/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.lang.reflect.Array;
import jp.ossc.nimbus.core.NimbusClassLoader;

class Utility {
    public static final String SYSTEM_PROPERTY_START = "${";
    public static final String SYSTEM_PROPERTY_END = "}";
    public static final String COMENT_START = "<!--";
    public static final String COMENT_END = "-->";
    private static final String ARRAY_CLASS_SUFFIX = "[]";

    Utility() {
    }

    public static String trim(String str) {
        int i;
        String result = str;
        int max = result.length();
        for (i = 0; i < max; ++i) {
            char c = result.charAt(i);
            if (Character.isWhitespace(c)) continue;
            result = result.substring(i);
            break;
        }
        i = result.length();
        while (--i >= 0) {
            char c = result.charAt(i);
            if (Character.isWhitespace(c)) continue;
            result = result.substring(0, i + 1);
            break;
        }
        return result;
    }

    public static String xmlComentOut(String str) {
        String result = str;
        int startIndex = result.indexOf(COMENT_START);
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf(COMENT_END);
        if (endIndex == -1 || startIndex > endIndex) {
            return result;
        }
        if ((result = result.substring(0, startIndex) + result.substring(endIndex + COMENT_END.length())).indexOf(COMENT_START) != -1) {
            return Utility.xmlComentOut(result);
        }
        return result;
    }

    public static String replaceSystemProperty(String str) {
        String result = str;
        int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf(SYSTEM_PROPERTY_END);
        if (endIndex == -1 || startIndex > endIndex) {
            return result;
        }
        String propStr = result.substring(startIndex + SYSTEM_PROPERTY_START.length(), endIndex);
        String prop = null;
        if (propStr != null && propStr.length() != 0) {
            prop = System.getProperty(propStr);
        }
        if (prop == null) {
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length()) + Utility.replaceSystemProperty(result.substring(endIndex + SYSTEM_PROPERTY_END.length()));
        }
        if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + SYSTEM_PROPERTY_END.length())).indexOf(SYSTEM_PROPERTY_START) != -1) {
            return Utility.replaceSystemProperty(result);
        }
        return result;
    }

    public static String unicodeConvert(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c;
            if ((c = str.charAt(i++)) == '\\') {
                if ((c = str.charAt(i++)) == 'u') {
                    int value = 0;
                    block12: for (int j = 0; j < 4; ++j) {
                        c = str.charAt(i++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + (c - 48);
                                continue block12;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + (c - 97);
                                continue block12;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + (c - 65);
                                continue block12;
                            }
                            default: {
                                throw new IllegalArgumentException("Failed to convert unicode : " + c);
                            }
                        }
                    }
                    buf.append((char)value);
                    continue;
                }
                switch (c) {
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                }
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static Class convertStringToClass(String typeStr) throws ClassNotFoundException {
        Class<Comparable<Byte>> type = null;
        if (typeStr != null) {
            if (Byte.TYPE.getName().equals(typeStr)) {
                type = Byte.TYPE;
            } else if (Character.TYPE.getName().equals(typeStr)) {
                type = Character.TYPE;
            } else if (Short.TYPE.getName().equals(typeStr)) {
                type = Short.TYPE;
            } else if (Integer.TYPE.getName().equals(typeStr)) {
                type = Integer.TYPE;
            } else if (Long.TYPE.getName().equals(typeStr)) {
                type = Long.TYPE;
            } else if (Float.TYPE.getName().equals(typeStr)) {
                type = Float.TYPE;
            } else if (Double.TYPE.getName().equals(typeStr)) {
                type = Double.TYPE;
            } else if (Boolean.TYPE.getName().equals(typeStr)) {
                type = Boolean.TYPE;
            } else if (typeStr.endsWith(ARRAY_CLASS_SUFFIX) && typeStr.length() > 2) {
                Class elementType = Utility.convertStringToClass(typeStr.substring(0, typeStr.length() - 2));
                type = Array.newInstance(elementType, 0).getClass();
            } else {
                type = Class.forName(typeStr, true, NimbusClassLoader.getInstance());
            }
        }
        return type;
    }
}

