/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.Utility;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNameRef;

public class ServiceNameRefEditor
extends PropertyEditorSupport
implements Serializable {
    private String managerName;

    public void setServiceManagerName(String name) {
        this.managerName = name;
    }

    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
            return;
        }
        String tmpText = Utility.replaceSystemProperty(text);
        int length = tmpText.length();
        if (tmpText == null || length <= 2) {
            throw new IllegalArgumentException(tmpText);
        }
        int index = tmpText.indexOf(61);
        if (index == -1 || index == 0 || index == length - 1) {
            throw new IllegalArgumentException(tmpText);
        }
        String refName = tmpText.substring(0, index);
        String realName = tmpText.substring(index + 1);
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(this.managerName);
        editor.setAsText(realName);
        ServiceName serviceName = (ServiceName)editor.getValue();
        this.setValue(new ServiceNameRef(refName, serviceName));
    }

    public String getAsText() {
        ServiceNameRef name = (ServiceNameRef)this.getValue();
        if (name == null) {
            return null;
        }
        return name.toString();
    }
}

