//-----------------------------------

#include <avr/io.h>
#include <avr/interrupt.h>
#include "akiled.h"

//*********************************

char linecnt;

#define LED_DDR     DDRD
#define LED_PORT    PORTD
#define LED_LATCH (1<<5)



extern unsigned char vram[488];//488


char led_flag=1;

void led_enable(char enableflag)
{
	led_flag = enableflag;
}

//-----------------
void led_init(void)
{
	int i;
	unsigned char *offset=(unsigned char *)0x7FFF; //dummy address

	linecnt=0;

	LED_PORT |= LED_LATCH ;
	LED_DDR |= LED_LATCH;

	for(i=0;i<16;i++)
	{
		*offset=0;
	}
	LED_PORT &= ~LED_LATCH ;
	LED_PORT |= LED_LATCH ;
}


//      chip1       chip2
//page1 [  0]-----  [ 61]-----
//page2 [122]-----  [183]-----
//page3 [244]-----  [305]-----
//page4 [366]-----  [427]-----



void led_disp(void)
{
	int col;
	int addr;
	unsigned char leddata;
	unsigned char mask;
	unsigned char *offset=(unsigned char *)0x7FFF; //sram address

	if(led_flag==0)return;	//disable

	for(col=0; col<16; col++)
	{
		leddata=0;
		//sI
		if(col==linecnt){
			leddata |= (1<<0);
		}

		//ʃrbg瑗M
		if(linecnt<8){
			addr = 15-col;
		}else{
			addr = (122+15)-col;
		}

		mask = 1 << (linecnt & 7);
		if(mask & vram[addr]){
			leddata|=(1<<1);
		}
		if(mask & vram[addr+16]){
			leddata|=(1<<2);
		}
		*offset=leddata;
	}

	LED_PORT &= ~LED_LATCH ;
	LED_PORT |= LED_LATCH ;

	linecnt++;
	if(linecnt >= 16)linecnt=0;
}

