/*----------------*/
/* middlefile.cpp */
/*----------------*/
#include"middlefile.h"
#include<stdio.h>
#include<stdlib.h>
#include<string.h>


int g_cnt_pointx, g_cnt_pointy, g_cnt_pointz;
double g_sum_x, g_sum_y, g_sum_z;
double g_average_x, g_average_y, g_average_z;

//fgets関数に、改行コードを弾く仕様を付加したもの
bool my_fgets(char *s, int leng, FILE * fp)
{
    if (fgets(s, leng, fp) == NULL)
        return false;
    char *c;
    if ((c = strrchr(s, '\n')) != NULL)
        *c = '\0';              //改行コードをはじく（その前までの文字列とする。）
    //↑純粋に、その行の文章を拾いたい意思から
    return true;

}






//****** 1行の文字列から、書式にしたがって座標情報を読み取る ******//
void cachedata(char *s, double x[4], double y[4], double z[4])
{
    char a[256];
    double dat[12];
    int i, j = 0, k = 0;
    //i文字目、を読み、それによって処理
    for (i = 0; true; i++)
      {
          //区切り文字 （スペースや改行など）ならそこまでの拾った文字列を数値に直す
          if (*(s + i) == ' ' || *(s + i) == '\0' || *(s + i) == '\n')
            {
                a[k] = '\0';
                dat[j] = atof(a);
                j++;
                k = 0;
          } else                //それ以外なら数字の途中とみて、拾っていく
            {
                a[k] = *(s + i);
                k++;
            }
          if (*(s + i) == '\0' || *(s + i) == '\n')     //行末に来ていたらさようなら
              break;
      }

    //下手に繰り返し文とかでやるより、却ってわかりやすいかと思いまして
    //座標情報の配列に、ひろったデータを入れています。
    x[0] = dat[0];
    g_sum_x += x[0];
    g_cnt_pointx++;
    y[0] = dat[1];
    g_sum_y += y[0];
    g_cnt_pointy++;
    z[0] = dat[2];
    g_sum_z += z[0];
    g_cnt_pointz++;
    x[1] = dat[3];
    g_sum_x += x[1];
    g_cnt_pointx++;
    y[1] = dat[4];
    g_sum_y += y[1];
    g_cnt_pointy++;
    z[1] = dat[5];
    g_sum_z += z[1];
    g_cnt_pointz++;
    x[2] = dat[6];
    g_sum_x += x[2];
    g_cnt_pointx++;
    y[2] = dat[7];
    g_sum_y += y[2];
    g_cnt_pointy++;
    z[2] = dat[8];
    g_sum_z += z[2];
    g_cnt_pointz++;
    x[3] = dat[9];
    g_sum_x += x[3];
    g_cnt_pointx++;
    y[3] = dat[10];
    g_sum_y += y[3];
    g_cnt_pointy++;
    z[3] = dat[11];
    g_sum_z += z[3];
    g_cnt_pointz++;
}






//****** 中間ファイルを読み込んで処理する関数です ******//
//このファイルの、ここから上の関数は、すべてこの関数のために。
bool read_datfile(int N, FACE_CORNER fase[], char filename[], double average[])
{

    g_cnt_pointx = 0, g_cnt_pointy = 0, g_cnt_pointz = 0;
    g_sum_x = 0.0, g_sum_y = 0.0, g_sum_z = 0.0;
    g_average_x = 0.0, g_average_y = 0.0, g_average_z = 0.0;

    FILE *fp = fopen(filename, "r");
    int j;
    double x[4], y[4], z[4];
    int corner_n;
    if (fp == NULL)             //エラーメッセージのとおり。中間ファイルが何故か開けないとき
      {
          printf("中間ファイルが読み込めません\n");
          return false;
      }
    char str[512];

    for (int i = 0; fgets(str, sizeof(str), fp) != NULL; i++)   //何角形か書いた行を読んでいく
      {
          if (strncmp("4", str, 1) == 0)        //4角形だと。
            {
                corner_n = 4;
          } else                //それ以外なら三角形
              corner_n = 3;


          if (corner_n == 4)    //四角形の時の座標拾い
            {
                fgets(str, sizeof(str), fp);    //座標の行を読み
                cachedata(str, x, y, z);        //座標のデータをそこから拾う
                fase[i].corners = 4;    //何角形かを入れて
                for (j = 0; j < 4; j++) //入力値を構造体に入れる
                  {
                      fase[i].x[j] = x[j];
                      fase[i].y[j] = y[j];
                      fase[i].z[j] = z[j];
                  }
            }
          //一応、3角形で構成されたものも可能な様に作ることも出きるように、中間ファイルの文法を組んでいますが
          //実際に実装の予定は、今のところありません。
          else if (corner_n == 3)       //三角形も四角形と同様
                  //三角形の機能はないですし、この部分は残骸ということになります。
            {
                fgets(str, sizeof(str), fp);    //座標の行を読み
                cachedata(str, x, y, z);        //座標のデータをそこから拾う
                fase[i].corners = 3;    //何角形かを入れて
                for (j = 0; j < 3; j++) //入力値を構造体に入れる
                  {
                      fase[i].x[j] = x[j];
                      fase[i].y[j] = y[j];
                      fase[i].z[j] = z[j];
                  }
            }

      }

    fclose(fp);
    average[0] = g_average_x = g_sum_x / g_cnt_pointx;
    average[1] = g_average_y = g_sum_y / g_cnt_pointy;
    average[2] = g_average_z = g_sum_z / g_cnt_pointz;
}
