/* -------- */
/* main.cpp */
/* -------- */
#include <GL/glut.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <time.h>
#include "./dxf2dat.h"          //DXFファイルを中間ファイルに変換する関係
#include "./middlefile.h"       //中間ファイルから座標情報を読み取る関係
#include "./delta.h"
#include "bitmap.h"
#include "conffile.h"
#define DELTA_MIDDLEFILENAME "delta.dat"        //最大変形の差分が入った中間ファイルの名前
#define REDRAW_TIME (1.0/12.0)       //12 fps
#define PI 3.141592654

#define DRAW_MODE_FUNC glOrtho(-1.2, 1.2, -1.2, 1.2, 0.01, 100) //同じ関数を同じ状態で呼び出さなければならないのでこんな変なことしてます。（ミス防止）読みづらいですね。

conffile conf;

int g_window_width, g_window_height;
double g_starttime;

double shoki_kaitenkaku[3];     //x,y,zの3つ
double g_bairitu;               //拡大縮小する倍率
double g_buttaisize;
int g_FaceN;                    //全面数
double g_Multipie, g_passtime;
FACE_CORNER *g_faces;           //原型の面の座標情報
FACE_CORNER *g_DeltaFaces;      //原型と最大変形との差分のデータ

//図形を回転して見る時の、回転角；（各軸に対して）
GLfloat theta_x;
GLfloat theta_y;
GLfloat theta_z;

//図形を移動して見るときの、移動量;(各軸方向に対して)
GLfloat g_idou_x = 0.0;
GLfloat g_idou_y = 0.0;
GLfloat g_idou_z = 0.0;

double g_nowtime = 0.0;
double g_shuki;

//****** 時間毎に呼び出される関数 *******//
//アニメーションで、変形を表示するために利用しています。
void timer(int value)
{
    g_nowtime += REDRAW_TIME;
    if (conf.avioutput() == true)
      {
          if (conf.avioutputtime("start") < g_nowtime
              && g_nowtime < conf.avioutputtime("end"))
          {
              printf("%lf %lf %lf\n"
                ,conf.avioutputtime("start")
                ,g_nowtime
                ,conf.avioutputtime("end"));

              capture_screen(g_window_width, g_window_height);  //**画面キャプチャ
          }
      }
    glutTimerFunc((double) REDRAW_TIME*1000, timer, 1);
    g_passtime = fmod((double) g_passtime + REDRAW_TIME, conf.cycle());
//    g_Multipie = sin((g_passtime / conf.cycle()) * 2 * PI);  //変形させる
    g_Multipie = sin(g_passtime * (2 * PI/conf.cycle()));  //変形させる
    glutPostRedisplay();
}


void Draw(int i,GLfloat *color,GLenum mode)
{
    double x,y,z;
    int j;
    glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, color);
    glPolygonMode(GL_FRONT_AND_BACK, mode);
    glBegin(GL_POLYGON);    //その面を書き始めて
    for (j = 0; j < 4; j++)
      {
           //座標を設定
           //式 : [原形での座標]-[最大変形時との差分]*[Sin関数で得た時間毎の変位倍率]
           x = g_faces[i].x[j] - g_DeltaFaces[i].x[j] * g_Multipie;
           y = g_faces[i].y[j] - g_DeltaFaces[i].y[j] * g_Multipie;
           z = g_faces[i].z[j] - g_DeltaFaces[i].z[j] * g_Multipie;
           glVertex3d(x, y, z);      //実際に書き込み
       }

     glEnd();
}

//****** 再描画関数 ******//
static void displayCallback(void)
{
    int i, j, k;
    double x, y, z;
    GLfloat green[] = { 0.0, 1.0, 0.0, 1.0 };
    GLfloat black[] = { 0.0, 0.0, 0.0, 1.0 };
    GLfloat white[] = { 1.0, 1.0, 1.0, 1.0 };
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glPushMatrix();

    glClearColor(black[0],black[1],black[2],black[3]);
    glRotatef(theta_z, 0.0, 0.0, 1.0);  //i-o
    glRotatef(theta_y, 0.0, 1.0, 0.0);  //j-k
    glRotatef(theta_x, 1.0, 0.0, 0.0);  //h-g;
    //glTranslatef(g_idou_x, g_idou_y, g_idou_z);
    gluLookAt(g_idou_x, g_idou_y, g_idou_z + 5.0, g_idou_x, g_idou_y, g_idou_z,
              0.0, 1.0, 0.0);

    // 各面を描画する //
    //各面に対してのループ
    for (i = 0; i < g_FaceN; i++)
      {
          Draw(i,green,GL_LINE);
          Draw(i,black,GL_FILL);
      }

    glPopMatrix();
    glutSwapBuffers();
 //   glDisable(GL_DEPTH_TEST);
}

static void reshapeCallback(int width, int height)
{
    glViewport(0, 0, width, height);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    DRAW_MODE_FUNC;             //描画の空間（def:直交座標系）を設定。#define参照
    glMatrixMode(GL_MODELVIEW);
}

static void keyboardCallback(unsigned char key, int x, int y)
{
    switch (key)                //キーボード入力での操作
      {
      case 'n':
          glScalef(1 / 1.05f, 1 / 1.05f, 1 / 1.05f);
          break;
      case 'p':
          glScalef(1.05f, 1.05f, 1.05f);
          break;
      case 'q':                //終了
          exit(EXIT_SUCCESS);
          break;
      case 'e':                //移動
          g_idou_z += 0.100;
          printf("positiond : %lf %lf %lf\n",g_idou_x,g_idou_y,g_idou_z);
          glutPostRedisplay();
          break;
      case 'w':                //移動
          g_idou_z -= 0.100;
          printf("positiond : %lf %lf %lf\n",g_idou_x,g_idou_y,g_idou_z);
          glutPostRedisplay();
          break;
      case 'g':                //移動
          g_idou_x -= 0.100;
          printf("positiond : %lf %lf %lf\n",g_idou_x,g_idou_y,g_idou_z);
          glutPostRedisplay();
          break;
      case 's':                //移動
          g_idou_x += 0.100;
          printf("positiond : %lf %lf %lf\n",g_idou_x,g_idou_y,g_idou_z);
          glutPostRedisplay();
          break;
      case 'f':                //移動
          g_idou_y += 0.100;
          printf("positiond : %lf %lf %lf\n",g_idou_x,g_idou_y,g_idou_z);
          glutPostRedisplay();
          break;
      case 'd':                //移動
          g_idou_y -= 0.100;
          printf("positiond : %lf %lf %lf\n",g_idou_x,g_idou_y,g_idou_z);
          glutPostRedisplay();
          break;
      case 'i':                //回転
          theta_z = fmod(theta_z + 2.5, 360.0);
          printf("angle : %lf %lf %lf\n",theta_x,theta_y,theta_z);
          glutPostRedisplay();
          break;
      case 'o':                //回転
          theta_z = fmod(theta_z - 2.5, 360.0);
          printf("angle : %lf %lf %lf\n",theta_x,theta_y,theta_z);
          glutPostRedisplay();
          break;
      case 'j':                //回転
          theta_y = fmod(theta_y + 2.5, 360.0);
          printf("angle : %lf %lf %lf\n",theta_x,theta_y,theta_z);
          glutPostRedisplay();
          break;
      case 'k':                //回転
          theta_y = fmod(theta_y - 2.5, 360.0);
          printf("angle : %lf %lf %lf\n",theta_x,theta_y,theta_z);
          glutPostRedisplay();
          break;
      case 'h':                //回転
          theta_x = fmod(theta_x - 2.5, 360.0);
          printf("angle : %lf %lf %lf\n",theta_x,theta_y,theta_z);
          glutPostRedisplay();
          break;
      case 'l':                //回転
          theta_x = fmod(theta_x + 2.5, 360.0);
          printf("angle : %lf %lf %lf\n",theta_x,theta_y,theta_z);
          glutPostRedisplay();
          break;
      case 'R':
          glutPostRedisplay();
          break;
      default:
          break;
      }
}

static void initGL(void)
{
    GLfloat light0Color[] = { 1.0, 1.0, 1.0, 1.0 };     //光源色
    GLfloat light0Ambient[] = { 1.0, 1.0, 1.0, 1.0 };   //光源モード
    GLfloat light0Position[] = { 0.0, 0.0, 0.0, 1.0 };  //光源位置
    int width, height;

    g_window_width = width = glutGet(GLUT_WINDOW_WIDTH);
    g_window_height = height = glutGet(GLUT_WINDOW_HEIGHT);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    DRAW_MODE_FUNC;             //直交座標系に設定
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    gluLookAt(0.0, 0.0, 3.5, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);     //視点位置の設定

    //光源を作成
    glLightfv(GL_LIGHT0, GL_DIFFUSE, light0Color);
    glLightfv(GL_LIGHT0, GL_SPECULAR, light0Color);
    glLightfv(GL_LIGHT0, GL_AMBIENT, light0Ambient);
    glLightfv(GL_LIGHT0, GL_POSITION, light0Position);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, light0Color);

    glClearColor(0.0, 0.0, 0.2, 1.0);

    //描画を有効化
    glShadeModel(GL_FLAT);      //シェーディングの設定
    glEnable(GL_LIGHT0);
    glEnable(GL_LIGHTING);      //シェーディングの有効化
    glEnable(GL_DEPTH_TEST);

    glScalef(g_bairitu, g_bairitu, g_bairitu);
}

int main(int argc, char *argv[])
{
    int i;
    //プロジェクトを開く
    //

    char *projectname = new char[strlen(argv[1]) + 1];
    strcpy(projectname, argv[1]);
    char *inputfile, *nextfile;
    conf.readfile(projectname);
    inputfile = conf.dxffilepath("nonallaxis");
    nextfile = conf.dxffilepath("allaxis");
    g_shuki = conf.cycle();
    double bairitu = conf.deltap();
    theta_x = conf.angle("x");
    theta_y = conf.angle("y");
    theta_z = conf.angle("z");
    g_bairitu = conf.scale();
    g_idou_x = conf.positiond("x");
    g_idou_y = conf.positiond("y");
    g_idou_z = conf.positiond("z");
    g_passtime = 0.0;
    //* dxfファイル読み込み *//
    //変形前のdxfファイル
    g_FaceN = dxf2dat(inputfile, "nfem3ap_middlefile.dat");     //中間ファイルの生成
    g_faces = new FACE_CORNER[g_FaceN]; //元図形の座標データを入れる領域作成
    double average[3];          //[0]:x [1]:y [2]:z 各座標軸の平均値
    read_datfile(g_FaceN, g_faces, "nfem3ap_middlefile.dat", average);  //元図形の座標データ読み込み
    if (g_idou_x == (double) NULL)
        g_idou_x = average[0];
    if (g_idou_y == (double) NULL)
        g_idou_y = average[1];
    if (g_idou_z == (double) NULL)
        g_idou_z = average[2]-1.2;
    int j;
    //初期起動時に表示されている真ん中の所を原点に設定する
    for (i = 0; i < g_FaceN; i++)
      {
          for (j = 0; j < 4; j++)
            {
                g_faces[i].x[j] -= g_idou_x;
                g_faces[i].y[j] -= g_idou_y;
                g_faces[i].z[j] -= g_idou_z;
            }
      }
    g_idou_x = 0;
    g_idou_y = 0;
    g_idou_z = 0;
    makedelta(inputfile, nextfile, "delta.dxf");
    dxf2dat("delta.dxf", DELTA_MIDDLEFILENAME);

    g_DeltaFaces = new FACE_CORNER[g_FaceN];
    double gomi_date[3];
    read_datfile(g_FaceN, g_DeltaFaces, DELTA_MIDDLEFILENAME, gomi_date);       //前記差分の読み込み

    for (j = 0; j < g_FaceN; j++)
      {
          for (i = 0; i < 4; i++)
            {
                g_DeltaFaces[j].x[i] *= bairitu;
                g_DeltaFaces[j].y[i] *= bairitu;
                g_DeltaFaces[j].z[i] *= bairitu;
            }
      }


    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);

    glutCreateWindow(projectname);
    glutTimerFunc((int) REDRAW_TIME*1000, timer, 1);
    glutDisplayFunc(displayCallback);
    glutKeyboardFunc(keyboardCallback);
    glutReshapeFunc(reshapeCallback);

    g_starttime = clock();
    initGL();
    glutMainLoop();

    delete[]g_faces;
    delete[]g_DeltaFaces;
    delete[]projectname;
    return EXIT_SUCCESS;
}
