/* xfce4-newsreader-plugin - A lightweight RSS/Atom news feed reader on xfce4-panel
 * 
 * Copyright 2005 mueki <mueki@users.sourceforge.jp>
 * Written for newsreader.
 *
 * config_gui_callbacks.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "config_gui_callbacks.h"

void
remove_clicked(GtkButton* wBtnRemove, newsreader_t* newsreader)
{
	GtkTreeView* view;
	GtkTreeModel* model;
	GtkTreeIter iter;
	GtkTreeSelection *selection;
	GtkEntry* entTitle;
	GtkEntry* entURL;
	GtkSpinButton* spnUntil;
	
	view = (GtkTreeView*)newsreader->oGUI.wTrFeedList;
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	if(!gtk_tree_selection_get_selected(selection, &model, &iter))
		return;

	gtk_list_store_remove(GTK_LIST_STORE(model), &iter);

	entTitle = (GtkEntry*)newsreader->oGUI.wEntFeedTitle;
	entURL = (GtkEntry*)newsreader->oGUI.wEntFeedURL;
	spnUntil = (GtkSpinButton*)newsreader->oGUI.wSpnUntil;

	gtk_entry_set_text(entTitle, "");
	gtk_entry_set_text (entURL, "");
	gtk_spin_button_set_value(spnUntil, 0);

	gtk_widget_set_sensitive(newsreader->oGUI.wBtnListApply, FALSE);
	gtk_widget_set_sensitive(newsreader->oGUI.wBtnListRemove, FALSE);

	return;
}

void
add_clicked(GtkButton* wBtnRemove, newsreader_t* newsreader)
{
	GtkTreeView* view;
	GtkTreeModel* model;
	GtkTreeIter iter;
	GtkEntry* entTitle;
	GtkEntry* entURL;
	GtkSpinButton* spnUntil;
	gchar* title;
	gchar* url;
	gint iUntil;

	view = (GtkTreeView*)newsreader->oGUI.wTrFeedList;
	entTitle = (GtkEntry*)newsreader->oGUI.wEntFeedTitle;
	entURL = (GtkEntry*)newsreader->oGUI.wEntFeedURL;
	spnUntil = (GtkSpinButton*)newsreader->oGUI.wSpnUntil;
	
	model = gtk_tree_view_get_model(GTK_TREE_VIEW(view));	

	title = (gchar*)gtk_entry_get_text(entTitle);
	url = (gchar*)gtk_entry_get_text(entURL);
	iUntil = (gint)gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(newsreader->oGUI.wSpnUntil));

	gtk_list_store_prepend (GTK_LIST_STORE(model), &iter);
	gtk_list_store_set (GTK_LIST_STORE(model), &iter,
						COL_TOGGLE, TRUE,
						COL_TITLE, title,
						COL_URL, url,
						COL_UNTIL, iUntil,
						-1);

	gtk_entry_set_text(entTitle, "");
	gtk_entry_set_text (entURL, "");
	gtk_spin_button_set_value(spnUntil, 0);

	gtk_widget_set_sensitive(newsreader->oGUI.wBtnListApply, FALSE);
	gtk_widget_set_sensitive(newsreader->oGUI.wBtnListRemove, FALSE);

	return;
}

void
listUp_clicked(GtkButton* wBtnListUp, newsreader_t* newsreader)
{
	GtkTreeView* view;
	GtkTreeModel* model;
	GtkTreeIter preIter, curIter;
	GtkTreeSelection *selection;
	GtkTreePath* path;
	
	view = (GtkTreeView*)newsreader->oGUI.wTrFeedList;
	
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));

	if (gtk_tree_selection_get_selected(selection, &model, &curIter)){
		path = gtk_tree_model_get_path(model, &curIter);
		g_return_if_fail (path != NULL);
		gtk_tree_path_prev (path);
		gtk_tree_model_get_iter (model, &preIter, path);
		gtk_tree_path_free (path);
		if(gtk_list_store_iter_is_valid(GTK_LIST_STORE(model), &preIter)){
			gtk_list_store_swap(GTK_LIST_STORE(model), &curIter, &preIter);
		}
	}
	else{
		g_print ("no row selected.\n");
	}	
}
			   
void
listDown_clicked(GtkButton* wBtnListUp, newsreader_t* newsreader)
{
	GtkTreeView* view;
	GtkTreeModel* model;
	GtkTreeIter nextIter, curIter;
	GtkTreeSelection *selection;
	GtkTreePath* path;

	view = (GtkTreeView*)newsreader->oGUI.wTrFeedList;
	
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));

	if (gtk_tree_selection_get_selected(selection, &model, &curIter)){
		path = gtk_tree_model_get_path(model, &curIter);
		g_return_if_fail (path != NULL);
		gtk_tree_path_next (path);
		gtk_tree_model_get_iter (model, &nextIter, path);
		gtk_tree_path_free (path);
		if(gtk_list_store_iter_is_valid(GTK_LIST_STORE(model), &nextIter)){
			gtk_list_store_swap(GTK_LIST_STORE(model), &curIter, &nextIter);
		}
	}
	else{
		g_print ("no row selected.\n");
	}	
	
}

void
row_toggled (GtkCellRendererToggle *cell,
			  gchar                 *path_str,
			  gpointer               data)
{
	GtkTreeModel *model = (GtkTreeModel *) data;
	GtkTreeIter iter;
	GtkTreePath *path = gtk_tree_path_new_from_string (path_str);
	gboolean owen;

	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (model, &iter, COL_TOGGLE, &owen, -1);

	owen = !owen;
	gtk_list_store_set (GTK_LIST_STORE (model), &iter, COL_TOGGLE, owen, -1);

	gtk_tree_path_free (path);

	return;
}

/* feedꥹȤι˸ƽФ */
gboolean
view_selection_func (GtkTreeSelection *selection,
					 GtkTreeModel     *model,
					 GtkTreePath      *path,
					 gboolean          path_currently_selected,
					 gpointer          userdata)
{
	GtkTreeIter iter;
	GtkEntry* entTitle, *entURL;
	GtkSpinButton* spnUntil;

	newsreader_t *newsreader = (newsreader_t*) userdata;

    if (gtk_tree_model_get_iter(model, &iter, path)){
		gchar *title;
		gchar *url;
		gint iUntil;

		gtk_tree_model_get(model, &iter, COL_TITLE, &title, -1);
		gtk_tree_model_get(model, &iter, COL_URL, &url, -1);
		gtk_tree_model_get(model, &iter, COL_UNTIL, &iUntil, -1);

		entTitle = (GtkEntry*)newsreader->oGUI.wEntFeedTitle;		
		entURL = (GtkEntry*)newsreader->oGUI.wEntFeedURL;
		spnUntil = (GtkSpinButton*)newsreader->oGUI.wSpnUntil;

		if (!path_currently_selected){
			gtk_entry_set_text(entTitle,title);
			gtk_entry_set_text(entURL,url);
			gtk_spin_button_set_value(spnUntil, iUntil);

			gtk_widget_set_sensitive(newsreader->oGUI.wBtnListRemove, TRUE);
			gtk_widget_set_sensitive(newsreader->oGUI.wBtnListApply, FALSE);

		}
		else{
			gtk_entry_set_text(entTitle,"");
			gtk_entry_set_text(entURL,"");
			gtk_spin_button_set_value(spnUntil, 0);
		}

		g_free(title);
		g_free(url);
	}

    return TRUE; /* allow selection state to change */

}

void
apply_clicked(GtkButton* wBtnApply, newsreader_t* newsreader)
{
	GtkTreeView* view;
	GtkTreeModel* model;
	GtkTreeIter iter;
	GtkTreeSelection *selection;
	GtkEntry* entTitle;
	GtkEntry* entURL;
	GtkSpinButton* spnUntil;
	gchar* title;
	gchar* url;
	gint iUntil;

	view = (GtkTreeView*)newsreader->oGUI.wTrFeedList;
	entTitle = (GtkEntry*)newsreader->oGUI.wEntFeedTitle;
	entURL = (GtkEntry*)newsreader->oGUI.wEntFeedURL;
	spnUntil = (GtkSpinButton*)newsreader->oGUI.wSpnUntil;

	title = (gchar*)gtk_entry_get_text(entTitle);
	url = (gchar*)gtk_entry_get_text(entURL);
	iUntil = (gint)gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(newsreader->oGUI.wSpnUntil));

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));

	if (gtk_tree_selection_get_selected(selection, &model, &iter)){
		gtk_list_store_set (GTK_LIST_STORE( model ), &iter, COL_TITLE, title, -1);
		gtk_list_store_set (GTK_LIST_STORE( model ), &iter, COL_URL, url, -1);
		gtk_list_store_set (GTK_LIST_STORE( model ), &iter, COL_UNTIL, iUntil, -1);
		gtk_widget_set_sensitive(newsreader->oGUI.wBtnListApply, FALSE);
	}
	else{
		g_message("no row selected.\n");
	}	
	
}

void 
item_changed(GtkWidget* wWidget, newsreader_t* newsreader)
{

	GtkTreeView* view;
	GtkTreeModel* model;
	GtkTreeIter curIter;
	GtkTreeSelection *selection;

	view = (GtkTreeView*)newsreader->oGUI.wTrFeedList;
	
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));

	if (gtk_tree_selection_get_selected(selection, &model, &curIter)){
		gtk_widget_set_sensitive(newsreader->oGUI.wBtnListApply, TRUE);
	}
	
	return;
}
