package jp.co.newral.workmgr.web.action;

import jp.co.newral.workmgr.common.bean.UsrVO;
import jp.co.newral.workmgr.service.bean.UsrBean;
import jp.co.newral.workmgr.service.blogic.MgrStaffTimeChangeSelectBLogic;
import jp.co.newral.workmgr.service.blogic.MgrStaffTimeListBLogic;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
* Ј̏oގЎԕύXANVB
*
* oގЎԕύXprWlXWbNĂсAЈԕύXʂ֑Jڂ
*/
public class MgrStaffTimeChangeSelectAction extends AbstractBLogicAction<UsrBean> {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(AbstractBLogicAction.class);
    
    /**
     * oЎԂێĂ
     * (̓G[ƃf[^)
     * 
     */
    private static String staticInHm = null;
    
    /**
     * ގЎԂێĂ
     * (̓G[ƃf[^)
     * 
     */
    private static String staticOutHm = null;
    

    /**
     * srWlXWbNNXB
     */
    private MgrStaffTimeChangeSelectBLogic mgrStaffTimeChangeSelectBLogic = null;

    /**
     * rWlXWbNԋpB
     *
     * @return ێrWlXWbN
     */
    public MgrStaffTimeChangeSelectBLogic getMgrStaffTimeChangeSelectBLogic() {
        return mgrStaffTimeChangeSelectBLogic;
    }

    /**
     * rWlXWbNݒ肷B
     *
     * @param mgrStaffTimeChangeSelectBLogic rWlXWbN
     */
    public void setMgrStaffTimeChangeSelectBLogic(MgrStaffTimeChangeSelectBLogic mgrStaffTimeChangeSelectBLogic) {
        this.mgrStaffTimeChangeSelectBLogic = mgrStaffTimeChangeSelectBLogic;
    }

    
    
    /**
     * Ԃ؂蕪
     *  "HH;MM"`̎l "HH"̂ݎ擾
     *
     * @param  Time      : 擾
     * @return InTimeTop : ؂蕪("HH" )
     */    
    private String getTimeTop(String Time){
    	
    	String InTimeTop;
    	
    	//r
    	if(Time.equals("-")){
    		// 󕶎("")̑
    		InTimeTop = "";
    	}else{
    		//擪2̑("hh:mm"  "hh" ̑)
    		InTimeTop = Time.substring(0,2);
    	}
    	return InTimeTop;
    }

    /**
     * Ԃ؂蕪
     *  "HH;MM"`̎l "MM"̂ݎ擾
     *
     * @param  Time      : 擾
     * @return InTimeEnd : ؂蕪("MM" )
     */    
    private String getTimeEnd(String Time){
    	
    	String InTimeEnd;
    	
    	//r
    	if(Time.equals("-")){
    		// 󕶎("")̑
    		InTimeEnd = "";
    	}else{
    		//擪2̑("hh:mm"  "mm" ̑)
    		InTimeEnd = Time.substring(3,5);
    	}
    	return InTimeEnd;
    }

    
    /**
     * Flag̒̒lLongϊł邩̔`FbN
     * G[tO̒g𔻒肵ĕԋpB
     *
     * @return O   tOOFF  0
     *          O tOON   1
     */
    private Long TimeChangeCheckLong(Long Flag)  throws Exception {
    	
    	if( Flag == null || Flag.equals("") ) { 
    		// NULL or 󔒂̏ꍇ̏ 
    		return Long.valueOf(0);
    	} 

    	try{
    		long TimeFlag = Long.valueOf(Flag);
    		return TimeFlag;
    	}catch (NumberFormatException nfe){
    		return Long.valueOf(0);
    	}catch (Exception e){
    		throw e;
    	}
    }


    /**
     * oЎԂ̕ێE
     * G[    ێl(staticInHm)擾l֑̈
     * G[  擾l(inHm)ێ֑̈
     * 
     * @param  : oЎԂ̎擾l
     * @return : (HH:MM)̑
     */
    public String SetInTime(String inHm) {

    	if(inHm == null){
    		// ێĂl̑
    		inHm = staticInHm;
    	}else{
    		// Vlێ֑̈
    		staticInHm = inHm;
    	}
    	return inHm;
    }   
    
    /**
     * ގЎԂ̕ێE
     * G[    ێl(staticOutHm)擾l֑̈
     * G[  擾l(outHm)ێ֑̈
     * 
     * @param  : ގЎԂ̎擾l
     * @return : (HH:MM)̑
     */

    public String SetOutTime(String outHm) {

    	if(outHm == null){
    		// ێĂl̑
    		outHm = staticOutHm;
    	}else{
    		// Vlێ֑̈
    		staticOutHm = outHm;
    	}
    	return outHm;
    }   
    
    
    
    /**
     * rWlXWbNsAЈo^擾AԋpB
     *
     * @param  usrBean   : Јo^擾̂߂̕ϐێUsrBean
     * @return Result    : Јo^ێBLogicResult
     * @throws Exception : O
     */
    @Override
    public BLogicResult doExecuteBLogic(UsrBean usrBean)
        throws Exception {

    	log.debug("MgrStaffTimeChangeSelectAction IN!!");
    	
    	log.debug("selectListYmd = [" + usrBean.getSelectListYmd() + "]");
    	log.debug("inHm          = [" + usrBean.getInHm() + "]");
    	log.debug("outHm         = [" + usrBean.getOutHm() + "]");
    	log.debug("listViewDay   = [" + usrBean.getListViewDay() + "]");
    	
    	//IN쐬iiYYYYMMADDj iYYYYMMDD `ɕϊjj
    	String InOutYmd = String.format("%1$s%2$02d",usrBean.getSelectListYmd(), Integer.valueOf(usrBean.getListViewDay()));
    	usrBean.setInoutYmd(InOutYmd);
    	
    	//==================================================================//
    	// G[Ɩŏ𕪂                             //
    	// G[  ێĂoЎԁEގЎԂ̒l     //
    	// G[  VoЎԁEގЎԂ̒lێ֑̈ //
    	//==================================================================//
    	usrBean.setInHm(SetInTime(usrBean.getInHm()));
    	usrBean.setOutHm(SetOutTime(usrBean.getOutHm()));
    	    	
    	//oЎԁEގЎԂ؂蕪Ď擾("HH:MM"  "HH" , "MM" Ɛ؂蕪ĕԂĂ)
    	String ChangeInHourTime    = getTimeTop(usrBean.getInHm());
    	String ChangeInMinuteTime  = getTimeEnd(usrBean.getInHm());
    	String ChangeOutHourTime   = getTimeTop(usrBean.getOutHm());
    	String ChangeOutMinuteTime = getTimeEnd(usrBean.getOutHm());
    	
    	//؂蕪Ԃ̑
    	usrBean.setChangeInHourTime(ChangeInHourTime);
    	usrBean.setChangeInMinuteTime(ChangeInMinuteTime);
    	usrBean.setChangeOutHourTime(ChangeOutHourTime);
    	usrBean.setChangeOutMinuteTime(ChangeOutMinuteTime);
    	
    	//====================================================//
    	// G[bZ[WóEo͂̔                 //
    	// G[bZ[Wo͎    TimeInputErrorFlag = 1 //
    	// G[bZ[Wo͎  TimeInputErrorFlag = 0 //
    	//====================================================//
        Long TimeInputErrorFlag = usrBean.getTimeInputErrorFlag(); 
        usrBean.setTimeInputErrorFlag(TimeChangeCheckLong(TimeInputErrorFlag));
  	
    	//rWlXWbN̎sAʂ̎擾
        UsrBean usrBeanBuf = usrBean;

    	//BLogicResult̐Aʂ̐ݒ
        BLogicResult result = new BLogicResult();
                
        UsrVO uvo = usrBean.getUvo();
        result.setResultString("success");
        result.setResultObject(usrBeanBuf);

        //\郁bZ[W̐Aݒ
        BLogicMessages messages = new BLogicMessages();
        messages.add("mgr.message",
                new BLogicMessage("mgr.message", uvo.getStaffName()));
        result.setMessages(messages);
        
        
    	log.debug("selectListYmd = [" + usrBeanBuf.getSelectListYmd() + "]");
    	log.debug("inHm          = [" + usrBeanBuf.getInHm() + "]");
    	log.debug("outHm         = [" + usrBeanBuf.getOutHm() + "]");
    	log.debug("listViewDay   = [" + usrBeanBuf.getListViewDay() + "]");
    	log.debug("InoutYmd      = [" + usrBeanBuf.getInoutYmd() + "]");

        
        log.debug("MgrStaffTimeChangeSelectAction OUT!!");
        
        return result;
    }

  
}
