
package jp.co.newral.workmgr.service.blogic;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.DownloadFile;
import jp.co.newral.workmgr.common.bean.UsrVO;
import jp.co.newral.workmgr.service.bean.*;

import jp.ne.so_net.ga2.no_ji.jcom.excel8.*;
import jp.ne.so_net.ga2.no_ji.jcom.*;

import java.lang.Long;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.Integer;
import java.nio.channels.FileChannel;


import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

/**
 * ꗗ擾rWlXWbNB
 *
 * f[^x[Xʂɕ\錏݈̂ꗗ擾B
 * ܂Aꗗ̑S擾B
 *
 */
public class UsrTimeListDownloadBLogicImpl implements UsrTimeListDownloadBLogic{

	/**
	 * DAONXB
	 * B
	 */
	private QueryDAO dao = null;

	/**
	 * QueryDAOԋpB
	 *
	 * @return ێQueryDAO
	 */
	public QueryDAO getDao() {
		return dao;
	}

	/**
	 * QueryDAOݒ肷B
	 *
	 * @param dao QueryDAO
	 */
	public void setDao(QueryDAO dao) {
		this.dao = dao;
	}

	/**
	 * NǍ̓߂B
	 *
	 * @param dao QueryDAO
	 */
	private int num_of_day(int year, int month)
	{
		int num_days[] = {31,28,31,30,31,30,31,31,30,31,30,31};
		
		if((month==2) && (((year%400)==0) || (((year%100)!=0) && ((year%4)==0)))){
			return 29;
		}else{
			return num_days[month-1];
		}
	}
	
	/**
	 * p̗j{̗j߂B
	 *
	 * @param dao QueryDAO
	 */
	private String sarchWeek(int EngWeekVal)
	{
		String jpnWeekStr = null;
		switch (EngWeekVal) {
			case Calendar.SUNDAY: 		jpnWeekStr = "";
				break;
			case Calendar.MONDAY: 		jpnWeekStr = "";
				break;
			case Calendar.TUESDAY: 		jpnWeekStr = "";
				break;
			case Calendar.WEDNESDAY:	jpnWeekStr = "";
				break;
			case Calendar.THURSDAY: 	jpnWeekStr = "";
				break;
			case Calendar.FRIDAY: 		jpnWeekStr = "";
				break;
			case Calendar.SATURDAY: 	jpnWeekStr = "y";
				break;
		}
		return jpnWeekStr;
	}
	
	
	
	/**********************************************
	 * 											  *
	 * jexcel - xlst@C̏o͂s			  *
	 * 											  *
	 **********************************************/
	public BLogicResult jxlExecute(UsrBean usrBean) { 
		String thisyear = null;
		String thismonth = null;
		
		//Calendar擾
		Calendar date = Calendar.getInstance();
		
		//͂ꂽ[UID̎擾Ai[
		UsrVO uvo;
		uvo = usrBean.getUvo();
		UsrBean usrBeanBuf = new UsrBean();
		usrBeanBuf.setStaffId(uvo.getStaffId());
		
		/****   f[^x[Ẍׂ̔N߂   ****/
		//ݕ\Ă\̔Nsession瓾B
		String selectYm = usrBean.getSelectListYmd();
		
		//f[^i߂Ẳʂɗj́A݂̔N𓾂
		if(selectYm == null){
			thisyear = String.format("%1$tY", date);
			thismonth = String.format("%1$tm", date);
		}
		//f[^炻̔NAʂŉꂽ{^ɂăCNg/fNg
		else{
			//ĂlNƌɐ؂蕪
			int monthVal = Integer.valueOf(selectYm.substring(4));
			int yearVal = Integer.valueOf(selectYm.substring(0,4));
			
			//ύXꂽNAstringϐɓȂ
			thisyear = Integer.toString(yearVal);
			thismonth = String.format("%1$02d",monthVal);		
		}
		/************************************************/ 
		
		/****@f[^x[XANZX  ****/ 
		//DBp̔Ni[B
		usrBeanBuf.settimeListSelectYM('%'+ thisyear + thismonth +'%');
		//DBANZX
		UsrBean[] bean = dao.executeForObjectArray("selectTimeList", usrBeanBuf,UsrBean.class);
		/************************************/        
		
		
		/****@t@Cp  ****************/ 
		//encoding̐ݒ
		WorkbookSettings ws = new WorkbookSettings();
		ws.setLocale(new Locale("ja","JP"));
		ws.setEncoding("Windows-31J");
		ws.setGCDisabled(true); //System.gc() uKx[WRNVv̎sOFFɐݒ
		//VK쐬t@C̖O쐬   
		String fileStaffName = String.format("%1$02d",usrBeanBuf.getStaffId());
		String NewDLName = "Ζ\݃\tg" + thisyear.substring(2,4) + thismonth + fileStaffName + ".xls";
		
		//t@C̃pXw
		String FilePath = "webapps\\workmgr\\Ζ\";
		try {
			//BookɂABook쐬B
			Workbook workbook0 = Workbook.getWorkbook(
					new java.io.File(FilePath,"VBAInoutListBlank.xls"),ws);
			
			WritableWorkbook workbook = Workbook.createWorkbook(
					new java.io.File(FilePath,NewDLName),workbook0);
			/************************************/  
			
			/***********݊Jn**********/  
			//Sheetw
			WritableSheet sheet1 = workbook.getSheet("Sheet1"); 
			
			//N
			jxl.Cell cell1 = sheet1.getWritableCell(0,0);
			jxl.write.Number number1 = new jxl.write.Number(0,0,Integer.valueOf(thisyear));
			if ( cell1.getCellFormat() != null ) {
				number1.setCellFormat(cell1.getCellFormat());
			}
			if ( number1 != null ) {
				sheet1.addCell(number1);
			}
			
			//
			jxl.Cell cell2 = sheet1.getWritableCell(2,0);
			jxl.write.Number number2 = new jxl.write.Number(2,0,Integer.valueOf(thismonth));
			if ( cell2.getCellFormat() != null ) {
				number2.setCellFormat(cell2.getCellFormat());
			}
			if ( number2 != null ) {
				sheet1.addCell(number2);
			}
			
			//ID       	
			jxl.Cell cell3 = sheet1.getWritableCell(5,1);
			jxl.write.Number number3 = new jxl.write.Number(5,1,usrBeanBuf.getStaffId());
			if ( cell3.getCellFormat() != null ) {
				number3.setCellFormat(cell3.getCellFormat());
			}
			if ( number3 != null ) {
				sheet1.addCell(number3);
			} 
			
			//
			jxl.Cell cell4 = sheet1.getWritableCell(7,1);
			jxl.write.Label label4 = new jxl.write.Label(7,1,uvo.getStaffName());
			if ( cell4.getCellFormat() != null ) {
				label4.setCellFormat(cell4.getCellFormat());
			}
			if ( label4 != null ) {
				sheet1.addCell(label4);
			}
			
			//NA\錎̓߁A\̗񐔂ƂB      
			int row = num_of_day(Integer.valueOf(thisyear), Integer.valueOf(thismonth));	//\̍ڐ
			
			int daycount = 0;		//JE^[
			int datacount = 0;		//beañf[^JE^[
			String bufcheck ="";	//OutHm󔒂ǂ𒲂ׂׂ̕ϐ
			
			jxl.Cell 			cell;
			jxl.write.Number	number;
			jxl.write.Label 	label;
			
			//CalendartB[hɔNEEݒ肷B
			//1ڂ\1ŒB
			date.set(Integer.valueOf(thisyear),Integer.valueOf(thismonth)-1,1);    
			
			//CalendartB[hɐݒ肳ꂽŃA1jƂejɑΉ1`7̐l𓾂B
			//œ1ŒɂĂׁAYN1ij̗jɓB
			//JEgAbvĂAe̗j߂ĂB
			int weekCount = date.get(Calendar.DAY_OF_WEEK);		//jJE^[
			
			//dayCount̓[vB
			for(daycount=0 ; daycount<row ; daycount++){			
				//f[^p̔N쐬
				String sarchlistymd = String.format("%1$s%2$s%3$02d",thisyear,thismonth,daycount+1);
				
				////EEEȉbeaňn߂EEE////
				
				//ʂɕ\ti[
				cell = sheet1.getWritableCell(0,daycount+7);
				number = new jxl.write.Number(0,daycount+7,daycount+1);
				if ( cell.getCellFormat() != null ) {
					number.setCellFormat(cell.getCellFormat());
				}
				if ( number != null ) {
					sheet1.addCell(number);
				}
				//ʂɕ\ji[
				cell = sheet1.getWritableCell(1,daycount+7);
				label = new jxl.write.Label(1,daycount+7,sarchWeek(weekCount));
				if ( cell.getCellFormat() != null ) {
					label.setCellFormat(cell.getCellFormat());
				}
				if ( label != null ) {
					sheet1.addCell(label);
				}
				//beañf[^JE^[őɂȂĂ
				//DBĂf[^͑SdownLoadChartɊi[IĂ̂ŁAcׂ͂ăf[^B
				if(datacount >= bean.length){
					//Z󔒂ׁ̈ȀȂ
				}	        	
				//f[^p̔NDBĂNvĂ
				//downLoadChartɒli[AdatacountCNgBiDBf[^j
				else if(sarchlistymd.equals(bean[datacount].getInoutYmd()) == true){
					String inHmStr = bean[datacount].getInHm();
					
					//Ўi[
					cell = sheet1.getWritableCell(2,daycount+7);
					number = new jxl.write.Number(2,daycount+7,Integer.valueOf(inHmStr.substring(0,2)));
					if ( cell.getCellFormat() != null ) {
						number.setCellFormat(cell.getCellFormat());
					}
					if ( number != null ) {
						sheet1.addCell(number);
					}  
					//Еi[
					cell = sheet1.getWritableCell(3,daycount+7);
					number = new jxl.write.Number(3,daycount+7,Integer.valueOf(inHmStr.substring(2,4)));
					if ( cell.getCellFormat() != null ) {
						number.setCellFormat(cell.getCellFormat());
					}
					if ( number != null ) {
						sheet1.addCell(number);
					}
					
					//ЎԂ݂̂DBɓo^Ă鎞iގЏĂȂj
					//outf[^̕󔒂ɂ	
					if(bean[datacount].getOutHm() == null || bufcheck.equals(bean[datacount].getOutHm())){
						//Z󔒂ׁ̈ȀȂ
					}
					//ȊO̎͒ldownLoadChartɊi[B
					else{
						String OutHmStr = bean[datacount].getOutHm();
						
						//ގЎi[
						cell = sheet1.getWritableCell(4,daycount+7);
						number = new jxl.write.Number(4,daycount+7,Integer.valueOf(OutHmStr.substring(0,2)));
						if ( cell.getCellFormat() != null ) {
							number.setCellFormat(cell.getCellFormat());
						}
						if ( number != null ) {
							sheet1.addCell(number);
						}
							//ގЕi[
						cell = sheet1.getWritableCell(5,daycount+7);
						number = new jxl.write.Number(5,daycount+7,Integer.valueOf(OutHmStr.substring(2,4)));
						if ( cell.getCellFormat() != null ) {
							number.setCellFormat(cell.getCellFormat());
						}
						if ( number != null ) {
							sheet1.addCell(number);
						}
					}
					datacount++;
				}
				//f[^p̔NDBĂNvĂȂi̓͏oގЂsĂȂ
				//f[^݂Ȃ̂ŋ󔒂ɂ
				else{
					//Z󔒂ׁ̈ȀȂ
				}
				//weekCountCNgB
				//weekCountj߂ׂ͈̐͂͂ݏoA1ijĂ܂߂JEgB
				weekCount++;
				if(weekCount == 8) weekCount = 1;
			}
			workbook.write();
			workbook.close(); 
			workbook0.close();
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		/*********************************/ 
		
		//_E[h
		BLogicResult result = new BLogicResult();
		File file = new File(FilePath,NewDLName);
		
		DownloadFile downloadFile = new DownloadFile(file);
		result.setResultObject(downloadFile);
		return result;
	}
	
	/********************************
	 *                              *
	 *  Jcomgďo͂s      *
	 *                              *
	 ********************************/
	public BLogicResult jcomExecute(UsrBean usrBean) { 
		
		String thisyear = null;
		String thismonth = null;
		
		//Calendar擾
		Calendar date = Calendar.getInstance();
		
		//͂ꂽ[UID̎擾Ai[
		UsrVO uvo;
		uvo = usrBean.getUvo();
		UsrBean usrBeanBuf = new UsrBean();
		usrBeanBuf.setStaffId(uvo.getStaffId());
		
		/****   f[^x[Ẍׂ̔N߂   ****/
		//ݕ\Ă\̔Nsession瓾B
		String selectYm = usrBean.getSelectListYmd();
		
		//f[^i߂Ẳʂɗj́A݂̔N𓾂
		if(selectYm == null){
			thisyear = String.format("%1$tY", date);
			thismonth = String.format("%1$tm", date);
		}
		//f[^炻̔NAʂŉꂽ{^ɂăCNg/fNg
		else{
			//ĂlNƌɐ؂蕪
			int monthVal = Integer.valueOf(selectYm.substring(4));
			int yearVal = Integer.valueOf(selectYm.substring(0,4));
			
			//ύXꂽNAstringϐɓȂ
			thisyear = Integer.toString(yearVal);
			thismonth = String.format("%1$02d",monthVal);		
		}
		/************************************************/ 
		
		/****@f[^x[XANZX  ****/ 
		//DBp̔Ni[B
		usrBeanBuf.settimeListSelectYM('%'+ thisyear + thismonth +'%');
		//DBANZX
		UsrBean[] bean = dao.executeForObjectArray("selectTimeList", usrBeanBuf,UsrBean.class);
		/************************************/        
		
		/****@excelANZX  ****/ 
		//o͂Ζ\̖O쐬
		String outputFileName = "Ζ\"+ thisyear.substring(2) + thismonth + String.format("%1$03d",usrBeanBuf.getStaffId()) + ".xls";
		String outputFileNamePath = "C:\\Program Files\\Apache Software Foundation\\Tomcat 5.5\\webapps\\webapps\\workmgr\\Ζ\\\"+outputFileName;
		
		//filecopy
		try{
			FileChannel sourceChannel = new FileInputStream("C:\\Program Files\\Apache Software Foundation\\Tomcat 5.5\\webapps\\webapps\\workmgr\\Ζ\\\Ζ\blank.xls").getChannel();
			FileChannel destinationChannel = new FileOutputStream(outputFileNamePath).getChannel();
			
			sourceChannel.transferTo(0, sourceChannel.size(), destinationChannel);
			sourceChannel.close();
			destinationChannel.close();
		}
		catch(Exception e){
			e.printStackTrace();
		}
		
		ReleaseManager rm = new ReleaseManager();
		try {
			//javahome𒲂ׂ
			//System.out.println("java.home="+System.getProperty("java.home"));
			
			//EXCELN
			// łɗオĂƁAVEBhEŊJB
			ExcelApplication excel = new ExcelApplication(rm);
			excel.Visible(true);
			
			ExcelWorkbooks xlBooks = excel.Workbooks();
			ExcelWorkbook xlBook = xlBooks.Open(outputFileNamePath);
			
			//"݂̃fBNg̃t@CZɐݒ"
			ExcelWorksheets xlSheets = xlBook.Worksheets();
			ExcelWorksheet xlSheet = xlSheets.Item(1);
			ExcelRange xlRange = xlSheet.Cells();
			
			/***********݊Jn**********/  
			//NAAID
			xlRange.Item(2,5).Value((new Long(thismonth)));
			xlRange.Item(2,2).Value((new Long(thisyear)));
			xlRange.Item(3,21).Value((new Long(usrBeanBuf.getStaffId())));
			
			//N猎̓߂B      
			int row = num_of_day(Integer.valueOf(thisyear), Integer.valueOf(thismonth));	//\̍ڐ
			
			int daycount = 0;		//JE^[
			int datacount = 0;		//beañf[^JE^[
			String bufcheck ="";	//OutHm󔒂ǂ𒲂ׂׂ̕ϐ
			
			//dayCount[vB
			for(daycount=0 ; daycount<row ; daycount++){			
				//f[^p̔N쐬
				String sarchlistymd = String.format("%1$s%2$s%3$02d",thisyear,thismonth,daycount+1);
				
				//beañf[^JE^[őɂȂĂ
				//DBĂf[^͑SdownLoadChartɊi[IĂ̂ŁAcׂ͂ăf[^B
				if(datacount >= bean.length){
					//Z󔒂ׁ̈ȀȂ
				}
				//f[^p̔NDBĂNvĂ
				//xlRange.Itemɒli[AdatacountCNgBiDBf[^j
				else if(sarchlistymd.equals(bean[datacount].getInoutYmd()) == true){
					String inHmStr = bean[datacount].getInHm();
					
					//Ўi[
					xlRange.Item(daycount+8,7).Value(Integer.valueOf(inHmStr.substring(0,2)));
					//Еi[
					xlRange.Item(daycount+8,8).Value(Integer.valueOf(inHmStr.substring(2,4)));
					
					//ЎԂ݂̂DBɓo^Ă鎞iގЏĂȂj
					//outf[^̕󔒂ɂ	
					if(bean[datacount].getOutHm() == null || bufcheck.equals(bean[datacount].getOutHm())){
						//Z󔒂ׁ̈ȀȂ
					}
					//ȊO̎͒lxlRange.ItemɊi[B
					else{
						String OutHmStr = bean[datacount].getOutHm();
						
						//ގЎi[
						xlRange.Item(daycount+8,9).Value(Integer.valueOf(OutHmStr.substring(0,2)));
						//ގЕi[
						xlRange.Item(daycount+8,10).Value(Integer.valueOf(OutHmStr.substring(2,4)));
					}
					datacount++;
				}
				//f[^p̔NDBĂNvĂȂi̓͏oގЂsĂȂ
				//f[^݂Ȃ̂ŋ󔒂ɂ
				else{
					//Z󔒂ׁ̈ȀȂ
				}
			}
			
			//t@C̏㏑ۑ
			xlBook.Save();
			xlBook.Close(false,null,false);
			excel.Quit();
		}
		catch(Exception e) { 
			e.printStackTrace(); 
		}
		finally {
			rm.release();
		}
		
		//_E[h
		BLogicResult result = new BLogicResult();
		File file = new File(outputFileNamePath);
		
		DownloadFile downloadFile = new DownloadFile(file);
		result.setResultObject(downloadFile);
		return result;
	}
}
