
package jp.co.newral.workmgr.common.filter;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.newral.workmgr.common.bean.UsrVO;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.thin.AuthenticationController;

/**
 * F؃`FbN(OCς݃`FbN)sB
 *
 */
public class AuthController implements AuthenticationController {

	/** Oo(ύX) */
	private Log log = LogFactory.getLog(AuthController.class);	
	
    /**
     *  F؃`FbN(OCς݃`FbN)sȂpX񃊃Xg擾L[B
     */
    private static final String AUTHENTICATED_NOCHECK_PATH_PREFIX
                                 = "access.control.authenticated.escape.";

    /**
     *  F؃`FbN(OCς݃`FbN)sȂpX񃊃Xg擾L[B
     */
    private List<String> noCheckList = null;

    /**
     * NGXg̃pXɑ΂āAw肳ꂽHTTPZbV
     * F؍ς(OCς)ł邩ǂ𔻒肷B
     *
     * @param  pathInfo  pX
     * @param  req       HTTPNGXg
     *
     * @return true      F؂ɐ (OCς)
     *          false     F؂Ɏs (OCĂȂ)
     */
    public boolean isAuthenticated(String pathInfo, ServletRequest req) {

        //ZbVUVO擾B
        HttpSession session = ((HttpServletRequest) req).getSession();
        UsrVO uvo = (UsrVO) session.getAttribute("USER_VALUE_OBJECT");
//        log.debug("uvo = [" + uvo + "]");

        
        //------------------------------------------------//     
        // UVO StaffId o^Ăꍇtrueԋp //
        // (OCς)                                 //
        //------------------------------------------------//
        if ((uvo != null) && (uvo.getStaffId() != null) ) {
//            log.debug("return true");
        	return true;            
        }
        //UVOA܂UVOɓo^ĂIDnull̏ꍇfalseԋpB(OCĂȂ)
//        log.debug("return false");
        return false;
    }


    /**
     * pXF؃`FbN(OCς݃`FbN)Ώۂۂ肷B
     *
     * @param  req   ΏۂƂȂ [ServletRequest] CX^X 
     *
     * @return true  `FbNΏۂ̏ꍇ    
     *          false `FbNΏۂ̏ꍇ  
     */
    public boolean isCheckRequired(ServletRequest req) {

//    	log.debug("OCς݃`FbN");
    	//--------------------------------------------------------------//
    	// pX擾B                                       //
    	//   Eϐ[pathInfo] ɂ͎ɎgppX̕񂪓Ă  //
    	//      (: OCʂ  "/login.do" )                    // 
    	//--------------------------------------------------------------//
    	String pathInfo = RequestUtil.getPathInfo(req);
//        log.debug("pathInfo = [" + pathInfo + "]");

        if (noCheckList == null) {
        	noCheckList = new ArrayList<String>();
//            log.debug("noCheckList = [" + noCheckList + "]");

            for (int i = 1; ; i++) {
            	//-----------------------------------------------------------------------------//
            	// F؃`FbN(OCς݃`FbN)sȂ񃊃Xg擾                //
            	// (ApplicationResources.properties t@CŎŒ`pX1擾) //
            	//-----------------------------------------------------------------------------//
            	String path = PropertyUtil.getProperty(AUTHENTICATED_NOCHECK_PATH_PREFIX + i);
//                log.debug("path = [" + path + "]");
                                
                if (path == null) {
                    break;
                }
                //------------------------------------------------------------------//
                // 擾F؃`FbN(OCς݃`FbN)sȂ񃊃Xg //
                // 1o^                                                  //
                //------------------------------------------------------------------//
                noCheckList.add(path);
            }

        }
        
        for (String path : noCheckList) {
//        	log.debug("path        = [" + path + "]");
//        	log.debug("pathInfo    = [" + pathInfo + "]");
//        	log.debug("noCheckList = [" + noCheckList + "]");
            
        	//---------------------------------------------------//
        	// Rs[ł邩ǂ̔ (stringCopy()) //
        	//                                                   //
        	//     EɃRs[łꍇtrue ԋp     //
        	//     ERs[łȂꍇfalseԋp     //
        	//---------------------------------------------------//
        	String nextHedPath;
            if(stringCopy(pathInfo)){          	
            	//ɃRs[ł̂łnj
            	nextHedPath = pathInfo.substring(0,4);	
            }else{
            	//F؃`FbN(OCς݃`FbN)肪svȏꍇ false ԋp  ʏ֖̏߂
            	return false;
            }
            
            //-----------------------------------------------------------------------------------------------------------------//
            // pathInfo.startsWith(path)  pathInfo  path 񂪎w肳ꂽŎn܂邩ǂ𒲂ׂ                  //
            //                              vȂ true, svȂ false                                                    //
            //                                                                                                                 //
            //             E[pathInfo]   ɎgppX̕                                                           //
            //             E[path]       F؃`FbN(OCς݃`FbN)sȂ񃊃Xg(for[v1) //
            //-----------------------------------------------------------------------------------------------------------------//
//        	log.debug("pathInfo.startsWith(path) = [" + pathInfo.startsWith(path) + "]");
            if ( (pathInfo.startsWith(path)) ) {
            	
            	//--------------------------------------------------------------------------//
            	// "/mgr".equals(pathInfo)   "/mgr" [pathInfo] ̕rsNX //
            	//                             vȂ true, svȂ false              //
            	//                                                                          //
            	//            E[pathInfo]   ɎgppX̕                     //
            	//--------------------------------------------------------------------------//
            	if(!("/mgr".equals(nextHedPath)) || !("/usr".equals(nextHedPath))){
//                    log.debug("[/mgr].equals(pathInfo)      = [" + "/mgr".equals(pathInfo) + "]");
//                    log.debug("[/usr].equals(pathInfo)      = [" + "/usr".equals(pathInfo) + "]");
                	
                	//F؃`FbN(OCς݃`FbN)肪svȏꍇ false ԋp  ʏ֖̏߂
                    //return true;
                    return false;                	
                }
            	
            }
        }

        //F؃`FbN(OCς݃`FbN)肪Kvȏꍇ true ԋp  isAuthorizedNX 
        //return false;
        return true;
    }	

    
    /**
     * 𐳏ɃRs[ł邩ǂ̔
     * G[tO̒g𔻒肵ĕԋpB
     *
     * @return  I   true
     *           O   false
     *          
     */
    public boolean stringCopy(String pathInfo) {
    		try{
    			//pathInfo.substring(0,4)  ϐ[pathInfo]  w蕶Rs[NXB(̏ꍇ0ځ`4ڂRs[)
    			String nextHedPath = pathInfo.substring(0,4);
    			return true;
    		}catch (Exception ex){
    			return false;
    		}
    }

}
