/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * OɊւ郆[eBeBNXB
 * 
 * <p>
 *  ÕX^bNg[Xׂďo͂@\łB<br>
 *  Ő@\ɂẮAƂȂOX^bNg[X
 *  Ō܂ŕ\ȂB
 *  {@\́AƂȂOċAIɎ擾A
 *  X^bNg[XƂȂ镶擾Bgp͉L̂ƂłB
 *  
 *  <strong>ExceptionUtil̎gp</strong><br>
 *  <code><pre>
 *  EEE
 *  try {
 *     EEE
 *  } catch (Exception e) {
 *      // OX^bNg[XŌ܂ŏo
 *      log.error("error-message", ExceptionUtil.getStackTrace(e));
 *  }
 *  EEE
 * </pre></code>
 * </p>
 * 
 */
public final class ExceptionUtil {
    
    /**
     * ONX
     */
    private static Log log = LogFactory.getLog(ExceptionUtil.class);
    
    /**
     * ServletException̂݁AÕX^bNg[X̏قȂ̂ŁA
     * ʂ邽߂ɎgpB
     */
    private static final String SERVLET_EXCEPTION_NAME = 
        "javax.servlet.ServletException";
    
    /**
     * ServletExceptionۂɎgp郁\bhB
     * Servlet ̗ONꂽɂȂOԂ\bhłB
     */
    private static final String GET_ROOT_CAUSE = "getRootCause";
    
    /**
     * w肵ÕX^bNg[X擾B
     * 
     * <p>
     *  w肵ǑƂȂO擾ł΁A
     *  ̗ÕX^bNg[XċAIɎ擾B
     *  getRootCause()ŏÊɂĂServletException̂ݑΉB
     * </p>
     *
     * @param throwable O
     * @return ċAIɒHꂽX^bNg[X
     */
    public static String getStackTrace(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (throwable != null) {
            baos.reset();
            throwable.printStackTrace(new PrintStream(baos));
            sb.append(baos.toString());
            
            //throwableClassIuWFNgoB
            Class throwableClass = throwable.getClass();
            
            // ServletException Ȃ getRootCause g
            if (SERVLET_EXCEPTION_NAME.equals(throwableClass.getName())) {
                try {
                    //throwable = ((ServletException) throwable).getRootCause()
                    //ClassIuWFNg烁\bhw肵ĎsB
                    Method method = throwableClass.getMethod(GET_ROOT_CAUSE);
                    throwable = (Throwable) method.invoke(throwable);
                } catch (NoSuchMethodException e) {
                    //v郁\bhȂꍇ
                    log.error(e.getMessage());
                    throwable = null;
                } catch (IllegalAccessException e) {
                    //{ƂȂ郁\bhɃANZXłȂꍇ
                    log.error(e.getMessage());
                    throwable = null;
                } catch (InvocationTargetException e) {
                    //{ƂȂ郁\bhOX[ꍇ
                    log.error(e.getMessage());
                    throwable = null;
                }
                
            } else {
                throwable = throwable.getCause();  
            }
        }
        return sb.toString();
    }

}
