/*
  â̕\Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include "wakaDraw.h"


// Unicode ̒Ԃ
int WakaDraw::getUniLen(Uint16 line[]) {
  int length = 0;

  while (line[length] != 0x00) {
    ++length;
  }
  return length;
}


// Unicodeǂ
bool WakaDraw::isHiragana(Uint16 wch) {
  if ((wch == 0) || (wch == 0x3090) || (wch == 0x3091) || (wch > 0x30f6)) {
    return false;
  }
  return true;
}


// r̐
void WakaDraw::createRubiInfo(int ku_index,
			      Uint16 ku_kanji[], Uint16 ku_yomi[]) {

  int kanji_length = getUniLen(ku_kanji);
  int yomi_index = 0;
  int rubi_index = 0;

  for (int i = 0; i < kanji_length; ++i, ++yomi_index) {
    if (isHiragana(ku_kanji[i])) {
      continue;
    }
    rubiInfo_t rubi;
    rubi.ku = ku_index;
    rubi.start = i;

    // ̎o
    while ((i < kanji_length) && (!isHiragana(ku_kanji[i]))) {
      rubi.rubi[rubi_index++] = ku_yomi[yomi_index++];
      ++i;
    }
    rubi.end = i;

    // r̔o
    while ((ku_kanji[i] != ku_yomi[yomi_index]) ||
	   ((isHiragana(ku_kanji[i+1])) &&
	    (ku_kanji[i+1] != ku_yomi[yomi_index+1]))) {
      rubi.rubi[rubi_index++] = ku_yomi[yomi_index++];
    }
    rubi.rubi[rubi_index] = 0x00;
    rubi_index = 0;
    rubiInfo.push_back(rubi);
  }
}


// 񂾂ƏoT[tFX̕`
void WakaDraw::drawSubSurface(ScreenCtrl& scr, SDL_Rect *position,
			      FontCtrl& ttf, Uint16 line[], int percentage) {
  int alpha[] = { 0, 0, 0,
		  0, 0, 0, 0, 0,
		  1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
		  15, 15, 15, 15, 15,
		  15, 15, 15, };
  int length = getUniLen(line);
  int index = percentage % 20 + (7 - length);

  // T[tFX̍쐬A`
  SDL_Rect pos = *position;
  Uint16 moji[] = { 0x00, 0x00 };
  for (int i = 0; i < length; ++i) {
    moji[0] = line[i];
    SDL_Surface *wch = ttf.createSurface(moji, TYPE_FS, BLACK);
    SDL_SetAlpha(wch, SDL_SRCALPHA,
		 abs(SDL_ALPHA_OPAQUE * alpha[index + (length-i)] / 15));
    scr.blitSurface(wch, NULL, scr.screen(), &pos);
    SDL_FreeSurface(wch);
    pos.x += wch->w;
  }
}


// r̕`
void WakaDraw::drawRubi(ScreenCtrl& scr, SDL_Rect *position, FontCtrl& ttf,
			int percentage) {
  // `悪xĂA\
  if (rubiInfo.size() <= rubiInfo_index) {
    return;
  }
  rubiInfo_t *ri = &rubiInfo[rubiInfo_index];
  int ku_index = percentage / 20;
  int kanji_length = getUniLen(wakaResource->kanji[ku_index]);
  int wch_index = kanji_length * (percentage % 20) / 19;

  // r̕\^C~O炷
  if ((ri->ku > ku_index) || (ri->end > wch_index +0)) {
    return;
  }

  // `揈
  int rubi_length = getUniLen(ri->rubi);
  int spaceWidth = (TYPE_FS * (ri->end - ri->start)) / rubi_length;
  spaceWidth = (spaceWidth < RUBI_FS) ? RUBI_FS : spaceWidth;
  
  SDL_Rect base;
  base.w = (spaceWidth * (rubi_length - 1)) + RUBI_FS;
  base.h = RUBI_FS;
  base.y = position->y - RUBI_FS;
  base.x = position->x + TYPE_FS * (ri->start + ri->end)/2;

  SDL_Rect pos;
  pos.w = RUBI_FS;
  pos.h = RUBI_FS;
  Uint16 moji[2] = { 0x00, 0x00 };
  for (int i = 0; i < rubi_length; ++i) {
    moji[0] = ri->rubi[i];
    pos.x = base.x - base.w/2 + spaceWidth * i;
    pos.y = base.y;
    SDL_Surface *wch = ttf.createSurface(moji, RUBI_FS, BLACK);
    scr.blitSurface(wch, NULL, scr.screen(), &pos);
    SDL_FreeSurface(wch);
  }
  ++rubiInfo_index;
  
  return;
}


// ̕\w肵ẴT[tFX쐬
// !!! ͂T[tFX͍ĂȂ
SDL_Rect WakaDraw::createSurface(FontCtrl& ttf) {

  base.x = 0;
  base.y = 0;
  base.h = TYPE_FS *3 + TYPE_FS/2 *2;
  base.w = TYPE_FS * getUniLen(wakaResource->kanji[0]) +
    TYPE_FS/2 + TYPE_FS * getUniLen(wakaResource->kanji[1]);
  int width;
  if ((width = TYPE_FS/2 +
       TYPE_FS * getUniLen(wakaResource->kanji[2])) > base.w) {
    base.w = width;
  }
  if ((width = TYPE_FS/2 *2 +
       TYPE_FS * getUniLen(wakaResource->kanji[3]) + TYPE_FS/2 +
       TYPE_FS * getUniLen(wakaResource->kanji[4])) > base.w) {
    base.w = width;
  }

  return base;
}


// ẫT[tFX`
void WakaDraw::drawSurface(const SDL_Rect *position, ScreenCtrl& scr,
			   FontCtrl& ttf, int percentage) {
  SDL_Rect pos;

  // S`悷ꍇArŏ`
  if (percentage == DRAW_ALL) {
    rubiInfo_index = 0;
  }
  for (int i = 0; i < 5; ++i) {
    if (i == 0) {		// ̋PAQ
      pos.x = position->x;
      pos.y = position->y;
      
    } else if (i == 2) {	// ̋R
      pos.x = position->x + TYPE_FS/2;
      pos.y += TYPE_FS + TYPE_FS/2;
      
    } else if (i == 3) {	// ̋PCQ
      pos.x = position->x + TYPE_FS/2 * 2;
      pos.y += TYPE_FS + TYPE_FS/2;
      
    }
    if ((percentage < 20 * (i+1)) || (percentage == DRAW_ALL)) {
      // `͈͂̃NA
      pos.h = TYPE_FS;
      pos.w = TYPE_FS * getUniLen(wakaResource->kanji[i]);
      if (percentage != DRAW_ALL) {
	scr.fillBack(&pos);
      }
      // 񂾂\
      drawSubSurface(scr, &pos, ttf, wakaResource->kanji[i], percentage);
      if (percentage != DRAW_ALL) {
	drawRubi(scr, &pos, ttf, percentage);
	break;
	
      } else {
	for (int j = 0; j < 20; ++j) {
	  drawRubi(scr, &pos, ttf, 20 * i + j);
	}
      }
    }
    pos.x += TYPE_FS * getUniLen(wakaResource->kanji[i]) + TYPE_FS/2;
  }
}


// ãf[^w肵ẴIuWFNg
WakaDraw::WakaDraw(wakaResource_t *wResource)
  : wakaResource(wResource), rubiInfo_index(0) {

  // r̐
  rubiInfo.clear();
  for (int i = 0; i < 5; ++i) {
    createRubiInfo(i, wakaResource->kanji[i], wakaResource->yomi[i]);
  }
}
