#ifndef SCREEN_CTRL_H
#define SCREEN_CTRL_H

/*
  o͑Sʂ̊Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include <vector>
#include "SDLResource.h"

using namespace std;

// [U̓
typedef struct {
  bool escape;			// ߂
  bool enter;			// 
  bool quit;			// I
  bool leftclick;		// }EXNbN
} userInput_t;


enum ScreenCtrlEnum {
  CURSOR_DELETE_SEC = 2,	// ȂJ[\܂ł̎

  TOP		= 0x00000001,
  MIDDLE	= 0x00000001 << 1,
  BOTTOM	= 0x00000001 << 2,
  LEFT		= 0x00000001 << 3,
  CENTER	= 0x00000001 << 4,
  RIGHT		= 0x00000001 << 5,
};


// o͑Sʂ̊Ǘ
class ScreenCtrl {
  SDL_Surface *backImage;
  Uint32 targetFPS;
  Uint32 frameRateNextTick;
  Uint32 frameRateInterval;
  int mx, my;
  int wipeWidth;
  int alreadyWiped;

  void videoInit(Uint32 mode);
  vector<SDL_Rect> updateRects;
  void wipeDraw(void);
  ScreenCtrl(void);

public:
  int const w(void) { return SDLResource::screen->w; };
  int const h(void) { return SDLResource::screen->h; };
  SDL_Surface *screen() { return SDLResource::screen; };

  userInput_t eventHandler(void);
  void blitSurface(SDL_Surface *src, SDL_Rect *srcrect,
			  SDL_Surface *dst, SDL_Rect *dstrect, int align);
  void blitSurface(SDL_Surface *src, SDL_Rect *srcrect,
			  SDL_Surface *dst, SDL_Rect *dstrect);
  void setBackImage(const char *fname);
  void fillBack(const SDL_Rect *area);
  void fillBack(void);
  void fillColor(SDL_Rect *area, Uint32 color);
  void initFrameRateCtrl(void);
  void setFPS(int fps);
  void frameRateWait(void);
  void wipeBack(int msec);
  void update(void);

  ScreenCtrl(Uint32 fullscreen);
};

#endif /* !SCREEN_CTRL_H */
