/*
  o͑Sʂ̊Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include <stdlib.h>
#include "screenCtrl.h"


// Cxgnh
userInput_t ScreenCtrl::eventHandler(void) {

  static Uint32 cursorLastMovedTicks = SDL_GetTicks();
  userInput_t userInput = { false, false, false, false };

  bool cursorMoved = false;
  SDL_Event event;
  while (SDL_PollEvent( &event )) {
    Uint8 mouseState;
    SDLKey key;
    SDLMod mod;
    switch ( event.type ) {
      int x, y;

    case SDL_QUIT:
      // Q[̏I
      userInput.quit = true;
      break;

    case SDL_MOUSEBUTTONDOWN:
      // }EX̓Cxg
      mouseState = SDL_GetMouseState(NULL, NULL);
      if (mouseState & SDL_BUTTON(1)) {	// NbN
	userInput.leftclick = true;
      } else if (mouseState & SDL_BUTTON(3)) { // ENbN
	userInput.escape = true;
      }
      break;
      
    case SDL_KEYDOWN:
      // L[̓Cxg
      key = event.key.keysym.sym;
      mod = event.key.keysym.mod;
      if (key == SDLK_ESCAPE) {
	// ߂
	userInput.escape = true;
	
      } else if ((key == SDLK_q) && (mod & KMOD_CTRL)) {
	// Q[̏I
	userInput.quit = true;
	
      } else if ((key == SDLK_F4) && (mod & KMOD_ALT)) {
	// Q[̏I
	userInput.quit = true;
	
      } else if (key == SDLK_RETURN) {
	// tXN[
	if (mod & KMOD_ALT) {
	  SDL_WM_ToggleFullScreen(SDLResource::screen);
	} else {
	  // 
	  userInput.enter = true;
	}

      } else if (((key == SDLK_j) || (key == SDLK_m)) &&
		 (mod & KMOD_CTRL)) {
	// 
	userInput.enter = true;
	
      } else if ((key == SDLK_g) && (mod & KMOD_CTRL)) {
	// ߂
	userInput.escape = true;
      }
      break;
      
    case SDL_MOUSEMOTION:
      // ړ΁A
      SDL_GetMouseState(&x, &y);
      if (abs(x - mx) + abs(y - my) > 4) {
	cursorMoved = true;
	SDL_ShowCursor(SDL_ENABLE);
	cursorLastMovedTicks = SDL_GetTicks();
	SDL_GetMouseState(&mx, &my);
      }
      break;
    }
  }
  // ړ̂Ȃ}EXB
  if (!cursorMoved &&
      ( SDL_GetTicks() - cursorLastMovedTicks > CURSOR_DELETE_SEC * 1000)) {
    SDL_ShowCursor(SDL_DISABLE);
  }

  return userInput;
}


// \̈ʒuw肵T[tFX]
void ScreenCtrl::blitSurface(SDL_Surface *src, SDL_Rect *srcrect,
			     SDL_Surface *dst, SDL_Rect *dstrect, int align) {
  SDL_Rect aligned = *dstrect;

  // ̈ʒu
  if ( align & MIDDLE ) {
    aligned.y -= ((srcrect == NULL) ? src->h : srcrect->h) >> 1;
  } else if ( align & BOTTOM ) {
    aligned.y -= ((srcrect == NULL) ? src->h : srcrect->h);
  }

  // ̈ʒu
  if ( align & CENTER ) {
    aligned.x -= ((srcrect == NULL) ? src->w : srcrect->w) >> 1;
  } else if ( align & RIGHT ) {
    aligned.x -= ((srcrect == NULL) ? src->w : srcrect->w);
  }
  
  blitSurface(src, srcrect, dst, &aligned);
}



// T[tFX]
void ScreenCtrl::blitSurface(SDL_Surface *src, SDL_Rect *srcrect,
			     SDL_Surface *dst, SDL_Rect *dstrect) {

  // UpdateRects ̎Ǘ
  SDL_Rect rect;
  rect.x = dstrect->x;
  rect.y = dstrect->y;
  rect.w = (srcrect == NULL) ? src->w : srcrect->w;
  rect.h = (srcrect == NULL) ? src->h : srcrect->h;

  // Sɂ͂ݏoĂꍇ
  if (( rect.x > dst->w ) ||
      ( rect.x + rect.w < 0) ||
      ( rect.y > dst->h ) ||
      ( rect.y + rect.h < 0)) {
    return;
  }

  // Iɂ͂ݏoĂꍇ
  if ( rect.x < 0 ) {
    rect.w += rect.x;
    rect.x = 0;
  }
  if ( rect.y < 0 ) {
    rect.h += rect.y;
    rect.y = 0;
  }
  if ( rect.x + rect.w > dst->w ) {
    rect.w += (dst->w - (rect.x + rect.w));
  }
  if ( rect.y + rect.h > dst->h ) {
    rect.h += (dst->h - (rect.y + rect.h));
  }

  SDL_BlitSurface(src, srcrect, dst, dstrect);
  updateRects.push_back(rect);
}


// wi̕~l߉摜ǂݍ
void ScreenCtrl::setBackImage(const char *fname) {

  // ǂݍݍς݂̉摜
  if (backImage) {
    SDL_FreeSurface(backImage);
  }

  // wi摜̓ǂݍ
  backImage = SDL_LoadBMP(fname);
  if (!backImage) {
    fprintf(stderr, "SDL_LoadBMP \"%s\" : %s\n", fname, SDL_GetError());
  }

  // wi摜ɂăJ[}bvݒ
  if((backImage->format->palette) && (SDLResource::screen->format->palette)) {
    SDL_SetColors(SDLResource::screen, backImage->format->palette->colors,
		  0, backImage->format->palette->ncolors);
  }
}


// wỉ摜~l(ݔ͈͂̎w肠)
void ScreenCtrl::fillBack(const SDL_Rect *area) {
  
  if (!backImage) {
    return;
  }

  // ރp^[ area ɂƂ̂ݕ`
  SDL_Rect pos;
  for (int y = 0; y < SDLResource::screen->h; y += backImage->h) {
    pos.y = y;
    for (int x = 0; x < SDLResource::screen->w; x += backImage->w) {
      pos.x = x;
      if ( !area ) {
	blitSurface(backImage, NULL, SDLResource::screen, &pos);
      } else if (( pos.x < area->x + area->w ) &&
		 ( pos.x + backImage->w > area->x ) &&
		 (( pos.y < area->y + area->h ) &&
		  ( pos.y + backImage->h > area->y ))) {
	SDL_BlitSurface(backImage, NULL, SDLResource::screen, &pos);
      }
    }
  }
  if ( area ) {
    // ݗ̈̔ĂȂ
    updateRects.push_back(*area);
  }
}


// wi摜ŕ~l
void ScreenCtrl::fillBack(void) {
  // Sʕ`ɂČĂяoꍇAWIPEʂ
  wipeWidth = 0;
  
  fillBack(NULL);
}


// `hԂ
void ScreenCtrl::fillColor(SDL_Rect *area, Uint32 color) {
  SDL_FillRect(SDLResource::screen, area, color);
  if (!area) {
    updateRects.clear();
    SDL_Rect all;
    all.x = 0;
    all.y = 0;
    all.w = SDLResource::screen->w;
    all.h = SDLResource::screen->h;
    updateRects.push_back(all);
  } else {
    updateRects.push_back(*area);
  }
}


// ڕWt[[gݒ
void ScreenCtrl::setFPS(int fps) {
  frameRateInterval = (1000 / fps) + 1;
}


// t[[g
void ScreenCtrl::initFrameRateCtrl(void) {
  frameRateNextTick = SDL_GetTicks() + frameRateInterval;
}


// t[[g邽߂̑ҋ@
void ScreenCtrl::frameRateWait(void) {

  // ̖ڕWҋ@vZ
  frameRateNextTick += frameRateInterval;

  // ݎ擾
  Uint32 now = SDL_GetTicks();

  // xꂷĂꍇ̒Aŏ̌Ăяoɂ
  if (frameRateNextTick + frameRateInterval * 5 < now) {
    frameRateNextTick = now + frameRateInterval;
  }
  
  // ҋ@A܂̓X[
  if (frameRateNextTick > now) {
    SDL_Delay(frameRateNextTick - now);
  }
}


// hԂ
void ScreenCtrl::wipeDraw(void) {
  
  // hԂ
  SDL_Rect area;
  area.x = alreadyWiped;
  area.y = 0;
  area.w = wipeWidth;
  area.h = SDLResource::screen->h;
  if ((area.x + area.w) > SDLResource::screen->w) {
    area.w = SDLResource::screen->w - area.x;
  }
  fillBack(&area);
  
  alreadyWiped += wipeWidth;
  if (alreadyWiped >= SDLResource::screen->w) {
    wipeWidth = 0;
  }
}


// hԂ̌Ăяo
void ScreenCtrl::wipeBack(int msec) {
  wipeWidth = SDLResource::screen->w / (msec / frameRateInterval) + 1;
  alreadyWiped = 0;
}


// \̍XV
void ScreenCtrl::update(void) {

  // hԂ
  if (wipeWidth > 0) {
    wipeDraw();
  }

  if (!updateRects.size()) {
    return;
  }

  // XN[̍XV
  SDL_UpdateRects(SDLResource::screen, updateRects.size(),
		  (SDL_Rect *)&updateRects[0]);
  updateRects.clear();
}


void ScreenCtrl::videoInit(Uint32 mode) {

  // VIDEO ɏς݂̏ꍇ
  if (SDL_WasInit(SDL_INIT_VIDEO) != 0) {
    return;
  }

  if (SDL_Init(SDL_INIT_VIDEO) < 0) {
    fprintf(stderr, "SDL_Init: %s\n", SDL_GetError());
    exit(1);
  }
  atexit(SDL_Quit);

  mode |= SDL_SWSURFACE | SDL_HWPALETTE;
  SDLResource::screen = SDL_SetVideoMode(640, 480, 24, mode);
  if (!SDLResource::screen) {
    fprintf(stderr, "SDL_SetVideoMode: %s\n", SDL_GetError());
    exit(1);
  }

  // t[[g
  targetFPS = 60;
  setFPS(targetFPS);
  initFrameRateCtrl();

  // hԂ
  wipeWidth = 0;
  alreadyWiped = 0;

  // }EXJ[\ʒům
  SDL_GetMouseState(&mx, &my);
}


ScreenCtrl::ScreenCtrl(Uint32 mode) : backImage(NULL) {
  videoInit(mode);
}

