#ifndef RANKING_ACCESS_H
#define RANKING_ACCESS_H

/*
  WebLOւ̓o^Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include <string>
#include <list>
#include "resultData.h"


enum RankingAccessEnum {
  ACCOUNT_LENGTH = 12,
  PASSWD_LENGTH = 32,
  KIMARIJI_PRACTICE,
  TYPING_PRACTICE,
};


class RankingAccess {
  bool active;
  string fileName;
  string connectionHost;
  string account, passwd;
  list<string> userInfo;
  
  RankingAccess(void);

public:
  void sendTypingInfo(ResultData& result, int inputMode,
		      int mode= TYPING_PRACTICE);
  void setUserInfo(void);
  bool toggleUserInfo(void);
  bool isActive(void);
  string getAccount(void);
  void save(void);
  
  RankingAccess(const char *fileName);
};

#endif /* !RANKING_ACCESS_H */
