/*
  WebLOւ̓o^Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include <fstream>
#include "rankingAccess.h"
#include "httpAccess.h"


// ^CsO]
void RankingAccess::sendTypingInfo(ResultData& result, int inputMode,
				   int mode) {
  if (!active) {
    return;
  }

  if (mode == KIMARIJI_PRACTICE) {
    HttpAccess http(connectionHost.c_str());
    http.addData("account", account.c_str()); // AJEg
    http.addData("passwd", passwd.c_str()); // pX[h
    http.addData("number", result.getDataNum()); // â̓͐
    http.addData("kimarijiscore", result.getKimarijiScore()); // _
    http.addData("delay", result.getStartDelayTotal()); // ͂̊Jn
    http.addData("delete", result.getTotalMiss()); // 폜L[̗p
    http.send();
    
  } else {
    HttpAccess http(connectionHost.c_str());
    http.addData("account", account.c_str()); // AJEg
    http.addData("passwd", passwd.c_str()); // pX[h
    http.addData("convert", ((inputMode == 0) ? "roman" : "kana")); // ͕@
    http.addData("number", result.getDataNum()); // â̓͐
    http.addData("score", result.getTotalScore()); // _
    http.addData("delay", result.getStartDelayTotal()); // ͂̊Jn
    http.addData("speed", result.getPressedNumPerMinute()); // ^CsOx
    http.addData("delete", result.getTotalMiss()); // 폜L[̗p
    http.send();
  }
}


bool RankingAccess::isActive(void) {
  return active;
}


string RankingAccess::getAccount(void) {
  return account;
}


bool RankingAccess::toggleUserInfo(void) {
  if (userInfo.size() == 0) {
    return false;
  }

  string line = userInfo.front();
  userInfo.pop_front();
  userInfo.push_back(line);
  setUserInfo();

  return active;
}


void RankingAccess::setUserInfo(void) {
  if (userInfo.size() == 0) {
    return;
  }

  list<string>::iterator it = userInfo.begin();
  if (it->size() < ACCOUNT_LENGTH+1+PASSWD_LENGTH) {
    active = false;
    return;
  }
  account.assign(*it, 0, ACCOUNT_LENGTH);
  passwd.assign(*it, ACCOUNT_LENGTH+1, ACCOUNT_LENGTH+1+PASSWD_LENGTH);

  active = true;
}


// \[Xt@C̍XV
void RankingAccess::save(void) {
  if (!active) {
    return;
  }

  // ݂̏ɂăt@Cۑ
  std::ofstream fd(fileName.c_str());
  fd << connectionHost.c_str() << endl;
  for (list<string>::iterator it = userInfo.begin();
       it != userInfo.end(); ++it) {
    fd << it->c_str() << endl;
  }
}


// \[Xt@CJ
RankingAccess::RankingAccess(const char *fname)
  : active(false) {

  // t@CJAڑy[WAAJEgApX[h̏i[
  fileName = fname;
  std::ifstream fd(fname);
  if (!fd) {
    fprintf(stderr, "Notice: %s is not found.\n", fname);
    return;
  }
  
  char buf[BUFSIZ];
  fd.getline(buf, BUFSIZ);
  connectionHost = buf;

  userInfo.clear();
  while (!fd.eof()) {
    fd.getline(buf, BUFSIZ);
    if (strlen(buf) == ACCOUNT_LENGTH + PASSWD_LENGTH + 1) {
      userInfo.push_back(buf);
    }
  }

  setUserInfo();
}
