/*
  ܂K̏
  Satofumi KAMIMURA
  $Id$
*/

#include "nettyping.h"
#include "kimarijiPractice.h"
#include "kimarijiManage.h"
#include "convert.h"
#include "keyType.h"
#include "drawUtils.h"


extern Uint16 toKimarijiModeTTF[];
extern Uint16 resultWakaNumTTF[];
extern Uint16 resultKimarijiTitleTTF[];
extern Uint16 resultKimarijiDelayTTF[];
extern Uint16 resultUseDeleteTTF[];
extern Uint16 resultTotalTTF[];
extern Uint16 syuTTF[];
extern Uint16 secTTF[];
extern Uint16 tenTTF[];
extern Uint16 kaiTTF[];
extern Uint16 timeoutTTF[];


enum KimarijiPracticeState {
  CHAR_DRAW_MSEC = 600,		// P\鎞
  LIMIT_BAR_WIDTH = 500,
  LIMIT_BAR_HEIGHT = 20,
  TYPING_AREA_SIZE = 16,

  BEFORE_TYPE,
  TYPE_READY,
  AFTER_TYPE,
  TIME_OUT,

  DRAW_ALL,
  END_DELAY_TIME = 4000,	// ͌̋xe
  RESULT_DRAW_TIME = 2000,	// ʕ\ɂ鎞
  ESCAPE_QUIT_TIMES = 2,	// AłŃ^CsO[h𔲂
};


// \Ǘ
typedef struct {
  int total;
  int ku;
  int ch;
} drawInfo_t;


// â̓ǂ݂Ԗɕ\
static int wakaDraw(wakaResource_t *wr, int msec, drawInfo_t *dr,
		     ScreenCtrl& scr, FontCtrl& ttf, SDL_Rect *position,
		    int kimariji) {

  enum { BORDER_WIDTH = 4 };
  
  int drawChars = dr->total - dr->ku;
  if ((msec/CHAR_DRAW_MSEC < dr->total) ||
      ((dr->ku == 4) && (wr->yomi[dr->ku][dr->ch] == 0x00))) {
    return drawChars;
  }
  ++(dr->total);

  // P\AeJE^i߂
  Uint16 chars[] = { 0x00, 0x00 };
  chars[0] = wr->yomi[dr->ku][dr->ch];
  ++(dr->ch);
  if (chars[0] == 0x00) {
    if ((dr->ku == 1) || (dr->ku == 2)) {
      position->y += TYPE_FS/2*3;
      position->x = TYPE_FS/3 + ((dr->ku == 2) ? TYPE_FS/3 : 0);
    }
    ++(dr->ku);
    dr->ch = 0;
  }
  if (chars[0] == 0x00) {
    position->x += TYPE_FS/3;
    return drawChars;
  }
  position->x += TYPE_FS;

  // `
  SDL_Rect pos = *position;
  pos.x -= TYPE_FS;
  if (drawChars == kimariji-1) {
    // ܂莚\
    SDL_Rect area = pos;
    area.w = TYPE_FS;
    area.h = BORDER_WIDTH;
    area.y += TYPE_FS - BORDER_WIDTH;
    scr.fillColor(&area, WHITE | 0xff);
  }
  SDL_Surface *wch = ttf.createSurface(chars, TYPE_FS, BLACK);
  scr.blitSurface(wch, NULL, scr.screen(), &pos);
  SDL_FreeSurface(wch);

  return drawChars;
}


// Ԑ̃o[\
static void drawTimeBar(ScreenCtrl& scr, int spentTime, int limitTime,
			int mode) {

  enum { BORDER_WIDTH = 1 };

  SDL_Rect area;
  area.x = scr.w()/2 - LIMIT_BAR_WIDTH/2;
  area.y = scr.h() - TYPE_FS;
  area.w = LIMIT_BAR_WIDTH;
  area.h = LIMIT_BAR_HEIGHT;

  // Og̕\
  SDL_Rect border = area;
  border.x -= BORDER_WIDTH;
  border.w += BORDER_WIDTH * 2;
  border.y -= BORDER_WIDTH;
  border.h += BORDER_WIDTH * 2;

  // ̏ꍇAwiœhԂ
  if (mode == CLEAR) {
    scr.fillBack(&border);
    return;
  }
  scr.fillColor(&border, BLACK);

  // o[̕\
  scr.fillColor(&area, GREEN);
  
  // oߎԕ
  int left = (int)(1.0 * LIMIT_BAR_WIDTH *
		   (limitTime - ((spentTime > limitTime) ?
				  limitTime : spentTime)) / limitTime);

  area.x += left;
  area.w -= left;
  scr.fillColor(&area, BLACK);
}


// ^CsǑʕ\
static void resultDrawMode(ScreenCtrl& scr, FontCtrl& ttf, SoundCtrl& snd,
			   ResultData& result, RankingAccess& rank,
			   GameOption& opt, int mode) {

  result.profile();
  int kimarijiScore = ((result.getKimarijiScore() < 0) || (mode == TIME_OUT)) ?
    0 : result.getKimarijiScore();
  
  // WebT[oɓo^
  if (rank.isActive() && (opt.getSelected("web") == 1) &&
      (kimarijiScore > 0)) {
    rank.sendTypingInfo(result, opt.getSelected("convert"), KIMARIJI_PRACTICE);
  }

  SDL_Rect titlePos, resultPos;
  enum { SPACE = 10, UP = 6, };

  // ^Cg\
  scr.fillBack();
  titlePos.x = scr.w()/2;
  titlePos.y = RESULT_FS;

  SDL_Surface *text = ttf.createSurface(resultKimarijiTitleTTF, MENU_FS,BLACK);
  scr.blitSurface(text, NULL, scr.screen(), &titlePos, CENTER);
  titlePos.y += text->h + SPACE;
  SDL_FreeSurface(text);

  char char_str[15];
  titlePos.x = MENU_FS/2 * 4;
  titlePos.y += RESULT_FS/2 * 6;
  resultPos.x = scr.w() - MENU_FS/2*7;
  resultPos.y = titlePos.y - UP;

  int counter = 0;
  int percentage = 0;
  int draw = false;
  while (1) {
    ++counter;
    int pre_percentage = percentage;
    percentage = (counter * (1000/FPS +1) > RESULT_DRAW_TIME) ? 100
      : (int)(100.0 * counter * (1000/FPS +1) / RESULT_DRAW_TIME);
    draw = (pre_percentage == percentage) ? false : true;

    // ͘a̐
    if (draw && percentage == 14) {
      snd.playEffect(TYPE_EFFECT);
      sprintf(char_str, "%3d", result.getDataNum()
	      - ((mode == TIME_OUT) ? 1 : 0));
      char_str[3] = '\0';
      drawResultText(scr, ttf, resultWakaNumTTF, char_str, syuTTF,
		     &titlePos, &resultPos);
      titlePos.y += RESULT_FS + SPACE;
      resultPos.y = titlePos.y - UP;
    }


    // ܂莚̓͒x
    if (draw && percentage == 14 * 2) {
      snd.playEffect(TYPE_EFFECT);
      if (mode == TIME_OUT) {
	drawResultText(scr, ttf, resultKimarijiDelayTTF, "--", secTTF,
		       &titlePos, &resultPos);
      } else {
	sprintf(char_str, "%11.1f",
		result.getStartDelayTotal()/ 1000.0 / result.getDataNum());
	char_str[14] = '\0';
	drawResultText(scr, ttf, resultKimarijiDelayTTF, char_str, secTTF,
		       &titlePos, &resultPos);
      }
      titlePos.y += RESULT_FS + SPACE;
      resultPos.y = titlePos.y - UP;

    }
    
    // 폜
    if (draw && percentage == 14 * 3) {
      snd.playEffect(TYPE_EFFECT);
      sprintf(char_str, "%3d/%d\n",
	      result.getTotalMiss(), result.getTotalPressedNum());
      int i;
      for (i = 0; char_str[i] != '\n'; ++i)
	;
      char_str[i] = '\0';
      drawResultText(scr, ttf, resultUseDeleteTTF, char_str, kaiTTF,
		     &titlePos, &resultPos);
      titlePos.y += RESULT_FS + SPACE;
      resultPos.y = titlePos.y - UP;
    }

    // uv
    if (draw && percentage == 14 * 4) {
      snd.playEffect(DECIDE_EFFECT);
      titlePos.y = scr.h() - MENU_FS;
      resultPos.y = titlePos.y;
      SDL_Rect line;
      line.h = 4;
      line.w = scr.w() - MENU_FS * 2;
      line.x = MENU_FS;
      line.y = titlePos.y;
      scr.fillColor(&line, BLACK);
      text = ttf.createSurface(resultTotalTTF, TYPE_FS, BLACK);
      scr.blitSurface(text, NULL, scr.screen(), &titlePos, BOTTOM);
      titlePos.y += text->h + SPACE;
      SDL_FreeSurface(text);
      
      // _
      Uint16 str[13];
      sprintf(char_str, "%12d", kimarijiScore);
      for (int i = 0; i < 12; ++i) {
	str[i] = char_str[i];
      }
      str[12] = '\0';
      text = ttf.createSurface(str, TYPE_FS, BLACK);
      scr.blitSurface(text, NULL, scr.screen(), &resultPos, RIGHT | BOTTOM);
      SDL_FreeSurface(text);
      
      // [_]
      text = ttf.createSurface(tenTTF, RUBI_FS, BLACK);
      scr.blitSurface(text, NULL, scr.screen(), &resultPos, LEFT | BOTTOM);
      SDL_FreeSurface(text);
    }


    snd.update();
    scr.update();
    scr.frameRateWait();
    userInput_t ui = scr.eventHandler();
    if (ui.quit) {
      gameExit();
    } else if (ui.escape || ui.enter || ui.leftclick) {
      snd.playMusic(-1);
      snd.playEffect(-1);
      return;
    }
  }
}


// ܂K
void kimarijiPractice(ScreenCtrl& scr, GameOption& opt,
		      FontCtrl& ttf, WakaResource& waka,
		      SoundCtrl& snd, RankingAccess& rank) {

  scr.fillBack();

  // Jňʉ
  Timer soundTimer;
  snd.playEffect(BEGIN_EFFECT);

  // â̎擾
  int wakaIdMax = 100;
  for (int i = 0, to = 4 - opt.getSelected("number"); i < to; ++i) {
    wakaIdMax >>= 1;
  }

  // ȁ̎擾
  waka.clearWakaInfo();
  KimarijiManage kj(waka);
  kj.randamize(SDL_GetTicks());

  // ͗pIuWFNg̐
  Convert cnv( (opt.getSelected("convert") == 0) ?
	       ROMAN_CONVERT : KANA_CONVERT );
  KeyType type;

  // ʉ̏I҂
  if (!waitFirstMusicEnd(5000, scr, ttf, snd, soundTimer, toKimarijiModeTTF)) {
    return;
  }
  snd.playMusic(TYPE_MUSIC);

  // â̕\ꏊ
  SDL_Rect wakaPosition;
  wakaPosition.x = TYPE_FS/3;
  wakaPosition.y = TYPE_FS * 2;

  // ͗̕\ꏊA͈
  SDL_Rect inputArea;
  inputArea.x = scr.w()/2 - TYPE_FS*7/2 - TYPE_FS/2;
  inputArea.y = scr.h()/2 + TYPE_FS * 2 + TYPE_FS/2 * 3;
  inputArea.w = TYPE_FS * TYPING_AREA_SIZE/2;
  inputArea.h = TYPE_FS;

  resultData_t rd[100];
  ResultData result;

  // [v
  scr.fillBack();
  int escape_count = 0;
  scr.initFrameRateCtrl();
  bool ringTypeSound = false;
  int mode = BEFORE_TYPE;
  for (int number = 0; number < wakaIdMax; ++number) {

    drawTotalWakaTyped(scr, ttf, number+1 ,wakaIdMax);

    wakaResource_t wr = waka.getWakaData( kj.getKimarijiWakaId() );
    drawInfo_t dr = { 0, 0, 0 };
    SDL_Rect pos = wakaPosition;

    cnv.clearBuffer();
    result.clearResultStruct(&rd[number], wr.id, wr.kimariji);
    int counter = 0;
    int timeLimit = -1;
    int limitTime = CHAR_DRAW_MSEC * (17 + 3 + 4 - wr.kimariji);
    mode = BEFORE_TYPE;
    bool wiped = false;
    Timer nextModeTimer;
    cnv.clearBuffer();
    while (1) {
      // P\
      if (mode != TIME_OUT) {
	int chs = wakaDraw(&wr, counter++ * (1000/FPS +1), &dr, scr, ttf, &pos,
			   wr.kimariji);
	// ܂莚ȍ~AԐo[̕\Jn
	if (chs >= wr.kimariji && timeLimit < 0) {
	  timeLimit = 0;
	  mode = TYPE_READY;
	}

	if ((mode == TYPE_READY) && (chs >= wr.kimariji) && (timeLimit >= 0)) {
	  // Ԑo[̕\
	  drawTimeBar(scr, timeLimit++ * (1000/FPS +1), limitTime, DRAW);
	  
	  // ͗̕\
	  drawInputArea(scr, ttf, &inputArea, cnv, DRAW);
	}
      }

      // ^CAEg
      if ((mode == TYPE_READY) && (timeLimit * (1000/FPS +1) > limitTime)) {
	mode = TIME_OUT;
	nextModeTimer.reset();
	rd[number].startDelay = DELAY_MAX;
	result.addData(&rd[number]);
      }
      
      snd.update();
      scr.update();
      scr.frameRateWait();

      if (mode == TYPE_READY) {
	ringTypeSound = type.inputHandler(scr, cnv, TYPING_AREA_SIZE-2,
					    &rd[number], 1);
      }
      userInput_t ui = scr.eventHandler();
#ifndef __MINGW32__
      if (ringTypeSound) {
	ringTypeSound = false;
	snd.playEffect(TYPE_EFFECT);
      }
#endif
      if ((mode == TYPE_READY) &&
	  type.compareBuffer((Uint16 *)wr.yomi[3],
			     cnv.getConvertBuffer(), 2)) {
	// ͂̊
	mode = AFTER_TYPE;
	nextModeTimer.reset();
	
	// ͊Ԃm
	rd[number].id = wr.id;
	rd[number].startDelay = timeLimit * (1000/FPS +1);
	rd[number].kimarijiSubScore = limitTime - timeLimit * (1000/FPS +1);
	result.addData(&rd[number]);

	// â̕\A͗̏
	cnv.clearBuffer();
	drawInputArea(scr, ttf, &inputArea, cnv, CLEAR);
	drawTimeBar(scr, 0, 0, CLEAR);
	pos = wakaPosition;
	dr.total = dr.ku = dr.ch = 0;
	for (int i = 0; i < 40; ++i) {
	  wakaDraw(&wr, CHAR_DRAW_MSEC*i +1, &dr, scr, ttf, &pos, wr.kimariji);
	}
	snd.playEffect(DECIDE_EFFECT);
      }
	
      if (ui.quit) {
	gameExit();
	
      } else if (ui.escape) {
	// ϊobt@̃NA
	if (cnv.getBufLen()) {
	  cnv.clearBuffer();
	  ++(rd[number].pressedNum);
	  ++(rd[number].deletePressed);
	  escape_count = 0;
	} else if (++escape_count >= ESCAPE_QUIT_TIMES) {
	  // obt@̏Ԃ ESC AłƁA
	  
	  snd.playMusic(-1);
	  snd.playEffect(-1);
	  // Ỏʂɖ߂
	  return;
	}
	  
      } else if ((mode == AFTER_TYPE) || (mode == TIME_OUT)) {
	if (!wiped && (nextModeTimer.getTime() > END_DELAY_TIME/4)) {
	  scr.wipeBack(END_DELAY_TIME/2);
	  wiped = true;
	}
	if (nextModeTimer.isOver(END_DELAY_TIME)) {
	  wiped = false;
	  break;
	}
      }
    }
    if (mode == TIME_OUT) {
      break;
    }
  }
  // ʂ̕\
  resultDrawMode(scr, ttf, snd, result, rank, opt, mode);

  if (opt.getSelected("learn") == 0) {    
    // uo悤v[h
    int ids[5];
    int max = (result.getDataNum() > 5) ? 5 : result.getDataNum();
    result.getSlowInputWakaId(ids, max);
    learnMode(scr, ttf, snd, waka, ids, max);
  }
}
