/*
  ^CsO͂̊ǗNX
  Satofumi KAMIMURA
  $Id$
*/

#include "keyType.h"
#include <ctype.h>
#include <limits.h>


// 񂪓ǂԂ(rTCYw)
bool KeyType::compareBuffer(Uint16 *s1, Uint16 *s2, int n) {
  int i = 0;
  Uint16 *p1 = s1, *p2 = s2;

  while ((*p1) && (++i < n) && (*p1 == *p2)) {
    p1++;
    p2++;
  }
  return (*p1 == *p2);
}


// 񂪓ǂԂ
bool KeyType::compareBuffer(Uint16 *s1, Uint16 *s2) {
  return compareBuffer(s1, s2, INT_MAX);
}


// PoCg̒Ԃ
int KeyType::getByteSize(Convert& cnv) {
  Uint16 *p = cnv.getConvertBuffer();
  int size = 0;

  while (*p) {
    ++p;
    size += (*p > 0xff) ? 2 : 1;
  }
  return size;
}


// SHIFT Ăꍇ̕(pL[{[hˑ)
static char withShift(SDLKey key) {

  typedef struct {
    SDLKey from;
    char to;
  } keyTable_t;

  keyTable_t tbl[] = {
    { SDLK_QUOTE, '~' },
    { SDLK_3, '#' },
    { SDLK_4, '$' },
    { SDLK_5, '%' },
    { SDLK_6, '&' },
    { SDLK_7, '\'' },
    { SDLK_8, '(' },
    { SDLK_9, ')' },
    { SDLK_0, '~' },
    { SDLK_MINUS, '=' },
    { SDLK_BACKSLASH, '|' },

    { SDLK_LEFTBRACKET, '{' },
    { SDLK_RIGHTBRACKET, '}' },

    { SDLK_e, 'E' },
    { SDLK_z, 'Z' },
  };

  int size = sizeof(tbl) / sizeof(tbl[0]);
  for (int i = 0; i < size; ++i) {
    if (key == tbl[i].from) {
      return tbl[i].to;
    }
  }
    
  return ' ';
}
			      


// \obt@ɕω邩Ԃ
bool KeyType::inputHandler(ScreenCtrl& scr, Convert& cnv, int maxLength,
			   resultData_t *rd, int spentTime) {
  enum { EVENT_MAX = 10, };

  SDL_Event events[EVENT_MAX];

  // CxgL[͂擾
  SDL_PumpEvents();
  int num = SDL_PeepEvents(events, EVENT_MAX, SDL_PEEKEVENT,
			   SDL_EVENTMASK(SDL_KEYDOWN));

  bool changed = false;
  for (int i = 0; i < num; ++i) {
    if (events[i].type == SDL_KEYUP) {
      continue;
    }
    SDLKey key = events[i].key.keysym.sym;
    SDLMod mod = events[i].key.keysym.mod;

    if ((key == SDLK_RCTRL) || (key == SDLK_LCTRL) ||
	(key == SDLK_RALT) || (key == SDLK_LALT)) {
      continue;
      
    } else if ((key == SDLK_RETURN) ||
	(((key == SDLK_j) || (key == SDLK_m)) && (mod & KMOD_CTRL))) {
      // sL[
      if (getByteSize(cnv)+2 < maxLength) {
	cnv.addChar('\n');
	changed = true;
      }
      
    } else if ((key == SDLK_BACKSPACE) ||
	       ((key == SDLK_h) &&
		(mod & KMOD_CTRL))) {
      // 폜L[
      cnv.deleteLast();
      changed = true;
      if (rd) {
	++(rd->pressedNum);
	++(rd->deletePressed);
      }
      
    } else if (isprint(key)) {
      // At@xbg
      if (getByteSize(cnv)+2 < maxLength) {
	if ((cnv.getBufLen() == 0) && (rd && spentTime > rd->startDelay)) {
	  rd->startDelay = spentTime;
	}
	if (mod & KMOD_SHIFT) {
	  cnv.addChar( withShift(key) );
	} else {
	  cnv.addChar(key);
	}
	changed = true;
	if (rd) {
	  ++(rd->pressedNum);
	}
      }
    }
  }
  
  return changed;
}


KeyType::KeyType(void) {
  SDL_EnableKeyRepeat(500, 20);
}


KeyType::~KeyType(void) {
  SDL_EnableKeyRepeat(0, 0);
}
