#ifndef GAME_OPTION_H
#define GAME_OPTION_H

/*
  IvV̊Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include <SDL.h>
#include <stdio.h>
#include <vector>
#include "fontCtrl.h"
#include "screenCtrl.h"


enum {
  RIGHT_LEFT_CHANGE = 0x01,
  UP_DOWN_CHANGE = 0x02,
};


typedef struct {
  Uint16 **titles;
  int max;
  int selected;
  char *tag;
} gameOption_t;


// IvV̊ǗNX
class GameOption {
  const char *fileName;
  int spaceHeight;
  int spaceWidth;
  int selected;
  int maxSelection;
  char *mTag;
  int mSelected;
  int mx, my;
  vector<gameOption_t> options;
  GameOption();
  
public:
  void loadOption(void);
  void saveOption(void);
  void setSpaceHeight(int height);
  void setSpaceWidth(int width);
  void clearData(void);
  void resetTitleSelected(void);
  void addData(gameOption_t *data);
  void drawSurface(ScreenCtrl& scr, SDL_Rect *position,
		   FontCtrl& ttf, int selectOffset);
  unsigned int changeSelect(void);
  int getSelected(const char *tag);
  void setSelected(const char *tag, int value);
  GameOption(const char *fname);
  ~GameOption(void);
};


class GameOptionError {
public:
  virtual void debug_print(void) const {
    fprintf(stderr, "GameOption error\n");
  }
};


class No_Option_File : public GameOptionError {
  const char *fileName;
  
public:
  No_Option_File(const char *fName) { fileName = fName; }
  virtual void degug_print(void) const {
    fprintf(stderr, "not such file : %s\n", fileName);
  }
};


#endif /* !GAME_OPTION_H */
