/*
  tHg̊Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include <stdlib.h>
#include <sys/stat.h>
#include "fontCtrl.h"


// ߂ TTF T[tFX쐬
SDL_Surface *FontCtrl::createSurface(Uint16 str[], int ptSize,
				     Uint32 color, Uint32 back) {
  SDL_Color font_color = {
    (color >> 24) & 0xff,
    (color >> 16) & 0xff,
    (color >> 8) & 0xff,
    0 };

  SDL_Color backcolor = {
#if 1
    ((back >> 24) & 0xff) >> 1,
    ((back >> 16) & 0xff) >> 1,
    ((back >> 8) & 0xff) >> 1,
#else
    0x80, 0x80, 0x80,
#endif
    0 };

  if (str[0] == 0x00) {
    return NULL;
  }
  
  SDL_Surface *text = TTF_RenderUNICODE_Shaded(size(ptSize), str,
					       font_color, backcolor);
  if ((back & 0xff) == 0xff) {
    return text;
  }
  // ߃T[tFX̍쐬
  if (text->format->palette) {
    SDL_SetColorKey(text, (SDL_SRCCOLORKEY | SDL_RLEACCEL),
                    *(Uint8 *)text->pixels);
  }
  SDL_Surface *temp = SDL_DisplayFormat(text);
  SDL_FreeSurface(text);
  if (!temp) {
    fprintf(stderr, "SDL_DisplayFormat: %s\n", SDL_GetError());
    exit(1);
  }

  return temp;
}


// ߂ TTF T[tFX쐬
SDL_Surface *FontCtrl::createSurface(Uint16 str[], int ptSize, Uint32 color) {
  return createSurface(str, ptSize, color, 0xffffff00);
}



// wTCỸtHgԂ
TTF_Font *FontCtrl::size(int ptSize) {

  TTF_Font *font;

  map<int,TTF_Font*>::iterator it = fontResources.find(ptSize);
  if ( it != fontResources.end() ) {
    // Ɏ݂ꍇ
    font = it->second;

  } else {
    // VKɃtHgǉ
    font = TTF_OpenFont(fileName, ptSize);
    if (!font) {
      fprintf(stderr, "TTF_OpenFont: %s\n", TTF_GetError());
      exit(1);
    }
    fontResources[ptSize] = font;
  }
  
  return font;
}


void FontCtrl::ttfInitialized(void) {
  static bool init = false;

  // TTF ɏĂȂꍇ̏
  if ( init == false ) {
    init = true;
    if (TTF_Init() < 0) {
      fprintf(stderr, "TTF_Init: %s\n", TTF_GetError());
      exit(1);
    }
    atexit(TTF_Quit);
  }
}


FontCtrl::FontCtrl(const char *fname) : fileName(fname) {

  // TTF Cȕ
  ttfInitialized();

  // t@C݂邩mF
  struct stat tmp;
  if (stat(fname, &tmp) < 0) {
    fprintf(stderr, "TTF file check %s: ", fname);
    perror("");
    exit(1);
  }
}


FontCtrl::~FontCtrl(void) {
  // tHg\[X̉
  for (map<int,TTF_Font*>::iterator it = fontResources.begin();
       it != fontResources.end(); ++it) {
    TTF_CloseFont(it->second);
  }
}
