#ifndef CONVERT_H
#define CONVERT_H

/*
  [}Eȕϊ̏
  Satofumi KAMIMURA
  $Id$
*/

#include <SDL.h>


enum ConvertClass {
  CONVERT_BUFFER_SIZE = 26,
  ROMAN_CONVERT,
  KANA_CONVERT,

  TBL_PTN_SIZE = 5,
};


// ϊNX
class Convert {
  Uint16 convertBuffer[CONVERT_BUFFER_SIZE+1];
  int lastPosition;
  const Uint16 *convertTbl;

  void init(int convertType);
  void matchedReplace(int pos_index, int length, int tbl_pos);
  void convert(void);

public:
  Uint16 *getConvertBuffer(void);
  void addChar(char key);
  void deleteLast(void);
  void clearBuffer(void);
  int getBufLen(void);

  Convert(void);
  Convert(int convertType);
  ~Convert(void) {};
};

#endif /* !CONVERT_H */
