﻿#!/usr/bin/ruby -Ku
require 'tk'
require 'tkextlib/bwidget'
require 'rubygems'
require './netlistchecker_main.rb'
#  
##
titlename =  "netlistchecker_v2.0.4"
## akinobu nishi
## ネットリスト比較プログラム
##

$bar_state = 0 # 20120228 add progressbarの状態を示すもの。netlistchecker_mainでカウントアップしている

Tk.root.geometry('1000x700-5+5') 
Tk.root.maxsize(400,200) 

window = TkRoot.new {
   title titlename
   resizable [0,0]
}

x_1 = 20

x_ref = x_1
y_ref = 10

## リファレンスとなるデータ（.net,.asc）を選択
label = TkLabel.new {
  text "input reference file ex) test.net,test.asc"
}.place('x' => x_ref, 'y' => y_ref)
x_ref += 0
y_ref += 20
entry_ref = TkEntry.new {
	self.value = "data/test.net"
	width 40
}.place('x' => x_ref, 'y' => y_ref)
x_ref += 260
y_ref += 0
TkButton.new {
  text "Open"
  command { entry_ref.value = Tk.getOpenFile }
}.place('x' => x_ref, 'y' => y_ref)
x_ref = x_1
y_ref += 20
#####

## 比較するデータ（.txt）を選択
label = TkLabel.new {
  text "input compare file ex) test.txt, test.drn" # 
}.place('x' => x_ref, 'y' => y_ref)
x_ref += 0
y_ref += 20
entry_com = TkEntry.new {
	self.value = "data/test.txt"
	width 40
}.place('x' => x_ref, 'y' => y_ref)
x_ref += 260
y_ref += 0
TkButton.new {
  text "Open"
  command { entry_com.value = Tk.getOpenFile }
}.place('x' => x_ref, 'y' => y_ref)
x_ref = x_1
y_ref += 20
#####

#####


TkButton.new {
  text "実行"
  command { 
	begin
		File.open(entry_ref.value,"r")
		File.open(entry_com.value,"r")
		name_check = 1
	rescue
		TkWarning.new("ファイルが存在しません").value
		name_check = 0
	end
	if(name_check == 1)
		my_NetCheck = NetCheck.new
		my_NetCheck.ref_name(entry_ref.value)
		my_NetCheck.com_name(entry_com.value)
		my_NetCheck.run
		Tk.messageBox("type"=>"ok", "title"=>"ネットリストチェック完了", "message"=>"diff_out.txtが出力されました")
	end
  }
}.place('x' => x_ref, 'y' => y_ref)
x_ref += 0
y_ref += 40

$progressBar = Tk::BWidget::ProgressBar.new(window) {
	self.variable = TkVariable.new
	self.variable.value = $bar_state
	self.maximum = 100
#  pack('side' => 'left','fill' => 'x','expand' => true)
}.place('height' => 25,
                  'width'  => 100,
                  'x'      => x_ref,
                  'y'      => y_ref)


Tk.mainloop

