/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.Splitter;

public class PDFSplit {
    private static final String PASSWORD = "-password";
    private static final String SPLIT = "-split";

    private PDFSplit() {
    }

    public static void main(String[] args) throws Exception {
        PDFSplit split = new PDFSplit();
        split.split(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void split(String[] args) throws Exception {
        PDDocument doc;
        int i;
        List<PDDocument> documents;
        PDDocument document;
        block18: {
            String password = "";
            String split = "1";
            Splitter splitter = new Splitter();
            String pdfFile = null;
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].equals(PASSWORD)) {
                    if (++i2 >= args.length) {
                        PDFSplit.usage();
                    }
                    password = args[i2];
                    continue;
                }
                if (args[i2].equals(SPLIT)) {
                    if (++i2 >= args.length) {
                        PDFSplit.usage();
                    }
                    split = args[i2];
                    continue;
                }
                if (pdfFile != null) continue;
                pdfFile = args[i2];
            }
            if (pdfFile == null) {
                PDFSplit.usage();
                return;
            }
            FileInputStream input = null;
            document = null;
            documents = null;
            try {
                input = new FileInputStream(pdfFile);
                document = PDFSplit.parseDocument(input);
                if (document.isEncrypted()) {
                    try {
                        document.decrypt(password);
                    }
                    catch (InvalidPasswordException e) {
                        if (args.length == 4) {
                            System.err.println("Error: The supplied password is incorrect.");
                            System.exit(2);
                        }
                        System.err.println("Error: The document is encrypted.");
                        PDFSplit.usage();
                    }
                }
                splitter.setSplitAtPage(Integer.parseInt(split));
                documents = splitter.split(document);
                for (i = 0; i < documents.size(); ++i) {
                    doc = documents.get(i);
                    String fileName = pdfFile.substring(0, pdfFile.length() - 4) + "-" + i + ".pdf";
                    PDFSplit.writeDocument(doc, fileName);
                    doc.close();
                }
                if (input == null) break block18;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    ((InputStream)input).close();
                }
                if (document != null) {
                    document.close();
                }
                for (int i3 = 0; documents != null && i3 < documents.size(); ++i3) {
                    PDDocument doc2 = (PDDocument)documents.get(i3);
                    doc2.close();
                }
                throw throwable;
            }
            ((InputStream)input).close();
        }
        if (document != null) {
            document.close();
        }
        for (i = 0; documents != null && i < documents.size(); ++i) {
            doc = documents.get(i);
            doc.close();
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeDocument(PDDocument doc, String fileName) throws IOException, COSVisitorException {
        FileOutputStream output = null;
        COSWriter writer = null;
        try {
            output = new FileOutputStream(fileName);
            writer = new COSWriter(output);
            writer.write(doc);
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static PDDocument parseDocument(InputStream input) throws IOException {
        PDFParser parser = new PDFParser(input);
        parser.parse();
        return parser.getPDDocument();
    }

    private static void usage() {
        System.err.println("Usage: java -jar pdfbox-app-x.y.z.jar PDFSplit [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -split     <integer>         split after this many pages\n  <PDF file>                   The PDF document to use\n");
        System.exit(1);
    }
}

