/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.xml;

import cx.fbn.nevernote.xml.EnmlException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLNoteRepairHandler
extends DefaultHandler {
    private final Vector<String> tagQueue;
    private final Vector<String> xml = new Vector();

    public XMLNoteRepairHandler() {
        this.tagQueue = new Vector();
    }

    public void setXml(String x) {
        String val = x.toString().replace("<HR>", "<hr/>");
        val = val.replace("<hr>", "<hr/>");
        val = val.replace("</HR>", "");
        x = val.replace("</hr>", "");
        x = x.replace("//>", "/>");
        x = x.replace("<br/></br>", "<br/>");
        int pos = 0;
        while (pos > -1) {
            String line;
            pos = x.indexOf(10);
            if (pos > -1) {
                line = new String(x.substring(0, pos));
                x = x.substring(pos + 1);
            } else {
                line = x;
            }
            this.xml.add(line);
        }
    }

    public String getXml() {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.xml.size()) {
            b.append(this.xml.get(i));
            if (i < this.xml.size() - 1) {
                b.append('\n');
            }
            ++i;
        }
        return b.toString();
    }

    public void reset() {
        this.tagQueue.clear();
    }

    public void stripAttribute(String attribute, int line, int column) {
        String repair = new String(this.xml.get(line - 1));
        int pos = column - 1;
        String fragment = repair.substring(0, pos);
        int startPos = fragment.lastIndexOf("<");
        fragment = fragment.substring(startPos);
        int attributeStart = fragment.indexOf(attribute) - 1;
        int endPos = fragment.indexOf("\"", attributeStart + 1);
        if ((endPos = fragment.indexOf("\"", endPos + 1) + 1) == -1) {
            endPos = fragment.length() - 1;
        }
        String repairedFragment = String.valueOf(fragment.substring(0, attributeStart)) + fragment.substring(endPos);
        repair = String.valueOf(repair.substring(0, startPos)) + repairedFragment + repair.substring(column - 1);
        this.xml.set(line - 1, repair);
    }

    public void renameElement(String element, int line, int column) {
        int i = 0;
        while (i < this.xml.size()) {
            String value = this.xml.get(i);
            value = value.replace("<" + element, "<span");
            value = value.replace("</" + element, "</span");
            this.xml.set(i, value);
            ++i;
        }
    }

    public String repair(int line, int column) {
        StringBuffer repair = new StringBuffer(this.xml.get(line - 1));
        int pos = column - 1;
        if (pos > 0) {
            int i = pos;
            while (i >= 0) {
                if (repair.charAt(i) == '<') {
                    pos = i;
                    i = -1;
                }
                --i;
            }
            if (pos > 0) {
                repair.insert(pos, "</" + this.tagQueue.get(this.tagQueue.size() - 1) + ">");
            }
            this.xml.remove(line - 1);
            this.xml.add(line - 1, repair.toString());
        }
        return this.getXml();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.tagQueue.add(qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String endVal = this.tagQueue.lastElement();
        if (endVal.equals(qName)) {
            this.tagQueue.remove(this.tagQueue.size() - 1);
        }
    }

    @Override
    public void error(SAXParseException e) throws EnmlException {
        Exception exception = new Exception();
        EnmlException e1 = new EnmlException(e.getMessage(), e.getPublicId(), e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), exception);
        throw e1;
    }

    @Override
    public void warning(SAXParseException e) throws SAXParseException {
        System.out.println("---------- WARNING ------------- ");
        throw e;
    }
}

