/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import com.evernote.edam.type.QueryFormat;
import com.evernote.edam.type.SavedSearch;
import com.trolltech.qt.core.QBuffer;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QPixmap;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.DeletedTable;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SavedSearchTable {
    private final ApplicationLogger logger;
    private final DatabaseConnection db;

    public SavedSearchTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.HIGH, "Creating table SavedSearch...");
        if (!query.exec("Create table SavedSearch (guid varchar primary key, name varchar, query varchar, format integer, sequence integer, isDirty boolean)")) {
            this.logger.log(this.logger.HIGH, "Table SavedSearch creation FAILED!!!");
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Drop table SavedSearch");
    }

    public List<SavedSearch> getAll() {
        ArrayList<SavedSearch> index = new ArrayList<SavedSearch>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid, name, query, format, sequence from SavedSearch");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "SavedSearch SQL retrieve has failed in getAll().");
        }
        while (query.next()) {
            SavedSearch tempSearch = new SavedSearch();
            tempSearch.setGuid(query.valueString(0));
            tempSearch.setName(query.valueString(1));
            tempSearch.setQuery(query.valueString(2));
            int fmt = new Integer(query.valueString(3));
            if (fmt == 1) {
                tempSearch.setFormat(QueryFormat.USER);
            } else {
                tempSearch.setFormat(QueryFormat.SEXP);
            }
            int sequence = new Integer(query.valueString(4));
            tempSearch.setUpdateSequenceNum(sequence);
            index.add(tempSearch);
        }
        return index;
    }

    public SavedSearch getSavedSearch(String guid) {
        SavedSearch tempSearch = null;
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select guid, name, query, format, sequence from SavedSearch where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "SavedSearch SQL prepare has failed in getSavedSearch.");
        }
        query.bindValue(":guid", guid);
        query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "SavedSearch SQL retrieve has failed in getSavedSearch.");
        }
        if (query.next()) {
            tempSearch = new SavedSearch();
            tempSearch.setGuid(query.valueString(0));
            tempSearch.setName(query.valueString(1));
            tempSearch.setQuery(query.valueString(2));
            int fmt = new Integer(query.valueString(3));
            if (fmt == 1) {
                tempSearch.setFormat(QueryFormat.USER);
            } else {
                tempSearch.setFormat(QueryFormat.SEXP);
            }
            int sequence = new Integer(query.valueInteger(4));
            tempSearch.setUpdateSequenceNum(sequence);
        }
        return tempSearch;
    }

    public void updateSavedSearch(SavedSearch search, boolean isDirty) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update SavedSearch set sequence=:sequence, name=:name, isDirty=:isDirty, query=:query, format=:format where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "SavedSearch SQL update prepare has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError().toString());
        }
        query.bindValue(":sequence", search.getUpdateSequenceNum());
        query.bindValue(":name", search.getName());
        query.bindValue(":isDirty", isDirty);
        query.bindValue(":query", search.getQuery());
        if (search.getFormat() == QueryFormat.USER) {
            query.bindValue(":format", 1);
        } else {
            query.bindValue(":format", 2);
        }
        query.bindValue(":guid", search.getGuid());
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Tag Table update failed.");
            this.logger.log(this.logger.EXTREME, query.lastError().toString());
        }
    }

    public void expungeSavedSearch(String guid, boolean needsSync) {
        SavedSearch s = this.getSavedSearch(guid);
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("delete from SavedSearch where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "SavedSearch SQL delete prepare has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError().toString());
        }
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Saved Search delete failed.");
            this.logger.log(this.logger.EXTREME, query.lastError().toString());
        }
        if (needsSync && s != null && s.getUpdateSequenceNum() > 0) {
            DeletedTable del = new DeletedTable(this.logger, this.db);
            del.addDeletedItem(guid, "SavedSearch");
        }
    }

    public void addSavedSearch(SavedSearch search, boolean isDirty) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Insert Into SavedSearch (guid, query, sequence, format, name, isDirty) Values(:guid, :query, :sequence, :format, :name, :isDirty)");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Search SQL insert prepare has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError().toString());
        }
        query.bindValue(":guid", search.getGuid());
        query.bindValue(":query", search.getQuery());
        query.bindValue(":sequence", search.getUpdateSequenceNum());
        if (search.getFormat() == QueryFormat.USER) {
            query.bindValue(":format", 1);
        } else {
            query.bindValue(":format", 2);
        }
        query.bindValue(":name", search.getName());
        query.bindValue(":isDirty", isDirty);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Search Table insert failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError().toString());
        }
    }

    public void updateSavedSearchSequence(String guid, int sequence) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update SavedSearch set sequence=:sequence where guid=:guid");
        query.bindValue(":sequence", sequence);
        query.bindValue(":guid", guid);
        query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "SavedSearch sequence update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void updateSavedSearchGuid(String oldGuid, String newGuid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update SavedSearch set guid=:newGuid where guid=:oldGuid");
        query.bindValue(":newGuid", newGuid);
        query.bindValue(":oldGuid", oldGuid);
        query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "SavedSearch guid update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public List<SavedSearch> getDirty() {
        ArrayList<SavedSearch> index = new ArrayList<SavedSearch>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid, query, sequence, name, format from SavedSearch where isDirty = true");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "SavedSearch getDirty prepare has failed.");
        }
        while (query.next()) {
            SavedSearch search = new SavedSearch();
            search.setGuid(query.valueString(0));
            search.setQuery(query.valueString(1));
            int sequence = new Integer(query.valueString(2));
            search.setUpdateSequenceNum(sequence);
            search.setName(query.valueString(3));
            int fmt = new Integer(query.valueString(4));
            if (fmt == 1) {
                search.setFormat(QueryFormat.USER);
            } else {
                search.setFormat(QueryFormat.SEXP);
            }
            index.add(search);
        }
        return index;
    }

    public String findSavedSearchByName(String name) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid from SavedSearch where name=:name");
        query.bindValue(":name", name);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "SavedSearch SQL retrieve has failed in findSavedSearchByName().");
        }
        String val = null;
        if (query.next()) {
            val = query.valueString(0);
        }
        return val;
    }

    public boolean exists(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid from SavedSearch where guid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "SavedSearch SQL retrieve has failed in exists().");
        }
        boolean retval = query.next();
        return retval;
    }

    public void syncSavedSearch(SavedSearch search, boolean isDirty) {
        if (this.exists(search.getGuid())) {
            this.updateSavedSearch(search, isDirty);
        } else {
            this.addSavedSearch(search, isDirty);
        }
    }

    public void resetDirtyFlag(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update SavedSearch set isdirty=false where guid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error resetting SavedSearch dirty field in resetDirtyFlag().");
        }
    }

    public QIcon getIcon(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Select icon from SavedSearch where guid=:guid")) {
            this.logger.log(this.logger.EXTREME, "Error preparing saved search icon select.");
        }
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error finding saved search icon.");
        }
        if (!query.next() || query.getBlob(0) == null) {
            return null;
        }
        QByteArray blob = new QByteArray(query.getBlob(0));
        QIcon icon = new QIcon(QPixmap.fromImage((QImage)QImage.fromData((QByteArray)blob)));
        return icon;
    }

    public void setIcon(String guid, QIcon icon, String type) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (icon == null) {
            if (!query.prepare("update SavedSearch set icon=null where guid=:guid")) {
                this.logger.log(this.logger.EXTREME, "Error preparing saved search icon set.");
            }
        } else {
            QBuffer buffer;
            if (!query.prepare("update SavedSearch set icon=:icon where guid=:guid")) {
                this.logger.log(this.logger.EXTREME, "Error preparing tag icon set.");
            }
            if (!(buffer = new QBuffer()).open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadWrite})) {
                this.logger.log(this.logger.EXTREME, "Failure to open buffer.  Aborting.");
                return;
            }
            QPixmap p = icon.pixmap(32, 32);
            QImage i = p.toImage();
            i.save((QIODevice)buffer, type.toUpperCase());
            buffer.close();
            QByteArray b = new QByteArray(buffer.buffer());
            if (!b.isNull() && !b.isEmpty()) {
                query.bindValue(":icon", b.toByteArray());
            } else {
                return;
            }
        }
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.LOW, "Error setting SavedSearch icon. " + query.lastError());
        }
    }

    public HashMap<String, QIcon> getAllIcons() {
        HashMap<String, QIcon> values = new HashMap<String, QIcon>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.exec("SELECT guid, icon from SavedSearch")) {
            this.logger.log(this.logger.EXTREME, "Error executing SavedSearch getAllIcons select.");
        }
        while (query.next()) {
            if (query.getBlob(1) == null) continue;
            String guid = query.valueString(0);
            QByteArray blob = new QByteArray(query.getBlob(1));
            QIcon icon = new QIcon(QPixmap.fromImage((QImage)QImage.fromData((QByteArray)blob)));
            values.put(guid, icon);
        }
        return values;
    }
}

