/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.trolltech.qt.core.QObject;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QMenuBar;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.NeverNote;
import cx.fbn.nevernote.gui.BrowserWindow;

public class MainMenuBar
extends QMenuBar {
    private final NeverNote parent;
    public QAction printAction;
    public QAction connectAction;
    public QAction fullReindexAction;
    public QAction synchronizeAction;
    public QAction selectiveSyncAction;
    public QAction settingsAction;
    public QAction emailAction;
    public QAction backupAction;
    public QAction restoreAction;
    public QAction emptyTrashAction;
    public QAction exitAction;
    public QAction aboutAction;
    public QAction checkForUpdates;
    public QAction loggerAction;
    public QAction releaseAction;
    public QAction noteAdd;
    public QAction noteAttributes;
    public QAction noteTags;
    public QAction noteDelete;
    public QAction noteRestoreAction;
    public QAction noteReindex;
    public QAction noteDuplicateAction;
    public QAction noteMergeAction;
    public QAction noteExportAction;
    public QAction noteImportAction;
    public QAction noteCopyAsUrlAction;
    public QAction noteOpenNewTab;
    public QAction noteAddNewTab;
    public QAction editFind;
    public QAction editUndo;
    public QAction editRedo;
    public QAction editCut;
    public QAction editPaste;
    public QAction editPasteWithoutFormat;
    public QAction editCopy;
    public QAction wideListView;
    public QAction narrowListView;
    public QAction thumbnailView;
    public QAction hideSavedSearches;
    public QAction hideZoom;
    public QAction hideSearch;
    public QAction hideQuota;
    public QAction hideNotebooks;
    public QAction hideTags;
    public QAction hideAttributes;
    public QAction hideTrash;
    public QAction hideNoteList;
    public QAction showEditorBar;
    public QAction hideLeftSide;
    public QAction viewSource;
    public QAction formatBold;
    public QAction formatItalic;
    public QAction formatUnderline;
    public QAction formatStrikethrough;
    public QAction formatSuperscript;
    public QAction formatSubscript;
    public QAction formatNumberList;
    public QAction formatBulletList;
    public QAction alignLeftAction;
    public QAction alignRightAction;
    public QAction alignCenterAction;
    public QAction horizontalLineAction;
    public QAction indentAction;
    public QAction outdentAction;
    public QAction noteOnlineHistoryAction;
    public QAction accountAction;
    public QAction disableIndexing;
    public QAction databaseStatusAction;
    public QAction folderImportAction;
    public QAction spellCheckAction;
    public QAction encryptDatabaseAction;
    public QAction notebookEditAction;
    public QAction notebookAddAction;
    public QAction notebookDeleteAction;
    public QAction notebookPublishAction;
    public QAction notebookShareAction;
    public QAction notebookCloseAction;
    public QAction notebookIconAction;
    public QAction notebookStackAction;
    public QAction savedSearchAddAction;
    public QAction savedSearchEditAction;
    public QAction savedSearchDeleteAction;
    public QAction savedSearchIconAction;
    public QAction tagEditAction;
    public QAction tagAddAction;
    public QAction tagDeleteAction;
    public QAction tagIconAction;
    public QAction tagMergeAction;
    private QMenu fileMenu;
    private QMenu noteMenu;
    private QMenu notebookMenu;
    private QMenu tagMenu;
    private QMenu savedSearchMenu;
    private QMenu editMenu;
    private QMenu formatMenu;
    private QMenu viewMenu;
    private QMenu listMenu;
    private QMenu indentMenu;
    private QMenu alignMenu;
    private QMenu toolsMenu;
    private QMenu helpMenu;
    private QMenu tableMenu;
    private QMenu imageMenu;
    private BrowserWindow prevBW;

    public MainMenuBar(NeverNote p) {
        this.parent = p;
        this.prevBW = this.parent.browserWindow;
        this.fullReindexAction = new QAction(this.tr("Reindex Database"), (QObject)this);
        this.fullReindexAction.setToolTip(this.tr("Reindex all notes"));
        this.fullReindexAction.triggered.connect((Object)this.parent, "fullReindex()");
        this.setupShortcut(this.fullReindexAction, "Tools_Reindex_Database");
        this.printAction = new QAction(this.tr("Print"), (QObject)this);
        this.printAction.setToolTip(this.tr("Print the current note"));
        this.printAction.triggered.connect((Object)this.parent, "printNote()");
        this.setupShortcut(this.printAction, "File_Print");
        this.emailAction = new QAction(this.tr("Email"), (QObject)this);
        this.emailAction.setToolTip(this.tr("Email the current note"));
        this.emailAction.triggered.connect((Object)this.parent, "emailNote()");
        this.setupShortcut(this.emailAction, "File_Email");
        this.backupAction = new QAction(this.tr("Backup Database"), (QObject)this);
        this.backupAction.setToolTip(this.tr("Backup the current database"));
        this.backupAction.triggered.connect((Object)this.parent, "databaseBackup()");
        this.setupShortcut(this.backupAction, "File_Backup");
        this.restoreAction = new QAction(this.tr("Restore Database"), (QObject)this);
        this.restoreAction.setToolTip(this.tr("Restore the database from a backup"));
        this.restoreAction.triggered.connect((Object)this.parent, "databaseRestore()");
        this.setupShortcut(this.restoreAction, "File_Restore");
        this.emptyTrashAction = new QAction(this.tr("Empty Trash"), (QObject)this);
        this.emptyTrashAction.setToolTip(this.tr("Empty the trash folder"));
        this.emptyTrashAction.triggered.connect((Object)this.parent, "emptyTrash()");
        this.setupShortcut(this.emptyTrashAction, "File_Empty_Trash");
        this.noteRestoreAction = new QAction(this.tr("Restore"), (QObject)this);
        this.noteRestoreAction.setToolTip(this.tr("Restore a deleted file from the trash"));
        this.noteRestoreAction.triggered.connect((Object)this.parent, "restoreNote()");
        this.noteRestoreAction.setVisible(false);
        this.setupShortcut(this.noteRestoreAction, "File_Note_Restore");
        this.settingsAction = new QAction(this.tr("Preferences"), (QObject)this);
        this.settingsAction.setToolTip(this.tr("Program settings"));
        this.settingsAction.triggered.connect((Object)this.parent, "settings()");
        this.setupShortcut(this.settingsAction, "Edit_Preferences");
        this.exitAction = new QAction(this.tr("Exit"), (QObject)this);
        this.exitAction.setToolTip(this.tr("Close the program"));
        this.exitAction.triggered.connect((Object)this.parent, "closeNeverNote()");
        this.exitAction.setShortcut("Ctrl+Q");
        this.setupShortcut(this.exitAction, "File_Exit");
        this.noteAttributes = new QAction(this.tr("Extended Information"), (QObject)this);
        this.noteAttributes.setToolTip(this.tr("Show/Hide extended note attributes"));
        this.noteAttributes.triggered.connect((Object)this.parent, "toggleNoteInformation()");
        this.noteAttributes.setShortcut("F8");
        this.setupShortcut(this.noteAttributes, "View_Extended_Information");
        this.noteReindex = new QAction(this.tr("Reindex"), (QObject)this);
        this.noteReindex.setToolTip(this.tr("Reindex this note"));
        this.noteReindex.triggered.connect((Object)this.parent, "reindexNote()");
        this.setupShortcut(this.noteReindex, "File_Note_Reindex");
        this.noteDuplicateAction = new QAction(this.tr("Duplicate"), (QObject)this);
        this.noteDuplicateAction.setToolTip(this.tr("Duplicate this note"));
        this.noteDuplicateAction.triggered.connect((Object)this.parent, "duplicateNote()");
        this.setupShortcut(this.noteDuplicateAction, "File_Note_Duplicate");
        this.noteMergeAction = new QAction(this.tr("Merge Notes"), (QObject)this);
        this.noteMergeAction.setToolTip(this.tr("Merge Multiple notes"));
        this.noteMergeAction.triggered.connect((Object)this.parent, "mergeNotes()");
        this.setupShortcut(this.noteMergeAction, "File_Note_Merge");
        this.noteExportAction = new QAction(this.tr("Export Selected Notes"), (QObject)this);
        this.noteExportAction.setToolTip(this.tr("Export selected notes"));
        this.noteExportAction.triggered.connect((Object)this.parent, "exportNotes()");
        this.setupShortcut(this.noteExportAction, "File_Note_Export");
        this.noteCopyAsUrlAction = new QAction(this.tr("Copy as URL"), (QObject)this);
        this.noteCopyAsUrlAction.setToolTip(this.tr("Copy as URL"));
        this.noteCopyAsUrlAction.triggered.connect((Object)this.parent, "copyAsUrlClicked()");
        this.setupShortcut(this.noteCopyAsUrlAction, "Note_Copy_As_Url");
        this.noteImportAction = new QAction(this.tr("Import Notes"), (QObject)this);
        this.noteImportAction.setToolTip(this.tr("Import notes"));
        this.noteImportAction.triggered.connect((Object)this.parent, "importNotes()");
        this.setupShortcut(this.noteImportAction, "File_Note_Import");
        this.noteAdd = new QAction(this.tr("Add"), (QObject)this);
        this.noteAdd.setToolTip(this.tr("Add a new note"));
        this.noteAdd.triggered.connect((Object)this.parent, "addNote()");
        this.setupShortcut(this.noteAdd, "File_Note_Add");
        this.noteTags = new QAction(this.tr("Modify Tags"), (QObject)this);
        this.noteTags.setToolTip(this.tr("Change the tags assigned to this note"));
        this.noteTags.triggered.connect((Object)this.parent.browserWindow, "modifyTags()");
        this.setupShortcut(this.noteTags, "File_Note_Modify_Tags");
        this.noteDelete = new QAction(this.tr("Delete"), (QObject)this);
        this.noteDelete.setToolTip(this.tr("Delete this note"));
        this.noteDelete.triggered.connect((Object)this.parent, "deleteNote()");
        this.setupShortcut(this.noteDelete, "File_Note_Delete");
        this.noteOpenNewTab = new QAction(this.tr("Open in New Tab"), (QObject)this);
        this.noteOpenNewTab.setToolTip(this.tr("Open this note in new tab"));
        this.noteOpenNewTab.triggered.connect((Object)this.parent, "openNewTab()");
        this.setupShortcut(this.noteOpenNewTab, "File_Note_Open_New_Tab");
        this.noteAddNewTab = new QAction(this.tr("Add in New Tab"), (QObject)this);
        this.noteAddNewTab.setToolTip(this.tr("Add a new note in new tab"));
        this.noteAddNewTab.triggered.connect((Object)this.parent, "noteAddNewTab()");
        this.setupShortcut(this.noteAddNewTab, "File_Note_Add_New_Tab");
        this.editFind = new QAction(this.tr("Find In Note"), (QObject)this);
        this.editFind.setToolTip(this.tr("Find a string in the current note"));
        this.editFind.triggered.connect((Object)this.parent, "findText()");
        this.setupShortcut(this.editFind, "Edit_Find_In_Note");
        this.editUndo = new QAction(this.tr("Undo"), (QObject)this);
        this.editUndo.setToolTip(this.tr("Undo"));
        this.editUndo.triggered.connect((Object)this.parent.browserWindow, "undoClicked()");
        this.setupShortcut(this.editUndo, "Edit_Undo");
        this.editRedo = new QAction(this.tr("Redo"), (QObject)this);
        this.editRedo.setToolTip(this.tr("Redo"));
        this.editRedo.triggered.connect((Object)this.parent.browserWindow, "redoClicked()");
        this.setupShortcut(this.editRedo, "Edit_Redo");
        this.editCut = new QAction(this.tr("Cut"), (QObject)this);
        this.editCut.setToolTip(this.tr("Cut"));
        this.editCut.triggered.connect((Object)this.parent.browserWindow, "cutClicked()");
        this.setupShortcut(this.editCut, "Edit_Cut");
        this.editCopy = new QAction(this.tr("Copy"), (QObject)this);
        this.editCopy.setToolTip(this.tr("Copy"));
        this.editCopy.triggered.connect((Object)this.parent.browserWindow, "copyClicked()");
        this.setupShortcut(this.editCopy, "Edit_Copy");
        this.editPaste = new QAction(this.tr("Paste"), (QObject)this);
        this.editPaste.setToolTip(this.tr("Paste"));
        this.editPaste.triggered.connect((Object)this.parent.browserWindow, "pasteClicked()");
        this.setupShortcut(this.editPaste, "Edit_Paste");
        this.editPasteWithoutFormat = new QAction(this.tr("Paste Without Formatting"), (QObject)this);
        this.editPasteWithoutFormat.setToolTip(this.tr("Paste Without Formatting"));
        this.editPasteWithoutFormat.triggered.connect((Object)this.parent.browserWindow, "pasteWithoutFormattingClicked()");
        this.setupShortcut(this.editPasteWithoutFormat, "Edit_Paste_Without_Formatting");
        this.hideNoteList = new QAction(this.tr("Show Note List"), (QObject)this);
        this.hideNoteList.setToolTip(this.tr("Show/Hide Note List"));
        this.hideNoteList.triggered.connect((Object)this.parent, "toggleNoteListWindow()");
        this.hideNoteList.setCheckable(true);
        this.hideNoteList.setChecked(true);
        this.setupShortcut(this.hideNoteList, "View_Show_Note_List");
        this.hideTags = new QAction(this.tr("Show Tags"), (QObject)this);
        this.hideTags.setToolTip(this.tr("Show/Hide Tags"));
        this.hideTags.triggered.connect((Object)this.parent, "toggleTagWindow()");
        this.hideTags.setCheckable(true);
        this.hideTags.setChecked(true);
        this.setupShortcut(this.hideTags, "View_Show_Tags");
        this.hideNotebooks = new QAction(this.tr("Show Notebooks"), (QObject)this);
        this.hideNotebooks.setToolTip(this.tr("Show/Hide Notebooks"));
        this.hideNotebooks.triggered.connect((Object)this.parent, "toggleNotebookWindow()");
        this.hideNotebooks.setCheckable(true);
        this.hideNotebooks.setChecked(true);
        this.setupShortcut(this.hideNotebooks, "View_Show_Notebooks");
        this.hideZoom = new QAction(this.tr("Show Zoom"), (QObject)this);
        this.hideZoom.setToolTip(this.tr("Show/Hide Zoom"));
        this.hideZoom.triggered.connect((Object)this.parent, "toggleZoomWindow()");
        this.hideZoom.setCheckable(true);
        this.hideZoom.setChecked(true);
        this.setupShortcut(this.hideZoom, "View_Show_Zoom");
        this.hideQuota = new QAction(this.tr("Show Quota Bar"), (QObject)this);
        this.hideQuota.setToolTip(this.tr("Show/Hide Quota"));
        this.hideQuota.triggered.connect((Object)this.parent, "toggleQuotaWindow()");
        this.hideQuota.setCheckable(true);
        this.hideQuota.setChecked(true);
        this.setupShortcut(this.hideQuota, "View_Show_Quota");
        this.hideSearch = new QAction(this.tr("Show Search Box"), (QObject)this);
        this.hideSearch.setToolTip(this.tr("Show/Hide Search Box"));
        this.hideSearch.triggered.connect((Object)this.parent, "toggleSearchWindow()");
        this.hideSearch.setCheckable(true);
        this.hideSearch.setChecked(true);
        this.setupShortcut(this.hideSearch, "View_Show_Search");
        this.wideListView = new QAction(this.tr("Wide List View"), (QObject)this);
        this.wideListView.setToolTip(this.tr("Wide List View"));
        this.wideListView.setCheckable(true);
        this.wideListView.changed.connect((Object)this.parent, "wideListView()");
        this.setupShortcut(this.wideListView, "View_Wide_List");
        this.narrowListView = new QAction(this.tr("Narrow List View"), (QObject)this);
        this.narrowListView.setToolTip(this.tr("Narrow List View"));
        this.narrowListView.setCheckable(true);
        this.narrowListView.changed.connect((Object)this.parent, "narrowListView()");
        this.setupShortcut(this.narrowListView, "View_Narrow_List");
        this.thumbnailView = new QAction(this.tr("Preview"), (QObject)this);
        this.thumbnailView.setToolTip(this.tr("Preview Notes"));
        this.thumbnailView.triggered.connect((Object)this.parent, "thumbnailView()");
        this.setupShortcut(this.thumbnailView, "View_Thumbnail");
        this.hideSavedSearches = new QAction(this.tr("Show Saved Searches"), (QObject)this);
        this.hideSavedSearches.setToolTip(this.tr("Show/Hide Saved Searches"));
        this.hideSavedSearches.triggered.connect((Object)this.parent, "toggleSavedSearchWindow()");
        this.hideSavedSearches.setCheckable(true);
        this.hideSavedSearches.setChecked(true);
        this.setupShortcut(this.hideSavedSearches, "View_Show_SavedSearches");
        this.hideAttributes = new QAction(this.tr("Show Attribute Searches"), (QObject)this);
        this.hideAttributes.setToolTip(this.tr("Show/Hide Attribute Searches"));
        this.hideAttributes.triggered.connect((Object)this.parent, "toggleAttributesWindow()");
        this.hideAttributes.setCheckable(true);
        this.hideAttributes.setChecked(true);
        this.setupShortcut(this.hideAttributes, "View_Show_Attribute_Searches");
        this.hideTrash = new QAction(this.tr("Show Trash"), (QObject)this);
        this.hideTrash.setToolTip(this.tr("Show/Hide Trash Tree"));
        this.hideTrash.triggered.connect((Object)this.parent, "toggleTrashWindow()");
        this.hideTrash.setCheckable(true);
        this.hideTrash.setChecked(true);
        this.setupShortcut(this.hideTrash, "View_Show_Trash");
        this.showEditorBar = new QAction(this.tr("Show Editor Button Bar"), (QObject)this);
        this.showEditorBar.setToolTip(this.tr("Show/Hide Editor Button Bar"));
        this.showEditorBar.triggered.connect((Object)this.parent, "toggleEditorButtonBar()");
        this.showEditorBar.setCheckable(true);
        this.showEditorBar.setChecked(true);
        this.setupShortcut(this.showEditorBar, "View_Show_Editor_Button_Bar");
        this.hideLeftSide = new QAction(this.tr("Hide Left Side Panels"), (QObject)this);
        this.hideLeftSide.setToolTip(this.tr("Hide The Entire Left Side"));
        this.hideLeftSide.triggered.connect((Object)this.parent, "toggleLeftSide()");
        this.hideLeftSide.setCheckable(true);
        this.hideLeftSide.setChecked(false);
        this.setupShortcut(this.hideLeftSide, "View_Show_Left_Side");
        this.viewSource = new QAction(this.tr("View Source"), (QObject)this);
        this.viewSource.setToolTip(this.tr("View the source HTML for a note"));
        this.viewSource.triggered.connect((Object)this.parent, "viewSource()");
        this.viewSource.setCheckable(true);
        this.viewSource.setChecked(false);
        this.setupShortcut(this.viewSource, "View_Source");
        this.alignLeftAction = new QAction(this.tr("Left"), (QObject)this);
        this.alignLeftAction.setToolTip(this.tr("Left Align"));
        this.alignLeftAction.triggered.connect((Object)this.parent.browserWindow, "justifyLeftClicked()");
        this.setupShortcut(this.alignLeftAction, "Format_Alignment_Left");
        this.alignRightAction = new QAction(this.tr("Right"), (QObject)this);
        this.alignRightAction.setToolTip(this.tr("Right Align"));
        this.alignRightAction.triggered.connect((Object)this.parent.browserWindow, "justifyRightClicked()");
        this.setupShortcut(this.alignRightAction, "Format_Alignment_Right");
        this.alignCenterAction = new QAction(this.tr("Center"), (QObject)this);
        this.alignCenterAction.setToolTip(this.tr("Center Align"));
        this.alignCenterAction.triggered.connect((Object)this.parent.browserWindow, "justifyCenterClicked()");
        this.setupShortcut(this.alignCenterAction, "Format_Alignment_Center");
        this.formatBold = new QAction(this.tr("Bold"), (QObject)this);
        this.formatBold.setToolTip(this.tr("Bold"));
        this.formatBold.triggered.connect((Object)this.parent.browserWindow, "boldClicked()");
        this.setupShortcut(this.formatBold, "Format_Bold");
        this.formatItalic = new QAction(this.tr("Italic"), (QObject)this);
        this.formatItalic.setToolTip(this.tr("Italic"));
        this.formatItalic.triggered.connect((Object)this.parent.browserWindow, "italicClicked()");
        this.setupShortcut(this.formatItalic, "Format_Italic");
        this.formatUnderline = new QAction(this.tr("Underline"), (QObject)this);
        this.formatUnderline.setToolTip(this.tr("Underline"));
        this.formatUnderline.triggered.connect((Object)this.parent.browserWindow, "underlineClicked()");
        this.setupShortcut(this.formatUnderline, "Format_Underline");
        this.formatSuperscript = new QAction(this.tr("Superscript"), (QObject)this);
        this.formatSuperscript.setToolTip(this.tr("Superscript"));
        this.formatSuperscript.triggered.connect((Object)this.parent.browserWindow, "superscriptClicked()");
        this.setupShortcut(this.formatSuperscript, "Format_Superscript");
        this.formatSubscript = new QAction(this.tr("Subscript"), (QObject)this);
        this.formatSubscript.setToolTip(this.tr("Subscript"));
        this.formatSubscript.triggered.connect((Object)this.parent.browserWindow, "subscriptClicked()");
        this.setupShortcut(this.formatSubscript, "Format_Subscript");
        this.formatStrikethrough = new QAction(this.tr("Strikethrough"), (QObject)this);
        this.formatStrikethrough.setToolTip(this.tr("Strikethrough"));
        this.formatStrikethrough.triggered.connect((Object)this.parent.browserWindow, "strikethroughClicked()");
        this.setupShortcut(this.formatStrikethrough, "Format_Strikethrough");
        this.horizontalLineAction = new QAction(this.tr("Horizontal Line"), (QObject)this);
        this.horizontalLineAction.setToolTip(this.tr("Horizontal Line"));
        this.horizontalLineAction.triggered.connect((Object)this.parent.browserWindow, "hlineClicked()");
        this.setupShortcut(this.horizontalLineAction, "Format_Horizontal_Line");
        this.formatBulletList = new QAction(this.tr("Bulleted List"), (QObject)this);
        this.formatBulletList.triggered.connect((Object)this.parent.browserWindow, "bulletListClicked()");
        this.setupShortcut(this.formatBulletList, "Format_List_Bullet");
        this.formatNumberList = new QAction(this.tr("Numbered List"), (QObject)this);
        this.formatNumberList.setText(this.tr("Numbered list"));
        this.formatNumberList.triggered.connect((Object)this.parent.browserWindow, "numberListClicked()");
        this.setupShortcut(this.formatNumberList, "Format_List_Numbered");
        this.indentAction = new QAction(this.tr(">> Increase"), (QObject)this);
        this.indentAction.setText(this.tr(">> Increase"));
        this.indentAction.triggered.connect((Object)this.parent.browserWindow, "indentClicked()");
        this.setupShortcut(this.indentAction, "Format_Indent_Increase");
        this.outdentAction = new QAction(this.tr("<< Decrease"), (QObject)this);
        this.outdentAction.setText(this.tr("<< Decrease"));
        this.outdentAction.triggered.connect((Object)this.parent.browserWindow, "outdentClicked()");
        this.setupShortcut(this.outdentAction, "Format_Indent_Decrease");
        this.notebookAddAction = new QAction(this.tr("Add"), (QObject)this);
        this.notebookAddAction.triggered.connect((Object)this.parent, "addNotebook()");
        this.setupShortcut(this.notebookAddAction, "File_Notebook_Add");
        this.notebookEditAction = new QAction(this.tr("Edit"), (QObject)this);
        this.notebookEditAction.setEnabled(false);
        this.notebookEditAction.triggered.connect((Object)this.parent, "editNotebook()");
        this.setupShortcut(this.notebookEditAction, "File_Notebook_Edit");
        this.notebookDeleteAction = new QAction(this.tr("Delete"), (QObject)this);
        this.notebookDeleteAction.setEnabled(false);
        this.notebookDeleteAction.triggered.connect((Object)this.parent, "deleteNotebook()");
        this.setupShortcut(this.notebookDeleteAction, "File_Notebook_Delete");
        this.notebookPublishAction = new QAction(this.tr("Share With The World"), (QObject)this);
        this.notebookPublishAction.setEnabled(false);
        this.notebookPublishAction.setVisible(false);
        this.notebookPublishAction.triggered.connect((Object)this.parent, "publishNotebook()");
        this.setupShortcut(this.notebookPublishAction, "File_Notebook_Publish");
        this.notebookShareAction = new QAction(this.tr("Share With Individuals"), (QObject)this);
        this.notebookShareAction.setEnabled(false);
        this.notebookShareAction.setVisible(false);
        this.notebookShareAction.triggered.connect((Object)this.parent, "shareNotebook()");
        this.setupShortcut(this.notebookShareAction, "File_Notebook_Share");
        this.notebookCloseAction = new QAction(this.tr("Open/Close Notebooks"), (QObject)this);
        this.notebookCloseAction.setEnabled(true);
        this.notebookCloseAction.triggered.connect((Object)this.parent, "closeNotebooks()");
        this.setupShortcut(this.notebookCloseAction, "File_Notebook_Close");
        this.notebookIconAction = new QAction(this.tr("Change Icon"), (QObject)this);
        this.notebookIconAction.setEnabled(false);
        this.notebookIconAction.triggered.connect((Object)this.parent, "setNotebookIcon()");
        this.setupShortcut(this.notebookIconAction, "File_Notebook_Icon");
        this.notebookStackAction = new QAction(this.tr("Set Stack"), (QObject)this);
        this.notebookStackAction.setEnabled(false);
        this.notebookStackAction.triggered.connect((Object)this.parent, "stackNotebook()");
        this.setupShortcut(this.notebookStackAction, "File_Notebook_Stack");
        this.tagAddAction = new QAction(this.tr("Add"), (QObject)this);
        this.tagAddAction.triggered.connect((Object)this.parent, "addTag()");
        this.setupShortcut(this.tagAddAction, "File_Tag_Add");
        this.tagEditAction = new QAction(this.tr("Edit"), (QObject)this);
        this.tagEditAction.triggered.connect((Object)this.parent, "editTag()");
        this.tagEditAction.setEnabled(false);
        this.setupShortcut(this.tagEditAction, "File_Tag_Edit");
        this.tagDeleteAction = new QAction(this.tr("Delete"), (QObject)this);
        this.tagDeleteAction.triggered.connect((Object)this.parent, "deleteTag()");
        this.tagDeleteAction.setEnabled(false);
        this.setupShortcut(this.tagDeleteAction, "File_Tag_Delete");
        this.tagIconAction = new QAction(this.tr("Change Icon"), (QObject)this);
        this.tagIconAction.triggered.connect((Object)this.parent, "setTagIcon()");
        this.tagIconAction.setEnabled(false);
        this.setupShortcut(this.tagIconAction, "File_Tag_Icon");
        this.tagMergeAction = new QAction(this.tr("Merge Tags"), (QObject)this);
        this.tagMergeAction.triggered.connect((Object)this.parent, "mergeTags()");
        this.tagMergeAction.setEnabled(false);
        this.setupShortcut(this.tagMergeAction, "File_Tag_Merge");
        this.savedSearchAddAction = new QAction(this.tr("Add"), (QObject)this);
        this.savedSearchAddAction.triggered.connect((Object)this.parent, "addSavedSearch()");
        this.setupShortcut(this.savedSearchAddAction, "File_SavedSearch_Add");
        this.savedSearchEditAction = new QAction(this.tr("Edit"), (QObject)this);
        this.savedSearchEditAction.triggered.connect((Object)this.parent, "editSavedSearch()");
        this.savedSearchEditAction.setEnabled(false);
        this.setupShortcut(this.savedSearchEditAction, "File_SavedSearch_Edit");
        this.savedSearchDeleteAction = new QAction(this.tr("Delete"), (QObject)this);
        this.savedSearchDeleteAction.triggered.connect((Object)this.parent, "deleteSavedSearch()");
        this.savedSearchDeleteAction.setEnabled(false);
        this.setupShortcut(this.savedSearchDeleteAction, "File_SavedSearch_Delete");
        this.savedSearchIconAction = new QAction(this.tr("Change Icon"), (QObject)this);
        this.savedSearchIconAction.triggered.connect((Object)this.parent, "setSavedSearchIcon()");
        this.savedSearchIconAction.setEnabled(false);
        this.setupShortcut(this.savedSearchIconAction, "File_SavedSearch_Icon");
        this.connectAction = new QAction(this.tr("Connect"), (QObject)this);
        this.connectAction.setToolTip("Connect to Evernote");
        this.connectAction.triggered.connect((Object)this.parent, "remoteConnect()");
        this.setupShortcut(this.connectAction, "Tools_Connect");
        this.synchronizeAction = new QAction(this.tr("Synchronize with Evernote"), (QObject)this);
        this.synchronizeAction.setToolTip("Delete all local data & get a fresh copy");
        this.synchronizeAction.triggered.connect((Object)this.parent, "evernoteSync()");
        this.synchronizeAction.setEnabled(false);
        this.setupShortcut(this.synchronizeAction, "Tools_Synchronize");
        this.noteOnlineHistoryAction = new QAction(this.tr("Note History"), (QObject)this);
        this.noteOnlineHistoryAction.triggered.connect((Object)this.parent, "viewNoteHistory()");
        this.noteOnlineHistoryAction.setEnabled(false);
        this.setupShortcut(this.noteOnlineHistoryAction, "File_Note_History");
        this.selectiveSyncAction = new QAction(this.tr("Selective Synchronize"), (QObject)this);
        this.selectiveSyncAction.setToolTip("Selectively ignore some notes");
        this.selectiveSyncAction.triggered.connect((Object)this.parent, "setupSelectiveSync()");
        this.selectiveSyncAction.setEnabled(false);
        this.setupShortcut(this.synchronizeAction, "File_Selective_Sync");
        this.accountAction = new QAction(this.tr("Account Information"), (QObject)this);
        this.accountAction.setToolTip(this.tr("Account Information"));
        this.accountAction.triggered.connect((Object)this.parent, "accountInformation()");
        this.setupShortcut(this.accountAction, "Tools_Account_Information");
        this.databaseStatusAction = new QAction(this.tr("Database Status"), (QObject)this);
        this.databaseStatusAction.setToolTip(this.tr("Show current database information"));
        this.databaseStatusAction.triggered.connect((Object)this.parent, "databaseStatus()");
        this.setupShortcut(this.databaseStatusAction, "Tools_Database_Status");
        this.disableIndexing = new QAction(this.tr("Disable Note Indexing"), (QObject)this);
        this.disableIndexing.setToolTip(this.tr("Manually Stop Note Indexing"));
        this.disableIndexing.triggered.connect((Object)this.parent, "toggleNoteIndexing()");
        this.disableIndexing.setCheckable(true);
        this.disableIndexing.setChecked(false);
        this.setupShortcut(this.disableIndexing, "Tools_Disable_Note_Indexing");
        this.folderImportAction = new QAction(this.tr("Automatic Folder Importing"), (QObject)this);
        this.folderImportAction.setToolTip(this.tr("Import Files Automatically"));
        this.folderImportAction.triggered.connect((Object)this.parent, "folderImport()");
        this.setupShortcut(this.folderImportAction, "Tools_Folder_Import");
        this.spellCheckAction = new QAction(this.tr("Spell Check"), (QObject)this);
        this.spellCheckAction.setToolTip(this.tr("Check for spelling errors"));
        this.spellCheckAction.triggered.connect((Object)this.parent.browserWindow, "spellCheckClicked()");
        this.setupShortcut(this.spellCheckAction, "Tools_Spell_Check");
        this.encryptDatabaseAction = new QAction(this.tr("Encrypt Database"), (QObject)this);
        this.encryptDatabaseAction.setToolTip(this.tr("Encrypt the database upon shutdown"));
        this.encryptDatabaseAction.triggered.connect((Object)this.parent, "doDatabaseEncrypt()");
        this.setupShortcut(this.encryptDatabaseAction, "Tools_Database_Encrypt");
        if (Global.cipherPassword != null && Global.cipherPassword != "") {
            this.encryptDatabaseAction.setText("Decrypt Database");
            this.encryptDatabaseAction.setToolTip("Decrypt the database upon shutdown");
        }
        this.loggerAction = new QAction(this.tr("Logs"), (QObject)this);
        this.loggerAction.setToolTip(this.tr("Show the detailed application log"));
        this.loggerAction.triggered.connect((Object)this.parent, "logger()");
        this.setupShortcut(this.loggerAction, "About_Log");
        this.releaseAction = new QAction(this.tr("Release Notes"), (QObject)this);
        this.releaseAction.setToolTip(this.tr("Release notes"));
        this.releaseAction.triggered.connect((Object)this.parent, "releaseNotes()");
        this.setupShortcut(this.releaseAction, "About_Release_Notes");
        this.checkForUpdates = new QAction(this.tr("Check For Updates"), (QObject)this);
        this.checkForUpdates.setToolTip(this.tr("Check for newer versions"));
        this.checkForUpdates.triggered.connect((Object)this.parent, "checkForUpdates()");
        this.setupShortcut(this.checkForUpdates, "Help_Check_For_Updates");
        this.checkForUpdates.setEnabled(true);
        this.aboutAction = new QAction(this.tr("About"), (QObject)this);
        this.aboutAction.setToolTip(this.tr("About NeighborNote"));
        this.aboutAction.triggered.connect((Object)this.parent, "about()");
        this.setupShortcut(this.aboutAction, "About_About");
        this.setupMenuBar();
    }

    public void setupMenuBar() {
        this.fileMenu = this.addMenu(this.tr("&File"));
        this.notebookMenu = this.fileMenu.addMenu(this.tr("Notebook"));
        this.tagMenu = this.fileMenu.addMenu(this.tr("Tag"));
        this.savedSearchMenu = this.fileMenu.addMenu(this.tr("Saved Searches"));
        this.fileMenu.addSeparator();
        this.fileMenu.addAction(this.emailAction);
        this.fileMenu.addAction(this.printAction);
        this.fileMenu.addSeparator();
        this.fileMenu.addAction(this.noteImportAction);
        this.fileMenu.addAction(this.noteExportAction);
        this.fileMenu.addAction(this.backupAction);
        this.fileMenu.addAction(this.restoreAction);
        this.fileMenu.addSeparator();
        this.fileMenu.addAction(this.selectiveSyncAction);
        this.fileMenu.addSeparator();
        this.fileMenu.addAction(this.emptyTrashAction);
        this.fileMenu.addAction(this.exitAction);
        this.editMenu = this.addMenu(this.tr("&Edit"));
        this.editMenu.addAction(this.editFind);
        this.editMenu.addSeparator();
        this.editMenu.addAction(this.editUndo);
        this.editMenu.addAction(this.editRedo);
        this.editMenu.addSeparator();
        this.editMenu.addAction(this.editCut);
        this.editMenu.addAction(this.editCopy);
        this.editMenu.addAction(this.editPaste);
        this.editMenu.addAction(this.editPasteWithoutFormat);
        this.editMenu.addSeparator();
        this.editMenu.addAction(this.settingsAction);
        this.viewMenu = this.addMenu(this.tr("&View"));
        this.viewMenu.addAction(this.noteAttributes);
        this.viewMenu.addAction(this.viewSource);
        this.viewMenu.addSeparator();
        this.viewMenu.addAction(this.wideListView);
        this.viewMenu.addAction(this.narrowListView);
        this.viewMenu.addAction(this.thumbnailView);
        this.viewMenu.addSeparator();
        this.viewMenu.addAction(this.hideNoteList);
        this.viewMenu.addAction(this.hideSearch);
        this.viewMenu.addAction(this.hideQuota);
        this.viewMenu.addAction(this.hideZoom);
        this.viewMenu.addAction(this.hideNotebooks);
        this.viewMenu.addAction(this.hideTags);
        this.viewMenu.addAction(this.hideAttributes);
        this.viewMenu.addAction(this.hideSavedSearches);
        this.viewMenu.addAction(this.hideTrash);
        this.viewMenu.addAction(this.showEditorBar);
        this.viewMenu.addAction(this.hideLeftSide);
        this.noteMenu = this.addMenu(this.tr("&Note"));
        this.formatMenu = this.addMenu(this.tr("F&ormat"));
        this.formatMenu.addAction(this.formatBold);
        this.formatMenu.addAction(this.formatUnderline);
        this.formatMenu.addAction(this.formatItalic);
        this.formatMenu.addSeparator();
        this.formatMenu.addAction(this.formatStrikethrough);
        this.formatMenu.addAction(this.horizontalLineAction);
        this.formatMenu.addSeparator();
        this.formatMenu.addAction(this.formatSuperscript);
        this.formatMenu.addAction(this.formatSubscript);
        this.formatMenu.addSeparator();
        this.formatMenu.addMenu(this.parent.browserWindow.browser.tableMenu);
        this.formatMenu.addMenu(this.parent.browserWindow.browser.imageMenu);
        this.formatMenu.addSeparator();
        this.tableMenu = new QMenu();
        this.tableMenu.setTitle(this.tr("Table"));
        this.tableMenu.addAction(this.parent.browserWindow.browser.insertTableAction);
        this.tableMenu.addAction(this.parent.browserWindow.browser.insertTableRowAction);
        this.tableMenu.addAction(this.parent.browserWindow.browser.insertTableColumnAction);
        this.tableMenu.addAction(this.parent.browserWindow.browser.deleteTableRowAction);
        this.tableMenu.addAction(this.parent.browserWindow.browser.deleteTableColumnAction);
        this.imageMenu = new QMenu();
        this.imageMenu.setTitle(this.tr("Image"));
        this.imageMenu.addAction(this.parent.browserWindow.browser.downloadImage);
        this.imageMenu.addAction(this.parent.browserWindow.browser.rotateImageRight);
        this.imageMenu.addAction(this.parent.browserWindow.browser.rotateImageLeft);
        this.alignMenu = this.formatMenu.addMenu(this.tr("Alignment"));
        this.alignMenu.addAction(this.alignLeftAction);
        this.alignMenu.addAction(this.alignCenterAction);
        this.alignMenu.addAction(this.alignRightAction);
        this.listMenu = this.formatMenu.addMenu(this.tr("Lists"));
        this.listMenu.addAction(this.formatBulletList);
        this.listMenu.addAction(this.formatNumberList);
        this.indentMenu = this.formatMenu.addMenu(this.tr("Indent"));
        this.indentMenu.addAction(this.indentAction);
        this.indentMenu.addAction(this.outdentAction);
        this.noteAttributes.setCheckable(true);
        this.noteMenu.addAction(this.noteOpenNewTab);
        this.noteMenu.addAction(this.noteAdd);
        this.noteMenu.addAction(this.noteAddNewTab);
        this.noteMenu.addAction(this.noteDelete);
        this.noteMenu.addAction(this.noteReindex);
        this.noteMenu.addSeparator();
        this.noteMenu.addAction(this.noteTags);
        this.noteMenu.addAction(this.noteRestoreAction);
        this.noteMenu.addSeparator();
        this.noteMenu.addAction(this.noteOnlineHistoryAction);
        this.noteMenu.addAction(this.noteDuplicateAction);
        this.noteMenu.addAction(this.noteMergeAction);
        this.notebookMenu.addAction(this.notebookAddAction);
        this.notebookMenu.addAction(this.notebookEditAction);
        this.notebookMenu.addAction(this.notebookDeleteAction);
        this.notebookMenu.addSeparator();
        this.notebookMenu.addAction(this.notebookPublishAction);
        this.notebookMenu.addAction(this.notebookShareAction);
        this.notebookMenu.addSeparator();
        this.notebookMenu.addAction(this.notebookStackAction);
        this.notebookMenu.addAction(this.notebookCloseAction);
        this.notebookMenu.addSeparator();
        this.notebookMenu.addAction(this.notebookIconAction);
        this.tagMenu.addAction(this.tagAddAction);
        this.tagMenu.addAction(this.tagEditAction);
        this.tagMenu.addAction(this.tagDeleteAction);
        this.tagMenu.addAction(this.tagMergeAction);
        this.tagMenu.addSeparator();
        this.tagMenu.addAction(this.tagIconAction);
        this.savedSearchMenu.addAction(this.savedSearchAddAction);
        this.savedSearchMenu.addAction(this.savedSearchEditAction);
        this.savedSearchMenu.addAction(this.savedSearchDeleteAction);
        this.savedSearchMenu.addSeparator();
        this.savedSearchMenu.addAction(this.savedSearchIconAction);
        this.toolsMenu = this.addMenu(this.tr("&Tools"));
        this.toolsMenu.addAction(this.synchronizeAction);
        this.toolsMenu.addAction(this.connectAction);
        this.toolsMenu.addSeparator();
        this.toolsMenu.addAction(this.spellCheckAction);
        this.toolsMenu.addAction(this.accountAction);
        this.toolsMenu.addAction(this.fullReindexAction);
        this.toolsMenu.addAction(this.disableIndexing);
        this.toolsMenu.addSeparator();
        this.toolsMenu.addAction(this.encryptDatabaseAction);
        this.toolsMenu.addAction(this.databaseStatusAction);
        this.toolsMenu.addSeparator();
        this.toolsMenu.addAction(this.folderImportAction);
        this.helpMenu = this.addMenu(this.tr("&Help"));
        this.helpMenu.addAction(this.releaseAction);
        this.helpMenu.addAction(this.checkForUpdates);
        this.helpMenu.addAction(this.loggerAction);
        this.helpMenu.addSeparator();
        this.helpMenu.addAction(this.aboutAction);
        this.addMenu(this.fileMenu);
        this.addMenu(this.editMenu);
        this.addMenu(this.viewMenu);
        this.addMenu(this.noteMenu);
        this.addMenu(this.formatMenu);
        this.addMenu(this.toolsMenu);
        this.addMenu(this.helpMenu);
    }

    public void setupToolBarVisible() {
        this.viewMenu.addAction(this.parent.toolBar.toggleViewAction());
        this.setupShortcut(this.parent.toolBar.toggleViewAction(), "View_Toolbar");
    }

    private void setupShortcut(QAction action, String text) {
        if (!Global.shortcutKeys.containsAction(text)) {
            return;
        }
        action.setShortcut(Global.shortcutKeys.getShortcut(text));
    }

    public void refreshTargetWindow() {
        this.noteTags.triggered.disconnect((Object)this.prevBW, "modifyTags()");
        this.editUndo.triggered.disconnect((Object)this.prevBW, "undoClicked()");
        this.editRedo.triggered.disconnect((Object)this.prevBW, "redoClicked()");
        this.editCut.triggered.disconnect((Object)this.prevBW, "cutClicked()");
        this.editCopy.triggered.disconnect((Object)this.prevBW, "copyClicked()");
        this.editPaste.triggered.disconnect((Object)this.prevBW, "pasteClicked()");
        this.editPasteWithoutFormat.triggered.disconnect((Object)this.prevBW, "pasteWithoutFormattingClicked()");
        this.alignLeftAction.triggered.disconnect((Object)this.prevBW, "justifyLeftClicked()");
        this.alignRightAction.triggered.disconnect((Object)this.prevBW, "justifyRightClicked()");
        this.alignCenterAction.triggered.disconnect((Object)this.prevBW, "justifyCenterClicked()");
        this.formatBold.triggered.disconnect((Object)this.prevBW, "boldClicked()");
        this.formatItalic.triggered.disconnect((Object)this.prevBW, "italicClicked()");
        this.formatUnderline.triggered.disconnect((Object)this.prevBW, "underlineClicked()");
        this.formatSuperscript.triggered.disconnect((Object)this.prevBW, "superscriptClicked()");
        this.formatSubscript.triggered.disconnect((Object)this.prevBW, "subscriptClicked()");
        this.formatStrikethrough.triggered.disconnect((Object)this.prevBW, "strikethroughClicked()");
        this.horizontalLineAction.triggered.disconnect((Object)this.prevBW, "hlineClicked()");
        this.formatBulletList.triggered.disconnect((Object)this.prevBW, "bulletListClicked()");
        this.formatNumberList.triggered.disconnect((Object)this.prevBW, "numberListClicked()");
        this.indentAction.triggered.disconnect((Object)this.prevBW, "indentClicked()");
        this.outdentAction.triggered.disconnect((Object)this.prevBW, "outdentClicked()");
        this.spellCheckAction.triggered.disconnect((Object)this.prevBW, "spellCheckClicked()");
        this.noteTags.triggered.connect((Object)this.parent.browserWindow, "modifyTags()");
        this.editUndo.triggered.connect((Object)this.parent.browserWindow, "undoClicked()");
        this.editRedo.triggered.connect((Object)this.parent.browserWindow, "redoClicked()");
        this.editCut.triggered.connect((Object)this.parent.browserWindow, "cutClicked()");
        this.editCopy.triggered.connect((Object)this.parent.browserWindow, "copyClicked()");
        this.editPaste.triggered.connect((Object)this.parent.browserWindow, "pasteClicked()");
        this.editPasteWithoutFormat.triggered.connect((Object)this.parent.browserWindow, "pasteWithoutFormattingClicked()");
        this.alignLeftAction.triggered.connect((Object)this.parent.browserWindow, "justifyLeftClicked()");
        this.alignRightAction.triggered.connect((Object)this.parent.browserWindow, "justifyRightClicked()");
        this.alignCenterAction.triggered.connect((Object)this.parent.browserWindow, "justifyCenterClicked()");
        this.formatBold.triggered.connect((Object)this.parent.browserWindow, "boldClicked()");
        this.formatItalic.triggered.connect((Object)this.parent.browserWindow, "italicClicked()");
        this.formatUnderline.triggered.connect((Object)this.parent.browserWindow, "underlineClicked()");
        this.formatSuperscript.triggered.connect((Object)this.parent.browserWindow, "superscriptClicked()");
        this.formatSubscript.triggered.connect((Object)this.parent.browserWindow, "subscriptClicked()");
        this.formatStrikethrough.triggered.connect((Object)this.parent.browserWindow, "strikethroughClicked()");
        this.horizontalLineAction.triggered.connect((Object)this.parent.browserWindow, "hlineClicked()");
        this.formatBulletList.triggered.connect((Object)this.parent.browserWindow, "bulletListClicked()");
        this.formatNumberList.triggered.connect((Object)this.parent.browserWindow, "numberListClicked()");
        this.indentAction.triggered.connect((Object)this.parent.browserWindow, "indentClicked()");
        this.outdentAction.triggered.connect((Object)this.parent.browserWindow, "outdentClicked()");
        this.spellCheckAction.triggered.connect((Object)this.parent.browserWindow, "spellCheckClicked()");
        this.fileMenu.insertAction(this.prevBW.browser.downloadAttachment, this.parent.browserWindow.browser.downloadAttachment);
        this.formatMenu.insertAction(this.prevBW.browser.todoAction, this.parent.browserWindow.browser.todoAction);
        this.formatMenu.insertAction(this.prevBW.browser.encryptAction, this.parent.browserWindow.browser.encryptAction);
        this.formatMenu.insertAction(this.prevBW.browser.insertLinkAction, this.parent.browserWindow.browser.insertLinkAction);
        this.formatMenu.insertAction(this.prevBW.browser.insertQuickLinkAction, this.parent.browserWindow.browser.insertQuickLinkAction);
        this.formatMenu.insertAction(this.prevBW.browser.insertLatexAction, this.parent.browserWindow.browser.insertLatexAction);
        this.tableMenu.insertAction(this.prevBW.browser.insertTableAction, this.parent.browserWindow.browser.insertTableAction);
        this.tableMenu.insertAction(this.prevBW.browser.insertTableRowAction, this.parent.browserWindow.browser.insertTableRowAction);
        this.tableMenu.insertAction(this.prevBW.browser.insertTableColumnAction, this.parent.browserWindow.browser.insertTableColumnAction);
        this.tableMenu.insertAction(this.prevBW.browser.deleteTableRowAction, this.parent.browserWindow.browser.deleteTableRowAction);
        this.tableMenu.insertAction(this.prevBW.browser.deleteTableColumnAction, this.parent.browserWindow.browser.deleteTableColumnAction);
        this.imageMenu.insertAction(this.prevBW.browser.downloadImage, this.parent.browserWindow.browser.downloadImage);
        this.imageMenu.insertAction(this.prevBW.browser.rotateImageRight, this.parent.browserWindow.browser.rotateImageRight);
        this.imageMenu.insertAction(this.prevBW.browser.rotateImageLeft, this.parent.browserWindow.browser.rotateImageLeft);
        this.fileMenu.removeAction(this.prevBW.browser.downloadAttachment);
        this.formatMenu.removeAction(this.prevBW.browser.todoAction);
        this.formatMenu.removeAction(this.prevBW.browser.encryptAction);
        this.formatMenu.removeAction(this.prevBW.browser.insertLinkAction);
        this.formatMenu.removeAction(this.prevBW.browser.insertQuickLinkAction);
        this.formatMenu.removeAction(this.prevBW.browser.insertLatexAction);
        this.tableMenu.removeAction(this.prevBW.browser.insertTableAction);
        this.tableMenu.removeAction(this.prevBW.browser.insertTableRowAction);
        this.tableMenu.removeAction(this.prevBW.browser.insertTableColumnAction);
        this.tableMenu.removeAction(this.prevBW.browser.deleteTableRowAction);
        this.tableMenu.removeAction(this.prevBW.browser.deleteTableColumnAction);
        this.imageMenu.removeAction(this.prevBW.browser.downloadImage);
        this.imageMenu.removeAction(this.prevBW.browser.rotateImageRight);
        this.imageMenu.removeAction(this.prevBW.browser.rotateImageLeft);
        this.prevBW = this.parent.browserWindow;
    }
}

