/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.core.QEvent;
import com.trolltech.qt.core.QMimeData;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QContextMenuEvent;
import com.trolltech.qt.gui.QDropEvent;
import com.trolltech.qt.gui.QKeyEvent;
import com.trolltech.qt.gui.QKeySequence;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QShortcut;
import com.trolltech.qt.gui.QWidget;
import com.trolltech.qt.network.QNetworkRequest;
import com.trolltech.qt.webkit.QWebPage;
import com.trolltech.qt.webkit.QWebView;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.gui.BrowserWindow;

public class ContentView
extends QWebView {
    BrowserWindow parent;
    QMenu contextMenu = new QMenu((QWidget)this);
    QMenu tableMenu = new QMenu((QWidget)this);
    QAction cutAction;
    QShortcut cutShortcut;
    QAction copyAction;
    QShortcut copyShortcut;
    QAction pasteAction;
    QShortcut pasteShortcut;
    QAction pasteWithoutFormatAction;
    QShortcut pasteWithoutFormatShortcut;
    QAction todoAction;
    QShortcut todoShortcut;
    QAction encryptAction;
    QShortcut encryptShortcut;
    QAction downloadAttachment;
    QShortcut downloadAttachmentShortcut;
    QAction downloadImage;
    QShortcut downloadImageShortcut;
    QAction rotateImageRight;
    QShortcut rotateImageRightShortcut;
    QAction rotateImageLeft;
    QShortcut rotateImageLeftShortcut;
    QAction insertLinkAction;
    QShortcut insertLinkShortcut;
    QAction insertLatexAction;
    QShortcut insertLatexShortcut;
    QAction insertTableAction;
    QShortcut insertTableShortcut;
    QAction insertTableRowAction;
    QShortcut insertTableRowShortcut;
    QAction insertTableColumnAction;
    QShortcut insertTableColumnShortcut;
    QAction deleteTableRowAction;
    QShortcut deleteTableRowShortcut;
    QAction deleteTableColumnAction;
    QShortcut deleteTableColumnShortcut;
    QAction openAction;
    QAction insertQuickLinkAction;
    QShortcut insertQuickLinkShortcut;
    QMenu imageMenu;
    QAction redBackgroundColor;
    QShortcut insertDateTimeShortcut;
    QSignalEmitter.Signal1<QNetworkRequest> downloadAttachmentRequested;
    QSignalEmitter.Signal1<QNetworkRequest> downloadImageRequested;

    public ContentView(BrowserWindow p) {
        this.parent = p;
        this.contextMenu = new QMenu((QWidget)this);
        this.openAction = new QAction(this.tr("Open"), (QObject)this);
        this.openAction.setText(this.tr("Open"));
        this.contextMenu.addAction(this.openAction);
        this.openAction.triggered.connect((Object)this.parent, "openFile()");
        this.cutAction = new QAction(this.tr("Cut"), (QObject)this);
        this.cutAction.triggered.connect((Object)this.parent, "cutClicked()");
        this.contextMenu.addAction(this.cutAction);
        this.contextMenu.insertSeparator(this.cutAction);
        this.setupShortcut(this.cutAction, "Edit_Cut");
        this.cutShortcut = new QShortcut((QWidget)this);
        this.cutShortcut.activated.connect((Object)this.parent, "cutClicked()");
        this.setupShortcut(this.cutShortcut, "Edit_Cut");
        this.copyAction = new QAction(this.tr("Copy"), (QObject)this);
        this.copyAction.triggered.connect((Object)this.parent, "copyClicked()");
        this.contextMenu.addAction(this.copyAction);
        this.setupShortcut(this.copyAction, "Edit_Copy");
        this.copyShortcut = new QShortcut((QWidget)this);
        this.copyShortcut.activated.connect((Object)this.parent, "copyClicked()");
        this.setupShortcut(this.copyShortcut, "Edit_Copy");
        this.pasteAction = this.pageAction(QWebPage.WebAction.Paste);
        this.pasteAction.disconnect();
        this.pasteAction.triggered.connect((Object)this.parent, "pasteClicked()");
        this.contextMenu.addAction(this.pasteAction);
        this.setupShortcut(this.pasteAction, "Edit_Paste");
        this.pasteShortcut = new QShortcut((QWidget)this);
        this.pasteShortcut.activated.connect((Object)this.parent, "pasteClicked()");
        this.setupShortcut(this.pasteShortcut, "Edit_Paste");
        this.pasteWithoutFormatAction = new QAction(this.tr("Paste Without Formatting"), (QObject)this);
        this.pasteWithoutFormatAction.triggered.connect((Object)this.parent, "pasteWithoutFormattingClicked()");
        this.contextMenu.addAction(this.pasteWithoutFormatAction);
        this.setupShortcut(this.pasteWithoutFormatAction, "Edit_Paste_Without_Formatting");
        this.contextMenu.addSeparator();
        QMenu colorMenu = new QMenu(this.tr("Background Color"));
        this.contextMenu.addMenu(colorMenu);
        colorMenu.addAction(this.setupColorMenuOption("White"));
        colorMenu.addAction(this.setupColorMenuOption("Red"));
        colorMenu.addAction(this.setupColorMenuOption("Blue"));
        colorMenu.addAction(this.setupColorMenuOption("Green"));
        colorMenu.addAction(this.setupColorMenuOption("Yellow"));
        colorMenu.addAction(this.setupColorMenuOption("Black"));
        colorMenu.addAction(this.setupColorMenuOption("Grey"));
        colorMenu.addAction(this.setupColorMenuOption("Purple"));
        colorMenu.addAction(this.setupColorMenuOption("Brown"));
        colorMenu.addAction(this.setupColorMenuOption("Orange"));
        colorMenu.addAction(this.setupColorMenuOption("Powder Blue"));
        this.contextMenu.addSeparator();
        this.todoAction = new QAction(this.tr("To-do"), (QObject)this);
        this.todoAction.triggered.connect((Object)this.parent, "todoClicked()");
        this.contextMenu.addAction(this.todoAction);
        this.setupShortcut(this.todoAction, "Edit_Insert_Todo");
        this.contextMenu.insertSeparator(this.todoAction);
        this.todoShortcut = new QShortcut((QWidget)this);
        this.todoShortcut.activated.connect((Object)this.parent, "todoClicked()");
        this.setupShortcut(this.todoShortcut, "Edit_Insert_Todo");
        this.encryptAction = new QAction(this.tr("Encrypt Selected Text"), (QObject)this);
        this.encryptAction.triggered.connect((Object)this.parent, "encryptText()");
        this.contextMenu.addAction(this.encryptAction);
        this.contextMenu.insertSeparator(this.encryptAction);
        this.setupShortcut(this.encryptAction, "Edit_Encrypt_Text");
        this.encryptAction.setEnabled(false);
        this.encryptShortcut = new QShortcut((QWidget)this);
        this.encryptShortcut.activated.connect((Object)this.parent, "encryptText()");
        this.setupShortcut(this.encryptShortcut, "Edit_Encrypt_Text");
        this.insertLinkAction = new QAction(this.tr("Insert Hyperlink"), (QObject)this);
        this.insertLinkAction.triggered.connect((Object)this.parent, "insertLink()");
        this.setupShortcut(this.insertLinkAction, "Edit_Insert_Hyperlink");
        this.contextMenu.addAction(this.insertLinkAction);
        this.insertLinkAction.setEnabled(false);
        this.insertLinkShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.insertLinkShortcut, "Edit_Insert_Hyperlink");
        this.insertLinkShortcut.activated.connect((Object)this.parent, "insertLink()");
        this.insertQuickLinkAction = new QAction(this.tr("Quick Link"), (QObject)this);
        this.insertQuickLinkAction.triggered.connect((Object)this.parent, "insertQuickLink()");
        this.setupShortcut(this.insertQuickLinkAction, "Edit_Insert_QuickLink");
        this.contextMenu.addAction(this.insertQuickLinkAction);
        this.insertQuickLinkAction.setEnabled(false);
        this.insertQuickLinkShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.insertQuickLinkShortcut, "Edit_Insert_Quicklink");
        this.insertQuickLinkShortcut.activated.connect((Object)this.parent, "insertQuickLink()");
        this.insertLatexAction = new QAction(this.tr("Insert LaTeX Formula"), (QObject)this);
        this.insertLatexAction.triggered.connect((Object)this.parent, "insertLatex()");
        this.setupShortcut(this.insertLatexAction, "Edit_Insert_Latex");
        this.contextMenu.addAction(this.insertLatexAction);
        this.insertLatexShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.insertLatexShortcut, "Edit_Insert_Latex");
        this.insertLatexShortcut.activated.connect((Object)this.parent, "insertLatex()");
        this.contextMenu.addMenu(this.tableMenu);
        this.tableMenu.setTitle("Table");
        this.insertTableAction = new QAction(this.tr("Insert Table"), (QObject)this);
        this.insertTableAction.triggered.connect((Object)this.parent, "insertTable()");
        this.setupShortcut(this.insertTableAction, "Edit_Insert_Table");
        this.tableMenu.addAction(this.insertTableAction);
        this.insertTableShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.insertTableShortcut, "Edit_Insert_Table");
        this.insertTableShortcut.activated.connect((Object)this.parent, "insertTable()");
        this.insertTableRowAction = new QAction(this.tr("Insert Row"), (QObject)this);
        this.insertTableRowAction.triggered.connect((Object)this.parent, "insertTableRow()");
        this.setupShortcut(this.insertTableRowAction, "Edit_Insert_Table_Row");
        this.tableMenu.addAction(this.insertTableRowAction);
        this.insertTableRowShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.insertTableRowShortcut, "Edit_Insert_Table_Row");
        this.insertTableRowShortcut.activated.connect((Object)this.parent, "insertTableRow()");
        this.insertTableColumnAction = new QAction(this.tr("Insert Column"), (QObject)this);
        this.insertTableColumnAction.triggered.connect((Object)this.parent, "insertTableColumn()");
        this.setupShortcut(this.insertTableColumnAction, "Edit_Insert_Table_Column");
        this.tableMenu.addAction(this.insertTableColumnAction);
        this.insertTableColumnShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.insertTableColumnShortcut, "Edit_Insert_Table_Column");
        this.insertTableColumnShortcut.activated.connect((Object)this.parent, "insertTableColumn()");
        this.deleteTableRowAction = new QAction(this.tr("Delete Row"), (QObject)this);
        this.deleteTableRowAction.triggered.connect((Object)this.parent, "deleteTableRow()");
        this.setupShortcut(this.deleteTableRowAction, "Edit_Delete_Table_Row");
        this.tableMenu.addAction(this.deleteTableRowAction);
        this.deleteTableRowShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.deleteTableRowShortcut, "Edit_Delete_Table_Row");
        this.deleteTableRowShortcut.activated.connect((Object)this.parent, "deleteTableRow()");
        this.deleteTableColumnAction = new QAction(this.tr("Delete Column"), (QObject)this);
        this.deleteTableColumnAction.triggered.connect((Object)this.parent, "deleteTableColumn()");
        this.setupShortcut(this.deleteTableColumnAction, "Edit_Delete_Table_Column");
        this.tableMenu.addAction(this.deleteTableColumnAction);
        this.deleteTableColumnShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.deleteTableColumnShortcut, "Edit_Delete_Table_Column");
        this.deleteTableColumnShortcut.activated.connect((Object)this.parent, "deleteTableColumn()");
        this.insertDateTimeShortcut = new QShortcut((QWidget)this);
        this.insertDateTimeShortcut.activated.connect((Object)this.parent, "insertDateTime()");
        this.setupShortcut(this.insertDateTimeShortcut, "Insert_DateTime");
        this.imageMenu = new QMenu();
        this.imageMenu.setTitle(this.tr("Image"));
        this.contextMenu.addMenu(this.imageMenu);
        this.downloadImage = this.pageAction(QWebPage.WebAction.DownloadImageToDisk);
        this.downloadImage.setText(this.tr("Save Image"));
        this.imageMenu.addAction(this.downloadImage);
        this.downloadImageRequested = new QSignalEmitter.Signal1((QSignalEmitter)this);
        this.rotateImageRight = new QAction(this.tr("Rotate Right"), (QObject)this);
        this.imageMenu.addAction(this.rotateImageRight);
        this.rotateImageRight.triggered.connect((Object)this.parent, "rotateImageRight()");
        this.rotateImageRightShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.rotateImageRightShortcut, "Edit_Image_Rotate_Right");
        this.rotateImageRightShortcut.activated.connect((Object)this.parent, "rotateImageRight()");
        this.rotateImageLeft = new QAction(this.tr("Rotate Left"), (QObject)this);
        this.imageMenu.addAction(this.rotateImageLeft);
        this.rotateImageLeft.triggered.connect((Object)this.parent, "rotateImageLeft()");
        this.rotateImageLeftShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.rotateImageLeftShortcut, "Edit_Image_Rotate_Left");
        this.rotateImageLeftShortcut.activated.connect((Object)this.parent, "rotateImageLeft()");
        this.downloadAttachment = this.pageAction(QWebPage.WebAction.DownloadLinkToDisk);
        this.downloadAttachment.setText(this.tr("Save Attachment"));
        this.contextMenu.addAction(this.downloadAttachment);
        this.page().downloadRequested.connect((Object)this, "downloadAttachment(QNetworkRequest)");
        this.downloadAttachmentRequested = new QSignalEmitter.Signal1((QSignalEmitter)this);
    }

    private void setupShortcut(QAction action, String text) {
        if (!Global.shortcutKeys.containsAction(text)) {
            return;
        }
        action.setShortcut(Global.shortcutKeys.getShortcut(text));
    }

    private void setupShortcut(QShortcut action, String text) {
        if (!Global.shortcutKeys.containsAction(text)) {
            return;
        }
        action.setKey(new QKeySequence(Global.shortcutKeys.getShortcut(text)));
    }

    private QAction setupColorMenuOption(String color) {
        QAction backgroundColor = new QAction(this.tr(color), (QObject)this);
        color = color.replace(" ", "");
        backgroundColor.triggered.connect((Object)this, "setBackground" + color + "()");
        return backgroundColor;
    }

    public boolean event(QEvent event) {
        if (event.type().equals((Object)QEvent.Type.KeyPress)) {
            QKeyEvent ke = (QKeyEvent)event;
            if (ke.key() == Qt.Key.Key_Tab.value()) {
                this.parent.tabPressed();
                ke.accept();
                return true;
            }
            if (ke.key() == Qt.Key.Key_Backtab.value()) {
                this.parent.backtabPressed();
                return true;
            }
        }
        return super.event(event);
    }

    public void keyPressEvent(QKeyEvent e) {
        if (e.key() == Qt.Key.Key_PageUp.value() || e.key() == Qt.Key.Key_PageDown.value()) {
            int bottom = this.page().mainFrame().geometry().bottom();
            int top = this.page().mainFrame().geometry().top();
            int scrollValue = top - bottom;
            if (e.key() == Qt.Key.Key_PageDown.value()) {
                scrollValue *= -1;
            }
            this.page().mainFrame().scroll(0, scrollValue);
        }
        if (e.matches(QKeySequence.StandardKey.Paste)) {
            this.parent.pasteClicked();
            e.accept();
            return;
        }
        super.keyPressEvent(e);
    }

    public void downloadAttachment(QNetworkRequest req) {
        this.downloadAttachmentRequested.emit((Object)req);
    }

    public void dropEvent(QDropEvent e) {
        this.setFocus();
        QMimeData mime = e.mimeData();
        this.parent.handleUrls(mime);
        this.parent.contentChanged();
    }

    public void contextMenuEvent(QContextMenuEvent event) {
        if (event != null) {
            this.contextMenu.exec(event.globalPos());
        }
    }

    private void setBackgroundWhite() {
        this.parent.setBackgroundColor("white");
    }

    private void setBackgroundRed() {
        this.parent.setBackgroundColor("red");
    }

    private void setBackgroundBlue() {
        this.parent.setBackgroundColor("blue");
    }

    private void setBackgroundGreen() {
        this.parent.setBackgroundColor("green");
    }

    private void setBackgroundYellow() {
        this.parent.setBackgroundColor("yellow");
    }

    private void setBackgroundBlack() {
        this.parent.setBackgroundColor("black");
    }

    private void setBackgroundPurple() {
        this.parent.setBackgroundColor("purple");
    }

    private void setBackgroundBrown() {
        this.parent.setBackgroundColor("brown");
    }

    private void setBackgroundGrey() {
        this.parent.setBackgroundColor("grey");
    }

    private void setBackgroundOrange() {
        this.parent.setBackgroundColor("orange");
    }

    private void setBackgroundPowderBlue() {
        this.parent.setBackgroundColor("powderblue");
    }
}

