/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.expression.ExpressionColumn;
import org.h2.fulltext.FullText;
import org.h2.jdbc.JdbcConnection;
import org.h2.store.fs.FileUtils;
import org.h2.tools.SimpleResultSet;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class FullTextLuceneEx
extends FullText {
    protected static final boolean STORE_DOCUMENT_TEXT_IN_INDEX = Utils.getProperty((String)"h2.storeDocumentTextInIndex", (boolean)false);
    protected static boolean TRIGGER_COMMIT = true;
    protected static boolean USE_RAM_DIRECTORY = false;
    protected static Version LUCENE_VERSION = FullTextLuceneEx.getVersion();
    protected static Analyzer ANALYZER = FullTextLuceneEx.getAnalyzer();
    private static final HashMap<String, IndexAccess> INDEX_ACCESS = New.hashMap();
    private static final String TRIGGER_PREFIX = "FTL_";
    private static final String SCHEMA = "FTL";
    private static final String LUCENE_FIELD_DATA = "_DATA";
    private static final String LUCENE_FIELD_QUERY = "_QUERY";
    private static final String LUCENE_FIELD_MODIFIED = "_modified";
    private static final String LUCENE_FIELD_COLUMN_PREFIX = "_";

    private static Version getVersion() {
        return Version.valueOf((String)"LUCENE_36");
    }

    private static Analyzer getAnalyzer() {
        return new CJKAnalyzer(LUCENE_VERSION);
    }

    public static void init(Connection conn) throws SQLException {
        TRIGGER_COMMIT = Utils.getProperty((String)"h2.isTriggerCommit", (boolean)true);
        USE_RAM_DIRECTORY = Utils.getProperty((String)"h2.useRamDirectory", (boolean)false);
        LUCENE_VERSION = FullTextLuceneEx.getVersion();
        ANALYZER = FullTextLuceneEx.getAnalyzer();
        Statement stat = conn.createStatement();
        stat.execute("CREATE SCHEMA IF NOT EXISTS FTL");
        stat.execute("CREATE TABLE IF NOT EXISTS FTL.INDEXES(SCHEMA VARCHAR, TABLE VARCHAR, COLUMNS VARCHAR, PRIMARY KEY(SCHEMA, TABLE))");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_CREATE_INDEX FOR \"" + FullTextLuceneEx.class.getName() + ".createIndex\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_SEARCH FOR \"" + FullTextLuceneEx.class.getName() + ".search\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_SEARCH_DATA FOR \"" + FullTextLuceneEx.class.getName() + ".searchData\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_REINDEX FOR \"" + FullTextLuceneEx.class.getName() + ".reindex\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_DROP_ALL FOR \"" + FullTextLuceneEx.class.getName() + ".dropAll\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_FLUSH_RAM FOR \"" + FullTextLuceneEx.class.getName() + ".flushRam\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_COMMIT FOR \"" + FullTextLuceneEx.class.getName() + ".commit\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_COMMIT_ALL FOR \"" + FullTextLuceneEx.class.getName() + ".commitAll\"");
        try {
            FullTextLuceneEx.getIndexAccess(conn);
        }
        catch (SQLException e) {
            throw FullTextLuceneEx.convertException(e);
        }
    }

    public static void flushRam(Connection conn) throws SQLException, IOException {
        IndexAccess access = FullTextLuceneEx.getIndexAccess(conn);
        if (access.writer.getDirectory() instanceof RAMDirectory) {
            Directory.copy((Directory)access.writer.getDirectory(), (Directory)FSDirectory.open((File)new File(FullTextLuceneEx.getIndexPath(conn))), (boolean)false);
        }
    }

    public static void commit(Connection conn) throws SQLException, IOException {
        IndexReader reader;
        IndexAccess indexAccess = FullTextLuceneEx.getIndexAccess(conn);
        indexAccess.writer.commit();
        indexAccess.searcher.close();
        indexAccess.reader.close();
        indexAccess.reader = reader = indexAccess.writer.getReader();
        indexAccess.searcher = new IndexSearcher(reader);
    }

    public static void commitAll(Connection conn) throws SQLException, IOException {
        FullTextLuceneEx.commit(conn);
        conn.commit();
    }

    public static void createIndex(Connection conn, String schema, String table, String columnList) throws SQLException {
        FullTextLuceneEx.init(conn);
        PreparedStatement prep = conn.prepareStatement("INSERT INTO FTL.INDEXES(SCHEMA, TABLE, COLUMNS) VALUES(?, ?, ?)");
        prep.setString(1, schema);
        prep.setString(2, table);
        prep.setString(3, columnList);
        prep.execute();
        FullTextLuceneEx.createTrigger(conn, schema, table);
        FullTextLuceneEx.indexExistingRows(conn, schema, table);
    }

    public static void reindex(Connection conn) throws SQLException {
        FullTextLuceneEx.init(conn);
        FullTextLuceneEx.removeAllTriggers((Connection)conn, (String)TRIGGER_PREFIX);
        FullTextLuceneEx.removeIndexFiles(conn);
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM FTL.INDEXES");
        while (rs.next()) {
            String schema = rs.getString("SCHEMA");
            String table = rs.getString("TABLE");
            FullTextLuceneEx.createTrigger(conn, schema, table);
            FullTextLuceneEx.indexExistingRows(conn, schema, table);
        }
    }

    public static void dropAll(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("DROP SCHEMA IF EXISTS FTL");
        FullTextLuceneEx.removeAllTriggers((Connection)conn, (String)TRIGGER_PREFIX);
        FullTextLuceneEx.removeIndexFiles(conn);
    }

    public static ResultSet search(Connection conn, String text, int limit, int offset) throws SQLException {
        return FullTextLuceneEx.search(conn, text, limit, offset, false);
    }

    public static ResultSet searchData(Connection conn, String text, int limit, int offset) throws SQLException {
        return FullTextLuceneEx.search(conn, text, limit, offset, true);
    }

    protected static SQLException convertException(Exception e) {
        SQLException e2 = new SQLException("Error while indexing document", "FULLTEXT");
        e2.initCause(e);
        return e2;
    }

    protected static void createTrigger(Connection conn, String schema, String table) throws SQLException {
        Statement stat = conn.createStatement();
        String trigger = String.valueOf(StringUtils.quoteIdentifier((String)schema)) + "." + StringUtils.quoteIdentifier((String)(TRIGGER_PREFIX + table));
        stat.execute("DROP TRIGGER IF EXISTS " + trigger);
        StringBuilder buff = new StringBuilder("CREATE TRIGGER IF NOT EXISTS ");
        buff.append(trigger).append(" AFTER INSERT, UPDATE, DELETE, ROLLBACK ON ").append(StringUtils.quoteIdentifier((String)schema)).append('.').append(StringUtils.quoteIdentifier((String)table)).append(" FOR EACH ROW CALL \"").append(FullTextTrigger.class.getName()).append('\"');
        stat.execute(buff.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IndexAccess getIndexAccess(Connection conn) throws SQLException {
        String path = FullTextLuceneEx.getIndexPath(conn);
        HashMap<String, IndexAccess> hashMap = INDEX_ACCESS;
        synchronized (hashMap) {
            IndexAccess access = INDEX_ACCESS.get(path);
            if (access == null) {
                try {
                    File f = new File(path);
                    Object indexDir = null;
                    indexDir = USE_RAM_DIRECTORY ? (f.exists() ? new RAMDirectory((Directory)FSDirectory.open((File)f)) : new RAMDirectory()) : FSDirectory.open((File)f);
                    boolean recreate = !IndexReader.indexExists((Directory)indexDir);
                    IndexWriter writer = new IndexWriter((Directory)indexDir, ANALYZER, recreate, IndexWriter.MaxFieldLength.UNLIMITED);
                    IndexReader reader = writer.getReader();
                    access = new IndexAccess();
                    access.writer = writer;
                    access.reader = reader;
                    access.searcher = new IndexSearcher(reader);
                }
                catch (IOException e) {
                    throw FullTextLuceneEx.convertException(e);
                }
                INDEX_ACCESS.put(path, access);
            }
            return access;
        }
    }

    protected static String getIndexPath(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("CALL DATABASE_PATH()");
        rs.next();
        String path = rs.getString(1);
        if (path == null) {
            throw FullTextLuceneEx.throwException((String)"Fulltext search for in-memory databases is not supported.");
        }
        int index = path.lastIndexOf(58);
        if (index > 1) {
            path = path.substring(index + 1);
        }
        rs.close();
        return String.valueOf(path) + LUCENE_FIELD_COLUMN_PREFIX + ANALYZER.getClass().getName();
    }

    protected static void indexExistingRows(Connection conn, String schema, String table) throws SQLException {
        FullTextTrigger existing = new FullTextTrigger();
        existing.init(conn, schema, null, table, false, 1);
        String sql = "SELECT * FROM " + StringUtils.quoteIdentifier((String)schema) + "." + StringUtils.quoteIdentifier((String)table);
        ResultSet rs = conn.createStatement().executeQuery(sql);
        int columnCount = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            Object[] row = new Object[columnCount];
            int i = 0;
            while (i < columnCount) {
                row[i] = rs.getObject(i + 1);
                ++i;
            }
            existing.insert(row, false);
        }
        existing.commitIndex();
    }

    private static void removeIndexFiles(Connection conn) throws SQLException {
        String path = FullTextLuceneEx.getIndexPath(conn);
        IndexAccess access = INDEX_ACCESS.get(path);
        if (access != null) {
            FullTextLuceneEx.removeIndexAccess(access, path);
        }
        FileUtils.deleteRecursive((String)path, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeIndexAccess(IndexAccess access, String indexPath) throws SQLException {
        HashMap<String, IndexAccess> hashMap = INDEX_ACCESS;
        synchronized (hashMap) {
            try {
                INDEX_ACCESS.remove(indexPath);
                access.searcher.close();
                access.reader.close();
                access.writer.close();
            }
            catch (Exception e) {
                throw FullTextLuceneEx.convertException(e);
            }
        }
    }

    protected static ResultSet search(Connection conn, String text, int limit, int offset, boolean data) throws SQLException {
        SimpleResultSet result = FullTextLuceneEx.createResultSet((boolean)data);
        if (conn.getMetaData().getURL().startsWith("jdbc:columnlist:")) {
            return result;
        }
        if (text == null || text.trim().length() == 0) {
            return result;
        }
        try {
            IndexAccess access = FullTextLuceneEx.getIndexAccess(conn);
            Searcher searcher = access.searcher;
            Analyzer analyzer = access.writer.getAnalyzer();
            QueryParser parser = new QueryParser(LUCENE_VERSION, LUCENE_FIELD_DATA, analyzer);
            parser.setAutoGeneratePhraseQueries(true);
            Query query = parser.parse(text);
            int maxResults = (limit == 0 ? 100 : limit) + offset;
            TopDocs docs = searcher.search(query, maxResults);
            if (limit == 0) {
                limit = docs.totalHits;
            }
            int i = 0;
            int len = docs.scoreDocs.length;
            while (i < limit && i + offset < docs.totalHits && i + offset < len) {
                ScoreDoc sd = docs.scoreDocs[i + offset];
                Document doc = searcher.doc(sd.doc);
                float score = sd.score;
                String q = doc.get(LUCENE_FIELD_QUERY);
                if (data) {
                    int idx = q.indexOf(" WHERE ");
                    JdbcConnection c = (JdbcConnection)conn;
                    Session session = (Session)c.getSession();
                    Parser p = new Parser(session);
                    String tab = q.substring(0, idx);
                    ExpressionColumn expr = (ExpressionColumn)p.parseExpression(tab);
                    String schemaName = expr.getOriginalTableAliasName();
                    String tableName = expr.getColumnName();
                    q = q.substring(idx + " WHERE ".length());
                    Object[][] columnData = FullTextLuceneEx.parseKey((Connection)conn, (String)q);
                    result.addRow(new Object[]{schemaName, tableName, columnData[0], columnData[1], Float.valueOf(score)});
                } else {
                    result.addRow(new Object[]{q, Float.valueOf(score)});
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw FullTextLuceneEx.convertException(e);
        }
        return result;
    }

    public static class FullTextTrigger
    implements Trigger {
        protected String schema;
        protected String table;
        protected int[] keys;
        protected int[] indexColumns;
        protected String[] columns;
        protected int[] columnTypes;
        protected String indexPath;
        protected IndexAccess indexAccess;

        public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
            String cols;
            this.schema = schemaName;
            this.table = tableName;
            this.indexPath = FullTextLuceneEx.getIndexPath(conn);
            this.indexAccess = FullTextLuceneEx.getIndexAccess(conn);
            ArrayList keyList = New.arrayList();
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getColumns(null, JdbcUtils.escapeMetaDataPattern((String)schemaName), JdbcUtils.escapeMetaDataPattern((String)tableName), null);
            ArrayList columnList = New.arrayList();
            while (rs.next()) {
                columnList.add(rs.getString("COLUMN_NAME"));
            }
            this.columnTypes = new int[columnList.size()];
            this.columns = new String[columnList.size()];
            columnList.toArray(this.columns);
            rs = meta.getColumns(null, JdbcUtils.escapeMetaDataPattern((String)schemaName), JdbcUtils.escapeMetaDataPattern((String)tableName), null);
            int i = 0;
            while (rs.next()) {
                this.columnTypes[i] = rs.getInt("DATA_TYPE");
                ++i;
            }
            if (keyList.size() == 0) {
                rs = meta.getPrimaryKeys(null, JdbcUtils.escapeMetaDataPattern((String)schemaName), tableName);
                while (rs.next()) {
                    keyList.add(rs.getString("COLUMN_NAME"));
                }
            }
            if (keyList.size() == 0) {
                throw FullTextLuceneEx.throwException((String)("No primary key for table " + tableName));
            }
            ArrayList indexList = New.arrayList();
            PreparedStatement prep = conn.prepareStatement("SELECT COLUMNS FROM FTL.INDEXES WHERE SCHEMA=? AND TABLE=?");
            prep.setString(1, schemaName);
            prep.setString(2, tableName);
            rs = prep.executeQuery();
            if (rs.next() && (cols = rs.getString(1)) != null) {
                String[] stringArray = StringUtils.arraySplit((String)cols, (char)',', (boolean)true);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    indexList.add(s);
                    ++n2;
                }
            }
            if (indexList.size() == 0) {
                indexList.addAll(columnList);
            }
            this.keys = new int[keyList.size()];
            FullTextLuceneEx.setColumns((int[])this.keys, (ArrayList)keyList, (ArrayList)columnList);
            this.indexColumns = new int[indexList.size()];
            FullTextLuceneEx.setColumns((int[])this.indexColumns, (ArrayList)indexList, (ArrayList)columnList);
        }

        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            if (oldRow != null) {
                if (newRow != null) {
                    if (FullTextLuceneEx.hasChanged((Object[])oldRow, (Object[])newRow, (int[])this.indexColumns)) {
                        this.delete(oldRow);
                        this.insert(newRow, TRIGGER_COMMIT);
                    }
                } else {
                    this.delete(oldRow);
                }
            } else if (newRow != null) {
                this.insert(newRow, TRIGGER_COMMIT);
            }
        }

        public void close() throws SQLException {
            if (this.indexAccess != null) {
                FullTextLuceneEx.removeIndexAccess(this.indexAccess, this.indexPath);
                this.indexAccess = null;
            }
        }

        public void remove() {
        }

        void commitIndex() throws SQLException {
            try {
                IndexReader reader;
                this.indexAccess.writer.commit();
                this.indexAccess.searcher.close();
                this.indexAccess.reader.close();
                this.indexAccess.reader = reader = this.indexAccess.writer.getReader();
                this.indexAccess.searcher = new IndexSearcher(reader);
            }
            catch (IOException e) {
                throw FullTextLuceneEx.convertException(e);
            }
        }

        protected void insert(Object[] row, boolean commitIndex) throws SQLException {
            String query = this.getQuery(row);
            Document doc = new Document();
            doc.add((Fieldable)new Field(FullTextLuceneEx.LUCENE_FIELD_QUERY, query, Field.Store.YES, Field.Index.NOT_ANALYZED));
            long time = System.currentTimeMillis();
            doc.add((Fieldable)new Field(FullTextLuceneEx.LUCENE_FIELD_MODIFIED, DateTools.timeToString((long)time, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.YES, Field.Index.NOT_ANALYZED));
            StatementBuilder buff = new StatementBuilder();
            int[] nArray = this.indexColumns;
            int n = this.indexColumns.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                String columnName = this.columns[index];
                String data = FullTextLuceneEx.asString((Object)row[index], (int)this.columnTypes[index]);
                if (columnName.startsWith(FullTextLuceneEx.LUCENE_FIELD_COLUMN_PREFIX)) {
                    columnName = FullTextLuceneEx.LUCENE_FIELD_COLUMN_PREFIX + columnName;
                }
                doc.add((Fieldable)new Field(columnName, data, Field.Store.NO, Field.Index.ANALYZED));
                buff.appendExceptFirst(" ");
                buff.append(data);
                ++n2;
            }
            Field.Store storeText = STORE_DOCUMENT_TEXT_IN_INDEX ? Field.Store.YES : Field.Store.NO;
            doc.add((Fieldable)new Field(FullTextLuceneEx.LUCENE_FIELD_DATA, buff.toString(), storeText, Field.Index.ANALYZED));
            try {
                this.indexAccess.writer.addDocument(doc);
                if (commitIndex) {
                    IndexReader reader;
                    this.indexAccess.writer.commit();
                    this.indexAccess.searcher.close();
                    this.indexAccess.reader.close();
                    this.indexAccess.reader = reader = this.indexAccess.writer.getReader();
                    this.indexAccess.searcher = new IndexSearcher(reader);
                }
            }
            catch (IOException e) {
                throw FullTextLuceneEx.convertException(e);
            }
        }

        protected void delete(Object[] row) throws SQLException {
            String query = this.getQuery(row);
            try {
                Term term = new Term(FullTextLuceneEx.LUCENE_FIELD_QUERY, query);
                this.indexAccess.writer.deleteDocuments(term);
            }
            catch (IOException e) {
                throw FullTextLuceneEx.convertException(e);
            }
        }

        private String getQuery(Object[] row) throws SQLException {
            StatementBuilder buff = new StatementBuilder();
            if (this.schema != null) {
                buff.append(StringUtils.quoteIdentifier((String)this.schema)).append('.');
            }
            buff.append(StringUtils.quoteIdentifier((String)this.table)).append(" WHERE ");
            int[] nArray = this.keys;
            int n = this.keys.length;
            int n2 = 0;
            while (n2 < n) {
                int columnIndex = nArray[n2];
                buff.appendExceptFirst(" AND ");
                buff.append(StringUtils.quoteIdentifier((String)this.columns[columnIndex]));
                Object o = row[columnIndex];
                if (o == null) {
                    buff.append(" IS NULL");
                } else {
                    buff.append('=').append(FullText.quoteSQL((Object)o, (int)this.columnTypes[columnIndex]));
                }
                ++n2;
            }
            return buff.toString();
        }
    }

    static class IndexAccess {
        IndexWriter writer;
        IndexReader reader;
        Searcher searcher;

        IndexAccess() {
        }
    }
}

