/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.utilities;

import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.SavedSearch;
import com.evernote.edam.type.Tag;
import com.trolltech.qt.QThread;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QDateTime;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.sql.QSqlQuery;
import com.trolltech.qt.xml.QDomAttr;
import com.trolltech.qt.xml.QDomDocument;
import com.trolltech.qt.xml.QDomElement;
import com.trolltech.qt.xml.QDomNodeList;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.evernote.NoteMetadata;
import cx.fbn.nevernote.filters.EnSearch;
import cx.fbn.nevernote.filters.NotebookCounter;
import cx.fbn.nevernote.filters.TagCounter;
import cx.fbn.nevernote.gui.NoteTableModel;
import cx.fbn.nevernote.signals.NotebookSignal;
import cx.fbn.nevernote.signals.StatusSignal;
import cx.fbn.nevernote.signals.TagSignal;
import cx.fbn.nevernote.signals.ThreadSignal;
import cx.fbn.nevernote.signals.TrashSignal;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.NoteTagsRecord;
import cx.fbn.nevernote.threads.CounterRunner;
import cx.fbn.nevernote.threads.SaveRunner;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ListManager {
    private final ApplicationLogger logger;
    DatabaseConnection conn;
    QSqlQuery deleteWords;
    QSqlQuery insertWords;
    private List<Tag> tagIndex;
    private List<Notebook> notebookIndex;
    private List<Notebook> archiveNotebookIndex;
    private List<String> localNotebookIndex;
    private List<LinkedNotebook> linkedNotebookIndex;
    private List<SavedSearch> searchIndex;
    private List<String> selectedNotebooks;
    private final NoteTableModel noteModel;
    private List<String> selectedTags;
    private String selectedSearch;
    ThreadSignal signals;
    public StatusSignal status;
    private final CounterRunner notebookCounterRunner;
    private final QThread notebookThread;
    private final CounterRunner tagCounterRunner;
    private final QThread tagThread;
    private final CounterRunner trashCounterRunner;
    private final QThread trashThread;
    public TrashSignal trashSignal;
    private List<NotebookCounter> notebookCounter;
    private List<TagCounter> tagCounter;
    private EnSearch enSearch;
    private boolean enSearchChanged;
    public HashMap<String, String> wordMap;
    public TagSignal tagSignal;
    public NotebookSignal notebookSignal;
    public boolean refreshCounters;
    private int trashCount;
    public SaveRunner saveRunner;
    QThread saveThread;

    public ListManager(DatabaseConnection d, ApplicationLogger l) {
        this.conn = d;
        this.logger = l;
        this.conn.getTagTable().cleanupTags();
        this.status = new StatusSignal();
        this.signals = new ThreadSignal();
        this.enSearchChanged = false;
        this.noteModel = new NoteTableModel(this);
        this.selectedTags = new ArrayList<String>();
        this.notebookCounter = new ArrayList<NotebookCounter>();
        this.tagCounter = new ArrayList<TagCounter>();
        this.selectedNotebooks = new ArrayList<String>();
        this.reloadIndexes();
        this.notebookSignal = new NotebookSignal();
        this.notebookCounterRunner = new CounterRunner("notebook_counter.log", CounterRunner.NOTEBOOK, Global.getDatabaseUrl(), Global.getIndexDatabaseUrl(), Global.getResourceDatabaseUrl(), Global.getBehaviorDatabaseUrl(), Global.getDatabaseUserid(), Global.getDatabaseUserPassword(), Global.cipherPassword);
        this.notebookCounterRunner.setNoteIndex(this.getNoteIndex());
        this.notebookCounterRunner.notebookSignal.countsChanged.connect((Object)this, "setNotebookCounter(List)");
        this.notebookThread = new QThread((Runnable)this.notebookCounterRunner, "Notebook Counter Thread");
        this.notebookThread.start();
        this.tagSignal = new TagSignal();
        this.tagCounterRunner = new CounterRunner("tag_counter.log", CounterRunner.TAG, Global.getDatabaseUrl(), Global.getIndexDatabaseUrl(), Global.getResourceDatabaseUrl(), Global.getBehaviorDatabaseUrl(), Global.getDatabaseUserid(), Global.getDatabaseUserPassword(), Global.cipherPassword);
        this.tagCounterRunner.setNoteIndex(this.getNoteIndex());
        this.tagCounterRunner.tagSignal.countsChanged.connect((Object)this, "setTagCounter(List)");
        this.tagThread = new QThread((Runnable)this.tagCounterRunner, "Tag Counter Thread");
        this.tagThread.start();
        this.trashSignal = new TrashSignal();
        this.trashCounterRunner = new CounterRunner("trash_counter.log", CounterRunner.TRASH, Global.getDatabaseUrl(), Global.getIndexDatabaseUrl(), Global.getResourceDatabaseUrl(), Global.getBehaviorDatabaseUrl(), Global.getDatabaseUserid(), Global.getDatabaseUserPassword(), Global.cipherPassword);
        this.trashCounterRunner.trashSignal.countChanged.connect((Object)this, "trashSignalReceiver(Integer)");
        this.trashThread = new QThread((Runnable)this.trashCounterRunner, "Trash Counter Thread");
        this.trashThread.start();
        this.wordMap = new HashMap();
        this.tagSignal = new TagSignal();
        this.logger.log(this.logger.EXTREME, "Setting save thread");
        this.saveRunner = new SaveRunner("saveRunner.log", Global.getDatabaseUrl(), Global.getIndexDatabaseUrl(), Global.getResourceDatabaseUrl(), Global.getBehaviorDatabaseUrl(), Global.getDatabaseUserid(), Global.getDatabaseUserPassword(), Global.cipherPassword);
        this.saveThread = new QThread((Runnable)this.saveRunner, "Save Runner Thread");
        this.saveThread.start();
        this.linkedNotebookIndex = this.conn.getLinkedNotebookTable().getAll();
        this.loadNoteTitleColors();
        this.refreshCounters = true;
        this.refreshCounters();
    }

    public void stop() {
        this.saveRunner.addWork("stop", "");
        this.tagCounterRunner.release(CounterRunner.EXIT);
        this.notebookCounterRunner.release(CounterRunner.EXIT);
        this.trashCounterRunner.release(CounterRunner.EXIT);
        this.logger.log(this.logger.MEDIUM, "Waiting for notebookCounterThread to stop");
        try {
            this.notebookThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.logger.log(this.logger.MEDIUM, "Waiting for tagCounterThread to stop");
        try {
            this.tagThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.logger.log(this.logger.MEDIUM, "Waiting for trashThread to stop");
        try {
            this.trashThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.logger.log(this.logger.MEDIUM, "Waiting for saveThread to stop");
        try {
            this.saveThread.join(0L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void saveUpdatedNotes(HashMap<Integer, Note> notes, HashMap<Integer, String> contents) {
        int i = 0;
        while (i < notes.size()) {
            Note n = notes.get(i);
            String content = contents.get(i);
            this.saveRunner.addWork(n.getGuid(), content);
            this.conn.getNoteTable().updateNoteTitle(n.getGuid(), n.getTitle());
            ++i;
        }
    }

    public void refreshLists() {
        this.setSavedSearchIndex(this.conn.getSavedSearchTable().getAll());
        this.setTagIndex(this.conn.getTagTable().getAll());
        this.setNotebookIndex(this.conn.getNotebookTable().getAll());
        List<Notebook> local = this.conn.getNotebookTable().getAllLocal();
        this.localNotebookIndex = new ArrayList<String>();
        int i = 0;
        while (i < local.size()) {
            this.localNotebookIndex.add(local.get(i).getGuid());
            ++i;
        }
        this.noteModel.setMasterNoteIndex(this.conn.getNoteTable().getAllNotes());
        List<NoteTagsRecord> noteTags = this.conn.getNoteTable().noteTagsTable.getAllNoteTags();
        int i2 = 0;
        while (i2 < this.getMasterNoteIndex().size()) {
            ArrayList<String> tags = new ArrayList<String>();
            ArrayList<String> names = new ArrayList<String>();
            int j = 0;
            while (j < noteTags.size()) {
                if (this.getMasterNoteIndex().get(i2).getGuid().equals(noteTags.get((int)j).noteGuid)) {
                    tags.add(noteTags.get((int)j).tagGuid);
                    names.add(this.getTagNameByGuid(noteTags.get((int)j).tagGuid));
                }
                ++j;
            }
            this.getMasterNoteIndex().get(i2).setTagGuids(tags);
            this.getMasterNoteIndex().get(i2).setTagNames(names);
            ++i2;
        }
        this.linkedNotebookIndex = this.conn.getLinkedNotebookTable().getAll();
        this.enSearchChanged = true;
    }

    public void reloadTagIndex() {
        this.setTagIndex(this.conn.getTagTable().getAll());
    }

    public void reloadIndexes() {
        List<Notebook> local = this.conn.getNotebookTable().getAllLocal();
        this.localNotebookIndex = new ArrayList<String>();
        int i = 0;
        while (i < local.size()) {
            this.localNotebookIndex.add(local.get(i).getGuid());
            ++i;
        }
        this.reloadTagIndex();
        this.setNotebookIndex(this.conn.getNotebookTable().getAll());
        this.setArchiveNotebookIndex(this.conn.getNotebookTable().getAllArchived());
        this.setSavedSearchIndex(this.conn.getSavedSearchTable().getAll());
        this.enSearch = new EnSearch(this.conn, this.logger, "", this.getTagIndex(), Global.getRecognitionWeight());
        this.logger.log(this.logger.HIGH, "Building note index");
        this.noteModel.setMasterNoteIndex(this.conn.getNoteTable().getAllNotes());
        List<NoteTagsRecord> noteTags = this.conn.getNoteTable().noteTagsTable.getAllNoteTags();
        int i2 = 0;
        while (i2 < this.getMasterNoteIndex().size()) {
            ArrayList<String> tags = new ArrayList<String>();
            ArrayList<String> names = new ArrayList<String>();
            int j = 0;
            while (j < noteTags.size()) {
                if (this.getMasterNoteIndex().get(i2).getGuid().equals(noteTags.get((int)j).noteGuid)) {
                    tags.add(noteTags.get((int)j).tagGuid);
                    names.add(this.getTagNameByGuid(noteTags.get((int)j).tagGuid));
                }
                ++j;
            }
            this.getMasterNoteIndex().get(i2).setTagGuids(tags);
            this.getMasterNoteIndex().get(i2).setTagNames(names);
            ++i2;
        }
        this.setNoteIndex(this.getMasterNoteIndex());
    }

    public List<String> getSelectedNotebooks() {
        return this.selectedNotebooks;
    }

    public void setSelectedNotebooks(List<String> s) {
        if (s == null) {
            s = new ArrayList<String>();
        }
        this.selectedNotebooks = s;
    }

    public NoteTableModel getNoteTableModel() {
        return this.noteModel;
    }

    private void setSavedSearchIndex(List<SavedSearch> t) {
        this.searchIndex = t;
    }

    public List<SavedSearch> getSavedSearchIndex() {
        return this.searchIndex;
    }

    private void setTagIndex(List<Tag> t) {
        this.tagIndex = t;
    }

    public List<Tag> getTagIndex() {
        return this.tagIndex;
    }

    private void setNotebookIndex(List<Notebook> t) {
        this.notebookIndex = t;
    }

    private void setArchiveNotebookIndex(List<Notebook> t) {
        this.archiveNotebookIndex = t;
    }

    public List<Notebook> getNotebookIndex() {
        return this.notebookIndex;
    }

    public List<LinkedNotebook> getLinkedNotebookIndex() {
        return this.linkedNotebookIndex;
    }

    public List<Notebook> getArchiveNotebookIndex() {
        return this.archiveNotebookIndex;
    }

    private void setNoteIndex(List<Note> n) {
        this.noteModel.setNoteIndex(n);
        this.refreshNoteMetadata();
    }

    public void refreshNoteMetadata() {
        this.noteModel.setNoteMetadata(this.conn.getNoteTable().getNotesMetaInformation());
    }

    public void updateNoteMetadata(NoteMetadata meta) {
        this.noteModel.metaData.remove(meta);
        this.noteModel.metaData.put(meta.getGuid(), meta);
        this.conn.getNoteTable().updateNoteMetadata(meta);
    }

    public synchronized List<Note> getNoteIndex() {
        return this.noteModel.getNoteIndex();
    }

    public void setNotebookCounter(List<NotebookCounter> n) {
        this.notebookCounter = n;
        this.notebookSignal.refreshNotebookTreeCounts.emit(this.getNotebookIndex(), this.notebookCounter);
    }

    public List<NotebookCounter> getNotebookCounter() {
        return this.notebookCounter;
    }

    public void setTagCounter(List<TagCounter> n) {
        this.tagCounter = n;
        this.tagSignal.refreshTagTreeCounts.emit(this.tagCounter);
    }

    public List<TagCounter> getTagCounter() {
        return this.tagCounter;
    }

    public List<String> getLocalNotebooks() {
        return this.localNotebookIndex;
    }

    public int getTrashCount() {
        return this.trashCount;
    }

    public EnSearch getEnSearch() {
        return this.enSearch;
    }

    public List<Note> getMasterNoteIndex() {
        return this.noteModel.getMasterNoteIndex();
    }

    public HashMap<String, NoteMetadata> getNoteMetadata() {
        return this.noteModel.metaData;
    }

    public QImage getThumbnail(String guid) {
        QImage img = new QImage();
        img = QImage.fromData((QByteArray)this.conn.getNoteTable().getThumbnail(guid));
        if (img == null || img.isNull()) {
            return null;
        }
        return img;
    }

    public QPixmap getThumbnailPixmap(String guid) {
        QPixmap img = new QPixmap();
        img.loadFromData(this.conn.getNoteTable().getThumbnail(guid));
        if (img == null || img.isNull()) {
            return null;
        }
        return img;
    }

    public void setEnSearch(String t) {
        this.enSearch = new EnSearch(this.conn, this.logger, t, this.getTagIndex(), Global.getRecognitionWeight());
        this.enSearchChanged = true;
    }

    public void setSelectedTags(List<String> selectedTags) {
        this.selectedTags = selectedTags;
    }

    public void setSelectedSavedSearch(String s) {
        this.selectedSearch = s;
    }

    public List<String> getSelectedTags() {
        return this.selectedTags;
    }

    public String getSelectedSearch() {
        return this.selectedSearch;
    }

    public void saveNoteTags(String noteGuid, List<String> tags, boolean isDirty) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.saveNoteTags");
        int i = 0;
        while (i < tags.size()) {
            String tagName = tags.get(i);
            int j = 0;
            while (j < this.tagIndex.size()) {
                if (this.tagIndex.get(j).getName().equalsIgnoreCase(tagName)) {
                    this.conn.getHistoryTable().addSameTagHistory(noteGuid, this.tagIndex.get(j).getGuid());
                }
                ++j;
            }
            ++i;
        }
        this.conn.getNoteTable().noteTagsTable.deleteNoteTag(noteGuid);
        ArrayList<String> tagGuids = new ArrayList<String>();
        boolean newTagCreated = false;
        int i2 = 0;
        while (i2 < tags.size()) {
            String tagName = tags.get(i2);
            boolean found = false;
            int j = 0;
            while (j < this.tagIndex.size()) {
                if (this.tagIndex.get(j).getName().equalsIgnoreCase(tagName)) {
                    this.conn.getNoteTable().noteTagsTable.saveNoteTag(noteGuid, this.tagIndex.get(j).getGuid(), isDirty);
                    tagGuids.add(this.tagIndex.get(j).getGuid());
                    j = this.tagIndex.size() + 1;
                    found = true;
                }
                ++j;
            }
            if (!found) {
                Tag nTag = new Tag();
                nTag.setName(tagName);
                GregorianCalendar currentTime = new GregorianCalendar();
                Long l = new Long(currentTime.getTimeInMillis());
                long prevTime = l;
                while (l == prevTime) {
                    currentTime = new GregorianCalendar();
                    l = currentTime.getTimeInMillis();
                }
                String randint = new String(Long.toString(l));
                nTag.setUpdateSequenceNum(0);
                nTag.setGuid(randint);
                this.conn.getTagTable().addTag(nTag, true);
                this.getTagIndex().add(nTag);
                this.conn.getNoteTable().noteTagsTable.saveNoteTag(noteGuid, nTag.getGuid(), isDirty);
                tagGuids.add(nTag.getGuid());
                newTagCreated = true;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i2).getGuid().equals(noteGuid)) {
                this.getNoteIndex().get(i2).setTagNames(tags);
                this.getNoteIndex().get(i2).setTagGuids(tagGuids);
                i2 = this.getNoteIndex().size() + 1;
            }
            ++i2;
        }
        if (newTagCreated) {
            this.tagSignal.listChanged.emit();
        }
        this.logger.log(this.logger.HIGH, "Leaving ListManager.saveNoteTags");
    }

    public void deleteNote(String guid) {
        this.trashCounterRunner.abortCount = true;
        GregorianCalendar currentTime = new GregorianCalendar();
        Long l = new Long(currentTime.getTimeInMillis());
        long prevTime = l;
        while (l == prevTime) {
            currentTime = new GregorianCalendar();
            l = currentTime.getTimeInMillis();
        }
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.getMasterNoteIndex().get(i).setActive(false);
                this.getMasterNoteIndex().get(i).setDeleted(l.longValue());
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.getNoteIndex().get(i).setActive(false);
                this.getNoteIndex().get(i).setDeleted(l.longValue());
                i = this.getNoteIndex().size();
            }
            ++i;
        }
        this.conn.getNoteTable().deleteNote(guid);
        this.reloadTrashCount();
    }

    public void restoreNote(String guid) {
        this.trashCounterRunner.abortCount = true;
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.getMasterNoteIndex().get(i).setActive(true);
                this.getMasterNoteIndex().get(i).setDeleted(0L);
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.getNoteIndex().get(i).setActive(true);
                this.getNoteIndex().get(i).setDeleted(0L);
                i = this.getNoteIndex().size();
            }
            ++i;
        }
        this.conn.getNoteTable().restoreNote(guid);
        this.reloadTrashCount();
    }

    public void updateNote(Note n) {
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(n.getGuid())) {
                this.getMasterNoteIndex().remove(i);
                this.getMasterNoteIndex().add(n);
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(n.getGuid())) {
                this.getNoteIndex().get(i).setActive(true);
                this.getNoteIndex().get(i).setDeleted(0L);
                i = this.getNoteIndex().size();
            }
            ++i;
        }
        this.conn.getNoteTable().updateNote(n);
    }

    public void addNote(Note n, NoteMetadata meta) {
        this.noteModel.addNote(n, meta);
        this.noteModel.metaData.put(n.getGuid(), meta);
    }

    public void expungeNote(String guid) {
        this.trashCounterRunner.abortCount = true;
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.getMasterNoteIndex().remove(i);
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.getNoteIndex().remove(i);
                i = this.getNoteIndex().size();
            }
            ++i;
        }
        this.conn.getNoteTable().expungeNote(guid, false, true);
        this.reloadTrashCount();
    }

    public void emptyTrash() {
        this.trashCounterRunner.abortCount = true;
        int i = this.getMasterNoteIndex().size() - 1;
        while (i >= 0) {
            if (!this.getMasterNoteIndex().get(i).isActive()) {
                this.getMasterNoteIndex().remove(i);
            }
            --i;
        }
        i = this.getNoteIndex().size() - 1;
        while (i >= 0) {
            if (!this.getNoteIndex().get(i).isActive()) {
                this.getNoteIndex().remove(i);
            }
            --i;
        }
        this.conn.getNoteTable().expungeAllDeletedNotes();
        this.reloadTrashCount();
    }

    private void trashSignalReceiver(Integer i) {
        this.trashCount = i;
        this.trashSignal.countChanged.emit((Object)i);
    }

    public void updateNoteContent(String guid, String content) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.updateNoteContent");
        this.saveRunner.addWork(guid, content);
        this.logger.log(this.logger.HIGH, "Leaving ListManager.updateNoteContent");
    }

    public void updateNoteCreatedDate(String guid, QDateTime date) {
        this.noteModel.updateNoteCreatedDate(guid, date);
        this.conn.getNoteTable().updateNoteCreatedDate(guid, date);
    }

    public void updateNoteSubjectDate(String guid, QDateTime date) {
        this.noteModel.updateNoteSubjectDate(guid, date);
        this.conn.getNoteTable().updateNoteSubjectDate(guid, date);
    }

    public void updateNoteAuthor(String guid, String author) {
        this.noteModel.updateNoteAuthor(guid, author);
        this.conn.getNoteTable().updateNoteAuthor(guid, author);
    }

    public void updateNoteGeoTag(String guid, Double lon, Double lat, Double alt) {
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.getMasterNoteIndex().get(i).getAttributes().setLongitude(lon.doubleValue());
                this.getMasterNoteIndex().get(i).getAttributes().setLongitudeIsSet(true);
                this.getMasterNoteIndex().get(i).getAttributes().setLatitude(lat.doubleValue());
                this.getMasterNoteIndex().get(i).getAttributes().setLatitudeIsSet(true);
                this.getMasterNoteIndex().get(i).getAttributes().setAltitude(alt.doubleValue());
                this.getMasterNoteIndex().get(i).getAttributes().setAltitudeIsSet(true);
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.getNoteIndex().get(i).getAttributes().setLongitude(lon.doubleValue());
                this.getNoteIndex().get(i).getAttributes().setLongitudeIsSet(true);
                this.getNoteIndex().get(i).getAttributes().setLatitude(lat.doubleValue());
                this.getNoteIndex().get(i).getAttributes().setLatitudeIsSet(true);
                this.getNoteIndex().get(i).getAttributes().setAltitude(alt.doubleValue());
                this.getNoteIndex().get(i).getAttributes().setAltitudeIsSet(true);
                i = this.getNoteIndex().size();
            }
            ++i;
        }
        this.conn.getNoteTable().updateNoteGeoTags(guid, lon, lat, alt);
    }

    public void updateNoteSourceUrl(String guid, String url) {
        this.noteModel.updateNoteSourceUrl(guid, url);
        this.conn.getNoteTable().updateNoteSourceUrl(guid, url);
    }

    public void updateNoteAlteredDate(String guid, QDateTime date) {
        this.noteModel.updateNoteChangedDate(guid, date);
        this.conn.getNoteTable().updateNoteAlteredDate(guid, date);
    }

    public void updateNoteTitle(String guid, String title) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.updateNoteTitle");
        this.conn.getNoteTable().updateNoteTitle(guid, title);
        this.noteModel.updateNoteTitle(guid, title);
        this.logger.log(this.logger.HIGH, "Leaving ListManager.updateNoteTitle");
    }

    public void updateNoteNotebook(String guid, String notebookGuid) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.updateNoteNotebook");
        this.noteModel.updateNoteNotebook(guid, notebookGuid);
        this.conn.getNoteTable().updateNoteNotebook(guid, notebookGuid, true);
        this.logger.log(this.logger.HIGH, "Leaving ListManager.updateNoteNotebook");
    }

    public void updateNoteSequence(String guid, int sequence) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.updateNoteSequence");
        this.conn.getNoteTable().updateNoteSequence(guid, sequence);
        int i = 0;
        while (i < this.noteModel.getMasterNoteIndex().size()) {
            if (this.noteModel.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.noteModel.getMasterNoteIndex().get(i).setUpdateSequenceNum(sequence);
                i = this.noteModel.getMasterNoteIndex().size() + 1;
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.getNoteIndex().get(i).setUpdateSequenceNum(sequence);
                i = this.getNoteIndex().size() + 1;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving ListManager.updateNoteSequence");
    }

    public void updateNoteGuid(String oldGuid, String newGuid, boolean updateDatabase) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.updateNoteGuid");
        if (updateDatabase) {
            this.conn.getNoteTable().updateNoteGuid(oldGuid, newGuid);
        }
        this.noteModel.updateNoteGuid(oldGuid, newGuid);
        this.logger.log(this.logger.HIGH, "Leaving ListManager.updateNoteGuid");
    }

    public void updateTagSequence(String guid, int sequence) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.updateTagSequence");
        this.conn.getTagTable().updateTagSequence(guid, sequence);
        int i = 0;
        while (i < this.tagIndex.size()) {
            if (this.tagIndex.get(i).getGuid().equals(guid)) {
                this.getTagIndex().get(i).setUpdateSequenceNum(sequence);
                i = this.tagIndex.size() + 1;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving ListManager.updateTagSequence");
    }

    public void updateTagGuid(String oldGuid, String newGuid) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.updateTagGuid");
        this.conn.getTagTable().updateTagGuid(oldGuid, newGuid);
        int i = 0;
        while (i < this.tagIndex.size()) {
            if (this.tagIndex.get(i).getGuid().equals(oldGuid)) {
                this.tagIndex.get(i).setGuid(newGuid);
                i = this.tagIndex.size() + 1;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving ListManager.updateTagGuid");
    }

    public List<Tag> findAllChildren(String guid) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        return this.findAllChildrenRecursive(guid, tags);
    }

    public List<Tag> findAllChildrenRecursive(String guid, List<Tag> tags) {
        int i = 0;
        while (i < this.getTagIndex().size()) {
            if (this.getTagIndex().get(i).getParentGuid() != null && this.getTagIndex().get(i).getParentGuid().equals(guid)) {
                tags.add(this.getTagIndex().get(i));
                tags = this.findAllChildrenRecursive(this.getTagIndex().get(i).getGuid(), tags);
            }
            ++i;
        }
        return tags;
    }

    public boolean checkNoteForChildTags(String guid, List<String> noteTags) {
        boolean returnValue = false;
        List<Tag> children = this.findAllChildren(guid);
        int i = 0;
        while (i < noteTags.size()) {
            String noteTag = noteTags.get(i);
            int j = 0;
            while (j < children.size()) {
                if (noteTag.equals(children.get(j).getGuid())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public void deleteNotebook(String guid) {
        int i = 0;
        while (i < this.getNotebookIndex().size()) {
            if (this.getNotebookIndex().get(i).getGuid().equals(guid)) {
                this.getNotebookIndex().remove(i);
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        this.conn.getNotebookTable().expungeNotebook(guid, true);
    }

    public void renameStack(String oldName, String newName) {
        int i = 0;
        while (i < this.getNotebookIndex().size()) {
            if (this.getNotebookIndex().get(i).getStack() != null && this.getNotebookIndex().get(i).getStack().equalsIgnoreCase(oldName)) {
                this.getNotebookIndex().get(i).setStack(newName);
            }
            ++i;
        }
    }

    public void updateNotebookSequence(String guid, int sequence) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.updateNotebookSequence");
        this.conn.getNotebookTable().updateNotebookSequence(guid, sequence);
        int i = 0;
        while (i < this.notebookIndex.size()) {
            if (this.notebookIndex.get(i).getGuid().equals(guid)) {
                this.notebookIndex.get(i).setUpdateSequenceNum(sequence);
                i = this.notebookIndex.size() + 1;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving ListManager.updateNotebookSequence");
    }

    public void updateNotebookGuid(String oldGuid, String newGuid) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.updateNotebookGuid");
        this.conn.getNotebookTable().updateNotebookGuid(oldGuid, newGuid);
        int i = 0;
        while (i < this.notebookIndex.size()) {
            if (this.notebookIndex.get(i).getGuid().equals(oldGuid)) {
                this.notebookIndex.get(i).setGuid(newGuid);
                i = this.notebookIndex.size() + 1;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving ListManager.updateNotebookGuid");
    }

    public void updateNotebookStack(String oldGuid, String stack) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.updateNotebookGuid");
        this.conn.getNotebookTable().setStack(oldGuid, stack);
        int i = 0;
        while (i < this.notebookIndex.size()) {
            if (this.notebookIndex.get(i).getGuid().equals(oldGuid)) {
                this.notebookIndex.get(i).setStack(stack);
                i = this.notebookIndex.size() + 1;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving ListManager.updateNotebookGuid");
    }

    public void noteDownloaded(Note n) {
        boolean found = false;
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(n.getGuid())) {
                this.getMasterNoteIndex().set(i, n);
                found = true;
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        if (!found) {
            this.getMasterNoteIndex().add(n);
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(n.getGuid())) {
                if (this.filterRecord(this.getNoteIndex().get(i))) {
                    this.getNoteIndex().add(n);
                }
                this.getNoteIndex().remove(i);
                i = this.getNoteIndex().size();
            }
            ++i;
        }
        if (this.filterRecord(n)) {
            this.getNoteIndex().add(n);
        }
    }

    public boolean filterRecord(Note n) {
        boolean goodNotebook = false;
        boolean goodTag = false;
        boolean goodStatus = false;
        if (!n.isActive() && Global.showDeleted) {
            return true;
        }
        if (n.isActive() && !Global.showDeleted) {
            goodStatus = true;
        }
        if (goodStatus) {
            goodNotebook = this.filterByNotebook(n.getNotebookGuid());
        }
        if (goodNotebook) {
            goodTag = this.filterByTag(n.getTagGuids());
        }
        if (goodTag) {
            boolean goodCreatedBefore = false;
            boolean goodCreatedSince = false;
            boolean goodChangedBefore = false;
            boolean goodChangedSince = false;
            boolean goodContains = false;
            goodCreatedBefore = !Global.createdBeforeFilter.hasSelection() ? true : Global.createdBeforeFilter.check(n);
            goodCreatedSince = !Global.createdSinceFilter.hasSelection() ? true : Global.createdSinceFilter.check(n);
            goodChangedBefore = !Global.changedBeforeFilter.hasSelection() ? true : Global.changedBeforeFilter.check(n);
            goodChangedSince = !Global.changedSinceFilter.hasSelection() ? true : Global.changedSinceFilter.check(n);
            goodContains = !Global.containsFilter.hasSelection() ? true : Global.containsFilter.check(this.conn.getNoteTable(), n);
            if (goodCreatedSince && goodCreatedBefore && goodChangedSince && goodChangedBefore && goodContains) {
                return true;
            }
        }
        return false;
    }

    public void refreshCounters() {
        if (!this.refreshCounters) {
            return;
        }
        this.refreshCounters = false;
        this.tagCounterRunner.abortCount = true;
        this.notebookCounterRunner.abortCount = true;
        this.trashCounterRunner.abortCount = true;
        this.countNotebookResults(this.getNoteIndex());
        this.countTagResults(this.getNoteIndex());
        this.reloadTrashCount();
    }

    public void loadNotesIndex() {
        this.logger.log(this.logger.EXTREME, "Entering ListManager.loadNotesIndex()");
        List<Note> matches = this.enSearchChanged || this.getMasterNoteIndex() == null ? this.enSearch.matchWords() : this.getMasterNoteIndex();
        if (matches == null) {
            matches = this.getMasterNoteIndex();
        }
        this.setNoteIndex(new ArrayList<Note>());
        int i = 0;
        while (i < matches.size()) {
            if (this.filterRecord(matches.get(i))) {
                this.getNoteIndex().add(matches.get(i));
            }
            ++i;
        }
        this.refreshCounters = true;
        this.enSearchChanged = false;
        this.logger.log(this.logger.EXTREME, "Leaving ListManager.loadNotesIndex()");
    }

    public void countNotebookResults(List<Note> index) {
        this.logger.log(this.logger.EXTREME, "Entering ListManager.countNotebookResults()");
        this.notebookCounterRunner.abortCount = true;
        if (!Global.mimicEvernoteInterface) {
            this.notebookCounterRunner.setNoteIndex(index);
        } else {
            this.notebookCounterRunner.setNoteIndex(this.getMasterNoteIndex());
        }
        this.notebookCounterRunner.release(CounterRunner.NOTEBOOK);
        this.logger.log(this.logger.EXTREME, "Leaving ListManager.countNotebookResults()");
    }

    public void countTagResults(List<Note> index) {
        this.logger.log(this.logger.EXTREME, "Entering ListManager.countTagResults");
        this.trashCounterRunner.abortCount = true;
        if (!Global.tagBehavior().equalsIgnoreCase("DoNothing")) {
            this.tagCounterRunner.setNoteIndex(index);
        } else {
            this.tagCounterRunner.setNoteIndex(this.getMasterNoteIndex());
        }
        this.tagCounterRunner.release(CounterRunner.TAG);
        this.logger.log(this.logger.EXTREME, "Leaving ListManager.countTagResults()");
    }

    public void reloadTrashCount() {
        this.logger.log(this.logger.EXTREME, "Entering ListManager.reloadTrashCount");
        this.trashCounterRunner.abortCount = true;
        this.trashCounterRunner.setNoteIndex(this.getMasterNoteIndex());
        this.trashCounterRunner.release(CounterRunner.TRASH);
        this.logger.log(this.logger.EXTREME, "Leaving ListManager.reloadTrashCount");
    }

    private boolean filterByNotebook(String guid) {
        boolean good = false;
        if (this.selectedNotebooks.size() == 0) {
            good = true;
        }
        if (!good && this.selectedNotebooks.contains(guid)) {
            good = true;
        }
        int i = 0;
        while (i < this.getArchiveNotebookIndex().size() && good) {
            if (guid.equals(this.getArchiveNotebookIndex().get(i).getGuid())) {
                good = false;
                return good;
            }
            ++i;
        }
        return good;
    }

    private boolean filterByTag(List<String> noteTags) {
        if (noteTags == null || this.selectedTags == null) {
            return true;
        }
        if (this.selectedTags.size() == 0) {
            return true;
        }
        if (!Global.anyTagSelectionMatch()) {
            int i = 0;
            while (i < this.selectedTags.size()) {
                String selectedGuid = this.selectedTags.get(i);
                boolean childMatch = false;
                if (Global.includeTagChildren()) {
                    childMatch = this.checkNoteForChildTags(selectedGuid, noteTags);
                    if (!noteTags.contains(selectedGuid) && !childMatch) {
                        return false;
                    }
                } else if (!noteTags.contains(selectedGuid)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int i = 0;
        while (i < this.selectedTags.size()) {
            String selectedGuid = this.selectedTags.get(i);
            if (noteTags.contains(selectedGuid)) {
                return true;
            }
            if (Global.includeTagChildren() && this.checkNoteForChildTags(selectedGuid, noteTags)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setNoteSynchronized(String guid, boolean value) {
        this.getNoteTableModel().updateNoteSyncStatus(guid, value);
    }

    public void updateNoteTitleColor(String guid, Integer color) {
        NoteMetadata meta = this.getNoteMetadata().get(guid);
        if (meta != null) {
            this.noteModel.updateNoteTitleColor(guid, color);
            meta.setColor(color);
            this.conn.getNoteTable().updateNoteMetadata(meta);
        }
    }

    public void loadNoteTitleColors() {
        this.noteModel.setMetaData(this.getNoteMetadata());
    }

    public void setIndexNeeded(String guid, String type, Boolean b) {
        if (Global.keepRunning && type.equalsIgnoreCase("content")) {
            this.conn.getNoteTable().setIndexNeeded(guid, false);
        }
        if (Global.keepRunning && type.equalsIgnoreCase("resource")) {
            this.conn.getNoteTable().noteResourceTable.setIndexNeeded(guid, b);
        }
    }

    public boolean threadCheck(int id) {
        if (id == 6) {
            return this.notebookThread.isAlive();
        }
        if (id == 2) {
            return this.tagThread.isAlive();
        }
        if (id == 3) {
            return this.trashThread.isAlive();
        }
        if (id == 5) {
            return this.saveThread.isAlive();
        }
        return false;
    }

    public void compactDatabase() {
        this.conn.compactDatabase();
    }

    public List<String> scanNoteForResources(Note n) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.scanNoteForResources");
        this.logger.log(this.logger.EXTREME, "Note guid: " + n.getGuid());
        QDomDocument doc = new QDomDocument();
        QDomDocument.Result result = doc.setContent(n.getContent());
        if (!result.success) {
            this.logger.log(this.logger.MEDIUM, "Parse error when scanning note for resources.");
            this.logger.log(this.logger.MEDIUM, "Note guid: " + n.getGuid());
            return null;
        }
        ArrayList<String> returnArray = new ArrayList<String>();
        QDomNodeList anchors = doc.elementsByTagName("en-media");
        int i = 0;
        while (i < anchors.length()) {
            QDomElement enmedia = anchors.at(i).toElement();
            if (enmedia.hasAttribute("type")) {
                QDomAttr hash = enmedia.attributeNode("hash");
                returnArray.add(hash.value().toString());
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving ListManager.scanNoteForResources");
        return returnArray;
    }

    public String getTagNamesForNote(Note n) {
        StringBuffer buffer = new StringBuffer(100);
        Vector<String> v = new Vector<String>();
        List guids = n.getTagGuids();
        if (guids == null) {
            return "";
        }
        int i = 0;
        while (i < guids.size()) {
            v.add(this.getTagNameByGuid((String)guids.get(i)));
            ++i;
        }
        Comparator comparator = Collections.reverseOrder();
        Collections.sort(v, comparator);
        Collections.reverse(v);
        int i2 = 0;
        while (i2 < v.size()) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            buffer.append((String)v.get(i2));
            ++i2;
        }
        return buffer.toString();
    }

    public String getTagNameByGuid(String guid) {
        int i = 0;
        while (i < this.getTagIndex().size()) {
            String s = this.getTagIndex().get(i).getGuid();
            if (s.equals(guid)) {
                return this.getTagIndex().get(i).getName();
            }
            ++i;
        }
        return "";
    }

    public String getNotebookNameByGuid(String guid) {
        if (this.notebookIndex == null) {
            return null;
        }
        int i = 0;
        while (i < this.notebookIndex.size()) {
            String s = this.notebookIndex.get(i).getGuid();
            if (s.equals(guid)) {
                return this.notebookIndex.get(i).getName();
            }
            ++i;
        }
        return "";
    }

    public void reloadNoteTagNames(String tagGuid, String newName) {
        int j;
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            j = 0;
            while (j < this.getMasterNoteIndex().get(i).getTagGuids().size()) {
                if (((String)this.getMasterNoteIndex().get(i).getTagGuids().get(j)).equals(tagGuid)) {
                    this.getMasterNoteIndex().get(i).getTagNames().set(j, newName);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            j = 0;
            while (j < this.getNoteIndex().get(i).getTagGuids().size()) {
                if (((String)this.getNoteIndex().get(i).getTagGuids().get(j)).equals(tagGuid)) {
                    this.getNoteIndex().get(i).getTagNames().set(j, newName);
                }
                ++j;
            }
            ++i;
        }
    }
}

