/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.oauth;

import com.trolltech.qt.core.QUrl;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QWidget;
import com.trolltech.qt.network.QNetworkAccessManager;
import com.trolltech.qt.network.QSslSocket;
import com.trolltech.qt.webkit.QWebView;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.oauth.NNOAuthNetworkAccessManager;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class OAuthWindow
extends QDialog {
    private static final String consumerKey = "kimaira792";
    private static final String consumerSecret = "c66506a41c02bf12";
    public String response;
    private final String temporaryCredUrl;
    private final String permanentCredUrl;
    static final String urlBase = "https://" + Global.getServer();
    public boolean error;
    public String errorMessage;
    static final String requestTokenUrl = String.valueOf(urlBase) + "/oauth";
    static final String accessTokenUrl = String.valueOf(urlBase) + "/oauth";
    static final String authorizationUrlBase = String.valueOf(urlBase) + "/OAuth.action";
    private final String iconPath = new String("classpath:cx/fbn/nevernote/");
    private final QWebView tempPage;
    private final QWebView authPage;
    private final QGridLayout grid;
    private NNOAuthNetworkAccessManager manager;
    static final String callbackUrl = "index.jsp?action=callbackReturn";
    private final ApplicationLogger logger;

    public OAuthWindow(ApplicationLogger l) {
        this.logger = l;
        int millis = (int)System.currentTimeMillis();
        int time = millis / 1000;
        this.temporaryCredUrl = "https://" + Global.getServer() + "/oauth?oauth_consumer_key=" + consumerKey + "&oauth_signature=" + consumerSecret + "%26&oauth_signature_method=PLAINTEXT&oauth_timestamp=" + String.valueOf(time) + "&oauth_nonce=" + String.valueOf(millis) + "&oauth_callback=nnoauth";
        this.permanentCredUrl = "https://" + Global.getServer() + "/oauth?oauth_consumer_key=" + consumerKey + "&oauth_signature=" + consumerSecret + "%26&oauth_signature_method=PLAINTEXT&oauth_timestamp=" + String.valueOf(time) + "&oauth_nonce=" + String.valueOf(millis) + "&oauth_token=";
        this.setWindowTitle(this.tr("Please Grant NeighborNote Access"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "icons/password.png"));
        this.grid = new QGridLayout();
        this.setLayout((QLayout)this.grid);
        this.tempPage = new QWebView();
        this.authPage = new QWebView();
        this.grid.addWidget((QWidget)this.authPage);
        this.tempPage.loadFinished.connect((Object)this, "temporaryCredentialsReceived()");
        this.error = false;
        this.errorMessage = "";
        this.logger.log(this.logger.MEDIUM, "SSL Sockets Supported: " + QSslSocket.supportsSsl());
        if (!QSslSocket.supportsSsl()) {
            this.errorMessage = new String(this.tr("SSL Support not found.  Aborting connection"));
            this.error = true;
        }
        QUrl tu = new QUrl(this.temporaryCredUrl);
        this.tempPage.load(tu);
    }

    public void temporaryCredentialsReceived() {
        this.logger.log(this.logger.MEDIUM, "Temporary Credentials Received");
        String contents = this.tempPage.page().mainFrame().toPlainText();
        this.logger.log(this.logger.MEDIUM, "Temporary Credentials:" + contents);
        int index = contents.indexOf("&oauth_token_secret");
        if (index > 0) {
            contents = contents.substring(0, index);
            QUrl accessUrl = new QUrl(String.valueOf(urlBase) + "/OAuth.action?" + contents);
            this.manager = new NNOAuthNetworkAccessManager(this.logger);
            this.authPage.page().setNetworkAccessManager((QNetworkAccessManager)this.manager);
            this.manager.tokenFound.connect((Object)this, "tokenFound(String)");
            this.authPage.load(accessUrl);
            this.grid.addWidget((QWidget)this.authPage);
        } else {
            this.error = true;
            this.errorMessage = new String(this.tr("OAuth error retrieving temporary token"));
            this.close();
        }
    }

    public void tokenFound(String token) {
        this.logger.log(this.logger.MEDIUM, "*** TOKEN *** " + token);
        if (token.indexOf("auth_verifier") <= 0) {
            this.errorMessage = new String(this.tr("Error receiving authorization"));
            this.error = true;
            this.close();
        }
        this.tempPage.disconnect();
        this.tempPage.loadFinished.connect((Object)this, "permanentCredentialsReceived()");
        this.logger.log(this.logger.HIGH, "Permanent URL: " + this.permanentCredUrl + token);
        this.tempPage.load(new QUrl(String.valueOf(this.permanentCredUrl) + token));
    }

    public void permanentCredentialsReceived() {
        String contents = this.tempPage.page().mainFrame().toPlainText();
        if (contents.startsWith("oauth_token=S%3D")) {
            this.logger.log(this.logger.HIGH, "Permanent Credentials:" + contents);
            try {
                this.response = "";
                String decoded = URLDecoder.decode(contents, "UTF-8");
                this.logger.log(this.logger.HIGH, "Decoded URL:" + decoded);
                this.response = decoded;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.close();
        }
    }
}

