/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.trolltech.qt.core.QSize;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QDockWidget;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QMessageBox;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QSizePolicy;
import com.trolltech.qt.gui.QToolBar;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.NeverNote;
import cx.fbn.nevernote.gui.RensoNoteList;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.threads.SyncRunner;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;

public class RensoNoteListDock
extends QDockWidget {
    private final DatabaseConnection conn;
    private final NeverNote parent;
    private final SyncRunner syncRunner;
    private final ApplicationLogger logger = new ApplicationLogger("rensoNoteList.log");
    private final QPushButton haltLogButton;
    private final QComboBox weightingModeSelect;
    private final RensoNoteList rensoNoteList;
    private final QToolBar rensoToolBar;
    private final String iconPath;

    public RensoNoteListDock(DatabaseConnection conn, NeverNote parent, SyncRunner syncRunner, String iconPath, String title) {
        super(title);
        this.logger.log(this.logger.HIGH, "Setting up rensoNoteListDock");
        this.conn = conn;
        this.parent = parent;
        this.iconPath = iconPath;
        this.syncRunner = syncRunner;
        QVBoxLayout vLayout = new QVBoxLayout();
        this.rensoToolBar = new QToolBar();
        vLayout.addWidget((QWidget)this.rensoToolBar);
        QLabel modeLabel = new QLabel(this.tr("Mode: "));
        modeLabel.setToolTip(this.tr("Preset Weighting Mode"));
        this.rensoToolBar.addWidget((QWidget)modeLabel);
        this.weightingModeSelect = new QComboBox();
        this.weightingModeSelect.setMaximumWidth(150);
        this.weightingModeSelect.setToolTip(this.tr("Preset Weighting Mode"));
        this.weightingModeSelect.insertItem(PresetMode.Standard.ordinal(), this.tr("Standard"));
        this.weightingModeSelect.insertItem(PresetMode.ConcurrentBrowse.ordinal(), this.tr("Concurrent Browse"));
        this.weightingModeSelect.insertItem(PresetMode.OperationToOrganize.ordinal(), this.tr("Operation to Organize"));
        this.weightingModeSelect.insertItem(PresetMode.ContentSimilarity.ordinal(), this.tr("Content Similarity"));
        this.weightingModeSelect.insertItem(PresetMode.Custom.ordinal(), this.tr("Custom"));
        int savedModeIndex = 0;
        try {
            savedModeIndex = PresetMode.valueOf(Global.rensoWeightingSelect()).ordinal();
        }
        catch (Exception e) {
            this.logger.log(this.logger.EXTREME, "Exception in weightingModeSelect = " + e);
        }
        if (savedModeIndex >= 0) {
            this.weightingModeSelect.setCurrentIndex(savedModeIndex);
        } else {
            this.weightingModeSelect.setCurrentIndex(0);
        }
        this.weightingModeSelect.currentIndexChanged.connect((Object)this, "weightingModeChanged(int)");
        this.rensoToolBar.addWidget((QWidget)this.weightingModeSelect);
        this.haltLogButton = new QPushButton();
        QIcon haltLogIcon = new QIcon(String.valueOf(this.iconPath) + "haltLog.png");
        this.haltLogButton.setIcon(haltLogIcon);
        this.haltLogButton.setIconSize(new QSize(24, 24));
        this.haltLogButton.setToolTip(this.tr("Halt Collectiong Operation Log"));
        this.haltLogButton.setCheckable(true);
        this.haltLogButton.setChecked(Global.isHaltLogButton());
        this.haltLogButton.toggled.connect((Object)this, "haltLogToggled(boolean)");
        QWidget spacer = new QWidget();
        spacer.setSizePolicy(QSizePolicy.Policy.Expanding, QSizePolicy.Policy.Expanding);
        this.rensoToolBar.addWidget(spacer);
        this.rensoToolBar.addWidget((QWidget)this.haltLogButton);
        this.rensoNoteList = new RensoNoteList(this.conn, this.parent, this.syncRunner, this.logger);
        this.getRensoNoteList().itemPressed.connect((Object)this.parent, "rensoNoteItemPressed(QListWidgetItem)");
        vLayout.addWidget((QWidget)this.getRensoNoteList());
        QWidget w = new QWidget();
        w.setLayout((QLayout)vLayout);
        this.setWidget(w);
    }

    private void weightingModeChanged(int modeIndex) {
        this.logger.log(this.logger.EXTREME, "RensoNoteListDock.weightingModeChanged modeIndex = " + modeIndex);
        PresetMode mode = Global.fromOrdinal(PresetMode.class, modeIndex);
        EnumMap<PresetMode, List<Integer>> presetMap = new EnumMap<PresetMode, List<Integer>>(PresetMode.class);
        presetMap.put(PresetMode.Standard, Arrays.asList(1, 3, 3, 10, 2, 2, 5));
        presetMap.put(PresetMode.ConcurrentBrowse, Arrays.asList(5, 2, 3, 10, 1, 1, 2));
        presetMap.put(PresetMode.OperationToOrganize, Arrays.asList(1, 2, 3, 10, 5, 5, 2));
        presetMap.put(PresetMode.ContentSimilarity, Arrays.asList(1, 2, 2, 10, 1, 1, 10));
        presetMap.put(PresetMode.Custom, Arrays.asList(Global.customBrowseWeight(), Global.customCopyPasteWeight(), Global.customAddNewNoteWeight(), Global.customRensoItemClickWeight(), Global.customSameTagWeight(), Global.customSameNotebookWeight(), Global.customENRelatedNotesWeight()));
        ArrayList weightList = new ArrayList((Collection)presetMap.get((Object)mode));
        Global.setBrowseWeight((Integer)weightList.get(0));
        Global.setCopyPasteWeight((Integer)weightList.get(1));
        Global.setAddNewNoteWeight((Integer)weightList.get(2));
        Global.setRensoItemClickWeight((Integer)weightList.get(3));
        Global.setSameTagWeight((Integer)weightList.get(4));
        Global.setSameNotebookWeight((Integer)weightList.get(5));
        Global.setENRelatedNotesWeight((Integer)weightList.get(6));
        Global.saveRensoWeightingSelect(mode.name());
        if (this.rensoNoteList != null && this.rensoNoteList.getGuid() != null) {
            this.rensoNoteList.refreshRensoNoteList();
            if (mode == PresetMode.Custom) {
                QMessageBox.information((QWidget)this, (String)this.tr("Information"), (String)this.tr("Custom mode was selected.\nYou can customize weighting manually in the Edit/Preferences/Renso Note List."));
            }
        }
    }

    private void haltLogToggled(boolean checked) {
        this.logger.log(this.logger.EXTREME, "RensoNoteListDock.haltLogToggled");
        if (checked) {
            QMessageBox.information((QWidget)this, (String)this.tr("Information"), (String)this.tr("Collecting operation log halted.\nYou can resume, if you press this button again."));
        }
        Global.saveHaltLogButton(checked);
    }

    public RensoNoteList getRensoNoteList() {
        return this.rensoNoteList;
    }

    private static enum PresetMode {
        Standard,
        ConcurrentBrowse,
        OperationToOrganize,
        ContentSimilarity,
        Custom;

    }
}

