/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.threads;

import com.evernote.edam.type.User;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QMutex;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.gui.QPixmap;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.oauth.OAuthTokenizer;
import cx.fbn.nevernote.signals.ENThumbnailSignal;
import cx.fbn.nevernote.signals.LimitSignal;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.AESEncrypter;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class ENThumbnailRunner
extends QObject
implements Runnable {
    private final ApplicationLogger logger;
    private final DatabaseConnection conn;
    public volatile ENThumbnailSignal enThumbnailSignal;
    public QMutex mutex;
    private volatile boolean keepRunning;
    private volatile LinkedBlockingQueue<String> workQueue;
    public volatile LimitSignal limitSignal;
    private volatile User user;
    private volatile String serverUrl;

    public ENThumbnailRunner(String logname, int t, String u, String i, String r, String b, String uid, String pswd, String cpswd) {
        this.logger = new ApplicationLogger(logname);
        this.conn = new DatabaseConnection(this.logger, u, i, r, b, uid, pswd, cpswd, 0);
        this.enThumbnailSignal = new ENThumbnailSignal();
        this.mutex = new QMutex();
        this.keepRunning = true;
        this.workQueue = new LinkedBlockingQueue();
        this.limitSignal = new LimitSignal();
        this.user = new User();
        this.serverUrl = "";
    }

    @Override
    public void run() {
        this.thread().setPriority(1);
        this.logger.log(this.logger.MEDIUM, "ENThumbnail\u30b9\u30ec\u30c3\u30c9\u958b\u59cb");
        while (this.keepRunning) {
            try {
                String work = this.workQueue.take();
                this.mutex.lock();
                if (work.startsWith("GET")) {
                    String guid = work.replace("GET ", "");
                    this.logger.log(this.logger.EXTREME, "Evernote\u30b5\u30e0\u30cd\u30a4\u30eb\u53d6\u5f97\u958b\u59cb guid = " + guid);
                    QByteArray thumbnailData = this.getENThumbnailData(guid);
                    if (thumbnailData == null) {
                        this.logger.log(this.logger.EXTREME, "Evernote\u30b5\u30e0\u30cd\u30a4\u30eb\u306e\u53d6\u5f97\u306b\u5931\u6557");
                    } else {
                        QPixmap thumbnail_p = new QPixmap();
                        thumbnail_p.loadFromData(thumbnailData);
                        this.logger.log(this.logger.EXTREME, "Evernote\u30b5\u30e0\u30cd\u30a4\u30eb\u306e\u53d6\u5f97\u306b\u6210\u529f");
                        this.saveImage(thumbnail_p, guid);
                        this.registImage(thumbnailData, guid);
                    }
                    this.enThumbnailSignal.getENThumbnailFinished.emit((Object)guid);
                    this.logger.log(this.logger.EXTREME, "Evernote\u30b5\u30e0\u30cd\u30a4\u30eb\u53d6\u5f97\u5b8c\u4e86 guid = " + guid);
                } else if (work.startsWith("STOP")) {
                    this.logger.log(this.logger.MEDIUM, "ENThumbnail\u30b9\u30ec\u30c3\u30c9\u505c\u6b62");
                    this.keepRunning = false;
                }
                this.mutex.unlock();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Loose catch block
     */
    private synchronized QByteArray getENThumbnailData(String guid) {
        String shardId = this.user.getShardId();
        if (shardId == null || shardId.equals("")) {
            return null;
        }
        OAuthTokenizer tokenizer = new OAuthTokenizer();
        AESEncrypter aes = new AESEncrypter();
        try {
            aes.decrypt(new FileInputStream(Global.getFileManager().getHomeDirFile("oauth.txt")));
        }
        catch (FileNotFoundException e) {
            this.logger.log(this.logger.HIGH, "Evernote\u30b5\u30e0\u30cd\u30a4\u30eb\u53d6\u5f97\u4e2d\u306b\u4f8b\u5916\u767a\u751f\uff1aFileNotFoundException");
            e.printStackTrace();
        }
        String authString = aes.getString();
        String oauthToken = new String();
        if (!authString.equals("")) {
            tokenizer.tokenize(authString);
            oauthToken = tokenizer.oauth_token;
        }
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPost httpPost = new HttpPost("https://" + this.serverUrl + "/shard/" + this.user.getShardId() + "/thm/note/" + guid + ".png");
        httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
        httpPost.setHeader("Host", this.getServerUrl());
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(2);
        nameValuePairs.add(new BasicNameValuePair("auth", oauthToken));
        nameValuePairs.add(new BasicNameValuePair("size", "80"));
        QByteArray data = new QByteArray();
        try {
            try {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
                HttpResponse response = null;
                response = httpClient.execute((HttpUriRequest)httpPost);
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                data = new QByteArray(bytes);
            }
            catch (UnsupportedEncodingException e) {
                this.logger.log(this.logger.HIGH, "Evernote\u30b5\u30e0\u30cd\u30a4\u30eb\u53d6\u5f97\u4e2d\u306b\u4f8b\u5916\u767a\u751f\uff1aUnsupportedEncodingException");
                e.printStackTrace();
                httpClient.getConnectionManager().shutdown();
                return null;
            }
            catch (ClientProtocolException e) {
                this.logger.log(this.logger.HIGH, "Evernote\u30b5\u30e0\u30cd\u30a4\u30eb\u53d6\u5f97\u4e2d\u306b\u4f8b\u5916\u767a\u751f\uff1aClientProtocolException");
                e.printStackTrace();
                httpClient.getConnectionManager().shutdown();
                return null;
            }
            catch (IOException e) {
                this.logger.log(this.logger.HIGH, "Evernote\u30b5\u30e0\u30cd\u30a4\u30eb\u53d6\u5f97\u4e2d\u306b\u4f8b\u5916\u767a\u751f\uff1aIOException");
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                httpClient.getConnectionManager().shutdown();
                return null;
            }
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return data;
    }

    private synchronized void saveImage(QPixmap thumbnail, String guid) {
        String thumbnailName = Global.getFileManager().getResDirPath("enThumbnail-" + guid + ".png");
        thumbnail.save(thumbnailName, "PNG");
    }

    private synchronized void registImage(QByteArray data, String guid) {
        this.conn.getNoteTable().setENThumbnail(guid, data);
    }

    public boolean isKeepRunning() {
        return this.keepRunning;
    }

    public void setKeepRunning(boolean keepRunning) {
        this.keepRunning = keepRunning;
    }

    public boolean addGuid(String guid) {
        return this.workQueue.offer("GET " + guid);
    }

    public boolean addStop() {
        return this.workQueue.offer("STOP");
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }
}

