/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.WatchFolderRecord;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.ListManager;
import java.util.ArrayList;
import java.util.List;

public class WatchFolderTable {
    ListManager parent;
    private final ApplicationLogger logger;
    private final DatabaseConnection db;

    public WatchFolderTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.HIGH, "Creating table WatchFolder...");
        if (!query.exec("Create table WatchFolders (folder varchar primary key, notebook varchar,keep boolean, depth integer)")) {
            // empty if block
        }
        this.logger.log(this.logger.HIGH, "Table WatchFolders creation FAILED!!!");
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Drop table WatchFolders");
    }

    public void addWatchFolder(String folder, String notebook, boolean keep, int depth) {
        if (this.exists(folder)) {
            this.expungeWatchFolder(folder);
        }
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Insert Into WatchFolders (folder, notebook, keep, depth) values (:folder, :notebook, :keep, :depth)");
        query.bindValue(":folder", folder);
        query.bindValue(":notebook", notebook);
        query.bindValue(":keep", keep);
        query.bindValue(":depth", depth);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "Insert into WatchFolder failed.");
        }
    }

    public boolean exists(String folder) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select folder from WatchFolders where folder=:folder ");
        query.bindValue(":folder", folder);
        query.exec();
        return query.next();
    }

    public void expungeWatchFolder(String folder) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("delete from WatchFolders where folder=:folder");
        query.bindValue(":folder", folder);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "Expunge WatchFolder failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void expungeAll() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.exec("delete from WatchFolders")) {
            this.logger.log(this.logger.MEDIUM, "Expunge all WatchFolder failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public List<WatchFolderRecord> getAll() {
        this.logger.log(this.logger.HIGH, "Entering RWatchFolders.getAll");
        ArrayList<WatchFolderRecord> list = new ArrayList<WatchFolderRecord>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Select folder, (select name from notebook where guid = notebook), keep, depth from WatchFolders");
        while (query.next()) {
            WatchFolderRecord record = new WatchFolderRecord();
            record.folder = query.valueString(0);
            record.notebook = query.valueString(1);
            record.keep = new Boolean(query.valueString(2));
            record.depth = new Integer(query.valueString(3));
            list.add(record);
        }
        this.logger.log(this.logger.HIGH, "Leaving RWatchFolders.getAll");
        return list;
    }

    public String getNotebook(String dir) {
        this.logger.log(this.logger.HIGH, "Entering RWatchFolders.getNotebook");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select notebook from WatchFolders where folder=:dir");
        query.bindValue(":dir", dir);
        query.exec();
        String response = null;
        while (query.next()) {
            response = query.valueString(0);
        }
        this.logger.log(this.logger.HIGH, "Leaving RWatchFolders.getNotebook");
        return response;
    }
}

