/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.Tag;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.NoteTable;
import cx.fbn.nevernote.sql.NoteTagsRecord;
import cx.fbn.nevernote.sql.NotebookTable;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class REnSearch {
    private final List<String> searchWords;
    private final List<String> searchPhrases;
    private final List<String> notebooks;
    private final List<String> tags;
    private final List<String> intitle;
    private final List<String> created;
    private final List<String> updated;
    private final List<String> resource;
    private final List<String> subjectDate;
    private final List<String> longitude;
    private final List<String> latitude;
    private final List<String> altitude;
    private final List<String> author;
    private final List<String> source;
    private final List<String> sourceApplication;
    private final List<String> recoType;
    private final List<String> todo;
    private final List<String> stack;
    private final List<Tag> tagIndex;
    private final ApplicationLogger logger;
    private boolean any;
    private int minimumRecognitionWeight = 80;
    private final DatabaseConnection conn;

    public REnSearch(DatabaseConnection c, ApplicationLogger l, String s, List<Tag> t, int r) {
        this.logger = l;
        this.conn = c;
        this.tagIndex = t;
        this.minimumRecognitionWeight = r;
        this.searchWords = new ArrayList<String>();
        this.searchPhrases = new ArrayList<String>();
        this.notebooks = new ArrayList<String>();
        this.tags = new ArrayList<String>();
        this.intitle = new ArrayList<String>();
        this.created = new ArrayList<String>();
        this.updated = new ArrayList<String>();
        this.resource = new ArrayList<String>();
        this.subjectDate = new ArrayList<String>();
        this.longitude = new ArrayList<String>();
        this.latitude = new ArrayList<String>();
        this.altitude = new ArrayList<String>();
        this.author = new ArrayList<String>();
        this.source = new ArrayList<String>();
        this.sourceApplication = new ArrayList<String>();
        this.recoType = new ArrayList<String>();
        this.todo = new ArrayList<String>();
        this.any = false;
        this.stack = new ArrayList<String>();
        if (s == null) {
            return;
        }
        if (s.trim().equals("")) {
            return;
        }
        this.resolveSearch(s);
    }

    public List<String> getWords() {
        return this.searchWords;
    }

    public List<String> getNotebooks() {
        return this.notebooks;
    }

    public List<String> getIntitle() {
        return this.intitle;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<String> getResource() {
        return this.resource;
    }

    public List<String> getAuthor() {
        return this.author;
    }

    public List<String> getSource() {
        return this.source;
    }

    public List<String> getSourceApplication() {
        return this.sourceApplication;
    }

    public List<String> getRecoType() {
        return this.recoType;
    }

    public List<String> getToDo() {
        return this.todo;
    }

    public List<String> getLongitude() {
        return this.longitude;
    }

    public List<String> getLatitude() {
        return this.latitude;
    }

    public List<String> getAltitude() {
        return this.altitude;
    }

    public List<String> getCreated() {
        return this.created;
    }

    public List<String> getUpdated() {
        return this.updated;
    }

    public List<String> getSubjectDate() {
        return this.subjectDate;
    }

    public List<String> getStack() {
        return this.stack;
    }

    private boolean matchTagsAll(List<String> tagNames, List<String> list) {
        int j = 0;
        while (j < list.size()) {
            boolean negative = false;
            negative = false;
            if (list.get(j).startsWith("-")) {
                negative = true;
            }
            int pos = list.get(j).indexOf(":");
            String filterName = this.cleanupWord(list.get(j).substring(pos + 1));
            filterName = filterName.replace("*", ".*");
            if (tagNames.size() == 0 && !negative) {
                return false;
            }
            boolean matchFound = false;
            int i = 0;
            while (i < tagNames.size()) {
                boolean matches = Pattern.matches(filterName.toLowerCase(), tagNames.get(i).toLowerCase());
                if (matches) {
                    matchFound = true;
                }
                ++i;
            }
            if (negative) {
                boolean bl = matchFound = !matchFound;
            }
            if (!matchFound) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private boolean matchTagsAny(List<String> tagNames, List<String> list) {
        if (list.size() == 0) {
            return true;
        }
        boolean negative = false;
        int j = 0;
        while (j < list.size()) {
            negative = false;
            if (list.get(j).startsWith("-")) {
                negative = true;
            }
            int pos = list.get(j).indexOf(":");
            String filterName = this.cleanupWord(list.get(j).substring(pos + 1));
            filterName = filterName.replace("*", ".*");
            if (tagNames.size() == 0 && !negative) {
                return false;
            }
            int i = 0;
            while (i < tagNames.size()) {
                boolean matches = Pattern.matches(filterName.toLowerCase(), tagNames.get(i).toLowerCase());
                if (!matches && !negative) {
                    return false;
                }
                ++i;
            }
            ++j;
        }
        return true;
    }

    private boolean matchNotebook(String guid) {
        if (this.getNotebooks().size() == 0) {
            return true;
        }
        NotebookTable bookTable = new NotebookTable(this.logger, this.conn);
        List<Notebook> books = bookTable.getAll();
        String name = new String("");
        int i = 0;
        while (i < books.size()) {
            if (guid.equalsIgnoreCase(books.get(i).getGuid())) {
                name = books.get(i).getName();
                i = books.size();
            }
            ++i;
        }
        if (this.any) {
            return this.matchListAny(this.getNotebooks(), name);
        }
        return this.matchListAll(this.getNotebooks(), name);
    }

    private boolean matchNotebookStack(String guid) {
        if (this.getStack().size() == 0) {
            return true;
        }
        NotebookTable bookTable = new NotebookTable(this.logger, this.conn);
        List<Notebook> books = bookTable.getAll();
        String name = new String("");
        int i = 0;
        while (i < books.size()) {
            if (guid.equalsIgnoreCase(books.get(i).getGuid())) {
                name = books.get(i).getStack();
                i = books.size();
            }
            ++i;
        }
        if (name == null) {
            name = "";
        }
        if (this.any) {
            return this.matchListAny(this.getStack(), name);
        }
        return this.matchListAll(this.getStack(), name);
    }

    private boolean matchListAny(List<String> list, String title) {
        if (list.size() == 0) {
            return true;
        }
        boolean negative = false;
        boolean found = false;
        int i = 0;
        while (i < list.size()) {
            int pos = list.get(i).indexOf(":");
            negative = false;
            if (list.get(i).startsWith("-")) {
                negative = true;
            }
            String filterName = this.cleanupWord(list.get(i).substring(pos + 1));
            boolean matches = Pattern.matches((filterName = filterName.replace("*", ".*")).toLowerCase(), title.toLowerCase());
            if (matches) {
                found = true;
            }
            ++i;
        }
        if (negative) {
            return !found;
        }
        return found;
    }

    /*
     * Unable to fully structure code
     */
    private boolean matchContentAny(Note n) {
        if (this.todo.size() == 0 && this.resource.size() == 0 && this.searchPhrases.size() == 0) {
            return true;
        }
        n = this.conn.getNoteTable().getNote(n.getGuid(), true, true, false, false, false);
        text = StringEscapeUtils.unescapeHtml4((String)n.getContent().replaceAll("\\<.*?\\>", "")).toLowerCase();
        negative = false;
        i = 0;
        while (i < this.searchPhrases.size()) {
            phrase = this.searchPhrases.get(i);
            if (phrase.startsWith("-")) {
                negative = true;
                phrase = phrase.substring(1);
            } else {
                negative = false;
            }
            phrase = phrase.substring(1);
            phrase = phrase.substring(0, phrase.length() - 1);
            if (text.indexOf(phrase) >= 0) {
                return negative == false;
            }
            if (text.indexOf(phrase) < 0 && negative) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.todo.size()) {
            value = this.todo.get(i);
            if (!((value = value.replace("\"", "")).endsWith(":false") || value.endsWith(":true") || value.endsWith(":*") || value.endsWith("*"))) {
                return false;
            }
            desiredState = value.endsWith(":false") == false;
            if (value.startsWith("-")) {
                v0 = desiredState = desiredState == false;
            }
            if ((pos = n.getContent().indexOf("<en-todo")) == -1 && value.startsWith("-") && (value.endsWith("*") || value.endsWith(":"))) {
                return true;
            }
            if (!value.endsWith("*")) ** GOTO lbl40
            return true;
lbl-1000:
            // 1 sources

            {
                endPos = n.getContent().indexOf("/>", pos);
                segment = n.getContent().substring(pos, endPos);
                currentState = segment.toLowerCase().indexOf("checked=\"true\"") != -1;
                if (desiredState == currentState) {
                    return true;
                }
                pos = n.getContent().indexOf("<en-todo", pos + 1);
lbl40:
                // 2 sources

                ** while (pos > -1)
            }
lbl41:
            // 1 sources

            ++i;
        }
        i = 0;
        while (i < this.resource.size()) {
            resourceString = this.resource.get(i);
            if ((resourceString = resourceString.replace("\"", "")).startsWith("-")) {
                negative = true;
            }
            resourceString = resourceString.substring(resourceString.indexOf(":") + 1);
            j = 0;
            while (j < n.getResourcesSize()) {
                match = this.stringMatch(((Resource)n.getResources().get(j)).getMime(), resourceString, negative);
                if (match) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private void resolveSearch(String search) {
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer b = new StringBuffer(search);
        int len = search.length();
        int nextChar = 32;
        boolean quote = false;
        int i = 0;
        int j = 0;
        while (i < len) {
            if (search.charAt(i) == nextChar && !quote) {
                b.setCharAt(j, '\u0000');
                nextChar = 32;
            } else if (search.charAt(i) == '\"') {
                if (!quote) {
                    quote = true;
                } else {
                    quote = false;
                    b.insert(++j, "\u0000");
                }
            }
            if (i + 2 < len && search.charAt(i) == '\\') {
                i += 2;
            }
            ++i;
            ++j;
        }
        search = b.toString();
        int pos = 0;
        int i2 = 0;
        while (i2 < search.length()) {
            if (search.charAt(i2) == '\u0000') {
                search = search.substring(1);
                i2 = 0;
            } else {
                pos = search.indexOf(0);
                if (pos > 0) {
                    words.add(search.substring(0, pos).toLowerCase());
                    search = search.substring(pos);
                    i2 = 0;
                }
            }
            ++i2;
        }
        if (search.charAt(0) == '\u0000') {
            words.add(search.substring(1).toLowerCase());
        } else {
            words.add(search.toLowerCase());
        }
        this.parseTerms(words);
    }

    private void parseTerms(List<String> words) {
        int i = 0;
        while (i < words.size()) {
            String word = words.get(i);
            int pos = word.indexOf(":");
            if (word.startsWith("any:")) {
                this.any = true;
                word = word.substring(4).trim();
                pos = word.indexOf(":");
            }
            boolean searchPhrase = false;
            if (pos < 0 && word.indexOf(" ") > 0) {
                searchPhrase = true;
                this.searchPhrases.add(word.toLowerCase());
            }
            if (!searchPhrase && pos < 0 && word != null && word.length() > 0) {
                this.getWords().add(word);
            }
            if (word.startsWith("intitle:")) {
                this.intitle.add("*" + word + "*");
            }
            if (word.startsWith("-intitle:")) {
                this.intitle.add("*" + word + "*");
            }
            if (word.startsWith("notebook:")) {
                this.notebooks.add(word);
            }
            if (word.startsWith("-notebook:")) {
                this.notebooks.add(word);
            }
            if (word.startsWith("tag:")) {
                this.tags.add(word);
            }
            if (word.startsWith("-tag:")) {
                this.tags.add(word);
            }
            if (word.startsWith("resource:")) {
                this.resource.add(word);
            }
            if (word.startsWith("-resource:")) {
                this.resource.add(word);
            }
            if (word.startsWith("author:")) {
                this.author.add(word);
            }
            if (word.startsWith("-author:")) {
                this.author.add(word);
            }
            if (word.startsWith("source:")) {
                this.source.add(word);
            }
            if (word.startsWith("-source:")) {
                this.source.add(word);
            }
            if (word.startsWith("sourceapplication:")) {
                this.sourceApplication.add(word);
            }
            if (word.startsWith("-sourceapplication:")) {
                this.sourceApplication.add(word);
            }
            if (word.startsWith("recotype:")) {
                this.recoType.add(word);
            }
            if (word.startsWith("-recotype:")) {
                this.recoType.add(word);
            }
            if (word.startsWith("todo:")) {
                this.todo.add(word);
            }
            if (word.startsWith("-todo:")) {
                this.todo.add(word);
            }
            if (word.startsWith("stack:")) {
                this.stack.add(word);
            }
            if (word.startsWith("-stack:")) {
                this.stack.add(word);
            }
            if (word.startsWith("latitude:")) {
                this.latitude.add(word);
            }
            if (word.startsWith("-latitude:")) {
                this.latitude.add(word);
            }
            if (word.startsWith("longitude:")) {
                this.longitude.add(word);
            }
            if (word.startsWith("-longitude:")) {
                this.longitude.add(word);
            }
            if (word.startsWith("altitude:")) {
                this.altitude.add(word);
            }
            if (word.startsWith("-altitude:")) {
                this.altitude.add(word);
            }
            if (word.startsWith("created:")) {
                this.created.add(word);
            }
            if (word.startsWith("-created:")) {
                this.created.add(word);
            }
            if (word.startsWith("updated:")) {
                this.updated.add(word);
            }
            if (word.startsWith("-updated:")) {
                this.updated.add(word);
            }
            if (word.startsWith("subjectdate:")) {
                this.created.add(word);
            }
            if (word.startsWith("-subjectdate:")) {
                this.created.add(word);
            }
            ++i;
        }
    }

    private boolean matchListAll(List<String> list, String title) {
        if (list.size() == 0) {
            return true;
        }
        boolean negative = false;
        int i = 0;
        while (i < list.size()) {
            int pos = list.get(i).indexOf(":");
            negative = false;
            if (list.get(i).startsWith("-")) {
                negative = true;
            }
            String filterName = this.cleanupWord(list.get(i).substring(pos + 1));
            boolean matches = Pattern.matches((filterName = filterName.replace("*", ".*")).toLowerCase(), title.toLowerCase());
            if (matches && negative) {
                return false;
            }
            if (matches && !negative) {
                return true;
            }
            ++i;
        }
        return negative;
    }

    private boolean matchContentAll(Note n) {
        if (this.todo.size() == 0 && this.resource.size() == 0 && this.searchPhrases.size() == 0) {
            return true;
        }
        n = this.conn.getNoteTable().getNote(n.getGuid(), true, true, false, false, false);
        String text = StringEscapeUtils.unescapeHtml4((String)n.getContent().replaceAll("\\<.*?\\>", "")).toLowerCase();
        boolean negative = false;
        int i = 0;
        while (i < this.searchPhrases.size()) {
            String phrase = this.searchPhrases.get(i);
            if (phrase.startsWith("-")) {
                negative = true;
                phrase = phrase.substring(1);
            } else {
                negative = false;
            }
            phrase = phrase.substring(1);
            phrase = phrase.substring(0, phrase.length() - 1);
            if (text.indexOf(phrase) >= 0 && negative) {
                return false;
            }
            if (text.indexOf(phrase) < 0 && !negative) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.todo.size()) {
            int pos;
            String value = this.todo.get(i);
            if (!((value = value.replace("\"", "")).endsWith(":false") || value.endsWith(":true") || value.endsWith(":*") || value.endsWith("*"))) {
                return false;
            }
            boolean desiredState = !value.endsWith(":false");
            if (value.startsWith("-")) {
                boolean bl = desiredState = !desiredState;
            }
            if ((pos = n.getContent().indexOf("<en-todo")) == -1 && !value.startsWith("-")) {
                return false;
            }
            if (pos > -1 && value.startsWith("-") && (value.endsWith("*") || value.endsWith(":"))) {
                return false;
            }
            if (pos == -1 && !value.startsWith("-")) {
                return false;
            }
            boolean returnTodo = false;
            while (pos > -1) {
                int endPos = n.getContent().indexOf(">", pos);
                String segment = n.getContent().substring(pos, endPos);
                boolean currentState = segment.toLowerCase().indexOf("checked=\"true\"") != -1;
                if (desiredState == currentState) {
                    returnTodo = true;
                }
                if (value.endsWith("*") || value.endsWith(":")) {
                    returnTodo = true;
                }
                pos = n.getContent().indexOf("<en-todo", pos + 1);
            }
            if (!returnTodo) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.resource.size()) {
            String resourceString = this.resource.get(i);
            resourceString = resourceString.replace("\"", "");
            negative = false;
            if (resourceString.startsWith("-")) {
                negative = true;
            }
            if ((resourceString = resourceString.substring(resourceString.indexOf(":") + 1)).equals("")) {
                return false;
            }
            int j = 0;
            while (j < n.getResourcesSize()) {
                boolean match = this.stringMatch(((Resource)n.getResources().get(j)).getMime(), resourceString, negative);
                if (!match && !negative) {
                    return false;
                }
                if (match && negative) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean stringMatch(String content, String text, boolean negative) {
        if (content == null && !negative) {
            return false;
        }
        if (content == null && negative) {
            return true;
        }
        String regex = text.endsWith("*") ? (text = text.substring(0, text.length() - 1)) : text;
        content = content.toLowerCase();
        regex = regex.toLowerCase();
        boolean matches = content.startsWith(regex);
        if (negative) {
            return !matches;
        }
        return matches;
    }

    private String cleanupWord(String word) {
        if (word.startsWith("\"")) {
            word = word.substring(1);
        }
        if (word.endsWith("\"")) {
            word = word.substring(0, word.length() - 1);
        }
        word = word.replace("\\\"", "\"");
        word = word.replace("\\\\", "\\");
        return word;
    }

    private boolean matchDatesAll(List<String> dates, long noteDate) {
        if (dates.size() == 0) {
            return true;
        }
        boolean negative = false;
        int i = 0;
        while (i < dates.size()) {
            String requiredDate = dates.get(i);
            if (requiredDate.startsWith("-")) {
                negative = true;
            }
            int response = 0;
            requiredDate = requiredDate.substring(requiredDate.indexOf(":") + 1);
            try {
                response = this.dateCheck(requiredDate, noteDate);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (negative && response < 0) {
                return false;
            }
            if (!negative && response > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean matchDatesAny(List<String> dates, long noteDate) {
        if (dates.size() == 0) {
            return true;
        }
        boolean negative = false;
        int i = 0;
        while (i < dates.size()) {
            String requiredDate = dates.get(i);
            if (requiredDate.startsWith("-")) {
                negative = true;
            }
            int response = 0;
            requiredDate = requiredDate.substring(requiredDate.indexOf(":") + 1);
            try {
                response = this.dateCheck(requiredDate, noteDate);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (negative && response > 0) {
                return true;
            }
            if (!negative && response < 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void printCalendar(Calendar calendar) {
        SimpleDateFormat sdf = new SimpleDateFormat("d MMM yyyy hh:mm:ss aaa");
        String date = sdf.format(calendar.getTime());
        System.err.print(date);
        calendar = new GregorianCalendar();
    }

    public List<Note> matchWords() {
        this.logger.log(this.logger.EXTREME, "Inside EnSearch.matchWords()");
        boolean subSelect = false;
        NoteTable noteTable = new NoteTable(this.logger, this.conn);
        ArrayList<String> validGuids = new ArrayList<String>();
        if (this.searchWords.size() > 0) {
            subSelect = true;
        }
        NSqlQuery query = new NSqlQuery(this.conn.getConnection());
        if (!this.conn.dbTableExists("SEARCH_RESULTS")) {
            query.exec("create temporary table SEARCH_RESULTS (guid varchar)");
            query.exec("create temporary table SEARCH_RESULTS_MERGE (guid varchar)");
        } else {
            query.exec("Delete from SEARCH_RESULTS");
            query.exec("Delete from SEARCH_RESULTS_MERGE");
        }
        NSqlQuery insertQuery = new NSqlQuery(this.conn.getConnection());
        NSqlQuery indexQuery = new NSqlQuery(this.conn.getIndexConnection());
        NSqlQuery mergeQuery = new NSqlQuery(this.conn.getConnection());
        NSqlQuery deleteQuery = new NSqlQuery(this.conn.getConnection());
        NSqlQuery ftlNoteQuery = new NSqlQuery(this.conn.getConnection());
        NSqlQuery ftlResourceQuery = new NSqlQuery(this.conn.getResourceConnection());
        ftlNoteQuery.prepare("SELECT N.GUID AS GUID FROM FTL_SEARCH_DATA(:text, 0, 0) FT, NOTE N WHERE FT.TABLE='NOTE' AND N.GUID=FT.KEYS[0]");
        ftlResourceQuery.prepare("SELECT R.GUID AS GUID FROM FTL_SEARCH_DATA(:text, 0, 0) FT, NOTERESOURCES R WHERE FT.TABLE='NOTERESOURCES' AND R.GUID=FT.KEYS[0]");
        insertQuery.prepare("Insert into SEARCH_RESULTS (guid) values (:guid)");
        mergeQuery.prepare("Insert into SEARCH_RESULTS_MERGE (guid) values (:guid)");
        if (subSelect) {
            int i = 0;
            while (i < this.getWords().size()) {
                if (this.getWords().get(i).indexOf("*") == -1) {
                    indexQuery.prepare("Select distinct guid from words where weight >= " + this.minimumRecognitionWeight + " and word=:word");
                    indexQuery.bindValue(":word", this.getWords().get(i));
                } else {
                    indexQuery.prepare("Select distinct guid from words where weight >= " + this.minimumRecognitionWeight + " and word like :word");
                    indexQuery.bindValue(":word", this.getWords().get(i).replace("*", "%"));
                }
                indexQuery.exec();
                String guid = null;
                while (indexQuery.next()) {
                    guid = indexQuery.valueString(0);
                    if (i == 0 || this.any) {
                        insertQuery.bindValue(":guid", guid);
                        insertQuery.exec();
                        continue;
                    }
                    mergeQuery.bindValue(":guid", guid);
                    mergeQuery.exec();
                }
                ftlNoteQuery.bindValue(":text", this.getWords().get(i));
                ftlNoteQuery.exec();
                while (ftlNoteQuery.next()) {
                    guid = ftlNoteQuery.valueString(0);
                    if (i == 0 || this.any) {
                        insertQuery.bindValue(":guid", guid);
                        insertQuery.exec();
                        continue;
                    }
                    mergeQuery.bindValue(":guid", guid);
                    mergeQuery.exec();
                }
                NSqlQuery rQuery = new NSqlQuery(this.conn.getResourceConnection());
                ftlResourceQuery.bindValue(":text", this.getWords().get(i));
                ftlResourceQuery.exec();
                while (ftlResourceQuery.next()) {
                    guid = ftlResourceQuery.valueString(0);
                    rQuery.prepare("Select noteGuid from noteResources where guid=:guid");
                    rQuery.bindValue(":guid", guid);
                    rQuery.exec();
                    while (rQuery.next()) {
                        guid = rQuery.valueString(0);
                        if (i == 0 || this.any) {
                            insertQuery.bindValue(":guid", guid);
                            insertQuery.exec();
                            continue;
                        }
                        mergeQuery.bindValue(":guid", guid);
                        mergeQuery.exec();
                    }
                }
                if (i > 0 && !this.any) {
                    deleteQuery.exec("Delete from SEARCH_RESULTS where guid not in (select guid from SEARCH_RESULTS_MERGE)");
                    deleteQuery.exec("Delete from SEARCH_RESULTS_MERGE");
                }
                ++i;
            }
            query.prepare("Select distinct guid from Note where guid in (Select guid from SEARCH_RESULTS)");
            if (!query.exec()) {
                this.logger.log(this.logger.LOW, "Error merging search results:" + query.lastError());
            }
            while (query.next()) {
                validGuids.add(query.valueString(0));
            }
        }
        List<Note> noteIndex = noteTable.getAllNotes();
        ArrayList<Note> guids = new ArrayList<Note>();
        int i = 0;
        while (i < noteIndex.size()) {
            Note n = noteIndex.get(i);
            boolean good = true;
            if (!validGuids.contains(n.getGuid()) && subSelect) {
                good = false;
            }
            if (this.any) {
                if (good && !this.matchTagsAny(n.getTagNames(), this.getTags())) {
                    good = false;
                }
                if (good && !this.matchNotebook(n.getNotebookGuid())) {
                    good = false;
                }
                if (good && !this.matchNotebookStack(n.getNotebookGuid())) {
                    good = false;
                }
                if (good && !this.matchListAny(this.getIntitle(), n.getTitle())) {
                    good = false;
                }
                if (good && !this.matchListAny(this.getAuthor(), n.getAttributes().getAuthor())) {
                    good = false;
                }
                if (good && !this.matchListAny(this.getSource(), n.getAttributes().getSource())) {
                    good = false;
                }
                if (good && !this.matchListAny(this.getSourceApplication(), n.getAttributes().getSourceApplication())) {
                    good = false;
                }
                if (good && !this.matchContentAny(n)) {
                    good = false;
                }
                if (good && !this.matchDatesAny(this.getCreated(), n.getCreated())) {
                    good = false;
                }
                if (good && !this.matchDatesAny(this.getUpdated(), n.getUpdated())) {
                    good = false;
                }
                if (good && n.getAttributes() != null && !this.matchDatesAny(this.getSubjectDate(), n.getAttributes().getSubjectDate())) {
                    good = false;
                }
            } else {
                if (good && !this.matchTagsAll(n.getTagNames(), this.getTags())) {
                    good = false;
                }
                if (good && !this.matchNotebook(n.getNotebookGuid())) {
                    good = false;
                }
                if (good && !this.matchNotebookStack(n.getNotebookGuid())) {
                    good = false;
                }
                if (good && !this.matchListAll(this.getIntitle(), n.getTitle())) {
                    good = false;
                }
                if (good && !this.matchListAll(this.getAuthor(), n.getAttributes().getAuthor())) {
                    good = false;
                }
                if (good && !this.matchListAll(this.getSource(), n.getAttributes().getSource())) {
                    good = false;
                }
                if (good && !this.matchListAll(this.getSourceApplication(), n.getAttributes().getSourceApplication())) {
                    good = false;
                }
                if (good && !this.matchContentAll(n)) {
                    good = false;
                }
                if (good && !this.matchDatesAll(this.getCreated(), n.getCreated())) {
                    good = false;
                }
                if (good && !this.matchDatesAll(this.getUpdated(), n.getUpdated())) {
                    good = false;
                }
                if (good && n.getAttributes() != null && !this.matchDatesAll(this.getSubjectDate(), n.getAttributes().getSubjectDate())) {
                    good = false;
                }
            }
            if (good) {
                guids.add(n);
            }
            ++i;
        }
        List<NoteTagsRecord> noteTags = noteTable.noteTagsTable.getAllNoteTags();
        int i2 = 0;
        while (i2 < guids.size()) {
            ArrayList<String> tags = new ArrayList<String>();
            ArrayList<String> names = new ArrayList<String>();
            int j = 0;
            while (j < noteTags.size()) {
                if (((Note)guids.get(i2)).getGuid().equals(noteTags.get((int)j).noteGuid)) {
                    tags.add(noteTags.get((int)j).tagGuid);
                    names.add(this.getTagNameByGuid(noteTags.get((int)j).tagGuid));
                }
                ++j;
            }
            ((Note)guids.get(i2)).setTagGuids(tags);
            ((Note)guids.get(i2)).setTagNames(names);
            ++i2;
        }
        this.logger.log(this.logger.EXTREME, "Leaving EnSearch.matchWords()");
        return guids;
    }

    private String getTagNameByGuid(String guid) {
        int i = 0;
        while (i < this.tagIndex.size()) {
            if (this.tagIndex.get(i).getGuid().equals(guid)) {
                return this.tagIndex.get(i).getName();
            }
            ++i;
        }
        return "";
    }

    public int dateCheck(String date, long noteDate) throws NumberFormatException {
        String modifier;
        int offset = 0;
        boolean found = false;
        GregorianCalendar calendar = new GregorianCalendar();
        if (date.contains("-")) {
            modifier = date.substring(date.indexOf("-") + 1);
            offset = new Integer(modifier);
            offset = 0 - offset;
            date = date.substring(0, date.indexOf("-"));
        }
        if (date.contains("+")) {
            modifier = date.substring(date.indexOf("+") + 1);
            offset = new Integer(modifier);
            date = date.substring(0, date.indexOf("+"));
        }
        if (date.equalsIgnoreCase("today")) {
            calendar.add(5, offset);
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 1);
            found = true;
        }
        if (date.equalsIgnoreCase("month")) {
            calendar.add(2, offset);
            calendar.set(5, 1);
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 1);
            found = true;
        }
        if (date.equalsIgnoreCase("year")) {
            calendar.add(1, offset);
            calendar.set(2, 0);
            calendar.set(5, 1);
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 1);
            found = true;
        }
        if (date.equalsIgnoreCase("week")) {
            calendar.add(5, 0 - calendar.get(7) + 1);
            calendar.add(5, offset * 7);
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 1);
            found = true;
        }
        if (!found) {
            calendar = this.stringToGregorianCalendar(date);
        }
        String dateTimeFormat = new String("yyyyMMdd-HHmmss");
        SimpleDateFormat simple = new SimpleDateFormat(dateTimeFormat);
        StringBuilder creationDate = new StringBuilder(simple.format(noteDate));
        GregorianCalendar nCalendar = this.stringToGregorianCalendar(creationDate.toString().replace("-", "T"));
        if (calendar == null || nCalendar == null) {
            return 1;
        }
        return calendar.compareTo(nCalendar);
    }

    private GregorianCalendar stringToGregorianCalendar(String date) {
        String datePart = date;
        GregorianCalendar calendar = new GregorianCalendar();
        boolean GMT = false;
        String timePart = "";
        if (date.contains("T")) {
            datePart = date.substring(0, date.indexOf("T"));
            timePart = date.substring(date.indexOf("T") + 1);
        } else {
            timePart = "000001";
        }
        if (datePart.length() != 8) {
            return null;
        }
        calendar.set(1, new Integer(datePart.substring(0, 4)));
        calendar.set(2, new Integer(datePart.substring(4, 6)) - 1);
        calendar.set(5, new Integer(datePart.substring(6)));
        if (timePart.endsWith("Z")) {
            GMT = true;
            timePart = timePart.substring(0, timePart.length() - 1);
        }
        timePart = timePart.concat("000000");
        timePart = timePart.substring(0, 6);
        calendar.set(10, new Integer(timePart.substring(0, 2)));
        calendar.set(12, new Integer(timePart.substring(2, 4)));
        calendar.set(13, new Integer(timePart.substring(4)));
        if (GMT) {
            calendar.set(15, -1 * (calendar.get(15) / 3600000));
        }
        return calendar;
    }
}

