/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.Arrays;
import org.apache.poi.hwpf.model.ListFormatOverrideLevel;
import org.apache.poi.util.LittleEndian;

public final class ListFormatOverride {
    int _lsid;
    int _reserved1;
    int _reserved2;
    byte _clfolvl;
    byte[] _reserved3 = new byte[3];
    ListFormatOverrideLevel[] _levelOverrides;

    public ListFormatOverride(int lsid) {
        this._lsid = lsid;
        this._levelOverrides = new ListFormatOverrideLevel[0];
    }

    public ListFormatOverride(byte[] buf, int offset) {
        this._lsid = LittleEndian.getInt((byte[])buf, (int)offset);
        this._reserved1 = LittleEndian.getInt((byte[])buf, (int)(offset += 4));
        this._reserved2 = LittleEndian.getInt((byte[])buf, (int)(offset += 4));
        offset += 4;
        this._clfolvl = buf[offset++];
        System.arraycopy(buf, offset, this._reserved3, 0, this._reserved3.length);
        this._levelOverrides = new ListFormatOverrideLevel[this._clfolvl];
    }

    public int numOverrides() {
        return this._clfolvl;
    }

    public int getLsid() {
        return this._lsid;
    }

    void setLsid(int lsid) {
        this._lsid = lsid;
    }

    public ListFormatOverrideLevel[] getLevelOverrides() {
        return this._levelOverrides;
    }

    public void setOverride(int index, ListFormatOverrideLevel lfolvl) {
        this._levelOverrides[index] = lfolvl;
    }

    public ListFormatOverrideLevel getOverrideLevel(int level) {
        ListFormatOverrideLevel retLevel = null;
        for (int x = 0; x < this._levelOverrides.length; ++x) {
            if (this._levelOverrides[x].getLevelNum() != level) continue;
            retLevel = this._levelOverrides[x];
        }
        return retLevel;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ListFormatOverride lfo = (ListFormatOverride)obj;
        return lfo._clfolvl == this._clfolvl && lfo._lsid == this._lsid && lfo._reserved1 == this._reserved1 && lfo._reserved2 == this._reserved2 && Arrays.equals(lfo._reserved3, this._reserved3) && Arrays.equals(lfo._levelOverrides, this._levelOverrides);
    }

    public byte[] toByteArray() {
        byte[] buf = new byte[16];
        int offset = 0;
        LittleEndian.putInt((byte[])buf, (int)offset, (int)this._lsid);
        LittleEndian.putInt((byte[])buf, (int)(offset += 4), (int)this._reserved1);
        LittleEndian.putInt((byte[])buf, (int)(offset += 4), (int)this._reserved2);
        offset += 4;
        buf[offset++] = this._clfolvl;
        System.arraycopy(this._reserved3, 0, buf, offset, 3);
        return buf;
    }
}

