/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote;

import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NoteVersionId;
import com.evernote.edam.type.Data;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.NoteAttributes;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Publishing;
import com.evernote.edam.type.QueryFormat;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.SavedSearch;
import com.evernote.edam.type.Tag;
import com.evernote.edam.type.User;
import com.evernote.thrift.TException;
import com.trolltech.qt.QThread;
import com.trolltech.qt.QtEnumerator;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QDateTime;
import com.trolltech.qt.core.QDir;
import com.trolltech.qt.core.QEvent;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QFileInfo;
import com.trolltech.qt.core.QFileSystemWatcher;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QLocale;
import com.trolltech.qt.core.QMimeData;
import com.trolltech.qt.core.QModelIndex;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.QTemporaryFile;
import com.trolltech.qt.core.QTextCodec;
import com.trolltech.qt.core.QTextStream;
import com.trolltech.qt.core.QThreadPool;
import com.trolltech.qt.core.QTimer;
import com.trolltech.qt.core.QTranslator;
import com.trolltech.qt.core.QUrl;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QClipboard;
import com.trolltech.qt.gui.QCloseEvent;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QCursor;
import com.trolltech.qt.gui.QDesktopServices;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QFileDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QKeySequence;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QListWidgetItem;
import com.trolltech.qt.gui.QMainWindow;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QMessageBox;
import com.trolltech.qt.gui.QPaintDeviceInterface;
import com.trolltech.qt.gui.QPainter;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.gui.QPrintDialog;
import com.trolltech.qt.gui.QPrinter;
import com.trolltech.qt.gui.QShortcut;
import com.trolltech.qt.gui.QSizePolicy;
import com.trolltech.qt.gui.QSpinBox;
import com.trolltech.qt.gui.QSplashScreen;
import com.trolltech.qt.gui.QSplitter;
import com.trolltech.qt.gui.QStatusBar;
import com.trolltech.qt.gui.QSystemTrayIcon;
import com.trolltech.qt.gui.QTableWidgetItem;
import com.trolltech.qt.gui.QTextEdit;
import com.trolltech.qt.gui.QToolBar;
import com.trolltech.qt.gui.QTreeWidgetItem;
import com.trolltech.qt.gui.QWidget;
import com.trolltech.qt.network.QNetworkAccessManager;
import com.trolltech.qt.network.QNetworkProxy;
import com.trolltech.qt.network.QNetworkReply;
import com.trolltech.qt.network.QNetworkRequest;
import com.trolltech.qt.webkit.QWebPage;
import com.trolltech.qt.webkit.QWebSettings;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.config.InitializationException;
import cx.fbn.nevernote.config.StartupConfig;
import cx.fbn.nevernote.dialog.AccountDialog;
import cx.fbn.nevernote.dialog.ConfigDialog;
import cx.fbn.nevernote.dialog.DBEncryptDialog;
import cx.fbn.nevernote.dialog.DatabaseLoginDialog;
import cx.fbn.nevernote.dialog.DatabaseStatus;
import cx.fbn.nevernote.dialog.FindDialog;
import cx.fbn.nevernote.dialog.IgnoreSync;
import cx.fbn.nevernote.dialog.LogFileDialog;
import cx.fbn.nevernote.dialog.NotebookArchive;
import cx.fbn.nevernote.dialog.NotebookEdit;
import cx.fbn.nevernote.dialog.OnlineNoteHistory;
import cx.fbn.nevernote.dialog.PublishNotebook;
import cx.fbn.nevernote.dialog.SavedSearchEdit;
import cx.fbn.nevernote.dialog.SetIcon;
import cx.fbn.nevernote.dialog.ShareNotebook;
import cx.fbn.nevernote.dialog.SharedNotebookSyncError;
import cx.fbn.nevernote.dialog.StackNotebook;
import cx.fbn.nevernote.dialog.SynchronizationRequiredWarning;
import cx.fbn.nevernote.dialog.TagEdit;
import cx.fbn.nevernote.dialog.TagMerge;
import cx.fbn.nevernote.dialog.ThumbnailViewer;
import cx.fbn.nevernote.dialog.UpgradeAvailableDialog;
import cx.fbn.nevernote.dialog.WatchFolder;
import cx.fbn.nevernote.evernote.NoteMetadata;
import cx.fbn.nevernote.filters.FilterEditorNotebooks;
import cx.fbn.nevernote.filters.FilterEditorTags;
import cx.fbn.nevernote.gui.AttributeTreeWidget;
import cx.fbn.nevernote.gui.BrowserWindow;
import cx.fbn.nevernote.gui.DateAttributeFilterTable;
import cx.fbn.nevernote.gui.ExternalBrowse;
import cx.fbn.nevernote.gui.MainMenuBar;
import cx.fbn.nevernote.gui.NotebookTreeWidget;
import cx.fbn.nevernote.gui.RensoNoteList;
import cx.fbn.nevernote.gui.RensoNoteListDock;
import cx.fbn.nevernote.gui.SavedSearchTreeWidget;
import cx.fbn.nevernote.gui.SearchPanel;
import cx.fbn.nevernote.gui.TabBrowse;
import cx.fbn.nevernote.gui.TabBrowserWidget;
import cx.fbn.nevernote.gui.TableView;
import cx.fbn.nevernote.gui.TagTreeWidget;
import cx.fbn.nevernote.gui.Thumbnailer;
import cx.fbn.nevernote.gui.TrashTreeWidget;
import cx.fbn.nevernote.gui.controls.QuotaProgressBar;
import cx.fbn.nevernote.neighbornote.ClipBoardObserver;
import cx.fbn.nevernote.oauth.OAuthTokenizer;
import cx.fbn.nevernote.oauth.OAuthWindow;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.WatchFolderRecord;
import cx.fbn.nevernote.threads.IndexRunner;
import cx.fbn.nevernote.threads.SyncRunner;
import cx.fbn.nevernote.threads.ThumbnailRunner;
import cx.fbn.nevernote.utilities.AESEncrypter;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.FileImporter;
import cx.fbn.nevernote.utilities.FileUtils;
import cx.fbn.nevernote.utilities.ListManager;
import cx.fbn.nevernote.utilities.SyncTimes;
import cx.fbn.nevernote.xml.ExportData;
import cx.fbn.nevernote.xml.ImportData;
import cx.fbn.nevernote.xml.ImportEnex;
import cx.fbn.nevernote.xml.NoteFormatter;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.h2.tools.ChangeFileEncryption;

public class NeverNote
extends QMainWindow {
    QStatusBar statusBar;
    DatabaseConnection conn;
    MainMenuBar menuBar;
    FindDialog find;
    List<String> emitLog;
    QSystemTrayIcon trayIcon;
    QMenu trayMenu;
    QAction trayExitAction;
    QAction trayShowAction;
    QAction trayAddNoteAction;
    QNetworkAccessManager versionChecker;
    NotebookTreeWidget notebookTree;
    AttributeTreeWidget attributeTree;
    TagTreeWidget tagTree;
    SavedSearchTreeWidget savedSearchTree;
    TrashTreeWidget trashTree;
    TableView noteTableView;
    public BrowserWindow browserWindow;
    public QToolBar toolBar;
    QComboBox searchField;
    QShortcut searchShortcut;
    boolean searchPerformed = false;
    QuotaProgressBar quotaBar;
    ApplicationLogger logger;
    List<String> selectedNotebookGUIDs;
    List<String> selectedTagGUIDs;
    List<String> selectedNoteGUIDs;
    String selectedSavedSearchGUID;
    private final HashMap<String, ExternalBrowse> externalWindows;
    NoteFilter filter;
    String currentNoteGuid;
    Note currentNote;
    HashMap<Integer, Boolean> noteDirty;
    HashMap<Integer, Boolean> inkNote;
    HashMap<Integer, Boolean> readOnly;
    ListManager listManager;
    List<QTemporaryFile> tempFiles;
    QTimer indexTimer;
    IndexRunner indexRunner;
    QThread indexThread;
    QTimer syncTimer;
    QTimer syncDelayTimer;
    SyncRunner syncRunner;
    QThread syncThread;
    ThumbnailRunner thumbnailRunner;
    QThread thumbnailThread;
    QTimer saveTimer;
    QTimer authTimer;
    QTimer externalFileSaveTimer;
    QTimer thumbnailTimer;
    QTimer debugTimer;
    List<String> externalFiles;
    List<String> importFilesKeep;
    List<String> importFilesDelete;
    int indexTime;
    boolean indexRunning;
    boolean indexDisabled;
    int syncThreadsReady;
    int syncTime;
    boolean syncRunning;
    boolean automaticSync;
    QTreeWidgetItem attributeTreeSelected;
    QAction prevButton;
    QAction nextButton;
    QAction downButton;
    QAction upButton;
    QAction synchronizeButton;
    QAction allNotesButton;
    QTimer synchronizeAnimationTimer;
    int synchronizeIconAngle;
    QAction printButton;
    QAction tagButton;
    QAction attributeButton;
    QAction emailButton;
    QAction deleteButton;
    QAction newButton;
    QSpinBox zoomSpinner;
    QAction searchClearButton;
    SearchPanel searchLayout;
    QSplitter mainLeftRightSplitter;
    QSplitter leftSplitter1;
    QSplitter browserIndexSplitter;
    QFileSystemWatcher importKeepWatcher;
    QFileSystemWatcher importDeleteWatcher;
    List<String> importedFiles;
    OnlineNoteHistory historyWindow;
    List<NoteVersionId> versions;
    QTimer threadMonitorTimer;
    int dbThreadDeadCount = 0;
    int syncThreadDeadCount = 0;
    int indexThreadDeadCount = 0;
    int notebookThreadDeadCount = 0;
    int tagDeadCount = 0;
    int trashDeadCount = 0;
    int saveThreadDeadCount = 0;
    int enRelatedNotesThreadDeadCount = 0;
    boolean disableTagThreadCheck = false;
    boolean disableNotebookThreadCheck = false;
    boolean disableTrashThreadCheck = false;
    boolean disableSaveThreadCheck = false;
    boolean disableSyncThreadCheck = false;
    boolean disableIndexThreadCheck = false;
    boolean disableENRelatedNotesThreadCheck = false;
    HashMap<String, String> noteCache;
    HashMap<String, Boolean> readOnlyCache;
    HashMap<String, Boolean> inkNoteCache;
    HashMap<Integer, ArrayList<String>> historyGuids;
    HashMap<Integer, Integer> historyPosition;
    HashMap<Integer, Boolean> fromHistory;
    String trashNoteGuid;
    List<Thumbnailer> thumbGenerators;
    ThumbnailViewer thumbnailViewer;
    boolean encryptOnShutdown;
    boolean decryptOnShutdown;
    String encryptCipher;
    boolean windowMaximized = false;
    List<String> pdfReadyQueue;
    List<QPixmap> syncIcons;
    private boolean closeAction = false;
    private static Logger log = Logger.getLogger(NeverNote.class);
    private String saveLastPath;
    private final QTimer messageTimer;
    private QTimer blockTimer;
    BrowserWindow blockingWindow;
    private final TabBrowserWidget tabBrowser;
    private final HashMap<Integer, TabBrowse> tabWindows;
    private final RensoNoteListDock rensoNoteListDock;
    ClipBoardObserver cbObserver;
    String rensoNotePressedItemGuid;
    String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public NeverNote(DatabaseConnection dbConn) {
        this.cbObserver = new ClipBoardObserver();
        this.conn = dbConn;
        if (this.conn.getConnection() == null) {
            String msg = new String(this.tr("Unable to connect to the database.\n\nThe most probable reason is that some other process\nis accessing the database or NeighborNote is already running.\n\nPlease end any other process or shutdown the other NeighborNote before starting.\n\nExiting program."));
            QMessageBox.critical(null, (String)this.tr("Database Connection Error"), (String)msg);
            System.exit(16);
        }
        this.setObjectName("mainWindow");
        this.logger = new ApplicationLogger("nevernote.log");
        this.logger.log(this.logger.HIGH, "Starting Application");
        this.decryptOnShutdown = false;
        this.encryptOnShutdown = false;
        this.conn.checkDatabaseVersion();
        Global.invalidElements = this.conn.getInvalidXMLTable().getInvalidElements();
        List<String> elements = this.conn.getInvalidXMLTable().getInvalidAttributeElements();
        int i = 0;
        while (i < elements.size()) {
            Global.invalidAttributes.put(elements.get(i), this.conn.getInvalidXMLTable().getInvalidAttributes(elements.get(i)));
            ++i;
        }
        this.logger.log(this.logger.EXTREME, "Starting GUI build");
        QTranslator nevernoteTranslator = new QTranslator();
        nevernoteTranslator.load(Global.getFileManager().getTranslateFilePath("neighbornote_" + QLocale.system().name() + ".qm"));
        QApplication.instance();
        QApplication.installTranslator((QTranslator)nevernoteTranslator);
        Global.originalPalette = QApplication.palette();
        QApplication.setStyle((String)Global.getStyle());
        if (Global.useStandardPalette()) {
            QApplication.setPalette((QPalette)QApplication.style().standardPalette());
        }
        this.setWindowTitle(this.tr("NeighborNote"));
        this.mainLeftRightSplitter = new QSplitter();
        this.mainLeftRightSplitter.setOrientation(Qt.Orientation.Horizontal);
        this.setCentralWidget((QWidget)this.mainLeftRightSplitter);
        this.leftSplitter1 = new QSplitter();
        this.leftSplitter1.setOrientation(Qt.Orientation.Vertical);
        this.browserIndexSplitter = new QSplitter();
        this.browserIndexSplitter.setOrientation(Qt.Orientation.Vertical);
        QThreadPool.globalInstance().setMaxThreadCount(10);
        this.logger.log(this.logger.EXTREME, "Building list manager");
        this.listManager = new ListManager(this.conn, this.logger);
        this.logger.log(this.logger.EXTREME, "Building index runners & timers");
        this.indexRunner = new IndexRunner("indexRunner.log", Global.getDatabaseUrl(), Global.getIndexDatabaseUrl(), Global.getResourceDatabaseUrl(), Global.getBehaviorDatabaseUrl(), Global.getDatabaseUserid(), Global.getDatabaseUserPassword(), Global.cipherPassword);
        this.indexThread = new QThread((Runnable)this.indexRunner, "Index Thread");
        this.indexRunner.indexAttachmentsLocally = Global.indexAttachmentsLocally();
        this.indexRunner.indexImageRecognition = Global.indexImageRecognition();
        this.indexThread.start();
        this.synchronizeAnimationTimer = new QTimer();
        this.synchronizeAnimationTimer.timeout.connect((Object)this, "updateSyncButton()");
        this.indexTimer = new QTimer();
        this.indexTime = 1000 * Global.getIndexThreadSleepInterval();
        this.indexTimer.start(this.indexTime);
        this.indexTimer.timeout.connect((Object)this, "indexTimer()");
        this.indexDisabled = false;
        this.indexRunning = false;
        this.logger.log(this.logger.EXTREME, "Setting sync thread & timers");
        this.syncThreadsReady = 1;
        this.syncRunner = new SyncRunner("syncRunner.log", Global.getDatabaseUrl(), Global.getIndexDatabaseUrl(), Global.getResourceDatabaseUrl(), Global.getBehaviorDatabaseUrl(), Global.getDatabaseUserid(), Global.getDatabaseUserPassword(), Global.cipherPassword);
        this.syncTime = new SyncTimes().timeValue(Global.getSyncInterval());
        this.syncTimer = new QTimer();
        this.syncTimer.timeout.connect((Object)this, "syncTimer()");
        this.syncRunner.status.message.connect((Object)this, "setMessage(String)");
        this.syncRunner.syncSignal.finished.connect((Object)this, "syncThreadComplete(Boolean)");
        this.syncRunner.syncSignal.errorDisconnect.connect((Object)this, "remoteErrorDisconnect()");
        this.syncRunning = false;
        if (this.syncTime > 0) {
            this.automaticSync = true;
            this.syncTimer.start(this.syncTime * 60 * 1000);
        } else {
            this.automaticSync = false;
            this.syncTimer.stop();
        }
        this.syncRunner.setEvernoteUpdateCount(Global.getEvernoteUpdateCount());
        this.syncThread = new QThread((Runnable)this.syncRunner, "Synchronization Thread");
        this.syncThread.start();
        this.logger.log(this.logger.EXTREME, "Starting thumnail thread");
        this.pdfReadyQueue = new ArrayList<String>();
        this.thumbnailRunner = new ThumbnailRunner("thumbnailRunner.log", Global.getDatabaseUrl(), Global.getIndexDatabaseUrl(), Global.getResourceDatabaseUrl(), Global.getBehaviorDatabaseUrl(), Global.getDatabaseUserid(), Global.getDatabaseUserPassword(), Global.cipherPassword);
        this.thumbnailThread = new QThread((Runnable)this.thumbnailRunner, "Thumbnail Thread");
        this.thumbnailRunner.noteSignal.thumbnailPageReady.connect((Object)this, "thumbnailHTMLReady(String,QByteArray,Integer)");
        this.thumbnailThread.start();
        this.thumbGenerators = new ArrayList<Thumbnailer>();
        this.thumbnailTimer = new QTimer();
        this.thumbnailTimer.timeout.connect((Object)this, "thumbnailTimer()");
        this.thumbnailTimer();
        this.thumbnailTimer.setInterval(500000);
        this.thumbnailTimer.start();
        this.logger.log(this.logger.EXTREME, "Starting authentication timer");
        this.authTimer = new QTimer();
        this.authTimer.timeout.connect((Object)this, "authTimer()");
        this.authTimer.start(900000);
        this.syncRunner.syncSignal.authRefreshComplete.connect((Object)this, "authRefreshComplete(boolean)");
        this.logger.log(this.logger.EXTREME, "Setting save note timer");
        this.saveTimer = new QTimer();
        this.saveTimer.timeout.connect((Object)this, "saveNote()");
        if (Global.getAutoSaveInterval() > 0) {
            this.saveTimer.setInterval(60000 * Global.getAutoSaveInterval());
            this.saveTimer.start();
        }
        this.listManager.saveRunner.noteSignals.noteSaveRunnerError.connect((Object)this, "saveRunnerError(String, String)");
        this.logger.log(this.logger.EXTREME, "Starting external file monitor timer");
        this.externalFileSaveTimer = new QTimer();
        this.externalFileSaveTimer.timeout.connect((Object)this, "externalFileEditedSaver()");
        this.externalFileSaveTimer.setInterval(5000);
        this.externalFiles = new ArrayList<String>();
        this.importFilesDelete = new ArrayList<String>();
        this.importFilesKeep = new ArrayList<String>();
        this.externalFileSaveTimer.start();
        this.notebookTree = new NotebookTreeWidget(this.conn);
        this.attributeTree = new AttributeTreeWidget();
        this.tagTree = new TagTreeWidget(this.conn);
        this.savedSearchTree = new SavedSearchTreeWidget();
        this.trashTree = new TrashTreeWidget();
        this.noteTableView = new TableView(this.logger, this.listManager, this);
        this.searchField = new QComboBox();
        this.searchField.setObjectName("searchField");
        this.searchField.setEditable(true);
        this.searchField.activatedIndex.connect((Object)this, "searchFieldChanged()");
        this.searchField.setDuplicatesEnabled(false);
        this.searchField.editTextChanged.connect((Object)this, "searchFieldTextChanged(String)");
        this.searchShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.searchShortcut, "Focus_Search");
        this.searchShortcut.activated.connect((Object)this, "focusSearch()");
        this.quotaBar = new QuotaProgressBar();
        this.zoomSpinner = new QSpinBox();
        this.zoomSpinner.setMinimum(10);
        this.zoomSpinner.setMaximum(1000);
        this.zoomSpinner.setAccelerated(true);
        this.zoomSpinner.setSingleStep(10);
        this.zoomSpinner.setValue(100);
        this.zoomSpinner.valueChanged.connect((Object)this, "zoomChanged()");
        this.searchLayout = new SearchPanel(this.searchField, this.quotaBar, this.notebookTree, this.zoomSpinner);
        QGridLayout leftGrid = new QGridLayout();
        this.leftSplitter1.setContentsMargins(5, 0, 0, 7);
        this.leftSplitter1.setLayout((QLayout)leftGrid);
        leftGrid.addWidget((QWidget)this.searchLayout, 1, 1);
        leftGrid.addWidget((QWidget)this.tagTree, 2, 1);
        leftGrid.addWidget((QWidget)this.attributeTree, 3, 1);
        leftGrid.addWidget((QWidget)this.savedSearchTree, 4, 1);
        leftGrid.addWidget((QWidget)this.trashTree, 5, 1);
        this.noteCache = new HashMap();
        this.readOnlyCache = new HashMap();
        this.inkNoteCache = new HashMap();
        this.browserWindow = new BrowserWindow(this.conn, this.cbObserver);
        this.historyGuids = new HashMap();
        this.historyPosition = new HashMap();
        this.fromHistory = new HashMap();
        this.tabWindows = new HashMap();
        this.tabBrowser = new TabBrowserWidget(this);
        this.tabBrowser.setStyleSheet("QTabBar::tab{width:150px;}");
        this.tabBrowser.setMovable(true);
        this.tabBrowser.setTabsClosable(true);
        TabBrowse tab = new TabBrowse(this.conn, this.tabBrowser, this.cbObserver);
        this.browserWindow = tab.getBrowserWindow();
        int index = this.tabBrowser.addNewTab(tab, "");
        this.tabWindows.put(index, tab);
        this.tabBrowser.currentChanged.connect((Object)this, "tabWindowChanged(int)");
        this.tabBrowser.tabCloseRequested.connect((Object)this, "tabWindowClosing(int)");
        this.noteDirty = new HashMap();
        this.noteDirty.put(index, false);
        this.inkNote = new HashMap();
        this.readOnly = new HashMap();
        this.historyGuids.put(index, new ArrayList());
        this.historyPosition.put(index, 0);
        this.fromHistory.put(index, false);
        this.mainLeftRightSplitter.addWidget((QWidget)this.leftSplitter1);
        this.mainLeftRightSplitter.addWidget((QWidget)this.browserIndexSplitter);
        this.rensoNoteListDock = new RensoNoteListDock(this.conn, this, this.syncRunner, this.iconPath, this.tr("Renso Note List"));
        this.addDockWidget(Qt.DockWidgetArea.RightDockWidgetArea, this.rensoNoteListDock);
        if (Global.getListView() == Global.View_List_Wide) {
            this.browserIndexSplitter.addWidget((QWidget)this.noteTableView);
            this.browserIndexSplitter.addWidget((QWidget)this.tabBrowser);
        } else {
            this.mainLeftRightSplitter.addWidget((QWidget)this.noteTableView);
            this.mainLeftRightSplitter.addWidget((QWidget)this.tabBrowser);
        }
        this.thumbnailViewer = new ThumbnailViewer();
        this.thumbnailViewer.upArrow.connect((Object)this, "upAction()");
        this.thumbnailViewer.downArrow.connect((Object)this, "downAction()");
        this.thumbnailViewer.leftArrow.connect((Object)this, "nextViewedAction()");
        this.thumbnailViewer.rightArrow.connect((Object)this, "previousViewedAction()");
        this.externalWindows = new HashMap();
        this.listManager.loadNotesIndex();
        this.initializeNotebookTree();
        this.initializeTagTree();
        this.initializeSavedSearchTree();
        this.attributeTree.itemClicked.connect((Object)this, "attributeTreeClicked(QTreeWidgetItem, Integer)");
        this.attributeTreeSelected = null;
        this.initializeNoteTable();
        this.selectedNoteGUIDs = new ArrayList<String>();
        this.statusBar = new QStatusBar();
        this.setStatusBar(this.statusBar);
        this.menuBar = new MainMenuBar(this);
        this.emitLog = new ArrayList<String>();
        this.tagTree.setDeleteAction(this.menuBar.tagDeleteAction);
        this.tagTree.setMergeAction(this.menuBar.tagMergeAction);
        this.tagTree.setEditAction(this.menuBar.tagEditAction);
        this.tagTree.setAddAction(this.menuBar.tagAddAction);
        this.tagTree.setIconAction(this.menuBar.tagIconAction);
        this.tagTree.setVisible(Global.isWindowVisible("tagTree"));
        this.leftSplitter1.setVisible(Global.isWindowVisible("leftPanel"));
        this.tagTree.noteSignal.tagsAdded.connect((Object)this, "tagsAdded(String, String)");
        this.menuBar.hideTags.setChecked(Global.isWindowVisible("tagTree"));
        this.listManager.tagSignal.listChanged.connect((Object)this, "reloadTagTree()");
        if (!Global.isWindowVisible("zoom")) {
            this.searchLayout.hideZoom();
            this.menuBar.hideZoom.setChecked(false);
        }
        this.notebookTree.setDeleteAction(this.menuBar.notebookDeleteAction);
        this.notebookTree.setEditAction(this.menuBar.notebookEditAction);
        this.notebookTree.setAddAction(this.menuBar.notebookAddAction);
        this.notebookTree.setIconAction(this.menuBar.notebookIconAction);
        this.notebookTree.setStackAction(this.menuBar.notebookStackAction);
        this.notebookTree.setPublishAction(this.menuBar.notebookPublishAction);
        this.notebookTree.setShareAction(this.menuBar.notebookShareAction);
        this.notebookTree.setVisible(Global.isWindowVisible("notebookTree"));
        this.notebookTree.noteSignal.notebookChanged.connect((Object)this, "updateNoteNotebook(String, String)");
        this.notebookTree.noteSignal.tagsChanged.connect((Object)this, "updateNoteTags(String, List)");
        this.notebookTree.noteSignal.tagsChanged.connect((Object)this, "updateListTags(String, List)");
        this.menuBar.hideNotebooks.setChecked(Global.isWindowVisible("notebookTree"));
        this.savedSearchTree.setAddAction(this.menuBar.savedSearchAddAction);
        this.savedSearchTree.setEditAction(this.menuBar.savedSearchEditAction);
        this.savedSearchTree.setDeleteAction(this.menuBar.savedSearchDeleteAction);
        this.savedSearchTree.setIconAction(this.menuBar.savedSearchIconAction);
        this.savedSearchTree.itemSelectionChanged.connect((Object)this, "updateSavedSearchSelection()");
        this.savedSearchTree.setVisible(Global.isWindowVisible("savedSearchTree"));
        this.menuBar.hideSavedSearches.setChecked(Global.isWindowVisible("savedSearchTree"));
        this.noteTableView.setOpenNewTabAction(this.menuBar.noteOpenNewTab);
        this.noteTableView.setAddAction(this.menuBar.noteAdd);
        this.noteTableView.setAddNoteNewTabAction(this.menuBar.noteAddNewTab);
        this.noteTableView.setDeleteAction(this.menuBar.noteDelete);
        this.noteTableView.setRestoreAction(this.menuBar.noteRestoreAction);
        this.noteTableView.setNoteDuplicateAction(this.menuBar.noteDuplicateAction);
        this.noteTableView.setNoteHistoryAction(this.menuBar.noteOnlineHistoryAction);
        this.noteTableView.noteSignal.titleColorChanged.connect((Object)this, "titleColorChanged(Integer)");
        this.noteTableView.noteSignal.notePinned.connect((Object)this, "notePinned()");
        this.noteTableView.setMergeNotesAction(this.menuBar.noteMergeAction);
        this.noteTableView.setCopyAsUrlAction(this.menuBar.noteCopyAsUrlAction);
        this.noteTableView.doubleClicked.connect((Object)this, "listDoubleClick()");
        this.listManager.trashSignal.countChanged.connect((Object)this.trashTree, "updateCounts(Integer)");
        this.quotaBar.setMouseClickAction(this.menuBar.accountAction);
        this.trashTree.load();
        this.trashTree.itemSelectionChanged.connect((Object)this, "trashTreeSelection()");
        this.trashTree.setEmptyAction(this.menuBar.emptyTrashAction);
        this.trashTree.setVisible(Global.isWindowVisible("trashTree"));
        this.menuBar.hideTrash.setChecked(Global.isWindowVisible("trashTree"));
        this.trashTree.updateCounts(this.listManager.getTrashCount());
        this.attributeTree.setVisible(Global.isWindowVisible("attributeTree"));
        this.menuBar.hideAttributes.setChecked(Global.isWindowVisible("attributeTree"));
        this.noteTableView.setVisible(Global.isWindowVisible("noteList"));
        this.menuBar.hideNoteList.setChecked(Global.isWindowVisible("noteList"));
        if (!Global.isWindowVisible("editorButtonBar")) {
            this.menuBar.showEditorBar.setChecked(false);
            this.toggleEditorButtonBar();
        }
        if (!Global.isWindowVisible("leftPanel")) {
            this.menuBar.hideLeftSide.setChecked(true);
        }
        if (Global.isWindowVisible("noteInformation")) {
            this.menuBar.noteAttributes.setChecked(true);
            this.toggleNoteInformation();
        }
        this.quotaBar.setVisible(Global.isWindowVisible("quota"));
        if (!Global.isWindowVisible("quota")) {
            this.menuBar.hideQuota.setChecked(false);
        }
        this.searchField.setVisible(Global.isWindowVisible("searchField"));
        if (!Global.isWindowVisible("searchField")) {
            this.menuBar.hideSearch.setChecked(false);
        }
        if (this.searchField.isHidden() && this.quotaBar.isHidden() && this.zoomSpinner.isHidden() && this.notebookTree.isHidden()) {
            this.searchLayout.hide();
        }
        this.setMenuBar(this.menuBar);
        this.setupToolBar();
        this.find = new FindDialog();
        this.find.getOkButton().clicked.connect((Object)this, "doFindText()");
        this.trayShowAction = new QAction(this.tr("Show/Hide"), (QObject)this);
        this.trayExitAction = new QAction(this.tr("Exit"), (QObject)this);
        this.trayAddNoteAction = new QAction(this.tr("Add Note"), (QObject)this);
        this.trayExitAction.triggered.connect((Object)this, "closeNeverNote()");
        this.trayAddNoteAction.triggered.connect((Object)this, "addNote()");
        this.trayShowAction.triggered.connect((Object)this, "trayToggleVisible()");
        this.trayMenu = new QMenu((QWidget)this);
        this.trayMenu.addAction(this.trayAddNoteAction);
        this.trayMenu.addAction(this.trayShowAction);
        this.trayMenu.addAction(this.trayExitAction);
        this.trayIcon = new QSystemTrayIcon((QObject)this);
        this.trayIcon.setToolTip(this.tr("NeighborNote"));
        this.trayIcon.setContextMenu(this.trayMenu);
        this.trayIcon.activated.connect((Object)this, "trayActivated(com.trolltech.qt.gui.QSystemTrayIcon$ActivationReason)");
        this.currentNoteGuid = "";
        this.currentNoteGuid = Global.getLastViewedNoteGuid();
        if (this.currentNoteGuid.equals("")) {
            this.currentNote = new Note();
        }
        if (!this.currentNoteGuid.trim().equals("")) {
            this.currentNote = this.conn.getNoteTable().getNote(this.currentNoteGuid, true, true, false, false, true);
        }
        this.noteIndexUpdated(true);
        this.showColumns();
        this.menuBar.showEditorBar.setChecked(Global.isWindowVisible("editorButtonBar"));
        if (this.menuBar.showEditorBar.isChecked()) {
            this.showEditorButtons(this.browserWindow);
        }
        this.tagIndexUpdated(true);
        this.savedSearchIndexUpdated();
        this.notebookIndexUpdated();
        this.updateQuotaBar();
        this.setupSyncSignalListeners();
        this.setupBrowserSignalListeners();
        this.setupIndexListeners();
        this.tagTree.tagSignal.listChanged.connect((Object)this, "tagIndexUpdated()");
        this.tagTree.showAllTags(true);
        QIcon appIcon = new QIcon(String.valueOf(this.iconPath) + "nevernote.png");
        if (QSystemTrayIcon.isSystemTrayAvailable()) {
            this.setWindowIcon(appIcon);
            this.trayIcon.setIcon(appIcon);
            if (Global.showTrayIcon() || Global.minimizeOnClose()) {
                this.trayIcon.show();
            } else {
                this.trayIcon.hide();
            }
        }
        this.scrollToGuid(this.currentNoteGuid);
        if (Global.automaticLogin()) {
            this.remoteConnect();
            if (Global.isConnected) {
                this.syncTimer();
            }
        }
        this.setupFolderImports();
        this.loadStyleSheet();
        this.restoreWindowState(true);
        if (Global.mimicEvernoteInterface) {
            this.notebookTree.selectGuid("");
        }
        this.threadMonitorTimer = new QTimer();
        this.threadMonitorTimer.timeout.connect((Object)this, "threadMonitorCheck()");
        this.threadMonitorTimer.start(10000);
        this.menuBar.blockSignals(true);
        this.menuBar.narrowListView.blockSignals(true);
        this.menuBar.wideListView.blockSignals(true);
        if (Global.getListView() == Global.View_List_Narrow) {
            this.menuBar.narrowListView.setChecked(true);
        } else {
            this.menuBar.wideListView.setChecked(true);
        }
        this.menuBar.blockSignals(false);
        this.menuBar.narrowListView.blockSignals(false);
        this.menuBar.wideListView.blockSignals(false);
        this.messageTimer = new QTimer();
        this.messageTimer.timeout.connect((Object)this, "clearMessage()");
        this.messageTimer.setInterval(15000);
        this.clearMessage();
        int sortCol = Global.getSortColumn();
        int sortOrder = Global.getSortOrder();
        this.noteTableView.proxyModel.blocked = true;
        if (sortCol == 0 && sortOrder == 1 && Global.getListView() == Global.View_List_Narrow) {
            this.noteTableView.sortByColumn(sortCol, Qt.SortOrder.resolve((int)0));
        }
        this.noteTableView.sortByColumn(sortCol, Qt.SortOrder.resolve((int)sortOrder));
        this.noteTableView.proxyModel.blocked = false;
        this.noteTableView.proxyModel.sortChanged.connect((Object)this, "tableSortOrderChanged(Integer,Integer)");
        String defaultNotebook = Global.getStartupNotebook();
        if (!defaultNotebook.equals("AllNotebooks") && !defaultNotebook.equals("")) {
            int k = 0;
            while (k < this.listManager.getNotebookIndex().size()) {
                if (this.listManager.getNotebookIndex().get(k).isDefaultNotebook()) {
                    this.notebookTree.clearSelection();
                    this.notebookTree.selectGuid(this.listManager.getNotebookIndex().get(k).getGuid());
                    this.notebookTree.selectionSignal.emit();
                }
                ++k;
            }
        }
        if (Global.checkVersionUpgrade()) {
            this.checkForUpdates();
        }
        if (this.currentNoteGuid == null || this.currentNoteGuid.equals("")) {
            this.menuBar.noteAddNewTab.setEnabled(false);
        }
    }

    public void debugDirty() {
        List<Note> dirty = this.conn.getNoteTable().getDirty();
        this.logger.log(this.logger.LOW, "------ Dirty Notes List Begin ------");
        int i = 0;
        while (i < dirty.size()) {
            this.logger.log(this.logger.LOW, "GUID: " + dirty.get(i).getGuid() + " Title:" + dirty.get(i).getTitle());
            ++i;
        }
        this.logger.log(this.logger.LOW, "------ Dirty Notes List End ------");
    }

    public static void main(String[] args) {
        DatabaseConnection dbConn;
        boolean showSplash;
        log.setLevel(Level.FATAL);
        QApplication.initialize((String[])args);
        QPixmap pixmap = new QPixmap("classpath:cx/fbn/nevernote/icons/splash_logo.png");
        QSplashScreen splash = new QSplashScreen(pixmap);
        try {
            NeverNote.initializeGlobalSettings(args);
            showSplash = Global.isWindowVisible("SplashScreen");
            if (showSplash) {
                splash.show();
            }
            dbConn = NeverNote.setupDatabaseConnection();
            Global.getFileManager().purgeResDirectory(true);
        }
        catch (InitializationException e) {
            e.printStackTrace();
            QMessageBox.critical(null, (String)"Startup error", (String)("Aborting: " + e.getMessage()));
            return;
        }
        String proxyUrl = Global.getProxyValue("url");
        String proxyPort = Global.getProxyValue("port");
        String proxyUserid = Global.getProxyValue("userid");
        String proxyPassword = Global.getProxyValue("password");
        boolean proxySet = false;
        QNetworkProxy proxy = new QNetworkProxy();
        proxy.setType(QNetworkProxy.ProxyType.HttpProxy);
        if (!proxyUrl.trim().equals("")) {
            System.out.println("Proxy URL found: " + proxyUrl);
            proxySet = true;
            proxy.setHostName(proxyUrl);
        }
        if (!proxyPort.trim().equals("")) {
            System.out.println("Proxy Port found: " + proxyPort);
            proxySet = true;
            proxy.setPort(Integer.parseInt(proxyPort));
        }
        if (!proxyUserid.trim().equals("")) {
            System.out.println("Proxy Userid found: " + proxyUserid);
            proxySet = true;
            proxy.setUser(proxyUserid);
        }
        if (!proxyPassword.trim().equals("")) {
            System.out.println("Proxy URL found: " + proxyPassword);
            proxySet = true;
            proxy.setPassword(proxyPassword);
        }
        if (proxySet) {
            QNetworkProxy.setApplicationProxy((QNetworkProxy)proxy);
        }
        NeverNote application = new NeverNote(dbConn);
        if (Global.syncOnly) {
            System.out.println("Performing synchronization only.");
            application.remoteConnect();
            if (Global.isConnected) {
                application.syncRunner.syncNeeded = true;
                application.syncRunner.addWork("SYNC");
                application.syncRunner.addWork("STOP");
                while (!application.syncRunner.isIdle()) {
                }
                application.closeNeverNote();
            }
            return;
        }
        application.setAttribute(Qt.WidgetAttribute.WA_DeleteOnClose, true);
        if (Global.startMinimized()) {
            application.showMinimized();
        } else if (Global.wasWindowMaximized()) {
            application.showMaximized();
        } else {
            application.show();
        }
        if (showSplash) {
            splash.finish((QWidget)application);
        }
        QApplication.exec();
        System.out.println("Goodbye.");
        QApplication.exit();
    }

    private static DatabaseConnection setupDatabaseConnection() throws InitializationException {
        ApplicationLogger logger = new ApplicationLogger("nevernote-database.log");
        File f = Global.getFileManager().getDbDirFile(String.valueOf(Global.databaseName) + ".h2.db");
        File fr = Global.getFileManager().getDbDirFile(String.valueOf(Global.resourceDatabaseName) + ".h2.db");
        File fi = Global.getFileManager().getDbDirFile(String.valueOf(Global.indexDatabaseName) + ".h2.db");
        File fb = Global.getFileManager().getDbDirFile(String.valueOf(Global.behaviorDatabaseName) + ".h2.db");
        if (!f.exists()) {
            Global.setDatabaseUrl("");
        }
        if (!fr.exists()) {
            Global.setResourceDatabaseUrl("");
        }
        if (!fi.exists()) {
            Global.setIndexDatabaseUrl("");
        }
        if (!fb.exists()) {
            Global.setBehaviorDatabaseUrl("");
        }
        if (Global.getDatabaseUrl().toUpperCase().indexOf("CIPHER=") > -1) {
            boolean goodCheck = false;
            while (!goodCheck) {
                DatabaseLoginDialog dialog = new DatabaseLoginDialog();
                dialog.exec();
                if (!dialog.okPressed()) {
                    System.exit(0);
                }
                Global.cipherPassword = dialog.getPassword();
                goodCheck = NeverNote.databaseCheck(Global.getDatabaseUrl(), Global.getDatabaseUserid(), Global.getDatabaseUserPassword(), Global.cipherPassword);
            }
        }
        DatabaseConnection dbConn = new DatabaseConnection(logger, Global.getDatabaseUrl(), Global.getIndexDatabaseUrl(), Global.getResourceDatabaseUrl(), Global.getBehaviorDatabaseUrl(), Global.getDatabaseUserid(), Global.getDatabaseUserPassword(), Global.cipherPassword, 0);
        return dbConn;
    }

    private void encryptOnShutdown() {
        String dbPath = Global.getFileManager().getDbDirPath("");
        try {
            Statement st = this.conn.getConnection().createStatement();
            st.execute("shutdown");
            st = this.conn.getResourceConnection().createStatement();
            st.execute("shutdown");
            st = this.conn.getIndexConnection().createStatement();
            st.execute("shutdown");
            st = this.conn.getBehaviorConnection().createStatement();
            st.execute("shutdown");
            if (QMessageBox.question((QWidget)this, (String)this.tr("Are you sure"), (String)this.tr("Are you sure you wish to encrypt the database?"), (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.Yes.value()) {
                ChangeFileEncryption.execute((String)dbPath, (String)"NeverNote", (String)this.encryptCipher, null, (char[])Global.cipherPassword.toCharArray(), (boolean)true);
                ChangeFileEncryption.execute((String)dbPath, (String)"Resources", (String)this.encryptCipher, null, (char[])Global.cipherPassword.toCharArray(), (boolean)true);
                ChangeFileEncryption.execute((String)dbPath, (String)"Index", (String)this.encryptCipher, null, (char[])Global.cipherPassword.toCharArray(), (boolean)true);
                ChangeFileEncryption.execute((String)dbPath, (String)"Behavior", (String)this.encryptCipher, null, (char[])Global.cipherPassword.toCharArray(), (boolean)true);
                Global.setDatabaseUrl(String.valueOf(Global.getDatabaseUrl()) + ";CIPHER=" + this.encryptCipher);
                Global.setResourceDatabaseUrl(String.valueOf(Global.getResourceDatabaseUrl()) + ";CIPHER=" + this.encryptCipher);
                Global.setIndexDatabaseUrl(String.valueOf(Global.getIndexDatabaseUrl()) + ";CIPHER=" + this.encryptCipher);
                Global.setBehaviorDatabaseUrl(String.valueOf(Global.getBehaviorDatabaseUrl()) + ";CIPHER=" + this.encryptCipher);
                QMessageBox.information((QWidget)this, (String)this.tr("Encryption Complete"), (String)this.tr("Encryption is complete"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void decryptOnShutdown() {
        String dbPath = Global.getFileManager().getDbDirPath("");
        String dbName = "NeverNote";
        try {
            Statement st = this.conn.getConnection().createStatement();
            st.execute("shutdown");
            this.encryptCipher = Global.getDatabaseUrl().toUpperCase().indexOf(";CIPHER=AES") > -1 ? "AES" : "XTEA";
            if (QMessageBox.question((QWidget)this, (String)this.tr("Confirmation"), (String)this.tr("Are you sure", "Are you sure you wish to decrypt the database?"), (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.Yes.value()) {
                ChangeFileEncryption.execute((String)dbPath, (String)dbName, (String)this.encryptCipher, (char[])Global.cipherPassword.toCharArray(), null, (boolean)true);
                Global.setDatabaseUrl("");
                Global.setResourceDatabaseUrl("");
                Global.setIndexDatabaseUrl("");
                QMessageBox.information((QWidget)this, (String)this.tr("Decryption Complete"), (String)this.tr("Decryption is complete"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void doDatabaseEncrypt() {
        if (Global.getDatabaseUrl().toUpperCase().indexOf("CIPHER=") == -1) {
            if (QMessageBox.question((QWidget)this, (String)this.tr("Confirmation"), (String)this.tr("Encrypting the database is usedto enhance security and is performed\nupon shutdown, but please be aware that if you lose the password your\nis lost forever.\n\nIt is highly recommended you perform a backup and/or fully synchronize\n prior to executing this funtction.\n\nDo you wish to proceed?"), (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.No.value()) {
                return;
            }
            DBEncryptDialog dialog = new DBEncryptDialog();
            dialog.exec();
            if (dialog.okPressed()) {
                Global.cipherPassword = dialog.getPassword();
                this.encryptOnShutdown = true;
                this.encryptCipher = dialog.getEncryptionMethod();
            }
        } else {
            DBEncryptDialog dialog = new DBEncryptDialog();
            dialog.setWindowTitle(this.tr("Database Decryption"));
            dialog.hideEncryption();
            dialog.exec();
            if (dialog.okPressed()) {
                if (!dialog.getPassword().equals(Global.cipherPassword)) {
                    QMessageBox.critical(null, (String)this.tr("Incorrect Password"), (String)this.tr("Incorrect Password"));
                    return;
                }
                this.decryptOnShutdown = true;
                this.encryptCipher = "";
            }
        }
    }

    private static void initializeGlobalSettings(String[] args) throws InitializationException {
        StartupConfig startupConfig = new StartupConfig();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String lower = arg.toLowerCase();
            if (lower.startsWith("--name=")) {
                startupConfig.setName(arg.substring(arg.indexOf(61) + 1));
            }
            if (lower.startsWith("--home=")) {
                startupConfig.setHomeDirPath(arg.substring(arg.indexOf(61) + 1));
            }
            if (lower.startsWith("--disable-viewing")) {
                startupConfig.setDisableViewing(true);
            }
            if (lower.startsWith("--sync-only=true")) {
                startupConfig.setSyncOnly(true);
            }
            ++n2;
        }
        Global.setup(startupConfig);
    }

    public void closeEvent(QCloseEvent event) {
        if (Global.minimizeOnClose() && !this.closeAction) {
            event.ignore();
            this.hide();
            return;
        }
        this.logger.log(this.logger.HIGH, "Entering NeverNote.closeEvent");
        this.waitCursor(true);
        if (this.currentNote != null & this.browserWindow != null && this.currentNote.getTitle() != null && this.browserWindow != null && !this.currentNote.getTitle().equals(this.browserWindow.getTitle())) {
            this.conn.getNoteTable().updateNoteTitle(this.currentNote.getGuid(), this.browserWindow.getTitle());
        }
        this.saveNote();
        this.setMessage(this.tr("Beginning shutdown."));
        Collection<ExternalBrowse> windows = this.externalWindows.values();
        for (ExternalBrowse browser : windows) {
            browser.windowClosing.disconnect();
            browser.close();
        }
        Collection<TabBrowse> win = this.tabWindows.values();
        Iterator<TabBrowse> it = win.iterator();
        this.tabBrowser.currentChanged.disconnect();
        this.tabBrowser.tabCloseRequested.disconnect();
        while (it.hasNext()) {
            TabBrowse browser = it.next();
            browser.close();
        }
        this.externalFileEditedSaver();
        if (Global.isConnected && Global.synchronizeOnClose()) {
            this.setMessage(this.tr("Performing synchronization before closing."));
            this.syncRunner.syncNeeded = true;
            this.syncRunner.addWork("SYNC");
        } else {
            this.syncRunner.keepRunning = false;
        }
        this.syncRunner.addWork("STOP");
        this.setMessage("Closing Program.");
        this.threadMonitorTimer.stop();
        this.thumbnailRunner.addWork("STOP");
        this.indexRunner.addWork("STOP");
        this.saveNote();
        this.listManager.stop();
        this.saveWindowState();
        this.rensoNoteListDock.getRensoNoteList().stopThread();
        if (this.tempFiles != null) {
            this.tempFiles.clear();
        }
        this.browserWindow.noteSignal.tagsChanged.disconnect();
        this.browserWindow.noteSignal.titleChanged.disconnect();
        this.browserWindow.noteSignal.noteChanged.disconnect();
        this.browserWindow.noteSignal.notebookChanged.disconnect();
        this.browserWindow.noteSignal.createdDateChanged.disconnect();
        this.browserWindow.noteSignal.alteredDateChanged.disconnect();
        this.syncRunner.searchSignal.listChanged.disconnect();
        this.syncRunner.tagSignal.listChanged.disconnect();
        this.syncRunner.notebookSignal.listChanged.disconnect();
        this.syncRunner.noteIndexSignal.listChanged.disconnect();
        if (this.isVisible()) {
            Global.saveWindowVisible("toolBar", this.toolBar.isVisible());
        }
        this.saveNoteColumnPositions();
        this.saveNoteIndexWidth();
        int width = this.notebookTree.columnWidth(0);
        Global.setColumnWidth("notebookTreeName", width);
        width = this.tagTree.columnWidth(0);
        Global.setColumnWidth("tagTreeName", width);
        Global.saveWindowMaximized(this.isMaximized());
        Global.saveCurrentNoteGuid(this.currentNoteGuid);
        int sortCol = this.noteTableView.proxyModel.sortColumn();
        int sortOrder = this.noteTableView.proxyModel.sortOrder().value();
        Global.setSortColumn(sortCol);
        Global.setSortOrder(sortOrder);
        this.hide();
        this.trayIcon.hide();
        Global.keepRunning = false;
        try {
            this.logger.log(this.logger.MEDIUM, "Waiting for indexThread to stop");
            if (this.indexRunner.thread().isAlive()) {
                this.indexRunner.thread().join(50L);
            }
            if (!this.indexRunner.thread().isAlive()) {
                this.logger.log(this.logger.MEDIUM, "Index thread has stopped");
            } else {
                this.logger.log(this.logger.MEDIUM, "Index thread still running - interrupting");
                this.indexRunner.thread().interrupt();
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (!this.syncRunner.thread().isAlive()) {
            this.logger.log(this.logger.MEDIUM, "Waiting for syncThread to stop");
            if (this.syncRunner.thread().isAlive()) {
                System.out.println(this.tr("Synchronizing.  Please be patient."));
                while (this.syncRunner.thread().isAlive()) {
                    try {
                        ((Object)((Object)this)).wait(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.logger.log(this.logger.MEDIUM, "Sync thread has stopped");
        }
        if (this.encryptOnShutdown) {
            this.encryptOnShutdown();
        }
        if (this.decryptOnShutdown) {
            this.decryptOnShutdown();
        }
        try {
            Global.getFileManager().purgeResDirectory(false);
        }
        catch (InitializationException e) {
            System.out.println(this.tr("Empty res directory purge failed"));
            e.printStackTrace();
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.closeEvent");
    }

    private void closeNeverNote() {
        this.closeAction = true;
        this.close();
    }

    public void setMessage(String s) {
        if (this.logger != null) {
            this.logger.log(this.logger.HIGH, "Entering NeverNote.setMessage");
        } else {
            System.out.println("*** ERROR *** " + s);
        }
        if (this.statusBar != null) {
            this.statusBar.show();
            if (this.logger != null) {
                this.logger.log(this.logger.HIGH, "Message: " + s);
            }
            this.statusBar.showMessage(s);
            if (this.emitLog != null) {
                this.emitLog.add(s);
            }
            if (this.messageTimer != null) {
                this.messageTimer.stop();
                this.messageTimer.setSingleShot(true);
                this.messageTimer.start();
            }
        }
        if (this.logger != null) {
            this.logger.log(this.logger.HIGH, "Leaving NeverNote.setMessage");
        }
    }

    private void clearMessage() {
        this.statusBar.clearMessage();
        this.statusBar.hide();
    }

    private void waitCursor(boolean wait) {
        if (wait) {
            if (QApplication.overrideCursor() == null) {
                QApplication.setOverrideCursor((QCursor)new QCursor(Qt.CursorShape.WaitCursor));
            }
        } else if (QApplication.overrideCursor() != null) {
            QApplication.restoreOverrideCursor();
        } else {
            QApplication.setOverrideCursor((QCursor)new QCursor(Qt.CursorShape.ArrowCursor));
        }
        this.listManager.refreshCounters();
    }

    private void setupIndexListeners() {
        this.indexRunner.signal.indexStarted.connect((Object)this, "indexStarted()");
        this.indexRunner.signal.indexFinished.connect((Object)this, "indexComplete()");
    }

    private void setupSyncSignalListeners() {
        this.syncRunner.tagSignal.listChanged.connect((Object)this, "tagIndexUpdated()");
        this.syncRunner.searchSignal.listChanged.connect((Object)this, "savedSearchIndexUpdated()");
        this.syncRunner.notebookSignal.listChanged.connect((Object)this, "notebookIndexUpdated()");
        this.syncRunner.noteIndexSignal.listChanged.connect((Object)this, "noteIndexUpdated(boolean)");
        this.syncRunner.noteSignal.quotaChanged.connect((Object)this, "updateQuotaBar()");
        this.syncRunner.syncSignal.saveUploadAmount.connect((Object)this, "saveUploadAmount(long)");
        this.syncRunner.syncSignal.saveUserInformation.connect((Object)this, "saveUserInformation(User)");
        this.syncRunner.syncSignal.saveEvernoteUpdateCount.connect((Object)this, "saveEvernoteUpdateCount(int)");
        this.syncRunner.noteSignal.guidChanged.connect((Object)this, "noteGuidChanged(String, String)");
        this.syncRunner.noteSignal.noteChanged.connect((Object)this, "invalidateNoteCache(String, String)");
        this.syncRunner.resourceSignal.resourceGuidChanged.connect((Object)this, "noteResourceGuidChanged(String,String,String)");
        this.syncRunner.noteSignal.noteDownloaded.connect((Object)this.listManager, "noteDownloaded(Note)");
        this.syncRunner.noteSignal.notebookChanged.connect((Object)this, "updateNoteNotebook(String, String)");
        this.syncRunner.syncSignal.refreshLists.connect((Object)this, "refreshLists()");
    }

    private void setupBrowserSignalListeners() {
        this.setupBrowserWindowListeners(this.browserWindow, true);
    }

    private void setupBrowserWindowListeners(BrowserWindow browser, boolean master) {
        browser.fileWatcher.fileChanged.connect((Object)this, "externalFileEdited(String)");
        browser.noteSignal.tagsChanged.connect((Object)this, "updateNoteTags(String, List)");
        browser.noteSignal.tagsChanged.connect((Object)this, "updateListTags(String, List)");
        if (master) {
            browser.noteSignal.noteChanged.connect((Object)this, "setNoteDirty()");
        }
        browser.noteSignal.titleChanged.connect((Object)this.listManager, "updateNoteTitle(String, String)");
        browser.noteSignal.titleChanged.connect((Object)this, "updateNoteTitle(String, String)");
        browser.noteSignal.notebookChanged.connect((Object)this, "updateNoteNotebook(String, String)");
        browser.noteSignal.createdDateChanged.connect((Object)this.listManager, "updateNoteCreatedDate(String, QDateTime)");
        browser.noteSignal.alteredDateChanged.connect((Object)this.listManager, "updateNoteAlteredDate(String, QDateTime)");
        browser.noteSignal.subjectDateChanged.connect((Object)this.listManager, "updateNoteSubjectDate(String, QDateTime)");
        browser.noteSignal.authorChanged.connect((Object)this.listManager, "updateNoteAuthor(String, String)");
        browser.noteSignal.geoChanged.connect((Object)this.listManager, "updateNoteGeoTag(String, Double,Double,Double)");
        browser.noteSignal.geoChanged.connect((Object)this, "setNoteDirty()");
        browser.noteSignal.sourceUrlChanged.connect((Object)this.listManager, "updateNoteSourceUrl(String, String)");
        browser.blockApplication.connect((Object)this, "blockApplication(BrowserWindow)");
        browser.unblockApplication.connect((Object)this, "unblockApplication()");
        if (master) {
            browser.focusLost.connect((Object)this, "saveNote()");
        }
        browser.resourceSignal.contentChanged.connect((Object)this, "externalFileEdited(String)");
        browser.evernoteLinkClicked.connect((Object)this, "evernoteLinkClick(String, String)");
    }

    private void setupShortcut(QShortcut action, String text) {
        if (!Global.shortcutKeys.containsAction(text)) {
            return;
        }
        action.setKey(new QKeySequence(Global.shortcutKeys.getShortcut(text)));
    }

    private void settings() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.settings");
        this.saveNoteColumnPositions();
        this.saveNoteIndexWidth();
        this.showColumns();
        ConfigDialog settings = new ConfigDialog(this, this.conn);
        String dateFormat = Global.getDateFormat();
        String timeFormat = Global.getTimeFormat();
        this.indexTime = 1000 * Global.getIndexThreadSleepInterval();
        this.indexTimer.start(this.indexTime);
        settings.exec();
        this.indexRunner.indexAttachmentsLocally = Global.indexAttachmentsLocally();
        this.indexRunner.indexImageRecognition = Global.indexImageRecognition();
        if (Global.showTrayIcon() || Global.minimizeOnClose()) {
            this.trayIcon.show();
        } else {
            this.trayIcon.hide();
        }
        this.showColumns();
        if (this.menuBar.showEditorBar.isChecked()) {
            int i = 0;
            while (i < this.tabBrowser.count()) {
                BrowserWindow browser = ((TabBrowse)this.tabBrowser.widget(i)).getBrowserWindow();
                this.showEditorButtons(browser);
                ++i;
            }
        }
        if (Global.getAutoSaveInterval() > 0) {
            this.saveTimer.setInterval(60000 * Global.getAutoSaveInterval());
        } else {
            this.saveTimer.stop();
        }
        if (settings.getDebugPage().reloadSharedNotebooksClicked()) {
            this.conn.executeSql("Delete from LinkedNotebook");
            this.conn.executeSql("delete from SharedNotebook");
            this.conn.executeSql("Delete from Notebook where linked=true");
            this.conn.executeSql("Insert into Sync (key, value) values ('FullLinkedNotebookSync', 'true')");
            this.conn.executeSql("Insert into Sync (key, value) values ('FullSharedNotebookSync', 'true')");
        }
        this.noteCache.clear();
        this.readOnlyCache.clear();
        this.inkNoteCache.clear();
        this.noteIndexUpdated(true);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.settings");
    }

    private void restoreWindowState(boolean mainWindow) {
        this.setObjectName("NeverNote");
        this.restoreState(Global.restoreState(this.objectName()));
        this.mainLeftRightSplitter.setObjectName("mainLeftRightSplitter");
        this.browserIndexSplitter.setObjectName("browserIndexSplitter");
        this.leftSplitter1.setObjectName("leftSplitter1");
        this.rensoNoteListDock.setObjectName("rensoNoteListDock");
        if (mainWindow) {
            this.restoreGeometry(Global.restoreGeometry(this.objectName()));
        }
        this.mainLeftRightSplitter.restoreState(Global.restoreState(this.mainLeftRightSplitter.objectName()));
        this.browserIndexSplitter.restoreState(Global.restoreState(this.browserIndexSplitter.objectName()));
        this.leftSplitter1.restoreState(Global.restoreState(this.leftSplitter1.objectName()));
        this.rensoNoteListDock.restoreGeometry(Global.restoreGeometry(this.rensoNoteListDock.objectName()));
    }

    private void saveWindowState() {
        Global.saveGeometry(this.objectName(), this.saveGeometry());
        Global.saveState(this.mainLeftRightSplitter.objectName(), this.mainLeftRightSplitter.saveState());
        Global.saveState(this.browserIndexSplitter.objectName(), this.browserIndexSplitter.saveState());
        Global.saveState(this.leftSplitter1.objectName(), this.leftSplitter1.saveState());
        Global.saveState(this.objectName(), this.saveState());
        Global.saveGeometry(this.rensoNoteListDock.objectName(), this.rensoNoteListDock.saveGeometry());
    }

    private void loadStyleSheet() {
        String fileName;
        QFile file;
        String styleSheetName = "default.qss";
        if (Global.getStyle().equalsIgnoreCase("cleanlooks")) {
            styleSheetName = "default-cleanlooks.qss";
        }
        if (!(file = new QFile(fileName = Global.getFileManager().getQssDirPathUser("default.qss"))).exists()) {
            fileName = Global.getFileManager().getQssDirPath(styleSheetName);
            file = new QFile(fileName);
        }
        file.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly});
        String styleSheet = file.readAll().toString();
        file.close();
        this.setStyleSheet(styleSheet);
    }

    private void saveNoteColumnPositions() {
        int position = this.noteTableView.header.visualIndex(Global.noteTableCreationPosition);
        Global.setColumnPosition("noteTableCreationPosition", position);
        position = this.noteTableView.header.visualIndex(Global.noteTableTagPosition);
        Global.setColumnPosition("noteTableTagPosition", position);
        position = this.noteTableView.header.visualIndex(Global.noteTableNotebookPosition);
        Global.setColumnPosition("noteTableNotebookPosition", position);
        position = this.noteTableView.header.visualIndex(Global.noteTableChangedPosition);
        Global.setColumnPosition("noteTableChangedPosition", position);
        position = this.noteTableView.header.visualIndex(Global.noteTableAuthorPosition);
        Global.setColumnPosition("noteTableAuthorPosition", position);
        position = this.noteTableView.header.visualIndex(Global.noteTableSourceUrlPosition);
        Global.setColumnPosition("noteTableSourceUrlPosition", position);
        position = this.noteTableView.header.visualIndex(Global.noteTableSubjectDatePosition);
        Global.setColumnPosition("noteTableSubjectDatePosition", position);
        position = this.noteTableView.header.visualIndex(Global.noteTableTitlePosition);
        Global.setColumnPosition("noteTableTitlePosition", position);
        position = this.noteTableView.header.visualIndex(Global.noteTableSynchronizedPosition);
        Global.setColumnPosition("noteTableSynchronizedPosition", position);
        position = this.noteTableView.header.visualIndex(Global.noteTableGuidPosition);
        Global.setColumnPosition("noteTableGuidPosition", position);
        position = this.noteTableView.header.visualIndex(Global.noteTableThumbnailPosition);
        Global.setColumnPosition("noteTableThumbnailPosition", position);
        position = this.noteTableView.header.visualIndex(Global.noteTablePinnedPosition);
        Global.setColumnPosition("noteTablePinnedPosition", position);
    }

    private void saveNoteIndexWidth() {
        int width = this.noteTableView.getColumnWidth(Global.noteTableCreationPosition);
        Global.setColumnWidth("noteTableCreationPosition", width);
        width = this.noteTableView.getColumnWidth(Global.noteTableChangedPosition);
        Global.setColumnWidth("noteTableChangedPosition", width);
        width = this.noteTableView.getColumnWidth(Global.noteTableGuidPosition);
        Global.setColumnWidth("noteTableGuidPosition", width);
        width = this.noteTableView.getColumnWidth(Global.noteTableNotebookPosition);
        Global.setColumnWidth("noteTableNotebookPosition", width);
        width = this.noteTableView.getColumnWidth(Global.noteTableTagPosition);
        Global.setColumnWidth("noteTableTagPosition", width);
        width = this.noteTableView.getColumnWidth(Global.noteTableTitlePosition);
        Global.setColumnWidth("noteTableTitlePosition", width);
        width = this.noteTableView.getColumnWidth(Global.noteTableSourceUrlPosition);
        Global.setColumnWidth("noteTableSourceUrlPosition", width);
        width = this.noteTableView.getColumnWidth(Global.noteTableAuthorPosition);
        Global.setColumnWidth("noteTableAuthorPosition", width);
        width = this.noteTableView.getColumnWidth(Global.noteTableSubjectDatePosition);
        Global.setColumnWidth("noteTableSubjectDatePosition", width);
        width = this.noteTableView.getColumnWidth(Global.noteTableSynchronizedPosition);
        Global.setColumnWidth("noteTableSynchronizedPosition", width);
        width = this.noteTableView.getColumnWidth(Global.noteTableThumbnailPosition);
        Global.setColumnWidth("noteTableThumbnailPosition", width);
        width = this.noteTableView.getColumnWidth(Global.noteTableGuidPosition);
        Global.setColumnWidth("noteTableGuidPosition", width);
        width = this.noteTableView.getColumnWidth(Global.noteTablePinnedPosition);
        Global.setColumnWidth("noteTablePinnedPosition", width);
    }

    private void toggleSearchWindow() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.toggleSearchWindow");
        this.searchLayout.toggleSearchField();
        this.menuBar.hideSearch.setChecked(this.searchField.isVisible());
        Global.saveWindowVisible("searchField", this.searchField.isVisible());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.toggleSearchWindow");
    }

    private void toggleQuotaWindow() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.toggleQuotaWindow");
        this.searchLayout.toggleQuotaBar();
        this.menuBar.hideQuota.setChecked(this.quotaBar.isVisible());
        Global.saveWindowVisible("quota", this.quotaBar.isVisible());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.toggleQuotaWindow");
    }

    private void toggleZoomWindow() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.toggleZoomWindow");
        this.searchLayout.toggleZoom();
        this.menuBar.hideZoom.setChecked(this.zoomSpinner.isVisible());
        Global.saveWindowVisible("zoom", this.zoomSpinner.isVisible());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.toggleZoomWindow");
    }

    private void initializeNotebookTree() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.initializeNotebookTree");
        this.notebookTree.selectionSignal.connect((Object)this, "notebookTreeSelection()");
        this.listManager.notebookSignal.refreshNotebookTreeCounts.connect((Object)this.notebookTree, "updateCounts(List, List)");
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.initializeNotebookTree");
    }

    private void notebookTreeSelection() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.notebookTreeSelection");
        this.noteTableView.proxyModel.blocked = true;
        this.clearTrashFilter();
        this.clearAttributeFilter();
        this.clearSavedSearchFilter();
        if (Global.mimicEvernoteInterface) {
            this.clearTagFilter();
            this.searchField.clearEditText();
        }
        this.menuBar.noteRestoreAction.setVisible(false);
        this.menuBar.notebookEditAction.setEnabled(true);
        this.menuBar.notebookDeleteAction.setEnabled(true);
        this.menuBar.notebookPublishAction.setEnabled(true);
        this.menuBar.notebookShareAction.setEnabled(true);
        this.menuBar.notebookIconAction.setEnabled(true);
        this.menuBar.notebookStackAction.setEnabled(true);
        if (!this.rensoNoteListDock.isEnabled()) {
            this.rensoNoteListDock.setEnabled(true);
        }
        List selections = this.notebookTree.selectedItems();
        this.selectedNotebookGUIDs.clear();
        String guid = "";
        String stackName = "";
        if (selections.size() > 0) {
            guid = ((QTreeWidgetItem)selections.get(0)).text(2);
            stackName = ((QTreeWidgetItem)selections.get(0)).text(0);
        }
        if (!Global.mimicEvernoteInterface && selections.size() == 0) {
            this.selectedNotebookGUIDs.clear();
            int i = 0;
            while (i < this.listManager.getNotebookIndex().size()) {
                this.selectedNotebookGUIDs.add(this.listManager.getNotebookIndex().get(i).getGuid());
                ++i;
            }
            this.menuBar.notebookEditAction.setEnabled(false);
            this.menuBar.notebookDeleteAction.setEnabled(false);
            this.menuBar.notebookStackAction.setEnabled(false);
            this.menuBar.notebookIconAction.setEnabled(false);
        }
        if (!guid.equals("") && !guid.equals("STACK")) {
            this.selectedNotebookGUIDs.add(guid);
            this.menuBar.notebookIconAction.setEnabled(true);
        } else {
            this.menuBar.notebookIconAction.setEnabled(true);
            int j = 0;
            while (j < this.listManager.getNotebookIndex().size()) {
                Notebook book = this.listManager.getNotebookIndex().get(j);
                if (book.getStack() != null && book.getStack().equalsIgnoreCase(stackName)) {
                    this.selectedNotebookGUIDs.add(book.getGuid());
                }
                ++j;
            }
        }
        this.listManager.setSelectedNotebooks(this.selectedNotebookGUIDs);
        this.listManager.loadNotesIndex();
        this.noteIndexUpdated(false);
        this.refreshEvernoteNote(true);
        this.listManager.refreshCounters = true;
        this.listManager.refreshCounters();
        if (this.selectedNotebookGUIDs.size() == 1) {
            int col = this.conn.getNotebookTable().getSortColumn(this.selectedNotebookGUIDs.get(0));
            int order = this.conn.getNotebookTable().getSortOrder(this.selectedNotebookGUIDs.get(0));
            if (col != -1) {
                this.noteTableView.proxyModel.blocked = true;
                if (order == 1) {
                    this.noteTableView.sortByColumn(col, Qt.SortOrder.DescendingOrder);
                } else {
                    this.noteTableView.sortByColumn(col, Qt.SortOrder.AscendingOrder);
                }
            }
        }
        this.noteTableView.proxyModel.blocked = false;
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.notebookTreeSelection");
    }

    private void clearNotebookFilter() {
        this.notebookTree.blockSignals(true);
        this.notebookTree.clearSelection();
        this.menuBar.noteRestoreAction.setVisible(false);
        this.menuBar.notebookEditAction.setEnabled(false);
        this.menuBar.notebookDeleteAction.setEnabled(false);
        this.selectedNotebookGUIDs.clear();
        this.listManager.setSelectedNotebooks(this.selectedNotebookGUIDs);
        this.notebookTree.blockSignals(false);
    }

    private void notebookIndexUpdated() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.notebookIndexUpdated");
        HashMap<String, QIcon> icons = this.conn.getNotebookTable().getAllIcons();
        this.notebookTree.setIcons(icons);
        if (this.selectedNotebookGUIDs == null) {
            this.selectedNotebookGUIDs = new ArrayList<String>();
        }
        List<Notebook> books = this.conn.getNotebookTable().getAll();
        int i = books.size() - 1;
        while (i >= 0) {
            int j = 0;
            while (j < this.listManager.getArchiveNotebookIndex().size()) {
                if (this.listManager.getArchiveNotebookIndex().get(j).getGuid().equals(books.get(i).getGuid())) {
                    books.remove(i);
                    j = this.listManager.getArchiveNotebookIndex().size();
                }
                ++j;
            }
            --i;
        }
        this.listManager.countNotebookResults(this.listManager.getNoteIndex());
        this.notebookTree.blockSignals(true);
        this.notebookTree.load(books, this.listManager.getLocalNotebooks());
        i = this.selectedNotebookGUIDs.size() - 1;
        while (i >= 0) {
            boolean found = this.notebookTree.selectGuid(this.selectedNotebookGUIDs.get(i));
            if (!found) {
                this.selectedNotebookGUIDs.remove(i);
            }
            --i;
        }
        this.listManager.refreshCounters = true;
        this.listManager.refreshCounters();
        this.notebookTree.blockSignals(false);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.notebookIndexUpdated");
    }

    private void toggleNotebookWindow() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.toggleNotebookWindow");
        this.searchLayout.toggleNotebook();
        this.menuBar.hideNotebooks.setChecked(this.notebookTree.isVisible());
        Global.saveWindowVisible("notebookTree", this.notebookTree.isVisible());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.toggleNotebookWindow");
    }

    private void addNotebook() {
        this.logger.log(this.logger.HIGH, "Inside NeverNote.addNotebook");
        NotebookEdit edit = new NotebookEdit();
        edit.setNotebooks(this.listManager.getNotebookIndex());
        edit.exec();
        if (!edit.okPressed()) {
            return;
        }
        GregorianCalendar currentTime = new GregorianCalendar();
        Long l = new Long(currentTime.getTimeInMillis());
        String randint = new String(Long.toString(l));
        Notebook newBook = new Notebook();
        newBook.setUpdateSequenceNum(0);
        newBook.setGuid(randint);
        newBook.setName(edit.getNotebook());
        newBook.setServiceCreated(new Date().getTime());
        newBook.setServiceUpdated(new Date().getTime());
        newBook.setDefaultNotebook(false);
        newBook.setPublished(false);
        this.listManager.getNotebookIndex().add(newBook);
        if (edit.isLocal()) {
            this.listManager.getLocalNotebooks().add(newBook.getGuid());
        }
        this.conn.getNotebookTable().addNotebook(newBook, true, edit.isLocal());
        this.notebookIndexUpdated();
        this.listManager.countNotebookResults(this.listManager.getNoteIndex());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.addNotebook");
    }

    private void stackNotebook() {
        QTreeWidgetItem currentSelection;
        this.logger.log(this.logger.HIGH, "Entering NeverNote.stackNotebook");
        StackNotebook edit = new StackNotebook();
        List selections = this.notebookTree.selectedItems();
        int i = 0;
        while (i < selections.size()) {
            currentSelection = (QTreeWidgetItem)selections.get(0);
            String guid = currentSelection.text(2);
            if (guid.equalsIgnoreCase("")) {
                QMessageBox.critical((QWidget)this, (String)this.tr("Unable To Stack"), (String)this.tr("You can't stack the \"All Notebooks\" item."));
                return;
            }
            if (guid.equalsIgnoreCase("STACK")) {
                QMessageBox.critical((QWidget)this, (String)this.tr("Unable To Stack"), (String)this.tr("You can't stack a stack."));
                return;
            }
            ++i;
        }
        edit.setStackNames(this.conn.getNotebookTable().getAllStackNames());
        edit.exec();
        if (!edit.okPressed()) {
            return;
        }
        String stack = edit.getStackName();
        int i2 = 0;
        while (i2 < selections.size()) {
            currentSelection = (QTreeWidgetItem)selections.get(i2);
            String guid = currentSelection.text(2);
            this.listManager.updateNotebookStack(guid, stack);
            ++i2;
        }
        this.notebookIndexUpdated();
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.stackNotebook");
    }

    private void editNotebook() {
        int i;
        this.logger.log(this.logger.HIGH, "Entering NeverNote.editNotebook");
        NotebookEdit edit = new NotebookEdit();
        List selections = this.notebookTree.selectedItems();
        QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(0);
        edit.setNotebook(currentSelection.text(0));
        String guid = currentSelection.text(2);
        if (!guid.equalsIgnoreCase("STACK")) {
            edit.setTitle(this.tr("Edit Notebook"));
            edit.setNotebooks(this.listManager.getNotebookIndex());
            edit.setLocalCheckboxEnabled(false);
            i = 0;
            while (i < this.listManager.getNotebookIndex().size()) {
                if (this.listManager.getNotebookIndex().get(i).getGuid().equals(guid)) {
                    edit.setDefaultNotebook(this.listManager.getNotebookIndex().get(i).isDefaultNotebook());
                    i = this.listManager.getNotebookIndex().size();
                }
                ++i;
            }
        } else {
            edit.setTitle(this.tr("Edit Stack"));
            edit.setStacks(this.conn.getNotebookTable().getAllStackNames());
            edit.hideLocalCheckbox();
            edit.hideDefaultCheckbox();
        }
        edit.exec();
        if (!edit.okPressed()) {
            return;
        }
        if (guid.equalsIgnoreCase("STACK")) {
            this.conn.getNotebookTable().renameStacks(currentSelection.text(0), edit.getNotebook());
            int j = 0;
            while (j < this.listManager.getNotebookIndex().size()) {
                if (this.listManager.getNotebookIndex().get(j).getStack() != null && this.listManager.getNotebookIndex().get(j).getStack().equalsIgnoreCase(currentSelection.text(0))) {
                    this.listManager.getNotebookIndex().get(j).setStack(edit.getNotebook());
                }
                ++j;
            }
            this.conn.getNotebookTable().renameStacks(currentSelection.text(0), edit.getNotebook());
            currentSelection.setText(0, edit.getNotebook());
            return;
        }
        this.updateListNotebookName(currentSelection.text(0), edit.getNotebook());
        currentSelection.setText(0, edit.getNotebook());
        i = 0;
        while (i < this.listManager.getNotebookIndex().size()) {
            if (this.listManager.getNotebookIndex().get(i).getGuid().equals(guid)) {
                this.listManager.getNotebookIndex().get(i).setName(edit.getNotebook());
                if (!this.listManager.getNotebookIndex().get(i).isDefaultNotebook() && edit.isDefaultNotebook()) {
                    int j = 0;
                    while (j < this.listManager.getNotebookIndex().size()) {
                        this.listManager.getNotebookIndex().get(j).setDefaultNotebook(false);
                        ++j;
                    }
                    this.listManager.getNotebookIndex().get(i).setDefaultNotebook(true);
                    this.conn.getNotebookTable().setDefaultNotebook(this.listManager.getNotebookIndex().get(i).getGuid());
                }
                this.conn.getNotebookTable().updateNotebook(this.listManager.getNotebookIndex().get(i), true);
                if (this.conn.getNotebookTable().isLinked(this.listManager.getNotebookIndex().get(i).getGuid())) {
                    LinkedNotebook linkedNotebook = this.conn.getLinkedNotebookTable().getByNotebookGuid(this.listManager.getNotebookIndex().get(i).getGuid());
                    linkedNotebook.setShareName(edit.getNotebook());
                    this.conn.getLinkedNotebookTable().updateNotebook(linkedNotebook, true);
                }
                i = this.listManager.getNotebookIndex().size();
            }
            ++i;
        }
        ArrayList<Notebook> nbooks = new ArrayList<Notebook>();
        int i2 = 0;
        while (i2 < this.listManager.getNotebookIndex().size()) {
            boolean found = false;
            int j = 0;
            while (j < this.listManager.getArchiveNotebookIndex().size()) {
                if (this.listManager.getArchiveNotebookIndex().get(j).getGuid().equals(this.listManager.getNotebookIndex().get(i2).getGuid())) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                nbooks.add(this.listManager.getNotebookIndex().get(i2));
            }
            ++i2;
        }
        FilterEditorNotebooks notebookFilter = new FilterEditorNotebooks(this.conn, this.logger);
        List<Notebook> filteredBooks = notebookFilter.getValidNotebooks(this.currentNote, this.listManager.getNotebookIndex());
        this.browserWindow.setNotebookList(filteredBooks);
        Iterator<String> set = this.externalWindows.keySet().iterator();
        while (set.hasNext()) {
            this.externalWindows.get(set.next()).getBrowserWindow().setNotebookList(filteredBooks);
        }
        Iterator<Integer> it = this.tabWindows.keySet().iterator();
        while (it.hasNext()) {
            this.tabWindows.get(it.next()).getBrowserWindow().setNotebookList(filteredBooks);
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.editNotebook");
    }

    private void publishNotebook() {
        List selections = this.notebookTree.selectedItems();
        QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(0);
        String guid = currentSelection.text(2);
        if (guid.equalsIgnoreCase("STACK") || guid.equalsIgnoreCase("")) {
            return;
        }
        Notebook n = null;
        int position = 0;
        int i = 0;
        while (i < this.listManager.getNotebookIndex().size()) {
            if (guid.equals(this.listManager.getNotebookIndex().get(i).getGuid())) {
                n = this.listManager.getNotebookIndex().get(i);
                position = i;
                i = this.listManager.getNotebookIndex().size();
            }
            ++i;
        }
        if (n == null) {
            return;
        }
        PublishNotebook publish = new PublishNotebook(Global.username, Global.getServer(), n);
        publish.exec();
        if (!publish.okClicked()) {
            return;
        }
        Publishing p = publish.getPublishing();
        boolean isPublished = !publish.isStopPressed();
        this.conn.getNotebookTable().setPublishing(n.getGuid(), isPublished, p);
        n.setPublished(isPublished);
        n.setPublishing(p);
        this.listManager.getNotebookIndex().set(position, n);
        this.notebookIndexUpdated();
    }

    private void shareNotebook() {
        List selections = this.notebookTree.selectedItems();
        QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(0);
        String guid = currentSelection.text(2);
        if (guid.equalsIgnoreCase("STACK") || guid.equalsIgnoreCase("")) {
            return;
        }
        Notebook n = null;
        int i = 0;
        while (i < this.listManager.getNotebookIndex().size()) {
            if (guid.equals(this.listManager.getNotebookIndex().get(i).getGuid())) {
                n = this.listManager.getNotebookIndex().get(i);
                i = this.listManager.getNotebookIndex().size();
            }
            ++i;
        }
        String authToken = null;
        if (this.syncRunner.isConnected) {
            authToken = this.syncRunner.authToken;
        }
        ShareNotebook share = new ShareNotebook(n.getName(), this.conn, n, this.syncRunner);
        share.exec();
    }

    private void deleteNotebook() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.deleteNotebook");
        boolean stacksFound = false;
        boolean notebooksFound = false;
        boolean assigned = false;
        List selections = this.notebookTree.selectedItems();
        int i = 0;
        while (i < selections.size()) {
            QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(i);
            String guid = currentSelection.text(2);
            if (!guid.equalsIgnoreCase("STACK")) {
                notebooksFound = true;
                int j = 0;
                while (j < this.listManager.getNoteIndex().size()) {
                    String noteGuid = this.listManager.getNoteIndex().get(j).getNotebookGuid();
                    if (noteGuid.equals(guid)) {
                        assigned = true;
                        j = this.listManager.getNoteIndex().size();
                        i = selections.size();
                    }
                    ++j;
                }
            } else {
                stacksFound = true;
            }
            ++i;
        }
        if (assigned) {
            QMessageBox.information((QWidget)this, (String)this.tr("Unable to Delete"), (String)this.tr("Some of the selected notebook(s) contain notes.\nPlease delete the notes or move them to another notebook before deleting any notebooks."));
            return;
        }
        if (this.conn.getNotebookTable().getAll().size() == 1) {
            QMessageBox.information((QWidget)this, (String)this.tr("Unable to Delete"), (String)this.tr("You must have at least one notebook."));
            return;
        }
        String msg1 = new String(this.tr("Delete selected notebooks?"));
        String msg2 = new String(this.tr("Remove selected stacks (notebooks will not be deleted)?"));
        String msg3 = new String(this.tr("Delete selected notebooks & remove stacks? Notebooks under the stacks are not deleted unless selected?"));
        String msg = "";
        if (stacksFound && notebooksFound) {
            msg = msg3;
        }
        if (!stacksFound && notebooksFound) {
            msg = msg1;
        }
        if (stacksFound && !notebooksFound) {
            msg = msg2;
        }
        if (QMessageBox.question((QWidget)this, (String)this.tr("Confirmation"), (String)msg, (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.No.value()) {
            return;
        }
        int i2 = selections.size() - 1;
        while (i2 >= 0) {
            QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(i2);
            String guid = currentSelection.text(2);
            if (currentSelection.text(2).equalsIgnoreCase("STACK")) {
                this.conn.getNotebookTable().renameStacks(currentSelection.text(0), "");
                this.listManager.renameStack(currentSelection.text(0), "");
            } else {
                this.conn.getNotebookTable().expungeNotebook(guid, true);
                this.listManager.deleteNotebook(guid);
            }
            --i2;
        }
        this.notebookIndexUpdated();
        this.logger.log(this.logger.HIGH, "Entering NeverNote.deleteNotebook");
    }

    private void updateNoteNotebook(String guid, String notebookGuid) {
        this.conn.getHistoryTable().addSameNotebookHistory(guid, notebookGuid);
        this.listManager.updateNoteNotebook(guid, notebookGuid);
        this.listManager.countNotebookResults(this.listManager.getNoteIndex());
        String notebookName = null;
        int i = 0;
        while (i < this.listManager.getNotebookIndex().size()) {
            if (this.listManager.getNotebookIndex().get(i).getGuid().equals(notebookGuid)) {
                notebookName = this.listManager.getNotebookIndex().get(i).getName();
                break;
            }
            ++i;
        }
        if (notebookName != null) {
            int pos;
            this.updateListNoteNotebook(guid, notebookName);
            if (guid.equals(this.currentNoteGuid) && (pos = this.browserWindow.notebookBox.findText(notebookName)) >= 0) {
                this.browserWindow.notebookBox.setCurrentIndex(pos);
            }
        }
        if (guid.equals(this.currentNoteGuid) && this.currentNote != null) {
            this.currentNote.setNotebookGuid(notebookGuid);
        }
    }

    private void closeNotebooks() {
        Notebook n;
        int j;
        String text;
        NotebookArchive na = new NotebookArchive(this.listManager.getNotebookIndex(), this.listManager.getArchiveNotebookIndex());
        na.exec();
        if (!na.okClicked()) {
            return;
        }
        this.waitCursor(true);
        this.listManager.getArchiveNotebookIndex().clear();
        int i = na.getClosedBookList().count() - 1;
        while (i >= 0) {
            text = na.getClosedBookList().takeItem(i).text();
            j = 0;
            while (j < this.listManager.getNotebookIndex().size()) {
                if (this.listManager.getNotebookIndex().get(j).getName().equalsIgnoreCase(text)) {
                    n = this.listManager.getNotebookIndex().get(j);
                    this.conn.getNotebookTable().setArchived(n.getGuid(), true);
                    this.listManager.getArchiveNotebookIndex().add(n);
                    j = this.listManager.getNotebookIndex().size();
                }
                ++j;
            }
            --i;
        }
        i = na.getOpenBookList().count() - 1;
        while (i >= 0) {
            text = na.getOpenBookList().takeItem(i).text();
            j = 0;
            while (j < this.listManager.getNotebookIndex().size()) {
                if (this.listManager.getNotebookIndex().get(j).getName().equalsIgnoreCase(text)) {
                    n = this.listManager.getNotebookIndex().get(j);
                    this.conn.getNotebookTable().setArchived(n.getGuid(), false);
                    j = this.listManager.getNotebookIndex().size();
                }
                ++j;
            }
            --i;
        }
        this.notebookTreeSelection();
        this.listManager.loadNotesIndex();
        this.notebookIndexUpdated();
        this.noteIndexUpdated(false);
        this.reloadTagTree(true);
        ArrayList<Notebook> nbooks = new ArrayList<Notebook>();
        int i2 = 0;
        while (i2 < this.listManager.getNotebookIndex().size()) {
            boolean found = false;
            int j2 = 0;
            while (j2 < this.listManager.getArchiveNotebookIndex().size()) {
                if (this.listManager.getArchiveNotebookIndex().get(j2).getGuid().equals(this.listManager.getNotebookIndex().get(i2).getGuid())) {
                    found = true;
                }
                ++j2;
            }
            if (!found) {
                nbooks.add(this.listManager.getNotebookIndex().get(i2));
            }
            ++i2;
        }
        FilterEditorNotebooks notebookFilter = new FilterEditorNotebooks(this.conn, this.logger);
        List<Notebook> filteredBooks = notebookFilter.getValidNotebooks(this.currentNote, this.listManager.getNotebookIndex());
        this.browserWindow.setNotebookList(filteredBooks);
        Iterator<String> set = this.externalWindows.keySet().iterator();
        while (set.hasNext()) {
            this.externalWindows.get(set.next()).getBrowserWindow().setNotebookList(filteredBooks);
        }
        Iterator<Integer> it = this.tabWindows.keySet().iterator();
        while (it.hasNext()) {
            this.tabWindows.get(it.next()).getBrowserWindow().setNotebookList(filteredBooks);
        }
        this.waitCursor(false);
    }

    private void setNotebookIcon() {
        SetIcon dialog;
        QIcon icon;
        boolean stackSelected = false;
        boolean allNotebookSelected = false;
        List selections = this.notebookTree.selectedItems();
        if (selections.size() == 0) {
            return;
        }
        QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(0);
        String guid = currentSelection.text(2);
        if (guid.equalsIgnoreCase("")) {
            allNotebookSelected = true;
        }
        if (guid.equalsIgnoreCase("STACK")) {
            stackSelected = true;
        }
        QIcon currentIcon = currentSelection.icon(0);
        if (!stackSelected && !allNotebookSelected) {
            icon = this.conn.getNotebookTable().getIcon(guid);
            if (icon == null) {
                dialog = new SetIcon(currentIcon, this.saveLastPath);
                dialog.setUseDefaultIcon(true);
            } else {
                dialog = new SetIcon(icon, this.saveLastPath);
                dialog.setUseDefaultIcon(false);
            }
        } else {
            icon = stackSelected ? this.conn.getSystemIconTable().getIcon(currentSelection.text(0), "STACK") : this.conn.getSystemIconTable().getIcon(currentSelection.text(0), "ALLNOTEBOOK");
            if (icon == null) {
                dialog = new SetIcon(currentIcon, this.saveLastPath);
                dialog.setUseDefaultIcon(true);
            } else {
                dialog = new SetIcon(icon, this.saveLastPath);
                dialog.setUseDefaultIcon(false);
            }
        }
        dialog.exec();
        if (dialog.okPressed()) {
            this.saveLastPath = dialog.getPath();
            QIcon newIcon = dialog.getIcon();
            if (stackSelected) {
                this.conn.getSystemIconTable().setIcon(currentSelection.text(0), "STACK", newIcon, dialog.getFileType());
                if (newIcon == null) {
                    newIcon = new QIcon(String.valueOf(this.iconPath) + "books2.png");
                }
                currentSelection.setIcon(0, newIcon);
                return;
            }
            if (allNotebookSelected) {
                this.conn.getSystemIconTable().setIcon(currentSelection.text(0), "ALLNOTEBOOK", newIcon, dialog.getFileType());
                if (newIcon == null) {
                    newIcon = new QIcon(String.valueOf(this.iconPath) + "notebook-green.png");
                }
                currentSelection.setIcon(0, newIcon);
                return;
            }
            this.conn.getNotebookTable().setIcon(guid, newIcon, dialog.getFileType());
            if (newIcon == null) {
                boolean isPublished = false;
                boolean found = false;
                int i = 0;
                while (i < this.listManager.getNotebookIndex().size() && !found) {
                    if (this.listManager.getNotebookIndex().get(i).getGuid().equals(guid)) {
                        isPublished = this.listManager.getNotebookIndex().get(i).isPublished();
                        found = true;
                    }
                    ++i;
                }
                newIcon = this.notebookTree.findDefaultIcon(guid, currentSelection.text(1), this.listManager.getLocalNotebooks(), isPublished);
            }
            currentSelection.setIcon(0, newIcon);
        }
    }

    private void addTag() {
        this.logger.log(this.logger.HIGH, "Inside NeverNote.addTag");
        TagEdit edit = new TagEdit();
        edit.setTagList(this.listManager.getTagIndex());
        List selections = this.tagTree.selectedItems();
        QTreeWidgetItem currentSelection = null;
        if (selections.size() > 0) {
            currentSelection = (QTreeWidgetItem)selections.get(0);
            edit.setParentTag(currentSelection.text(0));
        }
        edit.exec();
        if (!edit.okPressed()) {
            return;
        }
        GregorianCalendar currentTime = new GregorianCalendar();
        Long l = new Long(currentTime.getTimeInMillis());
        String randint = new String(Long.toString(l));
        Tag newTag = new Tag();
        newTag.setUpdateSequenceNum(0);
        newTag.setGuid(randint);
        newTag.setName(edit.getTag());
        if (edit.getParentTag().isChecked()) {
            newTag.setParentGuid(currentSelection.text(2));
            newTag.setParentGuidIsSet(true);
            currentSelection.setExpanded(true);
        }
        this.conn.getTagTable().addTag(newTag, true);
        this.listManager.getTagIndex().add(newTag);
        this.reloadTagTree(true);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.addTag");
    }

    private void reloadTagTree() {
        this.reloadTagTree(false);
    }

    private void reloadTagTree(boolean reload) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.reloadTagTree");
        this.tagIndexUpdated(reload);
        boolean filter = false;
        if (reload) {
            this.listManager.countTagResults(this.listManager.getNoteIndex());
        }
        if (this.notebookTree.selectedItems().size() > 0 && !((QTreeWidgetItem)this.notebookTree.selectedItems().get(0)).text(0).equalsIgnoreCase("All Notebooks")) {
            filter = true;
        }
        if (this.tagTree.selectedItems().size() > 0) {
            filter = true;
        }
        this.tagTree.showAllTags(!filter);
        this.tagIndexUpdated(false);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.reloadTagTree");
    }

    private void editTag() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.editTag");
        TagEdit edit = new TagEdit();
        edit.setTitle("Edit Tag");
        List selections = this.tagTree.selectedItems();
        QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(0);
        edit.setTag(currentSelection.text(0));
        edit.setTagList(this.listManager.getTagIndex());
        edit.exec();
        if (!edit.okPressed()) {
            return;
        }
        String guid = currentSelection.text(2);
        currentSelection.setText(0, edit.getTag());
        int i = 0;
        while (i < this.listManager.getTagIndex().size()) {
            if (this.listManager.getTagIndex().get(i).getGuid().equals(guid)) {
                this.listManager.getTagIndex().get(i).setName(edit.getTag());
                this.conn.getTagTable().updateTag(this.listManager.getTagIndex().get(i), true);
                this.updateListTagName(guid);
                if (this.currentNote != null && this.currentNote.getTagGuids().contains(guid)) {
                    this.browserWindow.setTag(this.getTagNamesForNote(this.currentNote));
                }
                this.logger.log(this.logger.HIGH, "Leaving NeverNote.editTag");
            }
            ++i;
        }
        this.listManager.reloadNoteTagNames(guid, edit.getTag());
        this.noteIndexUpdated(true);
        this.refreshEvernoteNote(true);
        this.browserWindow.setTag(this.getTagNamesForNote(this.currentNote));
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.editTag...");
    }

    private void deleteTag() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.deleteTag");
        if (QMessageBox.question((QWidget)this, (String)this.tr("Confirmation"), (String)this.tr("Delete the selected tags?"), (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.No.value()) {
            return;
        }
        List selections = this.tagTree.selectedItems();
        int i = selections.size() - 1;
        while (i >= 0) {
            QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(i);
            this.removeTagItem(currentSelection.text(2));
            --i;
        }
        this.tagIndexUpdated(true);
        this.tagTreeSelection();
        this.listManager.countTagResults(this.listManager.getNoteIndex());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.deleteTag");
    }

    private void removeTagItem(String guid) {
        int j = this.listManager.getTagIndex().size() - 1;
        while (j >= 0) {
            String parent = this.listManager.getTagIndex().get(j).getParentGuid();
            if (parent != null && parent.equals(guid)) {
                this.removeTagItem(this.listManager.getTagIndex().get(j).getGuid());
            }
            --j;
        }
        this.removeListTagName(guid);
        this.conn.getTagTable().expungeTag(guid, true);
        int a = 0;
        while (a < this.listManager.getTagIndex().size()) {
            if (this.listManager.getTagIndex().get(a).getGuid().equals(guid)) {
                this.listManager.getTagIndex().remove(a);
                return;
            }
            ++a;
        }
    }

    private void initializeTagTree() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.initializeTagTree");
        this.tagTree.selectionSignal.connect((Object)this, "tagTreeSelection()");
        this.listManager.tagSignal.refreshTagTreeCounts.connect((Object)this.tagTree, "updateCounts(List)");
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.initializeTagTree");
    }

    private void tagTreeSelection() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.tagTreeSelection");
        this.clearTrashFilter();
        this.clearAttributeFilter();
        this.clearSavedSearchFilter();
        this.menuBar.noteRestoreAction.setVisible(false);
        if (!this.rensoNoteListDock.isEnabled()) {
            this.rensoNoteListDock.setEnabled(true);
        }
        List selections = this.tagTree.selectedItems();
        this.selectedTagGUIDs.clear();
        int i = 0;
        while (i < selections.size()) {
            QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(i);
            this.selectedTagGUIDs.add(currentSelection.text(2));
            ++i;
        }
        if (selections.size() > 0) {
            this.menuBar.tagEditAction.setEnabled(true);
            this.menuBar.tagDeleteAction.setEnabled(true);
            this.menuBar.tagIconAction.setEnabled(true);
        } else {
            this.menuBar.tagEditAction.setEnabled(false);
            this.menuBar.tagDeleteAction.setEnabled(false);
            this.menuBar.tagIconAction.setEnabled(true);
        }
        if (selections.size() > 1) {
            this.menuBar.tagMergeAction.setEnabled(true);
        } else {
            this.menuBar.tagMergeAction.setEnabled(false);
        }
        this.listManager.setSelectedTags(this.selectedTagGUIDs);
        this.listManager.loadNotesIndex();
        this.noteIndexUpdated(false);
        this.refreshEvernoteNote(true);
        this.listManager.refreshCounters = true;
        this.listManager.refreshCounters();
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.tagTreeSelection");
    }

    private void tagIndexUpdated() {
        this.tagIndexUpdated(true);
    }

    private void tagIndexUpdated(boolean reload) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.tagIndexUpdated");
        if (this.selectedTagGUIDs == null) {
            this.selectedTagGUIDs = new ArrayList<String>();
        }
        if (reload) {
            this.listManager.reloadTagIndex();
        }
        this.tagTree.blockSignals(true);
        if (reload) {
            this.tagTree.setIcons(this.conn.getTagTable().getAllIcons());
            this.tagTree.load(this.listManager.getTagIndex());
        }
        int i = this.selectedTagGUIDs.size() - 1;
        while (i >= 0) {
            boolean found = this.tagTree.selectGuid(this.selectedTagGUIDs.get(i));
            if (!found) {
                this.selectedTagGUIDs.remove(i);
            }
            --i;
        }
        this.tagTree.blockSignals(false);
        this.browserWindow.setTag(this.getTagNamesForNote(this.currentNote));
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.tagIndexUpdated");
    }

    private void toggleTagWindow() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.toggleTagWindow");
        if (this.tagTree.isVisible()) {
            this.tagTree.hide();
        } else {
            this.tagTree.show();
        }
        this.menuBar.hideTags.setChecked(this.tagTree.isVisible());
        Global.saveWindowVisible("tagTree", this.tagTree.isVisible());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.toggleTagWindow");
    }

    private void updateNoteTags(String guid, List<String> tags) {
        ArrayList<String> newTags = new ArrayList<String>();
        int i = 0;
        while (i < tags.size()) {
            if (this.conn.getTagTable().findTagByName(tags.get(i)) == null) {
                newTags.add(tags.get(i));
            }
            ++i;
        }
        this.listManager.saveNoteTags(guid, tags, true);
        this.listManager.countTagResults(this.listManager.getNoteIndex());
        StringBuffer names = new StringBuffer("");
        int i2 = 0;
        while (i2 < tags.size()) {
            names = names.append(tags.get(i2));
            if (i2 < tags.size() - 1) {
                names.append(String.valueOf(Global.tagDelimeter) + " ");
            }
            ++i2;
        }
        this.browserWindow.setTag(names.toString());
        for (TabBrowse tab : this.tabWindows.values()) {
            if (!tab.getBrowserWindow().getNote().getGuid().equals(guid)) continue;
            int index = this.tabBrowser.indexOf(tab);
            this.noteDirty.put(index, true);
            break;
        }
        i = 0;
        while (i < newTags.size()) {
            this.tagTree.insertTag((String)newTags.get(i), this.conn.getTagTable().findTagByName((String)newTags.get(i)));
            ++i;
        }
    }

    private String getTagNamesForNote(Note n) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.getTagNamesForNote");
        if (n == null || n.getGuid() == null || n.getGuid().equals("")) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(100);
        Vector<String> v = new Vector<String>();
        List guids = n.getTagGuids();
        if (guids == null) {
            return "";
        }
        int i = 0;
        while (i < guids.size()) {
            v.add(this.listManager.getTagNameByGuid((String)guids.get(i)));
            ++i;
        }
        Comparator comparator = Collections.reverseOrder();
        Collections.sort(v, comparator);
        Collections.reverse(v);
        int i2 = 0;
        while (i2 < v.size()) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            buffer.append((String)v.get(i2));
            ++i2;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.getTagNamesForNote");
        return buffer.toString();
    }

    private void tagsAdded(String noteGuid, String tagGuid) {
        String tagName = null;
        int i = 0;
        while (i < this.listManager.getTagIndex().size()) {
            if (this.listManager.getTagIndex().get(i).getGuid().equals(tagGuid)) {
                tagName = this.listManager.getTagIndex().get(i).getName();
                i = this.listManager.getTagIndex().size();
            }
            ++i;
        }
        if (tagName == null) {
            return;
        }
        i = 0;
        while (i < this.listManager.getMasterNoteIndex().size()) {
            if (this.listManager.getMasterNoteIndex().get(i).getGuid().equals(noteGuid)) {
                ArrayList<String> tagNames = new ArrayList<String>();
                tagNames.add(new String(tagName));
                Note n = this.listManager.getMasterNoteIndex().get(i);
                int j = 0;
                while (j < n.getTagNames().size()) {
                    tagNames.add(new String((String)n.getTagNames().get(j)));
                    ++j;
                }
                this.listManager.getNoteTableModel().updateNoteTags(noteGuid, n.getTagGuids(), tagNames);
                if (n.getGuid().equals(this.currentNoteGuid)) {
                    Collections.sort(tagNames);
                    String display = "";
                    int j2 = 0;
                    while (j2 < tagNames.size()) {
                        display = String.valueOf(display) + (String)tagNames.get(j2);
                        if (j2 + 2 < tagNames.size()) {
                            display = String.valueOf(display) + Global.tagDelimeter + " ";
                        }
                        ++j2;
                    }
                    this.browserWindow.setTag(display);
                }
                i = this.listManager.getMasterNoteIndex().size();
            }
            ++i;
        }
        this.listManager.getNoteTableModel().updateNoteSyncStatus(noteGuid, false);
    }

    private void clearTagFilter() {
        this.tagTree.blockSignals(true);
        this.tagTree.clearSelection();
        this.menuBar.noteRestoreAction.setVisible(false);
        this.menuBar.tagEditAction.setEnabled(false);
        this.menuBar.tagMergeAction.setEnabled(false);
        this.menuBar.tagDeleteAction.setEnabled(false);
        this.menuBar.tagIconAction.setEnabled(false);
        this.selectedTagGUIDs.clear();
        this.listManager.setSelectedTags(this.selectedTagGUIDs);
        this.tagTree.blockSignals(false);
    }

    private void setTagIcon() {
        SetIcon dialog;
        List selections = this.tagTree.selectedItems();
        if (selections.size() == 0) {
            return;
        }
        QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(0);
        String guid = currentSelection.text(2);
        QIcon currentIcon = currentSelection.icon(0);
        QIcon icon = this.conn.getTagTable().getIcon(guid);
        if (icon == null) {
            dialog = new SetIcon(currentIcon, this.saveLastPath);
            dialog.setUseDefaultIcon(true);
        } else {
            dialog = new SetIcon(icon, this.saveLastPath);
            dialog.setUseDefaultIcon(false);
        }
        dialog.exec();
        if (dialog.okPressed()) {
            this.saveLastPath = dialog.getPath();
            QIcon newIcon = dialog.getIcon();
            this.conn.getTagTable().setIcon(guid, newIcon, dialog.getFileType());
            if (newIcon == null) {
                newIcon = new QIcon(String.valueOf(this.iconPath) + "tag.png");
            }
            currentSelection.setIcon(0, newIcon);
        }
    }

    private void mergeTags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        List selections = this.tagTree.selectedItems();
        int i = 0;
        while (i < selections.size()) {
            Tag record = new Tag();
            record.setGuid(((QTreeWidgetItem)selections.get(i)).text(2));
            record.setName(((QTreeWidgetItem)selections.get(i)).text(0));
            tags.add(record);
            ++i;
        }
        TagMerge mergeDialog = new TagMerge(tags);
        mergeDialog.exec();
        if (!mergeDialog.okClicked()) {
            return;
        }
        String newGuid = mergeDialog.getNewTagGuid();
        int i2 = 0;
        while (i2 < tags.size()) {
            if (!((Tag)tags.get(i2)).getGuid().equals(newGuid)) {
                List<String> noteGuids = this.conn.getNoteTable().noteTagsTable.getTagNotes(((Tag)tags.get(i2)).getGuid());
                int j = 0;
                while (j < noteGuids.size()) {
                    String noteGuid = noteGuids.get(j);
                    this.conn.getNoteTable().noteTagsTable.deleteNoteTag(noteGuid);
                    if (!this.conn.getNoteTable().noteTagsTable.checkNoteNoteTags(noteGuid, newGuid)) {
                        this.conn.getNoteTable().noteTagsTable.saveNoteTag(noteGuid, newGuid, true);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        this.listManager.reloadIndexes();
    }

    private void addSavedSearch() {
        this.logger.log(this.logger.HIGH, "Inside NeverNote.addSavedSearch");
        SavedSearchEdit edit = new SavedSearchEdit();
        edit.setSearchList(this.listManager.getSavedSearchIndex());
        edit.exec();
        if (!edit.okPressed()) {
            return;
        }
        GregorianCalendar currentTime = new GregorianCalendar();
        Long l = new Long(currentTime.getTimeInMillis());
        String randint = new String(Long.toString(l));
        SavedSearch search = new SavedSearch();
        search.setUpdateSequenceNum(0);
        search.setGuid(randint);
        search.setName(edit.getName());
        search.setQuery(edit.getQuery());
        search.setFormat(QueryFormat.USER);
        this.listManager.getSavedSearchIndex().add(search);
        this.conn.getSavedSearchTable().addSavedSearch(search, true);
        this.savedSearchIndexUpdated();
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.addSavedSearch");
    }

    private void editSavedSearch() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.editSavedSearch");
        SavedSearchEdit edit = new SavedSearchEdit();
        edit.setTitle(this.tr("Edit Search"));
        List selections = this.savedSearchTree.selectedItems();
        QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(0);
        String guid = currentSelection.text(1);
        SavedSearch s = this.conn.getSavedSearchTable().getSavedSearch(guid);
        edit.setName(currentSelection.text(0));
        edit.setQuery(s.getQuery());
        edit.setSearchList(this.listManager.getSavedSearchIndex());
        edit.exec();
        if (!edit.okPressed()) {
            return;
        }
        List<SavedSearch> list = this.listManager.getSavedSearchIndex();
        SavedSearch search = null;
        boolean found = false;
        int i = 0;
        while (i < list.size()) {
            search = list.get(i);
            if (search.getGuid().equals(guid)) {
                i = list.size();
                found = true;
            }
            ++i;
        }
        if (!found) {
            return;
        }
        search.setName(edit.getName());
        search.setQuery(edit.getQuery());
        this.conn.getSavedSearchTable().updateSavedSearch(search, true);
        this.savedSearchIndexUpdated();
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.editSavedSearch");
    }

    private void deleteSavedSearch() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.deleteSavedSearch");
        if (QMessageBox.question((QWidget)this, (String)this.tr("Confirmation"), (String)this.tr("Delete the selected search?"), (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.No.value()) {
            return;
        }
        List selections = this.savedSearchTree.selectedItems();
        int i = selections.size() - 1;
        while (i >= 0) {
            QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(i);
            int j = 0;
            while (j < this.listManager.getSavedSearchIndex().size()) {
                if (this.listManager.getSavedSearchIndex().get(j).getGuid().equals(currentSelection.text(1))) {
                    this.conn.getSavedSearchTable().expungeSavedSearch(this.listManager.getSavedSearchIndex().get(j).getGuid(), true);
                    this.listManager.getSavedSearchIndex().remove(j);
                    j = this.listManager.getSavedSearchIndex().size() + 1;
                }
                ++j;
            }
            selections.remove(i);
            --i;
        }
        this.savedSearchIndexUpdated();
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.deleteSavedSearch");
    }

    private void initializeSavedSearchTree() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.initializeSavedSearchTree");
        this.savedSearchTree.itemSelectionChanged.connect((Object)this, "savedSearchTreeSelection()");
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.initializeSavedSearchTree");
    }

    private void savedSearchTreeSelection() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.savedSearchTreeSelection");
        this.clearNotebookFilter();
        this.clearTagFilter();
        this.clearTrashFilter();
        this.clearAttributeFilter();
        String currentGuid = this.selectedSavedSearchGUID;
        this.menuBar.savedSearchEditAction.setEnabled(true);
        this.menuBar.savedSearchDeleteAction.setEnabled(true);
        this.menuBar.savedSearchIconAction.setEnabled(true);
        if (!this.rensoNoteListDock.isEnabled()) {
            this.rensoNoteListDock.setEnabled(true);
        }
        List selections = this.savedSearchTree.selectedItems();
        this.selectedSavedSearchGUID = "";
        int i = 0;
        while (i < selections.size()) {
            QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(i);
            if (currentSelection.text(1).equals(currentGuid)) {
                currentSelection.setSelected(false);
            } else {
                this.selectedSavedSearchGUID = currentSelection.text(1);
            }
            ++i;
        }
        if (selections.size() == 0) {
            this.clearSavedSearchFilter();
        }
        this.listManager.setSelectedSavedSearch(this.selectedSavedSearchGUID);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.savedSearchTreeSelection");
    }

    private void clearSavedSearchFilter() {
        this.menuBar.savedSearchEditAction.setEnabled(false);
        this.menuBar.savedSearchDeleteAction.setEnabled(false);
        this.menuBar.savedSearchIconAction.setEnabled(false);
        this.savedSearchTree.blockSignals(true);
        this.savedSearchTree.clearSelection();
        this.savedSearchTree.blockSignals(false);
        this.selectedSavedSearchGUID = "";
        this.searchField.setEditText("");
        this.searchPerformed = false;
        this.listManager.setSelectedSavedSearch(this.selectedSavedSearchGUID);
    }

    private void savedSearchIndexUpdated() {
        if (this.selectedSavedSearchGUID == null) {
            this.selectedSavedSearchGUID = new String();
        }
        this.savedSearchTree.blockSignals(true);
        this.savedSearchTree.setIcons(this.conn.getSavedSearchTable().getAllIcons());
        this.savedSearchTree.load(this.listManager.getSavedSearchIndex());
        this.savedSearchTree.selectGuid(this.selectedSavedSearchGUID);
        this.savedSearchTree.blockSignals(false);
    }

    private void updateSavedSearchSelection() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateSavedSearchSelection()");
        this.menuBar.savedSearchEditAction.setEnabled(true);
        this.menuBar.savedSearchDeleteAction.setEnabled(true);
        this.menuBar.savedSearchIconAction.setEnabled(true);
        List selections = this.savedSearchTree.selectedItems();
        if (selections.size() > 0) {
            this.menuBar.savedSearchEditAction.setEnabled(true);
            this.menuBar.savedSearchDeleteAction.setEnabled(true);
            this.menuBar.savedSearchIconAction.setEnabled(true);
            this.selectedSavedSearchGUID = ((QTreeWidgetItem)selections.get(0)).text(1);
            SavedSearch s = this.conn.getSavedSearchTable().getSavedSearch(this.selectedSavedSearchGUID);
            this.searchField.setEditText(s.getQuery());
        } else {
            this.menuBar.savedSearchEditAction.setEnabled(false);
            this.menuBar.savedSearchDeleteAction.setEnabled(false);
            this.menuBar.savedSearchIconAction.setEnabled(false);
            this.selectedSavedSearchGUID = "";
            this.searchField.setEditText("");
        }
        this.searchFieldChanged();
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateSavedSearchSelection()");
    }

    private void toggleSavedSearchWindow() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.toggleSavedSearchWindow");
        if (this.savedSearchTree.isVisible()) {
            this.savedSearchTree.hide();
        } else {
            this.savedSearchTree.show();
        }
        this.menuBar.hideSavedSearches.setChecked(this.savedSearchTree.isVisible());
        Global.saveWindowVisible("savedSearchTree", this.savedSearchTree.isVisible());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.toggleSavedSearchWindow");
    }

    private void setSavedSearchIcon() {
        SetIcon dialog;
        List selections = this.savedSearchTree.selectedItems();
        if (selections.size() == 0) {
            return;
        }
        QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(0);
        String guid = currentSelection.text(1);
        QIcon currentIcon = currentSelection.icon(0);
        QIcon icon = this.conn.getSavedSearchTable().getIcon(guid);
        if (icon == null) {
            dialog = new SetIcon(currentIcon, this.saveLastPath);
            dialog.setUseDefaultIcon(true);
        } else {
            dialog = new SetIcon(icon, this.saveLastPath);
            dialog.setUseDefaultIcon(false);
        }
        dialog.exec();
        if (dialog.okPressed()) {
            this.saveLastPath = dialog.getPath();
            QIcon newIcon = dialog.getIcon();
            this.conn.getSavedSearchTable().setIcon(guid, newIcon, dialog.getFileType());
            if (newIcon == null) {
                newIcon = new QIcon(String.valueOf(this.iconPath) + "search.png");
            }
            currentSelection.setIcon(0, newIcon);
        }
    }

    private void databaseStatus() {
        this.waitCursor(true);
        this.indexRunner.interrupt = true;
        int dirty = this.conn.getNoteTable().getDirtyCount();
        int unindexed = this.conn.getNoteTable().getUnindexedCount();
        DatabaseStatus status = new DatabaseStatus();
        status.setUnsynchronized(dirty);
        status.setUnindexed(unindexed);
        status.setNoteCount(this.conn.getNoteTable().getNoteCount());
        status.setNotebookCount(this.listManager.getNotebookIndex().size());
        status.setUnindexedResourceCount(this.conn.getNoteTable().noteResourceTable.getUnindexedCount());
        status.setSavedSearchCount(this.listManager.getSavedSearchIndex().size());
        status.setTagCount(this.listManager.getTagIndex().size());
        status.setResourceCount(this.conn.getNoteTable().noteResourceTable.getResourceCount());
        status.setWordCount(this.conn.getWordsTable().getWordCount());
        status.setHistoryCount(this.conn.getHistoryTable().getHistoryCount());
        status.setRensoClickCount(this.conn.getHistoryTable().getRensoClickCount());
        this.waitCursor(false);
        status.exec();
    }

    private void compactDatabase() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.compactDatabase");
        if (QMessageBox.question((QWidget)this, (String)this.tr("Confirmation"), (String)this.tr("This will free unused space in the database, but please be aware that depending upon the size of your database this can be time consuming and NeighborNote will be unresponsive until it is complete.  Do you wish to continue?"), (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.No.value() && Global.verifyDelete()) {
            return;
        }
        this.setMessage("Compacting database.");
        this.waitCursor(true);
        this.listManager.compactDatabase();
        this.waitCursor(false);
        this.setMessage("Database compact is complete.");
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.compactDatabase");
    }

    private void accountInformation() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.accountInformation");
        AccountDialog dialog = new AccountDialog();
        dialog.show();
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.accountInformation");
    }

    private void releaseNotes() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.releaseNotes");
        QDialog dialog = new QDialog((QWidget)this);
        QHBoxLayout layout = new QHBoxLayout();
        QTextEdit textBox = new QTextEdit();
        layout.addWidget((QWidget)textBox);
        textBox.setReadOnly(true);
        QFile file = new QFile(Global.getFileManager().getProgramDirPath("release.txt"));
        if (!file.open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly, QIODevice.OpenModeFlag.Text}))) {
            return;
        }
        QTextCodec codec = QTextCodec.codecForName((String)"UTF-8");
        QTextStream textStream = new QTextStream((QIODevice)file);
        textStream.setCodec(codec);
        textBox.setText(textStream.readAll().toString());
        file.close();
        dialog.setWindowTitle(this.tr("Release Notes"));
        dialog.setLayout((QLayout)layout);
        dialog.show();
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.releaseNotes");
    }

    private void logger() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.logger");
        LogFileDialog dialog = new LogFileDialog(this.emitLog);
        dialog.exec();
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.logger");
    }

    private void about() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.about");
        QMessageBox.about((QWidget)this, (String)this.tr("About NeighborNote"), (String)(String.valueOf(this.tr("<h4><center><b>NeighborNote</b></center></h4><hr><center>Version ")) + Global.version + "(based on NixNote 1.5)" + this.tr("<hr>Open Source Evernote Client.<br><br>Licensed under GPL v2.  <br><hr><br></center>Evernote is copyright 2001-2012 by Evernote Corporation<br>Jambi and QT are the licensed trademark of Nokia Corporation<br>PDFRenderer is licened under the LGPL<br>JTidy is copyrighted under the World Wide Web Consortium<br>Apache Common Utilities licensed under the Apache License Version 2.0<br>Jazzy is licened under the LGPL<br>Java is a registered trademark of Oracle Corporation.<br><hr>Special thanks to:<br>BitRock InstallBuilder for the Windows installer<br>CodeCogs (www.codecogs.com) for the LaTeX image rendering.")));
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.about");
    }

    private void toggleLeftSide() {
        boolean hidden = !this.menuBar.hideLeftSide.isChecked();
        this.menuBar.hideLeftSide.setChecked(!hidden);
        if (!hidden) {
            this.leftSplitter1.setHidden(true);
        } else {
            this.leftSplitter1.setHidden(false);
        }
        Global.saveWindowVisible("leftPanel", hidden);
    }

    public void checkForUpdates() {
        this.versionChecker = new QNetworkAccessManager((QObject)this);
        this.versionChecker.finished.connect((Object)this, "upgradeFileRead(QNetworkReply)");
        QNetworkRequest request = new QNetworkRequest();
        request.setUrl(new QUrl(Global.getUpdatesAvailableUrl()));
        this.versionChecker.get(request);
    }

    private void upgradeFileRead(QNetworkReply reply) {
        if (!reply.isReadable()) {
            return;
        }
        String winVersion = Global.version;
        String osxVersion = Global.version;
        String linuxVersion = Global.version;
        String linux64Version = Global.version;
        String version = Global.version;
        QByteArray data = reply.readLine();
        while (data != null && !reply.atEnd()) {
            String line = data.toString();
            String lineVersion = line.contains(":") ? line.substring(line.indexOf(":") + 1).replace(" ", "").replace("\n", "") : "";
            if (line.toLowerCase().contains("windows")) {
                winVersion = lineVersion;
            } else if (line.toLowerCase().contains("os-x")) {
                osxVersion = lineVersion;
            } else if (line.toLowerCase().contains("linux amd64")) {
                linux64Version = lineVersion;
            } else if (line.toLowerCase().contains("linux i386")) {
                linuxVersion = lineVersion;
            } else if (line.toLowerCase().contains("default")) {
                version = lineVersion;
            }
            data = reply.readLine();
        }
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            version = winVersion;
        }
        if (System.getProperty("os.name").toLowerCase().contains("mac os")) {
            version = osxVersion;
        }
        if (System.getProperty("os.name").toLowerCase().contains("Linux")) {
            version = System.getProperty("os.arch").contains("amd64") || System.getProperty("os.arch").contains("x86_64") ? linux64Version : linuxVersion;
        }
        String[] stringArray = Global.validVersions;
        int n = Global.validVersions.length;
        int n2 = 0;
        while (n2 < n) {
            String validVersion = stringArray[n2];
            if (version.equals(validVersion)) {
                return;
            }
            ++n2;
        }
        UpgradeAvailableDialog dialog = new UpgradeAvailableDialog();
        dialog.exec();
        if (dialog.remindMe()) {
            Global.setCheckVersionUpgrade(true);
        } else {
            Global.setCheckVersionUpgrade(false);
        }
    }

    private void focusSearch() {
        this.searchField.setFocus();
    }

    private void searchFieldCleared() {
        this.saveNote();
        this.readOnlyCache.clear();
        this.inkNoteCache.clear();
        this.noteCache.clear();
        QWebSettings.setMaximumPagesInCache((int)0);
        QWebSettings.setObjectCacheCapacities((int)0, (int)0, (int)0);
        this.searchField.setEditText("");
        this.saveNoteColumnPositions();
        this.saveNoteIndexWidth();
        this.noteIndexUpdated(true);
        if (this.currentNote == null && this.listManager.getNoteIndex().size() > 0) {
            this.currentNote = this.listManager.getNoteIndex().get(0);
            this.currentNoteGuid = this.currentNote.getGuid();
        }
        this.refreshEvernoteNote(true);
        if (this.currentNote != null) {
            this.loadNoteBrowserInformation(this.browserWindow, this.currentNoteGuid, this.currentNote);
        }
    }

    private void searchFieldTextChanged(String text) {
        QWebSettings.setMaximumPagesInCache((int)0);
        QWebSettings.setObjectCacheCapacities((int)0, (int)0, (int)0);
        if (text.trim().equals("")) {
            this.searchFieldCleared();
            if (this.searchPerformed) {
                this.noteCache.clear();
                this.readOnlyCache.clear();
                this.inkNoteCache.clear();
                this.listManager.setEnSearch("");
                this.listManager.loadNotesIndex();
                this.refreshEvernoteNote(true);
                this.noteIndexUpdated(false);
                this.refreshEvernoteNote(true);
            }
            this.searchPerformed = false;
        }
    }

    private void searchFieldChanged() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.searchFieldChanged");
        this.noteCache.clear();
        this.readOnlyCache.clear();
        this.inkNoteCache.clear();
        this.saveNoteColumnPositions();
        this.saveNoteIndexWidth();
        String text = this.searchField.currentText();
        this.listManager.setEnSearch(text.trim());
        this.listManager.loadNotesIndex();
        this.noteIndexUpdated(false);
        this.refreshEvernoteNote(true);
        this.searchPerformed = true;
        this.waitCursor(false);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.searchFieldChanged");
    }

    private void setupToolBar() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.setupToolBar");
        this.toolBar = this.addToolBar(this.tr("Tool Bar"));
        this.toolBar.setObjectName("toolBar");
        this.menuBar.setupToolBarVisible();
        if (!Global.isWindowVisible("toolBar")) {
            this.toolBar.setVisible(false);
        } else {
            this.toolBar.setVisible(true);
        }
        this.prevButton = this.toolBar.addAction(this.tr("Previous"));
        QIcon prevIcon = new QIcon(String.valueOf(this.iconPath) + "back.png");
        this.prevButton.setIcon(prevIcon);
        this.prevButton.triggered.connect((Object)this, "previousViewedAction()");
        this.togglePrevArrowButton(Global.isToolbarButtonVisible("prevArrow"));
        this.nextButton = this.toolBar.addAction(this.tr("Next"));
        QIcon nextIcon = new QIcon(String.valueOf(this.iconPath) + "forward.png");
        this.nextButton.setIcon(nextIcon);
        this.nextButton.triggered.connect((Object)this, "nextViewedAction()");
        this.toggleNextArrowButton(Global.isToolbarButtonVisible("nextArrow"));
        this.upButton = this.toolBar.addAction(this.tr("Up"));
        QIcon upIcon = new QIcon(String.valueOf(this.iconPath) + "up.png");
        this.upButton.setIcon(upIcon);
        this.upButton.triggered.connect((Object)this, "upAction()");
        this.toggleUpArrowButton(Global.isToolbarButtonVisible("upArrow"));
        this.downButton = this.toolBar.addAction(this.tr("Down"));
        QIcon downIcon = new QIcon(String.valueOf(this.iconPath) + "down.png");
        this.downButton.setIcon(downIcon);
        this.downButton.triggered.connect((Object)this, "downAction()");
        this.toggleDownArrowButton(Global.isToolbarButtonVisible("downArrow"));
        this.synchronizeButton = this.toolBar.addAction(this.tr("Synchronize"));
        this.synchronizeButton.setIcon(new QIcon(String.valueOf(this.iconPath) + "synchronize.png"));
        this.synchronizeIconAngle = 0;
        this.synchronizeButton.triggered.connect((Object)this, "evernoteSync()");
        this.toggleSynchronizeButton(Global.isToolbarButtonVisible("synchronize"));
        this.printButton = this.toolBar.addAction(this.tr("Print"));
        QIcon printIcon = new QIcon(String.valueOf(this.iconPath) + "print.png");
        this.printButton.setIcon(printIcon);
        this.printButton.triggered.connect((Object)this, "printNote()");
        this.togglePrintButton(Global.isToolbarButtonVisible("print"));
        this.tagButton = this.toolBar.addAction(this.tr("Tag"));
        QIcon tagIcon = new QIcon(String.valueOf(this.iconPath) + "tag.png");
        this.tagButton.setIcon(tagIcon);
        this.tagButton.triggered.connect((Object)this.browserWindow, "modifyTags()");
        this.toggleTagButton(Global.isToolbarButtonVisible("tag"));
        this.attributeButton = this.toolBar.addAction(this.tr("Attributes"));
        QIcon attributeIcon = new QIcon(String.valueOf(this.iconPath) + "attribute.png");
        this.attributeButton.setIcon(attributeIcon);
        this.attributeButton.triggered.connect((Object)this, "toggleNoteAttributes()");
        this.toggleAttributeButton(Global.isToolbarButtonVisible("attribute"));
        this.emailButton = this.toolBar.addAction(this.tr("Email"));
        QIcon emailIcon = new QIcon(String.valueOf(this.iconPath) + "email.png");
        this.emailButton.setIcon(emailIcon);
        this.emailButton.triggered.connect((Object)this, "emailNote()");
        this.toggleEmailButton(Global.isToolbarButtonVisible("email"));
        this.deleteButton = this.toolBar.addAction(this.tr("Delete"));
        QIcon deleteIcon = new QIcon(String.valueOf(this.iconPath) + "delete.png");
        this.deleteButton.setIcon(deleteIcon);
        this.deleteButton.triggered.connect((Object)this, "deleteNote()");
        this.toggleDeleteButton(Global.isToolbarButtonVisible("delete"));
        this.newButton = this.toolBar.addAction(this.tr("New"));
        QIcon newIcon = new QIcon(String.valueOf(this.iconPath) + "new.png");
        this.newButton.triggered.connect((Object)this, "addNote()");
        this.newButton.setIcon(newIcon);
        this.toggleNewButton(Global.isToolbarButtonVisible("new"));
        this.allNotesButton = this.toolBar.addAction(this.tr("All Notes"));
        QIcon allIcon = new QIcon(String.valueOf(this.iconPath) + "books.png");
        this.allNotesButton.triggered.connect((Object)this, "allNotes()");
        this.allNotesButton.setIcon(allIcon);
        this.toggleAllNotesButton(Global.isToolbarButtonVisible("allNotes"));
        this.updateQuotaBar();
        QSizePolicy sizePolicy = new QSizePolicy();
        sizePolicy.setHorizontalPolicy(QSizePolicy.Policy.MinimumExpanding);
        QLabel spacer = new QLabel("");
        spacer.setSizePolicy(sizePolicy);
        this.toolBar.addWidget((QWidget)spacer);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.setupToolBar");
    }

    public QMenu createPopupMenu() {
        QMenu contextMenu = super.createPopupMenu();
        contextMenu.addSeparator();
        QAction prevAction = this.addContextAction("prevArrow", this.tr("Previous Arrow"));
        contextMenu.addAction(prevAction);
        prevAction.triggered.connect((Object)this, "togglePrevArrowButton(Boolean)");
        QAction nextAction = this.addContextAction("nextArrow", this.tr("Next Arrow"));
        contextMenu.addAction(nextAction);
        nextAction.triggered.connect((Object)this, "toggleNextArrowButton(Boolean)");
        QAction upAction = this.addContextAction("upArrow", this.tr("Up Arrow"));
        contextMenu.addAction(upAction);
        upAction.triggered.connect((Object)this, "toggleUpArrowButton(Boolean)");
        QAction downAction = this.addContextAction("downArrow", this.tr("Down Arrow"));
        contextMenu.addAction(downAction);
        downAction.triggered.connect((Object)this, "toggleDownArrowButton(Boolean)");
        QAction synchronizeAction = this.addContextAction("synchronize", this.tr("Synchronize"));
        contextMenu.addAction(synchronizeAction);
        synchronizeAction.triggered.connect((Object)this, "toggleSynchronizeButton(Boolean)");
        QAction printAction = this.addContextAction("print", this.tr("Print"));
        contextMenu.addAction(printAction);
        printAction.triggered.connect((Object)this, "togglePrintButton(Boolean)");
        QAction tagAction = this.addContextAction("tag", this.tr("Tag"));
        contextMenu.addAction(tagAction);
        tagAction.triggered.connect((Object)this, "toggleTagButton(Boolean)");
        QAction attributeAction = this.addContextAction("attribute", this.tr("Attribute"));
        contextMenu.addAction(attributeAction);
        attributeAction.triggered.connect((Object)this, "toggleAttributeButton(Boolean)");
        QAction emailAction = this.addContextAction("email", this.tr("Email"));
        contextMenu.addAction(emailAction);
        emailAction.triggered.connect((Object)this, "toggleEmailButton(Boolean)");
        QAction deleteAction = this.addContextAction("delete", this.tr("Delete"));
        contextMenu.addAction(deleteAction);
        deleteAction.triggered.connect((Object)this, "toggleDeleteButton(Boolean)");
        QAction newAction = this.addContextAction("new", this.tr("Add"));
        contextMenu.addAction(newAction);
        newAction.triggered.connect((Object)this, "toggleNewButton(Boolean)");
        QAction allNotesAction = this.addContextAction("allNotes", this.tr("All Notes"));
        contextMenu.addAction(allNotesAction);
        allNotesAction.triggered.connect((Object)this, "toggleAllNotesButton(Boolean)");
        QAction searchClearAction = this.addContextAction("searchClear", this.tr("Search Clear"));
        contextMenu.addAction(searchClearAction);
        searchClearAction.triggered.connect((Object)this, "toggleSearchClearButton(Boolean)");
        return contextMenu;
    }

    private QAction addContextAction(String config, String name) {
        QAction newAction = new QAction((QObject)this);
        newAction.setText(name);
        newAction.setCheckable(true);
        newAction.setChecked(Global.isToolbarButtonVisible(config));
        return newAction;
    }

    private void togglePrevArrowButton(Boolean toggle) {
        this.prevButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("prevArrow", toggle);
    }

    private void toggleNextArrowButton(Boolean toggle) {
        this.nextButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("nextArrow", toggle);
    }

    private void toggleUpArrowButton(Boolean toggle) {
        this.upButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("upArrow", toggle);
    }

    private void toggleDownArrowButton(Boolean toggle) {
        this.downButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("downArrow", toggle);
    }

    private void toggleSynchronizeButton(Boolean toggle) {
        this.synchronizeButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("synchronize", toggle);
    }

    private void togglePrintButton(Boolean toggle) {
        this.printButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("print", toggle);
    }

    private void toggleTagButton(Boolean toggle) {
        this.tagButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("tag", toggle);
    }

    private void toggleAttributeButton(Boolean toggle) {
        this.attributeButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("attribute", toggle);
    }

    private void toggleEmailButton(Boolean toggle) {
        this.emailButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("email", toggle);
    }

    private void toggleDeleteButton(Boolean toggle) {
        this.deleteButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("delete", toggle);
    }

    private void toggleNewButton(Boolean toggle) {
        this.newButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("new", toggle);
    }

    private void toggleAllNotesButton(Boolean toggle) {
        this.allNotesButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("allNotes", toggle);
    }

    private void toggleSearchClearButton(Boolean toggle) {
        this.searchClearButton.setVisible(toggle.booleanValue());
        Global.saveToolbarButtonsVisible("searchClear", toggle);
    }

    private void updateSyncButton() {
        if (this.syncIcons == null) {
            this.syncIcons = new ArrayList<QPixmap>();
            double angle = 0.0;
            this.synchronizeIconAngle = 0;
            QPixmap pix = new QPixmap(String.valueOf(this.iconPath) + "synchronize.png");
            this.syncIcons.add(pix);
            int i = 0;
            while (i <= 360) {
                QPixmap rotatedPix = new QPixmap(pix.size());
                QPainter p = new QPainter((QPaintDeviceInterface)rotatedPix);
                rotatedPix.fill(this.toolBar.palette().color(QPalette.ColorRole.Button));
                QSize size = pix.size();
                p.translate((double)(size.width() / 2), (double)(size.height() / 2));
                p.rotate(angle += 1.0);
                p.setBackgroundMode(Qt.BGMode.OpaqueMode);
                p.translate((double)(-size.width() / 2), (double)(-size.height() / 2));
                p.drawPixmap(0, 0, pix);
                p.end();
                this.syncIcons.add(rotatedPix);
                ++i;
            }
        }
        ++this.synchronizeIconAngle;
        if (this.synchronizeIconAngle > 359) {
            this.synchronizeIconAngle = 0;
        }
        this.synchronizeButton.setIcon(this.syncIcons.get(this.synchronizeIconAngle));
    }

    private void evernoteSync() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.evernoteSync");
        if (!Global.isConnected) {
            this.remoteConnect();
        }
        if (Global.isConnected) {
            this.synchronizeAnimationTimer.start(5);
        }
        this.syncTimer();
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.evernoteSync");
    }

    private void updateQuotaBar() {
        long limit = Global.getUploadLimit();
        long amount = Global.getUploadAmount();
        if (amount > 0L && limit > 0L) {
            int percent = (int)(amount * 100L / limit);
            this.quotaBar.setValue(percent);
        } else {
            this.quotaBar.setValue(0);
        }
    }

    private void zoomChanged() {
        this.browserWindow.getBrowser().setZoomFactor(new Double(this.zoomSpinner.value()) / 100.0);
    }

    private void trayToggleVisible() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
            if (this.windowMaximized) {
                this.showMaximized();
            } else {
                this.showNormal();
            }
            this.raise();
        }
    }

    private void trayActivated(QSystemTrayIcon.ActivationReason reason) {
        if (reason == QSystemTrayIcon.ActivationReason.DoubleClick) {
            String name = QSystemTrayIcon.MessageIcon.resolve((int)reason.value()).name();
            this.trayToggleVisible();
        }
    }

    private void trashTreeSelection() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.trashTreeSelection");
        this.clearNotebookFilter();
        this.clearTagFilter();
        this.clearAttributeFilter();
        this.clearSavedSearchFilter();
        String tempGuid = this.currentNoteGuid;
        this.currentNote = new Note();
        this.selectedNoteGUIDs.clear();
        this.listManager.getSelectedNotebooks().clear();
        this.listManager.getSelectedTags().clear();
        this.listManager.setSelectedSavedSearch("");
        this.browserWindow.clear();
        this.newButton.setEnabled(!this.newButton.isEnabled());
        this.menuBar.noteAdd.setEnabled(this.newButton.isEnabled());
        this.menuBar.noteAdd.setVisible(true);
        List selections = this.trashTree.selectedItems();
        if (selections.size() == 0) {
            this.currentNoteGuid = this.trashNoteGuid;
            this.trashNoteGuid = tempGuid;
            Global.showDeleted = false;
            this.menuBar.noteRestoreAction.setEnabled(false);
            this.menuBar.noteRestoreAction.setVisible(false);
            this.rensoNoteListDock.setEnabled(true);
        } else {
            this.currentNoteGuid = this.trashNoteGuid = tempGuid;
            this.menuBar.noteRestoreAction.setEnabled(true);
            this.menuBar.noteRestoreAction.setVisible(true);
            this.rensoNoteListDock.setEnabled(false);
            Global.showDeleted = true;
        }
        this.menuBar.noteAddNewTab.setEnabled(this.newButton.isEnabled());
        if (this.currentNoteGuid == null || this.currentNoteGuid.equals("")) {
            this.menuBar.noteAddNewTab.setEnabled(false);
        }
        this.listManager.loadNotesIndex();
        this.noteIndexUpdated(false);
        this.browserWindow.setReadOnly(!this.newButton.isEnabled());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.trashTreeSelection");
    }

    private void emptyTrash() {
        this.logger.log(this.logger.EXTREME, "Emptying Trash");
        this.listManager.emptyTrash();
        this.logger.log(this.logger.EXTREME, "Resetting view after trash empty");
        if (this.trashTree.selectedItems().size() > 0) {
            this.listManager.getSelectedNotebooks().clear();
            this.listManager.getSelectedTags().clear();
            this.listManager.setSelectedSavedSearch("");
            this.newButton.setEnabled(!this.newButton.isEnabled());
            this.menuBar.noteAdd.setEnabled(this.newButton.isEnabled());
            this.menuBar.noteAddNewTab.setEnabled(this.newButton.isEnabled());
            if (this.currentNoteGuid == null || this.currentNoteGuid.equals("")) {
                this.menuBar.noteAddNewTab.setEnabled(false);
            }
            this.menuBar.noteAdd.setVisible(true);
            this.browserWindow.clear();
            this.clearTagFilter();
            this.clearNotebookFilter();
            this.clearSavedSearchFilter();
            this.clearAttributeFilter();
            Global.showDeleted = false;
            this.menuBar.noteRestoreAction.setEnabled(false);
            this.menuBar.noteRestoreAction.setVisible(false);
            this.listManager.loadNotesIndex();
            this.noteIndexUpdated(false);
            if (!this.rensoNoteListDock.isEnabled()) {
                this.rensoNoteListDock.setEnabled(true);
            }
        }
    }

    private void toggleTrashWindow() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.toggleTrashWindow");
        if (this.trashTree.isVisible()) {
            this.trashTree.hide();
        } else {
            this.trashTree.show();
        }
        this.menuBar.hideTrash.setChecked(this.trashTree.isVisible());
        Global.saveWindowVisible("trashTree", this.trashTree.isVisible());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.trashWindow");
    }

    private void clearTrashFilter() {
        Global.showDeleted = false;
        this.newButton.setEnabled(true);
        this.menuBar.noteAdd.setEnabled(true);
        if (this.currentNoteGuid == null || this.currentNoteGuid.equals("")) {
            this.menuBar.noteAddNewTab.setEnabled(false);
        } else {
            this.menuBar.noteAddNewTab.setEnabled(true);
        }
        this.menuBar.noteAdd.setVisible(true);
        this.trashTree.blockSignals(true);
        this.trashTree.clearSelection();
        this.trashTree.blockSignals(false);
    }

    private void remoteErrorDisconnect() {
        this.menuBar.connectAction.setText(this.tr("Connect"));
        this.menuBar.connectAction.setToolTip(this.tr("Connect to Evernote"));
        this.menuBar.synchronizeAction.setEnabled(false);
        Global.isConnected = false;
        this.synchronizeAnimationTimer.stop();
    }

    private void remoteConnect() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.remoteConnect");
        if (Global.isConnected) {
            Global.isConnected = false;
            this.syncRunner.enDisconnect();
            this.setupConnectMenuOptions();
            this.setupOnlineMenu();
            return;
        }
        OAuthTokenizer tokenizer = new OAuthTokenizer();
        AESEncrypter aes = new AESEncrypter();
        try {
            aes.decrypt(new FileInputStream(Global.getFileManager().getHomeDirFile("oauth.txt")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (Global.getProxyValue("url").equals("")) {
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
            System.setProperty("https.proxyHost", "");
            System.setProperty("https.proxyPort", "");
        } else {
            System.setProperty("http.proxyHost", Global.getProxyValue("url"));
            System.setProperty("http.proxyPort", Global.getProxyValue("port"));
            System.setProperty("https.proxyHost", Global.getProxyValue("url"));
            System.setProperty("https.proxyPort", Global.getProxyValue("port"));
            if (Global.getProxyValue("userid").equals("")) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(Global.getProxyValue("userid"), Global.getProxyValue("password").toCharArray());
                    }
                });
            }
        }
        this.syncRunner.userStoreUrl = Global.userStoreUrl;
        this.syncRunner.noteStoreUrl = Global.noteStoreUrl;
        this.syncRunner.noteStoreUrlBase = Global.noteStoreUrlBase;
        String authString = aes.getString();
        if (!authString.equals("")) {
            tokenizer.tokenize(authString);
            this.syncRunner.authToken = tokenizer.oauth_token;
            this.syncRunner.enConnect();
        }
        Global.isConnected = this.syncRunner.isConnected;
        boolean autoLoginMessageFlag = false;
        if (!Global.isConnected) {
            OAuthWindow window = new OAuthWindow(this.logger);
            if (window.error) {
                this.setMessage(window.errorMessage);
                return;
            }
            window.exec();
            if (window.error) {
                this.setMessage(window.errorMessage);
                return;
            }
            tokenizer.tokenize(window.response);
            if (tokenizer.oauth_token.equals("")) {
                this.setMessage(this.tr("Invalid authorization token received."));
                return;
            }
            aes.setString(window.response);
            try {
                aes.encrypt(new FileOutputStream(Global.getFileManager().getHomeDirFile("oauth.txt")));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.syncRunner.authToken = tokenizer.oauth_token;
            this.syncRunner.enConnect();
            Global.isConnected = this.syncRunner.isConnected;
            autoLoginMessageFlag = true;
        }
        if (!Global.isConnected) {
            return;
        }
        this.setupOnlineMenu();
        this.setupConnectMenuOptions();
        if (autoLoginMessageFlag && !Global.automaticLogin() && QMessageBox.question((QWidget)this, (String)this.tr("Confirmation"), (String)this.tr("Are you sure you want to enable the auto-login feature?"), (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.Yes.value()) {
            Global.setAutomaticLogin(true);
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.remoteConnect");
    }

    private void setupConnectMenuOptions() {
        this.logger.log(this.logger.HIGH, "entering NeverNote.setupConnectMenuOptions");
        if (!Global.isConnected) {
            this.menuBar.connectAction.setText(this.tr("Connect"));
            this.menuBar.connectAction.setToolTip(this.tr("Connect to Evernote"));
            this.menuBar.synchronizeAction.setEnabled(false);
        } else {
            this.menuBar.connectAction.setText(this.tr("Disconnect"));
            this.menuBar.connectAction.setToolTip(this.tr("Disconnect from Evernote"));
            this.menuBar.synchronizeAction.setEnabled(true);
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.setupConnectionMenuOptions");
    }

    private void attributeTreeClicked(QTreeWidgetItem item, Integer integer) {
        this.clearTrashFilter();
        if (!this.rensoNoteListDock.isEnabled()) {
            this.rensoNoteListDock.setEnabled(true);
        }
        if (this.attributeTreeSelected == null || item.nativeId() != this.attributeTreeSelected.nativeId()) {
            if (item.childCount() > 0) {
                item.setSelected(false);
            } else {
                Global.createdBeforeFilter.reset();
                Global.createdSinceFilter.reset();
                Global.changedBeforeFilter.reset();
                Global.changedSinceFilter.reset();
                Global.containsFilter.reset();
                this.attributeTreeSelected = item;
                DateAttributeFilterTable f = null;
                f = this.findDateAttributeFilterTable(item.parent());
                if (f != null) {
                    f.select(item.parent().indexOfChild(item));
                } else {
                    Global.containsFilter.select(item.parent().indexOfChild(item));
                }
            }
            this.listManager.loadNotesIndex();
            this.noteIndexUpdated(false);
            return;
        }
        this.attributeTreeSelected = null;
        item.setSelected(false);
        Global.createdBeforeFilter.reset();
        Global.createdSinceFilter.reset();
        Global.changedBeforeFilter.reset();
        Global.changedSinceFilter.reset();
        Global.containsFilter.reset();
        this.listManager.loadNotesIndex();
        this.noteIndexUpdated(false);
    }

    private DateAttributeFilterTable findDateAttributeFilterTable(QTreeWidgetItem w) {
        if (w.parent() != null && w.childCount() > 0) {
            QTreeWidgetItem parent = w.parent();
            if (parent.data(0, 32) == AttributeTreeWidget.Attributes.Created && w.data(0, 32) == AttributeTreeWidget.Attributes.Since) {
                return Global.createdSinceFilter;
            }
            if (parent.data(0, 32) == AttributeTreeWidget.Attributes.Created && w.data(0, 32) == AttributeTreeWidget.Attributes.Before) {
                return Global.createdBeforeFilter;
            }
            if (parent.data(0, 32) == AttributeTreeWidget.Attributes.LastModified && w.data(0, 32) == AttributeTreeWidget.Attributes.Since) {
                return Global.changedSinceFilter;
            }
            if (parent.data(0, 32) == AttributeTreeWidget.Attributes.LastModified && w.data(0, 32) == AttributeTreeWidget.Attributes.Before) {
                return Global.changedBeforeFilter;
            }
        }
        return null;
    }

    private void toggleAttributesWindow() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.toggleAttributesWindow");
        if (this.attributeTree.isVisible()) {
            this.attributeTree.hide();
        } else {
            this.attributeTree.show();
        }
        this.menuBar.hideAttributes.setChecked(this.attributeTree.isVisible());
        Global.saveWindowVisible("attributeTree", this.attributeTree.isVisible());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.toggleAttributeWindow");
    }

    private void clearAttributeFilter() {
        Global.createdBeforeFilter.reset();
        Global.createdSinceFilter.reset();
        Global.changedBeforeFilter.reset();
        Global.changedSinceFilter.reset();
        Global.containsFilter.reset();
        this.attributeTreeSelected = null;
        this.attributeTree.blockSignals(true);
        this.attributeTree.clearSelection();
        this.attributeTree.blockSignals(false);
    }

    private void initializeNoteTable() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.initializeNoteTable");
        this.noteTableView.setSelectionMode(QAbstractItemView.SelectionMode.ExtendedSelection);
        this.noteTableView.selectionModel().selectionChanged.connect((Object)this, "noteTableSelection()");
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.initializeNoteTable");
    }

    private void toggleNoteListWindow() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.toggleNoteListWindow");
        if (this.noteTableView.isVisible()) {
            this.noteTableView.hide();
        } else {
            this.noteTableView.show();
        }
        this.menuBar.hideNoteList.setChecked(this.noteTableView.isVisible());
        Global.saveWindowVisible("noteList", this.noteTableView.isVisible());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.toggleNoteListWindow");
    }

    private void noteTableSelection() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.noteTableSelection");
        this.saveNote();
        if (QApplication.mouseButtons().isSet((QtEnumerator[])new Qt.MouseButton[]{Qt.MouseButton.RightButton})) {
            List selections = this.noteTableView.selectionModel().selectedRows();
            if (selections.size() > 0) {
                this.selectedNoteGUIDs.clear();
                int i = 0;
                while (i < selections.size()) {
                    int row = ((QModelIndex)selections.get(i)).row();
                    QModelIndex index = this.noteTableView.proxyModel.index(row, Global.noteTableGuidPosition);
                    SortedMap ix = this.noteTableView.proxyModel.itemData(index);
                    this.selectedNoteGUIDs.add((String)ix.values().toArray()[0]);
                    ++i;
                }
            }
            return;
        }
        List selections = this.noteTableView.selectionModel().selectedRows();
        if (selections.size() > 1) {
            this.menuBar.noteMergeAction.setEnabled(true);
        } else {
            this.menuBar.noteMergeAction.setEnabled(false);
        }
        if ((QApplication.keyboardModifiers().isSet((QtEnumerator[])new Qt.KeyboardModifier[]{Qt.KeyboardModifier.ControlModifier}) || QApplication.keyboardModifiers().isSet((QtEnumerator[])new Qt.KeyboardModifier[]{Qt.KeyboardModifier.ShiftModifier})) && QApplication.mouseButtons().isSet((QtEnumerator[])new Qt.MouseButton[]{Qt.MouseButton.LeftButton})) {
            this.selectedNoteGUIDs.clear();
            int i = 0;
            while (i < selections.size()) {
                int row = ((QModelIndex)selections.get(i)).row();
                QModelIndex index = this.noteTableView.proxyModel.index(row, Global.noteTableGuidPosition);
                SortedMap ix = this.noteTableView.proxyModel.itemData(index);
                this.selectedNoteGUIDs.add((String)ix.values().toArray()[0]);
                ++i;
            }
            return;
        }
        this.noteTableView.showColumn(Global.noteTableGuidPosition);
        if (!Global.isColumnVisible("guid")) {
            this.noteTableView.hideColumn(Global.noteTableGuidPosition);
        }
        if (selections.size() > 0) {
            this.menuBar.noteDuplicateAction.setEnabled(true);
            this.menuBar.noteOnlineHistoryAction.setEnabled(true);
            this.menuBar.noteMergeAction.setEnabled(true);
            this.selectedNoteGUIDs.clear();
            if (this.currentNoteGuid != null && !this.currentNoteGuid.equals("") && !Global.showDeleted) {
                this.menuBar.noteAddNewTab.setEnabled(true);
            }
            if (selections.size() != 1 || Global.showDeleted) {
                this.menuBar.noteDuplicateAction.setEnabled(false);
            }
            if (selections.size() != 1 || !Global.isConnected) {
                this.menuBar.noteOnlineHistoryAction.setEnabled(false);
            }
            if (selections.size() == 1) {
                this.menuBar.noteMergeAction.setEnabled(false);
            }
            int i = 0;
            while (i < selections.size()) {
                int row = ((QModelIndex)selections.get(i)).row();
                if (row == 0) {
                    this.upButton.setEnabled(false);
                } else {
                    this.upButton.setEnabled(true);
                }
                if (row < this.listManager.getNoteTableModel().rowCount() - 1) {
                    this.downButton.setEnabled(true);
                } else {
                    this.downButton.setEnabled(false);
                }
                QModelIndex index = this.noteTableView.proxyModel.index(row, Global.noteTableGuidPosition);
                SortedMap ix = this.noteTableView.proxyModel.itemData(index);
                this.currentNoteGuid = (String)ix.values().toArray()[0];
                this.selectedNoteGUIDs.add(this.currentNoteGuid);
                ++i;
            }
        }
        this.nextButton.setEnabled(true);
        this.prevButton.setEnabled(true);
        int currentIndex = this.tabBrowser.currentIndex();
        ArrayList<String> histGuids = this.historyGuids.get(currentIndex);
        int histPosition = this.historyPosition.get(currentIndex);
        boolean fromHist = this.fromHistory.get(currentIndex);
        if (!fromHist) {
            int endPosition = histGuids.size() - 1;
            int j = histPosition;
            while (j <= endPosition) {
                histGuids.remove(histGuids.size() - 1);
                ++j;
            }
            histGuids.add(this.currentNoteGuid);
            this.historyPosition.put(currentIndex, histGuids.size());
            histPosition = histGuids.size();
        }
        if (histPosition <= 1) {
            this.prevButton.setEnabled(false);
        }
        if (histPosition == histGuids.size()) {
            this.nextButton.setEnabled(false);
        }
        this.fromHistory.put(currentIndex, false);
        fromHist = false;
        this.scrollToGuid(this.currentNoteGuid);
        this.refreshEvernoteNote(true);
        if (this.currentNoteGuid != null && !this.currentNoteGuid.equals("") && !Global.showDeleted) {
            this.addBrowseHistory();
        }
        this.rensoNoteListDock.getRensoNoteList().refreshRensoNoteList(this.currentNoteGuid);
        this.waitCursor(false);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.noteTableSelection");
    }

    private void addBrowseHistory() {
        if (this.tabWindows.size() >= 2) {
            Iterator<Object> it = this.tabWindows.keySet().iterator();
            while (it.hasNext()) {
                int tabIndex = it.next();
                String nextGuid = ((TabBrowse)this.tabBrowser.widget(tabIndex)).getBrowserWindow().getNote().getGuid();
                if (this.currentNoteGuid.equals(nextGuid)) continue;
                this.conn.getHistoryTable().addHistory("browse", this.currentNoteGuid, nextGuid);
            }
        }
        if (this.externalWindows.size() >= 1) {
            for (String nextGuid : this.externalWindows.keySet()) {
                if (this.currentNoteGuid.equals(nextGuid)) continue;
                this.conn.getHistoryTable().addHistory("browse", this.currentNoteGuid, nextGuid);
            }
        }
    }

    private void noteIndexUpdated(boolean reload) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.noteIndexUpdated");
        this.saveNote();
        this.refreshEvernoteNoteList();
        this.logger.log(this.logger.HIGH, "Calling note table reload in NeverNote.noteIndexUpdated() - " + reload);
        this.noteTableView.load(reload);
        if (this.currentNoteGuid == null || this.currentNoteGuid.equals("")) {
            QModelIndex i;
            int pos = this.noteTableView.proxyModel.sortOrder() == Qt.SortOrder.AscendingOrder ? this.noteTableView.proxyModel.rowCount() : 1;
            if (this.noteTableView.proxyModel.rowCount() == 0) {
                pos = 0;
            }
            if (pos > 0 && (i = this.noteTableView.proxyModel.index(pos - 1, Global.noteTableGuidPosition)) != null) {
                this.currentNoteGuid = (String)i.data();
            }
        }
        if (!this.noteTableView.isColumnHidden(Global.noteTableGuidPosition)) {
            this.showColumns();
        }
        this.scrollToGuid(this.currentNoteGuid);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.noteIndexUpdated");
    }

    private void refreshEvernoteNoteList() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.refreshEvernoteNoteList");
        this.browserWindow.setDisabled(false);
        if (this.selectedNoteGUIDs == null) {
            this.selectedNoteGUIDs = new ArrayList<String>();
        }
        this.selectedNoteGUIDs.clear();
        String saveCurrentNoteGuid = new String();
        String tempNoteGuid = new String();
        int currentIndex = this.tabBrowser.currentIndex();
        ArrayList<String> histGuids = this.historyGuids.get(currentIndex);
        histGuids.clear();
        this.historyPosition.put(currentIndex, 0);
        this.prevButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        if (this.currentNoteGuid == null) {
            this.currentNoteGuid = new String();
        }
        for (Note note : this.listManager.getNoteIndex()) {
            tempNoteGuid = note.getGuid();
            if (!this.currentNoteGuid.equals(tempNoteGuid)) continue;
            saveCurrentNoteGuid = tempNoteGuid;
        }
        if (this.listManager.getNoteIndex().size() == 0) {
            this.currentNoteGuid = "";
            this.currentNote = null;
            this.browserWindow.clear();
            this.browserWindow.setDisabled(true);
            this.waitCursor(false);
        }
        if (Global.showDeleted && this.listManager.getNoteIndex().size() > 0 && saveCurrentNoteGuid.equals("")) {
            saveCurrentNoteGuid = this.currentNoteGuid = this.listManager.getNoteIndex().get(0).getGuid();
            this.refreshEvernoteNote(true);
        }
        if (!saveCurrentNoteGuid.equals("")) {
            this.refreshEvernoteNote(false);
        } else {
            this.currentNoteGuid = "";
        }
        this.reloadTagTree(false);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.refreshEvernoteNoteList");
    }

    private void previousViewedAction() {
        int currentIndex = this.tabBrowser.currentIndex();
        ArrayList<String> histGuids = this.historyGuids.get(currentIndex);
        int histPosition = this.historyPosition.get(currentIndex);
        boolean fromHist = this.fromHistory.get(currentIndex);
        if (!this.prevButton.isEnabled()) {
            return;
        }
        if (histPosition == 0) {
            return;
        }
        this.historyPosition.put(currentIndex, --histPosition);
        if (histPosition <= 0) {
            return;
        }
        String historyGuid = histGuids.get(histPosition - 1);
        this.fromHistory.put(currentIndex, true);
        fromHist = true;
        int i = 0;
        while (i < this.noteTableView.model().rowCount()) {
            SortedMap ix;
            String tableGuid;
            QModelIndex modelIndex = this.noteTableView.model().index(i, Global.noteTableGuidPosition);
            if (modelIndex != null && (tableGuid = (String)(ix = this.noteTableView.model().itemData(modelIndex)).values().toArray()[0]).equals(historyGuid)) {
                this.noteTableView.selectRow(i);
                return;
            }
            ++i;
        }
    }

    private void nextViewedAction() {
        if (!this.nextButton.isEnabled()) {
            return;
        }
        int currentIndex = this.tabBrowser.currentIndex();
        ArrayList<String> histGuids = this.historyGuids.get(currentIndex);
        int histPosition = this.historyPosition.get(currentIndex);
        boolean fromHist = this.fromHistory.get(currentIndex);
        String historyGuid = histGuids.get(histPosition);
        this.historyPosition.put(currentIndex, ++histPosition);
        this.fromHistory.put(currentIndex, true);
        fromHist = true;
        int i = 0;
        while (i < this.noteTableView.model().rowCount()) {
            SortedMap ix;
            String tableGuid;
            QModelIndex modelIndex = this.noteTableView.model().index(i, Global.noteTableGuidPosition);
            if (modelIndex != null && (tableGuid = (String)(ix = this.noteTableView.model().itemData(modelIndex)).values().toArray()[0]).equals(historyGuid)) {
                this.noteTableView.selectRow(i);
                return;
            }
            ++i;
        }
    }

    private void upAction() {
        List selections = this.noteTableView.selectionModel().selectedRows();
        int row = ((QModelIndex)selections.get(0)).row();
        if (row > 0) {
            this.noteTableView.selectRow(row - 1);
        }
    }

    private void downAction() {
        int max;
        List selections = this.noteTableView.selectionModel().selectedRows();
        int row = ((QModelIndex)selections.get(0)).row();
        if (row < (max = this.listManager.getNoteTableModel().rowCount()) - 1) {
            this.noteTableView.selectRow(row + 1);
        }
    }

    private void updateListTags(String guid, List<String> tags) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateListTags");
        StringBuffer tagBuffer = new StringBuffer();
        int i = 0;
        while (i < tags.size()) {
            tagBuffer.append(tags.get(i));
            if (i < tags.size() - 1) {
                tagBuffer.append(", ");
            }
            ++i;
        }
        i = 0;
        while (i < this.listManager.getNoteTableModel().rowCount()) {
            SortedMap ix;
            String tableGuid;
            QModelIndex modelIndex = this.listManager.getNoteTableModel().index(i, Global.noteTableGuidPosition);
            if (modelIndex != null && (tableGuid = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equals(guid)) {
                this.listManager.getNoteTableModel().setData(i, Global.noteTableTagPosition, tagBuffer.toString());
                this.listManager.getNoteTableModel().setData(i, Global.noteTableSynchronizedPosition, "false");
                this.noteTableView.proxyModel.invalidate();
                return;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateListTags");
    }

    private void updateListAuthor(String guid, String author) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateListAuthor");
        int i = 0;
        while (i < this.listManager.getNoteTableModel().rowCount()) {
            SortedMap ix;
            String tableGuid;
            QModelIndex modelIndex = this.listManager.getNoteTableModel().index(i, Global.noteTableGuidPosition);
            if (modelIndex != null && (tableGuid = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equals(guid)) {
                this.listManager.getNoteTableModel().setData(i, Global.noteTableAuthorPosition, author);
                this.listManager.getNoteTableModel().setData(i, Global.noteTableSynchronizedPosition, "false");
                this.noteTableView.proxyModel.invalidate();
                return;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateListAuthor");
    }

    private void updateListNoteNotebook(String guid, String notebook) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateListNoteNotebook");
        this.listManager.getNoteTableModel().updateNoteSyncStatus(guid, false);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateListNoteNotebook");
    }

    private void updateListSourceUrl(String guid, String url) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateListAuthor");
        int i = 0;
        while (i < this.listManager.getNoteTableModel().rowCount()) {
            SortedMap ix;
            String tableGuid;
            QModelIndex modelIndex = this.listManager.getNoteTableModel().index(i, Global.noteTableGuidPosition);
            if (modelIndex != null && (tableGuid = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equals(guid)) {
                this.listManager.getNoteTableModel().setData(i, Global.noteTableSynchronizedPosition, "false");
                this.listManager.getNoteTableModel().setData(i, Global.noteTableSourceUrlPosition, url);
                this.noteTableView.proxyModel.invalidate();
                return;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateListAuthor");
    }

    private void updateListGuid(String oldGuid, String newGuid) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateListTitle");
        int i = 0;
        while (i < this.listManager.getNoteTableModel().rowCount()) {
            SortedMap ix;
            String tableGuid;
            QModelIndex modelIndex = this.listManager.getNoteTableModel().index(i, Global.noteTableGuidPosition);
            if (modelIndex != null && (tableGuid = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equals(oldGuid)) {
                this.listManager.getNoteTableModel().setData(i, Global.noteTableGuidPosition, newGuid);
                return;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateListTitle");
    }

    private void updateListTagName(String guid) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateTagName");
        int j = 0;
        while (j < this.listManager.getNoteIndex().size()) {
            if (this.listManager.getNoteIndex().get(j).getTagGuids().contains(guid)) {
                String newName = this.listManager.getTagNamesForNote(this.listManager.getNoteIndex().get(j));
                int i = 0;
                while (i < this.listManager.getNoteTableModel().rowCount()) {
                    SortedMap ix;
                    String noteGuid;
                    QModelIndex modelIndex = this.listManager.getNoteTableModel().index(i, Global.noteTableGuidPosition);
                    if (modelIndex != null && (noteGuid = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equalsIgnoreCase(this.listManager.getNoteIndex().get(j).getGuid())) {
                        this.listManager.getNoteTableModel().setData(i, Global.noteTableTagPosition, newName);
                        i = this.listManager.getNoteTableModel().rowCount();
                    }
                    ++i;
                }
            }
            ++j;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateListNotebook");
    }

    private void removeListTagName(String guid) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateTagName");
        int j = 0;
        while (j < this.listManager.getNoteIndex().size()) {
            if (this.listManager.getNoteIndex().get(j).getTagGuids().contains(guid)) {
                int i = this.listManager.getNoteIndex().get(j).getTagGuids().size() - 1;
                while (i >= 0) {
                    if (((String)this.listManager.getNoteIndex().get(j).getTagGuids().get(i)).equals(guid)) {
                        this.listManager.getNoteIndex().get(j).getTagGuids().remove(i);
                    }
                    --i;
                }
                String newName = this.listManager.getTagNamesForNote(this.listManager.getNoteIndex().get(j));
                int i2 = 0;
                while (i2 < this.listManager.getNoteTableModel().rowCount()) {
                    SortedMap ix;
                    String noteGuid;
                    QModelIndex modelIndex = this.listManager.getNoteTableModel().index(i2, Global.noteTableGuidPosition);
                    if (modelIndex != null && (noteGuid = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equalsIgnoreCase(this.listManager.getNoteIndex().get(j).getGuid())) {
                        this.listManager.getNoteTableModel().setData(i2, Global.noteTableTagPosition, newName);
                        i2 = this.listManager.getNoteTableModel().rowCount();
                    }
                    ++i2;
                }
            }
            ++j;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateListNotebook");
    }

    private void updateListNotebookName(String oldName, String newName) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateListNotebookName");
        int i = 0;
        while (i < this.listManager.getNoteTableModel().rowCount()) {
            SortedMap ix;
            String tableName;
            QModelIndex modelIndex = this.listManager.getNoteTableModel().index(i, Global.noteTableNotebookPosition);
            if (modelIndex != null && (tableName = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equalsIgnoreCase(oldName)) {
                this.listManager.getNoteTableModel().setData(i, Global.noteTableNotebookPosition, newName);
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateListNotebookName");
    }

    private void updateListDateCreated(String guid, QDateTime date) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateListDateCreated");
        int i = 0;
        while (i < this.listManager.getNoteTableModel().rowCount()) {
            SortedMap ix;
            String tableGuid;
            QModelIndex modelIndex = this.listManager.getNoteTableModel().index(i, Global.noteTableGuidPosition);
            if (modelIndex != null && (tableGuid = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equals(guid)) {
                this.listManager.getNoteTableModel().setData(i, Global.noteTableCreationPosition, date.toString(String.valueOf(Global.getDateFormat()) + " " + Global.getTimeFormat()));
                this.noteTableView.proxyModel.invalidate();
                return;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateListDateCreated");
    }

    private void updateListDateSubject(String guid, QDateTime date) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateListDateSubject");
        int i = 0;
        while (i < this.listManager.getNoteTableModel().rowCount()) {
            SortedMap ix;
            String tableGuid;
            QModelIndex modelIndex = this.listManager.getNoteTableModel().index(i, Global.noteTableGuidPosition);
            if (modelIndex != null && (tableGuid = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equals(guid)) {
                this.listManager.getNoteTableModel().setData(i, Global.noteTableSynchronizedPosition, "false");
                this.listManager.getNoteTableModel().setData(i, Global.noteTableSubjectDatePosition, date.toString(String.valueOf(Global.getDateFormat()) + " " + Global.getTimeFormat()));
                this.noteTableView.proxyModel.invalidate();
                return;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateListDateCreated");
    }

    private void updateListDateChanged(String guid, QDateTime date) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateListDateChanged");
        int i = 0;
        while (i < this.listManager.getNoteTableModel().rowCount()) {
            SortedMap ix;
            String tableGuid;
            QModelIndex modelIndex = this.listManager.getNoteTableModel().index(i, Global.noteTableGuidPosition);
            if (modelIndex != null && (tableGuid = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equals(guid)) {
                this.listManager.getNoteTableModel().setData(i, Global.noteTableSynchronizedPosition, "false");
                this.listManager.getNoteTableModel().setData(i, Global.noteTableChangedPosition, date.toString(String.valueOf(Global.getDateFormat()) + " " + Global.getTimeFormat()));
                return;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateListDateChanged");
    }

    private void updateListDateChanged() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.updateListDateChanged");
        QDateTime date = new QDateTime(QDateTime.currentDateTime());
        this.updateListDateChanged(this.currentNoteGuid, date);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.updateListDateChanged");
    }

    private void scrollToCurrentGuid() {
        List selections = this.noteTableView.selectionModel().selectedRows();
        if (selections.size() == 0) {
            return;
        }
        QModelIndex index = (QModelIndex)selections.get(0);
        int row = ((QModelIndex)selections.get(0)).row();
        String guid = (String)index.model().index(row, Global.noteTableGuidPosition).data();
        this.scrollToGuid(guid);
    }

    private void scrollToGuid(String guid) {
        int i;
        if (this.currentNote == null || guid == null) {
            return;
        }
        if (this.currentNote.isActive() && Global.showDeleted) {
            i = 0;
            while (i < this.listManager.getNoteIndex().size()) {
                if (!this.listManager.getNoteIndex().get(i).isActive()) {
                    this.currentNote = this.listManager.getNoteIndex().get(i);
                    this.currentNoteGuid = this.currentNote.getGuid();
                    i = this.listManager.getNoteIndex().size();
                }
                ++i;
            }
        }
        if (!this.currentNote.isActive() && !Global.showDeleted) {
            i = 0;
            while (i < this.listManager.getNoteIndex().size()) {
                if (this.listManager.getNoteIndex().get(i).isActive()) {
                    this.currentNote = this.listManager.getNoteIndex().get(i);
                    this.currentNoteGuid = this.currentNote.getGuid();
                    i = this.listManager.getNoteIndex().size();
                }
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < this.noteTableView.model().rowCount()) {
            QModelIndex index = this.noteTableView.model().index(i2, Global.noteTableGuidPosition);
            if (this.currentNoteGuid.equals(index.data())) {
                this.noteTableView.selectRow(i2);
                this.noteTableView.scrollTo(index, QAbstractItemView.ScrollHint.EnsureVisible);
                i2 = this.listManager.getNoteTableModel().rowCount();
            }
            ++i2;
        }
        this.noteTableView.repaint();
    }

    private void showColumns() {
        this.noteTableView.setColumnHidden(Global.noteTableCreationPosition, !Global.isColumnVisible("dateCreated"));
        this.noteTableView.setColumnHidden(Global.noteTableChangedPosition, !Global.isColumnVisible("dateChanged"));
        this.noteTableView.setColumnHidden(Global.noteTableSubjectDatePosition, !Global.isColumnVisible("dateSubject"));
        this.noteTableView.setColumnHidden(Global.noteTableAuthorPosition, !Global.isColumnVisible("author"));
        this.noteTableView.setColumnHidden(Global.noteTableSourceUrlPosition, !Global.isColumnVisible("sourceUrl"));
        this.noteTableView.setColumnHidden(Global.noteTableTagPosition, !Global.isColumnVisible("tags"));
        this.noteTableView.setColumnHidden(Global.noteTableNotebookPosition, !Global.isColumnVisible("notebook"));
        this.noteTableView.setColumnHidden(Global.noteTableSynchronizedPosition, !Global.isColumnVisible("synchronized"));
        this.noteTableView.setColumnHidden(Global.noteTableGuidPosition, !Global.isColumnVisible("guid"));
        this.noteTableView.setColumnHidden(Global.noteTableThumbnailPosition, !Global.isColumnVisible("thumbnail"));
        this.noteTableView.setColumnHidden(Global.noteTableTitlePosition, !Global.isColumnVisible("title"));
        this.noteTableView.setColumnHidden(Global.noteTablePinnedPosition, !Global.isColumnVisible("pinned"));
    }

    private void titleColorChanged(Integer color) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.titleColorChanged");
        this.setNoteDirty();
        QColor backgroundColor = new QColor();
        QColor foregroundColor = new QColor(QColor.black);
        backgroundColor.setRgb(color.intValue());
        if (backgroundColor.rgb() == QColor.black.rgb() || backgroundColor.rgb() == QColor.blue.rgb()) {
            foregroundColor.setRgb(QColor.white.rgb());
        }
        if (this.selectedNoteGUIDs.size() == 0) {
            this.selectedNoteGUIDs.add(this.currentNoteGuid);
        }
        int j = 0;
        while (j < this.selectedNoteGUIDs.size()) {
            int i = 0;
            while (i < this.listManager.getNoteTableModel().rowCount()) {
                SortedMap ix;
                String tableGuid;
                QModelIndex modelIndex = this.listManager.getNoteTableModel().index(i, Global.noteTableGuidPosition);
                if (modelIndex != null && (tableGuid = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equals(this.selectedNoteGUIDs.get(j))) {
                    int k = 0;
                    while (k < Global.noteTableColumnCount) {
                        this.listManager.getNoteTableModel().setData(i, k, backgroundColor, 8);
                        this.listManager.getNoteTableModel().setData(i, k, foregroundColor, 9);
                        this.listManager.updateNoteTitleColor(this.selectedNoteGUIDs.get(j), backgroundColor.rgb());
                        ++k;
                    }
                    i = this.listManager.getNoteTableModel().rowCount();
                }
                ++i;
            }
            ++j;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.titleColorChanged");
    }

    private void notePinned() {
        this.logger.log(this.logger.EXTREME, "Entering NeverNote.notePinned()");
        this.setNoteDirty();
        int j = 0;
        while (j < this.selectedNoteGUIDs.size()) {
            NoteMetadata meta = this.listManager.getNoteMetadata().get(this.selectedNoteGUIDs.get(j));
            boolean pinned = !meta.isPinned();
            meta.setPinned(pinned);
            this.listManager.updateNoteMetadata(meta);
            this.noteTableView.proxyModel.addGuid(this.selectedNoteGUIDs.get(j), meta);
            ++j;
        }
        this.logger.log(this.logger.EXTREME, "Leaving NeverNote.notePinned()");
    }

    public void narrowListView() {
        this.saveNoteColumnPositions();
        this.saveNoteIndexWidth();
        this.saveWindowState();
        int sortCol = this.noteTableView.proxyModel.sortColumn();
        int sortOrder = this.noteTableView.proxyModel.sortOrder().value();
        Global.setSortColumn(sortCol);
        Global.setSortOrder(sortOrder);
        Global.setListView(Global.View_List_Narrow);
        this.menuBar.wideListView.blockSignals(true);
        this.menuBar.narrowListView.blockSignals(true);
        this.menuBar.wideListView.setChecked(false);
        this.menuBar.narrowListView.setChecked(true);
        this.menuBar.wideListView.blockSignals(false);
        this.menuBar.narrowListView.blockSignals(false);
        this.mainLeftRightSplitter.addWidget((QWidget)this.noteTableView);
        this.mainLeftRightSplitter.addWidget((QWidget)this.tabBrowser);
        this.restoreWindowState(false);
        this.noteTableView.repositionColumns();
        this.noteTableView.resizeColumnWidths();
        this.noteTableView.resizeRowHeights();
        sortCol = Global.getSortColumn();
        sortOrder = Global.getSortOrder();
        this.noteTableView.proxyModel.blocked = true;
        this.noteTableView.sortByColumn(sortCol, Qt.SortOrder.resolve((int)sortOrder));
        this.noteTableView.proxyModel.blocked = false;
        this.showColumns();
        this.noteTableView.load(false);
        this.refreshEvernoteNote(true);
        this.scrollToCurrentGuid();
    }

    public void wideListView() {
        int sortCol = this.noteTableView.proxyModel.sortColumn();
        int sortOrder = this.noteTableView.proxyModel.sortOrder().value();
        Global.setSortColumn(sortCol);
        Global.setSortOrder(sortOrder);
        this.saveWindowState();
        this.saveNoteColumnPositions();
        this.saveNoteIndexWidth();
        Global.setListView(Global.View_List_Wide);
        this.menuBar.wideListView.blockSignals(true);
        this.menuBar.narrowListView.blockSignals(true);
        this.menuBar.wideListView.setChecked(true);
        this.menuBar.narrowListView.setChecked(false);
        this.menuBar.wideListView.blockSignals(false);
        this.menuBar.narrowListView.blockSignals(false);
        this.browserIndexSplitter.setVisible(true);
        this.browserIndexSplitter.addWidget((QWidget)this.noteTableView);
        this.browserIndexSplitter.addWidget((QWidget)this.tabBrowser);
        this.restoreWindowState(false);
        this.noteTableView.repositionColumns();
        this.noteTableView.resizeColumnWidths();
        this.noteTableView.resizeRowHeights();
        sortCol = Global.getSortColumn();
        sortOrder = Global.getSortOrder();
        this.noteTableView.proxyModel.blocked = true;
        this.noteTableView.sortByColumn(sortCol, Qt.SortOrder.resolve((int)sortOrder));
        this.noteTableView.proxyModel.blocked = false;
        this.showColumns();
        this.noteTableView.load(false);
        this.scrollToCurrentGuid();
    }

    public void tableSortOrderChanged(Integer column, Integer order) {
        List selectedNotebook = this.notebookTree.selectedItems();
        if (selectedNotebook.size() > 0 && !((QTreeWidgetItem)selectedNotebook.get(0)).text(0).equalsIgnoreCase("All Notebooks") && !((QTreeWidgetItem)selectedNotebook.get(0)).text(2).equalsIgnoreCase("STACK")) {
            QTreeWidgetItem currentSelectedNotebook = (QTreeWidgetItem)selectedNotebook.get(0);
            String notebook = currentSelectedNotebook.text(2);
            this.conn.getNotebookTable().setSortOrder(notebook, column, order);
        }
    }

    private void evernoteLinkClick(String syncGuid, String locGuid) {
        String guid = null;
        guid = this.conn.getNoteTable().guidExists(syncGuid) ? syncGuid : (this.conn.getNoteTable().guidExists(locGuid) ? locGuid : this.conn.getNoteTable().findAlternateGuid(locGuid));
        if (guid != null) {
            this.openExternalEditor(guid);
            return;
        }
        QMessageBox.information((QWidget)this, (String)this.tr("Note Not Found"), (String)this.tr("Sorry, but I can't seem to find that note."));
    }

    private void listDoubleClick() {
        this.saveNote();
        this.openExternalEditor(this.currentNoteGuid);
    }

    private void openExternalEditor(String guid) {
        if (this.externalWindows.containsKey(guid)) {
            this.externalWindows.get(guid).raise();
            return;
        }
        Note note = this.conn.getNoteTable().getNote(guid, true, true, false, true, true);
        QIcon appIcon = new QIcon(String.valueOf(this.iconPath) + "nevernote.png");
        ExternalBrowse newBrowser = new ExternalBrowse(this.conn, this.cbObserver);
        newBrowser.setWindowIcon(appIcon);
        this.externalWindows.put(guid, newBrowser);
        this.showEditorButtons(newBrowser.getBrowserWindow());
        this.loadNoteBrowserInformation(newBrowser.getBrowserWindow(), guid, note);
        this.setupBrowserWindowListeners(newBrowser.getBrowserWindow(), false);
        newBrowser.windowClosing.connect((Object)this, "externalWindowClosing(String)");
        newBrowser.getBrowserWindow().noteSignal.tagsChanged.connect((Object)this, "externalWindowTagsEdited(String, List)");
        newBrowser.contentsChanged.connect((Object)this, "saveNoteExternalBrowser(String, String, Boolean, BrowserWindow)");
        newBrowser.getBrowserWindow().blockApplication.connect((Object)this, "blockApplication(BrowserWindow)");
        newBrowser.getBrowserWindow().unblockApplication.connect((Object)this, "unblockApplication()");
        this.browserWindow.noteSignal.tagsChanged.connect((Object)newBrowser, "updateTags(String, List)");
        this.browserWindow.noteSignal.titleChanged.connect((Object)newBrowser, "updateTitle(String, String)");
        this.browserWindow.noteSignal.notebookChanged.connect((Object)newBrowser, "updateNotebook(String, String)");
        newBrowser.show();
    }

    private void externalWindowTagsEdited(String guid, List values) {
        StringBuffer line = new StringBuffer(100);
        int i = 0;
        while (i < values.size()) {
            if (i > 0) {
                line.append(String.valueOf(Global.tagDelimeter) + " ");
            }
            line.append(values.get(i));
            ++i;
        }
        if (guid.equals(this.currentNoteGuid)) {
            this.browserWindow.setTag(line.toString());
        }
    }

    private void externalWindowClosing(String guid) {
        this.externalWindows.remove(guid);
    }

    private void openNewTab() {
        this.saveNote();
        ArrayList<String> copySelected = new ArrayList<String>(this.selectedNoteGUIDs);
        int i = 0;
        while (i < copySelected.size()) {
            this.openTabEditor((String)copySelected.get(i));
            ++i;
        }
    }

    private void openNewTabFromRNL() {
        if (this.rensoNotePressedItemGuid != null) {
            String prevCurrentNoteGuid = new String(this.currentNoteGuid);
            this.saveNote();
            this.openTabEditor(this.rensoNotePressedItemGuid);
            this.conn.getHistoryTable().addHistory("rensoItemClick", prevCurrentNoteGuid, this.rensoNotePressedItemGuid);
        }
    }

    private void openTabEditor(String guid) {
        Note note = this.conn.getNoteTable().getNote(guid, true, true, false, true, true);
        TabBrowse newBrowser = new TabBrowse(this.conn, this.tabBrowser, this.cbObserver);
        this.showEditorButtons(newBrowser.getBrowserWindow());
        String noteTitle = note.getTitle();
        int index = this.tabBrowser.addNewTab(newBrowser, noteTitle);
        this.tabWindows.put(index, newBrowser);
        this.noteDirty.put(index, false);
        this.noteTableView.selectionModel().selectionChanged.disconnect((Object)this, "noteTableSelection()");
        this.loadNoteBrowserInformation(newBrowser.getBrowserWindow(), guid, note);
        this.noteTableView.selectionModel().selectionChanged.connect((Object)this, "noteTableSelection()");
        this.setupBrowserWindowListeners(newBrowser.getBrowserWindow(), false);
        this.toggleNoteInformation();
        this.viewSource();
        this.toggleEditorButtonBar();
        ArrayList<String> histGuids = new ArrayList<String>();
        this.historyGuids.put(index, histGuids);
        this.historyPosition.put(index, 0);
        this.fromHistory.put(index, false);
        histGuids.add(guid);
        this.historyPosition.put(index, histGuids.size());
        this.tabBrowser.setCurrentIndex(index);
        if (guid != null && !guid.equals("") && !Global.showDeleted) {
            this.addBrowseHistory();
        }
    }

    private void tabWindowClosing(int index) {
        if (this.tabBrowser.count() <= 1) {
            return;
        }
        TabBrowse t = (TabBrowse)this.tabBrowser.widget(index);
        String guid = t.getBrowserWindow().getNote().getGuid();
        String content = t.getBrowserWindow().getContent();
        BrowserWindow browser = t.getBrowserWindow();
        if (t.getNoteDirty()) {
            this.saveNoteTabBrowser(guid, content, true, browser);
        }
        browser.noteSignal.tagsChanged.disconnect();
        browser.noteSignal.titleChanged.disconnect();
        browser.noteSignal.noteChanged.disconnect();
        browser.noteSignal.notebookChanged.disconnect();
        browser.noteSignal.createdDateChanged.disconnect();
        browser.noteSignal.alteredDateChanged.disconnect();
        this.tabWindows.remove(index);
        this.tabBrowser.removeTab(index);
        this.noteDirty.remove(index);
        this.inkNote.remove(index);
        this.readOnly.remove(index);
        this.historyGuids.remove(index);
        this.historyPosition.remove(index);
        this.fromHistory.remove(index);
        int i = index;
        while (this.tabWindows.containsKey(i + 1)) {
            TabBrowse tab = this.tabWindows.get(i + 1);
            this.tabWindows.put(i, tab);
            this.tabWindows.remove(i + 1);
            boolean isNoteDirty = this.noteDirty.get(i + 1);
            this.noteDirty.put(i, isNoteDirty);
            this.noteDirty.remove(i + 1);
            boolean isInkNote = this.inkNote.get(i + 1);
            this.inkNote.put(i, isInkNote);
            this.inkNote.remove(i + 1);
            boolean isReadOnly = this.readOnly.get(i + 1);
            this.readOnly.put(i, isReadOnly);
            this.readOnly.remove(i + 1);
            ArrayList<String> histGuids = this.historyGuids.get(i + 1);
            this.historyGuids.put(i, histGuids);
            this.historyGuids.remove(i + 1);
            int histPosition = this.historyPosition.get(i + 1);
            this.historyPosition.put(i, histPosition);
            this.historyPosition.remove(i + 1);
            boolean fromHist = this.fromHistory.get(i + 1);
            this.fromHistory.put(i, fromHist);
            this.fromHistory.remove(i + 1);
            ++i;
        }
        if (this.tabBrowser.count() == 1) {
            this.tabBrowser.hideTabCloseButton(0);
        }
        this.tabWindowChanged(this.tabBrowser.currentIndex());
    }

    private void noteAddNewTab() {
        TabBrowse addedTab;
        String addedTabGuid;
        this.saveNote();
        TabBrowse prevTab = (TabBrowse)this.tabBrowser.currentWidget();
        String prevTabGuid = null;
        if (prevTab.getBrowserWindow() != null && prevTab.getBrowserWindow().getNote() != null) {
            prevTabGuid = prevTab.getBrowserWindow().getNote().getGuid();
        }
        this.openEmptyTabEditor();
        this.addNote();
        if (!(prevTabGuid == null || prevTabGuid.equals("") || (addedTabGuid = (addedTab = (TabBrowse)this.tabBrowser.currentWidget()).getBrowserWindow().getNote().getGuid()) == null || addedTabGuid.equals("") || prevTabGuid.equals(addedTabGuid))) {
            this.conn.getHistoryTable().addHistory("addNewNote", prevTabGuid, addedTabGuid);
        }
    }

    private void openEmptyTabEditor() {
        TabBrowse newBrowser = new TabBrowse(this.conn, this.tabBrowser, this.cbObserver);
        this.showEditorButtons(newBrowser.getBrowserWindow());
        this.setupBrowserWindowListeners(newBrowser.getBrowserWindow(), false);
        int index = this.tabBrowser.addNewTab(newBrowser, "");
        this.tabWindows.put(index, newBrowser);
        this.noteDirty.put(index, false);
        this.toggleNoteInformation();
        this.viewSource();
        this.toggleEditorButtonBar();
        ArrayList histGuids = new ArrayList();
        this.historyGuids.put(index, histGuids);
        this.historyPosition.put(index, 0);
        this.fromHistory.put(index, false);
        this.tabBrowser.setCurrentIndex(index);
    }

    private void setNoteDirty() {
        for (String guid : this.selectedNoteGUIDs) {
            this.setNoteDirty(guid);
        }
    }

    private void setNoteDirty(String targetGuid) {
        this.logger.log(this.logger.EXTREME, "Entering NeverNote.setNoteDirty()");
        if (this.externalWindows.containsKey(targetGuid)) {
            QTextCodec codec = QTextCodec.codecForName((String)"UTF-8");
            QByteArray unicode = codec.fromUnicode(this.browserWindow.getContent());
            ExternalBrowse window = this.externalWindows.get(targetGuid);
            window.getBrowserWindow().setContent(unicode);
        }
        Set<Integer> tabIndexes = this.tabWindows.keySet();
        Iterator indexIterator = tabIndexes.iterator();
        for (TabBrowse tab : this.tabWindows.values()) {
            int index = (Integer)indexIterator.next();
            String guid = tab.getBrowserWindow().getNote().getGuid();
            QTextCodec codec = QTextCodec.codecForName((String)"UTF-8");
            QByteArray unicode = codec.fromUnicode(this.browserWindow.getContent());
            if (!guid.equals(guid) || index == this.tabBrowser.currentIndex()) continue;
            TabBrowse window = this.tabWindows.get(index);
            window.getBrowserWindow().setContent(unicode);
        }
        int index = -1;
        boolean isNoteDirty = false;
        for (TabBrowse tab : this.tabWindows.values()) {
            if (!tab.getBrowserWindow().getNote().getGuid().equals(targetGuid)) continue;
            index = this.tabBrowser.indexOf(tab);
            isNoteDirty = this.noteDirty.get(index);
            break;
        }
        if (isNoteDirty) {
            return;
        }
        if (index >= 0) {
            this.noteDirty.put(index, true);
        }
        if (this.listManager.getNoteMetadata().containsKey(targetGuid) && this.listManager.getNoteMetadata().get(targetGuid).isDirty()) {
            return;
        }
        this.listManager.getNoteTableModel().updateNoteSyncStatus(targetGuid, false);
        int i = 0;
        while (i < this.listManager.getNoteTableModel().rowCount()) {
            SortedMap ix;
            String tableGuid;
            QModelIndex modelIndex = this.listManager.getNoteTableModel().index(i, Global.noteTableGuidPosition);
            if (modelIndex != null && (tableGuid = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equals(targetGuid)) {
                this.listManager.getNoteTableModel().proxyModel.setData(i, Global.noteTableSynchronizedPosition, "false");
                return;
            }
            ++i;
        }
        this.logger.log(this.logger.EXTREME, "Leaving NeverNote.setNoteDirty()");
    }

    private void saveNoteExternalBrowser(String guid, String content, Boolean save, BrowserWindow browser) {
        QTextCodec codec = QTextCodec.codecForName((String)"UTF-8");
        QByteArray unicode = codec.fromUnicode(content);
        this.noteCache.remove(guid);
        this.noteCache.put(guid, unicode.toString());
        if (guid.equals(this.currentNoteGuid)) {
            int index = this.tabBrowser.currentIndex();
            this.noteDirty.put(index, true);
            this.browserWindow.setContent(unicode);
        }
        if (save.booleanValue()) {
            this.thumbnailRunner.addWork("GENERATE " + guid);
            this.saveNote(guid, browser);
        }
    }

    private void saveNoteTabBrowser(String guid, String content, Boolean save, BrowserWindow browser) {
        QTextCodec codec = QTextCodec.codecForName((String)"UTF-8");
        QByteArray unicode = codec.fromUnicode(content);
        this.noteCache.remove(guid);
        this.noteCache.put(guid, unicode.toString());
        if (save.booleanValue()) {
            this.thumbnailRunner.addWork("GENERATE " + guid);
            this.saveNote(guid, browser);
        }
    }

    private void saveNote() {
        Set<Integer> dirtyIndex = this.noteDirty.keySet();
        Iterator indexIterator = dirtyIndex.iterator();
        for (boolean isNoteDirty : this.noteDirty.values()) {
            int index = (Integer)indexIterator.next();
            if (!isNoteDirty) continue;
            if (index < 0) {
                return;
            }
            BrowserWindow b = this.tabWindows.get(index).getBrowserWindow();
            String guid = b.getNote().getGuid();
            this.saveNote(guid, b);
            this.thumbnailRunner.addWork("GENERATE " + guid);
            this.noteDirty.put(index, false);
        }
    }

    private void saveNote(String guid, BrowserWindow window) {
        this.logger.log(this.logger.EXTREME, "Inside NeverNote.saveNote()");
        this.waitCursor(true);
        this.logger.log(this.logger.EXTREME, "Saving to cache");
        QTextCodec codec = QTextCodec.codecForLocale();
        codec = QTextCodec.codecForName((String)"UTF-8");
        QByteArray unicode = codec.fromUnicode(window.getContent());
        this.noteCache.put(guid, unicode.toString());
        this.logger.log(this.logger.EXTREME, "updating list manager");
        this.listManager.updateNoteContent(guid, window.getContent());
        this.logger.log(this.logger.EXTREME, "Updating title");
        this.listManager.updateNoteTitle(guid, window.getTitle());
        this.updateListDateChanged();
        this.logger.log(this.logger.EXTREME, "Looking through note index for refreshed note");
        int i = 0;
        while (i < this.listManager.getNoteIndex().size()) {
            if (this.listManager.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.currentNote = this.listManager.getNoteIndex().get(i);
                i = this.listManager.getNoteIndex().size();
            }
            ++i;
        }
        this.waitCursor(false);
    }

    private void refreshEvernoteNote(boolean reload) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.refreshEvernoteNote");
        if (Global.disableViewing) {
            this.browserWindow.setEnabled(false);
            return;
        }
        this.inkNote.put(this.tabBrowser.currentIndex(), false);
        this.readOnly.put(this.tabBrowser.currentIndex(), false);
        if (Global.showDeleted || this.currentNoteGuid == null || this.currentNoteGuid.equals("")) {
            this.readOnly.put(this.tabBrowser.currentIndex(), true);
        }
        Global.cryptCounter = 0;
        if (this.readOnly.get(this.tabBrowser.currentIndex()).booleanValue()) {
            this.browserWindow.setReadOnly(true);
        }
        if (!reload) {
            return;
        }
        this.waitCursor(true);
        this.browserWindow.loadingData(true);
        this.currentNote = this.conn.getNoteTable().getNote(this.currentNoteGuid, true, true, false, false, true);
        if (this.currentNote == null) {
            this.waitCursor(false);
            return;
        }
        this.tabBrowser.setTabTitle(this.tabBrowser.currentIndex(), this.currentNote.getTitle());
        this.loadNoteBrowserInformation(this.browserWindow, this.currentNoteGuid, this.currentNote);
    }

    private void loadNoteBrowserInformation(BrowserWindow browser, String guid, Note note) {
        QByteArray js;
        NoteFormatter formatter = new NoteFormatter(this.logger, this.conn, this.tempFiles);
        formatter.setNote(note, Global.pdfPreview());
        formatter.setHighlight(this.listManager.getEnSearch());
        int tabIndex = -1;
        for (TabBrowse tab : this.tabWindows.values()) {
            if (tab.getBrowserWindow() != browser) continue;
            tabIndex = this.tabBrowser.indexOf(tab);
            break;
        }
        if (!this.noteCache.containsKey(guid)) {
            js = new QByteArray();
            js.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            js.append("<style type=\"text/css\">.en-crypt-temp { border-collapse:collapse; border-style:solid; border-color:blue; padding:0.0mm 0.0mm 0.0mm 0.0mm; }</style>");
            js.append("<style type=\"text/css\">en-hilight { background-color: rgb(255,255,0) }</style>");
            js.append("<style> img { height:auto; width:auto; max-height:auto; max-width:100%; }</style>");
            if (Global.displayRightToLeft()) {
                js.append("<style> body { direction:rtl; }</style>");
            }
            js.append("<style type=\"text/css\">en-spell { text-decoration: none; border-bottom: dotted 1px #cc0000; }</style>");
            js.append("</head>");
            formatter.setNote(note, Global.pdfPreview());
            js.append(formatter.rebuildNoteHTML());
            js.append("</HTML>");
            js.replace("<!DOCTYPE en-note SYSTEM 'http://xml.evernote.com/pub/enml.dtd'>", "");
            js.replace("<!DOCTYPE en-note SYSTEM 'http://xml.evernote.com/pub/enml2.dtd'>", "");
            js.replace("<?xml version='1.0' encoding='UTF-8'?>", "");
            browser.setContent(js);
            this.noteCache.put(guid, js.toString());
            if (formatter.resourceError) {
                this.resourceErrorMessage(tabIndex);
            }
            if (formatter.formatError) {
                this.waitCursor(false);
                QMessageBox.information((QWidget)this, (String)this.tr("Error"), (String)this.tr("NeighborNote had issues formatting this note. To protect your data this note is being marked as read-only."));
                this.waitCursor(true);
            }
            if (tabIndex >= 0) {
                this.readOnly.put(tabIndex, formatter.readOnly);
                this.inkNote.put(tabIndex, formatter.inkNote);
            }
            if (tabIndex >= 0 && this.readOnly.get(tabIndex).booleanValue()) {
                this.readOnlyCache.put(guid, true);
            }
            if (tabIndex >= 0 && this.inkNote.get(tabIndex).booleanValue()) {
                this.inkNoteCache.put(guid, true);
            }
        } else {
            this.logger.log(this.logger.HIGH, "Note content is being pulled from the cache");
            String cachedContent = formatter.modifyCachedTodoTags(this.noteCache.get(guid));
            js = new QByteArray(cachedContent);
            browser.setContent(js);
            if (this.readOnlyCache.containsKey(guid) && tabIndex >= 0) {
                this.readOnly.put(tabIndex, true);
            } else {
                this.readOnly.put(tabIndex, false);
            }
            if (this.inkNoteCache.containsKey(guid) && tabIndex >= 0) {
                this.inkNote.put(tabIndex, true);
            } else {
                this.inkNote.put(tabIndex, false);
            }
        }
        if (this.conn.getNoteTable().isThumbnailNeeded(guid)) {
            this.thumbnailHTMLReady(guid, js, Global.calculateThumbnailZoom(js.toString()));
        }
        if (tabIndex >= 0 && (this.readOnly.get(tabIndex).booleanValue() || this.inkNote.get(tabIndex).booleanValue() || note.getAttributes() != null && note.getAttributes().getContentClass() != null && note.getAttributes().getContentClass() != "")) {
            browser.getBrowser().page().setContentEditable(false);
        } else {
            browser.getBrowser().page().setContentEditable(true);
        }
        if (tabIndex >= 0) {
            browser.setReadOnly(this.readOnly.get(tabIndex));
            this.deleteButton.setEnabled(this.readOnly.get(tabIndex) == false);
            this.tagButton.setEnabled(this.readOnly.get(tabIndex) == false);
            this.menuBar.noteDelete.setEnabled(this.readOnly.get(tabIndex) == false);
            this.menuBar.noteTags.setEnabled(this.readOnly.get(tabIndex) == false);
        }
        browser.setNote(note);
        if (note != null && note.getNotebookGuid() != null && this.conn.getNotebookTable().isLinked(note.getNotebookGuid())) {
            this.deleteButton.setEnabled(false);
            this.menuBar.notebookDeleteAction.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
            this.menuBar.notebookDeleteAction.setEnabled(true);
        }
        ArrayList<Notebook> nbooks = new ArrayList<Notebook>();
        int i = 0;
        while (i < this.listManager.getNotebookIndex().size()) {
            boolean found = false;
            int j = 0;
            while (j < this.listManager.getArchiveNotebookIndex().size()) {
                if (this.listManager.getArchiveNotebookIndex().get(j).getGuid().equals(this.listManager.getNotebookIndex().get(i).getGuid())) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                nbooks.add(this.listManager.getNotebookIndex().get(i));
            }
            ++i;
        }
        browser.setTitle(note.getTitle());
        browser.setTag(this.getTagNamesForNote(note));
        browser.setAuthor(note.getAttributes().getAuthor());
        browser.setAltered(note.getUpdated());
        browser.setCreation(note.getCreated());
        if (note.getAttributes().getSubjectDate() > 0L) {
            browser.setSubjectDate(note.getAttributes().getSubjectDate());
        } else {
            browser.setSubjectDate(note.getCreated());
        }
        browser.setUrl(note.getAttributes().getSourceURL());
        FilterEditorTags tagFilter = new FilterEditorTags(this.conn, this.logger);
        List<Tag> tagList = tagFilter.getValidTags(note);
        browser.setAllTags(tagList);
        browser.setCurrentTags(note.getTagNames());
        for (TabBrowse tab : this.tabWindows.values()) {
            if (!tab.getBrowserWindow().getNote().getGuid().equals(guid)) continue;
            int index = this.tabBrowser.indexOf(tab);
            this.noteDirty.put(index, false);
            break;
        }
        this.scrollToGuid(guid);
        browser.loadingData(false);
        if (this.thumbnailViewer.isActiveWindow()) {
            this.thumbnailView();
        }
        FilterEditorNotebooks notebookFilter = new FilterEditorNotebooks(this.conn, this.logger);
        browser.setNotebookList(notebookFilter.getValidNotebooks(note, this.listManager.getNotebookIndex()));
        this.waitCursor(false);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.refreshEvernoteNote");
    }

    private void toggleNoteAttributes() {
        this.menuBar.noteAttributes.setChecked(!this.menuBar.noteAttributes.isChecked());
        this.toggleNoteInformation();
    }

    private void toggleNoteInformation() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.toggleNoteInformation");
        boolean isChecked = this.menuBar.noteAttributes.isChecked();
        int i = 0;
        while (i < this.tabBrowser.count()) {
            BrowserWindow browser = ((TabBrowse)this.tabBrowser.widget(i)).getBrowserWindow();
            boolean isExtended = browser.isExtended();
            if (isChecked && !isExtended || !isChecked && isExtended) {
                browser.toggleInformation();
            }
            ++i;
        }
        this.menuBar.noteAttributes.setChecked(this.browserWindow.isExtended());
        Global.saveWindowVisible("noteInformation", this.browserWindow.isExtended());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.toggleNoteInformation");
    }

    private void printNote() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.printNote");
        QPrintDialog dialog = new QPrintDialog();
        if (dialog.exec() == QDialog.DialogCode.Accepted.value()) {
            QPrinter printer = dialog.printer();
            this.browserWindow.getBrowser().print(printer);
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.printNote");
    }

    private void emailNote() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.emailNote");
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            String text2 = this.browserWindow.getContentsToEmail();
            QUrl url = new QUrl("mailto:");
            url.addQueryItem("subject", this.currentNote.getTitle());
            url.addQueryItem("body", text2);
            QDesktopServices.openUrl((QUrl)url);
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.emailNote");
    }

    private void fullReindex() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.fullReindex");
        this.indexRunner.addWork("REINDEXALL");
        this.setMessage(this.tr("Database will be reindexed."));
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.fullReindex");
    }

    private void reindexNote() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.reindexNote");
        int i = 0;
        while (i < this.selectedNoteGUIDs.size()) {
            this.indexRunner.addWork("REINDEXNOTE " + this.selectedNoteGUIDs.get(i));
            ++i;
        }
        if (this.selectedNotebookGUIDs.size() > 1) {
            this.setMessage(this.tr("Notes will be reindexed."));
        } else {
            this.setMessage(this.tr("Note will be reindexed."));
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.reindexNote");
    }

    private void deleteNote() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.deleteNote");
        if (this.currentNote == null) {
            return;
        }
        if (this.currentNoteGuid.equals("")) {
            return;
        }
        String title = null;
        if (this.selectedNoteGUIDs.size() == 1) {
            title = this.conn.getNoteTable().getNote(this.selectedNoteGUIDs.get(0), false, false, false, false, false).getTitle();
        }
        if (this.currentNote.isActive()) {
            if (Global.verifyDelete()) {
                String msg = this.selectedNoteGUIDs.size() > 1 ? new String(String.valueOf(this.tr("Delete ")) + this.selectedNoteGUIDs.size() + " notes?") : (title != null ? new String(String.valueOf(this.tr("Delete note \"")) + title + "\"?") : new String(this.tr("Delete note selected note?")));
                if (QMessageBox.question((QWidget)this, (String)this.tr("Confirmation"), (String)msg, (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.No.value() && Global.verifyDelete()) {
                    return;
                }
            }
            if (this.selectedNoteGUIDs.size() == 0 && !this.currentNoteGuid.equals("")) {
                this.selectedNoteGUIDs.add(this.currentNoteGuid);
            }
            this.closeTabs(this.selectedNoteGUIDs);
            int i = 0;
            while (i < this.selectedNoteGUIDs.size()) {
                this.listManager.deleteNote(this.selectedNoteGUIDs.get(i));
                ++i;
            }
        } else {
            String msg;
            if (Global.verifyDelete() && QMessageBox.question((QWidget)this, (String)"Confirmation", (String)(msg = this.selectedNoteGUIDs.size() > 1 ? new String(String.valueOf(this.tr("Permanently delete ")) + this.selectedNoteGUIDs.size() + " notes?") : (title != null ? new String(String.valueOf(this.tr("Permanently delete note \"")) + title + "\"?") : new String(this.tr("Permanently delete note selected note?")))), (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.No.value()) {
                return;
            }
            if (this.selectedNoteGUIDs.size() == 0 && !this.currentNoteGuid.equals("")) {
                this.selectedNoteGUIDs.add(this.currentNoteGuid);
            }
            int i = this.selectedNoteGUIDs.size() - 1;
            while (i >= 0) {
                int j = this.listManager.getNoteTableModel().rowCount() - 1;
                while (j >= 0) {
                    SortedMap ix;
                    String tableGuid;
                    QModelIndex modelIndex = this.listManager.getNoteTableModel().index(j, Global.noteTableGuidPosition);
                    if (modelIndex != null && (tableGuid = (String)(ix = this.listManager.getNoteTableModel().itemData(modelIndex)).values().toArray()[0]).equals(this.selectedNoteGUIDs.get(i))) {
                        this.listManager.getNoteTableModel().removeRow(j);
                        j = -1;
                    }
                    --j;
                }
                this.closeTabs(this.selectedNoteGUIDs);
                this.listManager.expungeNote(this.selectedNoteGUIDs.get(i));
                this.conn.getHistoryTable().expungeHistory(this.selectedNoteGUIDs.get(i));
                this.conn.getExcludedTable().expungeExcludedNote(this.selectedNoteGUIDs.get(i));
                this.conn.getStaredTable().expungeStaredNote(this.selectedNoteGUIDs.get(i));
                --i;
            }
        }
        this.currentNoteGuid = "";
        this.closeExternalWindows(this.selectedNoteGUIDs);
        if (this.currentNoteGuid == null || this.currentNoteGuid.equals("")) {
            this.menuBar.noteAddNewTab.setEnabled(false);
        }
        this.listManager.loadNotesIndex();
        this.noteIndexUpdated(false);
        this.refreshEvernoteNote(true);
        this.scrollToGuid(this.currentNoteGuid);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.deleteNote");
    }

    private void closeTabs(List<String> noteGUIDs) {
        Collection<TabBrowse> tabBrowsers = this.tabWindows.values();
        Iterator<TabBrowse> tabIterator = tabBrowsers.iterator();
        Set<Integer> tabIndexes = this.tabWindows.keySet();
        Iterator indexIterator = tabIndexes.iterator();
        ArrayList<Integer> closeIndexes = new ArrayList<Integer>();
        while (tabIterator.hasNext()) {
            TabBrowse tab = tabIterator.next();
            int index = (Integer)indexIterator.next();
            String guid = tab.getBrowserWindow().getNote().getGuid();
            int i = 0;
            while (i < noteGUIDs.size()) {
                if (guid.equals(noteGUIDs.get(i))) {
                    closeIndexes.add(index);
                }
                ++i;
            }
        }
        int i = closeIndexes.size() - 1;
        while (i >= 0) {
            this.tabWindowClosing((Integer)closeIndexes.get(i));
            --i;
        }
    }

    private void closeExternalWindows(List<String> noteGUIDs) {
        Collection<ExternalBrowse> windows = this.externalWindows.values();
        Iterator<ExternalBrowse> windowIterator = windows.iterator();
        Set<String> guids = this.externalWindows.keySet();
        Iterator guidIterator = guids.iterator();
        ArrayList<ExternalBrowse> closeWindows = new ArrayList<ExternalBrowse>();
        while (windowIterator.hasNext()) {
            ExternalBrowse browser = windowIterator.next();
            String guid = (String)guidIterator.next();
            int i = 0;
            while (i < noteGUIDs.size()) {
                if (guid.equals(noteGUIDs.get(i))) {
                    closeWindows.add(browser);
                }
                ++i;
            }
        }
        int i = closeWindows.size() - 1;
        while (i >= 0) {
            ((ExternalBrowse)((Object)closeWindows.get(i))).close();
            --i;
        }
    }

    private void addNote() {
        this.logger.log(this.logger.HIGH, "Inside NeverNote.addNote");
        this.browserWindow.setReadOnly(false);
        this.saveNote();
        GregorianCalendar currentTime = new GregorianCalendar();
        StringBuffer noteString = new StringBuffer(100);
        noteString.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\">\n<en-note>\n");
        if (Global.overrideDefaultFont()) {
            noteString.append("<font face=\"" + Global.getDefaultFont() + "\" >");
            noteString.append("<span style=\"font-size:" + Global.getDefaultFontSize() + "pt;\">");
            noteString.append("<br clear=\"none\" />\n");
            noteString.append("</span>\n</font>\n");
        } else {
            noteString.append("<br clear=\"none\" />\n");
        }
        noteString.append("</en-note>");
        Long l = new Long(currentTime.getTimeInMillis());
        String randint = new String(Long.toString(l));
        String notebook = null;
        this.listManager.getNotebookIndex().get(0).getGuid();
        List selectedNotebook = this.notebookTree.selectedItems();
        if (selectedNotebook.size() > 0 && !((QTreeWidgetItem)selectedNotebook.get(0)).text(0).equalsIgnoreCase("All Notebooks") && !((QTreeWidgetItem)selectedNotebook.get(0)).text(2).equalsIgnoreCase("STACK")) {
            QTreeWidgetItem currentSelectedNotebook = (QTreeWidgetItem)selectedNotebook.get(0);
            notebook = currentSelectedNotebook.text(2);
        } else {
            boolean found = false;
            ArrayList<Notebook> goodNotebooks = new ArrayList<Notebook>();
            int i = 0;
            while (i < this.listManager.getNotebookIndex().size()) {
                boolean match = false;
                int j = 0;
                while (j < this.listManager.getArchiveNotebookIndex().size()) {
                    if (this.listManager.getArchiveNotebookIndex().get(j).getGuid().equals(this.listManager.getNotebookIndex().get(i).getGuid())) {
                        match = true;
                        j = this.listManager.getArchiveNotebookIndex().size();
                    }
                    ++j;
                }
                if (!match) {
                    goodNotebooks.add((Notebook)Global.deepCopy(this.listManager.getNotebookIndex().get(i)));
                }
                ++i;
            }
            found = false;
            i = 0;
            while (i < goodNotebooks.size()) {
                if (((Notebook)goodNotebooks.get(i)).isDefaultNotebook()) {
                    notebook = ((Notebook)goodNotebooks.get(i)).getGuid();
                    found = true;
                    i = goodNotebooks.size();
                }
                ++i;
            }
            if (goodNotebooks.size() > 0 && !found) {
                notebook = ((Notebook)goodNotebooks.get(0)).getGuid();
            }
            if (notebook == null) {
                notebook = this.listManager.getNotebookIndex().get(0).getGuid();
            }
        }
        Note newNote = new Note();
        newNote.setUpdateSequenceNum(0);
        newNote.setGuid(randint);
        newNote.setNotebookGuid(notebook);
        newNote.setTitle("Untitled Note");
        newNote.setContent(noteString.toString());
        newNote.setDeleted(0L);
        newNote.setCreated(System.currentTimeMillis());
        newNote.setUpdated(System.currentTimeMillis());
        newNote.setActive(true);
        NoteAttributes na = new NoteAttributes();
        na.setLatitude(0.0);
        na.setLongitude(0.0);
        na.setAltitude(0.0);
        newNote.setAttributes(new NoteAttributes());
        newNote.setTagGuids(new ArrayList());
        newNote.setTagNames(new ArrayList());
        if (Global.newNoteWithSelectedTags()) {
            List selections = this.tagTree.selectedItems();
            int i = 0;
            while (i < selections.size()) {
                QTreeWidgetItem currentSelection = (QTreeWidgetItem)selections.get(i);
                newNote.getTagGuids().add(currentSelection.text(2));
                newNote.getTagNames().add(currentSelection.text(0));
                ++i;
            }
        }
        this.conn.getNoteTable().addNote(newNote, true);
        NoteMetadata metadata = new NoteMetadata();
        metadata.setGuid(newNote.getGuid());
        metadata.setDirty(true);
        this.listManager.addNote(newNote, metadata);
        String prevCurrentNoteGuid = new String(this.currentNoteGuid);
        this.currentNote = newNote;
        this.currentNoteGuid = this.currentNote.getGuid();
        if (prevCurrentNoteGuid != null && !prevCurrentNoteGuid.equals("") && this.currentNoteGuid != null && !this.currentNoteGuid.equals("")) {
            this.conn.getHistoryTable().addHistory("addNewNote", prevCurrentNoteGuid, this.currentNoteGuid);
        }
        this.refreshEvernoteNote(true);
        this.listManager.countNotebookResults(this.listManager.getNoteIndex());
        this.browserWindow.titleLabel.setFocus();
        this.browserWindow.titleLabel.selectAll();
        if (!this.isVisible()) {
            this.listDoubleClick();
        }
        this.waitCursor(false);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.addNote");
    }

    private void restoreNote() {
        this.waitCursor(true);
        if (this.selectedNoteGUIDs.size() == 0 && !this.currentNoteGuid.equals("")) {
            this.selectedNoteGUIDs.add(this.currentNoteGuid);
        }
        int i = 0;
        while (i < this.selectedNoteGUIDs.size()) {
            this.listManager.restoreNote(this.selectedNoteGUIDs.get(i));
            ++i;
        }
        this.currentNoteGuid = "";
        this.listManager.loadNotesIndex();
        this.noteIndexUpdated(false);
        this.waitCursor(false);
    }

    private void findText() {
        this.find.show();
        this.find.setFocusOnTextField();
    }

    private void doFindText() {
        this.browserWindow.getBrowser().page().findText(this.find.getText(), this.find.getFlags());
        this.find.setFocus();
    }

    private void updateNoteTitle(String guid, String title) {
        this.listManager.setNoteSynchronized(guid, false);
        if (guid.equals(this.currentNoteGuid)) {
            this.browserWindow.titleLabel.blockSignals(true);
            this.browserWindow.titleLabel.setText(title);
            this.browserWindow.titleLabel.blockSignals(false);
        }
    }

    private void invalidateNoteCache(String guid, String content) {
        this.noteCache.remove(guid);
        this.refreshEvernoteNote(true);
    }

    private void noteGuidChanged(String oldGuid, String newGuid) {
        if (this.noteCache.containsKey(oldGuid)) {
            if (!oldGuid.equals(this.currentNoteGuid)) {
                String cache = this.noteCache.get(oldGuid);
                this.noteCache.put(newGuid, cache);
                this.noteCache.remove(oldGuid);
            } else {
                this.noteCache.remove(oldGuid);
                this.noteCache.put(newGuid, this.browserWindow.getContent());
            }
        }
        this.listManager.updateNoteGuid(oldGuid, newGuid, false);
        if (this.currentNoteGuid.equals(oldGuid)) {
            if (this.currentNote != null) {
                this.currentNote.setGuid(newGuid);
            }
            this.currentNoteGuid = newGuid;
        }
        if (this.externalWindows.containsKey(oldGuid)) {
            ExternalBrowse b = this.externalWindows.get(oldGuid);
            this.externalWindows.remove(oldGuid);
            b.getBrowserWindow().getNote().setGuid(newGuid);
            this.externalWindows.put(newGuid, b);
        }
        int i = 0;
        while (i < this.tabBrowser.count()) {
            TabBrowse b = (TabBrowse)this.tabBrowser.widget(i);
            if (b.getBrowserWindow().getNote().getGuid().equals(oldGuid)) {
                b.getBrowserWindow().getNote().setGuid(newGuid);
            }
            ++i;
        }
        i = 0;
        while (i < this.listManager.getNoteIndex().size()) {
            if (this.listManager.getNoteIndex().get(i).getGuid().equals(newGuid)) {
                this.noteTableView.proxyModel.addGuid(newGuid, this.listManager.getNoteMetadata().get(newGuid));
                i = this.listManager.getNoteIndex().size();
            }
            ++i;
        }
        if (this.listManager.getNoteTableModel().metaData.containsKey(oldGuid)) {
            NoteMetadata meta = this.listManager.getNoteTableModel().metaData.get(oldGuid);
            this.listManager.getNoteTableModel().metaData.put(newGuid, meta);
            this.listManager.getNoteTableModel().metaData.remove(oldGuid);
        }
    }

    private void toggleEditorButtonBar() {
        boolean isChecked = this.menuBar.showEditorBar.isChecked();
        int i = 0;
        while (i < this.tabBrowser.count()) {
            BrowserWindow browser = ((TabBrowse)this.tabBrowser.widget(i)).getBrowserWindow();
            boolean isVisible = browser.buttonsVisible;
            if (isChecked && !isVisible) {
                browser.buttonsVisible = true;
                this.showEditorButtons(browser);
            } else if (!isChecked && isVisible) {
                browser.hideButtons();
            }
            ++i;
        }
        Global.saveWindowVisible("editorButtonBar", this.browserWindow.buttonsVisible);
    }

    private void showEditorButtons(BrowserWindow browser) {
        browser.buttonLayout.setVisible(true);
        browser.undoAction.setVisible(false);
        browser.undoButton.setVisible(false);
        browser.undoAction.setVisible(Global.isEditorButtonVisible("undo"));
        browser.redoAction.setVisible(Global.isEditorButtonVisible("redo"));
        browser.cutAction.setVisible(Global.isEditorButtonVisible("cut"));
        browser.copyAction.setVisible(Global.isEditorButtonVisible("copy"));
        browser.pasteAction.setVisible(Global.isEditorButtonVisible("paste"));
        browser.strikethroughAction.setVisible(Global.isEditorButtonVisible("strikethrough"));
        browser.underlineAction.setVisible(Global.isEditorButtonVisible("underline"));
        browser.boldAction.setVisible(Global.isEditorButtonVisible("bold"));
        browser.italicAction.setVisible(Global.isEditorButtonVisible("italic"));
        browser.hlineAction.setVisible(Global.isEditorButtonVisible("hline"));
        browser.indentAction.setVisible(Global.isEditorButtonVisible("indent"));
        browser.outdentAction.setVisible(Global.isEditorButtonVisible("outdent"));
        browser.bulletListAction.setVisible(Global.isEditorButtonVisible("bulletList"));
        browser.numberListAction.setVisible(Global.isEditorButtonVisible("numberList"));
        browser.fontListAction.setVisible(Global.isEditorButtonVisible("font"));
        browser.fontSizeAction.setVisible(Global.isEditorButtonVisible("fontSize"));
        browser.fontColorAction.setVisible(Global.isEditorButtonVisible("fontColor"));
        browser.fontHilightAction.setVisible(Global.isEditorButtonVisible("fontHilight"));
        browser.leftAlignAction.setVisible(Global.isEditorButtonVisible("alignLeft"));
        browser.centerAlignAction.setVisible(Global.isEditorButtonVisible("alignCenter"));
        browser.rightAlignAction.setVisible(Global.isEditorButtonVisible("alignRight"));
        browser.spellCheckAction.setVisible(Global.isEditorButtonVisible("spellCheck"));
        browser.todoAction.setVisible(Global.isEditorButtonVisible("todo"));
    }

    private void duplicateNote(String guid) {
        Note oldNote = this.conn.getNoteTable().getNote(guid, true, false, false, false, true);
        List<Resource> resList = this.conn.getNoteTable().noteResourceTable.getNoteResources(guid, true);
        oldNote.setContent(this.conn.getNoteTable().getNoteContentNoUTFConversion(guid));
        oldNote.setResources(resList);
        this.duplicateNote(oldNote);
    }

    private void duplicateNote(Note oldNote) {
        this.waitCursor(true);
        GregorianCalendar currentTime = new GregorianCalendar();
        Long l = new Long(currentTime.getTimeInMillis());
        String newGuid = new String(Long.toString(l));
        Note newNote = (Note)Global.deepCopy(oldNote);
        newNote.setUpdateSequenceNum(0);
        newNote.setGuid(newGuid);
        newNote.setDeleted(0L);
        newNote.setActive(true);
        ArrayList resList = oldNote.getResources();
        if (resList == null) {
            resList = new ArrayList();
        }
        long prevGuid = 0L;
        int i = 0;
        while (i < resList.size()) {
            l = prevGuid;
            while (l == prevGuid) {
                currentTime = new GregorianCalendar();
                l = new Long(currentTime.getTimeInMillis());
            }
            prevGuid = l;
            String newResGuid = new String(Long.toString(l));
            ((Resource)resList.get(i)).setNoteGuid(newGuid);
            ((Resource)resList.get(i)).setGuid(newResGuid);
            ((Resource)resList.get(i)).setUpdateSequenceNum(0);
            ((Resource)resList.get(i)).setActive(true);
            this.conn.getNoteTable().noteResourceTable.saveNoteResource((Resource)Global.deepCopy(resList.get(i)), true);
            ++i;
        }
        newNote.setResources(resList);
        if (Global.getDuplicateRensoNote()) {
            this.conn.getHistoryTable().duplicateHistory(newGuid, oldNote.getGuid());
            this.conn.getExcludedTable().duplicateExcludedNotes(newGuid, oldNote.getGuid());
            this.conn.getStaredTable().duplicateStaredNotes(newGuid, oldNote.getGuid());
        }
        this.conn.getNoteTable().addNote(newNote, true);
        NoteMetadata metaData = new NoteMetadata();
        NoteMetadata oldMeta = this.listManager.getNoteMetadata().get(oldNote.getGuid());
        metaData.copy(oldMeta);
        metaData.setGuid(newNote.getGuid());
        this.listManager.addNote(newNote, metaData);
        this.noteTableView.insertRow(newNote, metaData, true, -1);
        this.currentNoteGuid = newNote.getGuid();
        this.currentNote = newNote;
        this.refreshEvernoteNote(true);
        this.listManager.countNotebookResults(this.listManager.getNoteIndex());
        this.waitCursor(false);
    }

    private void allNotes() {
        this.clearAttributeFilter();
        this.clearNotebookFilter();
        this.clearSavedSearchFilter();
        this.clearTrashFilter();
        this.clearTagFilter();
        this.searchField.clear();
        if (Global.mimicEvernoteInterface) {
            this.notebookTree.selectGuid("");
        }
        this.notebookTreeSelection();
        this.refreshEvernoteNote(true);
        if (!this.rensoNoteListDock.isEnabled()) {
            this.rensoNoteListDock.setEnabled(true);
        }
    }

    private void mergeNotes() {
        this.logger.log(this.logger.HIGH, "Merging notes");
        this.waitCursor(true);
        this.saveNote();
        String masterGuid = null;
        ArrayList<String> sources = new ArrayList<String>();
        int i = 0;
        while (i < this.noteTableView.selectionModel().selectedRows().size()) {
            int r = ((QModelIndex)this.noteTableView.selectionModel().selectedRows().get(i)).row();
            QModelIndex index = this.noteTableView.proxyModel.index(r, Global.noteTableGuidPosition);
            SortedMap ix = this.noteTableView.proxyModel.itemData(index);
            if (i == 0) {
                masterGuid = (String)ix.values().toArray()[0];
            } else {
                sources.add((String)ix.values().toArray()[0]);
            }
            ++i;
        }
        this.logger.log(this.logger.EXTREME, "Master guid=" + masterGuid);
        this.logger.log(this.logger.EXTREME, "Children count: " + sources.size());
        this.mergeNoteContents(masterGuid, sources);
        this.currentNoteGuid = masterGuid;
        if (Global.getMergeRensoNote()) {
            i = 0;
            while (i < sources.size()) {
                String childGuid = (String)sources.get(i);
                if (masterGuid != null && childGuid != null && !masterGuid.equals(childGuid)) {
                    this.conn.getHistoryTable().mergeHistoryGuid(masterGuid, childGuid);
                    this.conn.getExcludedTable().mergeHistoryGuid(masterGuid, childGuid);
                    this.conn.getStaredTable().mergeHistoryGuid(masterGuid, childGuid);
                }
                ++i;
            }
        }
        Collection<ExternalBrowse> windows = this.externalWindows.values();
        Iterator<ExternalBrowse> windowIterator = windows.iterator();
        Set<String> guids = this.externalWindows.keySet();
        Iterator guidIterator = guids.iterator();
        ArrayList<ExternalBrowse> closeWindows = new ArrayList<ExternalBrowse>();
        while (windowIterator.hasNext()) {
            ExternalBrowse browser = windowIterator.next();
            String guid = (String)guidIterator.next();
            int i2 = 0;
            while (i2 < sources.size()) {
                if (guid.equals(sources.get(i2))) {
                    closeWindows.add(browser);
                }
                ++i2;
            }
        }
        int i3 = closeWindows.size() - 1;
        while (i3 >= 0) {
            ((ExternalBrowse)((Object)closeWindows.get(i3))).close();
            --i3;
        }
        Collection<TabBrowse> tabBrowsers = this.tabWindows.values();
        Iterator<TabBrowse> tabIterator = tabBrowsers.iterator();
        Set<Integer> tabIndexes = this.tabWindows.keySet();
        Iterator indexIterator = tabIndexes.iterator();
        ArrayList<Integer> closeIndexes = new ArrayList<Integer>();
        while (tabIterator.hasNext()) {
            TabBrowse tab = tabIterator.next();
            int tabIndex = (Integer)indexIterator.next();
            String guid = tab.getBrowserWindow().getNote().getGuid();
            int i4 = 0;
            while (i4 < sources.size()) {
                if (guid.equals(sources.get(i4))) {
                    closeIndexes.add(tabIndex);
                }
                ++i4;
            }
        }
        int i5 = closeIndexes.size() - 1;
        while (i5 >= 0) {
            this.tabWindowClosing((Integer)closeIndexes.get(i5));
            --i5;
        }
        this.noteIndexUpdated(false);
        this.noteCache.remove(masterGuid);
        this.refreshEvernoteNote(true);
        this.waitCursor(false);
    }

    private void mergeNoteContents(String targetGuid, List<String> sources) {
        Note target = this.conn.getNoteTable().getNote(targetGuid, true, false, false, false, false);
        String newContent = target.getContent();
        newContent = newContent.replace("</en-note>", "<br></br>");
        int i = 0;
        while (i < sources.size()) {
            Note source = this.conn.getNoteTable().getNote(sources.get(i), true, true, false, false, false);
            if (source.isSetTitle()) {
                newContent = String.valueOf(newContent) + "<table bgcolor=\"lightgrey\"><tr><td><font size=\"6\"><b>" + source.getTitle() + "</b></font></td></tr></table>";
            }
            String sourceContent = source.getContent();
            this.logger.log(this.logger.EXTREME, "Merging contents into note");
            this.logger.log(this.logger.EXTREME, sourceContent);
            this.logger.log(this.logger.EXTREME, "End of content");
            int startOfNote = sourceContent.indexOf("<en-note>");
            sourceContent = sourceContent.substring(startOfNote + 9);
            int endOfNote = sourceContent.indexOf("</en-note>");
            sourceContent = sourceContent.substring(0, endOfNote);
            newContent = String.valueOf(newContent) + sourceContent;
            this.logger.log(this.logger.EXTREME, "New note content");
            this.logger.log(this.logger.EXTREME, newContent);
            this.logger.log(this.logger.EXTREME, "End of content");
            int j = 0;
            while (j < source.getResourcesSize()) {
                this.logger.log(this.logger.EXTREME, "Reassigning resource: " + ((Resource)source.getResources().get(j)).getGuid());
                Resource r = (Resource)source.getResources().get(j);
                Resource newRes = this.conn.getNoteTable().noteResourceTable.getNoteResource(r.getGuid(), true);
                GregorianCalendar currentTime = new GregorianCalendar();
                Long l = new Long(currentTime.getTimeInMillis());
                long prevGuid = 0L;
                l = prevGuid;
                while (l == prevGuid) {
                    currentTime = new GregorianCalendar();
                    l = new Long(currentTime.getTimeInMillis());
                }
                String newResGuid = new String(Long.toString(l));
                newRes.setNoteGuid(targetGuid);
                newRes.setGuid(newResGuid);
                newRes.setUpdateSequenceNum(0);
                newRes.setActive(true);
                this.conn.getNoteTable().noteResourceTable.saveNoteResource(newRes, true);
                ++j;
            }
            ++i;
        }
        this.logger.log(this.logger.EXTREME, "Updating note");
        this.conn.getNoteTable().updateNoteContent(targetGuid, String.valueOf(newContent) + "</en-note>");
        i = 0;
        while (i < sources.size()) {
            this.logger.log(this.logger.EXTREME, "Deleting note " + sources.get(i));
            this.listManager.deleteNote(sources.get(i));
            ++i;
        }
        this.logger.log(this.logger.EXTREME, "Exiting merge note");
    }

    private void noteResourceGuidChanged(String noteGuid, String oldGuid, String newGuid) {
        if (oldGuid != null && !oldGuid.equals(newGuid)) {
            Global.resourceMap.put(oldGuid, newGuid);
        }
    }

    public void thumbnailView() {
        String thumbnailName = Global.getFileManager().getResDirPath("thumbnail-" + this.currentNoteGuid + ".png");
        QFile thumbnail = new QFile(thumbnailName);
        if (!thumbnail.exists()) {
            QImage img = new QImage();
            img.loadFromData(this.conn.getNoteTable().getThumbnail(this.currentNoteGuid));
            this.thumbnailViewer.setThumbnail(img);
        } else {
            this.thumbnailViewer.setThumbnail(thumbnailName);
        }
        if (!this.thumbnailViewer.isVisible()) {
            this.thumbnailViewer.showFullScreen();
        }
    }

    private void saveRunnerError(String guid, String msg) {
        if (msg == null) {
            String title = "*Unknown*";
            int i = 0;
            while (i < this.listManager.getMasterNoteIndex().size()) {
                if (this.listManager.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                    title = this.listManager.getMasterNoteIndex().get(i).getTitle();
                    i = this.listManager.getMasterNoteIndex().size();
                }
                ++i;
            }
            msg = String.valueOf(this.tr("An error has happened while saving the note \"")) + title + this.tr("\".\n\nThis is probably due to a document that is too complex for NeighborNote to process.  As a result, changes to the note may not be saved properly in the database.\n\nA cached copy is being preserved so you can recover any data, but data may\nbe lost.  Please review the note to recover any critical data before restarting.");
            QMessageBox.information((QWidget)this, (String)this.tr("Error Saving Note"), (String)this.tr(msg));
        }
    }

    private void thumbnailHTMLReady(String guid, QByteArray html, Integer zoom) {
        this.logger.log(this.logger.HIGH, "Entering thumnailHTMLReady()");
        this.logger.log(this.logger.HIGH, "Thumbnail ready for " + guid);
        int i = 0;
        while (i < this.thumbGenerators.size()) {
            if (this.thumbGenerators.get((int)i).mutex.tryLock()) {
                this.logger.log(this.logger.EXTREME, "Idle generator found - loading thumbnail for " + guid);
                this.thumbGenerators.get(i).loadContent(guid, html, zoom);
                return;
            }
            ++i;
        }
        if (this.thumbGenerators.size() >= 1) {
            this.logger.log(this.logger.EXTREME, "No available thumbnail generators.  Aborting " + guid);
            return;
        }
        this.logger.log(this.logger.EXTREME, "Creating new thumbnail generator " + guid);
        Thumbnailer preview = new Thumbnailer(this.logger, this.conn, this.listManager, this.thumbnailRunner);
        this.thumbGenerators.add(preview);
        if (preview.mutex.tryLock()) {
            this.logger.log(this.logger.EXTREME, "Loading thumbnail for  " + guid);
            preview.loadContent(guid, html, zoom);
        }
        this.logger.log(this.logger.HIGH, "Exiting thumnailHTMLReady()");
    }

    private void setupOnlineMenu() {
        if (!Global.isConnected) {
            this.menuBar.noteOnlineHistoryAction.setEnabled(false);
            this.menuBar.selectiveSyncAction.setEnabled(false);
            return;
        }
        this.menuBar.noteOnlineHistoryAction.setEnabled(true);
        this.menuBar.selectiveSyncAction.setEnabled(true);
    }

    private void viewNoteHistory() {
        if (this.currentNoteGuid == null || this.currentNoteGuid.equals("")) {
            return;
        }
        if (this.currentNote.getUpdateSequenceNum() == 0) {
            this.setMessage(this.tr("Note has never been synchronized."));
            QMessageBox.information((QWidget)this, (String)this.tr("Error"), (String)this.tr("This note has never been sent to Evernote, so there is no history."));
            return;
        }
        this.setMessage(this.tr("Getting Note History"));
        this.waitCursor(true);
        Note currentOnlineNote = null;
        this.versions = null;
        try {
            this.versions = Global.isPremium() ? this.syncRunner.localNoteStore.listNoteVersions(this.syncRunner.authToken, this.currentNoteGuid) : new ArrayList<NoteVersionId>();
            currentOnlineNote = this.syncRunner.localNoteStore.getNote(this.syncRunner.authToken, this.currentNoteGuid, true, true, false, false);
        }
        catch (EDAMUserException e) {
            this.setMessage("EDAMUserException: " + e.getMessage());
            return;
        }
        catch (EDAMSystemException e) {
            this.setMessage("EDAMSystemException: " + e.getMessage());
            return;
        }
        catch (EDAMNotFoundException e) {
            this.setMessage(this.tr("Note not found on server."));
            QMessageBox.information((QWidget)this, (String)this.tr("Error"), (String)this.tr("This note could not be found on Evernote's servers."));
            return;
        }
        catch (TException e) {
            this.setMessage("EDAMTransactionException: " + e.getMessage());
            return;
        }
        if (this.historyWindow == null) {
            this.historyWindow = new OnlineNoteHistory(this.logger, this.conn, this.cbObserver);
            this.historyWindow.historyCombo.activated.connect((Object)this, "reloadHistoryWindow(String)");
            this.historyWindow.restoreAsNew.clicked.connect((Object)this, "restoreHistoryNoteAsNew()");
            this.historyWindow.restore.clicked.connect((Object)this, "restoreHistoryNote()");
        } else {
            this.historyWindow.historyCombo.clear();
        }
        boolean isDirty = this.conn.getNoteTable().isNoteDirty(this.currentNoteGuid);
        if (this.currentNote.getUpdateSequenceNum() != currentOnlineNote.getUpdateSequenceNum()) {
            isDirty = true;
        }
        this.historyWindow.setCurrent(isDirty);
        this.loadHistoryWindowContent(currentOnlineNote);
        this.historyWindow.load(this.versions);
        this.setMessage(this.tr("History retrieved"));
        this.waitCursor(false);
        this.historyWindow.exec();
    }

    private Note reloadHistoryWindow(String selection) {
        this.waitCursor(true);
        String fmt = String.valueOf(Global.getDateFormat()) + " " + Global.getTimeFormat();
        String dateTimeFormat = new String(fmt);
        SimpleDateFormat simple = new SimpleDateFormat(dateTimeFormat);
        int index = -1;
        int usn = 0;
        int i = 0;
        while (i < this.versions.size()) {
            StringBuilder versionDate = new StringBuilder(simple.format(this.versions.get(i).getSaved()));
            if (versionDate.toString().equals(selection)) {
                index = i;
            }
            ++i;
        }
        if (index > -1 || selection.indexOf("Current") > -1) {
            Note historyNote = null;
            try {
                if (index > -1) {
                    usn = this.versions.get(index).getUpdateSequenceNum();
                    historyNote = this.syncRunner.localNoteStore.getNoteVersion(this.syncRunner.authToken, this.currentNoteGuid, usn, true, true, true);
                } else {
                    historyNote = this.syncRunner.localNoteStore.getNote(this.syncRunner.authToken, this.currentNoteGuid, true, true, true, true);
                }
            }
            catch (EDAMUserException e) {
                this.setMessage("EDAMUserException: " + e.getMessage());
                this.waitCursor(false);
                return null;
            }
            catch (EDAMSystemException e) {
                this.setMessage("EDAMSystemException: " + e.getMessage());
                this.waitCursor(false);
                return null;
            }
            catch (EDAMNotFoundException e) {
                this.setMessage("EDAMNotFoundException: " + e.getMessage());
                this.waitCursor(false);
                return null;
            }
            catch (TException e) {
                this.setMessage("EDAMTransactionException: " + e.getMessage());
                this.waitCursor(false);
                return null;
            }
            this.waitCursor(false);
            if (historyNote != null) {
                this.historyWindow.setContent(historyNote);
            }
            return historyNote;
        }
        this.waitCursor(false);
        return null;
    }

    private void loadHistoryWindowContent(Note note) {
        note.setUpdateSequenceNum(0);
        this.historyWindow.setContent(note);
    }

    private void restoreHistoryNoteAsNew() {
        this.setMessage(this.tr("Restoring as new note."));
        this.duplicateNote(this.reloadHistoryWindow(this.historyWindow.historyCombo.currentText()));
        this.setMessage(this.tr("Note has been restored as a new note."));
    }

    private void restoreHistoryNote() {
        this.setMessage(this.tr("Restoring note."));
        Note n = this.reloadHistoryWindow(this.historyWindow.historyCombo.currentText());
        this.conn.getNoteTable().expungeNote(n.getGuid(), true, false);
        n.setActive(true);
        n.setDeleted(0L);
        int i = 0;
        while (i < n.getResourcesSize()) {
            ((Resource)n.getResources().get(i)).setActive(true);
            this.conn.getNoteTable().noteResourceTable.saveNoteResource((Resource)n.getResources().get(i), true);
            ++i;
        }
        NoteMetadata metadata = new NoteMetadata();
        metadata.setGuid(n.getGuid());
        this.listManager.addNote(n, metadata);
        this.conn.getNoteTable().addNote(n, true);
        this.refreshEvernoteNote(true);
        this.setMessage(this.tr("Note has been restored."));
    }

    private void setupSelectiveSync() {
        List notebooks = null;
        List tags = null;
        List linkedNotebooks = null;
        try {
            notebooks = this.syncRunner.localNoteStore.listNotebooks(this.syncRunner.authToken);
            tags = this.syncRunner.localNoteStore.listTags(this.syncRunner.authToken);
            linkedNotebooks = this.syncRunner.localNoteStore.listLinkedNotebooks(this.syncRunner.authToken);
        }
        catch (EDAMUserException e) {
            this.setMessage("EDAMUserException: " + e.getMessage());
            return;
        }
        catch (EDAMSystemException e) {
            this.setMessage("EDAMSystemException: " + e.getMessage());
            return;
        }
        catch (TException e) {
            this.setMessage("EDAMTransactionException: " + e.getMessage());
            return;
        }
        catch (EDAMNotFoundException e) {
            this.setMessage("EDAMNotFoundException: " + e.getMessage());
            return;
        }
        ArrayList<Notebook> ignoredBooks = new ArrayList<Notebook>();
        List<String> dbIgnoredNotebooks = this.conn.getSyncTable().getIgnoreRecords("NOTEBOOK");
        int i = notebooks.size() - 1;
        while (i >= 0) {
            int j = 0;
            while (j < dbIgnoredNotebooks.size()) {
                if (((Notebook)notebooks.get(i)).getGuid().equalsIgnoreCase(dbIgnoredNotebooks.get(j))) {
                    ignoredBooks.add((Notebook)notebooks.get(i));
                    j = dbIgnoredNotebooks.size();
                }
                ++j;
            }
            --i;
        }
        ArrayList<Tag> ignoredTags = new ArrayList<Tag>();
        List<String> dbIgnoredTags = this.conn.getSyncTable().getIgnoreRecords("TAG");
        int i2 = tags.size() - 1;
        while (i2 >= 0) {
            int j = 0;
            while (j < dbIgnoredTags.size()) {
                if (((Tag)tags.get(i2)).getGuid().equalsIgnoreCase(dbIgnoredTags.get(j))) {
                    ignoredTags.add((Tag)tags.get(i2));
                    j = dbIgnoredTags.size();
                }
                ++j;
            }
            --i2;
        }
        ArrayList<LinkedNotebook> ignoredLinkedNotebooks = new ArrayList<LinkedNotebook>();
        List<String> dbIgnoredLinkedNotebooks = this.conn.getSyncTable().getIgnoreRecords("LINKEDNOTEBOOK");
        int i3 = linkedNotebooks.size() - 1;
        while (i3 >= 0) {
            String notebookGuid = ((LinkedNotebook)linkedNotebooks.get(i3)).getGuid();
            int j = 0;
            while (j < dbIgnoredLinkedNotebooks.size()) {
                if (notebookGuid.equalsIgnoreCase(dbIgnoredLinkedNotebooks.get(j))) {
                    ignoredLinkedNotebooks.add((LinkedNotebook)linkedNotebooks.get(i3));
                    j = dbIgnoredLinkedNotebooks.size();
                }
                ++j;
            }
            --i3;
        }
        IgnoreSync ignore = new IgnoreSync(notebooks, ignoredBooks, tags, ignoredTags, linkedNotebooks, ignoredLinkedNotebooks);
        ignore.exec();
        if (!ignore.okClicked()) {
            return;
        }
        this.waitCursor(true);
        List<String> oldIgnoreNotebooks = this.conn.getSyncTable().getIgnoreRecords("NOTEBOOK");
        int i4 = 0;
        while (i4 < oldIgnoreNotebooks.size()) {
            this.conn.getSyncTable().deleteRecord("IGNORENOTEBOOK-" + oldIgnoreNotebooks.get(i4));
            ++i4;
        }
        ArrayList<String> newNotebooks = new ArrayList<String>();
        int i5 = ignore.getIgnoredBookList().count() - 1;
        while (i5 >= 0) {
            String text = ignore.getIgnoredBookList().takeItem(i5).text();
            int j = 0;
            while (j < notebooks.size()) {
                if (((Notebook)notebooks.get(j)).getName().equalsIgnoreCase(text)) {
                    Notebook n = (Notebook)notebooks.get(j);
                    this.conn.getSyncTable().addRecord("IGNORENOTEBOOK-" + n.getGuid(), n.getGuid());
                    j = notebooks.size();
                    newNotebooks.add(n.getGuid());
                }
                ++j;
            }
            --i5;
        }
        List<String> oldIgnoreTags = this.conn.getSyncTable().getIgnoreRecords("TAG");
        int i6 = 0;
        while (i6 < oldIgnoreTags.size()) {
            this.conn.getSyncTable().deleteRecord("IGNORETAG-" + oldIgnoreTags.get(i6));
            ++i6;
        }
        ArrayList<String> newTags = new ArrayList<String>();
        int i7 = ignore.getIgnoredTagList().count() - 1;
        while (i7 >= 0) {
            String text = ignore.getIgnoredTagList().takeItem(i7).text();
            int j = 0;
            while (j < tags.size()) {
                if (((Tag)tags.get(j)).getName().equalsIgnoreCase(text)) {
                    Tag t = (Tag)tags.get(j);
                    this.conn.getSyncTable().addRecord("IGNORETAG-" + t.getGuid(), t.getGuid());
                    newTags.add(t.getGuid());
                    j = tags.size();
                }
                ++j;
            }
            --i7;
        }
        List<String> oldIgnoreLinkedNotebooks = this.conn.getSyncTable().getIgnoreRecords("LINKEDNOTEBOOK");
        int i8 = 0;
        while (i8 < oldIgnoreLinkedNotebooks.size()) {
            this.conn.getSyncTable().deleteRecord("IGNORELINKEDNOTEBOOK-" + oldIgnoreLinkedNotebooks.get(i8));
            ++i8;
        }
        ArrayList<String> newLinked = new ArrayList<String>();
        int i9 = ignore.getIgnoredLinkedNotebookList().count() - 1;
        while (i9 >= 0) {
            String text = ignore.getIgnoredLinkedNotebookList().takeItem(i9).text();
            int j = 0;
            while (j < linkedNotebooks.size()) {
                if (((LinkedNotebook)linkedNotebooks.get(j)).getShareName().equalsIgnoreCase(text)) {
                    LinkedNotebook t = (LinkedNotebook)linkedNotebooks.get(j);
                    this.conn.getSyncTable().addRecord("IGNORELINKEDNOTEBOOK-" + t.getGuid(), t.getGuid());
                    newLinked.add(t.getGuid());
                    j = linkedNotebooks.size();
                }
                ++j;
            }
            --i9;
        }
        this.conn.getNoteTable().expungeIgnoreSynchronizedNotes(newNotebooks, newTags, newLinked);
        this.waitCursor(false);
        this.refreshLists();
    }

    private void resourceErrorMessage(int tabIndex) {
        if (tabIndex < 0) {
            return;
        }
        if (this.inkNote.get(tabIndex).booleanValue()) {
            return;
        }
        this.waitCursor(false);
        QMessageBox.information((QWidget)this, (String)this.tr("DOUGH!!!"), (String)this.tr("Well, this is embarrassing.\n\nSome attachments or images for this note appear to be missing from my database.\nIn a perfect world this wouldn't happen, but it has.\nIt is embarasing when a program like me, designed to save all your\nprecious data, has a problem finding data.\n\nI guess life isn't fair, but I'll survive.  Somehow...\n\nIn the mean time, I'm not going to let you make changes to this note.\nDon't get angry.  I'm doing it to prevent you from messing up\nthis note on the Evernote servers.  Sorry.\n\nP.S. You might want to re-synchronize to see if it corrects this problem.\nWho knows, you might get lucky."));
        this.inkNote.put(tabIndex, true);
        this.browserWindow.setReadOnly(true);
        this.waitCursor(true);
    }

    private void syncTimer() {
        this.logger.log(this.logger.EXTREME, "Entering NeverNote.syncTimer()");
        this.syncRunner.syncNeeded = true;
        this.syncRunner.disableUploads = Global.disableUploads;
        this.syncStart();
        this.logger.log(this.logger.EXTREME, "Leaving NeverNote.syncTimer()");
    }

    private void syncStart() {
        this.logger.log(this.logger.EXTREME, "Entering NeverNote.syncStart()");
        this.saveNote();
        if (!this.syncRunning && Global.isConnected) {
            this.syncRunner.setConnected(true);
            this.syncRunner.setKeepRunning(Global.keepRunning);
            this.syncRunner.syncDeletedContent = Global.synchronizeDeletedContent();
            if (this.syncThreadsReady > 0) {
                this.thumbnailRunner.interrupt = true;
                this.saveNoteIndexWidth();
                this.saveNoteColumnPositions();
                if (this.syncRunner.addWork("SYNC")) {
                    this.syncRunning = true;
                    this.syncRunner.syncNeeded = true;
                    --this.syncThreadsReady;
                }
            }
        }
        this.logger.log(this.logger.EXTREME, "Leaving NeverNote.syncStart");
    }

    private void syncThreadComplete(Boolean refreshNeeded) {
        this.setMessage(this.tr("Finalizing Synchronization"));
        ++this.syncThreadsReady;
        this.syncRunning = false;
        this.syncRunner.syncNeeded = false;
        this.synchronizeAnimationTimer.stop();
        this.synchronizeButton.setIcon(new QIcon(String.valueOf(this.iconPath) + "synchronize.png"));
        this.saveNote();
        if (this.currentNote == null) {
            this.currentNote = this.conn.getNoteTable().getNote(this.currentNoteGuid, false, false, false, false, true);
        }
        this.listManager.refreshNoteMetadata();
        this.noteIndexUpdated(true);
        this.noteTableView.selectionModel().blockSignals(true);
        this.scrollToGuid(this.currentNoteGuid);
        this.noteTableView.selectionModel().blockSignals(false);
        this.refreshEvernoteNote(false);
        this.scrollToGuid(this.currentNoteGuid);
        this.waitCursor(false);
        if (this.syncRunner.error && this.syncRunner.errorSharedNotebooks.size() > 0) {
            String guid = this.syncRunner.errorSharedNotebooks.get(0);
            String notebookGuid = this.conn.getLinkedNotebookTable().getLocalNotebookGuid(guid);
            String localName = this.listManager.getNotebookNameByGuid(notebookGuid);
            SharedNotebookSyncError syncDialog = new SharedNotebookSyncError(localName);
            syncDialog.exec();
            if (syncDialog.okPressed()) {
                if (syncDialog.doNothing.isChecked()) {
                    this.syncRunner.errorSharedNotebooksIgnored.put(guid, guid);
                    this.evernoteSync();
                }
                if (syncDialog.deleteNotebook.isChecked()) {
                    this.conn.getNoteTable().expungeNotesByNotebook(notebookGuid, true, false);
                    this.conn.getNotebookTable().expungeNotebook(notebookGuid, false);
                    this.conn.getLinkedNotebookTable().expungeNotebook(guid, false);
                    this.conn.getLinkedNotebookTable().expungeNotebook(guid, false);
                    this.evernoteSync();
                }
                this.refreshLists();
                return;
            }
        }
        if (!this.syncRunner.error) {
            this.setMessage(this.tr("Synchronization Complete"));
        } else {
            this.setMessage(this.tr("Synchronization completed with errors.  Please check the log for details."));
        }
        this.logger.log(this.logger.MEDIUM, "Sync complete.");
    }

    public void saveUploadAmount(long t) {
        Global.saveUploadAmount(t);
    }

    public void saveUserInformation(User user) {
        Global.saveUserInformation(user);
    }

    public void saveEvernoteUpdateCount(int i) {
        Global.saveEvernoteUpdateCount(i);
    }

    public void refreshLists() {
        this.logger.log(this.logger.EXTREME, "Entering NeverNote.refreshLists");
        this.updateQuotaBar();
        Set<Integer> tabIndex = this.noteDirty.keySet();
        Iterator indexIterator = tabIndex.iterator();
        HashMap<Integer, Note> saveNotes = new HashMap<Integer, Note>();
        HashMap<Integer, String> saveContents = new HashMap<Integer, String>();
        for (boolean isNoteDirty : this.noteDirty.values()) {
            int index = (Integer)indexIterator.next();
            if (!isNoteDirty) continue;
            saveNotes.put(index, this.tabWindows.get(index).getBrowserWindow().getNote());
            saveContents.put(index, this.tabWindows.get(index).getBrowserWindow().getContent());
        }
        this.listManager.saveUpdatedNotes(saveNotes, saveContents);
        this.listManager.refreshLists();
        this.tagIndexUpdated(true);
        this.notebookIndexUpdated();
        this.savedSearchIndexUpdated();
        this.listManager.loadNotesIndex();
        this.noteTableView.selectionModel().blockSignals(true);
        this.noteIndexUpdated(true);
        this.noteTableView.selectionModel().blockSignals(false);
        this.logger.log(this.logger.EXTREME, "Leaving NeverNote.refreshLists");
    }

    private void authTimer() {
        Calendar cal = Calendar.getInstance();
        if (!Global.isConnected) {
            return;
        }
        this.syncRunner.authRefreshNeeded = true;
        this.syncStart();
    }

    private void authRefreshComplete(boolean goodSync) {
        this.logger.log(this.logger.EXTREME, "Entering NeverNote.authRefreshComplete");
        Global.isConnected = this.syncRunner.isConnected;
        if (goodSync) {
            this.authTimer.start(900000);
            this.logger.log(this.logger.LOW, "Authentication token has been renewed");
        } else {
            this.authTimer.start(300000);
            this.logger.log(this.logger.LOW, "Authentication token renew has failed - retry in 5 minutes.");
        }
        this.logger.log(this.logger.EXTREME, "Leaving NeverNote.authRefreshComplete");
    }

    private synchronized void indexTimer() {
        this.logger.log(this.logger.EXTREME, "Index timer activated.  Sync running=" + this.syncRunning);
        if (this.syncRunning) {
            return;
        }
        if (!this.indexDisabled && this.indexRunner.idle) {
            this.thumbnailRunner.interrupt = true;
            this.indexRunner.addWork("SCAN");
        }
        this.logger.log(this.logger.EXTREME, "Leaving NeighborNote index timer");
    }

    private void indexStarted() {
        this.setMessage(this.tr("Indexing notes"));
    }

    private void indexComplete() {
        this.setMessage(this.tr("Index complete"));
    }

    private synchronized void toggleNoteIndexing() {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.toggleIndexing");
        boolean bl = this.indexDisabled = !this.indexDisabled;
        if (!this.indexDisabled) {
            this.setMessage(this.tr("Indexing is now enabled."));
        } else {
            this.setMessage(this.tr("Indexing is now disabled."));
        }
        this.menuBar.disableIndexing.setChecked(this.indexDisabled);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.toggleIndexing");
    }

    private void threadMonitorCheck() {
        int MAX = 3;
        boolean alive = this.listManager.threadCheck(2);
        if (!alive) {
            ++this.tagDeadCount;
            if (this.tagDeadCount > MAX && !this.disableTagThreadCheck) {
                QMessageBox.information((QWidget)this, (String)this.tr("A thread has died."), (String)this.tr("It appears as the tag counter thread has died.  I recommend checking stopping NeighborNote, saving the logs for later viewing, and restarting.  Sorry."));
                this.disableTagThreadCheck = true;
            }
        } else {
            this.tagDeadCount = 0;
        }
        if (!(alive = this.listManager.threadCheck(6))) {
            ++this.notebookThreadDeadCount;
            if (this.notebookThreadDeadCount > MAX && !this.disableNotebookThreadCheck) {
                QMessageBox.information((QWidget)this, (String)this.tr("A thread has died."), (String)this.tr("It appears as the notebook counter thread has died.  I recommend checking stopping NeighborNote, saving the logs for later viewing, and restarting.  Sorry."));
                this.disableNotebookThreadCheck = true;
            }
        } else {
            this.notebookThreadDeadCount = 0;
        }
        if (!(alive = this.listManager.threadCheck(3))) {
            ++this.trashDeadCount;
            if (this.trashDeadCount > MAX && !this.disableTrashThreadCheck) {
                QMessageBox.information((QWidget)this, (String)this.tr("A thread has died."), (String)"It appears as the trash counter thread has died.  I recommend checking stopping NeighborNote, saving the logs for later viewing, and restarting.  Sorry.");
                this.disableTrashThreadCheck = true;
            }
        } else {
            this.trashDeadCount = 0;
        }
        if (!(alive = this.listManager.threadCheck(5))) {
            ++this.saveThreadDeadCount;
            if (this.saveThreadDeadCount > MAX && !this.disableSaveThreadCheck) {
                QMessageBox.information((QWidget)this, (String)this.tr("A thread has died."), (String)this.tr("It appears as the note saver thread has died.  I recommend checking stopping NeighborNote, saving the logs for later viewing, and restarting.  Sorry."));
                this.disableSaveThreadCheck = true;
            }
        } else {
            this.saveThreadDeadCount = 0;
        }
        if (!this.syncThread.isAlive()) {
            ++this.syncThreadDeadCount;
            if (this.syncThreadDeadCount > MAX && !this.disableSyncThreadCheck) {
                QMessageBox.information((QWidget)this, (String)this.tr("A thread has died."), (String)this.tr("It appears as the synchronization thread has died.  I recommend checking stopping NeighborNote, saving the logs for later viewing, and restarting.  Sorry."));
                this.disableSyncThreadCheck = true;
            }
        } else {
            this.syncThreadDeadCount = 0;
        }
        if (!this.indexThread.isAlive()) {
            ++this.indexThreadDeadCount;
            if (this.indexThreadDeadCount > MAX && !this.disableIndexThreadCheck) {
                QMessageBox.information((QWidget)this, (String)this.tr("A thread has died."), (String)this.tr("It appears as the index thread has died.  I recommend checking stopping NeighborNote, saving the logs for later viewing, and restarting.  Sorry."));
                this.disableIndexThreadCheck = true;
            }
        } else {
            this.indexThreadDeadCount = 0;
        }
        if (!this.rensoNoteListDock.getRensoNoteList().getEnRelatedNotesThread().isAlive()) {
            ++this.enRelatedNotesThreadDeadCount;
            if (this.enRelatedNotesThreadDeadCount > MAX && !this.disableENRelatedNotesThreadCheck) {
                QMessageBox.information((QWidget)this, (String)this.tr("A thread has died."), (String)this.tr("It appears as the Evernote Related Notes thread has died.  I recommend checking stopping NeighborNote, saving the logs for later viewing, and restarting.  Sorry."));
                this.disableENRelatedNotesThreadCheck = true;
            }
        } else {
            this.enRelatedNotesThreadDeadCount = 0;
        }
    }

    private void thumbnailTimer() {
        if (Global.enableThumbnails() && !this.syncRunning && this.indexRunner.idle) {
            this.thumbnailRunner.addWork("SCAN");
        }
    }

    private void databaseBackup() {
        QFileDialog fd = new QFileDialog((QWidget)this);
        fd.setFileMode(QFileDialog.FileMode.AnyFile);
        fd.setConfirmOverwrite(true);
        fd.setWindowTitle(this.tr("Backup Database"));
        fd.setFilter(this.tr("NixNote Export (*.nnex);;All Files (*.*)"));
        fd.setAcceptMode(QFileDialog.AcceptMode.AcceptSave);
        if (this.saveLastPath == null || this.saveLastPath.equals("")) {
            fd.setDirectory(System.getProperty("user.home"));
        } else {
            fd.setDirectory(this.saveLastPath);
        }
        if (fd.exec() == 0 || fd.selectedFiles().size() == 0) {
            return;
        }
        this.waitCursor(true);
        this.saveLastPath = (String)fd.selectedFiles().get(0);
        this.saveLastPath = this.saveLastPath.substring(0, this.saveLastPath.lastIndexOf("/"));
        this.setMessage(this.tr("Backing up database"));
        this.saveNote();
        ExportData noteWriter = new ExportData(this.conn, true);
        String fileName = (String)fd.selectedFiles().get(0);
        if (!fileName.endsWith(".nnex")) {
            fileName = String.valueOf(fileName) + ".nnex";
        }
        noteWriter.exportData(fileName);
        this.setMessage(this.tr("Database backup completed."));
        this.waitCursor(false);
    }

    private void databaseRestore() {
        if (QMessageBox.question((QWidget)this, (String)this.tr("Confirmation"), (String)this.tr("This is used to restore a database from backups.\nIt is HIGHLY recommened that this only be used to populate\nan empty database.  Restoring into a database that\n already has data can cause problems.\n\nAre you sure you want to continue?"), (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.No.value()) {
            return;
        }
        QFileDialog fd = new QFileDialog((QWidget)this);
        fd.setFileMode(QFileDialog.FileMode.ExistingFile);
        fd.setConfirmOverwrite(true);
        fd.setWindowTitle(this.tr("Restore Database"));
        fd.setFilter(this.tr("NixNote Export (*.nnex);;All Files (*.*)"));
        fd.setAcceptMode(QFileDialog.AcceptMode.AcceptOpen);
        if (this.saveLastPath == null || this.saveLastPath.equals("")) {
            fd.setDirectory(System.getProperty("user.home"));
        } else {
            fd.setDirectory(this.saveLastPath);
        }
        if (fd.exec() == 0 || fd.selectedFiles().size() == 0) {
            return;
        }
        this.waitCursor(true);
        this.saveLastPath = (String)fd.selectedFiles().get(0);
        this.saveLastPath = this.saveLastPath.substring(0, this.saveLastPath.lastIndexOf("/"));
        this.setMessage(this.tr("Restoring database"));
        ImportData noteReader = new ImportData(this.conn, true);
        noteReader.importData((String)fd.selectedFiles().get(0));
        if (noteReader.lastError != 0) {
            this.setMessage(noteReader.getErrorMessage());
            this.logger.log(this.logger.LOW, "Restore problem: " + noteReader.lastError);
            this.waitCursor(false);
            return;
        }
        this.listManager.loadNoteTitleColors();
        this.refreshLists();
        this.refreshEvernoteNote(true);
        this.setMessage(this.tr("Database has been restored."));
        this.waitCursor(false);
    }

    private void exportNotes() {
        QFileDialog fd = new QFileDialog((QWidget)this);
        fd.setFileMode(QFileDialog.FileMode.AnyFile);
        fd.setConfirmOverwrite(true);
        fd.setWindowTitle(this.tr("Backup Database"));
        fd.setFilter(this.tr("NixNote Export (*.nnex);;All Files (*.*)"));
        fd.setAcceptMode(QFileDialog.AcceptMode.AcceptSave);
        fd.setDirectory(System.getProperty("user.home"));
        if (fd.exec() == 0 || fd.selectedFiles().size() == 0) {
            return;
        }
        this.waitCursor(true);
        this.setMessage(this.tr("Exporting Notes"));
        this.saveNote();
        if (this.selectedNoteGUIDs.size() == 0 && !this.currentNoteGuid.equals("")) {
            this.selectedNoteGUIDs.add(this.currentNoteGuid);
        }
        ExportData noteWriter = new ExportData(this.conn, false, this.selectedNoteGUIDs);
        String fileName = (String)fd.selectedFiles().get(0);
        if (!fileName.endsWith(".nnex")) {
            fileName = String.valueOf(fileName) + ".nnex";
        }
        noteWriter.exportData(fileName);
        this.setMessage(this.tr("Export completed."));
        this.waitCursor(false);
    }

    private void importNotes() {
        String fileName;
        QFileDialog fd = new QFileDialog((QWidget)this);
        fd.setFileMode(QFileDialog.FileMode.ExistingFile);
        fd.setConfirmOverwrite(true);
        fd.setWindowTitle(this.tr("Import Notes"));
        fd.setFilter(this.tr("NixNote Export (*.nnex);;Evernote Export (*.enex);;All Files (*.*)"));
        fd.setAcceptMode(QFileDialog.AcceptMode.AcceptOpen);
        if (this.saveLastPath == null || this.saveLastPath.equals("")) {
            fd.setDirectory(System.getProperty("user.home"));
        } else {
            fd.setDirectory(this.saveLastPath);
        }
        if (fd.exec() == 0 || fd.selectedFiles().size() == 0) {
            return;
        }
        this.waitCursor(true);
        this.setMessage(this.tr("Importing Notes"));
        this.saveNote();
        if (this.selectedNoteGUIDs.size() == 0 && !this.currentNoteGuid.equals("")) {
            this.selectedNoteGUIDs.add(this.currentNoteGuid);
        }
        if ((fileName = (String)fd.selectedFiles().get(0)).endsWith(".nnex")) {
            ImportData noteReader = new ImportData(this.conn, false);
            if (this.selectedNotebookGUIDs != null && this.selectedNotebookGUIDs.size() > 0) {
                noteReader.setNotebookGuid(this.selectedNotebookGUIDs.get(0));
            } else {
                noteReader.setNotebookGuid(this.listManager.getNotebookIndex().get(0).getGuid());
            }
            noteReader.importData(fileName);
            if (noteReader.lastError != 0) {
                this.setMessage(noteReader.getErrorMessage());
                this.logger.log(this.logger.LOW, "Import problem: " + noteReader.lastError);
                this.waitCursor(false);
                return;
            }
        } else if (fileName.endsWith(".enex")) {
            ImportEnex noteReader = new ImportEnex(this.conn, false);
            if (this.selectedNotebookGUIDs != null && this.selectedNotebookGUIDs.size() > 0) {
                noteReader.setNotebookGuid(this.selectedNotebookGUIDs.get(0));
            } else {
                noteReader.setNotebookGuid(this.listManager.getNotebookIndex().get(0).getGuid());
            }
            this.waitCursor(false);
            noteReader.createNewTags = QMessageBox.question((QWidget)this, (String)this.tr("Confirmation"), (String)this.tr("Create new tags from import?"), (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.Yes.value();
            this.waitCursor(true);
            noteReader.importData(fileName);
            if (noteReader.lastError != 0) {
                this.setMessage(noteReader.getErrorMessage());
                this.logger.log(this.logger.LOW, "Import problem: " + noteReader.lastError);
                this.waitCursor(false);
                return;
            }
        }
        this.listManager.loadNoteTitleColors();
        this.refreshLists();
        this.refreshEvernoteNote(false);
        this.setMessage(this.tr("Notes have been imported."));
        this.waitCursor(false);
        this.setMessage(this.tr("Import completed."));
        this.waitCursor(false);
    }

    private void duplicateNote() {
        this.saveNote();
        this.duplicateNote(this.currentNoteGuid);
    }

    private void copyAsUrlClicked() {
        String selectedGuid;
        SortedMap ix;
        QModelIndex index;
        int row;
        QClipboard clipboard = QApplication.clipboard();
        QMimeData mime = new QMimeData();
        mime.setText(this.currentNoteGuid);
        ArrayList<QUrl> urls = new ArrayList<QUrl>();
        User user = Global.getUserInformation();
        if ((user.getShardId().equals("") || user.getId() == 0) && !Global.bypassSynchronizationWarning()) {
            SynchronizationRequiredWarning warning = new SynchronizationRequiredWarning((QWidget)this);
            warning.exec();
            if (!warning.neverSynchronize()) {
                return;
            }
            Global.setBypassSynchronizationWarning(true);
            user.setShardId("s0");
            user.setId(0);
        }
        this.noteTableView.showColumn(Global.noteTableGuidPosition);
        List selections = this.noteTableView.selectionModel().selectedRows();
        if (!Global.isColumnVisible("guid")) {
            this.noteTableView.hideColumn(Global.noteTableGuidPosition);
        }
        int i = 0;
        while (i < selections.size()) {
            row = ((QModelIndex)selections.get(i)).row();
            index = this.noteTableView.proxyModel.index(row, Global.noteTableGuidPosition);
            ix = this.noteTableView.proxyModel.itemData(index);
            selectedGuid = (String)ix.values().toArray()[0];
            Note n = this.conn.getNoteTable().getNote(selectedGuid, false, false, false, false, false);
            if (n.getUpdateSequenceNum() == 0 && !this.conn.getNotebookTable().isNotebookLocal(n.getNotebookGuid())) {
                QMessageBox.critical((QWidget)this, (String)this.tr("Please Synchronize"), (String)this.tr("Please either synchronize or move any new notes to a local notebook."));
                return;
            }
            ++i;
        }
        i = 0;
        while (i < selections.size()) {
            String lid;
            String gid;
            row = ((QModelIndex)selections.get(i)).row();
            index = this.noteTableView.proxyModel.index(row, Global.noteTableGuidPosition);
            ix = this.noteTableView.proxyModel.itemData(index);
            selectedGuid = (String)ix.values().toArray()[0];
            mime.setText(selectedGuid);
            Note selectedNote = this.conn.getNoteTable().getNote(selectedGuid, false, false, false, false, false);
            if (selectedNote.getUpdateSequenceNum() > 0) {
                gid = selectedGuid;
                lid = selectedGuid;
            } else {
                gid = "00000000-0000-0000-0000-000000000000";
                lid = selectedGuid;
            }
            String url = String.valueOf(new String("evernote://///view/")) + new String(String.valueOf(user.getId()) + "/" + user.getShardId() + "/" + gid + "/" + lid + "/");
            urls.add(new QUrl(url));
            ++i;
        }
        mime.setUrls(urls);
        clipboard.setMimeData(mime);
    }

    public void setupFolderImports() {
        int i;
        List<WatchFolderRecord> records = this.conn.getWatchFolderTable().getAll();
        if (this.importKeepWatcher == null) {
            this.importKeepWatcher = new QFileSystemWatcher();
        }
        if (this.importDeleteWatcher == null) {
            this.importDeleteWatcher = new QFileSystemWatcher();
            i = 0;
            while (i < records.size()) {
                if (!records.get((int)i).keep) {
                    this.folderImportDelete(records.get((int)i).folder);
                }
                ++i;
            }
        }
        i = 0;
        while (i < records.size()) {
            this.logger.log(this.logger.LOW, "Adding file monitor: " + records.get((int)i).folder);
            if (records.get((int)i).keep) {
                this.importKeepWatcher.addPath(records.get((int)i).folder);
            } else {
                this.importDeleteWatcher.addPath(records.get((int)i).folder);
            }
            ++i;
        }
        this.logger.log(this.logger.EXTREME, "List of directories being watched (kept)...");
        List monitorDelete = this.importKeepWatcher.directories();
        int i2 = 0;
        while (i2 < monitorDelete.size()) {
            this.logger.log(this.logger.EXTREME, (String)monitorDelete.get(i2));
            ++i2;
        }
        this.logger.log(this.logger.EXTREME, "<end of list>");
        this.logger.log(this.logger.EXTREME, "List of directories being watched (delete)...");
        monitorDelete = this.importDeleteWatcher.directories();
        i2 = 0;
        while (i2 < monitorDelete.size()) {
            this.logger.log(this.logger.EXTREME, (String)monitorDelete.get(i2));
            ++i2;
        }
        this.logger.log(this.logger.EXTREME, "<end of list>");
        this.importKeepWatcher.directoryChanged.connect((Object)this, "folderImportKeep(String)");
        this.importDeleteWatcher.directoryChanged.connect((Object)this, "folderImportDelete(String)");
        if (this.importedFiles == null) {
            this.importedFiles = new ArrayList<String>();
            int j = 0;
            while (j < records.size()) {
                QDir dir = new QDir(records.get((int)j).folder);
                List list = dir.entryInfoList();
                int k = 0;
                while (k < list.size()) {
                    if (((QFileInfo)list.get(k)).isFile()) {
                        this.importedFiles.add(((QFileInfo)list.get(k)).absoluteFilePath());
                    }
                    ++k;
                }
                ++j;
            }
        }
    }

    public void folderImport() {
        List<WatchFolderRecord> recs = this.conn.getWatchFolderTable().getAll();
        WatchFolder dialog = new WatchFolder(recs, this.listManager.getNotebookIndex());
        dialog.exec();
        if (!dialog.okClicked()) {
            return;
        }
        if (this.importKeepWatcher.directories().size() > 0) {
            this.importKeepWatcher.removePaths(this.importKeepWatcher.directories());
        }
        if (this.importDeleteWatcher.directories().size() > 0) {
            this.importDeleteWatcher.removePaths(this.importDeleteWatcher.directories());
        }
        this.conn.getWatchFolderTable().expungeAll();
        int i = 0;
        while (i < dialog.table.rowCount()) {
            QTableWidgetItem item = dialog.table.item(i, 0);
            String dir = item.text();
            item = dialog.table.item(i, 1);
            String notebook = item.text();
            item = dialog.table.item(i, 2);
            boolean keep = item.text().equalsIgnoreCase("Keep");
            String guid = this.conn.getNotebookTable().findNotebookByName(notebook);
            this.conn.getWatchFolderTable().addWatchFolder(dir, guid, keep, 0);
            ++i;
        }
        this.setupFolderImports();
    }

    public void folderImportKeep(String dirName) throws NoSuchAlgorithmException {
        this.logger.log(this.logger.LOW, "Inside folderImportKeep");
        String whichOS = System.getProperty("os.name");
        if (whichOS.contains("Windows")) {
            dirName = dirName.replace('/', '\\');
        }
        FileImporter importer = new FileImporter(this.logger, this.conn);
        QDir dir = new QDir(dirName);
        List list = dir.entryInfoList();
        String notebook = this.conn.getWatchFolderTable().getNotebook(dirName);
        int i = 0;
        while (i < list.size()) {
            this.logger.log(this.logger.LOW, "File found: " + ((QFileInfo)list.get(i)).fileName());
            boolean redundant = false;
            int j = 0;
            while (j < this.importedFiles.size()) {
                this.logger.log(this.logger.LOW, "redundant file list: " + ((QFileInfo)list.get(i)).absoluteFilePath());
                if (this.importedFiles.get(j).equals(((QFileInfo)list.get(i)).absoluteFilePath())) {
                    redundant = true;
                }
                ++j;
            }
            this.logger.log(this.logger.LOW, "Checking if redundant: " + redundant);
            if (!redundant) {
                importer.setFileInfo((QFileInfo)list.get(i));
                importer.setFileName(((QFileInfo)list.get(i)).absoluteFilePath());
                this.logger.log(this.logger.LOW, "File importing is a file: " + ((QFileInfo)list.get(i)).isFile());
                this.logger.log(this.logger.LOW, "File importing is a valid: " + importer.isValidType());
                if (((QFileInfo)list.get(i)).isFile() && importer.isValidType()) {
                    if (!importer.importFile()) {
                        this.logger.log(this.logger.LOW, "Unable to save externally edited file.  Saving for later.");
                        this.importFilesKeep.add(((QFileInfo)list.get(i)).absoluteFilePath());
                    } else {
                        Note newNote = importer.getNote();
                        newNote.setNotebookGuid(notebook);
                        newNote.setTitle(dir.at(i));
                        NoteMetadata metadata = new NoteMetadata();
                        metadata.setDirty(true);
                        metadata.setGuid(newNote.getGuid());
                        this.listManager.addNote(newNote, metadata);
                        this.conn.getNoteTable().addNote(newNote, true);
                        this.noteTableView.insertRow(newNote, metadata, true, -1);
                        this.listManager.updateNoteContent(newNote.getGuid(), importer.getNoteContent());
                        this.listManager.countNotebookResults(this.listManager.getNoteIndex());
                        this.importedFiles.add(((QFileInfo)list.get(i)).absoluteFilePath());
                    }
                }
            }
            ++i;
        }
    }

    public void folderImportDelete(String dirName) {
        this.logger.log(this.logger.LOW, "Inside folderImportDelete");
        String whichOS = System.getProperty("os.name");
        if (whichOS.contains("Windows")) {
            dirName = dirName.replace('/', '\\');
        }
        FileImporter importer = new FileImporter(this.logger, this.conn);
        QDir dir = new QDir(dirName);
        List list = dir.entryInfoList();
        String notebook = this.conn.getWatchFolderTable().getNotebook(dirName);
        int i = 0;
        while (i < list.size()) {
            this.logger.log(this.logger.LOW, "File found: " + ((QFileInfo)list.get(i)).fileName());
            importer.setFileInfo((QFileInfo)list.get(i));
            importer.setFileName(((QFileInfo)list.get(i)).absoluteFilePath());
            this.logger.log(this.logger.LOW, "File importing is a file: " + ((QFileInfo)list.get(i)).isFile());
            this.logger.log(this.logger.LOW, "File importing is a valid: " + importer.isValidType());
            if (((QFileInfo)list.get(i)).isFile() && importer.isValidType()) {
                if (!importer.importFile()) {
                    this.logger.log(this.logger.LOW, "Unable to save externally edited file.  Saving for later.");
                    this.importFilesKeep.add(((QFileInfo)list.get(i)).absoluteFilePath());
                } else {
                    Note newNote = importer.getNote();
                    newNote.setNotebookGuid(notebook);
                    newNote.setTitle(dir.at(i));
                    NoteMetadata metadata = new NoteMetadata();
                    metadata.setDirty(true);
                    metadata.setGuid(newNote.getGuid());
                    this.listManager.addNote(newNote, metadata);
                    this.conn.getNoteTable().addNote(newNote, true);
                    this.noteTableView.insertRow(newNote, metadata, true, -1);
                    this.listManager.updateNoteContent(newNote.getGuid(), importer.getNoteContent());
                    this.listManager.countNotebookResults(this.listManager.getNoteIndex());
                    dir.remove(dir.at(i));
                }
            }
            ++i;
        }
    }

    private void externalFileEdited(String fileName) throws NoSuchAlgorithmException {
        QFile file;
        this.logger.log(this.logger.HIGH, "Entering exernalFileEdited");
        String dPath = FileUtils.toForwardSlashedPath(Global.getFileManager().getResDirPath());
        String name = fileName.replace(dPath, "");
        int pos = name.lastIndexOf(46);
        String guid = name;
        if (pos > -1) {
            guid = guid.substring(0, pos);
        }
        if ((pos = name.lastIndexOf(Global.attachmentNameDelimeter)) > -1) {
            guid = name.substring(0, pos);
        }
        if (!(file = new QFile(fileName)).open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly}))) {
            this.logger.log(this.logger.LOW, "Unable to save externally edited file.  Saving for later.");
            this.externalFiles.add(fileName);
            return;
        }
        QByteArray binData = file.readAll();
        file.close();
        if (binData.size() == 0) {
            this.logger.log(this.logger.LOW, "Unable to save externally edited file.  Saving for later.");
            this.externalFiles.add(fileName);
            return;
        }
        Resource r = this.conn.getNoteTable().noteResourceTable.getNoteResource(guid, true);
        if (r == null) {
            r = this.conn.getNoteTable().noteResourceTable.getNoteResource(Global.resourceMap.get(guid), true);
        }
        if (r == null || r.getData() == null || r.getData().getBody() == null) {
            return;
        }
        String oldHash = Global.byteArrayToHexString(r.getData().getBodyHash());
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(binData.toByteArray());
        byte[] hash = md.digest();
        String newHash = Global.byteArrayToHexString(hash);
        if (r.getNoteGuid().equalsIgnoreCase(this.currentNoteGuid)) {
            this.updateResourceContentHash(this.browserWindow, r.getGuid(), oldHash, newHash);
        }
        if (this.externalWindows.containsKey(r.getNoteGuid())) {
            this.updateResourceContentHash(this.externalWindows.get(r.getNoteGuid()).getBrowserWindow(), r.getGuid(), oldHash, newHash);
        }
        this.conn.getNoteTable().updateResourceContentHash(r.getNoteGuid(), oldHash, newHash);
        Data data = r.getData();
        data.setBody(binData.toByteArray());
        data.setBodyHash(hash);
        this.logger.log(this.logger.LOW, "externalFileEdited: " + data.getSize() + " bytes");
        r.setData(data);
        this.conn.getNoteTable().noteResourceTable.updateNoteResource(r, true);
        if (r.getNoteGuid().equals(this.currentNoteGuid)) {
            QWebSettings.setMaximumPagesInCache((int)0);
            QWebSettings.setObjectCacheCapacities((int)0, (int)0, (int)0);
            this.refreshEvernoteNote(true);
            this.browserWindow.getBrowser().triggerPageAction(QWebPage.WebAction.Reload);
        }
        if (this.externalWindows.containsKey(r.getNoteGuid())) {
            QWebSettings.setMaximumPagesInCache((int)0);
            QWebSettings.setObjectCacheCapacities((int)0, (int)0, (int)0);
            this.externalWindows.get(r.getNoteGuid()).getBrowserWindow().getBrowser().triggerPageAction(QWebPage.WebAction.Reload);
        }
        this.logger.log(this.logger.HIGH, "Exiting externalFielEdited");
    }

    public void externalFileEditedSaver() {
        int i = this.externalFiles.size() - 1;
        while (i >= 0) {
            try {
                this.logger.log(this.logger.MEDIUM, "Trying to save " + this.externalFiles.get(i));
                this.externalFileEdited(this.externalFiles.get(i));
                this.externalFiles.remove(i);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            --i;
        }
        i = 0;
        while (i < this.importFilesKeep.size()) {
            try {
                this.logger.log(this.logger.MEDIUM, "Trying to save " + this.importFilesKeep.get(i));
                this.folderImportKeep(this.importFilesKeep.get(i));
                this.importFilesKeep.remove(i);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < this.importFilesDelete.size()) {
            this.logger.log(this.logger.MEDIUM, "Trying to save " + this.importFilesDelete.get(i));
            this.folderImportDelete(this.importFilesDelete.get(i));
            this.importFilesDelete.remove(i);
            ++i;
        }
    }

    public void updateResourceContentHash(BrowserWindow browser, String guid, String oldHash, String newHash) {
        int position = this.browserWindow.getContent().indexOf("en-tag=\"en-media\" guid=\"" + guid + "\" type=");
        while (position > -1) {
            int hashEnd;
            int hashPos;
            int endPos = browser.getContent().indexOf(">", position + 1);
            String oldSegment = browser.getContent().substring(position, endPos);
            String hash = oldSegment.substring((hashPos = oldSegment.indexOf("hash=\"")) + 6, hashEnd = oldSegment.indexOf("\"", hashPos + 7));
            if (hash.equalsIgnoreCase(oldHash)) {
                String newSegment = oldSegment.replace(oldHash, newHash);
                String content = String.valueOf(browser.getContent().substring(0, position)) + newSegment + browser.getContent().substring(endPos);
                browser.setContent(new QByteArray(content));
            }
            position = browser.getContent().indexOf("en-tag=\"en-media\" guid=\"" + guid + "\" type=", position + 1);
        }
    }

    public void changeEvent(QEvent e) {
        if (e.type() == QEvent.Type.WindowStateChange && QSystemTrayIcon.isSystemTrayAvailable()) {
            if (this.isMinimized() && (Global.showTrayIcon() || Global.showTrayIcon())) {
                e.accept();
                QTimer.singleShot((int)10, (QObject)this, (String)"hide()");
                return;
            }
            this.windowMaximized = this.isMaximized();
        }
    }

    private static boolean databaseCheck(String url, String userid, String userPassword, String cypherPassword) {
        Connection connection;
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
            System.exit(16);
        }
        try {
            String passwordString = null;
            passwordString = cypherPassword == null || cypherPassword.trim().equals("") ? userPassword : String.valueOf(cypherPassword) + " " + userPassword;
            connection = DriverManager.getConnection(url, userid, passwordString);
        }
        catch (SQLException e) {
            return false;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void viewSource() {
        int i = 0;
        while (i < this.tabBrowser.count()) {
            BrowserWindow browser = ((TabBrowse)this.tabBrowser.widget(i)).getBrowserWindow();
            browser.showSource(this.menuBar.viewSource.isChecked());
            ++i;
        }
    }

    private void blockApplication(BrowserWindow b) {
        this.waitCursor(true);
        this.blockSignals(true);
        this.blockTimer = new QTimer();
        this.blockTimer.setSingleShot(true);
        this.blockTimer.setInterval(15000);
        this.blockTimer.timeout.connect((Object)this, "unblockApplication()");
        this.blockingWindow = b;
        this.blockTimer.start();
    }

    private void unblockApplication() {
        this.waitCursor(false);
        if (this.blockingWindow != null && new GregorianCalendar().getTimeInMillis() > this.blockingWindow.unblockTime && this.blockingWindow.unblockTime != -1L) {
            QMessageBox.critical(null, (String)this.tr("No Response from CodeCogs"), (String)this.tr("Unable to contact CodeCogs for LaTeX formula."));
            this.blockingWindow.unblockTime = -1L;
            this.blockingWindow.awaitingHttpResponse = false;
        }
        this.blockingWindow = null;
        this.blockSignals(false);
    }

    private void tabWindowChanged(int index) {
        if (index < 0 || index >= this.tabBrowser.count()) {
            return;
        }
        this.saveNote();
        TabBrowse tab = (TabBrowse)this.tabBrowser.widget(index);
        if (tab.getBrowserWindow().getNote() != null) {
            this.currentNoteGuid = tab.getBrowserWindow().getNote().getGuid();
            this.currentNote = tab.getBrowserWindow().getNote();
        } else {
            this.currentNoteGuid = "";
            this.currentNote = null;
        }
        this.selectedNoteGUIDs.clear();
        if (this.currentNoteGuid != null && !this.currentNoteGuid.equals("")) {
            this.selectedNoteGUIDs.add(this.currentNoteGuid);
        }
        this.browserWindow.noteSignal.noteChanged.disconnect((Object)this, "setNoteDirty()");
        this.browserWindow.focusLost.disconnect((Object)this, "saveNote()");
        this.browserWindow = tab.getBrowserWindow();
        this.browserWindow.noteSignal.noteChanged.connect((Object)this, "setNoteDirty()");
        this.browserWindow.focusLost.connect((Object)this, "saveNote()");
        this.menuBar.refreshTargetWindow();
        boolean nextIsActive = tab.getBrowserWindow().getNote() != null ? tab.getBrowserWindow().getNote().isActive() : true;
        if (Global.showDeleted && nextIsActive) {
            this.switchNoteTable(false);
        } else if (!Global.showDeleted && !nextIsActive) {
            this.switchNoteTable(true);
        }
        this.noteTableView.selectionModel().selectionChanged.disconnect((Object)this, "noteTableSelection()");
        this.scrollToGuid(this.currentNoteGuid);
        this.noteTableView.selectionModel().selectionChanged.connect((Object)this, "noteTableSelection()");
        this.menuBar.noteDuplicateAction.setEnabled(true);
        this.menuBar.noteOnlineHistoryAction.setEnabled(true);
        this.menuBar.noteMergeAction.setEnabled(true);
        if (Global.showDeleted) {
            this.menuBar.noteDuplicateAction.setEnabled(false);
        }
        if (!Global.isConnected) {
            this.menuBar.noteOnlineHistoryAction.setEnabled(false);
        }
        this.menuBar.noteMergeAction.setEnabled(false);
        try {
            int row = ((QModelIndex)this.noteTableView.selectionModel().selectedRows().get(0)).row();
            if (row == 0) {
                this.upButton.setEnabled(false);
            } else {
                this.upButton.setEnabled(true);
            }
            if (row < this.listManager.getNoteTableModel().rowCount() - 1) {
                this.downButton.setEnabled(true);
            } else {
                this.downButton.setEnabled(false);
            }
        }
        catch (Exception e) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
        int currentIndex = this.tabBrowser.currentIndex();
        ArrayList<String> histGuids = this.historyGuids.get(currentIndex);
        int histPosition = this.historyPosition.get(currentIndex);
        this.nextButton.setEnabled(true);
        this.prevButton.setEnabled(true);
        if (histPosition <= 1) {
            this.prevButton.setEnabled(false);
        }
        if (histPosition == histGuids.size()) {
            this.nextButton.setEnabled(false);
        }
        this.refreshEvernoteNote(true);
        this.rensoNoteListDock.getRensoNoteList().refreshRensoNoteList(this.currentNoteGuid);
    }

    private void switchNoteTable(boolean toDeleted) {
        this.clearNotebookFilter();
        this.clearTagFilter();
        this.clearAttributeFilter();
        this.clearSavedSearchFilter();
        this.listManager.getSelectedNotebooks().clear();
        this.listManager.getSelectedTags().clear();
        this.listManager.setSelectedSavedSearch("");
        this.newButton.setEnabled(!this.newButton.isEnabled());
        this.menuBar.noteAdd.setEnabled(this.newButton.isEnabled());
        this.menuBar.noteAddNewTab.setEnabled(this.newButton.isEnabled());
        if (this.currentNoteGuid == null || this.currentNoteGuid.equals("")) {
            this.menuBar.noteAddNewTab.setEnabled(false);
        }
        this.menuBar.noteAdd.setVisible(true);
        if (!toDeleted) {
            this.trashTree.itemSelectionChanged.disconnect((Object)this, "trashTreeSelection()");
            this.trashTree.clearSelection();
            this.trashTree.itemSelectionChanged.connect((Object)this, "trashTreeSelection()");
            Global.showDeleted = false;
            this.menuBar.noteRestoreAction.setEnabled(false);
            this.menuBar.noteRestoreAction.setVisible(false);
            this.rensoNoteListDock.setEnabled(true);
        } else {
            this.trashTree.itemSelectionChanged.disconnect((Object)this, "trashTreeSelection()");
            this.trashTree.setCurrentItem(this.trashTree.getTrashItem());
            this.trashTree.itemSelectionChanged.connect((Object)this, "trashTreeSelection()");
            Global.showDeleted = true;
            this.menuBar.noteRestoreAction.setEnabled(true);
            this.menuBar.noteRestoreAction.setVisible(true);
            this.rensoNoteListDock.setEnabled(false);
        }
        this.listManager.loadNotesIndex();
        this.noteTableView.selectionModel().selectionChanged.disconnect((Object)this, "noteTableSelection()");
        this.noteIndexUpdated(false);
        this.noteTableView.selectionModel().selectionChanged.connect((Object)this, "noteTableSelection()");
        this.browserWindow.setReadOnly(!this.newButton.isEnabled());
    }

    private void rensoNoteItemPressed(QListWidgetItem current) {
        this.logger.log(this.logger.HIGH, "Nevernote.rensoNoteSelectionChange\u306b\u5165\u3063\u305f");
        this.rensoNotePressedItemGuid = this.rensoNoteListDock.getRensoNoteList().getNoteGuid(current);
        if (QApplication.mouseButtons().isSet((QtEnumerator[])new Qt.MouseButton[]{Qt.MouseButton.RightButton})) {
            return;
        }
        this.saveNote();
        String prevCurrentNoteGuid = new String(this.currentNoteGuid);
        int i = 0;
        while (i < this.noteTableView.model().rowCount()) {
            SortedMap ix;
            String tableGuid;
            QModelIndex modelIndex = this.noteTableView.model().index(i, Global.noteTableGuidPosition);
            if (modelIndex != null && (tableGuid = (String)(ix = this.noteTableView.model().itemData(modelIndex)).values().toArray()[0]).equals(this.rensoNotePressedItemGuid)) {
                this.noteTableView.selectRow(i);
                break;
            }
            ++i;
        }
        this.conn.getHistoryTable().addHistory("rensoItemClick", prevCurrentNoteGuid, this.currentNoteGuid);
        this.logger.log(this.logger.HIGH, "Nevernote.rensoNoteSelectionChange\u3092\u51fa\u305f");
    }

    private void excludeNote() {
        if (this.rensoNotePressedItemGuid != null) {
            this.saveNote();
            this.excludeNote(this.rensoNotePressedItemGuid);
        }
    }

    private void excludeNote(String guid) {
        if (Global.verifyExclude()) {
            Note note = this.conn.getNoteTable().getNote(guid, false, false, false, false, false);
            String title = note.getTitle();
            String msg = title != null ? new String(String.valueOf(this.tr("Exclude note \"")) + title + "\"?") : new String(this.tr("Exclude note selected note?"));
            if (QMessageBox.question((QWidget)this, (String)this.tr("Confirmation"), (String)msg, (QMessageBox.StandardButton)QMessageBox.StandardButton.Yes, (QMessageBox.StandardButton)QMessageBox.StandardButton.No) == QMessageBox.StandardButton.No.value() && Global.verifyDelete()) {
                return;
            }
        }
        this.conn.getHistoryTable().expungeHistory(guid, this.currentNoteGuid);
        this.conn.getExcludedTable().addExclusion(guid, this.currentNoteGuid);
        this.rensoNoteListDock.getRensoNoteList().refreshRensoNoteList(this.currentNoteGuid);
    }

    private void starNote() {
        if (this.rensoNotePressedItemGuid != null) {
            this.saveNote();
            this.starNote(this.rensoNotePressedItemGuid);
        }
    }

    private void starNote(String guid) {
        this.conn.getStaredTable().addStaredItem(this.currentNoteGuid, guid);
        this.rensoNoteListDock.getRensoNoteList().refreshRensoNoteList(this.currentNoteGuid);
    }

    private void unstarNote() {
        if (this.rensoNotePressedItemGuid != null) {
            this.saveNote();
            this.unstarNote(this.rensoNotePressedItemGuid);
        }
    }

    private void unstarNote(String guid) {
        this.conn.getStaredTable().removeStaredItem(this.currentNoteGuid, guid);
        this.rensoNoteListDock.getRensoNoteList().refreshRensoNoteList(this.currentNoteGuid);
    }

    public String getCurrentNoteGuid() {
        return this.currentNoteGuid;
    }

    private void tabIndexChanged(int from, int to) {
        TabBrowse tab = this.tabWindows.get(from);
        this.tabWindows.put(from, this.tabWindows.get(to));
        this.tabWindows.put(to, tab);
        boolean isNoteDirty = this.noteDirty.get(from);
        this.noteDirty.put(from, this.noteDirty.get(to));
        this.noteDirty.put(to, isNoteDirty);
        boolean isInkNote = this.inkNote.get(from);
        this.inkNote.put(from, this.inkNote.get(to));
        this.inkNote.put(to, isInkNote);
        boolean isReadOnly = this.readOnly.get(from);
        this.readOnly.put(from, this.readOnly.get(to));
        this.readOnly.put(to, isReadOnly);
        ArrayList<String> histGuids = this.historyGuids.get(from);
        this.historyGuids.put(from, this.historyGuids.get(to));
        this.historyGuids.put(to, histGuids);
        int histPosition = this.historyPosition.get(from);
        this.historyPosition.put(from, this.historyPosition.get(to));
        this.historyPosition.put(to, histPosition);
        boolean fromHist = this.fromHistory.get(from);
        this.fromHistory.put(from, this.fromHistory.get(to));
        this.fromHistory.put(to, fromHist);
    }

    public RensoNoteList getRensoNoteList() {
        return this.rensoNoteListDock.getRensoNoteList();
    }
}

