/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.xml;

import com.evernote.edam.type.Note;
import com.evernote.edam.type.Resource;
import com.trolltech.qt.QtEnumerator;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QDataStream;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QTemporaryFile;
import com.trolltech.qt.core.QTextCodec;
import com.trolltech.qt.core.QUrl;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QPaintDeviceInterface;
import com.trolltech.qt.gui.QPainter;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.xml.QDomAttr;
import com.trolltech.qt.xml.QDomDocument;
import com.trolltech.qt.xml.QDomElement;
import com.trolltech.qt.xml.QDomNode;
import com.trolltech.qt.xml.QDomNodeList;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.config.FileManager;
import cx.fbn.nevernote.filters.EnSearch;
import cx.fbn.nevernote.gui.PDFPreview;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.xml.XMLInsertHilight;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.tidy.Tidy;
import org.w3c.tidy.TidyMessage;
import org.w3c.tidy.TidyMessageListener;

public class NoteFormatter {
    private final ApplicationLogger logger;
    private final DatabaseConnection conn;
    public boolean resourceError = false;
    public boolean readOnly = false;
    public boolean inkNote = false;
    public boolean addHighlight = true;
    private Note currentNote;
    private String currentNoteGuid;
    private boolean pdfPreview;
    ArrayList<QTemporaryFile> tempFiles;
    private EnSearch enSearch;
    private boolean noteHistory;
    public boolean formatError;

    public NoteFormatter(ApplicationLogger logger, DatabaseConnection conn, List<QTemporaryFile> tempFiles2) {
        this.logger = logger;
        this.conn = conn;
        this.noteHistory = false;
    }

    public void setNote(Note note, boolean pdfPreview) {
        this.currentNote = note;
        this.pdfPreview = pdfPreview;
        this.readOnly = false;
        this.currentNoteGuid = null;
        if (note != null) {
            this.currentNoteGuid = note.getGuid();
            this.readOnly = this.conn.getNotebookTable().isReadOnly(note.getNotebookGuid());
        }
        this.resourceError = false;
    }

    public void setHighlight(EnSearch search) {
        if (search == null || search.hilightWords == null || search.hilightWords.size() == 0) {
            this.enSearch = null;
            this.addHighlight = false;
        } else {
            this.enSearch = search;
            this.addHighlight = true;
        }
    }

    public void setNoteHistory(boolean value) {
        this.noteHistory = value;
    }

    public String rebuildNoteHTML() {
        this.formatError = false;
        if (this.currentNote == null) {
            return null;
        }
        this.logger.log(this.logger.HIGH, "Entering NeverNote.rebuildNoteHTML");
        this.logger.log(this.logger.EXTREME, "Note guid: " + this.currentNoteGuid);
        this.logger.log(this.logger.EXTREME, "Note Text:" + this.currentNote);
        QDomDocument doc = new QDomDocument();
        QDomDocument.Result result = doc.setContent(this.currentNote.getContent());
        if (!result.success) {
            this.logger.log(this.logger.LOW, "Error parsing document.  Attempting to restructure");
            Tidy tidy = new Tidy();
            TidyListener tidyListener = new TidyListener(this.logger);
            tidy.setMessageListener((TidyMessageListener)tidyListener);
            tidy.getStderr().close();
            tidy.setXmlTags(true);
            QTextCodec codec = QTextCodec.codecForName((String)"UTF-8");
            QByteArray unicode = codec.fromUnicode(this.currentNote.getContent());
            this.logger.log(this.logger.MEDIUM, "Starting JTidy check");
            this.logger.log(this.logger.MEDIUM, "Start of JTidy Input");
            this.logger.log(this.logger.MEDIUM, this.currentNote.getContent());
            this.logger.log(this.logger.MEDIUM, "End Of JTidy Input");
            ByteArrayInputStream is = new ByteArrayInputStream(unicode.toByteArray());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            tidy.setInputEncoding("UTF-8");
            tidy.parse((InputStream)is, (OutputStream)os);
            String tidyContent = os.toString();
            if (tidyListener.errorFound) {
                this.logger.log(this.logger.LOW, "Restructure failed!!!");
            } else {
                doc = null;
                doc = new QDomDocument();
                result = doc.setContent(tidyContent);
            }
        }
        if (!result.success) {
            this.logger.log(this.logger.MEDIUM, "Parse error when rebuilding XML to HTML");
            this.logger.log(this.logger.MEDIUM, "Note guid: " + this.currentNoteGuid);
            this.logger.log(this.logger.MEDIUM, "Error: " + result.errorMessage);
            this.logger.log(this.logger.MEDIUM, "Line: " + result.errorLine + " Column: " + result.errorColumn);
            System.out.println("Error: " + result.errorMessage);
            System.out.println("Line: " + result.errorLine + " Column: " + result.errorColumn);
            this.logger.log(this.logger.EXTREME, "**** Start of unmodified note HTML");
            this.logger.log(this.logger.EXTREME, this.currentNote.getContent());
            this.logger.log(this.logger.EXTREME, "**** End of unmodified note HTML");
            this.formatError = true;
            this.readOnly = true;
            return this.currentNote.getContent();
        }
        if (this.tempFiles == null) {
            this.tempFiles = new ArrayList();
        }
        this.tempFiles.clear();
        doc = this.modifyTags(doc);
        if (this.addHighlight) {
            doc = this.addHilight(doc);
        }
        QDomElement docElem = doc.documentElement();
        docElem.setTagName("Body");
        this.logger.log(this.logger.EXTREME, "Rebuilt HTML:");
        this.logger.log(this.logger.EXTREME, doc.toString());
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.rebuildNoteHTML");
        StringBuffer html = new StringBuffer(doc.toString());
        int i = html.indexOf("<a en-tag=\"en-media\" ", 0);
        while (i > -1) {
            i = html.indexOf(">\n", i + 1);
            int z = html.indexOf("<img", i);
            int j = z - 1;
            while (j > i) {
                html.deleteCharAt(j);
                --j;
            }
            i = html.indexOf("/>", z + 1);
            z = html.indexOf("</a>", i);
            j = z - 1;
            while (j > i + 1) {
                html.deleteCharAt(j);
                --j;
            }
            i = html.indexOf("<a en-tag=\"en-media\" ", i);
        }
        return html.toString();
    }

    private void addImageHilight(String resGuid, QFile f) {
        if (this.enSearch == null || this.enSearch.hilightWords == null || this.enSearch.hilightWords.size() == 0) {
            return;
        }
        Resource recoResource = this.conn.getNoteTable().noteResourceTable.getNoteResourceRecognition(resGuid);
        if (recoResource.getRecognition().getBody() == null || recoResource.getRecognition().getBody().length == 0) {
            return;
        }
        QByteArray recoData = new QByteArray(recoResource.getRecognition().getBody());
        String xml = recoData.toString();
        QPixmap pix = new QPixmap(f.fileName());
        QPixmap hilightedPix = new QPixmap(pix.size());
        QPainter p = new QPainter((QPaintDeviceInterface)hilightedPix);
        p.drawPixmap(0, 0, pix);
        QPixmap overlayPix = new QPixmap(pix.size());
        overlayPix.fill(QColor.transparent);
        QPainter p2 = new QPainter((QPaintDeviceInterface)overlayPix);
        p2.setBackgroundMode(Qt.BGMode.TransparentMode);
        p2.setRenderHint(QPainter.RenderHint.Antialiasing, true);
        QColor yellow = QColor.yellow;
        p2.setBrush(yellow);
        QDomDocument doc = new QDomDocument();
        doc.setContent(xml);
        QDomNodeList anchors = doc.elementsByTagName("item");
        int i = 0;
        while (i < anchors.length()) {
            QDomElement element = anchors.at(i).toElement();
            int x = new Integer(element.attribute("x"));
            int y = new Integer(element.attribute("y"));
            int w = new Integer(element.attribute("w"));
            int h = new Integer(element.attribute("h"));
            QDomNodeList children = element.childNodes();
            int j = 0;
            while (j < children.length()) {
                QDomElement child = children.at(j).toElement();
                if (child.nodeName().equalsIgnoreCase("t")) {
                    String text = child.text();
                    int weight = new Integer(child.attribute("w"));
                    if (weight >= Global.getRecognitionWeight()) {
                        int k = 0;
                        while (k < this.enSearch.hilightWords.size()) {
                            String searchWord = this.enSearch.hilightWords.get(k).toLowerCase();
                            if (searchWord.startsWith("*")) {
                                searchWord = searchWord.substring(1);
                            }
                            if (searchWord.endsWith("*")) {
                                searchWord = searchWord.substring(0, searchWord.length() - 1);
                            }
                            if (text.toLowerCase().contains(searchWord)) {
                                p2.drawRect(x, y, w, h);
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        p2.end();
        p.setOpacity(0.4);
        p.drawPixmap(0, 0, overlayPix);
        p.end();
        hilightedPix.save(f.fileName());
    }

    private void modifyImageTags(QDomDocument doc, QDomElement docElem, QDomElement enmedia, QDomAttr hash) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.modifyImageTags");
        String type = enmedia.attribute("type");
        type = type.startsWith("image/") ? "." + type.substring(6) : "";
        String resGuid = this.conn.getNoteTable().noteResourceTable.getNoteResourceGuidByHashHex(this.currentNoteGuid, hash.value());
        QFile tfile = new QFile(Global.getFileManager().getResDirPath(String.valueOf(resGuid) + type));
        Resource r = null;
        if (resGuid != null) {
            r = this.conn.getNoteTable().noteResourceTable.getNoteResource(resGuid, true);
        }
        if (r == null || r.getData() == null || r.getData().getBody().length == 0) {
            this.resourceError = true;
            this.readOnly = true;
        }
        if (r != null && r.getData() != null && r.getData().getBody().length > 0) {
            tfile.open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly}));
            QByteArray binData = new QByteArray(r.getData().getBody());
            tfile.write(binData);
            tfile.close();
            this.addImageHilight(r.getGuid(), tfile);
            enmedia.setAttribute("src", QUrl.fromLocalFile((String)tfile.fileName()).toString());
            enmedia.setAttribute("en-tag", "en-media");
            enmedia.setNodeValue("");
            enmedia.setAttribute("guid", r.getGuid());
            enmedia.setTagName("img");
        }
        enmedia.setAttribute("src", tfile.fileName().toString());
        enmedia.setAttribute("en-tag", "en-media");
        enmedia.setTagName("img");
        if (!(r == null || r.getAttributes() == null || r.getAttributes().getSourceURL() != null && r.getAttributes().getSourceURL().toLowerCase().startsWith("http://latex.codecogs.com/gif.latex?"))) {
            enmedia.setAttribute("onContextMenu", "window.jambi.imageContextMenu('" + tfile.fileName() + "');");
        } else {
            QDomElement newText = doc.createElement("a");
            enmedia.setAttribute("src", tfile.fileName().toString());
            enmedia.setAttribute("en-tag", "en-latex");
            newText.setAttribute("onMouseOver", "style.cursor='hand'");
            if (r != null && r.getAttributes() != null && r.getAttributes().getSourceURL() != null) {
                newText.setAttribute("title", r.getAttributes().getSourceURL());
            }
            newText.setAttribute("href", "latex://" + tfile.fileName().toString());
            enmedia.parentNode().replaceChild((QDomNode)newText, (QDomNode)enmedia);
            newText.appendChild((QDomNode)enmedia);
        }
        enmedia.setNodeValue("");
        enmedia.setAttribute("guid", resGuid);
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.modifyImageTags");
    }

    private QDomDocument modifyTags(QDomDocument doc) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.modifyTags");
        if (this.tempFiles == null) {
            this.tempFiles = new ArrayList();
        }
        this.tempFiles.clear();
        QDomElement docElem = doc.documentElement();
        QDomNodeList anchors = docElem.elementsByTagName("en-media");
        int enMediaCount = anchors.length();
        int i = enMediaCount - 1;
        while (i >= 0) {
            QDomElement enmedia = anchors.at(i).toElement();
            if (enmedia.hasAttribute("type")) {
                QDomAttr attr = enmedia.attributeNode("type");
                QDomAttr hash = enmedia.attributeNode("hash");
                String[] type = attr.nodeValue().split("/");
                String appl = type[1];
                if (type[0] != null) {
                    if (type[0].equals("image")) {
                        this.modifyImageTags(doc, docElem, enmedia, hash);
                    }
                    if (!type[0].equals("image")) {
                        this.modifyApplicationTags(doc, docElem, enmedia, hash, appl);
                    }
                }
            }
            --i;
        }
        anchors = docElem.elementsByTagName("en-todo");
        int enTodoCount = anchors.length();
        int i2 = enTodoCount - 1;
        while (i2 >= 0) {
            QDomElement enmedia = anchors.at(i2).toElement();
            this.modifyTodoTags(enmedia);
            --i2;
        }
        anchors = docElem.elementsByTagName("en-crypt");
        int enCryptLen = anchors.length();
        int i3 = enCryptLen - 1;
        while (i3 >= 0) {
            QDomElement enmedia = anchors.at(i3).toElement();
            enmedia.setAttribute("contentEditable", "false");
            enmedia.setAttribute("src", Global.getFileManager().getImageDirPath("encrypt.png"));
            enmedia.setAttribute("en-tag", "en-crypt");
            enmedia.setAttribute("alt", enmedia.text());
            Global.cryptCounter = Global.cryptCounter + 1;
            enmedia.setAttribute("id", "crypt" + Global.cryptCounter.toString());
            String encryptedText = enmedia.text();
            if (encryptedText.endsWith("\n")) {
                encryptedText = encryptedText.substring(0, encryptedText.length() - 1);
            }
            if (encryptedText.endsWith("\r")) {
                encryptedText = encryptedText.substring(0, encryptedText.length() - 1);
            }
            String hint = enmedia.attribute("hint");
            hint = hint.replace("'", "&apos;");
            enmedia.setAttribute("onClick", "window.jambi.decryptText('crypt" + Global.cryptCounter.toString() + "', '" + encryptedText + "', '" + hint + "');");
            enmedia.setAttribute("onMouseOver", "style.cursor='hand'");
            enmedia.setTagName("img");
            enmedia.removeChild(enmedia.firstChild());
            --i3;
        }
        anchors = docElem.elementsByTagName("a");
        enCryptLen = anchors.length();
        i3 = 0;
        while (i3 < anchors.length()) {
            QDomElement element = anchors.at(i3).toElement();
            if (!element.attribute("href").toLowerCase().startsWith("latex://")) {
                element.setAttribute("title", element.attribute("href"));
            } else {
                element.setAttribute("title", element.attribute("title").toLowerCase().replace("http://latex.codecogs.com/gif.latex?", ""));
            }
            ++i3;
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.modifyTags");
        return doc;
    }

    private boolean buildInkNote(QDomDocument doc, QDomElement docElem, QDomElement enmedia, QDomAttr hash, String appl) {
        String resGuid = this.conn.getNoteTable().noteResourceTable.getNoteResourceGuidByHashHex(this.currentNote.getGuid(), hash.value());
        Resource r = this.conn.getNoteTable().noteResourceTable.getNoteResource(resGuid, false);
        if (r == null || r.getData() == null) {
            return false;
        }
        if (!this.resourceError) {
            List<QByteArray> data = this.conn.getInkImagesTable().getImage(r.getGuid());
            if (data.size() == 0) {
                return false;
            }
            int i = 0;
            while (i < data.size()) {
                QFile f = new QFile(Global.getFileManager().getResDirPath(String.valueOf(resGuid) + new Integer(i).toString() + ".png"));
                f.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly});
                f.write(data.get(i));
                f.close();
                QDomElement newImage = doc.createElement("img");
                newImage.setAttribute("src", QUrl.fromLocalFile((String)f.fileName()).toString());
                enmedia.appendChild((QDomNode)newImage);
                ++i;
            }
            return true;
        }
        return false;
    }

    private void modifyApplicationTags(QDomDocument doc, QDomElement docElem, QDomElement enmedia, QDomAttr hash, String appl) {
        String resGuid;
        Resource r;
        this.logger.log(this.logger.HIGH, "Entering NeverNote.modifyApplicationTags");
        if (appl.equalsIgnoreCase("vnd.evernote.ink")) {
            this.inkNote = true;
            if (this.buildInkNote(doc, docElem, enmedia, hash, appl)) {
                return;
            }
        }
        if ((r = this.conn.getNoteTable().noteResourceTable.getNoteResource(resGuid = this.conn.getNoteTable().noteResourceTable.getNoteResourceGuidByHashHex(this.currentNote.getGuid(), hash.value()), false)) == null || r.getData() == null) {
            this.resourceError = true;
        }
        if (r != null && r.getData() != null) {
            String icon;
            String contextFileName;
            String fn;
            int pos;
            if (appl.equalsIgnoreCase("octet-stream") && r.getAttributes() != null && r.getAttributes().getFileName() != null && (pos = (fn = r.getAttributes().getFileName()).lastIndexOf(".")) > -1) {
                appl = fn.substring(pos + 1);
            }
            String fileDetails = null;
            if (r.getAttributes() != null && r.getAttributes().getFileName() != null && !r.getAttributes().getFileName().equals("")) {
                fileDetails = r.getAttributes().getFileName();
            }
            FileManager fileManager = Global.getFileManager();
            if (fileDetails != null && !fileDetails.equals("")) {
                if (!this.noteHistory) {
                    enmedia.setAttribute("href", "nnres://" + r.getGuid() + Global.attachmentNameDelimeter + fileDetails);
                    contextFileName = fileManager.getResDirPath(String.valueOf(r.getGuid()) + Global.attachmentNameDelimeter + fileDetails);
                } else {
                    enmedia.setAttribute("href", "nnres://" + r.getGuid() + this.currentNote.getUpdateSequenceNum() + Global.attachmentNameDelimeter + fileDetails);
                    contextFileName = fileManager.getResDirPath(String.valueOf(r.getGuid()) + this.currentNote.getUpdateSequenceNum() + Global.attachmentNameDelimeter + fileDetails);
                }
            } else if (!this.noteHistory) {
                enmedia.setAttribute("href", "nnres://" + r.getGuid() + this.currentNote.getUpdateSequenceNum() + Global.attachmentNameDelimeter + appl);
                contextFileName = fileManager.getResDirPath(String.valueOf(r.getGuid()) + this.currentNote.getUpdateSequenceNum() + Global.attachmentNameDelimeter + appl);
            } else {
                enmedia.setAttribute("href", "nnres://" + r.getGuid() + Global.attachmentNameDelimeter + appl);
                contextFileName = fileManager.getResDirPath(String.valueOf(r.getGuid()) + Global.attachmentNameDelimeter + appl);
            }
            contextFileName = contextFileName.replace("\\", "/");
            enmedia.setAttribute("onContextMenu", "window.jambi.resourceContextMenu('" + contextFileName + "');");
            if (fileDetails == null || fileDetails.equals("")) {
                fileDetails = "";
            }
            enmedia.setAttribute("en-tag", "en-media");
            enmedia.setAttribute("guid", r.getGuid());
            enmedia.setTagName("a");
            QDomElement newText = doc.createElement("img");
            boolean goodPreview = false;
            String filePath = "";
            if (appl.equalsIgnoreCase("pdf") && this.pdfPreview) {
                Resource res = this.conn.getNoteTable().noteResourceTable.getNoteResource(r.getGuid(), true);
                String fileName = res.getAttributes() != null && res.getAttributes().getFileName() != null && !res.getAttributes().getFileName().trim().equals("") ? String.valueOf(res.getGuid()) + Global.attachmentNameDelimeter + res.getAttributes().getFileName() : String.valueOf(res.getGuid()) + ".pdf";
                QFile file = new QFile(fileManager.getResDirPath(fileName));
                QIODevice.OpenMode mode = new QIODevice.OpenMode(new QIODevice.OpenModeFlag[0]);
                mode.set((QtEnumerator[])new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly});
                file.open(mode);
                QDataStream out = new QDataStream((QIODevice)file);
                Resource resBinary = this.conn.getNoteTable().noteResourceTable.getNoteResource(res.getGuid(), true);
                QByteArray binData = new QByteArray(resBinary.getData().getBody());
                resBinary = null;
                out.writeBytes(binData.toByteArray());
                file.close();
                PDFPreview pdfPreview = new PDFPreview();
                goodPreview = pdfPreview.setupPreview(file.fileName(), appl, 0);
                if (goodPreview) {
                    QDomElement span = doc.createElement("span");
                    QDomElement table = doc.createElement("table");
                    span.setAttribute("pdfNavigationTable", "true");
                    QDomElement tr = doc.createElement("tr");
                    QDomElement td = doc.createElement("td");
                    QDomElement left = doc.createElement("img");
                    left.setAttribute("onMouseDown", "window.jambi.nextPage('" + file.fileName() + "')");
                    left.setAttribute("onMouseDown", "window.jambi.nextPage('" + file.fileName() + "')");
                    left.setAttribute("onMouseOver", "style.cursor='hand'");
                    QDomElement right = doc.createElement("img");
                    right.setAttribute("onMouseDown", "window.jambi.nextPage('" + file.fileName() + "')");
                    left.setAttribute("onMouseDown", "window.jambi.previousPage('" + file.fileName() + "')");
                    left.setAttribute("src", Global.getFileManager().getImageDirPath("small_left.png"));
                    right.setAttribute("src", Global.getFileManager().getImageDirPath("small_right.png"));
                    right.setAttribute("onMouseOver", "style.cursor='hand'");
                    table.appendChild((QDomNode)tr);
                    tr.appendChild((QDomNode)td);
                    td.appendChild((QDomNode)left);
                    td.appendChild((QDomNode)right);
                    span.appendChild((QDomNode)table);
                    enmedia.parentNode().insertBefore((QDomNode)span, (QDomNode)enmedia);
                }
                filePath = String.valueOf(fileName) + ".png";
            }
            if ((icon = this.findIcon(appl)).equals("attachment.png")) {
                icon = this.findIcon(fileDetails.substring(fileDetails.indexOf(".") + 1));
            }
            newText.setAttribute("src", Global.getFileManager().getImageDirPath(icon));
            if (goodPreview) {
                newText.setAttribute("src", fileManager.getResDirPathSpecialChar(filePath));
                newText.setAttribute("style", "border-style:solid; border-color:green; padding:0.5mm 0.5mm 0.5mm 0.5mm;");
            }
            newText.setAttribute("title", fileDetails);
            enmedia.removeChild(enmedia.firstChild());
            enmedia.appendChild((QDomNode)newText);
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.modifyApplicationTags");
    }

    private void modifyTodoTags(QDomElement todo) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.modifyTodoTags");
        todo.setAttribute("type", "checkbox");
        String checked = todo.attribute("checked");
        todo.removeAttribute("checked");
        if (checked.equalsIgnoreCase("true")) {
            todo.setAttribute("checked", "");
        } else {
            todo.setAttribute("unchecked", "");
        }
        todo.setAttribute("value", checked);
        todo.setAttribute("onClick", "value=checked;window.jambi.contentChanged(); ");
        todo.setAttribute("onMouseOver", "style.cursor='hand'");
        todo.setTagName("input");
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.modifyTodoTags");
    }

    public String modifyCachedTodoTags(String note) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.modifyCachedTodoTags");
        StringBuffer html = new StringBuffer(note);
        int i = html.indexOf("<input", 0);
        while (i > -1) {
            int endPos = html.indexOf(">", i + 1);
            String input = html.substring(i, endPos);
            input = input.indexOf("value=\"true\"") > 0 ? input.replace(" unchecked=\"\"", " checked=\"\"") : input.replace(" checked=\"\"", " unchecked=\"\"");
            html.replace(i, endPos, input);
            ++i;
            i = html.indexOf("<input", i);
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.modifyCachedTodoTags");
        return html.toString();
    }

    public QDomDocument addHilight(QDomDocument doc) {
        if (this.enSearch.hilightWords == null || this.enSearch.hilightWords.size() == 0) {
            return doc;
        }
        XMLInsertHilight hilight = new XMLInsertHilight(doc, this.enSearch.hilightWords);
        return hilight.getDoc();
    }

    private String findIcon(String appl) {
        this.logger.log(this.logger.HIGH, "Entering NeverNote.findIcon");
        appl = appl.toLowerCase();
        String relativePath = String.valueOf(appl) + ".png";
        File f = Global.getFileManager().getImageDirFile(relativePath);
        if (f.exists()) {
            return relativePath;
        }
        if (f.exists()) {
            return String.valueOf(appl) + ".png";
        }
        this.logger.log(this.logger.HIGH, "Leaving NeverNote.findIcon");
        return "attachment.png";
    }

    private class TidyListener
    implements TidyMessageListener {
        ApplicationLogger logger;
        public boolean errorFound;

        public TidyListener(ApplicationLogger logger) {
            this.logger = logger;
            this.errorFound = false;
        }

        public void messageReceived(TidyMessage msg) {
            if (msg.getLevel() == TidyMessage.Level.ERROR) {
                this.logger.log(this.logger.LOW, "******* JTIDY ERORR *******");
                this.logger.log(this.logger.LOW, "Error Code: " + msg.getErrorCode());
                this.logger.log(this.logger.LOW, "Column: " + msg.getColumn());
                this.logger.log(this.logger.LOW, "Column: " + msg.getColumn());
                this.logger.log(this.logger.LOW, "Line: " + msg.getLine());
                this.logger.log(this.logger.LOW, "Message: " + msg.getMessage());
                this.logger.log(this.logger.LOW, "***************************");
                this.errorFound = true;
            } else {
                this.logger.log(this.logger.EXTREME, "JTidy Results: " + msg.getMessage());
            }
        }
    }
}

