/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import com.trolltech.qt.core.QBuffer;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QPixmap;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;

public class SystemIconTable {
    private final ApplicationLogger logger;
    DatabaseConnection db;

    public SystemIconTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.HIGH, "Creating table SystemIcon...");
        if (!query.exec("Create table SystemIcon (name varchar, type varchar, primary key(name, type), icon blob)")) {
            this.logger.log(this.logger.HIGH, "Table SystemIcon creation FAILED!!!");
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Drop table SystemIcon");
    }

    public QIcon getIcon(String name, String type) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Select icon from SystemIcon where name=:name and type=:type")) {
            this.logger.log(this.logger.EXTREME, "Error preparing system icon select.");
        }
        query.bindValue(":name", name);
        query.bindValue(":type", type);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error finding system icon.");
        }
        if (!query.next() || query.getBlob(0) == null) {
            return null;
        }
        QByteArray blob = new QByteArray(query.getBlob(0));
        QIcon icon = new QIcon(QPixmap.fromImage((QImage)QImage.fromData((QByteArray)blob)));
        return icon;
    }

    public boolean exists(String name, String type) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Select icon from SystemIcon where name=:name and type=:type")) {
            this.logger.log(this.logger.EXTREME, "Error preparing system icon select.");
        }
        query.bindValue(":name", name);
        query.bindValue(":type", type);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error finding system icon.");
        }
        return query.next() && query.getBlob(0) != null;
    }

    public void setIcon(String name, String rectype, QIcon icon, String filetype) {
        if (this.exists(name, rectype)) {
            this.updateIcon(name, rectype, icon, filetype);
        } else {
            this.addIcon(name, rectype, icon, filetype);
        }
    }

    public void addIcon(String name, String rectype, QIcon icon, String filetype) {
        QBuffer buffer;
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (icon == null) {
            return;
        }
        if (!query.prepare("Insert into SystemIcon (icon, name, type) values (:icon, :name, :type)")) {
            this.logger.log(this.logger.EXTREME, "Error preparing notebook icon select.");
        }
        if (!(buffer = new QBuffer()).open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadWrite})) {
            this.logger.log(this.logger.EXTREME, "Failure to open buffer.  Aborting.");
            return;
        }
        QPixmap p = icon.pixmap(32, 32);
        QImage i = p.toImage();
        i.save((QIODevice)buffer, filetype.toUpperCase());
        buffer.close();
        QByteArray b = new QByteArray(buffer.buffer());
        if (b.isNull() || b.isEmpty()) {
            return;
        }
        query.bindValue(":icon", b.toByteArray());
        query.bindValue(":name", name);
        query.bindValue(":type", rectype);
        if (!query.exec()) {
            this.logger.log(this.logger.LOW, "Error setting system icon. " + query.lastError());
        }
    }

    public void updateIcon(String name, String rectype, QIcon icon, String filetype) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (icon == null) {
            if (!query.prepare("delete from SystemIcon where name=:name and type=:type")) {
                this.logger.log(this.logger.EXTREME, "Error preparing notebook icon select.");
            }
        } else {
            QBuffer buffer;
            if (!query.prepare("update SystemIcon set icon=:icon where name=:name and type=:type")) {
                this.logger.log(this.logger.EXTREME, "Error preparing notebook icon select.");
            }
            if (!(buffer = new QBuffer()).open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadWrite})) {
                this.logger.log(this.logger.EXTREME, "Failure to open buffer.  Aborting.");
                return;
            }
            QPixmap p = icon.pixmap(32, 32);
            QImage i = p.toImage();
            i.save((QIODevice)buffer, filetype.toUpperCase());
            buffer.close();
            QByteArray b = new QByteArray(buffer.buffer());
            if (!b.isNull() && !b.isEmpty()) {
                query.bindValue(":icon", b.toByteArray());
            } else {
                return;
            }
        }
        query.bindValue(":name", name);
        query.bindValue(":type", rectype);
        if (!query.exec()) {
            this.logger.log(this.logger.LOW, "Error setting system icon. " + query.lastError());
        }
    }
}

