/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Tag;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QListWidget;
import com.trolltech.qt.gui.QListWidgetItem;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QSpacerItem;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import java.util.List;

public class IgnoreSync
extends QDialog {
    private final QListWidget syncBookList;
    private final QListWidget ignoreBookList;
    private final QListWidget syncTagList;
    private final QListWidget ignoreTagList;
    private final QListWidget syncLinkedNotebookList;
    private final QListWidget ignoreLinkedNotebookList;
    private final QPushButton okButton;
    private final QPushButton cancelButton;
    private boolean okClicked;
    private final QPushButton leftButton;
    private final QPushButton rightButton;
    private final QPushButton leftTagButton;
    private final QPushButton rightTagButton;
    private final QPushButton leftLinkedNotebookButton;
    private final QPushButton rightLinkedNotebookButton;
    private final QLabel linkedLabelLeft;
    private final QLabel linkedLabelRight;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public IgnoreSync(List<Notebook> allBooks, List<Notebook> archive, List<Tag> allTags, List<Tag> ignoreTags, List<LinkedNotebook> allLinkedNotebooks, List<LinkedNotebook> ignoreLinkedNotebooks) {
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "synchronize.png"));
        this.okClicked = false;
        this.syncBookList = new QListWidget();
        this.syncBookList.setSortingEnabled(true);
        this.syncBookList.setSelectionMode(QAbstractItemView.SelectionMode.MultiSelection);
        this.syncTagList = new QListWidget();
        this.syncTagList.setSortingEnabled(true);
        this.syncTagList.setSelectionMode(QAbstractItemView.SelectionMode.MultiSelection);
        this.syncLinkedNotebookList = new QListWidget();
        this.syncLinkedNotebookList.setSortingEnabled(true);
        this.syncLinkedNotebookList.setSelectionMode(QAbstractItemView.SelectionMode.MultiSelection);
        this.okButton = new QPushButton();
        this.okButton.setText(this.tr("OK"));
        this.okButton.pressed.connect((Object)this, "onClicked()");
        this.cancelButton = new QPushButton();
        this.cancelButton.setText(this.tr("Cancel"));
        this.cancelButton.pressed.connect((Object)this, "onCancel()");
        QVBoxLayout openLayout = new QVBoxLayout();
        openLayout.addWidget((QWidget)new QLabel(this.tr("Synchronized Notebooks")));
        openLayout.addWidget((QWidget)this.syncBookList);
        QVBoxLayout openTagLayout = new QVBoxLayout();
        openTagLayout.addWidget((QWidget)new QLabel(this.tr("Synchronized Tags")));
        openTagLayout.addWidget((QWidget)this.syncTagList);
        QVBoxLayout openLinkedNotebookLayout = new QVBoxLayout();
        this.linkedLabelLeft = new QLabel(this.tr("Synchronized Linked Notebooks"));
        openLinkedNotebookLayout.addWidget((QWidget)this.linkedLabelLeft);
        openLinkedNotebookLayout.addWidget((QWidget)this.syncLinkedNotebookList);
        this.rightButton = new QPushButton((QWidget)this);
        this.rightButton.setIcon(new QIcon(String.valueOf(this.iconPath) + "forward.png"));
        this.leftButton = new QPushButton((QWidget)this);
        this.leftButton.setIcon(new QIcon(String.valueOf(this.iconPath) + "back.png"));
        this.leftButton.setEnabled(false);
        this.rightButton.setEnabled(false);
        this.rightTagButton = new QPushButton((QWidget)this);
        this.rightTagButton.setIcon(new QIcon(String.valueOf(this.iconPath) + "forward.png"));
        this.leftTagButton = new QPushButton((QWidget)this);
        this.leftTagButton.setIcon(new QIcon(String.valueOf(this.iconPath) + "back.png"));
        this.leftTagButton.setEnabled(false);
        this.rightTagButton.setEnabled(false);
        this.rightLinkedNotebookButton = new QPushButton((QWidget)this);
        this.rightLinkedNotebookButton.setIcon(new QIcon(String.valueOf(this.iconPath) + "forward.png"));
        this.leftLinkedNotebookButton = new QPushButton((QWidget)this);
        this.leftLinkedNotebookButton.setIcon(new QIcon(String.valueOf(this.iconPath) + "back.png"));
        this.leftLinkedNotebookButton.setEnabled(false);
        this.rightLinkedNotebookButton.setEnabled(false);
        QVBoxLayout middleLayout = new QVBoxLayout();
        middleLayout.addSpacerItem(new QSpacerItem(1, 1));
        middleLayout.addWidget((QWidget)this.rightButton);
        middleLayout.addWidget((QWidget)this.leftButton);
        middleLayout.addSpacerItem(new QSpacerItem(1, 1));
        QVBoxLayout middleTagLayout = new QVBoxLayout();
        middleTagLayout.addSpacerItem(new QSpacerItem(1, 1));
        middleTagLayout.addWidget((QWidget)this.rightTagButton);
        middleTagLayout.addWidget((QWidget)this.leftTagButton);
        middleTagLayout.addSpacerItem(new QSpacerItem(1, 1));
        QVBoxLayout middleLinkedNotebookLayout = new QVBoxLayout();
        middleLinkedNotebookLayout.addSpacerItem(new QSpacerItem(1, 1));
        middleLinkedNotebookLayout.addWidget((QWidget)this.rightLinkedNotebookButton);
        middleLinkedNotebookLayout.addWidget((QWidget)this.leftLinkedNotebookButton);
        middleLinkedNotebookLayout.addSpacerItem(new QSpacerItem(1, 1));
        QVBoxLayout closeLayout = new QVBoxLayout();
        closeLayout.addWidget((QWidget)new QLabel(this.tr("Non-Synchronized Notebooks")));
        this.ignoreBookList = new QListWidget();
        this.ignoreBookList.setSortingEnabled(true);
        this.ignoreBookList.setSelectionMode(QAbstractItemView.SelectionMode.MultiSelection);
        closeLayout.addWidget((QWidget)this.ignoreBookList);
        QVBoxLayout closeTagLayout = new QVBoxLayout();
        closeTagLayout.addWidget((QWidget)new QLabel(this.tr("Non-Synchronized Tags")));
        this.ignoreTagList = new QListWidget();
        this.ignoreTagList.setSortingEnabled(true);
        this.ignoreTagList.setSelectionMode(QAbstractItemView.SelectionMode.MultiSelection);
        closeTagLayout.addWidget((QWidget)this.ignoreTagList);
        QVBoxLayout closeLinkedNotebookLayout = new QVBoxLayout();
        this.linkedLabelRight = new QLabel(this.tr("Non-Synchronized Linked Notebooks"));
        closeLinkedNotebookLayout.addWidget((QWidget)this.linkedLabelRight);
        this.ignoreLinkedNotebookList = new QListWidget();
        this.ignoreLinkedNotebookList.setSortingEnabled(true);
        this.ignoreLinkedNotebookList.setSelectionMode(QAbstractItemView.SelectionMode.MultiSelection);
        closeLinkedNotebookLayout.addWidget((QWidget)this.ignoreLinkedNotebookList);
        this.syncBookList.itemSelectionChanged.connect((Object)this, "syncBookSelected()");
        this.ignoreBookList.itemSelectionChanged.connect((Object)this, "ignoreBookSelected()");
        this.leftButton.clicked.connect((Object)this, "toOpenList()");
        this.rightButton.clicked.connect((Object)this, "toClosedList()");
        this.syncTagList.itemSelectionChanged.connect((Object)this, "syncTagSelected()");
        this.ignoreTagList.itemSelectionChanged.connect((Object)this, "ignoreTagSelected()");
        this.leftTagButton.clicked.connect((Object)this, "toOpenTagList()");
        this.rightTagButton.clicked.connect((Object)this, "toClosedTagList()");
        this.syncLinkedNotebookList.itemSelectionChanged.connect((Object)this, "syncLinkedNotebookSelected()");
        this.ignoreLinkedNotebookList.itemSelectionChanged.connect((Object)this, "ignoreLinkedNotebookSelected()");
        this.leftLinkedNotebookButton.clicked.connect((Object)this, "toOpenLinkedNotebookList()");
        this.rightLinkedNotebookButton.clicked.connect((Object)this, "toClosedLinkedNotebookList()");
        QHBoxLayout buttonLayout = new QHBoxLayout();
        buttonLayout.addStretch(1);
        buttonLayout.addWidget((QWidget)this.okButton);
        buttonLayout.addWidget((QWidget)this.cancelButton);
        this.setWindowTitle(this.tr("Open/Close Notebooks"));
        QHBoxLayout upperLayout = new QHBoxLayout();
        upperLayout.addLayout((QLayout)openLayout);
        upperLayout.addLayout((QLayout)middleLayout);
        upperLayout.addLayout((QLayout)closeLayout);
        QHBoxLayout tagLayout = new QHBoxLayout();
        tagLayout.addLayout((QLayout)openTagLayout);
        tagLayout.addLayout((QLayout)middleTagLayout);
        tagLayout.addLayout((QLayout)closeTagLayout);
        QHBoxLayout linkedNotebookLayout = new QHBoxLayout();
        linkedNotebookLayout.addLayout((QLayout)openLinkedNotebookLayout);
        linkedNotebookLayout.addLayout((QLayout)middleLinkedNotebookLayout);
        linkedNotebookLayout.addLayout((QLayout)closeLinkedNotebookLayout);
        QVBoxLayout mainLayout = new QVBoxLayout();
        mainLayout.addLayout((QLayout)upperLayout);
        mainLayout.addLayout((QLayout)tagLayout);
        mainLayout.addLayout((QLayout)linkedNotebookLayout);
        mainLayout.addSpacing(1);
        mainLayout.addLayout((QLayout)buttonLayout);
        this.setLayout((QLayout)mainLayout);
        int i = 0;
        while (i < allBooks.size()) {
            boolean found = false;
            int j = 0;
            while (j < archive.size()) {
                if (archive.get(j).getName().equalsIgnoreCase(allBooks.get(i).getName())) {
                    found = true;
                    j = archive.size();
                }
                ++j;
            }
            if (!found) {
                QListWidgetItem item = new QListWidgetItem(allBooks.get(i).getName());
                item.setSelected(false);
                this.syncBookList.addItem(item);
            }
            ++i;
        }
        this.setWindowTitle(this.tr("Open Notebooks"));
        i = 0;
        while (i < archive.size()) {
            QListWidgetItem item = new QListWidgetItem(archive.get(i).getName());
            item.setSelected(false);
            this.ignoreBookList.addItem(item);
            ++i;
        }
        i = 0;
        while (i < allTags.size()) {
            boolean found = false;
            int j = 0;
            while (j < ignoreTags.size()) {
                if (ignoreTags.get(j).getName().equalsIgnoreCase(allTags.get(i).getName())) {
                    found = true;
                    j = ignoreTags.size();
                }
                ++j;
            }
            if (!found) {
                QListWidgetItem item = new QListWidgetItem(allTags.get(i).getName());
                item.setSelected(false);
                this.syncTagList.addItem(item);
            }
            ++i;
        }
        i = 0;
        while (i < ignoreTags.size()) {
            QListWidgetItem item = new QListWidgetItem(ignoreTags.get(i).getName());
            item.setSelected(false);
            this.ignoreTagList.addItem(item);
            ++i;
        }
        i = 0;
        while (i < allLinkedNotebooks.size()) {
            boolean found = false;
            int j = 0;
            while (j < ignoreLinkedNotebooks.size()) {
                if (ignoreLinkedNotebooks.get(j).getShareName().equalsIgnoreCase(allLinkedNotebooks.get(i).getShareName())) {
                    found = true;
                    j = ignoreLinkedNotebooks.size();
                }
                ++j;
            }
            if (!found) {
                QListWidgetItem item = new QListWidgetItem(allLinkedNotebooks.get(i).getShareName());
                item.setSelected(false);
                this.syncLinkedNotebookList.addItem(item);
            }
            ++i;
        }
        i = 0;
        while (i < ignoreLinkedNotebooks.size()) {
            QListWidgetItem item = new QListWidgetItem(ignoreLinkedNotebooks.get(i).getShareName());
            item.setSelected(false);
            this.ignoreLinkedNotebookList.addItem(item);
            ++i;
        }
        this.syncBookList.itemSelectionChanged.connect((Object)this, "itemSelected()");
        this.setWindowTitle(this.tr("Ignore Synchronized Notes"));
        if (allLinkedNotebooks.size() == 0) {
            this.linkedLabelLeft.setVisible(false);
            this.linkedLabelRight.setVisible(false);
            this.rightLinkedNotebookButton.setVisible(false);
            this.leftLinkedNotebookButton.setVisible(false);
            this.ignoreLinkedNotebookList.setVisible(false);
            this.syncLinkedNotebookList.setVisible(false);
        }
    }

    private void toClosedList() {
        List items = this.syncBookList.selectedItems();
        int i = items.size() - 1;
        while (i >= 0) {
            int row = this.syncBookList.row((QListWidgetItem)items.get(i));
            this.syncBookList.takeItem(row);
            this.ignoreBookList.addItem(((QListWidgetItem)items.get(i)).text());
            --i;
        }
        if (this.syncBookList.count() == 0) {
            this.okButton.setEnabled(false);
        }
        this.rightButton.setEnabled(false);
    }

    private void toOpenList() {
        List items = this.ignoreBookList.selectedItems();
        int i = items.size() - 1;
        while (i >= 0) {
            int row = this.ignoreBookList.row((QListWidgetItem)items.get(i));
            this.ignoreBookList.takeItem(row);
            this.syncBookList.addItem(((QListWidgetItem)items.get(i)).text());
            --i;
        }
        this.okButton.setEnabled(true);
        this.leftButton.setEnabled(false);
    }

    private void toClosedTagList() {
        List items = this.syncTagList.selectedItems();
        int i = items.size() - 1;
        while (i >= 0) {
            int row = this.syncTagList.row((QListWidgetItem)items.get(i));
            this.syncTagList.takeItem(row);
            this.ignoreTagList.addItem(((QListWidgetItem)items.get(i)).text());
            --i;
        }
        this.rightTagButton.setEnabled(false);
    }

    private void toOpenTagList() {
        List items = this.ignoreTagList.selectedItems();
        int i = items.size() - 1;
        while (i >= 0) {
            int row = this.ignoreTagList.row((QListWidgetItem)items.get(i));
            this.ignoreTagList.takeItem(row);
            this.syncTagList.addItem(((QListWidgetItem)items.get(i)).text());
            --i;
        }
        this.leftTagButton.setEnabled(false);
    }

    private void toClosedLinkedNotebookList() {
        List items = this.syncLinkedNotebookList.selectedItems();
        int i = items.size() - 1;
        while (i >= 0) {
            int row = this.syncLinkedNotebookList.row((QListWidgetItem)items.get(i));
            this.syncLinkedNotebookList.takeItem(row);
            this.ignoreLinkedNotebookList.addItem(((QListWidgetItem)items.get(i)).text());
            --i;
        }
        this.rightLinkedNotebookButton.setEnabled(false);
    }

    private void toOpenLinkedNotebookList() {
        List items = this.ignoreLinkedNotebookList.selectedItems();
        int i = items.size() - 1;
        while (i >= 0) {
            int row = this.ignoreLinkedNotebookList.row((QListWidgetItem)items.get(i));
            this.ignoreLinkedNotebookList.takeItem(row);
            this.syncLinkedNotebookList.addItem(((QListWidgetItem)items.get(i)).text());
            --i;
        }
        this.leftLinkedNotebookButton.setEnabled(false);
    }

    private void ignoreBookSelected() {
        if (this.ignoreBookList.selectedItems().size() > 0) {
            this.leftButton.setEnabled(true);
        } else {
            this.leftButton.setEnabled(false);
        }
    }

    private void syncBookSelected() {
        if (this.syncBookList.selectedItems().size() > 0) {
            this.rightButton.setEnabled(true);
        } else {
            this.rightButton.setEnabled(false);
        }
    }

    private void ignoreTagSelected() {
        if (this.ignoreTagList.selectedItems().size() > 0) {
            this.leftTagButton.setEnabled(true);
        } else {
            this.leftTagButton.setEnabled(false);
        }
    }

    private void syncTagSelected() {
        if (this.syncTagList.selectedItems().size() > 0) {
            this.rightTagButton.setEnabled(true);
        } else {
            this.rightTagButton.setEnabled(false);
        }
    }

    private void ignoreLinkedNotebookSelected() {
        if (this.ignoreLinkedNotebookList.selectedItems().size() > 0) {
            this.leftLinkedNotebookButton.setEnabled(true);
        } else {
            this.leftLinkedNotebookButton.setEnabled(false);
        }
    }

    private void syncLinkedNotebookSelected() {
        if (this.syncLinkedNotebookList.selectedItems().size() > 0) {
            this.rightLinkedNotebookButton.setEnabled(true);
        } else {
            this.rightLinkedNotebookButton.setEnabled(false);
        }
    }

    private void onClicked() {
        this.okClicked = true;
        this.close();
    }

    private void onCancel() {
        this.okClicked = false;
        this.close();
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    public QListWidget getSyncBookList() {
        return this.syncBookList;
    }

    public QListWidget getIgnoredBookList() {
        return this.ignoreBookList;
    }

    public QListWidget getSyncTagList() {
        return this.syncTagList;
    }

    public QListWidget getIgnoredTagList() {
        return this.ignoreTagList;
    }

    public QListWidget getSyncLinkedNotebookList() {
        return this.syncLinkedNotebookList;
    }

    public QListWidget getIgnoredLinkedNotebookList() {
        return this.ignoreLinkedNotebookList;
    }

    private void itemSelected() {
        if (this.syncBookList.selectedItems().size() == this.syncBookList.count()) {
            this.okButton.setEnabled(false);
            this.rightButton.setEnabled(false);
            return;
        }
        this.rightButton.setEnabled(true);
        this.okButton.setEnabled(true);
    }
}

