/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QCheckBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QWidget;

public class EnDecryptDialog
extends QDialog {
    private boolean okPressed = false;
    private final QLineEdit password;
    private final QLineEdit password2;
    private final QLabel hint;
    private final QPushButton ok;
    private final QLabel error;
    private final QCheckBox permanent;
    private final QCheckBox remember;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public EnDecryptDialog() {
        this.setWindowTitle(this.tr("Decrypt Text"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "password.png"));
        QGridLayout grid = new QGridLayout();
        QGridLayout input = new QGridLayout();
        QGridLayout msgGrid = new QGridLayout();
        QGridLayout button = new QGridLayout();
        this.setLayout((QLayout)grid);
        this.hint = new QLabel("");
        this.password = new QLineEdit("");
        this.password.setEchoMode(QLineEdit.EchoMode.Password);
        this.password2 = new QLineEdit("");
        this.password2.setEchoMode(QLineEdit.EchoMode.Password);
        input.addWidget((QWidget)new QLabel(this.tr("Password")), 1, 1);
        input.addWidget((QWidget)this.password, 1, 2);
        input.addWidget((QWidget)new QLabel(this.tr("Verify")), 2, 1);
        input.addWidget((QWidget)this.password2, 2, 2);
        this.permanent = new QCheckBox();
        this.permanent.setText(this.tr("Permanently Decrypt"));
        input.addWidget((QWidget)this.permanent, 3, 2);
        this.remember = new QCheckBox();
        this.remember.setText(this.tr("Remember For This Session"));
        input.addWidget((QWidget)this.remember, 4, 2);
        input.setContentsMargins(10, 10, -10, -10);
        grid.addLayout((QLayout)input, 1, 1);
        msgGrid.addWidget((QWidget)new QLabel(this.tr("Hint: ")), 1, 1);
        msgGrid.addWidget((QWidget)this.hint, 1, 2);
        msgGrid.addWidget((QWidget)new QLabel(""), 1, 3);
        msgGrid.setColumnStretch(3, 100);
        this.error = new QLabel();
        msgGrid.addWidget((QWidget)this.error, 2, 2);
        grid.addLayout((QLayout)msgGrid, 2, 1);
        this.ok = new QPushButton("OK");
        this.ok.clicked.connect((Object)this, "okButtonPressed()");
        this.ok.setEnabled(false);
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelButtonPressed()");
        button.addWidget((QWidget)this.ok, 1, 1);
        button.addWidget((QWidget)cancel, 1, 2);
        grid.addLayout((QLayout)button, 3, 1);
        this.password.textChanged.connect((Object)this, "validateInput()");
        this.password2.textChanged.connect((Object)this, "validateInput()");
    }

    public boolean permanentlyDecrypt() {
        return this.permanent.isChecked();
    }

    private void okButtonPressed() {
        this.okPressed = true;
        this.close();
    }

    private void cancelButtonPressed() {
        this.okPressed = false;
        this.close();
    }

    public String getPasswordVerify() {
        return this.password2.text();
    }

    public String getPassword() {
        return this.password.text();
    }

    public void setHint(String h) {
        this.hint.setText(h.replace("&apos;", "'"));
    }

    public String getHint() {
        return this.hint.text();
    }

    public void setError(String e) {
        this.error.setText(e);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public boolean rememberPassword() {
        return this.remember.isChecked();
    }

    private void validateInput() {
        this.ok.setEnabled(false);
        this.error.setText("");
        if (!this.password.text().equals(this.password2.text())) {
            this.error.setText("Passwords do not match");
            return;
        }
        this.ok.setEnabled(true);
    }
}

