/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import com.evernote.edam.type.NoteSortOrder;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Publishing;
import com.trolltech.qt.core.QBuffer;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QPixmap;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.DeletedTable;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.Pair;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NotebookTable {
    private final ApplicationLogger logger;
    DatabaseConnection db;
    private final String dbName;
    NSqlQuery notebookCountQuery;

    public NotebookTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
        this.dbName = "Notebook";
    }

    public NotebookTable(ApplicationLogger l, DatabaseConnection d, String name) {
        this.logger = l;
        this.db = d;
        this.dbName = name;
    }

    public void createTable(boolean addDefaulte) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.HIGH, "Creating table " + this.dbName + "...");
        if (!query.exec("Create table " + this.dbName + " (guid varchar primary key, " + "sequence integer, " + "name varchar, " + "defaultNotebook varchar, " + "serviceCreated timestamp, " + "serviceUpdated timestamp, " + "published boolean, " + "isDirty boolean, " + "autoEncrypt boolean, " + "local boolean, " + "archived boolean)")) {
            this.logger.log(this.logger.HIGH, "Table " + this.dbName + " creation FAILED!!!");
        }
        Notebook newnote = new Notebook();
        newnote.setDefaultNotebook(true);
        newnote.setName("My Notebook");
        newnote.setPublished(false);
        newnote.setGuid("1");
        SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        query = new NSqlQuery(this.db.getConnection());
        query.prepare("Insert Into " + this.dbName + " (guid, sequence, name, defaultNotebook, " + "serviceCreated, serviceUpdated, published, " + "isDirty, autoEncrypt, " + "local, archived) Values(" + ":guid, :sequence, :name, :defaultNotebook,  " + ":serviceCreated, :serviceUpdated, :published, " + ":isDirty, :autoEncrypt, " + ":local, false)");
        query.bindValue(":guid", newnote.getGuid());
        query.bindValue(":sequence", newnote.getUpdateSequenceNum());
        query.bindValue(":name", newnote.getName());
        query.bindValue(":defaultNotebook", newnote.isDefaultNotebook());
        StringBuilder serviceCreated = new StringBuilder(simple.format(newnote.getServiceCreated()));
        StringBuilder serviceUpdated = new StringBuilder(simple.format(newnote.getServiceUpdated()));
        if (serviceUpdated.toString() == null) {
            serviceUpdated = serviceCreated;
        }
        query.bindValue(":serviceCreated", serviceCreated.toString());
        query.bindValue(":serviceUpdated", serviceCreated.toString());
        query.bindValue(":published", newnote.isPublished());
        query.bindValue(":isDirty", true);
        query.bindValue(":autoEncrypt", false);
        query.bindValue(":local", false);
        boolean check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Initial " + this.dbName + " Table insert failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError().toString());
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Drop table " + this.dbName);
    }

    public void addNotebook(Notebook tempNotebook, boolean isDirty, boolean local) {
        this.addNotebook(tempNotebook, isDirty, local, false, false);
    }

    public void addNotebook(Notebook tempNotebook, boolean isDirty, boolean local, boolean linked, boolean readOnly) {
        SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Insert Into " + this.dbName + " (guid, sequence, name, defaultNotebook, " + "serviceCreated, serviceUpdated, published, " + "publishingUri, publishingOrder, publishingAscending, publishingPublicDescription, " + "isDirty, autoEncrypt, stack, " + "local, archived, readOnly, linked) Values(" + ":guid, :sequence, :name, :defaultNotebook,  " + ":serviceCreated, :serviceUpdated, :published, " + ":publishingUri, :publishingOrder, :publishingAscending, :publishingPublicDescription, " + ":isDirty, :autoEncrypt, " + ":stack, :local, false, :readOnly, :linked)");
        query.bindValue(":guid", tempNotebook.getGuid());
        query.bindValue(":sequence", tempNotebook.getUpdateSequenceNum());
        query.bindValue(":name", tempNotebook.getName());
        query.bindValue(":defaultNotebook", tempNotebook.isDefaultNotebook());
        StringBuilder serviceCreated = new StringBuilder(simple.format(tempNotebook.getServiceCreated()));
        StringBuilder serviceUpdated = new StringBuilder(simple.format(tempNotebook.getServiceUpdated()));
        if (serviceUpdated.toString() == null) {
            serviceUpdated = serviceCreated;
        }
        query.bindValue(":serviceCreated", serviceCreated.toString());
        query.bindValue(":serviceUpdated", serviceCreated.toString());
        query.bindValue(":published", tempNotebook.isPublished());
        query.bindValue(":linked", linked);
        query.bindValue(":readOnly", readOnly);
        if (tempNotebook.isPublished() && tempNotebook.getPublishing() != null) {
            Publishing p = tempNotebook.getPublishing();
            query.bindValue(":publishingUri", p.getUri());
            query.bindValue(":publishingOrder", p.getOrder().getValue());
            query.bindValue(":publishingAscending", p.isAscending());
            query.bindValue(":publishingPublicDescription", p.getPublicDescription());
        } else {
            query.bindValue(":publishingUri", "");
            query.bindValue(":publishingOrder", 1);
            query.bindValue(":publishingAscending", 1);
            query.bindValue(":publishingPublicDescription", "");
        }
        if (isDirty) {
            query.bindValue(":isDirty", true);
        } else {
            query.bindValue(":isDirty", false);
        }
        query.bindValue(":autoEncrypt", false);
        query.bindValue(":local", local);
        query.bindValue(":stack", tempNotebook.getStack());
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, this.dbName + " Table insert failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError().toString());
        }
    }

    public void expungeNotebook(String guid, boolean needsSync) {
        Notebook n = this.getNotebook(guid);
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("delete from " + this.dbName + " where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, String.valueOf(this.dbName) + " SQL delete prepare has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError().toString());
        }
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, String.valueOf(this.dbName) + " delete failed.");
        }
        if (needsSync && n != null && n.getUpdateSequenceNum() > 0) {
            DeletedTable deletedTable = new DeletedTable(this.logger, this.db);
            deletedTable.addDeletedItem(guid, this.dbName);
        }
    }

    public void updateNotebook(Notebook tempNotebook, boolean isDirty) {
        SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update " + this.dbName + " set sequence=:sequence, name=:name, defaultNotebook=:defaultNotebook, " + "serviceCreated=:serviceCreated, serviceUpdated=:serviceUpdated, " + "published=:published, isDirty=:isDirty, publishinguri=:uri, " + "publishingOrder=:order, " + "publishingAscending=:ascending, " + "publishingPublicDescription=:desc, " + "stack=:stack " + "where guid=:guid ");
        query.bindValue(":sequence", tempNotebook.getUpdateSequenceNum());
        query.bindValue(":name", tempNotebook.getName());
        query.bindValue(":defaultNotebook", tempNotebook.isDefaultNotebook());
        StringBuilder serviceCreated = new StringBuilder(simple.format(tempNotebook.getServiceCreated()));
        StringBuilder serviceUpdated = new StringBuilder(simple.format(tempNotebook.getServiceUpdated()));
        query.bindValue(":serviceCreated", serviceCreated.toString());
        query.bindValue(":serviceUpdated", serviceUpdated.toString());
        query.bindValue(":published", tempNotebook.isPublished());
        query.bindValue(":isDirty", isDirty);
        if (tempNotebook.isPublished()) {
            query.bindValue(":uri", tempNotebook.getPublishing().getUri());
            query.bindValue(":order", tempNotebook.getPublishing().getOrder().getValue());
            query.bindValue(":ascending", tempNotebook.getPublishing().isAscending());
            query.bindValue(":desc", tempNotebook.getPublishing().getPublicDescription());
        } else {
            query.bindValue(":uri", "");
            query.bindValue(":order", NoteSortOrder.CREATED.getValue());
            query.bindValue(":ascending", false);
            query.bindValue(":desc", "");
        }
        query.bindValue(":guid", tempNotebook.getGuid());
        query.bindValue(":stack", tempNotebook.getStack());
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, String.valueOf(this.dbName) + " Table update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError().toString());
        }
    }

    public List<Notebook> getAll() {
        ArrayList<Notebook> index = new ArrayList<Notebook>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid, sequence, name, defaultNotebook, serviceCreated, serviceUpdated, published, stack, publishinguri, publishingascending, publishingPublicDescription, publishingOrder from " + this.dbName + " order by name");
        if (!check) {
            this.logger.log(this.logger.EXTREME, String.valueOf(this.dbName) + " SQL retrieve has failed.");
        }
        while (query.next()) {
            Notebook tempNotebook = new Notebook();
            tempNotebook.setGuid(query.valueString(0));
            int sequence = new Integer(query.valueString(1));
            tempNotebook.setUpdateSequenceNum(sequence);
            tempNotebook.setName(query.valueString(2));
            tempNotebook.setDefaultNotebook(query.valueBoolean(3, false));
            SimpleDateFormat indfm = null;
            try {
                indfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tempNotebook.setServiceCreated(indfm.parse(query.valueString(4)).getTime());
                tempNotebook.setServiceUpdated(indfm.parse(query.valueString(5)).getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            tempNotebook.setPublished(new Boolean(query.valueString(6)).booleanValue());
            tempNotebook.setStack(query.valueString(7));
            if (tempNotebook.isPublished()) {
                Publishing p = new Publishing();
                p.setUri(query.valueString(8));
                p.setAscending(query.valueBoolean(9, false));
                p.setPublicDescription(query.valueString(10));
                p.setOrder(NoteSortOrder.findByValue((int)query.valueInteger(11)));
                tempNotebook.setPublishing(p);
            }
            index.add(tempNotebook);
        }
        return index;
    }

    public List<Notebook> getAllLocal() {
        ArrayList<Notebook> index = new ArrayList<Notebook>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid, sequence, name, defaultNotebook, serviceCreated, serviceUpdated, published, stack from " + this.dbName + " where local=true order by name");
        if (!check) {
            this.logger.log(this.logger.EXTREME, String.valueOf(this.dbName) + " SQL retrieve has failed.");
        }
        while (query.next()) {
            Notebook tempNotebook = new Notebook();
            tempNotebook.setGuid(query.valueString(0));
            int sequence = new Integer(query.valueString(1));
            tempNotebook.setUpdateSequenceNum(sequence);
            tempNotebook.setName(query.valueString(2));
            SimpleDateFormat indfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            try {
                tempNotebook.setServiceCreated(indfm.parse(query.valueString(4)).getTime());
                tempNotebook.setServiceUpdated(indfm.parse(query.valueString(5)).getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (query.valueString(7) != null && !query.valueString(7).trim().equals("")) {
                tempNotebook.setStack(query.valueString(7));
            }
            index.add(tempNotebook);
        }
        return index;
    }

    public void setArchived(String guid, boolean val) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update " + this.dbName + " set archived=:archived where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, String.valueOf(this.dbName) + " SQL archive update has failed.");
        }
        query.bindValue(":guid", guid);
        query.bindValue(":archived", val);
        query.exec();
    }

    public List<Notebook> getAllArchived() {
        ArrayList<Notebook> index = new ArrayList<Notebook>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid, sequence, name, defaultNotebook, serviceCreated, serviceUpdated, published, stack, publishinguri, publishingascending, publishingPublicDescription, publishingOrder from " + this.dbName + " where archived=true order by name");
        if (!check) {
            this.logger.log(this.logger.EXTREME, String.valueOf(this.dbName) + " SQL retrieve has failed.");
        }
        while (query.next()) {
            Notebook tempNotebook = new Notebook();
            tempNotebook.setGuid(query.valueString(0));
            int sequence = new Integer(query.valueString(1));
            tempNotebook.setUpdateSequenceNum(sequence);
            tempNotebook.setName(query.valueString(2));
            SimpleDateFormat indfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            try {
                tempNotebook.setServiceCreated(indfm.parse(query.valueString(4)).getTime());
                tempNotebook.setServiceUpdated(indfm.parse(query.valueString(5)).getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            tempNotebook.setPublished(new Boolean(query.valueString(6)).booleanValue());
            if (query.valueString(7) != null && !query.valueString(7).trim().equals("")) {
                tempNotebook.setStack(query.valueString(7));
            }
            if (tempNotebook.isPublished()) {
                Publishing p = new Publishing();
                p.setUri(query.valueString(8));
                p.setAscending(query.valueBoolean(9, false));
                p.setPublicDescription(query.valueString(10));
                p.setOrder(NoteSortOrder.findByValue((int)query.valueInteger(11)));
                tempNotebook.setPublishing(p);
            }
            index.add(tempNotebook);
        }
        return index;
    }

    public boolean isNotebookLocal(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select local from " + this.dbName + " where guid=:guid");
        query.bindValue(":guid", guid);
        query.exec();
        if (!query.next()) {
            return false;
        }
        boolean returnValue = query.valueBoolean(0, false);
        return returnValue;
    }

    public boolean isNotebookLinked(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select linked from " + this.dbName + " where guid=:guid");
        query.bindValue(":guid", guid);
        query.exec();
        if (!query.next()) {
            return false;
        }
        boolean returnValue = query.valueBoolean(0, false);
        return returnValue;
    }

    public boolean isReadOnly(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select readOnly from " + this.dbName + " where guid=:guid and readOnly=true");
        query.bindValue(":guid", guid);
        query.exec();
        if (!query.next()) {
            return false;
        }
        boolean returnValue = query.valueBoolean(0, false);
        return returnValue;
    }

    public void updateNotebookSequence(String guid, int sequence) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update " + this.dbName + " set sequence=:sequence where guid=:guid");
        query.bindValue(":guid", guid);
        query.bindValue(":sequence", sequence);
        query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, String.valueOf(this.dbName) + " sequence update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void updateNotebookGuid(String oldGuid, String newGuid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update " + this.dbName + " set guid=:newGuid where guid=:oldGuid");
        query.bindValue(":oldGuid", oldGuid);
        query.bindValue(":newGuid", newGuid);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, String.valueOf(this.dbName) + " guid update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.prepare("Update Note set notebookGuid=:newGuid where notebookGuid=:oldGuid");
        query.bindValue(":oldGuid", oldGuid);
        query.bindValue(":newGuid", newGuid);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, String.valueOf(this.dbName) + " guid update for note failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update WatchFolders set notebook=:newGuid where notebook=:oldGuid");
        query.bindValue(":oldGuid", oldGuid);
        query.bindValue(":newGuid", newGuid);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "Update WatchFolder notebook failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError().toString());
        }
    }

    public List<Notebook> getDirty() {
        ArrayList<Notebook> index = new ArrayList<Notebook>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid, sequence, name, defaultNotebook, serviceCreated, serviceUpdated, published, stack, publishinguri, publishingascending, publishingPublicDescription, publishingOrder from " + this.dbName + " where isDirty=true and local=false and linked=false");
        if (!check) {
            this.logger.log(this.logger.EXTREME, String.valueOf(this.dbName) + " SQL retrieve has failed.");
        }
        while (query.next()) {
            Notebook tempNotebook = new Notebook();
            tempNotebook.setGuid(query.valueString(0));
            int sequence = new Integer(query.valueString(1));
            tempNotebook.setUpdateSequenceNum(sequence);
            tempNotebook.setName(query.valueString(2));
            SimpleDateFormat indfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            try {
                tempNotebook.setServiceCreated(indfm.parse(query.valueString(4)).getTime());
                tempNotebook.setServiceUpdated(indfm.parse(query.valueString(5)).getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            tempNotebook.setPublished(new Boolean(query.valueString(6)).booleanValue());
            if (query.valueString(7) != null && !query.valueString(7).trim().equals("")) {
                tempNotebook.setStack(query.valueString(7));
            }
            if (tempNotebook.isPublished()) {
                Publishing p = new Publishing();
                p.setUri(query.valueString(8));
                p.setAscending(query.valueBoolean(9, false));
                p.setPublicDescription(query.valueString(10));
                p.setOrder(NoteSortOrder.findByValue((int)query.valueInteger(11)));
                if (p.getPublicDescription() != null && p.getPublicDescription().trim().equalsIgnoreCase("")) {
                    p.setPublicDescription(null);
                }
                tempNotebook.setPublishing(p);
            }
            index.add(tempNotebook);
        }
        return index;
    }

    public Notebook getNotebook(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid, sequence, name, defaultNotebook, serviceCreated, serviceUpdated, published, stack, publishinguri, publishingascending, publishingPublicDescription, publishingOrder from " + this.dbName + " where guid=:guid");
        query.bindValue(":guid", guid);
        boolean check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, String.valueOf(this.dbName) + " SQL retrieve has failed.");
        }
        if (query.next()) {
            Notebook tempNotebook = new Notebook();
            tempNotebook.setGuid(query.valueString(0));
            int sequence = new Integer(query.valueString(1));
            tempNotebook.setUpdateSequenceNum(sequence);
            tempNotebook.setName(query.valueString(2));
            SimpleDateFormat indfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            try {
                tempNotebook.setServiceCreated(indfm.parse(query.valueString(4)).getTime());
                tempNotebook.setServiceUpdated(indfm.parse(query.valueString(5)).getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            tempNotebook.setPublished(new Boolean(query.valueString(6)).booleanValue());
            if (query.valueString(7) != null && !query.valueString(7).trim().equals("")) {
                tempNotebook.setStack(query.valueString(7));
            }
            if (tempNotebook.isPublished()) {
                Publishing p = new Publishing();
                p.setUri(query.valueString(8));
                p.setAscending(query.valueBoolean(9, false));
                p.setPublicDescription(query.valueString(10));
                p.setOrder(NoteSortOrder.findByValue((int)query.valueInteger(11)));
                if (p.getPublicDescription() != null && p.getPublicDescription().trim().equalsIgnoreCase("")) {
                    p.setPublicDescription(null);
                }
                tempNotebook.setPublishing(p);
            }
            return tempNotebook;
        }
        return null;
    }

    public void syncNotebook(Notebook notebook, boolean isDirty) {
        if (!this.exists(notebook.getGuid())) {
            this.addNotebook(notebook, isDirty, isDirty);
            return;
        }
        this.updateNotebook(notebook, isDirty);
    }

    public void syncLinkedNotebook(Notebook notebook, boolean isDirty, boolean readOnly) {
        if (!this.exists(notebook.getGuid())) {
            this.addNotebook(notebook, isDirty, false, true, readOnly);
            return;
        }
        this.updateNotebook(notebook, isDirty);
    }

    private boolean exists(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid from " + this.dbName + " where guid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, String.valueOf(this.dbName) + " SQL retrieve has failed.");
        }
        boolean retval = query.next();
        return retval;
    }

    public void resetDirtyFlag(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update " + this.dbName + " set isdirty='false' where guid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error resetting " + this.dbName + " dirty field.");
        }
    }

    public void setDefaultNotebook(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update " + this.dbName + " set defaultNotebook=false, isDirty=true where linked=false and defaultNotebook=true");
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error removing default " + this.dbName + ".");
        }
        query.prepare("Update " + this.dbName + " set defaultNotebook=true, isDirty=true where guid=:guid and linked=false");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error setting default " + this.dbName + ".");
        }
    }

    public HashMap<String, QIcon> getAllIcons() {
        HashMap<String, QIcon> values = new HashMap<String, QIcon>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.exec("SELECT guid, icon from " + this.dbName + " where ARCHIVED  != true")) {
            this.logger.log(this.logger.EXTREME, "Error executing " + this.dbName + " getAllIcons select.");
        }
        while (query.next()) {
            if (query.getBlob(1) == null) continue;
            String guid = query.valueString(0);
            QByteArray blob = new QByteArray(query.getBlob(1));
            QIcon icon = new QIcon(QPixmap.fromImage((QImage)QImage.fromData((QByteArray)blob)));
            values.put(guid, icon);
        }
        return values;
    }

    public QIcon getIcon(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Select icon from " + this.dbName + " where guid=:guid")) {
            this.logger.log(this.logger.EXTREME, "Error preparing " + this.dbName + " icon select.");
        }
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error finding " + this.dbName + " icon.");
        }
        if (!query.next() || query.getBlob(0) == null) {
            return null;
        }
        QByteArray blob = new QByteArray(query.getBlob(0));
        QIcon icon = new QIcon(QPixmap.fromImage((QImage)QImage.fromData((QByteArray)blob)));
        return icon;
    }

    public QByteArray getIconAsByteArray(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Select icon from " + this.dbName + " where guid=:guid")) {
            this.logger.log(this.logger.EXTREME, "Error preparing " + this.dbName + " icon select.");
        }
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error finding " + this.dbName + " icon.");
        }
        if (!query.next() || query.getBlob(0) == null) {
            return null;
        }
        QByteArray blob = new QByteArray(query.getBlob(0));
        return blob;
    }

    public void setIcon(String guid, QIcon icon, String type) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (icon == null) {
            if (!query.prepare("update " + this.dbName + " set icon=null where guid=:guid")) {
                this.logger.log(this.logger.EXTREME, "Error preparing " + this.dbName + " icon select.");
            }
        } else {
            QBuffer buffer;
            if (!query.prepare("update " + this.dbName + " set icon=:icon where guid=:guid")) {
                this.logger.log(this.logger.EXTREME, "Error preparing " + this.dbName + " icon select.");
            }
            if (!(buffer = new QBuffer()).open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadWrite})) {
                this.logger.log(this.logger.EXTREME, "Failure to open buffer.  Aborting.");
                return;
            }
            QPixmap p = icon.pixmap(32, 32);
            QImage i = p.toImage();
            i.save((QIODevice)buffer, type.toUpperCase());
            buffer.close();
            QByteArray b = new QByteArray(buffer.buffer());
            if (!b.isNull() && !b.isEmpty()) {
                query.bindValue(":icon", b.toByteArray());
            } else {
                return;
            }
        }
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.LOW, "Error setting " + this.dbName + " icon. " + query.lastError());
        }
    }

    public void setReadOnly(String guid, boolean readOnly) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("update " + this.dbName + " set readOnly=:readOnly where guid=:guid")) {
            this.logger.log(this.logger.EXTREME, "Error preparing " + this.dbName + " read only.");
        }
        query.bindValue(":guid", guid);
        query.bindValue(":readOnly", readOnly);
        if (!query.exec()) {
            this.logger.log(this.logger.LOW, "Error setting " + this.dbName + " read only. " + query.lastError());
        }
    }

    public String findNotebookByName(String newname) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid from " + this.dbName + " where name=:newname");
        query.bindValue(":newname", newname);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, String.valueOf(this.dbName) + " SQL retrieve has failed.");
        }
        String val = null;
        if (query.next()) {
            val = query.valueString(0);
        }
        return val;
    }

    /*
     * Unable to fully structure code
     */
    public List<Pair<String, Integer>> getNotebookCounts() {
        counts = new ArrayList<Pair<String, Integer>>();
        if (this.notebookCountQuery == null) {
            this.notebookCountQuery = new NSqlQuery(this.db.getConnection());
            this.notebookCountQuery.prepare("select notebookGuid, count(guid) from note where active=1 group by notebookguid;");
        }
        if (this.notebookCountQuery.exec()) ** GOTO lbl15
        this.logger.log(this.logger.EXTREME, "NoteTags SQL getTagCounts has failed.");
        this.logger.log(this.logger.MEDIUM, this.notebookCountQuery.lastError());
        return null;
lbl-1000:
        // 1 sources

        {
            newCount = new Pair<String, Integer>();
            newCount.setFirst(this.notebookCountQuery.valueString(0));
            newCount.setSecond(this.notebookCountQuery.valueInteger(1));
            counts.add(newCount);
lbl15:
            // 2 sources

            ** while (this.notebookCountQuery.next())
        }
lbl16:
        // 1 sources

        return counts;
    }

    public void clearStack(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update " + this.dbName + " set stack='' where guid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error clearing " + this.dbName + " stack.");
        }
    }

    public void setStack(String guid, String stack) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update " + this.dbName + " set stack=:stack, isDirty=true where guid=:guid");
        query.bindValue(":guid", guid);
        query.bindValue(":stack", stack);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error setting notebook stack.");
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<String> getAllStackNames() {
        stacks = new ArrayList<String>();
        query = new NSqlQuery(this.db.getConnection());
        if (query.exec("Select distinct stack from " + this.dbName)) ** GOTO lbl9
        this.logger.log(this.logger.EXTREME, "Error getting all stack names.");
        return null;
lbl-1000:
        // 1 sources

        {
            if (query.valueString(0) == null || query.valueString(0).trim().equals("")) continue;
            stacks.add(query.valueString(0));
lbl9:
            // 3 sources

            ** while (query.next())
        }
lbl10:
        // 1 sources

        return stacks;
    }

    public void renameStacks(String oldName, String newName) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("update " + this.dbName + " set stack=:newName where stack=:oldName")) {
            this.logger.log(this.logger.EXTREME, "Error preparing in renameStacks.");
            return;
        }
        query.bindValue(":oldName", oldName);
        query.bindValue(":newName", newName);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error updating stack names");
            return;
        }
        if (!query.prepare("update SystemIcon set name=:newName where name=:oldName and type='STACK'")) {
            this.logger.log(this.logger.EXTREME, "Error preparing icon rename in renameStacks.");
            return;
        }
        query.bindValue(":oldName", oldName);
        query.bindValue(":newName", newName);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error updating stack names for SystemIcon");
            return;
        }
    }

    public boolean stackExists(String stack) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid from " + this.dbName + " where stack=:stack limit 1");
        query.bindValue(":stack", stack);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error setting " + this.dbName + " stack.");
        }
        return query.next();
    }

    public void setPublishing(String guid, boolean published, Publishing p) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update " + this.dbName + " set publishingPublicDescription=:publishingPublicDescription, " + "publishingUri=:publishingUri, publishingOrder=:publishingOrder, published=:published, " + "publishingAscending=:publishingAscending, isdirty=true where " + "guid=:guid");
        query.bindValue(":publishingPublicDescription", p.getPublicDescription());
        query.bindValue(":publishingUri", p.getUri());
        query.bindValue(":publishingOrder", p.getOrder().getValue());
        query.bindValue(":publishingAscending", p.isAscending());
        query.bindValue(":publishingPublicDescription", p.getPublicDescription());
        query.bindValue(":published", published);
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error setting " + this.dbName + " stack.");
        }
    }

    public String getNotebookByUri(String uri) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select guid from " + this.dbName + " where publishingUri=:uri");
        query.bindValue(":uri", uri);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL retrieve guid by uri has failed.");
        }
        if (query.next()) {
            return query.valueString(0);
        }
        return null;
    }

    public int getSortColumn(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = Global.getSortOrder() != Global.View_List_Wide ? query.prepare("Select wide_sort_column from " + this.dbName + " where guid=:guid") : query.prepare("Select narrow_sort_column from " + this.dbName + " where guid=:guid");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL retrieve sort order has failed.");
            return -1;
        }
        if (query.next()) {
            return query.valueInteger(0);
        }
        return -1;
    }

    public int getSortOrder(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = Global.getSortOrder() != Global.View_List_Wide ? query.prepare("Select wide_sort_order from " + this.dbName + " where guid=:guid") : query.prepare("Select narrow_sort_order from " + this.dbName + " where guid=:guid");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL retrieve sort order has failed.");
            return -1;
        }
        if (query.next()) {
            return query.valueInteger(0);
        }
        return -1;
    }

    public void setSortOrder(String guid, int column, int order) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = Global.getSortOrder() != Global.View_List_Wide ? query.prepare("Update " + this.dbName + " set wide_sort_order=:order, wide_sort_column=:column where guid=:guid") : query.prepare("Update " + this.dbName + " set narrow_sort_order=:order, narrow_sort_column=:column where guid=:guid");
        query.bindValue(":guid", guid);
        query.bindValue(":order", order);
        query.bindValue(":column", column);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL set sort order has failed.");
        }
    }

    public boolean isLinked(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select guid from " + this.dbName + " where guid=:guid and linked=true");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL isLinked failed.");
        }
        return query.next();
    }

    public List<String> getValidLinkedTags(String guid) {
        ArrayList<String> tags = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("select distinct tagGuid from noteTags where noteGuid in (SELECT guid from note where notebookguid=:guid)");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL getValidLinedTags failed.");
        }
        while (query.next()) {
            tags.add(query.valueString(0));
        }
        return tags;
    }

    public void deleteLinkedTags(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("select distinct tagguid from noteTags where noteGuid in (SELECT guid from note where notebookguid=:guid)");
        query.bindValue(":guid", guid);
        boolean check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL getValidLinedTags failed.");
        }
        while (query.next()) {
            this.db.getTagTable().expungeTag(query.valueString(0), false);
        }
        query.prepare("delete from note where notebookguid=:guid");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL getValidLinedTags failed.");
        }
    }

    public void convertFromSharedNotebook(String guid, boolean local) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update Notebook set sequence=0, published=false, isdirty=true, local=:local, publishinguri='' where guid=:guid");
        query.bindValue(":guid", guid);
        if (local) {
            query.bindValue(":local", true);
        } else {
            query.bindValue(":local", false);
        }
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "NotebookTable.convertToLocalNotebook error.");
        }
        query.prepare("Update Note set updatesequencenumber=0, isdirty=true where notebookguid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "NotebookTable.convertToLocalNotebook #2 error.");
        }
    }
}

