/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.evernote.edam.type.Note;
import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.core.QAbstractItemModel;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QModelIndex;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAbstractItemDelegate;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QContextMenuEvent;
import com.trolltech.qt.gui.QDragEnterEvent;
import com.trolltech.qt.gui.QDropEvent;
import com.trolltech.qt.gui.QFontMetrics;
import com.trolltech.qt.gui.QKeyEvent;
import com.trolltech.qt.gui.QKeySequence;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QTableView;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.NeverNote;
import cx.fbn.nevernote.evernote.NoteMetadata;
import cx.fbn.nevernote.filters.NoteSortFilterProxyModel;
import cx.fbn.nevernote.gui.NoteTableDateDelegate;
import cx.fbn.nevernote.gui.TableViewHeader;
import cx.fbn.nevernote.signals.NoteSignal;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.ListManager;
import java.util.List;
import java.util.SortedMap;

public class TableView
extends QTableView {
    private final ListManager runner;
    private final ApplicationLogger logger;
    public NoteSortFilterProxyModel proxyModel;
    private QAction deleteAction;
    private QAction addAction;
    private QAction restoreAction;
    private QAction noteHistoryAction;
    private QAction duplicateAction;
    private QAction mergeNotesAction;
    private QAction openNewTabAction;
    private QAction addNoteNewTabAction;
    private QAction noteTitleColorWhite;
    private QAction noteTitleColorRed;
    private QAction noteTitleColorBlue;
    private QAction noteTitleColorGreen;
    private QAction noteTitleColorYellow;
    private QAction noteTitleColorBlack;
    private QAction noteTitleColorGray;
    private QAction noteTitleColorCyan;
    private QAction noteTitleColorMagenta;
    private QAction notePinned;
    private QAction copyAsUrlAction;
    public TableViewHeader header;
    int fontHeight;
    public QSignalEmitter.Signal1<String> rowChanged;
    public QSignalEmitter.Signal0 resetViewport;
    public NoteSignal noteSignal;
    private final NeverNote parent;

    public TableView(ApplicationLogger l, ListManager m, NeverNote parent) {
        this.parent = parent;
        this.logger = l;
        this.header = new TableViewHeader(Qt.Orientation.Horizontal, (QWidget)this);
        this.setHorizontalHeader(this.header);
        this.header.setMovable(true);
        this.header.subjectDateAction.toggled.connect((Object)this, "toggleSubjectDate(Boolean)");
        this.header.createdDateAction.toggled.connect((Object)this, "toggleCreationDate(Boolean)");
        this.header.changedDateAction.toggled.connect((Object)this, "toggleChangedDate(Boolean)");
        this.header.authorAction.toggled.connect((Object)this, "toggleAuthor(Boolean)");
        this.header.urlAction.toggled.connect((Object)this, "toggleSourceUrl(Boolean)");
        this.header.pinnedAction.toggled.connect((Object)this, "togglePinned(Boolean)");
        this.header.tagsAction.toggled.connect((Object)this, "toggleTags(Boolean)");
        this.header.notebookAction.toggled.connect((Object)this, "toggleNotebook(Boolean)");
        this.header.synchronizedAction.toggled.connect((Object)this, "toggleSynchronized(Boolean)");
        this.header.guidAction.toggled.connect((Object)this, "toggleGuid(Boolean)");
        this.header.thumbnailAction.toggled.connect((Object)this, "toggleThumbnail(Boolean)");
        this.header.titleAction.toggled.connect((Object)this, "toggleTitle(Boolean)");
        this.noteSignal = new NoteSignal();
        this.setAcceptDrops(true);
        this.setDragEnabled(true);
        this.setDragDropMode(QAbstractItemView.DragDropMode.DragDrop);
        this.setDropIndicatorShown(false);
        this.runner = m;
        this.runner.getNoteTableModel().setHeaderData(Global.noteTableCreationPosition, Qt.Orientation.Horizontal, this.tr("Date Created"), 0);
        this.runner.getNoteTableModel().setHeaderData(Global.noteTableTagPosition, Qt.Orientation.Horizontal, this.tr("Tags"), 0);
        this.runner.getNoteTableModel().setHeaderData(Global.noteTableGuidPosition, Qt.Orientation.Horizontal, this.tr("Guid"), 0);
        this.runner.getNoteTableModel().setHeaderData(Global.noteTableNotebookPosition, Qt.Orientation.Horizontal, this.tr("Notebook"), 0);
        this.runner.getNoteTableModel().setHeaderData(Global.noteTableTitlePosition, Qt.Orientation.Horizontal, this.tr("Title"), 0);
        this.runner.getNoteTableModel().setHeaderData(Global.noteTableChangedPosition, Qt.Orientation.Horizontal, this.tr("Date Changed"), 0);
        this.runner.getNoteTableModel().setHeaderData(Global.noteTableAuthorPosition, Qt.Orientation.Horizontal, this.tr("Author"), 0);
        this.runner.getNoteTableModel().setHeaderData(Global.noteTableSourceUrlPosition, Qt.Orientation.Horizontal, this.tr("Source Url"), 0);
        this.runner.getNoteTableModel().setHeaderData(Global.noteTableSubjectDatePosition, Qt.Orientation.Horizontal, this.tr("Subject Date"), 0);
        this.runner.getNoteTableModel().setHeaderData(Global.noteTableSynchronizedPosition, Qt.Orientation.Horizontal, this.tr("Sync"), 0);
        this.runner.getNoteTableModel().setHeaderData(Global.noteTablePinnedPosition, Qt.Orientation.Horizontal, this.tr("Pinned"), 0);
        this.runner.getNoteTableModel().setHeaderData(Global.noteTableThumbnailPosition, Qt.Orientation.Horizontal, this.tr("Thumbnail"), 0);
        this.header.sortIndicatorChanged.connect((Object)this, "resetViewport()");
        this.proxyModel = new NoteSortFilterProxyModel((QObject)this);
        this.proxyModel.setSourceModel((QAbstractItemModel)this.runner.getNoteTableModel());
        this.setAlternatingRowColors(false);
        this.setModel((QAbstractItemModel)this.proxyModel);
        this.runner.getNoteTableModel().setSortProxyModel(this.proxyModel);
        this.setSortingEnabled(true);
        int sortCol = this.proxyModel.sortColumn();
        Qt.SortOrder sortOrder = this.proxyModel.sortOrder();
        this.sortByColumn(sortCol, sortOrder);
        this.setSelectionBehavior(QAbstractItemView.SelectionBehavior.SelectRows);
        this.setSelectionMode(QAbstractItemView.SelectionMode.SingleSelection);
        this.verticalHeader().setVisible(false);
        this.hideColumn(Global.noteTableGuidPosition);
        this.setShowGrid(false);
        this.setEditTriggers(new QAbstractItemView.EditTrigger[]{QAbstractItemView.EditTrigger.NoEditTriggers});
        QFontMetrics f = QApplication.fontMetrics();
        this.fontHeight = f.height();
        this.rowChanged = new QSignalEmitter.Signal1((QSignalEmitter)this);
        this.resetViewport = new QSignalEmitter.Signal0((QSignalEmitter)this);
        NoteTableDateDelegate dateDelegate = new NoteTableDateDelegate();
        this.setItemDelegateForColumn(Global.noteTableCreationPosition, (QAbstractItemDelegate)dateDelegate);
        this.setItemDelegateForColumn(Global.noteTableChangedPosition, (QAbstractItemDelegate)dateDelegate);
        this.setItemDelegateForColumn(Global.noteTableSubjectDatePosition, (QAbstractItemDelegate)dateDelegate);
    }

    private void resetViewport() {
    }

    public void load(boolean reload) {
        this.proxyModel.clear();
        this.setSortingEnabled(false);
        QFontMetrics f = QApplication.fontMetrics();
        if (!Global.isColumnVisible("thumbnail")) {
            this.verticalHeader().setDefaultSectionSize(f.height());
        } else if (Global.getListView() == Global.View_List_Wide) {
            this.verticalHeader().setDefaultSectionSize(Global.smallThumbnailSize.height());
        } else {
            this.verticalHeader().setDefaultSectionSize(Global.largeThumbnailSize.height());
        }
        int i = 0;
        while (i < this.runner.getNoteIndex().size()) {
            String guid = this.runner.getNoteIndex().get(i).getGuid();
            NoteMetadata metaInfo = this.runner.getNoteMetadata().get(guid);
            if (Global.showDeleted && !this.runner.getNoteIndex().get(i).isActive()) {
                this.proxyModel.addGuid(guid, null);
            }
            if (!Global.showDeleted && (this.runner.getNoteIndex().get(i).isActive() || metaInfo.isPinned())) {
                this.proxyModel.addGuid(guid, metaInfo);
            }
            ++i;
        }
        if (!reload) {
            this.logger.log(this.logger.EXTREME, "TableView.load() reload starting.");
            this.proxyModel.filter();
            this.setSortingEnabled(true);
            this.logger.log(this.logger.EXTREME, "TableView.load() leaving reload.");
            return;
        }
        this.logger.log(this.logger.EXTREME, "TableView.load() Filling table data from scratch");
        i = 0;
        while (i < this.runner.getMasterNoteIndex().size()) {
            if (this.runner.getMasterNoteIndex().get(i) != null) {
                Note note = this.runner.getMasterNoteIndex().get(i);
                NoteMetadata meta = this.runner.getNoteMetadata().get(note.getGuid());
                this.insertRow(this.runner.getMasterNoteIndex().get(i), meta, false, i);
            }
            ++i;
        }
        this.proxyModel.invalidate();
        this.resizeColumnWidths();
        this.repositionColumns();
        this.proxyModel.filter();
        this.setSortingEnabled(true);
        this.resetViewport.emit();
    }

    public void repositionColumns() {
        int from = this.header.visualIndex(Global.noteTableCreationPosition);
        int to = Global.getColumnPosition("noteTableCreationPosition");
        if (to >= 0) {
            this.header.moveSection(from, to);
        }
        from = this.header.visualIndex(Global.noteTableTitlePosition);
        to = Global.getColumnPosition("noteTableTitlePosition");
        if (to >= 0) {
            this.header.moveSection(from, to);
        }
        from = this.header.visualIndex(Global.noteTableTagPosition);
        to = Global.getColumnPosition("noteTableTagPosition");
        if (to >= 0) {
            this.header.moveSection(from, to);
        }
        from = this.header.visualIndex(Global.noteTableNotebookPosition);
        to = Global.getColumnPosition("noteTableNotebookPosition");
        if (to >= 0) {
            this.header.moveSection(from, to);
        }
        from = this.header.visualIndex(Global.noteTableChangedPosition);
        to = Global.getColumnPosition("noteTableChangedPosition");
        if (to >= 0) {
            this.header.moveSection(from, to);
        }
        from = this.header.visualIndex(Global.noteTableSourceUrlPosition);
        to = Global.getColumnPosition("noteTableSourceUrlPosition");
        if (to >= 0) {
            this.header.moveSection(from, to);
        }
        from = this.header.visualIndex(Global.noteTableAuthorPosition);
        to = Global.getColumnPosition("noteTableAuthorPosition");
        if (to >= 0) {
            this.header.moveSection(from, to);
        }
        from = this.header.visualIndex(Global.noteTableSubjectDatePosition);
        to = Global.getColumnPosition("noteTableSubjectDatePosition");
        if (to >= 0) {
            this.header.moveSection(from, to);
        }
        from = this.header.visualIndex(Global.noteTableSynchronizedPosition);
        to = Global.getColumnPosition("noteTableSynchronizedPosition");
        if (to >= 0) {
            this.header.moveSection(from, to);
        }
        from = this.header.visualIndex(Global.noteTablePinnedPosition);
        to = Global.getColumnPosition("noteTablePinnedPosition");
        if (to >= 0) {
            this.header.moveSection(from, to);
        }
        from = this.header.visualIndex(Global.noteTableGuidPosition);
        to = Global.getColumnPosition("noteTableGuidPosition");
        if (to >= 0) {
            this.header.moveSection(from, to);
        }
        from = this.header.visualIndex(Global.noteTableThumbnailPosition);
        to = Global.getColumnPosition("noteTableThumbnailPosition");
        if (to >= 0) {
            this.header.moveSection(from, to);
        }
    }

    public void resizeColumnWidths() {
        int width = Global.getColumnWidth("noteTableCreationPosition");
        if (width > 0) {
            this.setColumnWidth(Global.noteTableCreationPosition, width);
        }
        if ((width = Global.getColumnWidth("noteTableChangedPosition")) > 0) {
            this.setColumnWidth(Global.noteTableChangedPosition, width);
        }
        if ((width = Global.getColumnWidth("noteTableTitlePosition")) > 0) {
            this.setColumnWidth(Global.noteTableTitlePosition, width);
        }
        if ((width = Global.getColumnWidth("noteTableTagPosition")) > 0) {
            this.setColumnWidth(Global.noteTableTagPosition, width);
        }
        if ((width = Global.getColumnWidth("noteTableGuidPosition")) > 0) {
            this.setColumnWidth(Global.noteTableGuidPosition, width);
        }
        if ((width = Global.getColumnWidth("noteTableNotebookPosition")) > 0) {
            this.setColumnWidth(Global.noteTableNotebookPosition, width);
        }
        if ((width = Global.getColumnWidth("noteTableSourceUrlPosition")) > 0) {
            this.setColumnWidth(Global.noteTableSourceUrlPosition, width);
        }
        if ((width = Global.getColumnWidth("noteTableAuthorPosition")) > 0) {
            this.setColumnWidth(Global.noteTableAuthorPosition, width);
        }
        if ((width = Global.getColumnWidth("noteTableSubjectDatePosition")) > 0) {
            this.setColumnWidth(Global.noteTableSubjectDatePosition, width);
        }
        if ((width = Global.getColumnWidth("noteTableSynchronizedPosition")) > 0) {
            this.setColumnWidth(Global.noteTableSynchronizedPosition, width);
        }
        if ((width = Global.getColumnWidth("noteTableThumbnailPosition")) > 0) {
            this.setColumnWidth(Global.noteTablePinnedPosition, width);
        }
        if ((width = Global.getColumnWidth("noteTablePinnedPosition")) > 0) {
            this.setColumnWidth(Global.noteTableThumbnailPosition, width);
        }
        if ((width = Global.getColumnWidth("noteTableGuidPosition")) > 0) {
            this.setColumnWidth(Global.noteTableGuidPosition, width);
        }
    }

    public void resizeRowHeights() {
        int height;
        if (!Global.isColumnVisible("thumbnail") || !Global.enableThumbnails()) {
            QFontMetrics f = QApplication.fontMetrics();
            this.verticalHeader().setDefaultSectionSize(f.height());
            height = this.fontHeight;
        } else if (Global.getListView() == Global.View_List_Wide) {
            this.verticalHeader().setDefaultSectionSize(Global.smallThumbnailSize.height());
            height = Global.smallThumbnailSize.height();
        } else {
            this.verticalHeader().setDefaultSectionSize(Global.largeThumbnailSize.height());
            height = Global.largeThumbnailSize.height();
        }
        int i = 0;
        while (i < this.runner.getNoteTableModel().rowCount()) {
            this.setRowHeight(i, height);
            ++i;
        }
    }

    public void insertRow(Note tempNote, NoteMetadata meta, boolean newNote, int row) {
        if (newNote) {
            this.proxyModel.addGuid(tempNote.getGuid(), meta);
        }
        if (row > this.runner.getNoteTableModel().rowCount()) {
            this.runner.getNoteTableModel().insertRow(0);
        }
        if (row < 0) {
            row = this.runner.getNoteTableModel().rowCount();
            this.runner.getNoteTableModel().insertRow(row);
        }
        if (newNote) {
            this.resizeRowHeights();
        }
    }

    protected boolean filterAcceptsRow(int sourceRow, QModelIndex sourceParent) {
        return true;
    }

    public void setAddAction(QAction a) {
        this.addAction = a;
    }

    public void setMergeNotesAction(QAction a) {
        this.mergeNotesAction = a;
    }

    public void setCopyAsUrlAction(QAction a) {
        this.copyAsUrlAction = a;
    }

    public void setNoteHistoryAction(QAction a) {
        this.noteHistoryAction = a;
    }

    public void setDeleteAction(QAction d) {
        this.deleteAction = d;
    }

    public void setRestoreAction(QAction r) {
        this.restoreAction = r;
    }

    public void setNoteDuplicateAction(QAction d) {
        this.duplicateAction = d;
    }

    public void setOpenNewTabAction(QAction t) {
        this.openNewTabAction = t;
    }

    public void setAddNoteNewTabAction(QAction t) {
        this.addNoteNewTabAction = t;
    }

    public void keyPressEvent(QKeyEvent e) {
        if (e.matches(QKeySequence.StandardKey.MoveToStartOfDocument) && this.runner.getNoteTableModel().rowCount() > 0) {
            this.clearSelection();
            this.selectRow(0);
        }
        if (e.matches(QKeySequence.StandardKey.MoveToEndOfDocument) && this.runner.getNoteTableModel().rowCount() > 0) {
            this.clearSelection();
            this.selectRow(this.model().rowCount() - 1);
        }
        super.keyPressEvent(e);
    }

    public void contextMenuEvent(QContextMenuEvent event) {
        QMenu menu = new QMenu((QWidget)this);
        menu.addAction(this.openNewTabAction);
        menu.addSeparator();
        if (Global.showDeleted) {
            menu.addAction(this.restoreAction);
        } else {
            menu.addAction(this.addAction);
            if (this.parent.getCurrentNoteGuid() != null && !this.parent.getCurrentNoteGuid().equals("")) {
                menu.addAction(this.addNoteNewTabAction);
            }
        }
        menu.addSeparator();
        menu.addAction(this.deleteAction);
        menu.addSeparator();
        menu.addAction(this.duplicateAction);
        menu.addAction(this.copyAsUrlAction);
        menu.addSeparator();
        menu.addAction(this.noteHistoryAction);
        menu.addAction(this.mergeNotesAction);
        QMenu titleColorMenu = new QMenu((QWidget)this);
        titleColorMenu.setTitle(this.tr("Title Color"));
        menu.addMenu(titleColorMenu);
        this.noteTitleColorWhite = new QAction((QObject)titleColorMenu);
        this.noteTitleColorRed = new QAction((QObject)titleColorMenu);
        this.noteTitleColorBlue = new QAction((QObject)titleColorMenu);
        this.noteTitleColorGreen = new QAction((QObject)titleColorMenu);
        this.noteTitleColorYellow = new QAction((QObject)titleColorMenu);
        this.noteTitleColorBlack = new QAction((QObject)titleColorMenu);
        this.noteTitleColorGray = new QAction((QObject)titleColorMenu);
        this.noteTitleColorCyan = new QAction((QObject)titleColorMenu);
        this.noteTitleColorMagenta = new QAction((QObject)titleColorMenu);
        this.notePinned = new QAction((QObject)titleColorMenu);
        menu.addAction(this.notePinned);
        this.noteTitleColorWhite.setText(this.tr("White"));
        this.noteTitleColorRed.setText(this.tr("Red"));
        this.noteTitleColorBlue.setText(this.tr("Blue"));
        this.noteTitleColorGreen.setText(this.tr("Green"));
        this.noteTitleColorYellow.setText(this.tr("Yellow"));
        this.noteTitleColorBlack.setText(this.tr("Black"));
        this.noteTitleColorGray.setText(this.tr("Gray"));
        this.noteTitleColorCyan.setText(this.tr("Cyan"));
        this.noteTitleColorMagenta.setText(this.tr("Magenta"));
        this.notePinned.setText(this.tr("Pin/Unpin"));
        titleColorMenu.addAction(this.noteTitleColorWhite);
        titleColorMenu.addAction(this.noteTitleColorRed);
        titleColorMenu.addAction(this.noteTitleColorBlue);
        titleColorMenu.addAction(this.noteTitleColorGreen);
        titleColorMenu.addAction(this.noteTitleColorYellow);
        titleColorMenu.addAction(this.noteTitleColorBlack);
        titleColorMenu.addAction(this.noteTitleColorGray);
        titleColorMenu.addAction(this.noteTitleColorCyan);
        titleColorMenu.addAction(this.noteTitleColorMagenta);
        this.noteTitleColorWhite.triggered.connect((Object)this, "titleColorWhite()");
        this.noteTitleColorWhite.triggered.connect((Object)this, "titleColorWhite()");
        this.noteTitleColorRed.triggered.connect((Object)this, "titleColorRed()");
        this.noteTitleColorBlue.triggered.connect((Object)this, "titleColorBlue()");
        this.noteTitleColorGreen.triggered.connect((Object)this, "titleColorGreen()");
        this.noteTitleColorYellow.triggered.connect((Object)this, "titleColorYellow()");
        this.noteTitleColorBlack.triggered.connect((Object)this, "titleColorBlack()");
        this.noteTitleColorGray.triggered.connect((Object)this, "titleColorGray()");
        this.noteTitleColorCyan.triggered.connect((Object)this, "titleColorCyan()");
        this.noteTitleColorMagenta.triggered.connect((Object)this, "titleColorMagenta()");
        this.notePinned.triggered.connect((Object)this, "notePinned()");
        menu.exec(event.globalPos());
    }

    private void titleColorWhite() {
        this.noteSignal.titleColorChanged.emit((Object)QColor.white.rgb());
    }

    private void titleColorRed() {
        this.noteSignal.titleColorChanged.emit((Object)QColor.red.rgb());
    }

    private void titleColorBlue() {
        this.noteSignal.titleColorChanged.emit((Object)QColor.blue.rgb());
    }

    private void titleColorGreen() {
        this.noteSignal.titleColorChanged.emit((Object)QColor.green.rgb());
    }

    private void titleColorYellow() {
        this.noteSignal.titleColorChanged.emit((Object)QColor.yellow.rgb());
    }

    private void titleColorBlack() {
        this.noteSignal.titleColorChanged.emit((Object)QColor.black.rgb());
    }

    private void titleColorGray() {
        this.noteSignal.titleColorChanged.emit((Object)QColor.gray.rgb());
    }

    private void titleColorCyan() {
        this.noteSignal.titleColorChanged.emit((Object)QColor.cyan.rgb());
    }

    private void titleColorMagenta() {
        this.noteSignal.titleColorChanged.emit((Object)QColor.magenta.rgb());
    }

    private void notePinned() {
        this.noteSignal.notePinned.emit();
    }

    public void dragEnterEvent(QDragEnterEvent event) {
        StringBuffer guid = new StringBuffer(1000);
        this.showColumn(Global.noteTableGuidPosition);
        List selections = this.selectionModel().selectedRows();
        this.hideColumn(Global.noteTableGuidPosition);
        if (selections.size() > 0) {
            int i = 0;
            while (i < selections.size()) {
                int row = ((QModelIndex)selections.get(i)).row();
                QModelIndex index = this.proxyModel.index(row, Global.noteTableGuidPosition);
                SortedMap ix = this.proxyModel.itemData(index);
                guid.append((String)ix.values().toArray()[0]);
                guid.append(" ");
                ++i;
            }
        }
        event.mimeData().setData("application/x-nevernote-note", new QByteArray(guid.toString()));
        event.accept();
    }

    public void dropEvent(QDropEvent event) {
        if (event.source() == this) {
            event.ignore();
        }
    }

    public int getColumnWidth(int col) {
        return this.columnWidth(col);
    }

    public void toggleSubjectDate(Boolean toggle) {
        Global.saveColumnVisible("dateSubject", toggle);
        this.setColumnHidden(Global.noteTableSubjectDatePosition, toggle == false);
    }

    public void toggleChangedDate(Boolean toggle) {
        Global.saveColumnVisible("dateChanged", toggle);
        this.setColumnHidden(Global.noteTableChangedPosition, toggle == false);
    }

    public void toggleCreationDate(Boolean toggle) {
        Global.saveColumnVisible("dateCreated", toggle);
        this.setColumnHidden(Global.noteTableCreationPosition, toggle == false);
    }

    public void toggleSourceUrl(Boolean toggle) {
        Global.saveColumnVisible("sourceUrl", toggle);
        this.setColumnHidden(Global.noteTableSourceUrlPosition, toggle == false);
    }

    public void toggleAuthor(Boolean toggle) {
        Global.saveColumnVisible("author", toggle);
        this.setColumnHidden(Global.noteTableAuthorPosition, toggle == false);
    }

    public void toggleNotebook(Boolean toggle) {
        Global.saveColumnVisible("notebook", toggle);
        this.setColumnHidden(Global.noteTableNotebookPosition, toggle == false);
    }

    public void toggleTitle(Boolean toggle) {
        Global.saveColumnVisible("title", toggle);
        this.setColumnHidden(Global.noteTableTitlePosition, toggle == false);
    }

    public void toggleTags(Boolean toggle) {
        Global.saveColumnVisible("tags", toggle);
        this.setColumnHidden(Global.noteTableTagPosition, toggle == false);
    }

    public void toggleSynchronized(Boolean toggle) {
        Global.saveColumnVisible("synchronized", toggle);
        this.setColumnHidden(Global.noteTableSynchronizedPosition, toggle == false);
    }

    public void togglePinned(Boolean toggle) {
        Global.saveColumnVisible("pinned", toggle);
        this.setColumnHidden(Global.noteTablePinnedPosition, toggle == false);
    }

    public void toggleGuid(Boolean toggle) {
        Global.saveColumnVisible("guid", toggle);
        this.setColumnHidden(Global.noteTableGuidPosition, toggle == false);
    }

    public void toggleThumbnail(Boolean toggle) {
        int size;
        Global.saveColumnVisible("thumbnail", toggle);
        if (!toggle.booleanValue()) {
            QFontMetrics f = QApplication.fontMetrics();
            size = f.height();
            this.verticalHeader().setDefaultSectionSize(f.height());
        } else {
            size = Global.smallThumbnailSize.height();
        }
        int i = 0;
        while (i < this.runner.getNoteTableModel().rowCount()) {
            this.setRowHeight(i, size);
            ++i;
        }
        this.setColumnHidden(Global.noteTableThumbnailPosition, toggle == false);
    }
}

