/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QCheckBox;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QFormLayout;
import com.trolltech.qt.gui.QGroupBox;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.gui.QScrollArea;
import com.trolltech.qt.gui.QSpinBox;
import com.trolltech.qt.gui.QStyleFactory;
import com.trolltech.qt.gui.QSystemTrayIcon;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import java.util.ArrayList;
import java.util.List;

public class ConfigAppearancePage
extends QWidget {
    private final QComboBox dateFormat;
    private final QComboBox timeFormat;
    private final QComboBox styleFormat;
    private final QComboBox tagBehavior;
    private final QCheckBox standardPalette;
    private final QCheckBox showSplashScreen;
    private final QCheckBox showTrayIcon;
    private final QCheckBox verifyDelete;
    private final QCheckBox pdfPreview;
    private final QCheckBox anyTagSelection;
    private final QCheckBox checkForUpdates;
    private final QCheckBox newNoteWithTags;
    private final QCheckBox mimicEvernote;
    private final QCheckBox startMinimized;
    private final QCheckBox minimizeOnClose;
    private final QCheckBox includeTagChildren;
    private final QCheckBox displayRightToLeft;
    private final QComboBox startupNotebook;
    private final QSpinBox autoSaveInterval;
    private final List<String> tformats;
    private final List<String> dformats = new ArrayList<String>();

    public ConfigAppearancePage(QWidget parent) {
        this.tformats = new ArrayList<String>();
        this.dformats.add("MM/dd/yy - 02/03/09");
        this.dformats.add("MM/dd/yyyy - 02/03/2009");
        this.dformats.add("M/dd/yyyy - 2/03/2009");
        this.dformats.add("M/d/yyyy - 2/3/2009");
        this.dformats.add("dd/MM/yy - 03/02/09");
        this.dformats.add("d/M/yy - 3/2/09");
        this.dformats.add("dd/MM/yyyy - 03/02/2009");
        this.dformats.add("d/M/yyyy - 3/2/2009");
        this.dformats.add("yyyy/MM/dd - 2009/02/03");
        this.dformats.add("yy/MM/dd - 09/02/03");
        this.tformats.add("HH:mm:ss - 18:13:01");
        this.tformats.add("HH:mm:ss a - 18:13:01 pm");
        this.tformats.add("HH:mm - 18:13");
        this.tformats.add("HH:mm a - 18:13 pm");
        this.tformats.add("hh:mm:ss - 06:13:01");
        this.tformats.add("hh:mm:ss a - 06:13:01 pm");
        this.tformats.add("h:mm:ss a - 6:13:01 pm");
        this.tformats.add("hh:mm - 06:13");
        this.tformats.add("hh:mm a - 06:13 pm");
        this.tformats.add("h:mm a - 6:13 pm");
        List styles = QStyleFactory.keys();
        QGroupBox styleGroup = new QGroupBox(this.tr("GUI Style"));
        this.styleFormat = new QComboBox();
        this.styleFormat.addItems(styles);
        this.styleFormat.activated.connect((Object)this, "styleSelected(String)");
        this.standardPalette = new QCheckBox();
        this.standardPalette.setText(this.tr("Use standard palette"));
        this.standardPalette.clicked.connect((Object)this, "standardPaletteChanged()");
        QFormLayout styleLayout = new QFormLayout();
        styleLayout.addWidget((QWidget)this.styleFormat);
        styleLayout.addWidget((QWidget)this.standardPalette);
        styleGroup.setLayout((QLayout)styleLayout);
        QGroupBox tagBehaviorGroup = new QGroupBox(this.tr("Tag Behavior"));
        this.tagBehavior = new QComboBox();
        this.tagBehavior.addItem(this.tr("Do nothing"), (Object)"DoNothing");
        this.tagBehavior.addItem(this.tr("Count tags & do not hide inactive"), (Object)"NoHideInactiveCount");
        this.tagBehavior.addItem(this.tr("Count tags & hide inactive"), (Object)"HideInactiveCount");
        this.tagBehavior.addItem(this.tr("Color active tags"), (Object)"ColorActive");
        QFormLayout tagLayout = new QFormLayout();
        tagLayout.addWidget((QWidget)this.tagBehavior);
        tagBehaviorGroup.setLayout((QLayout)tagLayout);
        QGroupBox datetimeGroup = new QGroupBox(this.tr("Date/Time Format"));
        this.dateFormat = new QComboBox();
        int i = 0;
        while (i < this.dformats.size()) {
            this.dateFormat.addItem(this.tr(this.dformats.get(i)));
            ++i;
        }
        this.timeFormat = new QComboBox();
        i = 0;
        while (i < this.tformats.size()) {
            this.timeFormat.addItem(this.tr(this.tformats.get(i)));
            ++i;
        }
        QFormLayout formatLayout = new QFormLayout();
        formatLayout.addWidget((QWidget)this.dateFormat);
        formatLayout.addWidget((QWidget)this.timeFormat);
        datetimeGroup.setLayout((QLayout)formatLayout);
        this.mimicEvernote = new QCheckBox(this.tr("Mimic Evernote Selection Behavior (Requires Restart)"));
        this.showSplashScreen = new QCheckBox(this.tr("Show Splash Screen on Startup"));
        this.showTrayIcon = new QCheckBox(this.tr("Minimize To Tray"));
        this.minimizeOnClose = new QCheckBox(this.tr("Close To Tray"));
        if (!QSystemTrayIcon.isSystemTrayAvailable()) {
            this.showTrayIcon.setEnabled(false);
            this.minimizeOnClose.setEnabled(false);
        }
        this.verifyDelete = new QCheckBox(this.tr("Verify Deletes"));
        this.startMinimized = new QCheckBox(this.tr("Start Minimized"));
        this.pdfPreview = new QCheckBox(this.tr("Display PDF Documents Inline"));
        this.checkForUpdates = new QCheckBox(this.tr("Check For Updates At Startup"));
        this.newNoteWithTags = new QCheckBox(this.tr("Create New Notes With Selected Tags"));
        this.anyTagSelection = new QCheckBox(this.tr("Display Notes Matching Any Selected Tags"));
        this.includeTagChildren = new QCheckBox(this.tr("Include Children In Tag Selection"));
        this.displayRightToLeft = new QCheckBox(this.tr("Display Notes Right-To-Left"));
        QHBoxLayout startupNotebookLayout = new QHBoxLayout();
        this.startupNotebook = new QComboBox();
        this.startupNotebook.addItem(this.tr("All Notebooks"), (Object)"AllNotebooks");
        this.startupNotebook.addItem(this.tr("Default Notebook"), (Object)"DefaultNotebook");
        startupNotebookLayout.addWidget((QWidget)new QLabel(this.tr("Startup Notebook")));
        startupNotebookLayout.addWidget((QWidget)this.startupNotebook);
        startupNotebookLayout.addStretch();
        QHBoxLayout autoSaveLayout = new QHBoxLayout();
        autoSaveLayout.addWidget((QWidget)new QLabel(this.tr("Automatic Save Interval (in Minutes)")));
        this.autoSaveInterval = new QSpinBox();
        autoSaveLayout.addWidget((QWidget)this.autoSaveInterval);
        this.autoSaveInterval.setMaximum(1440);
        this.autoSaveInterval.setMinimum(0);
        QVBoxLayout mainLayout = new QVBoxLayout((QWidget)this);
        mainLayout.addWidget((QWidget)styleGroup);
        mainLayout.addWidget((QWidget)datetimeGroup);
        mainLayout.addLayout((QLayout)autoSaveLayout);
        mainLayout.addWidget((QWidget)tagBehaviorGroup);
        QVBoxLayout checkboxLayout = new QVBoxLayout();
        checkboxLayout.addWidget((QWidget)this.mimicEvernote);
        checkboxLayout.addLayout((QLayout)startupNotebookLayout);
        checkboxLayout.addWidget((QWidget)this.showTrayIcon);
        checkboxLayout.addWidget((QWidget)this.minimizeOnClose);
        checkboxLayout.addWidget((QWidget)this.startMinimized);
        checkboxLayout.addWidget((QWidget)this.showSplashScreen);
        checkboxLayout.addWidget((QWidget)this.verifyDelete);
        checkboxLayout.addWidget((QWidget)this.pdfPreview);
        checkboxLayout.addWidget((QWidget)this.newNoteWithTags);
        checkboxLayout.addWidget((QWidget)this.anyTagSelection);
        checkboxLayout.addWidget((QWidget)this.includeTagChildren);
        checkboxLayout.addWidget((QWidget)this.displayRightToLeft);
        checkboxLayout.addWidget((QWidget)this.checkForUpdates);
        checkboxLayout.addStretch(1);
        QWidget checkBoxGroup = new QWidget();
        checkBoxGroup.setLayout((QLayout)checkboxLayout);
        QScrollArea scrollArea = new QScrollArea();
        scrollArea.setHorizontalScrollBarPolicy(Qt.ScrollBarPolicy.ScrollBarAsNeeded);
        scrollArea.setVerticalScrollBarPolicy(Qt.ScrollBarPolicy.ScrollBarAsNeeded);
        scrollArea.setWidgetResizable(true);
        scrollArea.setWidget(checkBoxGroup);
        mainLayout.addWidget((QWidget)scrollArea);
        this.setLayout((QLayout)mainLayout);
        this.showTrayIcon.clicked.connect((Object)this, "showTrayIconClicked(Boolean)");
        this.showTrayIconClicked(this.showTrayIcon.isChecked());
    }

    private void showTrayIconClicked(Boolean checked) {
    }

    public void setDateFormat(String id) {
        int i = 0;
        while (i < this.dformats.size()) {
            String d = this.dformats.get(i);
            if (d.substring(0, id.length()).equals(id)) {
                this.dateFormat.setCurrentIndex(i);
            }
            ++i;
        }
    }

    public String getDateFormat() {
        int i = this.dateFormat.currentIndex();
        return this.dateFormat.itemText(i);
    }

    public void setTimeFormat(String id) {
        int i = 0;
        while (i < this.tformats.size()) {
            String d = this.tformats.get(i);
            int dash = d.indexOf("-");
            if ((d = d.substring(0, dash - 1)).equals(id)) {
                this.timeFormat.setCurrentIndex(i);
                return;
            }
            ++i;
        }
    }

    public String getTimeFormat() {
        int i = this.timeFormat.currentIndex();
        return this.timeFormat.itemText(i);
    }

    public void setStyle(String id) {
        int i = 0;
        while (i < this.styleFormat.count()) {
            String d = this.styleFormat.itemText(i);
            if (d.equals(id)) {
                this.styleFormat.setCurrentIndex(i);
            }
            ++i;
        }
    }

    public String getStyle() {
        int i = this.styleFormat.currentIndex();
        return this.styleFormat.itemText(i);
    }

    public void setStandardPalette(boolean value) {
        this.standardPalette.setChecked(value);
    }

    public boolean getStandardPalette() {
        return this.standardPalette.isChecked();
    }

    public void setShowTrayIcon(boolean val) {
        this.showTrayIcon.setChecked(val);
        this.showTrayIconClicked(this.showTrayIcon.isChecked());
    }

    public boolean getShowTrayIcon() {
        return this.showTrayIcon.isChecked();
    }

    public void setMinimizeOnClose(boolean val) {
        this.minimizeOnClose.setChecked(val);
    }

    public boolean getMinimizeOnClose() {
        return this.minimizeOnClose.isChecked();
    }

    public void setShowSplashScreen(boolean val) {
        this.showSplashScreen.setChecked(val);
    }

    public boolean getShowSplashScreen() {
        return this.showSplashScreen.isChecked();
    }

    public void setVerifyDelete(boolean val) {
        this.verifyDelete.setChecked(val);
    }

    public boolean getVerifyDelete() {
        return this.verifyDelete.isChecked();
    }

    public void setPdfPreview(boolean val) {
        this.pdfPreview.setChecked(val);
    }

    public boolean getPdfPreview() {
        return this.pdfPreview.isChecked();
    }

    public void setCheckForUpdates(boolean val) {
        this.checkForUpdates.setChecked(val);
    }

    public boolean getCheckForUpdates() {
        return this.checkForUpdates.isChecked();
    }

    public void styleSelected(String style) {
        QApplication.setStyle((String)style);
        QApplication.setPalette((QPalette)QApplication.style().standardPalette());
    }

    public void standardPaletteChanged() {
        if (this.standardPalette.isChecked()) {
            QApplication.setPalette((QPalette)QApplication.style().standardPalette());
        } else {
            QApplication.setPalette((QPalette)Global.originalPalette);
        }
    }

    public void setAutoSaveInterval(int len) {
        this.autoSaveInterval.setValue(len);
    }

    public int getAutoSaveInterval() {
        return this.autoSaveInterval.value();
    }

    public void setTagBehavior(String value) {
        int i = 0;
        while (i < this.tagBehavior.count()) {
            String d = this.tagBehavior.itemData(i).toString();
            if (value.equalsIgnoreCase(d)) {
                this.tagBehavior.setCurrentIndex(i);
                return;
            }
            ++i;
        }
    }

    public String getTagBehavior() {
        int i = this.tagBehavior.currentIndex();
        return this.tagBehavior.itemData(i).toString();
    }

    public boolean getMimicEvernote() {
        return this.mimicEvernote.isChecked();
    }

    public void setMimicEvernote(boolean val) {
        this.mimicEvernote.setChecked(val);
    }

    public boolean getStartMinimized() {
        return this.startMinimized.isChecked();
    }

    public void setStartMinimized(boolean val) {
        this.startMinimized.setChecked(val);
    }

    public boolean getNewNoteWithTags() {
        return this.newNoteWithTags.isChecked();
    }

    public void setNewNoteWithTags(boolean val) {
        this.newNoteWithTags.setChecked(val);
    }

    public boolean getAnyTagSelection() {
        return this.anyTagSelection.isChecked();
    }

    public void setAnyTagSelection(boolean val) {
        this.anyTagSelection.setChecked(val);
    }

    public boolean getIncludeTagChildren() {
        return this.includeTagChildren.isChecked();
    }

    public void setIncludeTagChildren(boolean val) {
        this.includeTagChildren.setChecked(val);
    }

    public boolean getDisplayRightToLeft() {
        return this.displayRightToLeft.isChecked();
    }

    public void setDisplayRightToLeft(boolean val) {
        this.displayRightToLeft.setChecked(val);
    }

    public void setStartupNotebook(String value) {
        int i = 0;
        while (i < this.startupNotebook.count()) {
            String d = this.startupNotebook.itemData(i).toString();
            if (d.equals(value)) {
                this.startupNotebook.setCurrentIndex(i);
            }
            ++i;
        }
    }

    public String getStartupNotebook() {
        int index = this.startupNotebook.currentIndex();
        return this.startupNotebook.itemData(index).toString();
    }
}

