/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import com.trolltech.qt.core.QByteArray;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.util.ArrayList;
import java.util.List;

public class InkImagesTable {
    private final ApplicationLogger logger;
    DatabaseConnection db;

    public InkImagesTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.HIGH, "Creating table InkImage...");
        if (!query.exec("Create table InkImages (guid varchar, slice integer, primary key(guid, slice), image blob)")) {
            this.logger.log(this.logger.HIGH, "Table InkImage creation FAILED!!!");
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("drop table InkImages");
    }

    public void expungeImage(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Delete from InkImages where guid=:guid ")) {
            this.logger.log(this.logger.EXTREME, "InkImage SQL prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return;
        }
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "InkImage SQL delete has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<QByteArray> getImage(String guid) {
        data = new ArrayList<QByteArray>();
        query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Select image from InkImages where guid = :guid order by slice")) {
            this.logger.log(this.logger.EXTREME, "InkImage SQL prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return null;
        }
        query.bindValue(":guid", guid);
        if (query.exec()) ** GOTO lbl14
        this.logger.log(this.logger.EXTREME, "InkImage SQL exec has failed.");
        this.logger.log(this.logger.MEDIUM, query.lastError());
        return null;
lbl-1000:
        // 1 sources

        {
            data.add(new QByteArray(query.getBlob(0)));
lbl14:
            // 2 sources

            ** while (query.next())
        }
lbl15:
        // 1 sources

        return data;
    }

    public void saveImage(String guid, int slice, QByteArray data) {
        this.logger.log(this.logger.HIGH, "Entering inkImageTable.saveImage");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Insert Into InkImages (guid, slice, image) Values(:guid, :slice, :data)");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "InkImages SQL insert prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return;
        }
        query.bindValue(":guid", guid);
        query.bindValue(":slice", slice);
        query.bindBlob(":data", data.toByteArray());
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "*** InkImages Table insert failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        this.logger.log(this.logger.HIGH, "Leaving InkImages.saveImage");
    }
}

