/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.type.Notebook;
import com.trolltech.qt.core.QModelIndex;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QFontMetrics;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QTableWidget;
import com.trolltech.qt.gui.QTableWidgetItem;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.dialog.WatchFolderAdd;
import cx.fbn.nevernote.sql.WatchFolderRecord;
import java.util.ArrayList;
import java.util.List;

public class WatchFolder
extends QDialog {
    private final QPushButton okButton;
    private final QPushButton cancelButton;
    private final QPushButton addButton;
    private final QPushButton editButton;
    private final QPushButton deleteButton;
    private boolean okClicked;
    public final QTableWidget table;
    private final List<Notebook> notebooks;
    private final List<WatchFolderRecord> records;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public WatchFolder(List<WatchFolderRecord> w, List<Notebook> n) {
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "folder.png"));
        this.okClicked = false;
        this.notebooks = n;
        this.records = w;
        this.okButton = new QPushButton();
        this.okButton.setText(this.tr("OK"));
        this.okButton.pressed.connect((Object)this, "onClicked()");
        this.cancelButton = new QPushButton();
        this.cancelButton.setText(this.tr("Cancel"));
        this.cancelButton.pressed.connect((Object)this, "onCancel()");
        QHBoxLayout horizontalLayout = new QHBoxLayout();
        QHBoxLayout buttonLayout = new QHBoxLayout();
        buttonLayout.addStretch(1);
        buttonLayout.addWidget((QWidget)this.okButton);
        buttonLayout.addWidget((QWidget)this.cancelButton);
        this.setWindowTitle(this.tr("Auto Import Folders"));
        this.table = new QTableWidget(this.records.size(), 3);
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(this.tr("Directory"));
        headers.add(this.tr("Target Notebook"));
        headers.add(this.tr("Keep"));
        this.table.setHorizontalHeaderLabels(headers);
        this.table.verticalHeader().setVisible(false);
        this.table.setAlternatingRowColors(true);
        this.table.setSelectionBehavior(QAbstractItemView.SelectionBehavior.SelectRows);
        this.table.setSelectionMode(QAbstractItemView.SelectionMode.SingleSelection);
        this.table.itemSelectionChanged.connect((Object)this, "tableSelection()");
        horizontalLayout.addWidget((QWidget)this.table);
        this.addButton = new QPushButton();
        this.addButton.setText(this.tr("Add"));
        this.addButton.clicked.connect((Object)this, "addPressed()");
        this.editButton = new QPushButton();
        this.editButton.setText(this.tr("Edit"));
        this.editButton.setEnabled(false);
        this.editButton.clicked.connect((Object)this, "editPressed()");
        this.deleteButton = new QPushButton();
        this.deleteButton.setText(this.tr("Delete"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.clicked.connect((Object)this, "deletePressed()");
        QVBoxLayout editLayout = new QVBoxLayout();
        editLayout.addWidget((QWidget)this.addButton);
        editLayout.addWidget((QWidget)this.editButton);
        editLayout.addWidget((QWidget)this.deleteButton);
        QHBoxLayout listLayout = new QHBoxLayout();
        listLayout.addLayout((QLayout)horizontalLayout);
        listLayout.addLayout((QLayout)editLayout);
        QVBoxLayout mainLayout = new QVBoxLayout();
        mainLayout.addLayout((QLayout)listLayout);
        mainLayout.addSpacing(1);
        mainLayout.addLayout((QLayout)buttonLayout);
        this.setLayout((QLayout)mainLayout);
        this.table.setColumnWidth(0, 160);
        this.resize(500, 200);
        this.load();
    }

    private void onClicked() {
        this.okClicked = true;
        this.close();
    }

    private void onCancel() {
        this.okClicked = false;
        this.close();
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    private void itemSelected() {
        this.okButton.setEnabled(true);
    }

    private void load() {
        int i = 0;
        while (i < this.records.size()) {
            this.addRow(i, this.records.get((int)i).folder, this.records.get((int)i).notebook, this.records.get((int)i).keep);
            ++i;
        }
    }

    private void addRow(int row, String folder, String notebook, boolean keepAfter) {
        QFontMetrics f = QApplication.fontMetrics();
        int fontHeight = f.height();
        QTableWidgetItem dir = new QTableWidgetItem();
        dir.setText(folder);
        this.table.setItem(row, 0, dir);
        this.table.setRowHeight(row, fontHeight);
        dir.setToolTip(folder);
        QTableWidgetItem book = new QTableWidgetItem();
        book.setText(notebook);
        this.table.setItem(row, 1, book);
        QTableWidgetItem keep = new QTableWidgetItem();
        if (keepAfter) {
            keep.setText(this.tr("Keep"));
            keep.setData(32, (Object)"Keep");
        } else {
            keep.setText(this.tr("Delete"));
            keep.setData(32, (Object)"Delete");
        }
        this.table.setItem(row, 2, keep);
    }

    private void tableSelection() {
        this.editButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
    }

    private void addPressed() {
        WatchFolderAdd dialog = new WatchFolderAdd(null, this.notebooks);
        dialog.exec();
        if (dialog.okClicked()) {
            String dir = dialog.directory.text();
            String notebook = dialog.books.currentText();
            int index = dialog.keep.currentIndex();
            String value = (String)dialog.keep.itemData(index);
            boolean keep = value.equalsIgnoreCase("keep");
            this.table.insertRow(this.table.rowCount());
            this.addRow(this.table.rowCount() - 1, dir, notebook, keep);
        }
    }

    private void editPressed() {
        WatchFolderRecord record = new WatchFolderRecord();
        QModelIndex index = this.table.currentIndex();
        int row = index.row();
        QTableWidgetItem item = this.table.item(row, 0);
        record.folder = item.text();
        item = this.table.item(row, 1);
        record.notebook = item.text();
        item = this.table.item(row, 2);
        record.keep = item.data(32).toString().equalsIgnoreCase("keep");
        WatchFolderAdd dialog = new WatchFolderAdd(record, this.notebooks);
        dialog.exec();
        if (dialog.okClicked()) {
            String dir = dialog.directory.text();
            String notebook = dialog.books.currentText();
            int idx = dialog.keep.currentIndex();
            boolean keep = dialog.keep.itemData(idx, 32).toString().equalsIgnoreCase("keep");
            this.table.removeRow(row);
            this.table.insertRow(this.table.rowCount());
            this.addRow(this.table.rowCount() - 1, dir, notebook, keep);
            WatchFolderRecord newRecord = new WatchFolderRecord();
            newRecord.folder = dir;
            newRecord.notebook = notebook;
            newRecord.keep = keep;
            this.records.add(newRecord);
        }
        this.table.setCurrentIndex(index);
    }

    private void deletePressed() {
        QModelIndex index = this.table.currentIndex();
        int row = index.row();
        QTableWidgetItem dirWidget = this.table.item(row, 0);
        String value = dirWidget.text();
        this.table.removeRow(row);
        int i = 0;
        while (i < this.records.size()) {
            if (value.equals(this.records.get((int)i).folder)) {
                this.records.remove(i);
                i = this.records.size();
            }
            ++i;
        }
        if (this.table.rowCount() == 0) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }
}

