/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QWidget;

public class DBEncryptDialog
extends QDialog {
    private boolean okPressed = false;
    private final QLineEdit password1;
    private final QLineEdit password2;
    private final QPushButton ok;
    private final QComboBox encryptionType;
    private final QLabel encryptionLabel;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public DBEncryptDialog() {
        this.setWindowTitle(this.tr("Database Encryption"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "password.png"));
        QGridLayout grid = new QGridLayout();
        this.setLayout((QLayout)grid);
        QGridLayout passwordGrid = new QGridLayout();
        QGridLayout buttonGrid = new QGridLayout();
        this.password1 = new QLineEdit();
        this.password1.setEchoMode(QLineEdit.EchoMode.Password);
        this.password2 = new QLineEdit();
        this.password2.setEchoMode(QLineEdit.EchoMode.Password);
        this.password1.textChanged.connect((Object)this, "validateInput()");
        this.password2.textChanged.connect((Object)this, "validateInput()");
        this.encryptionLabel = new QLabel(this.tr("Encryption Method"));
        this.encryptionType = new QComboBox();
        this.encryptionType.addItem(this.tr("AES"), (Object)"AES");
        this.encryptionType.addItem(this.tr("XTEA"), (Object)"XTEA");
        passwordGrid.addWidget((QWidget)new QLabel(this.tr("Password")), 1, 1);
        passwordGrid.addWidget((QWidget)this.password1, 1, 2);
        passwordGrid.addWidget((QWidget)new QLabel(this.tr("Verify Password")), 2, 1);
        passwordGrid.addWidget((QWidget)this.password2, 2, 2);
        passwordGrid.addWidget((QWidget)this.encryptionLabel, 3, 1);
        passwordGrid.addWidget((QWidget)this.encryptionType, 3, 2);
        passwordGrid.setContentsMargins(10, 10, -10, -10);
        grid.addLayout((QLayout)passwordGrid, 1, 1);
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.setEnabled(false);
        this.ok.clicked.connect((Object)this, "okButtonPressed()");
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelButtonPressed()");
        buttonGrid.addWidget((QWidget)this.ok, 1, 1);
        buttonGrid.addWidget((QWidget)cancel, 1, 2);
        grid.addLayout((QLayout)buttonGrid, 2, 1);
    }

    public void hideEncryption() {
        this.encryptionType.setVisible(false);
        this.encryptionLabel.setVisible(false);
    }

    public String getEncryptionMethod() {
        int i = this.encryptionType.currentIndex();
        return this.encryptionType.itemData(i).toString();
    }

    private void okButtonPressed() {
        this.okPressed = true;
        this.close();
    }

    private void cancelButtonPressed() {
        this.okPressed = false;
        this.close();
    }

    public String getPassword() {
        return this.password1.text();
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public void validateInput() {
        this.ok.setEnabled(true);
        if (this.password1.text().trim().equals("")) {
            this.ok.setEnabled(false);
            return;
        }
        if (this.password1.text().length() < 4) {
            this.ok.setEnabled(false);
            return;
        }
        if (!this.password1.text().equals(this.password2.text())) {
            this.ok.setEnabled(false);
            return;
        }
        if (this.password1.text().indexOf(" ") > -1) {
            this.ok.setEnabled(false);
            return;
        }
    }
}

