/* ȈՃt@CpbJ[ uNRmakiv */
/* NRmakíû܂v̗        */

/*  
	E܂ȃf[^zu
	wb_ (8oCg)
	CfbNX (72oCg x t@C)
	f[^ it@C̐j

	Ewb_[
	+0 VOl` "NrMk"
	+4 ܂łt@C

	Ȇ
	f[^܂Ƃ߂Ă邾Ȃ̂ŃTCYłB
	tekňkقȂ
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef unsigned char UCHAR;

void put32(UCHAR *p, int i);
int get32(const UCHAR *p);
char *strtok(register char *string, const char *separators);
int schar(char *str, char s_str);
int process_unpacking(char *out, int ad);
int process_packing(char *files, char *out, unsigned int maxm, int maxf, int adi);
int show_filelist(char *filename);
void put_usage(void);
void error_onexit(void);

#define MAXSIZ	4 * 1024 * 1024
#define MAXFILE	100
#define HEADSIZ	8 /* wb_̃TCY */

/* t@C̃f[^i72oCgj*/
struct FILE_DATA {
	char filename[64];
	long fsize;
	long add;
};

static UCHAR sign[4] = "NrMk";	/* VOl` */
int ret;						/* error_onexitp */ 

int main(int argc, UCHAR **argv)
{
	int j;
	int maxf = 0, maxm = 0;
	int fl = 0, out = 0, in = 0, ad = 0, adi = 0;
	int cmds = argc - 1;
	UCHAR infile[256], outfile[256];

	ret = 0;

	/*  */
	if (!cmds) put_usage();
	
	/*  */
	for (j = 1;j <= cmds;j++) {
		if (!strncmp("out:", argv[j], 4)) { strcpy(outfile, argv[j] + 4); out = 1; }
		if (!strncmp("in:", argv[j], 3)) { strcpy(infile, argv[j] + 3); in = 1; }
		if (!strcmp("-fl", argv[j])) fl = 1;
		if (!strcmp("-ad", argv[j])) ad = 1;
		if (!strcmp("-adi", argv[j])) adi = 1;
		if (!strncmp("maxf:", argv[j], 5)) maxf = atoi(argv[j] + 5);
		if (!strncmp("maxm:", argv[j], 5)) maxm = atoi(argv[j] + 5);
	}

	/* SςȈ */
	if (!out && !in && !fl) put_usage();

	/* flXCb`̂Ƃ */
	if (fl && in && !out) {
		ret = show_filelist(infile);
		error_onexit();
	}
	
	/* pbNApbN */
	if (in && !out) ret = process_unpacking(infile, ad);
	else if (in && out) ret = process_packing(infile, outfile, maxf, maxm, adi);
	else put_usage(); /* Ƃ肠\Ƃ */

	error_onexit();
	return 0;
}	

/* usage\ */
void put_usage(void)
{
	puts("[ Simple File Packer \"NRmaki\" v0.0.1 ]");
	puts("Copyright (C) 2010 Negitoro OS Project\n");
	puts(" usage: >nrmaki out:outfile [-fl|-ad|-adi] in:infile1+infile2+...");
	exit(0);
}

/* G[\ďI */
void error_onexit(void)
{
	if (ret) {
		printf("any error happened.(%d)\n", ret);
		exit(1);
	}
	exit(0);
}

/* pbNĂt@CB\ */
int show_filelist(char *filename)
{
	FILE *fp;
	UCHAR *buf = malloc(MAXSIZ);
	struct FILE_DATA files;
	int fsize = 0, fnum = 0, j;
	
	if (!buf) return 1;

	fp = fopen(filename, "rb");
	if (!fp) return 3;
	
	/* TCY`FbN */
	fseek(fp, 0, SEEK_END);
	fsize = ftell(fp);	
	if (fsize <= 4) return 7;
	
	/* VOl``FbN */
	fseek(fp, 0, SEEK_SET);
	fread(buf, 1, 4, fp);
	if (strncmp(buf, sign, 4)) return 7;

	/* wb_擾 */
	fseek(fp, 0, SEEK_SET);
	fread(buf, 1, 8, fp);
	fnum = get32(&buf[4]);
	printf("[ packed file name is \"%s\" ]\n", filename);	
	printf("It includ %d files\n", fnum);
	puts("----------------------------------------");
	
	/* CfbNX擾\ */
	for (j = 0;j < fnum;j++) {
		memset(buf, 0, MAXSIZ);
		fread(buf, 72, 1, fp);
		files = *((struct FILE_DATA *)buf);
		printf("[%s] size:%d\n", files.filename, files.fsize);
	}

	fclose(fp);	

	return 0;
}

/* t@CpbN */
int process_packing(char *filelist, char *out, unsigned int maxm, int maxf, int adi)
{
	if (!maxm) maxm = MAXSIZ;
	if (!maxf) maxf = MAXFILE;

	UCHAR *buf = malloc(maxm);
	struct FILE_DATA files[maxf];
	char cmd[256], *dat;
	int fval = 0, j, next, fsiz, dsiz, r, b;
	FILE *fp, *fpd;	

	 /* s */
	if (!buf) return 1;

	/* t@CXg */
	for (j = 0;j < maxf;j++) {
		memset(files[j].filename, 0, 64);
		files[j].fsize = 0;
	}

	/* \̂Ƀf[^Zbg */
	strcpy(cmd, filelist);
	fval = schar(cmd, '+') + 1;
	if (fval > maxf) return 1;
	strcpy(files[0].filename, strtok(cmd, "+"));
	for (j = 1;j < fval;j++) {
		dat = strtok(NULL, "+");
		if (!dat) return 2; /* sȃR}hC */
		strcpy(files[j].filename, dat);
	}
	next = HEADSIZ + 72 * fval;
	for (j = 0;j < maxf;j++) {
		if (files[j].filename[0]) {
			
			/* t@CTCY擾 */
			fp = fopen(files[j].filename, "rb");
			if (!fp) return 3; /* ̓t@CG[1 */
			fseek(fp, 0, SEEK_END);
			files[j].fsize = ftell(fp);
			fclose(fp);

			/* t@CuoCgZbg */
			if (j > 0) {
				next += files[j - 1].fsize;
			}
			files[j].add = next;

		}
	}

	/* XgAbvĕ\ */
	printf("%s plans to include %d files.\n", out, fval);
	printf("[ ");
	for (j = 0;j < maxf;j++) {
		if (files[j].filename[0]) {
			printf("%s(%ldb) ", files[j].filename, files[j].fsize);
		}
	}
	printf("]\n");

	/* t@C */
	fsiz = 0;
	for (j = 0;j < fval;j++) {
		if (files[j].filename[0]) 
			fsiz += files[j].fsize;
	}	
	puts("start packing.");

	fp = fopen(out, "wb");
	if (!fp) return 4; /* o̓t@CI[vG[ */

	/* wb_ */
	for (j = 0;j < 4;j++) 
		buf[j] = sign[j];
	put32(&buf[4], fval);
	if (fwrite(buf, HEADSIZ, 1, fp) != 1) 
		return 5; /* o̓t@C݃G[ */

	/* CfbNX */
	fsiz = 0;
	for (j = 0;j < fval;j++) {
		b = sizeof(files[j]);
		if (fwrite((void *)&files[j], b, 1, fp) != 1) 
			return 5; /* o̓t@C݃G[ */
		fsiz += b;
	}

	/* Cf[^ */
	dsiz = 0;
	for (j = 0;j < fval;j++) {
		if (files[j].filename[0]) {
			printf("packing.. [%s]\n", files[j].filename);
			memset(buf, 0, maxm);
			
			/* t@Cǂݍ */
			fpd = fopen(files[j].filename, "rb");
			if (!fpd) 
				return 6; /* ̓t@CG[2 */
			r = fread(buf, 1, maxm, fpd);
			if (r >= maxm || r < 0) 
				return 6; /* ̓t@CG[2 */
			fclose(fpd);
			
			/* adiIvV */		
			if (adi) remove(files[j].filename);
			
			/* pbNt@C */
			if (fwrite(buf, 1, files[j].fsize, fp) != files[j].fsize) 
				return 5; /* o̓t@C݃G[ */	
			dsiz += files[j].fsize;
		}
	}
	
	/* ݏI */
	printf("finish packing.\n[ index=%db/data=%db ]\n", fsiz, dsiz);
	fclose(fp);

	return 0;
}

/* t@CApbN */
int process_unpacking(char *out, int ad)
{
	UCHAR *buf = malloc(MAXSIZ);
	FILE *fp, *fpd;
	struct FILE_DATA fd;
	int fsize, fnum, j;

	if (!buf) return 1;

	/* t@CTCYƃVOl`画 */
	fp = fopen(out, "rb");
	if (!fp) return 3;
	fseek(fp, 0, SEEK_END);
	fsize = ftell(fp);
	if (fsize <= 4) return 7;
	fseek(fp, 0, SEEK_SET);	
	fread(buf, 1, 4, fp);
	if (strncmp(buf, sign, 4)) return 7; /* Ȃt@C */

	/* t@C擾 */
	fseek(fp, 0, SEEK_SET);
	fread(buf, 1, 8, fp);
	fnum = get32(&buf[4]);	

	/* t@Co */
	puts("start unpacking.");
		
	for (j = 0;j < fnum;j++) {
		memset(buf, 0, MAXSIZ);
		fseek(fp, 8 + 72 * j, SEEK_SET);
		fread(buf, 72, 1, fp);
		fd = *((struct FILE_DATA *)buf);

		printf("unpacking.. [%s]\n");
		fseek(fp, fd.add, SEEK_SET);
		memset(buf, 0, MAXSIZ);
		fread(buf, fd.fsize, 1, fp);
		
		fpd = fopen(fd.filename, "wb");
		if (!fpd) return 4;
		if (fwrite(buf, 1, fd.fsize, fpd) != fd.fsize)
			return 5;
		fclose(fpd);
	}

	/* S̃t@Co */
	puts("finish unpacking.");
	fclose(fp);
	
	/* adIvV */
	if (ad) remove(out);

	return 0;
}

/* wb_ */
int get32(const UCHAR *p)
{
	return p[0] | p[1] << 8 | p[2] << 16 | p[3] << 24;
}

/* wb_ǂݍ */
void put32(UCHAR *p, int i)
{
	p[0] =  i        & 0xff;
	p[1] = (i >>  8) & 0xff;
	p[2] = (i >> 16) & 0xff;
	p[3] = (i >> 24) & 0xff;
	return;
}

char *strtok(register char *string, const char *separators)
{
	register char *s1, *s2;
	static char *savestring;

	if (string == 0) {
		string = savestring;
		if (string == 0) return 0;
	}

	s1 = string + strspn(string, separators);
	if (*s1 == '\0') {
		savestring = 0;
		return 0;
	}

	s2 = strpbrk(s1, separators);
	if (s2 != 0) *s2++ = '\0';
	savestring = s2;

	return s1;
}

int schar(char *str, char s_str)
{
	int j;
	char *p;
	
	for (p = str, j = 0;*p != 0;p++) 
		if (*p == s_str) j++;
	
	return j;
}
