/*
 * TestSetup.h
 */

#ifndef cppunit_TestSetup_h
#define cppunit_TestSetup_h

#include "cuconfig.h"
#include "TestCase.h"
#include "TestDecorator.h"

cu_NAMESPACE_BEGIN(cppunit)

/**
 * eXg̏AЕtǉfR[^B<br>
 * Decorator to set up and tear down additional fixture state.
 *
 * ۗL Test ̃CtTCNǗB
 */
class TestSetup : public TestDecorator
{
  public:
	/**
	 * RXgN^B
	 * @param test ɂȂeXgB
	 */
	explicit TestSetup(Test* test);

	virtual void run(TestResult* result);

  protected:
	/** eXgB */
	virtual void setUp() {}

	/** eXǧЕtB */
	virtual void tearDown() {}

	/** ۂɃeXgsB */
	void runBare();

//	#define TEST_ERROR(msg)
	/**
	 * G[ǉB
	 * @param msg  bZ[WB
	 * @param file t@CB
	 * @param line sԍB
	 * @see TEST_ERROR
	 */
	void addError(const cu_String& msg, const char* file, long line);

  private:
	TestSetup(const TestSetup& rhs);
	TestSetup& operator=(const TestSetup& rhs);

  private:
	bool m_hasError;
	TestResult* m_result;	// sZbgB
};

cu_NAMESPACE_END

#endif /* !cppunit_TestSetup_h */
