/*
 * TestResult.h
 */

#ifndef cppunit_TestResult_h
#define cppunit_TestResult_h

#include "cuconfig.h"

cu_NAMESPACE_BEGIN(cppunit)

class Test;
class TestFailure;
class TestListener;

/**
 * eXgʂێNXB<br>
 * A TestResult collects the results of executing a test case.
 * It is an instance of the Collecting Parameter pattern.
 *
 * The test framework distinguishes between failures and errors.<br>
 * A failure is anticipated and checked for with assertions.<br>
 * Errors are unanticipated problems signified by exceptions
 * that are not generated by the framework.
 *
 * ۗL TestFailure ̃CtTCNǗB<br>
 * TestListener ̃CtTCN̓NCAgŊǗ邱ƁB
 *
 * @see Test
 */
class TestResult
{
  public:
	/** rZ}tH̊NXB */
	class Mutex {
	  public:
		virtual ~Mutex() {}
		virtual void lock();
		virtual void unlock();
	};

  protected:
	/** Mutex bNB */
	class AutoMutexLock {
	  public:
		/// bN𐶐B
		explicit AutoMutexLock(Mutex *mutex)
			: m_mutex(mutex) { m_mutex->lock(); }
		/// bNB
		~AutoMutexLock() { m_mutex->unlock(); }

	  private:
		AutoMutexLock(const AutoMutexLock& rhs);
		AutoMutexLock& operator=(const AutoMutexLock& rhs);
		Mutex* m_mutex;
	};

  public:
	/**
	 * RXgN^B
	 * @param mutex 0 ܂ <code>new</code> ꂽrZ}tHB
	 */
	explicit TestResult(Mutex* mutex = 0);

	/** fXgN^B */
	~TestResult();

	/**
	 * XiǉB
	 *
	 * eXgs͎gpȂƁB
	 */
	void addListener(TestListener* listener);

	/**
	 * eXgJnB<br>
	 * Informs the result that a test will be started.
	 */
	void startTest(Test* test);

	/**
	 * eXgIB<br>
	 * Informs the result that a test was completed.
	 */
	void endTest(Test* test);

	/**
	 * eXg̎sǉB<br>
	 * Adds a failure to the list of failures.
	 * @param failure seXg̏B
	 */
	void addFailure(const TestFailure* failure);

	/**
	 * G[ǉB<br>
	 * Adds an error to the list of errors.
	 * @param error G[B
	 */
	void addError(const TestFailure* error);

	/**
	 * sꂽeXǧԂB<br>
	 * Gets the number of run tests.
	 */
	int runCount() const;

	/**
	 * seXǧԂB<br>
	 * Gets the number of detected failures.
	 */
	int failureCount() const;

	/**
	 * G[ɂȂeXǧԂB<br>
	 * Gets the number of detected errors.
	 */
	int errorCount() const;

	/**
	 * ÃeXg?<br>
	 * Returns whether the entire test was successful or not.
	 */
	bool wasSuccessful() const;

	/**
	 * eXg𒆎~Kv邩?<br>
	 * Returns whether testing should be stopped.
	 */
	bool shouldStop() const;

	/**
	 * eXg𒆎~B<br>
	 * Stop testing.
	 */
	void stop();

	/**
	 * seXg̃XgԂB<br>
	 * Returns a list of the failures.
	 *
	 * eXgs͎gpȂƁB
	 */
	const cu_List& failures() const { return m_failures; }

	/**
	 * G[̃XgԂB<br>
	 * Returns a list of the errors.
	 *
	 * eXgs͎gpȂƁB
	 */
	const cu_List& errors() const { return m_errors; }

  private:
	TestResult(const TestResult& rhs);
	TestResult& operator=(const TestResult& rhs);

  private:
	Mutex* m_mutex;
	cu_List m_listeners;	// list<TestListener*>
	cu_List m_failures;		// list<TestFailure*>
	cu_List m_errors;		// list<TestFailure*>
	int  m_runCount;
	bool m_shouldStop;
};

cu_NAMESPACE_END

#endif /* !cppunit_TestResult_h */
