/*
 * TestRegistry.h
 */

#ifndef cppunit_TestRegistry_h
#define cppunit_TestRegistry_h

#include "cuconfig.h"
#include "Test.h"

cu_NAMESPACE_BEGIN(cppunit)

class TestResult;

/**
 * eXgo^NXB
 *
 * TestRunner ̎ŎgpB
 * CppUnit 1.6.x  TestRegistry Ƃ͗prقȂB
 * 
 * ۗL Test ̃CtTCNǗB
 */
class TestRegistry
{
  public:
	/** RXgN^B */
	TestRegistry() {}

	/** fXgN^B */
	~TestRegistry();

	/**
	 * eXgǉB
	 * @param name eXgB
	 * @param test ǉeXgB
	 */
	void addTest(const char* name, Test* test);

	/**
	 * w肳ꂽÕeXgLɂB
	 * @param name eXgB
	 * @return YeXg邩?
	 */
	bool setAvailable(const char* name, bool value = true);

	/** SẴeXgLɂB */
	void setAllAvailable(bool value = true);

	/** LȃeXg邩? */
	bool hasAvailables() const;

	/** ǉꂽeXg̃XgԂB */
	const cu_List& entries() const { return m_entries; }

	/**
	 * eXgsB
	 * @param result eXgʁB
	 */
	void runTests(TestResult* result);

  private:
	int m_availables;
	cu_List m_entries;	// list<Entry*>

  public:
	/**
	 * eXg̃GgB
	 */
	class Entry {
	  public:
		/**
		 * RXgN^B
		 * @param name      eXgB
		 * @param test      eXgB
		 * @param available eXgL?
		 */
		Entry(const char* name, Test* test, bool available = false)
			: m_name(name), m_test(test), m_available(available) {}

		/** fXgN^B */
		~Entry() { delete m_test; }

		/** eXgԂB */
		const char* getName() const { return m_name.c_str(); }

		/** eXgԂB */
		Test* getTest() const { return m_test; }

		/** eXgL? */
		bool isAvailable() const { return m_available; }

		/**
		 * eXgLݒ肷B
		 * @param value ݒ肷lB
		 */
		void setAvailable(bool value = true) { m_available = value; }

	  private:
		cu_String m_name;
		Test* m_test;
		bool  m_available;
	};
};

cu_NAMESPACE_END

#endif /* !cppunit_TestRegistry_h */
