/*
    TCFbETestCase2.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbETestCase2H
#define TCFbETestCase2H
//---------------------------------------------------------------------------
#pragma hdrstop
//---------------------------------------------------------------------------
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestRunner.h>

USING_NAMESPACE_CPPUNIT
//---------------------------------------------------------------------------
#include "TCFbEDataSet.h"
#include "TCFbEToolkit.h"

#include "TCFbECosineSimilarity.h"
#include "TCFbEAdjustedCosineSimilarityWithAverage.h"
#include "TCFbEAdjustedCosineSimilarityWithMedian.h"
#include "TCFbECorrelationCoefficientWithAverage.h"
#include "TCFbECorrelationCoefficientWithMedian.h"
#include "TCFbERankCorrelation.h"
#include "TCFbEDistanceSimilarityWithAverage.h"
#include "TCFbEDistanceSimilarityWithMedian.h"

#include "TCFbEWeightedSum.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfColumn.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfColumn.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfNeighbors.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfNeighbors.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfRow.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfRow.h"
#include "TCFbEAmplifiedWeightedSumWithAveragedMultiplier.h"
#include "TCFbEAmplifiedWeightedSumWithMedianOfMultiplier.h"
#include "TCFbEAmplifiedWeightedSumWithWeightedMultiplier.h"
//---------------------------------------------------------------------------
// eXgP[X1
class TCFbETestCase2 : public TestCase
{
    // RXgN^
    TEST_CASE_COMMON(TCFbETestCase2)

public:
    // eXg
    //    FILENAME    BUG                LOC                N_COMM            HALVOL                SCPMN            N_VEXUSE
    //    module_1                    800.0000000000     0.3000000000     3600.0000000000     4.0000000000     0.6000000000
    //    module_2    2.0000000000     250.0000000000                     3200.0000000000     3.5000000000     0.4000000000
    //    module_3    5.0000000000     500.0000000000     0.0000000000                         3.0000000000     0.3000000000
    //    module_4    5.0000000000     700.0000000000     0.2500000000     3500.0000000000                     0.8000000000
    //    module_5                    600.0000000000     0.2000000000     3200.0000000000     2.5000000000
    //    module_6    10.0000000000     900.0000000000     0.3500000000     3800.0000000000     4.1000000000     0.7500000000
    virtual void setUp() {
        TStringList* TestStringList = new TStringList();
        TestStringList->Add("FILENAME,    BUG,            LOC,            N_COMM,            HALVOL,                SCPMN,            N_VEXUSE");
        TestStringList->Add("module_1,    ,                800.0000000000,    0.3000000000,    3600.0000000000,    4.0000000000,    0.6000000000");
        TestStringList->Add("module_2,    2.0000000000,    250.0000000000,    ,                3200.0000000000,     3.5000000000,    0.4000000000");
        TestStringList->Add("module_3,    5.0000000000,    500.0000000000,    0.0000000000,    ,                    3.0000000000,    0.3000000000");
        TestStringList->Add("module_4,    5.0000000000,     700.0000000000, 0.2500000000,     3500.0000000000,     ,                0.8000000000");
        TestStringList->Add("module_5,    ,                600.0000000000, 0.2000000000,     3200.0000000000,     2.5000000000,                ");
        TestStringList->Add("module_6,    10.0000000000,     900.0000000000, 0.3500000000,     3800.0000000000,     4.1000000000,     0.7500000000");

        this->DataSet = new TCFbEDataSet(TestStringList);
        delete TestStringList;
    }

    // eXǧЕt
    virtual void tearDown() {
        delete this->DataSet;
    }

    virtual void Test_TCFbEDataSet_GetRowLabelList() {
        TEST_ASSERT_EQUALS(6,    this->DataSet->NumberOfRows);

        TEST_ASSERT_EQUALS("module_1",    this->DataSet->RowLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_2",    this->DataSet->RowLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_3",    this->DataSet->RowLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_4",    this->DataSet->RowLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_5",    this->DataSet->RowLabelList->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_6",    this->DataSet->RowLabelList->Strings[5].c_str());
    }

    virtual void Test_TCFbEDataSet_GetColumnLabelList() {
        TEST_ASSERT_EQUALS(6,    this->DataSet->NumberOfColumns);

        TEST_ASSERT_EQUALS("BUG",    this->DataSet->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",    this->DataSet->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    this->DataSet->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    this->DataSet->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN",    this->DataSet->ColumnLabelList->Strings[4].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    this->DataSet->ColumnLabelList->Strings[5].c_str());
    }

    //---------------------------------------------------------------------------
    // Value-based & Row-based
    //---------------------------------------------------------------------------
    //    FILENAME    BUG    LOC    N_COMM    HALVOL    SCPMN    N_VEXUSE
    //    module_1    800.0000000000     0.3000000000     3600.0000000000     4.0000000000     0.6000000000
    //    module_2    2.0000000000     250.0000000000         3200.0000000000     3.5000000000     0.4000000000
    //    module_3    5.0000000000     500.0000000000     0.0000000000         3.0000000000     0.3000000000
    //    module_4    5.0000000000     700.0000000000     0.2500000000     3500.0000000000         0.8000000000
    //    module_5            600.0000000000     0.2000000000     3200.0000000000     2.5000000000
    //    module_6    10.0000000000     900.0000000000     0.3500000000     3800.0000000000     4.1000000000     0.7500000000
    virtual void Test_TCFbEDataSet_GetValues() {
        TEST_ASSERT_EQUALS_DOUBLE(800.0000000000,    this->DataSet->Values["module_1"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->Values["module_1"]["N_COMM"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3600.0000000000,    this->DataSet->Values["module_1"]["HALVOL"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->Values["module_1"]["SCPMN"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->Values["module_1"]["N_VEXUSE"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0000000000,    this->DataSet->Values["module_2"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0000000000,    this->DataSet->Values["module_2"]["LOC"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->Values["module_2"]["HALVOL"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->Values["module_2"]["SCPMN"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4000000000,    this->DataSet->Values["module_2"]["N_VEXUSE"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->Values["module_3"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500.0000000000,    this->DataSet->Values["module_3"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Values["module_3"]["N_COMM"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->Values["module_3"]["SCPMN"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->Values["module_3"]["N_VEXUSE"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->Values["module_4"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0000000000,    this->DataSet->Values["module_4"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->Values["module_4"]["N_COMM"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->Values["module_4"]["HALVOL"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,    this->DataSet->Values["module_4"]["N_VEXUSE"], 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(600.0000000000,    this->DataSet->Values["module_5"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->Values["module_5"]["N_COMM"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->Values["module_5"]["HALVOL"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5000000000,    this->DataSet->Values["module_5"]["SCPMN"], 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(10.0000000000,    this->DataSet->Values["module_6"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0000000000,    this->DataSet->Values["module_6"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3500000000,    this->DataSet->Values["module_6"]["N_COMM"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0000000000,    this->DataSet->Values["module_6"]["HALVOL"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1000000000,    this->DataSet->Values["module_6"]["SCPMN"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->Values["module_6"]["N_VEXUSE"], 1E-6);
    }

    //    Average of Column        5.5000000000     625.0000000000     0.2200000000     3460.0000000000     3.4200000000     0.5700000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(625.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2200000000,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3460.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4200000000,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5700000000,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        5.0000000000     650.0000000000     0.2500000000     3500.0000000000     3.5000000000     0.6000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(650.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    880.9800000000
    //    691.1800000000
    //    101.6600000000
    //    841.2100000000
    //    950.6750000000
    //    785.8666666667
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(880.9800000000,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(691.1800000000,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(101.6600000000,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(841.2100000000,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(950.6750000000,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(785.8666666667,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    4.0000000000
    //    3.5000000000
    //    3.0000000000
    //    5.0000000000
    //    301.2500000000
    //    7.0500000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(301.2500000000,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.0500000000,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    1.7419642857
    //    1.6444444444
    //    1.0303571429
    //    1.3895833333
    //    0.8938019846
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.7419642857,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6444444444,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0303571429,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3895833333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8938019846,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    1.3214285714
    //    1.6000000000
    //    1.0857142857
    //    1.4166666667
    //    0.8888888889
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.3214285714,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0857142857,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4166666667,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8888888889,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    2.2662592009
    //    1.6478601381
    //    1.0782647864
    //    1.3883713977
    //    0.8836798536
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.2662592009,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6478601381,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0782647864,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3883713977,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8836798536,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Value-based & Column-based
    //---------------------------------------------------------------------------
    //    FILENAME    module_1    module_2    module_3    module_4    module_5    module_6
    //    BUG        2.0000000000     5.0000000000     5.0000000000         10.0000000000
    //    LOC    800.0000000000     250.0000000000     500.0000000000     700.0000000000     600.0000000000     900.0000000000
    //    N_COMM    0.3000000000         0.0000000000     0.2500000000     0.2000000000     0.3500000000
    //    HALVOL    3600.0000000000     3200.0000000000         3500.0000000000     3200.0000000000     3800.0000000000
    //    SCPMN    4.0000000000     3.5000000000     3.0000000000         2.5000000000     4.1000000000
    //    N_VEXUSE    0.6000000000     0.4000000000     0.3000000000     0.8000000000         0.7500000000
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(2.0000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(10.0000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(800.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_1"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3500000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3600.0000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_2"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_3"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.5000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_6"]->Value, 1E-6);
    }

    //    Average of Row        880.9800000000     691.1800000000     101.6600000000     841.2100000000     950.6750000000     785.8666666667
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(880.9800000000,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(691.1800000000,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(101.6600000000,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(841.2100000000,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(950.6750000000,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(785.8666666667,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Row        4.0000000000     3.5000000000     3.0000000000     5.0000000000     301.2500000000     7.0500000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(301.2500000000,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.0500000000,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Column
    //    5.5000000000
    //    625.0000000000
    //    0.2200000000
    //    3460.0000000000
    //    3.4200000000
    //    0.5700000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(625.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2200000000,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3460.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4200000000,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5700000000,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Column
    //    5.0000000000
    //    650.0000000000
    //    0.2500000000
    //    3500.0000000000
    //    3.5000000000
    //    0.6000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(650.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    0.0090634921
    //    24.2857142857
    //    0.0015617168
    //    1.5590398761
    //    10.3125000000
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0090634921,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(24.2857142857,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0015617168,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5590398761,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.3125000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    0.0090000000
    //    24.2857142857
    //    0.0014285714
    //    1.6666666667
    //    9.7916666667
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0090000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(24.2857142857,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0014285714,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6666666667,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(9.7916666667,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    0.0098222982
    //    26.4211868693
    //    0.0018695549
    //    1.7199057237
    //    13.9826155114
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0098222982,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(26.4211868693,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0018695549,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7199057237,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(13.9826155114,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Standardized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    FILENAME    BUG    LOC    N_COMM    HALVOL    SCPMN    N_VEXUSE
    //    module_1        0.8268741925     0.6620847109     0.6002450480     0.9592347424     0.1547131869
    //    module_2    -1.2185435917     -1.7718732697         -1.1147408034     0.1323082403     -0.8767080593
    //    module_3    -0.1740776560     -0.5906244232     -1.8207329549         -0.6946182617     -1.3924186824
    //    module_4    -0.1740776560     0.3543746539     0.2482817666     0.1714985851         1.1861344332
    //    module_5        -0.1181248846     -0.1655211777     -1.1147408034     -1.5215447638
    //    module_6    1.5666989036     1.2993737311     1.0758876552     1.4577379737     1.1246200428     0.9282791216
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(0.8268741925,    this->DataSet->PredictionTable->Cells["module_1"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6620847109,    this->DataSet->PredictionTable->Cells["module_1"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6002450480,    this->DataSet->PredictionTable->Cells["module_1"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9592347424,    this->DataSet->PredictionTable->Cells["module_1"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1547131869,    this->DataSet->PredictionTable->Cells["module_1"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.2185435917,    this->DataSet->PredictionTable->Cells["module_2"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.7718732697,    this->DataSet->PredictionTable->Cells["module_2"]["LOC"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.1147408034,    this->DataSet->PredictionTable->Cells["module_2"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1323082403,    this->DataSet->PredictionTable->Cells["module_2"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8767080593,    this->DataSet->PredictionTable->Cells["module_2"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.1740776560,    this->DataSet->PredictionTable->Cells["module_3"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5906244232,    this->DataSet->PredictionTable->Cells["module_3"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.8207329549,    this->DataSet->PredictionTable->Cells["module_3"]["N_COMM"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.6946182617,    this->DataSet->PredictionTable->Cells["module_3"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.3924186824,    this->DataSet->PredictionTable->Cells["module_3"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.1740776560,    this->DataSet->PredictionTable->Cells["module_4"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3543746539,    this->DataSet->PredictionTable->Cells["module_4"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2482817666,    this->DataSet->PredictionTable->Cells["module_4"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1714985851,    this->DataSet->PredictionTable->Cells["module_4"]["HALVOL"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.1861344332,    this->DataSet->PredictionTable->Cells["module_4"]["N_VEXUSE"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(-0.1181248846,    this->DataSet->PredictionTable->Cells["module_5"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1655211777,    this->DataSet->PredictionTable->Cells["module_5"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.1147408034,    this->DataSet->PredictionTable->Cells["module_5"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.5215447638,    this->DataSet->PredictionTable->Cells["module_5"]["SCPMN"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.5666989036,    this->DataSet->PredictionTable->Cells["module_6"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2993737311,    this->DataSet->PredictionTable->Cells["module_6"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0758876552,    this->DataSet->PredictionTable->Cells["module_6"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4577379737,    this->DataSet->PredictionTable->Cells["module_6"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1246200428,    this->DataSet->PredictionTable->Cells["module_6"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9282791216,    this->DataSet->PredictionTable->Cells["module_6"]["N_VEXUSE"]->Value, 1E-6);
    }

    //    Average of Column        0.0000000000     0.0000000000     0.0000000000     0.0000000000     0.0000000000     0.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        -0.1740776560     0.1181248846     0.2482817666     0.1714985851     0.1323082403     0.1547131869
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1740776560,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1181248846,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2482817666,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1714985851,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1323082403,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1547131869,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.6406303761
    //    -0.9699114968
    //    -0.9344943957
    //    0.3572423566
    //    -0.7299829074
    //    1.2420995713
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6406303761,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9699114968,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9344943957,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3572423566,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7299829074,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2420995713,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.6620847109
    //    -1.1147408034
    //    -0.6946182617
    //    0.2482817666
    //    -0.6401309906
    //    1.2119968869
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6620847109,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.1147408034,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6946182617,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2482817666,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6401309906,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2119968869,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    2.1078996983
    //    0.8139249639
    //    2.1576086957
    //    3.0422240803
    //    0.5366241602
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.1078996983,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8139249639,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1576086957,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0422240803,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5366241602,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    0.5025641026
    //    0.8722943723
    //    2.5000000000
    //    2.3152173913
    //    0.6153846154
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5025641026,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8722943723,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.3152173913,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6153846154,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    1.7686794806
    //    0.8091679477
    //    1.9693888457
    //    3.4666389125
    //    0.5145911418
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.7686794806,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8091679477,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.9693888457,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4666389125,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5145911418,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // StandardizedValue-based & Column-based
    //---------------------------------------------------------------------------
    //    FILENAME    module_1    module_2    module_3    module_4    module_5    module_6
    //    BUG        -1.2185435917     -0.1740776560     -0.1740776560         1.5666989036
    //    LOC    0.8268741925     -1.7718732697     -0.5906244232     0.3543746539     -0.1181248846     1.2993737311
    //    N_COMM    0.6620847109         -1.8207329549     0.2482817666     -0.1655211777     1.0758876552
    //    HALVOL    0.6002450480     -1.1147408034         0.1714985851     -1.1147408034     1.4577379737
    //    SCPMN    0.9592347424     0.1323082403     -0.6946182617         -1.5215447638     1.1246200428
    //    N_VEXUSE    0.1547131869     -0.8767080593     -1.3924186824     1.1861344332         0.9282791216
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(-1.2185435917,    this->DataSet->PredictionTable->Cells["BUG"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1740776560,    this->DataSet->PredictionTable->Cells["BUG"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1740776560,    this->DataSet->PredictionTable->Cells["BUG"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.5666989036,    this->DataSet->PredictionTable->Cells["BUG"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8268741925,    this->DataSet->PredictionTable->Cells["LOC"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.7718732697,    this->DataSet->PredictionTable->Cells["LOC"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5906244232,    this->DataSet->PredictionTable->Cells["LOC"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3543746539,    this->DataSet->PredictionTable->Cells["LOC"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1181248846,    this->DataSet->PredictionTable->Cells["LOC"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2993737311,    this->DataSet->PredictionTable->Cells["LOC"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6620847109,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_1"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.8207329549,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2482817666,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1655211777,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0758876552,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6002450480,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.1147408034,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_2"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.1714985851,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.1147408034,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4577379737,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.9592347424,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1323082403,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6946182617,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_3"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.5215447638,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1246200428,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.1547131869,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8767080593,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.3924186824,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1861344332,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.9282791216,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_6"]->Value, 1E-6);
    }

    //    Average of Column        0.6406303761     -0.9699114968     -0.9344943957     0.3572423566     -0.7299829074     1.2420995713
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6406303761,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9699114968,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9344943957,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3572423566,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7299829074,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2420995713,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.6620847109     -1.1147408034     -0.6946182617     0.2482817666     -0.6401309906     1.2119968869
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6620847109,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.1147408034,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6946182617,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2482817666,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6401309906,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2119968869,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.0000000000
    //    0.0000000000
    //    0.0000000000
    //    0.0000000000
    //    0.0000000000
    //    0.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    -0.1740776560
    //    0.1181248846
    //    0.2482817666
    //    0.1714985851
    //    0.1323082403
    //    0.1547131869
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1740776560,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1181248846,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2482817666,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1714985851,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1323082403,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1547131869,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    0.6698521441
    //    0.7509766379
    //    1.0609677789
    //    3.6178617319
    //    0.8373580520
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6698521441,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7509766379,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0609677789,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.6178617319,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8373580520,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    0.5894698868
    //    0.7011294400
    //    1.0747465812
    //    1.3930917501
    //    0.7683342653
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5894698868,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7011294400,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0747465812,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3930917501,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7683342653,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    0.7902007865
    //    0.9265429861
    //    1.0624221537
    //    2.2498534400
    //    0.9853489558
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7902007865,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9265429861,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0624221537,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.2498534400,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9853489558,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Normalized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    FILENAME    BUG    LOC    N_COMM    HALVOL    SCPMN    N_VEXUSE
    //    module_1        0.8461538462     0.8571428571     0.6666666667     0.9375000000     0.6000000000
    //    module_2    0.0000000000     0.0000000000         0.0000000000     0.6250000000     0.2000000000
    //    module_3    0.3750000000     0.3846153846     0.0000000000         0.3125000000     0.0000000000
    //    module_4    0.3750000000     0.6923076923     0.7142857143     0.5000000000         1.0000000000
    //    module_5        0.5384615385     0.5714285714     0.0000000000     0.0000000000
    //    module_6    1.0000000000     1.0000000000     1.0000000000     1.0000000000     1.0000000000     0.9000000000
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(0.8461538462,    this->DataSet->PredictionTable->Cells["module_1"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8571428571,    this->DataSet->PredictionTable->Cells["module_1"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6666666667,    this->DataSet->PredictionTable->Cells["module_1"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9375000000,    this->DataSet->PredictionTable->Cells["module_1"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["module_1"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["LOC"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6250000000,    this->DataSet->PredictionTable->Cells["module_2"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->PredictionTable->Cells["module_2"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->PredictionTable->Cells["module_3"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3846153846,    this->DataSet->PredictionTable->Cells["module_3"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["N_COMM"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.3125000000,    this->DataSet->PredictionTable->Cells["module_3"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->PredictionTable->Cells["module_4"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6923076923,    this->DataSet->PredictionTable->Cells["module_4"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7142857143,    this->DataSet->PredictionTable->Cells["module_4"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["module_4"]["HALVOL"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_4"]["N_VEXUSE"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.5384615385,    this->DataSet->PredictionTable->Cells["module_5"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5714285714,    this->DataSet->PredictionTable->Cells["module_5"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_5"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_5"]["SCPMN"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9000000000,    this->DataSet->PredictionTable->Cells["module_6"]["N_VEXUSE"]->Value, 1E-6);
    }

    //    Average of Column        0.4375000000     0.5769230769     0.6285714286     0.4333333333     0.5750000000     0.5400000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4375000000,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5769230769,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6285714286,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4333333333,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5750000000,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5400000000,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.3750000000     0.6153846154     0.7142857143     0.5000000000     0.6250000000     0.6000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6153846154,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7142857143,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6250000000,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.7814926740
    //    0.1650000000
    //    0.2144230769
    //    0.6563186813
    //    0.2774725275
    //    0.9833333333
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7814926740,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1650000000,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2144230769,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6563186813,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2774725275,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9833333333,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.8461538462
    //    0.0000000000
    //    0.3125000000
    //    0.6923076923
    //    0.2692307692
    //    1.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8461538462,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3125000000,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6923076923,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2692307692,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    2.2500000000
    //    2.6000000000
    //    1.0888888889
    //    1.5357142857
    //    0.7948260073
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.2500000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6000000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0888888889,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5357142857,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7948260073,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    2.2500000000
    //    2.6000000000
    //    1.2111111111
    //    1.5357142857
    //    0.8461538462
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.2500000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2111111111,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5357142857,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8461538462,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    2.2936344969
    //    2.4263951101
    //    1.1914413105
    //    1.5500743848
    //    0.7616479265
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.2936344969,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.4263951101,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1914413105,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5500743848,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7616479265,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // NormalizedValue-based & Column-based
    //---------------------------------------------------------------------------
    //    FILENAME    module_1    module_2    module_3    module_4    module_5    module_6
    //    BUG        0.0000000000     0.3750000000     0.3750000000         1.0000000000
    //    LOC    0.8461538462     0.0000000000     0.3846153846     0.6923076923     0.5384615385     1.0000000000
    //    N_COMM    0.8571428571         0.0000000000     0.7142857143     0.5714285714     1.0000000000
    //    HALVOL    0.6666666667     0.0000000000         0.5000000000     0.0000000000     1.0000000000
    //    SCPMN    0.9375000000     0.6250000000     0.3125000000         0.0000000000     1.0000000000
    //    N_VEXUSE    0.6000000000     0.2000000000     0.0000000000     1.0000000000         0.9000000000
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8461538462,    this->DataSet->PredictionTable->Cells["LOC"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3846153846,    this->DataSet->PredictionTable->Cells["LOC"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6923076923,    this->DataSet->PredictionTable->Cells["LOC"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5384615385,    this->DataSet->PredictionTable->Cells["LOC"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8571428571,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_1"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7142857143,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5714285714,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6666666667,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_2"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.9375000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6250000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3125000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_3"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.9000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_6"]->Value, 1E-6);
    }

    //    Average of Column        0.7814926740     0.1650000000     0.2144230769     0.6563186813     0.2774725275     0.9833333333
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7814926740,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1650000000,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2144230769,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6563186813,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2774725275,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9833333333,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.8461538462     0.0000000000     0.3125000000     0.6923076923     0.2692307692     1.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8461538462,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3125000000,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6923076923,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2692307692,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.4375000000
    //    0.5769230769
    //    0.6285714286
    //    0.4333333333
    //    0.5750000000
    //    0.5400000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4375000000,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5769230769,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6285714286,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4333333333,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5750000000,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5400000000,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.3750000000
    //    0.6153846154
    //    0.7142857143
    //    0.5000000000
    //    0.6250000000
    //    0.6000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6153846154,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7142857143,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6250000000,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    0.8388888889
    //    0.7625000000
    //    0.8750000000
    //    0.7333333333
    //    0.4953703704
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8388888889,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7625000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8750000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7333333333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4953703704,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    0.9750000000
    //    0.7625000000
    //    0.8750000000
    //    1.0000000000
    //    0.3750000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9750000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7625000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8750000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    0.8763134948
    //    0.8512091963
    //    0.9216890507
    //    0.9113819053
    //    0.7788276971
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8763134948,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8512091963,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9216890507,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9113819053,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7788276971,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Order-based & Row-based
    //---------------------------------------------------------------------------
    //    FILENAME    BUG    LOC    N_COMM    HALVOL    SCPMN    N_VEXUSE
    //    module_1        0.8000000000     0.7500000000     0.7500000000     0.7500000000     0.5000000000
    //    module_2    0.0000000000     0.0000000000         0.1250000000     0.5000000000     0.2500000000
    //    module_3    0.5000000000     0.2000000000     0.0000000000         0.2500000000     0.0000000000
    //    module_4    0.5000000000     0.6000000000     0.5000000000     0.5000000000         1.0000000000
    //    module_5        0.4000000000     0.2500000000     0.1250000000     0.0000000000
    //    module_6    1.0000000000     1.0000000000     1.0000000000     1.0000000000     1.0000000000     0.7500000000
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,    this->DataSet->PredictionTable->Cells["module_1"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["module_1"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["module_1"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["module_1"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["module_1"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["LOC"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->Cells["module_2"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["module_2"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["module_2"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["module_3"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->PredictionTable->Cells["module_3"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["N_COMM"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["module_3"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["module_4"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["module_4"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["module_4"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["module_4"]["HALVOL"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_4"]["N_VEXUSE"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.4000000000,    this->DataSet->PredictionTable->Cells["module_5"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["module_5"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->Cells["module_5"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_5"]["SCPMN"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["module_6"]["N_VEXUSE"]->Value, 1E-6);
    }

    //    Average of Column        0.5000000000     0.5000000000     0.5000000000     0.5000000000     0.5000000000     0.5000000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.5000000000     0.5000000000     0.5000000000     0.5000000000     0.5000000000     0.5000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.7100000000
    //    0.1750000000
    //    0.1900000000
    //    0.6200000000
    //    0.1937500000
    //    0.9583333333
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7100000000,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1750000000,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1900000000,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6200000000,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1937500000,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9583333333,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.7500000000
    //    0.1250000000
    //    0.2000000000
    //    0.5000000000
    //    0.1875000000
    //    1.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1875000000,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    3.1666666667
    //    3.5000000000
    //    1.2083333333
    //    3.6666666667
    //    0.7433333333
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.1666666667,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2083333333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.6666666667,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7433333333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    2.0000000000
    //    3.5000000000
    //    1.4166666667
    //    3.0000000000
    //    0.7500000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4166666667,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    5.2625189681
    //    3.6254572056
    //    1.3965130952
    //    5.0756183746
    //    0.7470809300
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.2625189681,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.6254572056,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3965130952,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0756183746,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7470809300,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Order-based & Column-based
    //---------------------------------------------------------------------------
    //    FILENAME    module_1    module_2    module_3    module_4    module_5    module_6
    //    BUG        0.0000000000     0.5000000000     0.5000000000         1.0000000000
    //    LOC    0.8000000000     0.0000000000     0.2000000000     0.6000000000     0.4000000000     1.0000000000
    //    N_COMM    0.7500000000         0.0000000000     0.5000000000     0.2500000000     1.0000000000
    //    HALVOL    0.7500000000     0.1250000000         0.5000000000     0.1250000000     1.0000000000
    //    SCPMN    0.7500000000     0.5000000000     0.2500000000         0.0000000000     1.0000000000
    //    N_VEXUSE    0.5000000000     0.2500000000     0.0000000000     1.0000000000         0.7500000000
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_1"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_2"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_3"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_6"]->Value, 1E-6);
    }

    //    Average of Column        0.7100000000     0.1750000000     0.1900000000     0.6200000000     0.1937500000     0.9583333333
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7100000000,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1750000000,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1900000000,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6200000000,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1937500000,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9583333333,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.7500000000     0.1250000000     0.2000000000     0.5000000000     0.1875000000     1.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1875000000,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    1.4444444444
    //    1.0000000000
    //    0.6666666667
    //    1.0000000000
    //    0.6111111111
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.4444444444,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6666666667,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6111111111,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    0.5000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    1.1277066146
    //    1.0000000000
    //    0.9449960047
    //    1.0462183970
    //    1.1708028373
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.1277066146,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9449960047,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0462183970,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1708028373,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // ȉCASỸeXg

    //---------------------------------------------------------------------------
    // Value-based & Row-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    0.9901177604
    //    0.9999994185
    //    0.9997737281
    //    0.9994448571
    //    0.9999035624
    virtual void Test_TCFbECosineSimilarity_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9901177604,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999994185,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997737281,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9994448571,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999035624,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.9976507295
    //    -0.9999971731
    //    0.9829727877
    //    -0.6965683667
    //    0.9767712349
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9976507295,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999971731,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9829727877,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6965683667,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9767712349,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.9984564331
    //    -0.9999971112
    //    0.8320436060
    //    -0.6839439306
    //    0.9587974866
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9984564331,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999971112,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8320436060,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6839439306,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9587974866,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9891840230
    //    0.3514209594
    //    0.9997313139
    //    0.9884671240
    //    0.9943703173
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9891840230,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3514209594,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997313139,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9884671240,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9943703173,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.9900926718
    //    0.9999983627
    //    0.9997677324
    //    0.9831233986
    //    0.9999098538
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9900926718,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999983627,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997677324,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9831233986,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999098538,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    virtual void Test_TCFbERankCorrelation_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.0042074261
    //    0.0132625995
    //    0.0199750312
    //    0.0066489362
    //    0.0166500167
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0042074261,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0132625995,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0199750312,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0066489362,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0166500167,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    0.0049937578
    //    1.5384615385
    //    0.0199600798
    //    0.0099255583
    //    6.6666666667
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0049937578,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5384615385,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0199600798,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0099255583,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.6666666667,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    5.5085887372
    //    1.9425139355
    //    1.7816757791
    //    5.6010422355
    //    5.5086187813
    //    5.5000000000
    //    6.3056236075
    //    9.0483620803
    virtual void Test_TCFbEWeightedSum_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5085887372,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.9425139355,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.7816757791,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6010422355,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5086187813,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3056236075,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.0483620803,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    5.5085887372
    //    7.4951929079
    //    7.5830164225
    //    5.6010422355
    //    5.5086187813
    //    5.5000000000
    //    6.3056236075
    //    9.0483620803
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5085887372,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4951929079,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5830164225,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6010422355,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5086187813,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3056236075,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.0483620803,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    5.5085887372
    //    6.9904039104
    //    7.0556218185
    //    5.6010422355
    //    5.5086187813
    //    5.5000000000
    //    6.3056236075
    //    9.0483620803
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5085887372,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9904039104,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0556218185,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6010422355,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5086187813,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3056236075,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.0483620803,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    5.5085887372
    //    7.4951929079
    //    7.5830164225
    //    5.6010422355
    //    5.5086187813
    //    5.5000000000
    //    6.3056236075
    //    9.0483620803
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5085887372,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4951929079,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5830164225,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6010422355,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5086187813,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3056236075,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.0483620803,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    5.5085887372
    //    6.9904039104
    //    7.0556218185
    //    5.6010422355
    //    5.5086187813
    //    5.5000000000
    //    6.3056236075
    //    9.0483620803
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5085887372,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9904039104,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0556218185,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6010422355,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5086187813,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3056236075,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.0483620803,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    281.7406273018
    //    679.9396998522
    //    708.1546245261
    //    184.3135253771
    //    281.7411374673
    //    281.5008333333
    //    256.0959133680
    //    231.9847013676
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(281.7406273018,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(679.9396998522,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(708.1546245261,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(184.3135253771,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(281.7411374673,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(281.5008333333,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(256.0959133680,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(231.9847013676,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    4.8683499193
    //    4.6008899133
    //    4.6138722997
    //    4.6454715722
    //    4.8683691000
    //    4.8625000000
    //    5.2816621642
    //    6.7625604446
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.8683499193,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.6008899133,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.6138722997,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.6454715722,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.8683691000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.8625000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.2816621642,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7625604446,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    6.4563463327
    //    0.5297739087
    //    0.3049411761
    //    6.1096261815
    //    6.4563704304
    //    6.4489890886
    //    6.9402192833
    //    8.7917227555
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4563463327,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5297739087,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.3049411761,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.1096261815,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4563704304,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4489890886,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9402192833,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7917227555,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.2489709923
    //    0.8545838497
    //    0.6335474270
    //    5.9050471690
    //    6.2489986007
    //    6.2400793651
    //    6.9074026500
    //    8.7105454966
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.2489709923,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8545838497,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6335474270,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9050471690,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.2489986007,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.2400793651,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9074026500,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7105454966,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    6.7555041841
    //    0.2956259241
    //    0.0511223870
    //    6.4641018719
    //    6.7555231020
    //    6.7499853901
    //    7.0832603311
    //    8.7141394994
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7555041841,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.2956259241,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0511223870,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4641018719,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7555231020,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7499853901,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0832603311,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7141394994,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Value-based & Column-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃ACeƂق̃ACe̊Ԃ̗ގxvZƂ
    //    0.9836066949
    //    0.9017000960
    //    0.8968217659
    //    0.8991068415
    //    0.9227002865
    virtual void Test_TCFbECosineSimilarity_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9836066949,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9017000960,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8968217659,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8991068415,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9227002865,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.3553050841
    //    0.9999880635
    //    -0.9962689032
    //    0.9999871077
    //    0.9999878833
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.3553050841,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999880635,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9962689032,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999871077,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999878833,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    0.6686639593
    //    -0.8267794991
    //    0.3184271644
    //    -0.7628956006
    //    -0.5803600916
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6686639593,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8267794991,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3184271644,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7628956006,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5803600916,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9197895190
    //    0.5801908394
    //    0.9836910734
    //    0.6504566481
    //    0.5734835971
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9197895190,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5801908394,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9836910734,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6504566481,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5734835971,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.8445765603
    //    0.3713906764
    //    0.9701425001
    //    0.6587443126
    //    0.5276900959
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8445765603,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3713906764,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9701425001,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6587443126,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5276900959,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    0.9486832981
    //    0.8660254038
    //    1.0000000000
    //    0.5000000000
    //    0.3162277660
    virtual void Test_TCFbERankCorrelation_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9486832981,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8660254038,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3162277660,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.0017182131
    //    0.1546391753
    //    0.0002861776
    //    0.3191489362
    //    0.2025316456
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0017182131,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1546391753,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0002861776,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3191489362,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2025316456,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    0.0016806723
    //    0.2000000000
    //    0.0002861230
    //    0.5000000000
    //    0.2247191011
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0016806723,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0002861230,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2247191011,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    873.1364957916
    //    -757.7607670362
    //    531.3759918434
    //    1154.4465349790
    //    1236.8221371001
    //    1201.1766720065
    //    5.6747447069
    //    4.9309180294
    virtual void Test_TCFbEWeightedSum_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(873.1364957916,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-757.7607670362,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(531.3759918434,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1154.4465349790,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1236.8221371001,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1201.1766720065,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6747447069,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9309180294,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    873.1364957916
    //    -354.3663020927
    //    1742.4505020519
    //    1154.4465349790
    //    1236.8221371001
    //    1201.1766720065
    //    5.6747447069
    //    4.9309180294
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(873.1364957916,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-354.3663020927,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1742.4505020519,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1154.4465349790,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1236.8221371001,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1201.1766720065,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6747447069,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9309180294,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    873.1364957916
    //    -755.9291955365
    //    536.8747523610
    //    1154.4465349790
    //    1236.8221371001
    //    1201.1766720065
    //    5.6747447069
    //    4.9309180294
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(873.1364957916,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-755.9291955365,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(536.8747523610,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1154.4465349790,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1236.8221371001,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1201.1766720065,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6747447069,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9309180294,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    873.1364957916
    //    -354.3663020927
    //    1742.4505020519
    //    1154.4465349790
    //    1236.8221371001
    //    1201.1766720065
    //    5.6747447069
    //    4.9309180294
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(873.1364957916,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-354.3663020927,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1742.4505020519,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1154.4465349790,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1236.8221371001,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1201.1766720065,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6747447069,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9309180294,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    873.1364957916
    //    -755.9291955365
    //    536.8747523610
    //    1154.4465349790
    //    1236.8221371001
    //    1201.1766720065
    //    5.6747447069
    //    4.9309180294
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(873.1364957916,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-755.9291955365,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(536.8747523610,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1154.4465349790,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1236.8221371001,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1201.1766720065,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6747447069,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9309180294,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    70.2940236880
    //    -12.1051047669
    //    56.5179027437
    //    86.1774891195
    //    89.7237935206
    //    89.8827339687
    //    6.3024270113
    //    6.1980967847
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(70.2940236880,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-12.1051047669,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(56.5179027437,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(86.1774891195,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(89.7237935206,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(89.8827339687,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3024270113,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.1980967847,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    56.6336099214
    //    -5.5206813825
    //    46.7213346640
    //    68.8394183841
    //    71.4331335925
    //    71.8135612192
    //    5.6687896181
    //    5.5834912841
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(56.6336099214,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-5.5206813825,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(46.7213346640,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(68.8394183841,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(71.4331335925,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(71.8135612192,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6687896181,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5834912841,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    6.5291385470
    //    3.8340870341
    //    -2.4495683047
    //    6.4816870463
    //    6.4216001505
    //    6.5782588617
    //    6.4632114933
    //    6.4525282124
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5291385470,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.8340870341,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-2.4495683047,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4816870463,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4216001505,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5782588617,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4632114933,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4525282124,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.4463614446
    //    3.9667971678
    //    -2.5552539516
    //    6.3691043537
    //    6.3061917131
    //    6.4650434431
    //    6.5721274414
    //    6.6087908140
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4463614446,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.9667971678,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-2.5552539516,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3691043537,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3061917131,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4650434431,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5721274414,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.6087908140,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    7.5671690714
    //    4.4310567202
    //    -2.9372784453
    //    7.4800621056
    //    7.4331927979
    //    7.4752753087
    //    7.5714985484
    //    7.4734182670
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5671690714,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.4310567202,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-2.9372784453,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4800621056,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4331927979,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4752753087,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5714985484,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4734182670,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Standardized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    -0.6685321921
    //    -0.7263668776
    //    0.4756642569
    //    -0.7943749408
    //    0.9359682466
    virtual void Test_TCFbECosineSimilarity_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6685321921,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7263668776,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4756642569,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7943749408,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9359682466,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.6685321921
    //    -0.7263668776
    //    0.4756642569
    //    -0.7943749408
    //    0.9359682466
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6685321921,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7263668776,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4756642569,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7943749408,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9359682466,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.6441729975
    //    -0.6252352350
    //    0.1708979822
    //    -0.8464172857
    //    0.8913308489
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6441729975,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6252352350,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1708979822,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8464172857,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8913308489,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.1932599017
    //    0.5206404284
    //    -0.8899375377
    //    -0.2454869582
    //    0.4257212724
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.1932599017,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5206404284,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8899375377,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2454869582,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4257212724,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.1612725498
    //    0.4574269066
    //    -0.8919718972
    //    -0.3464579202
    //    0.4568398976
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.1612725498,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4574269066,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8919718972,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3464579202,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4568398976,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    0.2000000000
    //    0.6000000000
    //    -0.2000000000
    //    -0.2000000000
    //    0.3000000000
    virtual void Test_TCFbERankCorrelation_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.6480796282
    //    0.5632770548
    //    1.7046881796
    //    0.6701997000
    //    1.8637615340
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6480796282,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5632770548,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7046881796,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6701997000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8637615340,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    0.7282241594
    //    0.6248077011
    //    2.2191499289
    //    0.7518839594
    //    2.1164041832
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7282241594,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6248077011,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.2191499289,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7518839594,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1164041832,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    7.8791184665
    //    7.8791184665
    //    8.2846370429
    //    6.2016226314
    //    6.3684057634
    //    5.8461538462
    //    6.5428593071
    //    6.4761750070
    virtual void Test_TCFbEWeightedSum_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8791184665,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8791184665,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2846370429,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.2016226314,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3684057634,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8461538462,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5428593071,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4761750070,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    7.8791184665
    //    7.8791184665
    //    8.2846370429
    //    6.2016226314
    //    6.3684057634
    //    5.8461538462
    //    6.5428593071
    //    6.4761750070
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8791184665,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8791184665,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2846370429,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.2016226314,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3684057634,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8461538462,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5428593071,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4761750070,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    7.3820996255
    //    7.3820996255
    //    7.7402091590
    //    5.7631345282
    //    5.9150554221
    //    5.6923076923
    //    6.5428593071
    //    6.4761750070
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3820996255,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3820996255,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7402091590,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.7631345282,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9150554221,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6923076923,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5428593071,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4761750070,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    7.8791184665
    //    7.8791184665
    //    8.2846370429
    //    6.2016226314
    //    6.3684057634
    //    5.8461538462
    //    6.5428593071
    //    6.4761750070
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8791184665,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8791184665,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2846370429,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.2016226314,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3684057634,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8461538462,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5428593071,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4761750070,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    7.3820996255
    //    7.3820996255
    //    7.7402091590
    //    5.7631345282
    //    5.9150554221
    //    5.6923076923
    //    6.5428593071
    //    6.4761750070
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3820996255,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3820996255,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7402091590,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.7631345282,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9150554221,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6923076923,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5428593071,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4761750070,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    6.9971833436
    //    6.9971833436
    //    7.1962453031
    //    8.6971059189
    //    8.6976628954
    //    8.6882033604
    //    7.3198994084
    //    7.2400757620
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9971833436,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9971833436,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.1962453031,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6971059189,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6976628954,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6882033604,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3198994084,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2400757620,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    7.2199129827
    //    7.2199129827
    //    7.3836873837
    //    8.5024992234
    //    8.5113929208
    //    8.4676331522
    //    7.5020621945
    //    7.4335338255
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2199129827,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2199129827,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3836873837,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5024992234,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5113929208,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4676331522,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5020621945,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4335338255,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    7.9852154064
    //    7.9852154064
    //    8.4914422136
    //    5.6726577406
    //    5.8504306686
    //    4.9003816983
    //    5.0085713034
    //    4.9884189461
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9852154064,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9852154064,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4914422136,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6726577406,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8504306686,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9003816983,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.0085713034,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9884189461,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.7435511624
    //    6.7435511624
    //    7.0699084414
    //    6.3496068260
    //    6.4641013403
    //    5.8594508056
    //    5.8440931022
    //    5.7695640772
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7435511624,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7435511624,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0699084414,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3496068260,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4641013403,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8594508056,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8440931022,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.7695640772,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    7.6846694941
    //    7.6846694941
    //    8.1317868024
    //    5.7242593720
    //    5.8826153588
    //    5.0467776194
    //    5.1647333848
    //    5.1404938071
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6846694941,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6846694941,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1317868024,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.7242593720,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8826153588,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.0467776194,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.1647333848,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.1404938071,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Standardized Value-based & Column-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃ACeƂق̃ACe̊Ԃ̗ގxvZƂ
    //    0.9197895190
    //    0.5801908394
    //    0.9836910734
    //    0.6504566481
    //    0.5734835971
    virtual void Test_TCFbECosineSimilarity_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9197895190,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5801908394,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9836910734,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6504566481,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5734835971,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.5425783563
    //    -0.7505577749
    //    0.9560931789
    //    -0.1325356570
    //    -0.8994903813
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5425783563,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7505577749,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9560931789,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1325356570,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8994903813,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    0.2086983819
    //    -0.7375326010
    //    0.8276918233
    //    -0.2010362691
    //    -0.9425209184
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.2086983819,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7375326010,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8276918233,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2010362691,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9425209184,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9197895190
    //    0.5801908394
    //    0.9836910734
    //    0.6504566481
    //    0.5734835971
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9197895190,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5801908394,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9836910734,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6504566481,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5734835971,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.8445765603
    //    0.3713906764
    //    0.9701425001
    //    0.6587443126
    //    0.5276900959
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8445765603,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3713906764,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9701425001,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6587443126,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5276900959,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    0.9486832981
    //    0.8660254038
    //    1.0000000000
    //    0.5000000000
    //    0.3162277660
    virtual void Test_TCFbERankCorrelation_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9486832981,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8660254038,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3162277660,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    2.2654496090
    //    1.1719546701
    //    5.3730705644
    //    1.2967526339
    //    1.1239717110
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.2654496090,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1719546701,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.3730705644,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2967526339,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1239717110,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    2.1164041832
    //    2.0374431173
    //    9.1776015587
    //    1.9210797177
    //    1.0771446655
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.1164041832,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0374431173,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(9.1776015587,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.9210797177,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0771446655,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    7.3963128657
    //    5.7269858610
    //    5.3448561446
    //    7.3963128657
    //    7.4078212982
    //    7.4670534651
    //    7.3648955089
    //    7.3674924426
    virtual void Test_TCFbEWeightedSum_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.7269858610,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.3448561446,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4078212982,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4670534651,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3648955089,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3674924426,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    7.3963128657
    //    7.7262695701
    //    7.7176834782
    //    7.3963128657
    //    7.4078212982
    //    7.4670534651
    //    7.3648955089
    //    7.3674924426
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7262695701,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7176834782,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4078212982,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4670534651,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3648955089,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3674924426,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    7.3963128657
    //    7.7932244064
    //    7.7971480708
    //    7.3963128657
    //    7.4078212982
    //    7.4670534651
    //    7.3648955089
    //    7.3674924426
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7932244064,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7971480708,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4078212982,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4670534651,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3648955089,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3674924426,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    7.3963128657
    //    7.7262695701
    //    7.7176834782
    //    7.3963128657
    //    7.4078212982
    //    7.4670534651
    //    7.3648955089
    //    7.3674924426
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7262695701,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7176834782,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4078212982,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4670534651,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3648955089,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3674924426,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    7.3963128657
    //    7.7932244064
    //    7.7971480708
    //    7.3963128657
    //    7.4078212982
    //    7.4670534651
    //    7.3648955089
    //    7.3674924426
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7932244064,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7971480708,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4078212982,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4670534651,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3648955089,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3674924426,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.3963128657
    //    5.7269858610
    //    5.3448561446
    //    7.3963128657
    //    7.4078212982
    //    7.4670534651
    //    7.3648955089
    //    7.3674924426
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.7269858610,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.3448561446,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4078212982,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4670534651,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3648955089,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3674924426,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    6.4344463441
    //    5.3276416043
    //    5.0308637184
    //    6.4344463441
    //    6.4588646709
    //    6.4816138179
    //    6.3980348673
    //    6.3836750588
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4344463441,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.3276416043,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.0308637184,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4344463441,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4588646709,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4816138179,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3980348673,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3836750588,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    8.4097779902
    //    5.4647588967
    //    4.9646422830
    //    8.4097779902
    //    8.5870654272
    //    8.1651171039
    //    8.0331497042
    //    8.1096186429
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4097779902,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.4647588967,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9646422830,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4097779902,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5870654272,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1651171039,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0331497042,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1096186429,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    7.2737634965
    //    5.7177923703
    //    5.4139783909
    //    7.2737634965
    //    7.3335706061
    //    7.2524091609
    //    7.2853143663
    //    7.3632608217
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2737634965,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.7177923703,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.4139783909,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2737634965,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3335706061,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2524091609,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2853143663,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3632608217,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    7.8825226795
    //    5.5705965841
    //    5.1398729440
    //    7.8825226795
    //    7.9702160762
    //    7.8068200026
    //    7.6982419154
    //    7.7506548651
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8825226795,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5705965841,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.1398729440,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8825226795,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9702160762,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8068200026,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6982419154,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7506548651,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Normalized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    0.6944994562
    //    0.7609133497
    //    0.9484206852
    //    0.7229564935
    //    0.9909483325
    virtual void Test_TCFbECosineSimilarity_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6944994562,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7609133497,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9484206852,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7229564935,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9909483325,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.6325046601
    //    -0.7118987884
    //    0.4510233762
    //    -0.8260362038
    //    0.9282829241
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6325046601,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7118987884,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4510233762,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8260362038,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9282829241,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.6002671236
    //    -0.6047799861
    //    0.1368306741
    //    -0.8693886832
    //    0.8778496852
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6002671236,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6047799861,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1368306741,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8693886832,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8778496852,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.5217016230
    //    0.5232452951
    //    -0.4152703551
    //    0.2288910488
    //    0.7133008256
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5217016230,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5232452951,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4152703551,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2288910488,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7133008256,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.0376633264
    //    0.6245229727
    //    -0.3698247162
    //    0.2413616015
    //    0.7735019523
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0376633264,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6245229727,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3698247162,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2413616015,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7735019523,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    0.3162277660
    //    0.2108185107
    //    -0.2000000000
    //    0.1054092553
    //    0.7071067812
    virtual void Test_TCFbERankCorrelation_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.3162277660,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2108185107,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1054092553,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7071067812,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    1.7974938787
    //    1.5725240307
    //    4.6330080611
    //    1.8201896031
    //    5.0375974535
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.7974938787,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5725240307,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.6330080611,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8201896031,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0375974535,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    1.8750000000
    //    1.6326530612
    //    6.2400000000
    //    2.0526315789
    //    6.5000000000
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.8750000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6326530612,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.2400000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0526315789,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.5000000000,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    5.8457813913
    //    4.4391869066
    //    4.5313691091
    //    4.7744565036
    //    5.8504904216
    //    5.9670171536
    //    6.5179876750
    //    6.6540850484
    virtual void Test_TCFbEWeightedSum_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8457813913,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.4391869066,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.5313691091,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.7744565036,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8504904216,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9670171536,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5179876750,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.6540850484,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    5.8457813913
    //    7.8943363194
    //    8.3315337175
    //    6.1118700210
    //    7.2843062179
    //    6.9432030581
    //    6.5179876750
    //    6.6540850484
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8457813913,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8943363194,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3315337175,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.1118700210,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2843062179,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9432030581,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5179876750,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.6540850484,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    5.8457813913
    //    7.4007435461
    //    7.7886530592
    //    5.9208109471
    //    7.0794753899
    //    6.8037479289
    //    6.5179876750
    //    6.6540850484
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8457813913,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4007435461,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7886530592,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9208109471,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0794753899,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8037479289,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5179876750,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.6540850484,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    5.8457813913
    //    7.8943363194
    //    8.3315337175
    //    6.1118700210
    //    7.2843062179
    //    6.9432030581
    //    6.5179876750
    //    6.6540850484
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8457813913,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8943363194,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3315337175,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.1118700210,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2843062179,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9432030581,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5179876750,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.6540850484,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    5.8457813913
    //    7.4007435461
    //    7.7886530592
    //    5.9208109471
    //    7.0794753899
    //    6.8037479289
    //    6.5179876750
    //    6.6540850484
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8457813913,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4007435461,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7886530592,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9208109471,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0794753899,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8037479289,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5179876750,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.6540850484,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.6800049332
    //    7.8954829478
    //    8.1728980646
    //    8.7181054697
    //    9.1868549947
    //    8.5293112606
    //    7.4768452087
    //    7.4177020951
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6800049332,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8954829478,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1728980646,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7181054697,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.1868549947,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5293112606,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4768452087,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4177020951,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    8.1721164738
    //    8.2181974265
    //    8.4765239368
    //    9.3745951657
    //    9.4621348507
    //    9.1967315577
    //    7.9276720187
    //    7.8445634703
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1721164738,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2181974265,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4765239368,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.3745951657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.4621348507,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.1967315577,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9276720187,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8445634703,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    6.5170356198
    //    2.6693517040
    //    2.5908826247
    //    5.3403742334
    //    6.7529876635
    //    5.8261368945
    //    6.5574729267
    //    6.5821784831
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5170356198,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.6693517040,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.5908826247,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.3403742334,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7529876635,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.8261368945,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5574729267,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5821784831,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.7393356617
    //    2.8700152617
    //    2.7758766252
    //    5.4050765801
    //    6.8537983891
    //    5.9774601920
    //    6.8463641416
    //    6.8872716311
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7393356617,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.8700152617,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.7758766252,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.4050765801,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8537983891,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9774601920,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8463641416,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8872716311,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    6.4087728650
    //    2.7659621389
    //    2.6467779086
    //    5.0691078533
    //    6.3961104323
    //    5.5758062958
    //    6.5014389860
    //    6.5418164361
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4087728650,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.7659621389,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.6467779086,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.0691078533,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3961104323,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5758062958,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5014389860,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.5418164361,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Normalized Value-based & Column-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃ACeƂق̃ACe̊Ԃ̗ގxvZƂ
    //    0.9722536510
    //    0.9114556946
    //    0.9945054529
    //    0.8574565448
    //    0.8281469016
    virtual void Test_TCFbECosineSimilarity_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9722536510,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9114556946,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9945054529,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8574565448,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8281469016,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.5111669542
    //    -0.6984463542
    //    0.9604245007
    //    -0.5511071481
    //    -0.9155257605
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5111669542,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6984463542,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9604245007,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5511071481,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9155257605,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    0.1932564780
    //    -0.2616141047
    //    1.0000000000
    //    0.0000000000
    //    -0.7359449862
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.1932564780,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2616141047,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7359449862,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9197895190
    //    0.5801908394
    //    0.9836910734
    //    0.6504566481
    //    0.5734835971
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9197895190,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5801908394,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9836910734,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6504566481,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5734835971,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.8445765603
    //    0.3713906764
    //    0.9701425001
    //    0.6587443126
    //    0.5276900959
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8445765603,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3713906764,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9701425001,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6587443126,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5276900959,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    0.9486832981
    //    0.8660254038
    //    1.0000000000
    //    0.5000000000
    //    0.3162277660
    virtual void Test_TCFbERankCorrelation_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9486832981,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8660254038,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3162277660,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    12.2352941176
    //    4.2000000000
    //    24.0000000000
    //    4.3636363636
    //    3.0769230769
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(12.2352941176,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.2000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(24.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.3636363636,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0769230769,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    208.0000000000
    //    2.9473684211
    //    0.0000000000
    //    16.0000000000
    //    3.4782608696
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(208.0000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9473684211,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(16.0000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4782608696,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    8.2538532430
    //    0.6980667268
    //    2.6002649545
    //    8.2256297348
    //    8.2004824253
    //    8.3238624241
    //    7.9971783596
    //    8.7913720505
    virtual void Test_TCFbEWeightedSum_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2538532430,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6980667268,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.6002649545,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2256297348,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2004824253,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3238624241,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9971783596,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7913720505,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    8.2538532430
    //    8.1422098513
    //    8.2937437299
    //    8.2256297348
    //    8.2004824253
    //    8.3238624241
    //    7.9971783596
    //    8.7913720505
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2538532430,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1422098513,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2937437299,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2256297348,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2004824253,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3238624241,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9971783596,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7913720505,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    8.2538532430
    //    8.7581427144
    //    8.7648255756
    //    8.2256297348
    //    8.2004824253
    //    8.3238624241
    //    7.9971783596
    //    8.7913720505
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2538532430,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7581427144,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7648255756,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2256297348,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2004824253,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3238624241,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9971783596,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7913720505,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    8.2538532430
    //    8.1422098513
    //    8.2937437299
    //    8.2256297348
    //    8.2004824253
    //    8.3238624241
    //    7.9971783596
    //    8.7913720505
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2538532430,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1422098513,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2937437299,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2256297348,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2004824253,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3238624241,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9971783596,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7913720505,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    8.2538532430
    //    8.7581427144
    //    8.7648255756
    //    8.2256297348
    //    8.2004824253
    //    8.3238624241
    //    7.9971783596
    //    8.7913720505
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2538532430,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7581427144,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7648255756,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2256297348,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2004824253,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3238624241,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9971783596,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7913720505,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.3627585157
    //    5.3842197177
    //    6.1624371940
    //    7.3987493476
    //    7.4192587247
    //    7.4541413736
    //    7.4417807266
    //    7.6762294431
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3627585157,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.3842197177,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.1624371940,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3987493476,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4192587247,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4541413736,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4417807266,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6762294431,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    6.3817908081
    //    5.0132721844
    //    5.6349813262
    //    6.4291890259
    //    6.4600398558
    //    6.4664238878
    //    6.4683252826
    //    6.8546913482
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3817908081,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.0132721844,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6349813262,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4291890259,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4600398558,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4664238878,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4683252826,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8546913482,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    6.7356986948
    //    1.5943618168
    //    3.2079143266
    //    6.7978062138
    //    6.7866053164
    //    6.9805017665
    //    6.9034316974
    //    7.6106459045
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7356986948,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.5943618168,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.2079143266,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7978062138,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7866053164,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9805017665,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9034316974,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6106459045,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    7.2029020397
    //    1.5662396041
    //    3.4832788572
    //    7.2878875829
    //    7.3175891521
    //    7.4463255610
    //    7.2840556698
    //    8.5724954318
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2029020397,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.5662396041,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.4832788572,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2878875829,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3175891521,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4463255610,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2840556698,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5724954318,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    7.4631963622
    //    1.0340148861
    //    2.8142281479
    //    7.4666366793
    //    7.4623815100
    //    7.5627426971
    //    7.3555208096
    //    7.9603684524
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4631963622,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.0340148861,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.8142281479,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4666366793,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4623815100,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5627426971,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3555208096,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9603684524,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Order-based & Row-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    0.7302077484
    //    0.7646370735
    //    0.8936184067
    //    0.8076212696
    //    0.9987569171
    virtual void Test_TCFbECosineSimilarity_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7302077484,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7646370735,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8936184067,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8076212696,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9987569171,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.7809376882
    //    -0.7408896016
    //    0.1268864803
    //    -0.8682179366
    //    0.9668594366
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7809376882,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7408896016,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1268864803,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8682179366,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9668594366,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.7809376882
    //    -0.7408896016
    //    0.1268864803
    //    -0.8682179366
    //    0.9668594366
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7809376882,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7408896016,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1268864803,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8682179366,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9668594366,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    -0.2292202491
    //    0.5490023806
    //    -0.9299617703
    //    0.3061292983
    //    0.9800181487
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2292202491,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5490023806,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9299617703,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3061292983,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9800181487,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    -0.3547874376
    //    0.6827887420
    //    -0.9230769231
    //    0.7158291329
    //    0.9805806757
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3547874376,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6827887420,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9230769231,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7158291329,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9805806757,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    -0.6324555320
    //    0.5000000000
    //    -0.3333333333
    //    0.7745966692
    //    0.7905694150
    virtual void Test_TCFbERankCorrelation_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6324555320,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3333333333,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7745966692,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7905694150,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    2.0779220779
    //    1.7021276596
    //    3.3333333333
    //    1.7582417582
    //    4.1666666667
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.0779220779,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7021276596,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.3333333333,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7582417582,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1666666667,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    2.2857142857
    //    1.8181818182
    //    4.0000000000
    //    1.7777777778
    //    4.0000000000
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.2857142857,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8181818182,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7777777778,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    5.3964152862
    //    3.5136824485
    //    3.5136824485
    //    3.7622298310
    //    3.7552564332
    //    4.3238403829
    //    5.9258578807
    //    5.7081545064
    virtual void Test_TCFbEWeightedSum_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.3964152862,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.5136824485,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.5136824485,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.7622298310,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.7552564332,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.3238403829,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9258578807,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.7081545064,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    5.3964152862
    //    8.3411359321
    //    8.3411359321
    //    7.2491578961
    //    7.2700815609
    //    8.1533665540
    //    5.9258578807
    //    5.7081545064
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.3964152862,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2491578961,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2700815609,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1533665540,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9258578807,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.7081545064,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    5.3964152862
    //    8.3411359321
    //    8.3411359321
    //    7.2491578961
    //    7.2700815609
    //    8.1533665540
    //    5.9258578807
    //    5.7081545064
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.3964152862,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2491578961,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2700815609,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1533665540,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9258578807,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.7081545064,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    5.3964152862
    //    8.3411359321
    //    8.3411359321
    //    7.2491578961
    //    7.2700815609
    //    8.1533665540
    //    5.9258578807
    //    5.7081545064
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.3964152862,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2491578961,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2700815609,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1533665540,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9258578807,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.7081545064,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    5.3964152862
    //    8.3411359321
    //    8.3411359321
    //    7.2491578961
    //    7.2700815609
    //    8.1533665540
    //    5.9258578807
    //    5.7081545064
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.3964152862,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2491578961,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2700815609,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1533665540,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9258578807,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.7081545064,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.2288130020
    //    6.8402013116
    //    6.8402013116
    //    8.4493543622
    //    8.5462606599
    //    8.6007373312
    //    7.0447115221
    //    6.9763233190
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2288130020,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8402013116,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8402013116,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4493543622,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5462606599,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6007373312,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0447115221,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9763233190,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    7.9077536964
    //    7.0234326872
    //    7.0234326872
    //    8.2192659103
    //    8.3472126702
    //    8.5151621021
    //    7.7224263580
    //    7.7145922747
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9077536964,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0234326872,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0234326872,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2192659103,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3472126702,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5151621021,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7224263580,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7145922747,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    7.7361923003
    //    0.8502771665
    //    0.8502771665
    //    4.5162890072
    //    4.7867617388
    //    5.5898379286
    //    7.1718074863
    //    7.0818669528
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7361923003,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8502771665,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8502771665,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.5162890072,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.7867617388,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5898379286,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.1718074863,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0818669528,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    8.0306627683
    //    0.8953833128
    //    0.8953833128
    //    4.3146578538
    //    4.6039473519
    //    5.4593100788
    //    7.5042528290
    //    7.4481402003
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0306627683,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8953833128,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8953833128,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.3146578538,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.6039473519,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.4593100788,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5042528290,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4481402003,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    8.1370756118
    //    0.7793645962
    //    0.7793645962
    //    4.4060537262
    //    4.7044554766
    //    5.6029730016
    //    7.5583483462
    //    7.4994200376
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1370756118,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7793645962,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7793645962,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.4060537262,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.7044554766,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6029730016,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5583483462,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4994200376,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Order-based & Column-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃ACeƂق̃ACe̊Ԃ̗ގxvZƂ
    //    0.9660917831
    //    0.9128709292
    //    0.9938079900
    //    0.8783100657
    //    0.8006407690
    virtual void Test_TCFbECosineSimilarity_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9660917831,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9128709292,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9938079900,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8783100657,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8006407690,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.5525800754
    //    -0.5585029467
    //    0.8430182553
    //    -0.3060441633
    //    -0.6975057878
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5525800754,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5585029467,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8430182553,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3060441633,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6975057878,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    0.3003341575
    //    -1.0000000000
    //    0.0000000000
    //    -0.2592442202
    //    -0.3835167802
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.3003341575,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.0000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2592442202,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3835167802,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9128709292
    //    0.7071067812
    //    0.9899494937
    //    0.6324555320
    //    0.4472135955
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9128709292,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7071067812,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9899494937,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6324555320,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4472135955,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.9128709292
    //    0.7071067812
    //    0.9899494937
    //    0.6324555320
    //    0.4472135955
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9128709292,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7071067812,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9899494937,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6324555320,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4472135955,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    0.9486832981
    //    0.8660254038
    //    1.0000000000
    //    0.5000000000
    //    0.3162277660
    virtual void Test_TCFbERankCorrelation_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9486832981,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8660254038,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3162277660,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    10.0000000000
    //    6.0000000000
    //    24.0000000000
    //    4.0000000000
    //    2.6666666667
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(10.0000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.0000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(24.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6666666667,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    20.0000000000
    //    0.0000000000
    //    0.0000000000
    //    4.0000000000
    //    2.6666666667
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(20.0000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6666666667,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    7.1663776510
    //    2.1565387928
    //    -0.7664859097
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEWeightedSum_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.1565387928,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7664859097,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    7.1663776510
    //    7.7604810809
    //    7.3943696760
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7604810809,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3943696760,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    7.1663776510
    //    8.1829928045
    //    8.0707178183
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1829928045,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0707178183,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    7.1663776510
    //    7.7604810809
    //    7.3943696760
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7604810809,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3943696760,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    7.1663776510
    //    8.1829928045
    //    8.0707178183
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1829928045,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0707178183,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.1663776510
    //    5.5422945323
    //    4.3061251574
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5422945323,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.3061251574,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    7.1663776510
    //    5.5422945323
    //    4.3061251574
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5422945323,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.3061251574,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    7.0331690488
    //    2.4027026598
    //    -0.2064777658
    //    7.2939365509
    //    7.2939365509
    //    7.4840209493
    //    6.8293650794
    //    10.0972222222
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0331690488,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.4027026598,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2064777658,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2939365509,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2939365509,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4840209493,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8293650794,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(10.0972222222,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.7266315228
    //    2.5102852628
    //    -0.4704246654
    //    7.0176620007
    //    7.0176620007
    //    7.1951758339
    //    7.3214285714
    //    7.3750000000
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7266315228,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.5102852628,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4704246654,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0176620007,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0176620007,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.1951758339,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3214285714,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3750000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    7.5102583344
    //    2.0581516115
    //    -0.8006238349
    //    7.6257088075
    //    7.6257088075
    //    7.6883396532
    //    7.5495657091
    //    8.5286368031
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5102583344,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.0581516115,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8006238349,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6257088075,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6257088075,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6883396532,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5495657091,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5286368031,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Double Standardized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    FILENAME    BUG                LOC                N_COMM            HALVOL            SCPMN            N_VEXUSE
    //    module_1    0.6806088978     0.0784026627     -0.1475840337     1.1643069326     -1.7757344594
    //    module_2    -0.3981798752     -1.2843275071                     -0.2319415572     1.7651852932     0.1492636463
    //    module_3    1.2856569703     0.5813901823     -1.4983872942                     0.4055650112     -0.7742248697
    //    module_4    -1.1788239623     -0.0063624869     -0.2417476312     -0.4121041998                     1.8390382802
    //    module_5                    1.0101302589     0.9318826459     -0.6352055194     -1.3068073854
    //    module_6    1.4637636381     0.2582748148     -0.7495239050     0.9724100483     -0.5297677628     -1.4151568334
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(0.6806088978,    this->DataSet->PredictionTable->Cells["module_1"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0784026627,    this->DataSet->PredictionTable->Cells["module_1"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1475840337,    this->DataSet->PredictionTable->Cells["module_1"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1643069326,    this->DataSet->PredictionTable->Cells["module_1"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.7757344594,    this->DataSet->PredictionTable->Cells["module_1"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.3981798752,    this->DataSet->PredictionTable->Cells["module_2"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.2843275071,    this->DataSet->PredictionTable->Cells["module_2"]["LOC"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.2319415572,    this->DataSet->PredictionTable->Cells["module_2"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7651852932,    this->DataSet->PredictionTable->Cells["module_2"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1492636463,    this->DataSet->PredictionTable->Cells["module_2"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.2856569703,    this->DataSet->PredictionTable->Cells["module_3"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5813901823,    this->DataSet->PredictionTable->Cells["module_3"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.4983872942,    this->DataSet->PredictionTable->Cells["module_3"]["N_COMM"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.4055650112,    this->DataSet->PredictionTable->Cells["module_3"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7742248697,    this->DataSet->PredictionTable->Cells["module_3"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.1788239623,    this->DataSet->PredictionTable->Cells["module_4"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.0063624869,    this->DataSet->PredictionTable->Cells["module_4"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2417476312,    this->DataSet->PredictionTable->Cells["module_4"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4121041998,    this->DataSet->PredictionTable->Cells["module_4"]["HALVOL"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.8390382802,    this->DataSet->PredictionTable->Cells["module_4"]["N_VEXUSE"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0101302589,    this->DataSet->PredictionTable->Cells["module_5"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9318826459,    this->DataSet->PredictionTable->Cells["module_5"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6352055194,    this->DataSet->PredictionTable->Cells["module_5"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.3068073854,    this->DataSet->PredictionTable->Cells["module_5"]["SCPMN"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.4637636381,    this->DataSet->PredictionTable->Cells["module_6"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2582748148,    this->DataSet->PredictionTable->Cells["module_6"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7495239050,    this->DataSet->PredictionTable->Cells["module_6"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9724100483,    this->DataSet->PredictionTable->Cells["module_6"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5297677628,    this->DataSet->PredictionTable->Cells["module_6"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.4151568334,    this->DataSet->PredictionTable->Cells["module_6"]["N_VEXUSE"]->Value, 1E-6);
    }

    //    Average of Column        0.2931041927     0.2066190266     -0.2958747044     -0.0908850524     0.2996964178     -0.3953628472 
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.2931041927,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2066190266,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2958747044,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.0908850524,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2996964178,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3953628472,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.4437385475     0.4198324986     -0.2417476312     -0.2319415572     0.4055650112     -0.7742248697 
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4437385475,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4198324986,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2417476312,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2319415572,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4055650112,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7742248697,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.0000000000
    //    0.0000000000
    //    0.0000000000
    //    0.0000000000
    //    0.0000000000
    //    0.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.0784026627
    //    -0.2319415572
    //    0.4055650112
    //    -0.2417476312
    //    0.1483385632
    //    -0.1357464740
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0784026627,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2319415572,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4055650112,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2417476312,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1483385632,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1357464740,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    3.4306144373
    //    1.5968433743
    //    27.1550417149
    //    0.4703031997
    //    1.2688304410
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.4306144373,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5968433743,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(27.1550417149,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4703031997,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2688304410,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    0.6479465522
    //    1.7321109636
    //    0.6618504292
    //    0.4530619510
    //    1.2547969367
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6479465522,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7321109636,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6618504292,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4530619510,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2547969367,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    2.9861250224
    //    1.7401306398
    //    1.8256093273
    //    0.3010168571
    //    0.5921719849
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.9861250224,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7401306398,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8256093273,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3010168571,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5921719849,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Double Standardized Value-based & Column-based
    //---------------------------------------------------------------------------
    //    FILENAME    module_1        module_2        module_3        module_4        module_5        module_6
    //    BUG                            -0.3981798752     1.2856569703     -1.1788239623                     1.4637636381
    //    LOC            0.6806088978     -1.2843275071     0.5813901823     -0.0063624869     1.0101302589     0.2582748148
    //    N_COMM        0.0784026627                     -1.4983872942     -0.2417476312     0.9318826459     -0.7495239050
    //    HALVOL        -0.1475840337     -0.2319415572                     -0.4121041998     -0.6352055194     0.9724100483
    //    SCPMN        1.1643069326     1.7651852932     0.4055650112                     -1.3068073854     -0.5297677628
    //    N_VEXUSE    -1.7757344594     0.1492636463     -0.7742248697     1.8390382802                     -1.4151568334
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(-0.3981798752,    this->DataSet->PredictionTable->Cells["BUG"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2856569703,    this->DataSet->PredictionTable->Cells["BUG"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.1788239623,    this->DataSet->PredictionTable->Cells["BUG"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.4637636381,    this->DataSet->PredictionTable->Cells["BUG"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6806088978,    this->DataSet->PredictionTable->Cells["LOC"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.2843275071,    this->DataSet->PredictionTable->Cells["LOC"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5813901823,    this->DataSet->PredictionTable->Cells["LOC"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.0063624869,    this->DataSet->PredictionTable->Cells["LOC"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0101302589,    this->DataSet->PredictionTable->Cells["LOC"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2582748148,    this->DataSet->PredictionTable->Cells["LOC"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0784026627 ,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_1"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.4983872942,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2417476312,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9318826459,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7495239050,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.1475840337,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2319415572,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_2"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.4121041998,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6352055194,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9724100483,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.1643069326,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7651852932,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4055650112,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_3"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.3068073854,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5297677628,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.7757344594,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1492636463,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7742248697,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8390382802,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.4151568334,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_6"]->Value, 1E-6);
    }

    //    Average of Column        0.0000000000     0.0000000000     0.0000000000     0.0000000000     0.0000000000     0.0000000000 
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.0784026627     -0.2319415572     0.4055650112     -0.2417476312     0.1483385632     -0.1357464740
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0784026627,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2319415572,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4055650112,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2417476312,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1483385632,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1357464740,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.2931041927
    //    0.2066190266
    //    -0.2958747044
    //    -0.0908850524
    //    0.2996964178
    //    -0.3953628472
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.2931041927,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2066190266,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2958747044,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.0908850524,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2996964178,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3953628472,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.4437385475
    //    0.4198324986
    //    -0.2417476312
    //    -0.2319415572
    //    0.4055650112
    //    -0.7742248697
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4437385475,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4198324986,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2417476312,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2319415572,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4055650112,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7742248697,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    48.3665196063
    //    2.5624034281
    //    2.0275064742
    //    2.0528806823
    //    1.5008871368
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(48.3665196063,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5624034281,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0275064742,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0528806823,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5008871368,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    3.9394076387
    //    1.9529245542
    //    1.7167250237
    //    2.7630288983
    //    1.3474601819
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.9394076387,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.9529245542,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7167250237,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.7630288983,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3474601819,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    10.3148699905
    //    1.6279657805
    //    1.6910030467
    //    1.9958857979
    //    1.7645826750
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(10.3148699905,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6279657805,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6910030467,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.9958857979,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7645826750,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Double Normalized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    FILENAME    BUG                LOC                N_COMM            HALVOL            SCPMN            N_VEXUSE
    //    module_1                    0.7293447293     0.7619047619     0.1975308642     1.0000000000     0.0000000000
    //    module_2    0.0000000000     0.0000000000                     0.0000000000     1.0000000000     0.3200000000
    //    module_3    0.9750000000     1.0000000000     0.0000000000                     0.8125000000     0.0000000000
    //    module_4    0.0000000000     0.5076923077     0.5428571429     0.2000000000                     1.0000000000
    //    module_5                    0.9423076923     1.0000000000     0.0000000000     0.0000000000
    //    module_6    1.0000000000     1.0000000000     1.0000000000     1.0000000000     1.0000000000     0.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(0.7293447293,    this->DataSet->PredictionTable->Cells["module_1"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7619047619,    this->DataSet->PredictionTable->Cells["module_1"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1975308642,    this->DataSet->PredictionTable->Cells["module_1"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_1"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_1"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["LOC"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3200000000,    this->DataSet->PredictionTable->Cells["module_2"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.9750000000,    this->DataSet->PredictionTable->Cells["module_3"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["N_COMM"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8125000000,    this->DataSet->PredictionTable->Cells["module_3"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_4"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5076923077,    this->DataSet->PredictionTable->Cells["module_4"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5428571429,    this->DataSet->PredictionTable->Cells["module_4"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->PredictionTable->Cells["module_4"]["HALVOL"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_4"]["N_VEXUSE"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.9423076923,    this->DataSet->PredictionTable->Cells["module_5"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_5"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_5"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_5"]["SCPMN"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["N_VEXUSE"]->Value, 1E-6);
    }

    //    Average of Column        0.4937500000     0.6965574549     0.6609523810     0.2795061728     0.7625000000     0.2640000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4937500000,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6965574549,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6609523810,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2795061728,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7625000000,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2640000000,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.4875000000     0.8358262108     0.7619047619     0.1975308642     1.0000000000     0.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4875000000,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8358262108,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7619047619,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1975308642,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.5377560711
    //    0.2640000000
    //    0.5575000000
    //    0.4501098901
    //    0.4855769231
    //    0.8333333333
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5377560711,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2640000000,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5575000000,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4501098901,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4855769231,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8333333333,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.7293447293
    //    0.0000000000
    //    0.8125000000
    //    0.5076923077
    //    0.4711538462
    //    1.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7293447293,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8125000000,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5076923077,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4711538462,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    0.5000000000
    //    0.9800569801
    //    0.9569377990
    //    0.7679516251
    //    0.6721950889
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9800569801,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9569377990,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7679516251,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6721950889,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    0.5000000000
    //    0.9800569801
    //    1.1955815465
    //    0.7679516251
    //    0.7456247456
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9800569801,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1955815465,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7679516251,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7456247456,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    1.0000000000
    //    0.8370345167
    //    1.1690962577
    //    0.7717043340
    //    0.4665115744
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8370345167,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1690962577,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7717043340,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4665115744,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Double Normalized Value-based & Column-based
    //---------------------------------------------------------------------------
    //    FILENAME    module_1        module_2        module_3        module_4        module_5        module_6
    //    BUG                            0.0000000000     0.9750000000     0.0000000000                     1.0000000000
    //    LOC            0.7293447293     0.0000000000     1.0000000000     0.5076923077     0.9423076923     1.0000000000
    //    N_COMM        0.7619047619                     0.0000000000     0.5428571429     1.0000000000     1.0000000000
    //    HALVOL        0.1975308642     0.0000000000                     0.2000000000     0.0000000000     1.0000000000
    //    SCPMN        1.0000000000     1.0000000000     0.8125000000                     0.0000000000     1.0000000000
    //    N_VEXUSE    0.0000000000     0.3200000000     0.0000000000     1.0000000000                     0.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9750000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7293447293,    this->DataSet->PredictionTable->Cells["LOC"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5076923077,    this->DataSet->PredictionTable->Cells["LOC"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9423076923,    this->DataSet->PredictionTable->Cells["LOC"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7619047619,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_1"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5428571429,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.1975308642,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_2"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8125000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_3"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3200000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_6"]->Value, 1E-6);
    }

    //    Average of Column        0.5377560711     0.2640000000     0.5575000000     0.4501098901     0.4855769231     0.8333333333
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5377560711,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2640000000,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5575000000,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4501098901,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4855769231,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8333333333,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.7293447293     0.0000000000     0.8125000000     0.5076923077     0.4711538462     1.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7293447293,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8125000000,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5076923077,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4711538462,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.4937500000
    //    0.6965574549
    //    0.6609523810
    //    0.2795061728
    //    0.7625000000
    //    0.2640000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4937500000,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6965574549,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6609523810,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2795061728,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7625000000,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2640000000,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.4875000000
    //    0.8358262108
    //    0.7619047619
    //    0.1975308642
    //    1.0000000000
    //    0.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4875000000,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8358262108,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7619047619,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1975308642,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    0.6583333333
    //    0.5000000000
    //    0.5000000000
    //    0.7333333333
    //    0.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6583333333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7333333333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    0.9750000000
    //    0.5000000000
    //    0.5000000000
    //    1.0000000000
    //    0.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9750000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    0.7944137118
    //    0.6059656689
    //    0.6059656689
    //    0.6522215708
    //    0.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7944137118,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6059656689,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6059656689,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6522215708,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Double Order-based & Row-based
    //---------------------------------------------------------------------------
    //    FILENAME    BUG                LOC                N_COMM            HALVOL            SCPMN            N_VEXUSE
    //    module_1                    1.0000000000     0.5000000000     0.5000000000     0.5000000000     0.0000000000
    //    module_2    0.1250000000     0.1250000000                     0.5000000000     1.0000000000     0.7500000000
    //    module_3    1.0000000000     0.5000000000     0.1250000000                     0.7500000000     0.1250000000
    //    module_4    0.2500000000     0.7500000000     0.2500000000     0.2500000000                     1.0000000000
    //    module_5                    1.0000000000     0.6666666667     0.3333333333     0.0000000000
    //    module_6    0.6000000000     0.6000000000     0.6000000000     0.6000000000     0.6000000000     0.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_1"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["module_1"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["module_1"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["module_1"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_1"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->Cells["module_2"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->Cells["module_2"]["LOC"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["module_2"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["module_2"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["module_3"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->Cells["module_3"]["N_COMM"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["module_3"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->Cells["module_3"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["module_4"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["module_4"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["module_4"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["module_4"]["HALVOL"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_4"]["N_VEXUSE"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["module_5"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6666666667,    this->DataSet->PredictionTable->Cells["module_5"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3333333333,    this->DataSet->PredictionTable->Cells["module_5"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_5"]["SCPMN"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["module_6"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["module_6"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["module_6"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["module_6"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["module_6"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["N_VEXUSE"]->Value, 1E-6);
    }

    //    Average of Column        0.4937500000     0.6625000000     0.4283333333     0.4366666667     0.5700000000     0.3750000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4937500000,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6625000000,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4283333333,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4366666667,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5700000000,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.4250000000     0.6750000000     0.5000000000     0.5000000000     0.6000000000     0.1250000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4250000000,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6750000000,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.2500000000
    //    0.5000000000
    //    0.6000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    2.3750000000
    //    1.6666666667
    //    1.3333333333
    //    1.0833333333
    //    1.0416666667
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.3750000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6666666667,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3333333333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0833333333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0416666667,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    0.7500000000
    //    1.3333333333
    //    1.6666666667
    //    1.0000000000
    //    0.8333333333
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3333333333,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6666666667,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8333333333,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    3.0346316331
    //    2.0147338801
    //    1.5745305997
    //    1.1328656257
    //    1.0701458467
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.0346316331,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0147338801,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5745305997,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1328656257,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0701458467,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Double Order-based & Column-based
    //---------------------------------------------------------------------------
    //    FILENAME    module_1        module_2        module_3        module_4        module_5        module_6
    //    BUG                            0.1250000000     1.0000000000     0.2500000000                     0.6000000000
    //    LOC            1.0000000000     0.1250000000     0.5000000000     0.7500000000     1.0000000000     0.6000000000
    //    N_COMM        0.5000000000                     0.1250000000     0.2500000000     0.6666666667     0.6000000000
    //    HALVOL        0.5000000000     0.5000000000                     0.2500000000     0.3333333333     0.6000000000
    //    SCPMN        0.5000000000     1.0000000000     0.7500000000                     0.0000000000     0.6000000000
    //    N_VEXUSE    0.0000000000     0.7500000000     0.1250000000     1.0000000000                     0.0000000000
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);

        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["BUG"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["LOC"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_1"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6666666667,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["N_COMM"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_2"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3333333333,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["HALVOL"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_3"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["SCPMN"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["N_VEXUSE"]["module_6"]->Value, 1E-6);
    }

    //    Average of Column        0.5000000000     0.5000000000     0.5000000000     0.5000000000     0.5000000000     0.5000000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.5000000000     0.5000000000     0.5000000000     0.2500000000     0.5000000000     0.6000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.4937500000
    //    0.6625000000
    //    0.4283333333
    //    0.4366666667
    //    0.5700000000
    //    0.3750000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4937500000,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6625000000,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4283333333,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4366666667,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5700000000,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.4250000000
    //    0.6750000000
    //    0.5000000000
    //    0.5000000000
    //    0.6000000000
    //    0.1250000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4250000000,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6750000000,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    1.0833333333
    //    3.3333333333
    //    0.7500000000
    //    0.8194444444
    //    2.8055555556
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.0833333333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.3333333333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8194444444,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8055555556,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    0.2500000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    1.0451324304
    //    2.0464656407
    //    0.9410327076
    //    0.9851546201
    //    3.3341189209
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.0451324304,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0464656407,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9410327076,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9851546201,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.3341189209,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Double Standardized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    0.1932599017
    //    0.5206404284
    //    -0.8899375377
    //    -0.2454869582
    //    0.4257212724
    virtual void Test_TCFbECosineSimilarity_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.1932599017,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5206404284,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8899375377,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2454869582,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4257212724,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.0499114210
    //    0.1492266287
    //    -0.9201920873
    //    -0.2185745151
    //    0.1593138899
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.0499114210,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1492266287,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9201920873,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2185745151,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1593138899,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.1109068808
    //    -0.2149471450
    //    -0.9514100052
    //    -0.4216921247
    //    -0.0741944003
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1109068808,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2149471450,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9514100052,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4216921247,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.0741944003,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.1932599017
    //    0.5206404284
    //    -0.8899375377
    //    -0.2454869582
    //    0.4257212724
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.1932599017,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5206404284,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8899375377,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2454869582,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4257212724,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.1612725498
    //    0.4574269066
    //    -0.8919718972
    //    -0.3464579202
    //    0.4568398976
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.1612725498,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4574269066,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8919718972,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3464579202,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4568398976,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    0.2000000000
    //    0.6000000000
    //    -0.2000000000
    //    -0.2000000000
    //    0.3000000000
    virtual void Test_TCFbERankCorrelation_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.8742843774
    //    1.1640562083
    //    0.8185961160
    //    0.9657783334
    //    1.1299672374
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8742843774,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1640562083,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8185961160,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9657783334,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1299672374,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    0.7918043605
    //    1.1362012686
    //    1.9858573622
    //    1.4913114679
    //    1.2078365872
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7918043605,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1362012686,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.9858573622,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4913114679,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2078365872,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    8.2170920308
    //    8.2803554433
    //    7.7941408476
    //    8.2170920308
    //    8.2365264149
    //    8.1663479840
    //    7.7023118050
    //    7.4279262203
    virtual void Test_TCFbEWeightedSum_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2170920308,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2803554433,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7941408476,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2170920308,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2365264149,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1663479840,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7023118050,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4279262203,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    8.4191244459
    //    8.6299234367
    //    8.2548886162
    //    8.4191244459
    //    8.4454065731
    //    8.2372322561
    //    7.7023118050
    //    7.4279262203
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4191244459,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6299234367,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2548886162,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4191244459,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4454065731,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2372322561,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7023118050,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4279262203,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    8.5229544942
    //    8.8095761011
    //    8.4916796434
    //    8.5229544942
    //    8.5527558661
    //    8.2736616449
    //    7.7023118050
    //    7.4279262203
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5229544942,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.8095761011,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4916796434,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5229544942,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5527558661,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2736616449,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7023118050,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4279262203,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    8.4191244459
    //    8.6299234367
    //    8.2548886162
    //    8.4191244459
    //    8.4454065731
    //    8.2372322561
    //    7.7023118050
    //    7.4279262203
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4191244459,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6299234367,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2548886162,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4191244459,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4454065731,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2372322561,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7023118050,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4279262203,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    8.5229544942
    //    8.8095761011
    //    8.4916796434
    //    8.5229544942
    //    8.5527558661
    //    8.2736616449
    //    7.7023118050
    //    7.4279262203
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5229544942,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.8095761011,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4916796434,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5229544942,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5527558661,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2736616449,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7023118050,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4279262203,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    8.2170920308
    //    8.2803554433
    //    7.7941408476
    //    8.2170920308
    //    8.2365264149
    //    8.1663479840
    //    7.7023118050
    //    7.4279262203
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2170920308,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2803554433,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7941408476,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2170920308,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2365264149,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1663479840,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7023118050,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4279262203,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    8.1533651339
    //    8.1742116064
    //    7.7518811978
    //    8.1533651339
    //    8.1776151984
    //    8.1042841306
    //    7.7800933255
    //    7.5458514843
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1533651339,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1742116064,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7518811978,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1533651339,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1776151984,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1042841306,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7800933255,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5458514843,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    18.9903363563
    //    25.8588891241
    //    24.8037252254
    //    18.9903363563
    //    19.3724567949
    //    12.1272773652
    //    2.8236029162
    //    -1.8790833436
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(18.9903363563,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(25.8588891241,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(24.8037252254,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(18.9903363563,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(19.3724567949,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(12.1272773652,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.8236029162,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-1.8790833436,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    8.3414714359
    //    8.1734436703
    //    7.4307784368
    //    8.3414714359
    //    8.3435807148
    //    8.5441908418
    //    8.0898820376
    //    7.7996871065
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3414714359,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1734436703,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4307784368,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3414714359,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3435807148,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5441908418,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0898820376,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7996871065,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    8.5867648938
    //    8.8839513233
    //    8.2904744027
    //    8.5867648938
    //    8.5973037207
    //    8.4253136754
    //    7.4943289994
    //    7.0904974666
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5867648938,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.8839513233,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2904744027,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5867648938,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5973037207,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4253136754,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4943289994,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0904974666,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Double Standardized Value-based & Column-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    0.4963217722
    //    -0.7104766373
    //    0.9635129613
    //    -0.2550098976
    //    -0.9344790585
    virtual void Test_TCFbECosineSimilarity_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4963217722,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7104766373,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9635129613,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2550098976,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9344790585,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.4963217722
    //    -0.7104766373
    //    0.9635129613
    //    -0.2550098976
    //    -0.9344790585
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4963217722,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7104766373,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9635129613,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2550098976,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9344790585,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    0.3091825308
    //    -0.6473406117
    //    0.9259045525
    //    -0.2578548838
    //    -0.9039397721
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.3091825308,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6473406117,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9259045525,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2578548838,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9039397721,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.5116470755
    //    -0.6595781419
    //    0.8090325465
    //    -0.6615834047
    //    -0.9202532603
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5116470755,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6595781419,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8090325465,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6615834047,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9202532603,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.5247894594
    //    -0.5554562978
    //    0.5965897565
    //    -0.8111555078
    //    -0.8835925625
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5247894594,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5554562978,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5965897565,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8111555078,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8835925625,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    0.6000000000
    //    -0.5000000000
    //    1.0000000000
    //    -1.0000000000
    //    -1.0000000000
    virtual void Test_TCFbERankCorrelation_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.0000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.0000000000,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    1.0079718684
    //    0.5055264029
    //    2.1062805722
    //    0.5955939711
    //    0.4703609085
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.0079718684,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5055264029,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1062805722,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5955939711,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4703609085,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    0.9715297542
    //    0.4518165763
    //    2.0351942487
    //    0.5016223971
    //    0.4049564801
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9715297542,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4518165763,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0351942487,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5016223971,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4049564801,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    7.6915309346
    //    7.6915309346
    //    7.6829343884
    //    7.5697589978
    //    7.5382616827
    //    7.4997601307
    //    7.3858690634
    //    7.3871093944
    virtual void Test_TCFbEWeightedSum_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6915309346,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6915309346,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6829343884,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5697589978,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5382616827,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4997601307,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3858690634,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3871093944,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    7.6915309346
    //    7.6915309346
    //    7.6829343884
    //    7.5697589978
    //    7.5382616827
    //    7.4997601307
    //    7.3858690634
    //    7.3871093944
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6915309346,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6915309346,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6829343884,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5697589978,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5382616827,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4997601307,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3858690634,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3871093944,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    7.7612263628
    //    7.7612263628
    //    7.7561774841
    //    7.6473102529
    //    7.6205162562
    //    7.5749099904
    //    7.3858690634
    //    7.3871093944
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7612263628,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7612263628,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7561774841,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6473102529,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6205162562,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5749099904,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3858690634,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3871093944,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    7.6915309346
    //    7.6915309346
    //    7.6829343884
    //    7.5697589978
    //    7.5382616827
    //    7.4997601307
    //    7.3858690634
    //    7.3871093944
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6915309346,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6915309346,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6829343884,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5697589978,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5382616827,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4997601307,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3858690634,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3871093944,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    7.7612263628
    //    7.7612263628
    //    7.7561774841
    //    7.6473102529
    //    7.6205162562
    //    7.5749099904
    //    7.3858690634
    //    7.3871093944
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7612263628,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7612263628,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7561774841,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6473102529,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6205162562,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5749099904,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3858690634,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3871093944,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.8006730481
    //    7.8006730481
    //    7.7967703213
    //    7.7134392780
    //    7.6929197175
    //    7.6770918737
    //    7.6397601962
    //    7.6404738751
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8006730481,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8006730481,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7967703213,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7134392780,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6929197175,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6770918737,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6397601962,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6404738751,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    7.8585965286
    //    7.8585965286
    //    7.8595398797
    //    7.7793468268
    //    7.7538379593
    //    7.7508588064
    //    7.7866672714
    //    7.7869217361
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8585965286,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8585965286,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8595398797,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7793468268,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7538379593,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7508588064,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7866672714,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7869217361,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    11.5013886444
    //    11.5013886444
    //    10.3256488664
    //    11.1660447765
    //    11.3966620514
    //    11.1025212769
    //    12.8456605028
    //    13.0268687749
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(11.5013886444,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(11.5013886444,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(10.3256488664,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(11.1660447765,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(11.3966620514,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(11.1025212769,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(12.8456605028,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(13.0268687749,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    7.8999791071
    //    7.8999791071
    //    7.8122011869
    //    7.5914921913
    //    7.4975572332
    //    7.4272025997
    //    7.8494784409
    //    7.8448080172
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8999791071,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8999791071,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8122011869,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5914921913,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4975572332,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4272025997,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8494784409,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8448080172,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    8.6240908572
    //    8.6240908572
    //    8.3960844445
    //    8.3665425315
    //    8.3537030001
    //    8.2426930573
    //    8.4346403311
    //    8.4685108189
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6240908572,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6240908572,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3960844445,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3665425315,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3537030001,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2426930573,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4346403311,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4685108189,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Double Standardized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    0.7598844079
    //    0.8233295438
    //    0.6080663560
    //    0.7190492451
    //    0.9165551194
    virtual void Test_TCFbECosineSimilarity_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7598844079,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8233295438,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6080663560,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7190492451,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9165551194,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.1443845209
    //    0.0862862329
    //    -0.8994653997
    //    -0.4650423583
    //    0.3173740862
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.1443845209,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0862862329,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8994653997,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4650423583,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3173740862,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    0.9119481898
    //    -0.2048003561
    //    0.3052362424
    //    -0.1012024983
    //    -0.1924676521
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9119481898,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2048003561,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3052362424,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1012024983,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1924676521,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.5217016230
    //    0.5232452951
    //    -0.4152703551
    //    0.2288910488
    //    0.7133008256
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5217016230,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5232452951,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4152703551,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2288910488,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7133008256,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.0376633264
    //    0.6245229727
    //    -0.3698247162
    //    0.2413616015
    //    0.7735019523
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0376633264,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6245229727,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3698247162,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2413616015,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7735019523,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    0.3162277660
    //    0.2108185107
    //    -0.2000000000
    //    0.1054092553
    //    0.7071067812
    virtual void Test_TCFbERankCorrelation_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.3162277660,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2108185107,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1054092553,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7071067812,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    3.2080185230
    //    3.2785271980
    //    2.7716778221
    //    2.4263171971
    //    3.8132436627
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.2080185230,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.2785271980,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.7716778221,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.4263171971,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8132436627,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    3.8645038168
    //    4.3653322969
    //    4.5382342076
    //    4.4340175953
    //    4.2000000000
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.8645038168,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.3653322969,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.5382342076,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.4340175953,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.2000000000,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    8.2936807162
    //    7.5489125197
    //    6.1441741783
    //    8.3198196281
    //    8.8672861751
    //    8.5182043611
    //    8.2479232086
    //    8.1455706418
    virtual void Test_TCFbEWeightedSum_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2936807162,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5489125197,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.1441741783,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3198196281,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.8672861751,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5182043611,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2479232086,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1455706418,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    8.2936807162
    //    9.2056881032
    //    6.8002578142
    //    8.8292308839
    //    9.4134163703
    //    8.8900265994
    //    8.2479232086
    //    8.1455706418
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2936807162,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.2056881032,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8002578142,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.8292308839,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.4134163703,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.8900265994,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2479232086,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1455706418,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    8.2936807162
    //    9.1847162603
    //    6.7919529580
    //    8.8227826402
    //    9.4065033299
    //    8.8853199888
    //    8.2479232086
    //    8.1455706418
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2936807162,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.1847162603,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7919529580,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.8227826402,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.4065033299,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.8853199888,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2479232086,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1455706418,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    8.2936807162
    //    9.2056881032
    //    6.8002578142
    //    8.8292308839
    //    9.4134163703
    //    8.8900265994
    //    8.2479232086
    //    8.1455706418
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2936807162,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.2056881032,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8002578142,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.8292308839,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.4134163703,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.8900265994,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2479232086,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1455706418,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    8.2936807162
    //    9.1847162603
    //    6.7919529580
    //    8.8227826402
    //    9.4065033299
    //    8.8853199888
    //    8.2479232086
    //    8.1455706418
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2936807162,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.1847162603,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7919529580,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.8227826402,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.4065033299,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.8853199888,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2479232086,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1455706418,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    8.2712221388
    //    9.1018728878
    //    7.4228919383
    //    8.7320944708
    //    9.0687008200
    //    8.6518257722
    //    8.2333201395
    //    8.1659505555
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2712221388,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.1018728878,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4228919383,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7320944708,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.0687008200,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6518257722,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2333201395,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1659505555,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    8.6172655752
    //    9.6471641640
    //    8.4544091042
    //    9.1367518398
    //    9.2017692278
    //    9.0248872110
    //    8.5886177722
    //    8.5154846339
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6172655752,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.6471641640,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4544091042,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.1367518398,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.2017692278,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(9.0248872110,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5886177722,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5154846339,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    8.0187487744
    //    7.3517261120
    //    6.2563484279
    //    8.0167193845
    //    8.4699512550
    //    8.0741030343
    //    7.9765594342
    //    7.9129874686
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0187487744,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3517261120,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.2563484279,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0167193845,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4699512550,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0741030343,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9765594342,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9129874686,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    8.0772191437
    //    7.3951956556
    //    6.2327127668
    //    8.0817839791
    //    8.5548880882
    //    8.1718548339
    //    8.0343963974
    //    7.9620615408
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0772191437,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3951956556,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.2327127668,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0817839791,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5548880882,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1718548339,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0343963974,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9620615408,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    7.7552233059
    //    7.2075201502
    //    6.3703156968
    //    7.7438282955
    //    8.1018022166
    //    7.7449449109
    //    7.7201188330
    //    7.6786633792
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7552233059,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2075201502,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3703156968,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7438282955,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1018022166,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7449449109,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7201188330,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6786633792,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Double Normalized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    0.9411137945
    //    0.6292591798
    //    0.9805806757
    //    0.7867612789
    //    0.0000000000
    virtual void Test_TCFbECosineSimilarity_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9411137945,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6292591798,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9805806757,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7867612789,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.6832850680
    //    -0.6582250854
    //    0.9585437448
    //    -0.1446398884
    //    -0.8039387810
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.6832850680,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6582250854,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9585437448,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1446398884,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8039387810,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    0.3048411761
    //    -0.3457373375
    //    1.0000000000
    //    0.0000000000
    //    -0.5060611751
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.3048411761,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3457373375,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5060611751,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.8885031749
    //    -0.1369785864
    //    0.8089144409
    //    0.0930609402
    //    -0.7977654203
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8885031749,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1369785864,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8089144409,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0930609402,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7977654203,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.7986183639
    //    -0.2005669430
    //    0.7132377475
    //    -0.5674866303
    //    -0.6204938606
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7986183639,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2005669430,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7132377475,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5674866303,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6204938606,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    0.8888888889
    //    0.5000000000
    //    0.8660254038
    //    0.0000000000
    //    -0.8888888889
    virtual void Test_TCFbERankCorrelation_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8888888889,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8660254038,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8888888889,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    7.5090252708
    //    1.9764705882
    //    15.0000000000
    //    2.5806451613
    //    1.2139605463
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5090252708,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.9764705882,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(15.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5806451613,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2139605463,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    80.0000000000
    //    1.8421052632
    //    0.0000000000
    //    6.1538461538
    //    1.0126582278
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(80.0000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8421052632,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.1538461538,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0126582278,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    8.5362112120
    //    6.8345310147
    //    6.9958625100
    //    7.5891351235
    //    6.8028439368
    //    7.8308784638
    //    7.9959160691
    //    8.7991697494
    virtual void Test_TCFbEWeightedSum_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5362112120,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8345310147,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9958625100,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5891351235,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8028439368,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8308784638,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9959160691,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7991697494,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    8.5362112120
    //    8.2708183337
    //    8.1427963484
    //    8.5851591054
    //    8.1930570313
    //    8.6519314980
    //    7.9959160691
    //    8.7991697494
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5362112120,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2708183337,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1427963484,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5851591054,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1930570313,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6519314980,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9959160691,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7991697494,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    8.5362112120
    //    8.7825305673
    //    8.5514193785
    //    8.9400168347
    //    8.6883542037
    //    8.9444515785
    //    7.9959160691
    //    8.7991697494
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5362112120,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7825305673,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5514193785,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.9400168347,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6883542037,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.9444515785,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9959160691,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7991697494,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    8.5362112120
    //    8.2708183337
    //    8.1427963484
    //    8.5851591054
    //    8.1930570313
    //    8.6519314980
    //    7.9959160691
    //    8.7991697494
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5362112120,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2708183337,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1427963484,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5851591054,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1930570313,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6519314980,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9959160691,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7991697494,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    8.5362112120
    //    8.7825305673
    //    8.5514193785
    //    8.9400168347
    //    8.6883542037
    //    8.9444515785
    //    7.9959160691
    //    8.7991697494
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5362112120,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7825305673,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.5514193785,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.9400168347,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.6883542037,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.9444515785,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9959160691,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7991697494,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    8.2956033026
    //    8.1790564638
    //    8.1665729668
    //    8.3131476010
    //    8.1112498779
    //    8.3420741122
    //    8.0862014882
    //    8.2545569339
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2956033026,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1790564638,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1665729668,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3131476010,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1112498779,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3420741122,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0862014882,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2545569339,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    8.0351854928
    //    8.0557801091
    //    8.0756118542
    //    8.0225164950
    //    8.0370876434
    //    8.0349613376
    //    8.0399120576
    //    7.8578480309
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0351854928,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0557801091,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0756118542,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0225164950,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0370876434,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0349613376,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.0399120576,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8578480309,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    7.9045230585
    //    6.8547956521
    //    6.9420034827
    //    7.3177351630
    //    6.7640094273
    //    7.4035971035
    //    7.5382362444
    //    8.1233795383
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9045230585,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8547956521,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9420034827,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3177351630,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7640094273,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4035971035,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5382362444,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1233795383,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    8.2500699536
    //    6.9538985312
    //    7.0301479381
    //    7.5456304375
    //    6.7948395672
    //    7.5799128466
    //    7.7695160241
    //    8.7336345343
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.2500699536,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9538985312,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0301479381,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5456304375,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7948395672,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5799128466,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7695160241,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.7336345343,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    7.9861595001
    //    6.8934170477
    //    6.9711406415
    //    7.4034423937
    //    6.8794681957
    //    7.5296022949
    //    7.6346158316
    //    8.3536015870
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9861595001,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8934170477,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9711406415,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4034423937,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8794681957,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5296022949,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6346158316,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.3536015870,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    /////////
    //---------------------------------------------------------------------------
    // Double Order-based & Row-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    0.5283959493
    //    0.8333333333
    //    0.6285393611
    //    0.9091372901
    //    0.9449111825
    virtual void Test_TCFbECosineSimilarity_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.5283959493,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8333333333,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6285393611,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9091372901,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9449111825,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.8624555639
    //    0.0192257865
    //    -0.6553164674
    //    0.6456916642
    //    0.6020238853
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8624555639,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0192257865,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6553164674,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6456916642,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6020238853,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.8871920399
    //    -0.4507205360
    //    -0.2578478222
    //    0.6746925523
    //    -0.1189176780
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8871920399,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4507205360,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2578478222,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6746925523,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1189176780,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    -0.6565321643
    //    0.4522670169
    //    -0.2672612419
    //    0.6708203932
    //    0.7878385972
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6565321643,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4522670169,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2672612419,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6708203932,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7878385972,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    -0.6565321643
    //    0.4522670169
    //    -0.1961161351
    //    0.6708203932
    //    0.7071067812
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6565321643,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4522670169,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1961161351,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6708203932,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7071067812,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    -0.6324555320
    //    0.5000000000
    //    -0.3333333333
    //    0.7745966692
    //    0.7905694150
    virtual void Test_TCFbERankCorrelation_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6324555320,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3333333333,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7745966692,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7905694150,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    1.8823529412
    //    3.2000000000
    //    2.2857142857
    //    4.8000000000
    //    7.1428571429
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.8823529412,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.2000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.2857142857,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.8000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.1428571429,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    1.6000000000
    //    3.2000000000
    //    4.0000000000
    //    6.0000000000
    //    10.0000000000
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.6000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.2000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.0000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0000000000,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    7.5531055925
    //    5.2543313497
    //    3.7797731020
    //    6.7932637727
    //    6.8524536390
    //    6.7992518769
    //    7.5714616632
    //    7.5531914894
    virtual void Test_TCFbEWeightedSum_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531055925,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.2543313497,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.7797731020,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7932637727,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8524536390,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7992518769,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5714616632,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531914894,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    7.5531055925
    //    7.7515603670
    //    7.5807577007
    //    7.7802278743
    //    7.7889703244
    //    7.7825299262
    //    7.5714616632
    //    7.5531914894
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531055925,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7515603670,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5807577007,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7802278743,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7889703244,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7825299262,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5714616632,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531914894,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    7.5531055925
    //    7.6539953662
    //    7.2162885033
    //    7.7215275412
    //    7.7307010135
    //    7.7236758116
    //    7.5714616632
    //    7.5531914894
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531055925,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6539953662,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2162885033,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7215275412,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7307010135,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7236758116,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5714616632,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531914894,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    7.5531055925
    //    7.7515603670
    //    7.5807577007
    //    7.7802278743
    //    7.7889703244
    //    7.7825299262
    //    7.5714616632
    //    7.5531914894
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531055925,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7515603670,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5807577007,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7802278743,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7889703244,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7825299262,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5714616632,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531914894,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    7.5531055925
    //    7.6539953662
    //    7.2162885033
    //    7.7215275412
    //    7.7307010135
    //    7.7236758116
    //    7.5714616632
    //    7.5531914894
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531055925,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6539953662,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2162885033,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7215275412,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7307010135,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7236758116,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5714616632,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531914894,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.5531055925
    //    7.7604299126
    //    7.5932577007
    //    7.7855642682
    //    7.7942675345
    //    7.7878803003
    //    7.5714616632
    //    7.5531914894
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531055925,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7604299126,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5932577007,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7855642682,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7942675345,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7878803003,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5714616632,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531914894,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    7.5744479721
    //    7.6556944136
    //    7.5625987749
    //    7.7182787023
    //    7.7347554088
    //    7.7159102252
    //    7.5616168636
    //    7.5531914894
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5744479721,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6556944136,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5625987749,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7182787023,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7347554088,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7159102252,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5616168636,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5531914894,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    7.7992147618
    //    4.9071925095
    //    2.9444674730
    //    7.2232609026
    //    7.3246267263
    //    7.2792653974
    //    7.7662053123
    //    7.7123226950
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7992147618,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9071925095,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.9444674730,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2232609026,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3246267263,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.2792653974,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7662053123,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7123226950,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    7.6456146932
    //    4.9617711978
    //    3.5110375904
    //    6.9040473673
    //    7.0211287293
    //    6.9140793966
    //    7.6179445603
    //    7.5895390071
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6456146932,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9617711978,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.5110375904,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9040473673,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0211287293,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9140793966,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6179445603,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5895390071,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    7.9312921952
    //    4.7758487471
    //    2.5112428512
    //    7.4557860215
    //    7.5163873403
    //    7.5069505658
    //    7.8715675294
    //    7.8005042778
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleOrder_abRow() {
        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9312921952,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.7758487471,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.5112428512,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4557860215,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5163873403,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5069505658,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8715675294,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8005042778,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    ////////
    //---------------------------------------------------------------------------
    // Double Order-based & Column-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    0.8133078158
    //    0.6935199655
    //    0.8935041554
    //    0.7594230128
    //    0.3111517607
    virtual void Test_TCFbECosineSimilarity_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8133078158,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6935199655,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8935041554,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7594230128,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3111517607,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.2804999700
    //    -0.4386476254
    //    0.5832460485
    //    -0.1460580239
    //    -0.7995350276
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.2804999700,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4386476254,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5832460485,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1460580239,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7995350276, this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    0.3600000000
    //    -1.0000000000
    //    0.0000000000
    //    -0.1788854382
    //    -0.4241462667
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.3600000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.0000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1788854382,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4241462667,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.2261318465
    //    -0.4102822279
    //    0.3394040874
    //    -0.2165182762
    //    -0.7838105698
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.2261318465,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4102822279,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3394040874,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2165182762,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7838105698,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.0935894395
    //    -0.5341779946
    //    0.5849104736
    //    -0.1176071526
    //    -0.4823920796
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0935894395,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5341779946,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5849104736,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1176071526,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4823920796,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    0.2000000000
    //    -0.5000000000
    //    0.5000000000
    //    -0.5000000000
    //    -0.6000000000
    virtual void Test_TCFbERankCorrelation_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6000000000,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    4.0000000000
    //    3.4285714286
    //    8.0000000000
    //    2.6666666667
    //    1.4035087719
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4285714286,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(8.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6666666667,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4035087719,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    4.0000000000
    //    0.0000000000
    //    0.0000000000
    //    4.0000000000
    //    1.4545454545
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4545454545,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    7.5723378784
    //    5.6222682950
    //    4.6493545389
    //    5.2085716241
    //    5.1659206194
    //    4.9347826087
    //    7.5665809769
    //    7.6346153846
    virtual void Test_TCFbEWeightedSum_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5723378784,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6222682950,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.6493545389,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.2085716241,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.1659206194,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9347826087,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5665809769,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6346153846,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    7.5723378784
    //    7.7402227290
    //    7.6997283754
    //    7.7555332200
    //    7.6588759262
    //    7.6739130435
    //    7.5665809769
    //    7.6346153846
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5723378784,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7402227290,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6997283754,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7555332200,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6588759262,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6739130435,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5665809769,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6346153846,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    7.5723378784
    //    7.7402227290
    //    7.6997283754
    //    7.7555332200
    //    7.6588759262
    //    7.6739130435
    //    7.5665809769
    //    7.6346153846
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5723378784,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7402227290,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6997283754,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7555332200,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6588759262,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6739130435,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5665809769,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6346153846,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    7.5723378784
    //    7.7402227290
    //    7.6997283754
    //    7.7555332200
    //    7.6588759262
    //    7.6739130435
    //    7.5665809769
    //    7.6346153846
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5723378784,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7402227290,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6997283754,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7555332200,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6588759262,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6739130435,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5665809769,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6346153846,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    7.5723378784
    //    7.7402227290
    //    7.6997283754
    //    7.7555332200
    //    7.6588759262
    //    7.6739130435
    //    7.5665809769
    //    7.6346153846
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5723378784,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7402227290,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6997283754,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7555332200,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6588759262,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6739130435,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5665809769,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6346153846,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.5545239548
    //    7.6762337046
    //    7.6065399073
    //    7.6847766657
    //    7.6148292232
    //    7.6343297101
    //    7.5650057841
    //    7.5492307692
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5545239548,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6762337046,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6065399073,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6847766657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6148292232,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6343297101,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5650057841,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5492307692,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    7.3403454144
    //    7.5165086248
    //    7.5207227673
    //    7.5227260286
    //    7.4076655967
    //    7.5076086957
    //    7.3449871465
    //    7.5009615385
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3403454144,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5165086248,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5207227673,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5227260286,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.4076655967,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5076086957,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.3449871465,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5009615385,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    7.7730448678
    //    4.6419057657
    //    2.9369258236
    //    4.3923579152
    //    3.9776123048
    //    4.1730072464
    //    7.7251856612
    //    7.6316773504
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7730448678,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.6419057657,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.9369258236,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.3923579152,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.9776123048,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.1730072464,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.7251856612,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6316773504,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    7.5723378784
    //    5.6222682950
    //    4.6493545389
    //    5.2085716241
    //    5.1659206194
    //    4.9347826087
    //    7.5665809769
    //    7.6346153846
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5723378784,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.6222682950,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.6493545389,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.2085716241,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.1659206194,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9347826087,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5665809769,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6346153846,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    7.6782462979
    //    5.1040996020
    //    3.8765845429
    //    4.8019884188
    //    4.6168720331
    //    4.5909299101
    //    7.6547306319
    //    7.6505695056
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleOrder_abColumn() {
        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6782462979,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.1040996020,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.8765845429,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.8019884188,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.6168720331,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.5909299101,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6547306319,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbDoubleOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6505695056,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Value-based & Row-based with Default Value
    //---------------------------------------------------------------------------
    //    FILENAME    BUG                LOC                N_COMM            HALVOL            SCPMN            N_VEXUSE
    //    module_1                    800.0000000000     0.3000000000     3600.0000000000    4.0000000000     0.6000000000
    //    module_2    2.0000000000     250.0000000000     0.0000000000     3200.0000000000 3.5000000000     0.4000000000
    //    module_3    5.0000000000     500.0000000000     0.0000000000     0.0000000000     3.0000000000     0.3000000000
    //    module_4    5.0000000000     700.0000000000     0.2500000000     3500.0000000000 0.0000000000     0.8000000000
    //    module_5    0.0000000000     600.0000000000     0.2000000000     3200.0000000000 2.5000000000     0.0000000000
    //    module_6    10.0000000000     900.0000000000     0.3500000000     3800.0000000000 4.1000000000     0.7500000000
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(800.0000000000,    this->DataSet->PredictionTable->Cells["module_1"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->PredictionTable->Cells["module_1"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3600.0000000000,    this->DataSet->PredictionTable->Cells["module_1"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->PredictionTable->Cells["module_1"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->Cells["module_1"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->PredictionTable->Cells["module_2"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->PredictionTable->Cells["module_2"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4000000000,    this->DataSet->PredictionTable->Cells["module_2"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->PredictionTable->Cells["module_3"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->PredictionTable->Cells["module_3"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->PredictionTable->Cells["module_4"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0000000000,    this->DataSet->PredictionTable->Cells["module_4"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->Cells["module_4"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->PredictionTable->Cells["module_4"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_4"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,    this->DataSet->PredictionTable->Cells["module_4"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_5"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600.0000000000,    this->DataSet->PredictionTable->Cells["module_5"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->PredictionTable->Cells["module_5"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->PredictionTable->Cells["module_5"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5000000000,    this->DataSet->PredictionTable->Cells["module_5"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->PredictionTable->Cells["module_5"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(10.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3500000000,    this->DataSet->PredictionTable->Cells["module_6"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0000000000,    this->DataSet->PredictionTable->Cells["module_6"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1000000000,    this->DataSet->PredictionTable->Cells["module_6"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->PredictionTable->Cells["module_6"]["N_VEXUSE"]->Value, 1E-6);
    }

    //    Average of Column        3.6666666667    625.0000000000     0.1833333333     2883.3333333333     2.8500000000     0.4750000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.6666666667,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(625.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1833333333,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2883.3333333333,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8500000000,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4750000000,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        3.5000000000    650.0000000000     0.2250000000     3350.0000000000     3.2500000000     0.5000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(650.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2250000000,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3350.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.2500000000,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    734.1500000000
    //    575.9833333333
    //    84.7166666667
    //    701.0083333333
    //    633.7833333333
    //    785.8666666667
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(734.1500000000,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(575.9833333333,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(84.7166666667,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(701.0083333333,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(633.7833333333,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(785.8666666667,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    2.3000000000
    //    2.7500000000
    //    1.6500000000
    //    2.9000000000
    //    1.3500000000
    //    7.0500000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.3000000000,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.7500000000,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6500000000,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9000000000,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3500000000,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.0500000000,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    1.3935714286
    //    1.2333333333
    //    0.8242857143
    //    1.3895833333
    //    0.7448349872
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.3935714286,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2333333333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8242857143,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3895833333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7448349872,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    1.1428571429
    //    1.4666666667
    //    1.0285714286
    //    1.4166666667
    //    0.8730158730
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.1428571429,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4666666667,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0285714286,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4166666667,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8730158730,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //
    //    1.8491667175
    //    1.6784315185
    //    1.0426767699
    //    1.4030645283
    //    0.8829383287
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.8491667175,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6784315185,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0426767699,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4030645283,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8829383287,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //
    //    0.9901175649
    //    0.2169221429
    //    0.9997721591
    //    0.9994448439
    //    0.9999002840
    virtual void Test_TCFbECosineSimilarity_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9901175649,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2169221429,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997721591,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9994448439,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999002840,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.4455348639
    //    -0.9808083450
    //    0.9929463014
    //    0.9497516455
    //    0.9985833835
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4455348639,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9808083450,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9929463014,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9497516455,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9985833835,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.7827156626
    //    -0.8795878211
    //    0.9756955866
    //    -0.9756061568
    //    0.9991412486
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7827156626,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8795878211,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9756955866,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9756061568,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9991412486,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9892752555
    //    0.0183264173
    //    0.9997389845
    //    0.9993756170
    //    0.9998930931
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9892752555,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0183264173,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997389845,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9993756170,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9998930931,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.9900734509
    //    0.2132266756
    //    0.9997686502
    //    0.9994496009
    //    0.9999122075
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9900734509,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2132266756,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997686502,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9994496009,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999122075,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    0.8285714286
    //    -0.0869656553
    //    0.4857142857
    //    0.8986451053
    //    0.6571428571
    virtual void Test_TCFbERankCorrelation_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8285714286,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.0869656553,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4857142857,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8986451053,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6571428571,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.0062959077
    //    0.0015358624
    //    0.0286738351
    //    0.0099634673
    //    0.0193361263
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0062959077,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0015358624,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0286738351,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0099634673,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0193361263,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    0.8000000000
    //    0.3333333333
    //    0.2222222222
    //    0.9523809524
    //    0.1970443350
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3333333333,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2222222222,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9523809524,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1970443350,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    4.2943498073
    //    2.5042430380
    //    1.9308496653
    //    4.2599132797
    //    4.2937641063
    //    3.4569423780
    //    5.4251270834
    //    2.5342393917
    virtual void Test_TCFbEWeightedSum_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2943498073,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.5042430380,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.9308496653,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2599132797,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2937641063,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.4569423780,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.4251270834,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.5342393917,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    4.2943498073
    //    4.1510408488
    //    6.1245921132
    //    4.2599132797
    //    4.2937641063
    //    3.6726135503
    //    5.4251270834
    //    2.5342393917
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2943498073,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.1510408488,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.1245921132,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2599132797,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2937641063,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.6726135503,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.4251270834,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.5342393917,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    4.2943498073
    //    4.0761864029
    //    5.9339674565
    //    4.2599132797
    //    4.2937641063
    //    3.6628103152
    //    5.4251270834
    //    2.5342393917
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2943498073,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.0761864029,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9339674565,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2599132797,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2937641063,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.6628103152,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.4251270834,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.5342393917,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    4.2943498073
    //    4.4804004110
    //    6.9633406028
    //    4.2599132797
    //    4.2937641063
    //    3.7157477848
    //    5.4251270834
    //    2.5342393917
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2943498073,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.4804004110,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9633406028,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2599132797,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2937641063,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.7157477848,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.4251270834,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.5342393917,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    4.2943498073
    //    4.7498764164
    //    7.6495893670
    //    4.2599132797
    //    4.2937641063
    //    3.7510394311
    //    5.4251270834
    //    2.5342393917
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2943498073,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.7498764164,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.6495893670,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2599132797,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2937641063,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.7510394311,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.4251270834,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.5342393917,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    94.4511411738
    //    220.0613874370
    //    665.5170988436
    //    66.6812802563
    //    93.9576903820
    //    96.3105648765
    //    50.1562683545
    //    176.4967479497
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(94.4511411738,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(220.0613874370,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(665.5170988436,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(66.6812802563,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(93.9576903820,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(96.3105648765,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(50.1562683545,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(176.4967479497,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    3.1758773965
    //    2.3295319316
    //    3.1571711656
    //    3.0536088968
    //    3.1737211519
    //    2.5815779319
    //    3.8839045511
    //    2.4113381113
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.1758773965,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.3295319316,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.1571711656,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.0536088968,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.1737211519,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.5815779319,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.8839045511,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.4113381113,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    3.7243931598
    //    1.5394196088
    //    0.8362800805
    //    3.6035883340
    //    3.7222613688
    //    2.9318261977
    //    4.3950652560
    //    2.6622151715
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.7243931598,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.5394196088,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.8362800805,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.6035883340,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.7222613688,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.9318261977,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.3950652560,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.6622151715,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    4.2140276384
    //    1.7515569909
    //    1.1925974429
    //    4.0598753241
    //    4.2113121422
    //    3.2096461971
    //    5.1960412412
    //    2.8487648348
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2140276384,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.7515569909,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.1925974429,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.0598753241,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.2113121422,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.2096461971,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.1960412412,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.8487648348,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    4.6415121002
    //    1.6966027793
    //    0.7874036776
    //    4.4558699735
    //    4.6382299680
    //    3.6079618521
    //    5.4157931461
    //    3.4548616764
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.6415121002,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.6966027793,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7874036776,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.4558699735,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.6382299680,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.6079618521,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.4157931461,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, true, 0.0, false, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(3.4548616764,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Value-based & Row-based with Case Amplification
    //---------------------------------------------------------------------------
    //    FILENAME    BUG                LOC                N_COMM            HALVOL            SCPMN            N_VEXUSE
    //    module_1                    800.0000000000     0.3000000000     3600.0000000000 4.0000000000     0.6000000000
    //    module_2    2.0000000000     250.0000000000                     3200.0000000000 3.5000000000     0.4000000000
    //    module_3    5.0000000000     500.0000000000     0.0000000000                     3.0000000000     0.3000000000
    //    module_4    5.0000000000     700.0000000000     0.2500000000     3500.0000000000                 0.8000000000
    //    module_5                    600.0000000000     0.2000000000     3200.0000000000 2.5000000000
    //    module_6    10.0000000000     900.0000000000     0.3500000000     3800.0000000000 4.1000000000     0.7500000000
    virtual void Test_TCFbEDataSet_GetAppliedValues_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(800.0000000000,    this->DataSet->Values["module_1"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,        this->DataSet->Values["module_1"]["N_COMM"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3600.0000000000,    this->DataSet->Values["module_1"]["HALVOL"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,        this->DataSet->Values["module_1"]["SCPMN"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,        this->DataSet->Values["module_1"]["N_VEXUSE"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0000000000,        this->DataSet->Values["module_2"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0000000000,    this->DataSet->Values["module_2"]["LOC"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->Values["module_2"]["HALVOL"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,        this->DataSet->Values["module_2"]["SCPMN"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4000000000,        this->DataSet->Values["module_2"]["N_VEXUSE"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,        this->DataSet->Values["module_3"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500.0000000000,    this->DataSet->Values["module_3"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,        this->DataSet->Values["module_3"]["N_COMM"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,        this->DataSet->Values["module_3"]["SCPMN"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,        this->DataSet->Values["module_3"]["N_VEXUSE"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,        this->DataSet->Values["module_4"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0000000000,    this->DataSet->Values["module_4"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,        this->DataSet->Values["module_4"]["N_COMM"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->Values["module_4"]["HALVOL"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,        this->DataSet->Values["module_4"]["N_VEXUSE"], 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(600.0000000000,    this->DataSet->Values["module_5"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,        this->DataSet->Values["module_5"]["N_COMM"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->Values["module_5"]["HALVOL"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5000000000,        this->DataSet->Values["module_5"]["SCPMN"], 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(10.0000000000,    this->DataSet->Values["module_6"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0000000000,    this->DataSet->Values["module_6"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3500000000,        this->DataSet->Values["module_6"]["N_COMM"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0000000000,    this->DataSet->Values["module_6"]["HALVOL"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1000000000,        this->DataSet->Values["module_6"]["SCPMN"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,        this->DataSet->Values["module_6"]["N_VEXUSE"], 1E-6);
    }

    //    Average of Column        3.6666666667    625.0000000000     0.1833333333     2883.3333333333     2.8500000000     0.4750000000
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(625.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2200000000,    this->DataSet->PredictionTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3460.0000000000,    this->DataSet->PredictionTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4200000000,    this->DataSet->PredictionTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5700000000,    this->DataSet->PredictionTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        3.5000000000    650.0000000000     0.2250000000     3350.0000000000     3.2500000000     0.5000000000
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(650.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->PredictionTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->PredictionTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    virtual void Test_TCFbEDataSet_GetAppliedAverageOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(880.9800000000,    this->DataSet->PredictionTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(691.1800000000,    this->DataSet->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(101.6600000000,    this->DataSet->PredictionTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(841.2100000000,    this->DataSet->PredictionTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(950.6750000000,    this->DataSet->PredictionTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(785.8666666667,    this->DataSet->PredictionTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->PredictionTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(301.2500000000,    this->DataSet->PredictionTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.0500000000,    this->DataSet->PredictionTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    virtual void Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(1.7419642857,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6444444444,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0303571429,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3895833333,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8938019846,    this->DataSet->PredictionTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    virtual void Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(1.3214285714,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6000000000,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0857142857,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4166666667,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8888888889,    this->DataSet->PredictionTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    virtual void Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(2.2662592009,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6478601381,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0782647864,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3883713977,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8836798536,    this->DataSet->PredictionTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //
    //    0.9754772089
    //    0.9999985462
    //    0.9994344163
    //    0.9986127205
    //    0.9997589234
    virtual void Test_TCFbECosineSimilarity_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(0.9754772089,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999985462,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9994344163,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9986127205,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997589234,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.9941371678
    //    -0.9999929327
    //    0.9579740344
    //    -0.4049574283
    //    0.9429358631
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9941371678,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999929327,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9579740344,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4049574283,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9429358631,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.9961455490
    //    -0.9999927779
    //    0.6314881696
    //    -0.3868577039
    //    0.9001548324
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9961455490,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999927779,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6314881696,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3868577039,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9001548324,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9731790090
    //    0.0732097882
    //    0.9993284200
    //    0.9714167186
    //    0.9859851625
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(0.9731790090,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0732097882,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9993284200,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9714167186,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9859851625,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.9754154161
    //    0.9999959067
    //    0.9994194322
    //    0.9583410280
    //    0.9997746496
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(0.9754154161,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999959067,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9994194322,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9583410280,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997746496,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    virtual void Test_TCFbERankCorrelation_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.0000011483
    //    0.0000202568
    //    0.0000563922
    //    0.0000036048
    //    0.0000357715
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000011483,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000202568,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000563922,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000036048,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000357715,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    0.0000017623
    //    2.9357333631
    //    0.0000562867
    //    0.0000098149
    //    114.7550621098
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000017623,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9357333631,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000562867,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000098149,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(114.7550621098,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    5.5213925841
    //    1.8564609881
    //    1.4645845937
    //    5.6631220793
    //    5.5214673631
    //    5.5000000000
    //    6.5445496714
    //    9.8752752495
    virtual void Test_TCFbEWeightedSum_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5213925841,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(1.8564609881,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(1.4645845937,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.6631220793,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5214673631,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.5445496714,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(9.8752752495,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    5.5213925841
    //    7.4880927858
    //    7.6887576784
    //    5.6631220793
    //    5.5214673631
    //    5.5000000000
    //    6.5445496714
    //    9.8752752495
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5213925841,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(7.4880927858,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(7.6887576784,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.6631220793,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5214673631,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.5445496714,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(9.8752752495,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    5.5213925841
    //    6.9761262587
    //    7.1229237616
    //    5.6631220793
    //    5.5214673631
    //    5.5000000000
    //    6.5445496714
    //    9.8752752495
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5213925841,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.9761262587,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(7.1229237616,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.6631220793,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5214673631,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.5445496714,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(9.8752752495,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    5.5213925841
    //    7.4880927858
    //    7.6887576784
    //    5.6631220793
    //    5.5214673631
    //    5.5000000000
    //    6.5445496714
    //    9.8752752495
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5213925841,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(7.4880927858,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(7.6887576784,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.6631220793,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5214673631,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.5445496714,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(9.8752752495,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    5.5213925841
    //    6.9761262587
    //    7.1229237616
    //    5.6631220793
    //    5.5214673631
    //    5.5000000000
    //    6.5445496714
    //    9.8752752495
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5213925841,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.9761262587,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(7.1229237616,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.6631220793,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5214673631,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.5445496714,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(9.8752752495,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    282.0984674341
    //    688.2063179686
    //    755.3276653221
    //    129.4506208869
    //    282.0997322253
    //    281.5008333333
    //    197.1741412501
    //    122.0557410763
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(282.0984674341,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(688.2063179686,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(755.3276653221,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(129.4506208869,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(282.0997322253,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(281.5008333333,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(197.1741412501,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(122.0557410763,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    4.8770717813
    //    4.5835320519
    //    4.6093601963
    //    4.5262084112
    //    4.8771195001
    //    4.8625000000
    //    5.2707469092
    //    6.9263012970
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(4.8770717813,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(4.5835320519,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(4.6093601963,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(4.5262084112,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(4.8771195001,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(4.8625000000,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.2707469092,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.9263012970,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    6.4673157995
    //    0.4306988908
    //    -0.1116195296
    //    5.9219250052
    //    6.4673757518
    //    6.4489890886
    //    6.8751593146
    //    8.9201627774
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.4673157995,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(0.4306988908,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1116195296,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.9219250052,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.4673757518,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.4489890886,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.8751593146,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(8.9201627774,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.2622275686
    //    0.7585998125
    //    0.2258763358
    //    5.7218313319
    //    6.2622962203
    //    6.2400793651
    //    6.9489803997
    //    8.8667142979
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.2622275686,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(0.7585998125,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(0.2258763358,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(5.7218313319,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.2622962203,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.2400793651,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.9489803997,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(8.8667142979,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    6.7637328664
    //    0.1930904753
    //    -0.3955021302
    //    6.3049740041
    //    6.7637799514
    //    6.7499853901
    //    6.9758671010
    //    8.8218925700
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.7637328664,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(0.1930904753,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3955021302,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.3049740041,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.7637799514,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.7499853901,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(6.9758671010,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, false, 2.5);
        TEST_ASSERT_EQUALS_DOUBLE(8.8218925700,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //---------------------------------------------------------------------------
    // Value-based & Row-based with Inverse Case Frequency
    //---------------------------------------------------------------------------
    //    ICF Coefficient        0.4054651081     0.0000000000     0.1823215568     0.1823215568     0.1823215568     0.1823215568
    virtual void Test_TCFbEDataSet_GetICFCoefficient_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.4054651081,    this->DataSet->GetICFCoefficient(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetICFCoefficient(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1823215568,    this->DataSet->GetICFCoefficient(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1823215568,    this->DataSet->GetICFCoefficient(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1823215568,    this->DataSet->GetICFCoefficient(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1823215568,    this->DataSet->GetICFCoefficient(5), 1E-6);
    }

    //    FILENAME    BUG                LOC                N_COMM            HALVOL            SCPMN            N_VEXUSE
    //    module_1                    0.0000000000     0.0546964670     656.3576044582     0.7292862272     0.1093929341
    //    module_2    0.8109302162     0.0000000000                     583.4289817407     0.6381254488     0.0729286227
    //    module_3    2.0273255405     0.0000000000     0.0000000000                     0.5469646704     0.0546964670
    //    module_4    2.0273255405     0.0000000000     0.0455803892     638.1254487788                     0.1458572454
    //    module_5                    0.0000000000     0.0364643114     583.4289817407     0.4558038920
    //    module_6    4.0546510811     0.0000000000     0.0638125449     692.8219158170     0.7475183829     0.1367411676
    virtual void Test_TCFbEDataSet_GetSimilarityComputationTableValues_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->SimilarityComputationTable->Cells["module_1"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0546964670,    this->DataSet->SimilarityComputationTable->Cells["module_1"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(656.3576044582,    this->DataSet->SimilarityComputationTable->Cells["module_1"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7292862272,    this->DataSet->SimilarityComputationTable->Cells["module_1"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1093929341,    this->DataSet->SimilarityComputationTable->Cells["module_1"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8109302162,    this->DataSet->SimilarityComputationTable->Cells["module_2"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->SimilarityComputationTable->Cells["module_2"]["LOC"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(583.4289817407,    this->DataSet->SimilarityComputationTable->Cells["module_2"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6381254488,    this->DataSet->SimilarityComputationTable->Cells["module_2"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0729286227,    this->DataSet->SimilarityComputationTable->Cells["module_2"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0273255405,    this->DataSet->SimilarityComputationTable->Cells["module_3"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->SimilarityComputationTable->Cells["module_3"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->SimilarityComputationTable->Cells["module_3"]["N_COMM"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5469646704,    this->DataSet->SimilarityComputationTable->Cells["module_3"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0546964670,    this->DataSet->SimilarityComputationTable->Cells["module_3"]["N_VEXUSE"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0273255405,    this->DataSet->SimilarityComputationTable->Cells["module_4"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->SimilarityComputationTable->Cells["module_4"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0455803892,    this->DataSet->SimilarityComputationTable->Cells["module_4"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(638.1254487788,    this->DataSet->SimilarityComputationTable->Cells["module_4"]["HALVOL"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.1458572454,    this->DataSet->SimilarityComputationTable->Cells["module_4"]["N_VEXUSE"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->SimilarityComputationTable->Cells["module_5"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0364643114,    this->DataSet->SimilarityComputationTable->Cells["module_5"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(583.4289817407,    this->DataSet->SimilarityComputationTable->Cells["module_5"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4558038920,    this->DataSet->SimilarityComputationTable->Cells["module_5"]["SCPMN"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(4.0546510811,    this->DataSet->SimilarityComputationTable->Cells["module_6"]["BUG"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->SimilarityComputationTable->Cells["module_6"]["LOC"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0638125449,    this->DataSet->SimilarityComputationTable->Cells["module_6"]["N_COMM"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(692.8219158170,    this->DataSet->SimilarityComputationTable->Cells["module_6"]["HALVOL"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7475183829,    this->DataSet->SimilarityComputationTable->Cells["module_6"]["SCPMN"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1367411676,    this->DataSet->SimilarityComputationTable->Cells["module_6"]["N_VEXUSE"]->Value, 1E-6);
    }

    //    Average of Column        2.2300580946     0.0000000000     0.0401107425     630.8325865071     0.6235397242     0.1039232874 
    virtual void Test_TCFbEDataSet_GetSimilarityComputationTableAverageOfColumn_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.2300580946,    this->DataSet->SimilarityComputationTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->SimilarityComputationTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0401107425,    this->DataSet->SimilarityComputationTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(630.8325865071,    this->DataSet->SimilarityComputationTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6235397242,    this->DataSet->SimilarityComputationTable->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1039232874,    this->DataSet->SimilarityComputationTable->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        2.0273255405     0.0000000000     0.0455803892     638.1254487788     0.6381254488     0.1093929341 
    virtual void Test_TCFbEDataSet_GetSimilarityComputationTableMedianOfColumn_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.0273255405,    this->DataSet->SimilarityComputationTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->SimilarityComputationTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0455803892,    this->DataSet->SimilarityComputationTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(638.1254487788,    this->DataSet->SimilarityComputationTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6381254488,    this->DataSet->SimilarityComputationTable->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1093929341,    this->DataSet->SimilarityComputationTable->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row            131.4501960173        116.9901932057        0.5257973356        128.0688423908        145.9803124860        116.3041064989        
    virtual void Test_TCFbEDataSet_GetSimilarityComputationTableAverageOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(131.4501960173,    this->DataSet->SimilarityComputationTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(116.9901932057,    this->DataSet->SimilarityComputationTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5257973356,    this->DataSet->SimilarityComputationTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(128.0688423908,    this->DataSet->SimilarityComputationTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(145.9803124860,    this->DataSet->SimilarityComputationTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(116.3041064989,    this->DataSet->SimilarityComputationTable->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row            0.1093929341        0.6381254488        0.0546964670        0.1458572454        0.2461341017        0.4421297752        
    virtual void Test_TCFbEDataSet_GetSimilarityComputationTableMedianOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.1093929341,    this->DataSet->SimilarityComputationTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6381254488,    this->DataSet->SimilarityComputationTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0546964670,    this->DataSet->SimilarityComputationTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1458572454,    this->DataSet->SimilarityComputationTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2461341017,    this->DataSet->SimilarityComputationTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4421297752,    this->DataSet->SimilarityComputationTable->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //    1.2559523810
    //    1.6666666667
    //    0.9928571429
    //    1.4083333333
    //    0.8950302586
    virtual void Test_TCFbEDataSet_GetSimilarityComputationTableAveragedMultiplierOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.2559523810,    this->DataSet->SimilarityComputationTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6666666667,    this->DataSet->SimilarityComputationTable->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9928571429,    this->DataSet->SimilarityComputationTable->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4083333333,    this->DataSet->SimilarityComputationTable->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8950302586,    this->DataSet->SimilarityComputationTable->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //    1.1428571429
    //    1.6666666667
    //    1.0285714286
    //    1.5000000000
    //    0.9022556391
    virtual void Test_TCFbEDataSet_GetSimilarityComputationTableMedianOfMultiplierOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.1428571429,    this->DataSet->SimilarityComputationTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6666666667,    this->DataSet->SimilarityComputationTable->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0285714286,    this->DataSet->SimilarityComputationTable->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5000000000,    this->DataSet->SimilarityComputationTable->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9022556391,    this->DataSet->SimilarityComputationTable->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //    Weighted Multiplier
    //    1.2829455719
    //    1.7195881230
    //    1.0284267581
    //    1.4346175639
    //    0.8803760971
    virtual void Test_TCFbEDataSet_GetSimilarityComputationTableWeightedMultiplierOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.2829455719,    this->DataSet->SimilarityComputationTable->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7195881230,    this->DataSet->SimilarityComputationTable->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0284267581,    this->DataSet->SimilarityComputationTable->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4346175639,    this->DataSet->SimilarityComputationTable->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8803760971,    this->DataSet->SimilarityComputationTable->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //
    //    0.9999999990
    //    0.9960528800
    //    0.9999999980
    //    0.9999999454
    //    0.9999999990
    virtual void Test_TCFbECosineSimilarity_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999999990,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9960528800,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999999980,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999999454,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999999990,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.9999899998
    //    -0.8418935262
    //    0.9999846624
    //    -0.9999996951
    //    0.9999976366
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999899998,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8418935262,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999846624,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999996951,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999976366,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.9999872780
    //    -0.8234091224
    //    0.0000000000
    //    -0.9999985556
    //    0.9999953612
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999872780,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8234091224,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999985556,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999953612,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9999998165
    //    0.8538086960
    //    0.9999995614
    //    0.9933871162
    //    0.9967326199
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999998165,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8538086960,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999995614,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9933871162,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9967326199,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.9999986528
    //    0.9977000728
    //    0.9999999954
    //    0.9999997581
    //    0.9999995574
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999986528,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9977000728,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999999954,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999997581,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999995574,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Rank Correlation
    //
    //    1.0000000000
    //    0.9486832981
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    virtual void Test_TCFbERankCorrelation_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9486832981,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.0547523329
    //    13.7120373694
    //    0.2188454842
    //    0.0546296310
    //    0.1369150012
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.0547523329,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(13.7120373694,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2188454842,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0546296310,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1369150012,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    15.6708998507
    //    18.2827164925
    //    43.8785195820
    //    6.8560186847
    //    54.8481494775
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(15.6708998507,    this->DataSet->Similarities["module_1"]["module_2"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(18.2827164925,    this->DataSet->Similarities["module_1"]["module_3"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(43.8785195820,    this->DataSet->Similarities["module_1"]["module_4"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.8560186847,    this->DataSet->Similarities["module_1"]["module_5"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(54.8481494775,    this->DataSet->Similarities["module_1"]["module_6"], 1E-6);
    }

    //    Simple Weighted Sum
    //    5.5004938773
    //    2.2880684666
    //    1.3752726409
    //    5.5151649619
    //    5.5002883383
    //    5.5064979511
    //    5.0368430631
    //    6.7125984252
    virtual void Test_TCFbEWeightedSum_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5004938773,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(2.2880684666,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.3752726409,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5151649619,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5002883383,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5064979511,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.0368430631,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7125984252,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    5.5004938773
    //    7.5617348853
    //    8.4792674449
    //    5.5151649619
    //    5.5002883383
    //    5.5064979511
    //    5.0368430631
    //    6.7125984252
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5004938773,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5617348853,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4792674449,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5151649619,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5002883383,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5064979511,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.0368430631,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7125984252,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    5.5004938773
    //    7.0823106654
    //    7.8334497355
    //    5.5151649619
    //    5.5002883383
    //    5.5064979511
    //    5.0368430631
    //    6.7125984252
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5004938773,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0823106654,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8334497355,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5151649619,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5002883383,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5064979511,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.0368430631,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7125984252,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    5.5004938773
    //    7.5617348853
    //    8.4792674449
    //    5.5151649619
    //    5.5002883383
    //    5.5064979511
    //    5.0368430631
    //    6.7125984252
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5004938773,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.5617348853,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.4792674449,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5151649619,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5002883383,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5064979511,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.0368430631,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7125984252,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    5.5004938773
    //    7.0823106654
    //    7.8334497355
    //    5.5151649619
    //    5.5002883383
    //    5.5064979511
    //    5.0368430631
    //    6.7125984252
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5004938773,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.0823106654,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.8334497355,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5151649619,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5002883383,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.5064979511,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.0368430631,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7125984252,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    281.0041715277
    //    661.9428161121
    //    878.4649010807
    //    262.5602870122
    //    281.2116050340
    //    274.9662446204
    //    763.9778799236
    //    188.9873228346
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(281.0041715277,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(661.9428161121,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(878.4649010807,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(262.5602870122,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(281.2116050340,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(274.9662446204,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(763.9778799236,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(188.9873228346,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    4.8613764295
    //    4.7200123849
    //    4.9928303347
    //    4.8175420405
    //    4.8618461477
    //    4.8477171613
    //    5.9646483903
    //    5.3179133858
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.8613764295,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.7200123849,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.9928303347,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.8175420405,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.8618461477,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(4.8477171613,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.9646483903,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(5.3179133858,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    6.4472375700
    //    0.9587987182
    //    -0.4661622472
    //    6.3795539671
    //    6.4479696499
    //    6.4259443242
    //    8.1632116079
    //    6.9430618850
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4472375700,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.9587987182,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4661622472,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.3795539671,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4479696499,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.4259443242,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1632116079,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.9430618850,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.2383409959
    //    1.2856714287
    //    -0.1208648580
    //    6.1710140661
    //    6.2390677801
    //    6.2172076086
    //    7.9480009370
    //    6.8843269591
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.2383409959,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(1.2856714287,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1208648580,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.1710140661,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.2390677801,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.2172076086,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.9480009370,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.8843269591,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

    //    Amplified Weighted Sum with Weighted Multiplier
    //    6.7485143126
    //    0.7181229202
    //    -0.8783827237
    //    6.6916708902
    //    6.7491290857
    //    6.7306303941
    //    8.1865895723
    //    7.1066383181
    virtual void Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7485143126,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(0.7181229202,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8783827237,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.6916708902,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7491290857,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(6.7306303941,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(8.1865895723,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithWeightedMultiplier(), 0, false, 0.0, true, 1.0);
        TEST_ASSERT_EQUALS_DOUBLE(7.1066383181,    this->DataSet->PredictedValues["module_1"]["BUG"], 1E-6);
    }

protected:
    TCFbEDataSet* DataSet;

};

//---------------------------------------------------------------------------
#endif
